/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.rmi.RemoteException;
import visad.ContourControl;
import visad.ControlEvent;
import visad.ControlListener;
import visad.ProjectionControl;
import visad.VisADException;
import visad.java3d.LabelTransform;
import visad.java3d.MouseBehaviorJ3D;
import visad.util.Util;

class ProjectionControlListener
implements ControlListener {
    LabelTransform[][][] LT_array = null;
    ProjectionControl p_cntrl = null;
    ContourControl c_cntrl = null;
    double last_scale;
    double first_scale;
    int cnt = 0;
    double last_time;

    ProjectionControlListener(ProjectionControl p_cntrl, ContourControl c_cntrl) {
        this.p_cntrl = p_cntrl;
        this.c_cntrl = c_cntrl;
        double[] matrix = p_cntrl.getMatrix();
        double[] rot_a = new double[3];
        double[] trans_a = new double[3];
        double[] scale_a = new double[1];
        MouseBehaviorJ3D.unmake_matrix(rot_a, scale_a, trans_a, matrix);
        this.first_scale = this.last_scale = scale_a[0];
        this.LT_array = new LabelTransform[1000][][];
        this.last_time = System.currentTimeMillis();
        p_cntrl.addControlListener(this);
        c_cntrl.addProjectionControlListener(this, p_cntrl);
    }

    public synchronized void controlChanged(ControlEvent e) throws VisADException, RemoteException {
        double[] matrix = this.p_cntrl.getMatrix();
        double[] rot_a = new double[3];
        double[] trans_a = new double[3];
        double[] scale_a = new double[1];
        MouseBehaviorJ3D.unmake_matrix(rot_a, scale_a, trans_a, matrix);
        if (!Util.isApproximatelyEqual(scale_a[0], this.last_scale)) {
            double current_time = System.currentTimeMillis();
            if (scale_a[0] / this.last_scale > 1.15 || scale_a[0] / this.last_scale < 0.8695652173913044) {
                if (current_time - this.last_time < 3000.0) {
                    if (this.LT_array != null) {
                        for (int ii = 0; ii < this.cnt; ++ii) {
                            for (int kk = 0; kk < this.LT_array[ii][0].length; ++kk) {
                                for (int jj = 0; jj < this.LT_array[0].length; ++jj) {
                                    if (this.LT_array[ii][jj][kk] == null) continue;
                                    this.LT_array[ii][jj][kk].controlChanged(this.first_scale, scale_a);
                                }
                            }
                        }
                    }
                } else {
                    if (this.LT_array != null) {
                        for (int ii = 0; ii < this.cnt; ++ii) {
                            for (int kk = 0; kk < this.LT_array[ii][0].length; ++kk) {
                                for (int jj = 0; jj < this.LT_array[0].length; ++jj) {
                                    if (this.LT_array[ii][jj][kk] == null) continue;
                                    this.LT_array[ii][jj][kk].controlChanged(this.first_scale, scale_a);
                                }
                            }
                        }
                    }
                    this.c_cntrl.reLabel();
                }
                this.last_scale = scale_a[0];
            }
            this.last_time = current_time;
        }
    }
}

