/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.util.ArrayList;
import visad.util.CmdlineConsumer;

public class CmdlineParser {
    private String mainName;
    private ArrayList list;

    public CmdlineParser(Object mainClass) {
        String className = mainClass.getClass().getName();
        int pt = className.lastIndexOf(46);
        int ds = className.lastIndexOf(36);
        if (ds > pt) {
            pt = ds;
        }
        this.mainName = className.substring(pt == -1 ? 0 : pt + 1);
        this.list = null;
        if (mainClass instanceof CmdlineConsumer) {
            this.addConsumer((CmdlineConsumer)mainClass);
        }
    }

    public void addConsumer(CmdlineConsumer consumer) {
        if (this.list == null) {
            this.list = new ArrayList();
        }
        this.list.add(consumer);
    }

    public String getMainClassName() {
        return this.mainName;
    }

    public boolean processArgs(String[] args) {
        int c;
        boolean usage = false;
        if (this.list == null || args == null) {
            return true;
        }
        CmdlineConsumer[] consumers = new CmdlineConsumer[this.list.size()];
        for (c = 0; c < consumers.length; ++c) {
            consumers[c] = (CmdlineConsumer)this.list.get(consumers.length - (c + 1));
        }
        for (c = 0; c < consumers.length; ++c) {
            consumers[c].initializeArgs();
        }
        block2: for (int i = 0; !usage && i < args.length; ++i) {
            if (args[i].length() > 0 && args[i].charAt(0) == '-') {
                String str;
                char ch = args[i].charAt(1);
                boolean strInOption = false;
                if (args[i].length() > 2) {
                    str = args[i].substring(2);
                    strInOption = true;
                } else {
                    str = i + 1 < args.length ? args[i + 1] : null;
                }
                for (int c2 = 0; c2 < consumers.length; ++c2) {
                    int handled = consumers[c2].checkOption(this.mainName, ch, str);
                    if (handled > 0) {
                        if (handled > 1) {
                            handled = strInOption ? 1 : 2;
                        }
                        i += handled - 1;
                        continue block2;
                    }
                    if (handled == 0) {
                        System.err.println(this.mainName + ": Unknown option \"-" + ch + "\"");
                    }
                    usage = true;
                }
                continue;
            }
            for (int c3 = 0; c3 < consumers.length; ++c3) {
                int handled = consumers[c3].checkKeyword(this.mainName, i, args);
                if (handled > 0) {
                    i += handled - 1;
                    continue block2;
                }
                if (handled == 0) {
                    System.err.println(this.mainName + ": Unknown keyword \"" + args[i] + "\"");
                }
                usage = true;
            }
        }
        for (c = 0; !usage && c < consumers.length; usage |= !consumers[c].finalizeArgs(this.mainName), ++c) {
        }
        if (usage) {
            int c4;
            StringBuffer buf = new StringBuffer("Usage: " + this.mainName);
            for (c4 = 0; c4 < consumers.length; ++c4) {
                buf.append(consumers[c4].optionUsage());
            }
            for (c4 = 0; c4 < consumers.length; ++c4) {
                buf.append(consumers[c4].keywordUsage());
            }
            System.err.println(buf.toString());
        }
        return !usage;
    }
}

