/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.jaxws;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.jws.WebService;
import javax.xml.ws.Endpoint;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.core.task.support.ConcurrentExecutorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleJaxWsServiceExporter
implements BeanFactoryAware,
DisposableBean {
    public static final String DEFAULT_BASE_ADDRESS = "http://localhost:8080/";
    private String baseAddress = "http://localhost:8080/";
    private Executor executor;
    private Map<String, Object> endpointProperties;
    private final Set<Endpoint> publishedEndpoints = new LinkedHashSet<Endpoint>();

    public void setBaseAddress(String baseAddress) {
        this.baseAddress = baseAddress;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void setTaskExecutor(TaskExecutor executor) {
        this.executor = new ConcurrentExecutorAdapter(executor);
    }

    public void setEndpointProperties(Map<String, Object> endpointProperties) {
        this.endpointProperties = endpointProperties;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        String[] beanNames;
        if (!(beanFactory instanceof ListableBeanFactory)) {
            throw new IllegalStateException("SimpleJaxWsServiceExporter requires a ListableBeanFactory");
        }
        ListableBeanFactory lbf = (ListableBeanFactory)beanFactory;
        for (String beanName : beanNames = lbf.getBeanNamesForType(Object.class, false, false)) {
            Class type = lbf.getType(beanName);
            WebService annotation = type.getAnnotation(WebService.class);
            if (annotation == null) continue;
            Endpoint endpoint = Endpoint.create((Object)lbf.getBean(beanName));
            if (this.executor != null) {
                endpoint.setExecutor(this.executor);
            }
            if (this.endpointProperties != null) {
                endpoint.setProperties(this.endpointProperties);
            }
            String fullAddress = this.baseAddress + annotation.serviceName();
            endpoint.publish(fullAddress);
            this.publishedEndpoints.add(endpoint);
        }
    }

    @Override
    public void destroy() {
        for (Endpoint endpoint : this.publishedEndpoints) {
            endpoint.stop();
        }
    }
}

