// This code conforms with the UFC specification version 1.4
// and was automatically generated by FFC version 0.9.2.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: True
//   cpp_optimize:                   False
//   epsilon:                        1e-14
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      10
//   log_prefix:                     ''
//   optimize:                       False
//   output_dir:                     '.'
//   precision:                      '8'
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False

#ifndef __VECTORLAPLACEGRADCURL_H
#define __VECTORLAPLACEGRADCURL_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class vectorlaplacegradcurl_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  vectorlaplacegradcurl_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vectorlaplacegradcurl_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 2)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 10;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Reset values.
    *values = 0.00000000;
    
    // Map degree of freedom to element degree of freedom
    const unsigned int dof = i;
    
    // Array of basisvalues.
    double basisvalues[10] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
    
    // Declare helper variables.
    unsigned int rr = 0;
    unsigned int ss = 0;
    unsigned int tt = 0;
    double tmp5 = 0.00000000;
    double tmp6 = 0.00000000;
    double tmp7 = 0.00000000;
    double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
    double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
    double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
    double tmp3 = 0.50000000*(1.00000000 - Z);
    double tmp4 = tmp3*tmp3;
    
    // Compute basisvalues.
    basisvalues[0] = 1.00000000;
    basisvalues[1] = tmp0;
    for (unsigned int r = 1; r < 2; r++)
    {
      rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
      ss = r*(r + 1)*(r + 2)/6;
      tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
      basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
    }// end loop over 'r'
    for (unsigned int r = 0; r < 2; r++)
    {
      rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
      ss = r*(r + 1)*(r + 2)/6;
      basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
    }// end loop over 'r'
    for (unsigned int r = 0; r < 1; r++)
    {
      for (unsigned int s = 1; s < 2 - r; s++)
      {
        rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
        ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
        tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
        tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
        tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
        tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
        basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 2; r++)
    {
      for (unsigned int s = 0; s < 2 - r; s++)
      {
        rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
        ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 1; r++)
    {
      for (unsigned int s = 0; s < 1 - r; s++)
      {
        for (unsigned int t = 1; t < 2 - r - s; t++)
        {
          rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
          ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
          tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
          tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
          tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
          tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 3; r++)
    {
      for (unsigned int s = 0; s < 3 - r; s++)
      {
        for (unsigned int t = 0; t < 3 - r - s; t++)
        {
          rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    
    // Table(s) of coefficients.
    static const double coefficients0[10][10] = \
    {{-0.05773503, -0.06085806, -0.03513642, -0.02484520, 0.06506000, 0.05039526, 0.04114756, 0.02909572, 0.02375655, 0.01679842},
    {-0.05773503, 0.06085806, -0.03513642, -0.02484520, 0.06506000, -0.05039526, -0.04114756, 0.02909572, 0.02375655, 0.01679842},
    {-0.05773503, 0.00000000, 0.07027284, -0.02484520, 0.00000000, 0.00000000, 0.00000000, 0.08728716, -0.04751311, 0.01679842},
    {-0.05773503, 0.00000000, 0.00000000, 0.07453560, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.10079053},
    {0.23094011, 0.00000000, 0.14054567, 0.09938080, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.11878277, -0.06719368},
    {0.23094011, 0.12171612, -0.07027284, 0.09938080, 0.00000000, 0.00000000, 0.10286890, 0.00000000, -0.05939139, -0.06719368},
    {0.23094011, 0.12171612, 0.07027284, -0.09938080, 0.00000000, 0.10079053, -0.02057378, -0.08728716, -0.01187828, 0.01679842},
    {0.23094011, -0.12171612, -0.07027284, 0.09938080, 0.00000000, 0.00000000, -0.10286890, 0.00000000, -0.05939139, -0.06719368},
    {0.23094011, -0.12171612, 0.07027284, -0.09938080, 0.00000000, -0.10079053, 0.02057378, -0.08728716, -0.01187828, 0.01679842},
    {0.23094011, 0.00000000, -0.14054567, -0.09938080, -0.13012001, 0.00000000, 0.00000000, 0.02909572, 0.02375655, 0.01679842}};
    
    // Compute value(s).
    for (unsigned int r = 0; r < 10; r++)
    {
      *values += coefficients0[dof][r]*basisvalues[r];
    }// end loop over 'r'
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.00000000;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K_00, K_01, K_02}, {K_10, K_11, K_12}, {K_20, K_21, K_22}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.00000000;
    }// end loop over 'r'
    
    // Map degree of freedom to element degree of freedom
    const unsigned int dof = i;
    
    // Array of basisvalues.
    double basisvalues[10] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
    
    // Declare helper variables.
    unsigned int rr = 0;
    unsigned int ss = 0;
    unsigned int tt = 0;
    double tmp5 = 0.00000000;
    double tmp6 = 0.00000000;
    double tmp7 = 0.00000000;
    double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
    double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
    double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
    double tmp3 = 0.50000000*(1.00000000 - Z);
    double tmp4 = tmp3*tmp3;
    
    // Compute basisvalues.
    basisvalues[0] = 1.00000000;
    basisvalues[1] = tmp0;
    for (unsigned int r = 1; r < 2; r++)
    {
      rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
      ss = r*(r + 1)*(r + 2)/6;
      tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
      basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
    }// end loop over 'r'
    for (unsigned int r = 0; r < 2; r++)
    {
      rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
      ss = r*(r + 1)*(r + 2)/6;
      basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
    }// end loop over 'r'
    for (unsigned int r = 0; r < 1; r++)
    {
      for (unsigned int s = 1; s < 2 - r; s++)
      {
        rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
        ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
        tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
        tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
        tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
        tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
        basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 2; r++)
    {
      for (unsigned int s = 0; s < 2 - r; s++)
      {
        rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
        ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 1; r++)
    {
      for (unsigned int s = 0; s < 1 - r; s++)
      {
        for (unsigned int t = 1; t < 2 - r - s; t++)
        {
          rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
          ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
          tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
          tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
          tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
          tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 3; r++)
    {
      for (unsigned int s = 0; s < 3 - r; s++)
      {
        for (unsigned int t = 0; t < 3 - r - s; t++)
        {
          rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    
    // Table(s) of coefficients.
    static const double coefficients0[10][10] = \
    {{-0.05773503, -0.06085806, -0.03513642, -0.02484520, 0.06506000, 0.05039526, 0.04114756, 0.02909572, 0.02375655, 0.01679842},
    {-0.05773503, 0.06085806, -0.03513642, -0.02484520, 0.06506000, -0.05039526, -0.04114756, 0.02909572, 0.02375655, 0.01679842},
    {-0.05773503, 0.00000000, 0.07027284, -0.02484520, 0.00000000, 0.00000000, 0.00000000, 0.08728716, -0.04751311, 0.01679842},
    {-0.05773503, 0.00000000, 0.00000000, 0.07453560, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.10079053},
    {0.23094011, 0.00000000, 0.14054567, 0.09938080, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.11878277, -0.06719368},
    {0.23094011, 0.12171612, -0.07027284, 0.09938080, 0.00000000, 0.00000000, 0.10286890, 0.00000000, -0.05939139, -0.06719368},
    {0.23094011, 0.12171612, 0.07027284, -0.09938080, 0.00000000, 0.10079053, -0.02057378, -0.08728716, -0.01187828, 0.01679842},
    {0.23094011, -0.12171612, -0.07027284, 0.09938080, 0.00000000, 0.00000000, -0.10286890, 0.00000000, -0.05939139, -0.06719368},
    {0.23094011, -0.12171612, 0.07027284, -0.09938080, 0.00000000, -0.10079053, 0.02057378, -0.08728716, -0.01187828, 0.01679842},
    {0.23094011, 0.00000000, -0.14054567, -0.09938080, -0.13012001, 0.00000000, 0.00000000, 0.02909572, 0.02375655, 0.01679842}};
    
    // Tables of derivatives of the polynomial base (transpose).
    static const double dmats0[10][10] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {6.32455532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 11.22497216, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {4.58257569, 0.00000000, 8.36660027, -1.18321596, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {3.74165739, 0.00000000, 0.00000000, 8.69482605, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
    
    static const double dmats1[10][10] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {5.47722558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {2.29128785, 7.24568837, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {1.87082869, 0.00000000, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-2.64575131, 0.00000000, 9.66091783, 0.68313005, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {3.24037035, 0.00000000, 0.00000000, 7.52994024, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
    
    static const double dmats2[10][10] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {1.82574186, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {5.16397779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {2.29128785, 1.44913767, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {1.87082869, 7.09929574, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {1.32287566, 0.00000000, 3.86436713, -0.34156503, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {1.08012345, 0.00000000, 7.09929574, 2.50998008, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-3.81881308, 0.00000000, 0.00000000, 8.87411967, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
    
    // Compute reference derivatives.
    // Declare pointer to array of derivatives on FIAT element.
    double *derivatives = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      derivatives[r] = 0.00000000;
    }// end loop over 'r'
    
    // Declare derivative matrix (of polynomial basis).
    double dmats[10][10] = \
    {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
    
    // Declare (auxiliary) derivative matrix (of polynomial basis).
    double dmats_old[10][10] = \
    {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
    
    // Loop possible derivatives.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      // Resetting dmats values to compute next derivative.
      for (unsigned int t = 0; t < 10; t++)
      {
        for (unsigned int u = 0; u < 10; u++)
        {
          dmats[t][u] = 0.00000000;
          if (t == u)
          {
          dmats[t][u] = 1.00000000;
          }
          
        }// end loop over 'u'
      }// end loop over 't'
      
      // Looping derivative order to generate dmats.
      for (unsigned int s = 0; s < n; s++)
      {
        // Updating dmats_old with new values and resetting dmats.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats_old[t][u] = dmats[t][u];
            dmats[t][u] = 0.00000000;
          }// end loop over 'u'
        }// end loop over 't'
        
        // Update dmats using an inner product.
        if (combinations[r][s] == 0)
        {
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            for (unsigned int tu = 0; tu < 10; tu++)
            {
              dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
        if (combinations[r][s] == 1)
        {
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            for (unsigned int tu = 0; tu < 10; tu++)
            {
              dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
        if (combinations[r][s] == 2)
        {
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            for (unsigned int tu = 0; tu < 10; tu++)
            {
              dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
      }// end loop over 's'
      for (unsigned int s = 0; s < 10; s++)
      {
        for (unsigned int t = 0; t < 10; t++)
        {
          derivatives[r] += coefficients0[dof][s]*dmats[s][t]*basisvalues[t];
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    
    // Transform derivatives back to physical element
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r] += transform[r][s]*derivatives[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer to array of derivatives on FIAT element
    delete [] derivatives;
    
    // Delete pointer to array of combinations of derivatives and transform
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] combinations[r];
    }// end loop over 'r'
    delete [] combinations;
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] transform[r];
    }// end loop over 'r'
    delete [] transform;
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.00000000;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      y[2] = x[0][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      y[2] = x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      y[2] = x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = x[3][0];
      y[1] = x[3][1];
      y[2] = x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.50000000*x[2][0] + 0.50000000*x[3][0];
      y[1] = 0.50000000*x[2][1] + 0.50000000*x[3][1];
      y[2] = 0.50000000*x[2][2] + 0.50000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.50000000*x[1][0] + 0.50000000*x[3][0];
      y[1] = 0.50000000*x[1][1] + 0.50000000*x[3][1];
      y[2] = 0.50000000*x[1][2] + 0.50000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.50000000*x[1][0] + 0.50000000*x[2][0];
      y[1] = 0.50000000*x[1][1] + 0.50000000*x[2][1];
      y[2] = 0.50000000*x[1][2] + 0.50000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.50000000*x[0][0] + 0.50000000*x[3][0];
      y[1] = 0.50000000*x[0][1] + 0.50000000*x[3][1];
      y[2] = 0.50000000*x[0][2] + 0.50000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.50000000*x[0][0] + 0.50000000*x[2][0];
      y[1] = 0.50000000*x[0][1] + 0.50000000*x[2][1];
      y[2] = 0.50000000*x[0][2] + 0.50000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.50000000*x[0][0] + 0.50000000*x[1][0];
      y[1] = 0.50000000*x[0][1] + 0.50000000*x[1][1];
      y[2] = 0.50000000*x[0][2] + 0.50000000*x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.00000000;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    y[2] = x[0][2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    y[2] = x[1][2];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    y[2] = x[2][2];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = x[3][0];
    y[1] = x[3][1];
    y[2] = x[3][2];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.50000000*x[2][0] + 0.50000000*x[3][0];
    y[1] = 0.50000000*x[2][1] + 0.50000000*x[3][1];
    y[2] = 0.50000000*x[2][2] + 0.50000000*x[3][2];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.50000000*x[1][0] + 0.50000000*x[3][0];
    y[1] = 0.50000000*x[1][1] + 0.50000000*x[3][1];
    y[2] = 0.50000000*x[1][2] + 0.50000000*x[3][2];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.50000000*x[1][0] + 0.50000000*x[2][0];
    y[1] = 0.50000000*x[1][1] + 0.50000000*x[2][1];
    y[2] = 0.50000000*x[1][2] + 0.50000000*x[2][2];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.50000000*x[0][0] + 0.50000000*x[3][0];
    y[1] = 0.50000000*x[0][1] + 0.50000000*x[3][1];
    y[2] = 0.50000000*x[0][2] + 0.50000000*x[3][2];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.50000000*x[0][0] + 0.50000000*x[2][0];
    y[1] = 0.50000000*x[0][1] + 0.50000000*x[2][1];
    y[2] = 0.50000000*x[0][2] + 0.50000000*x[2][2];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.50000000*x[0][0] + 0.50000000*x[1][0];
    y[1] = 0.50000000*x[0][1] + 0.50000000*x[1][1];
    y[2] = 0.50000000*x[0][2] + 0.50000000*x[1][2];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
    vertex_values[3] = dof_values[3];
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for a finite element.

class vectorlaplacegradcurl_finite_element_1: public ufc::finite_element
{
public:

  /// Constructor
  vectorlaplacegradcurl_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vectorlaplacegradcurl_finite_element_1()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 2, 3)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 30;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 1;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return 3;
        break;
      }
    }
    
    return 0;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Reset values.
    values[0] = 0.00000000;
    values[1] = 0.00000000;
    values[2] = 0.00000000;
    if (0 <= i && i <= 9)
    {
      // Map degree of freedom to element degree of freedom
      const unsigned int dof = i;
      
      // Array of basisvalues.
      double basisvalues[10] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10][10] = \
      {{-0.05773503, -0.06085806, -0.03513642, -0.02484520, 0.06506000, 0.05039526, 0.04114756, 0.02909572, 0.02375655, 0.01679842},
      {-0.05773503, 0.06085806, -0.03513642, -0.02484520, 0.06506000, -0.05039526, -0.04114756, 0.02909572, 0.02375655, 0.01679842},
      {-0.05773503, 0.00000000, 0.07027284, -0.02484520, 0.00000000, 0.00000000, 0.00000000, 0.08728716, -0.04751311, 0.01679842},
      {-0.05773503, 0.00000000, 0.00000000, 0.07453560, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.10079053},
      {0.23094011, 0.00000000, 0.14054567, 0.09938080, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.11878277, -0.06719368},
      {0.23094011, 0.12171612, -0.07027284, 0.09938080, 0.00000000, 0.00000000, 0.10286890, 0.00000000, -0.05939139, -0.06719368},
      {0.23094011, 0.12171612, 0.07027284, -0.09938080, 0.00000000, 0.10079053, -0.02057378, -0.08728716, -0.01187828, 0.01679842},
      {0.23094011, -0.12171612, -0.07027284, 0.09938080, 0.00000000, 0.00000000, -0.10286890, 0.00000000, -0.05939139, -0.06719368},
      {0.23094011, -0.12171612, 0.07027284, -0.09938080, 0.00000000, -0.10079053, 0.02057378, -0.08728716, -0.01187828, 0.01679842},
      {0.23094011, 0.00000000, -0.14054567, -0.09938080, -0.13012001, 0.00000000, 0.00000000, 0.02909572, 0.02375655, 0.01679842}};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[dof][r]*basisvalues[r];
      }// end loop over 'r'
    }
    
    if (10 <= i && i <= 19)
    {
      // Map degree of freedom to element degree of freedom
      const unsigned int dof = i - 10;
      
      // Array of basisvalues.
      double basisvalues[10] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10][10] = \
      {{-0.05773503, -0.06085806, -0.03513642, -0.02484520, 0.06506000, 0.05039526, 0.04114756, 0.02909572, 0.02375655, 0.01679842},
      {-0.05773503, 0.06085806, -0.03513642, -0.02484520, 0.06506000, -0.05039526, -0.04114756, 0.02909572, 0.02375655, 0.01679842},
      {-0.05773503, 0.00000000, 0.07027284, -0.02484520, 0.00000000, 0.00000000, 0.00000000, 0.08728716, -0.04751311, 0.01679842},
      {-0.05773503, 0.00000000, 0.00000000, 0.07453560, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.10079053},
      {0.23094011, 0.00000000, 0.14054567, 0.09938080, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.11878277, -0.06719368},
      {0.23094011, 0.12171612, -0.07027284, 0.09938080, 0.00000000, 0.00000000, 0.10286890, 0.00000000, -0.05939139, -0.06719368},
      {0.23094011, 0.12171612, 0.07027284, -0.09938080, 0.00000000, 0.10079053, -0.02057378, -0.08728716, -0.01187828, 0.01679842},
      {0.23094011, -0.12171612, -0.07027284, 0.09938080, 0.00000000, 0.00000000, -0.10286890, 0.00000000, -0.05939139, -0.06719368},
      {0.23094011, -0.12171612, 0.07027284, -0.09938080, 0.00000000, -0.10079053, 0.02057378, -0.08728716, -0.01187828, 0.01679842},
      {0.23094011, 0.00000000, -0.14054567, -0.09938080, -0.13012001, 0.00000000, 0.00000000, 0.02909572, 0.02375655, 0.01679842}};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[dof][r]*basisvalues[r];
      }// end loop over 'r'
    }
    
    if (20 <= i && i <= 29)
    {
      // Map degree of freedom to element degree of freedom
      const unsigned int dof = i - 20;
      
      // Array of basisvalues.
      double basisvalues[10] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10][10] = \
      {{-0.05773503, -0.06085806, -0.03513642, -0.02484520, 0.06506000, 0.05039526, 0.04114756, 0.02909572, 0.02375655, 0.01679842},
      {-0.05773503, 0.06085806, -0.03513642, -0.02484520, 0.06506000, -0.05039526, -0.04114756, 0.02909572, 0.02375655, 0.01679842},
      {-0.05773503, 0.00000000, 0.07027284, -0.02484520, 0.00000000, 0.00000000, 0.00000000, 0.08728716, -0.04751311, 0.01679842},
      {-0.05773503, 0.00000000, 0.00000000, 0.07453560, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.10079053},
      {0.23094011, 0.00000000, 0.14054567, 0.09938080, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.11878277, -0.06719368},
      {0.23094011, 0.12171612, -0.07027284, 0.09938080, 0.00000000, 0.00000000, 0.10286890, 0.00000000, -0.05939139, -0.06719368},
      {0.23094011, 0.12171612, 0.07027284, -0.09938080, 0.00000000, 0.10079053, -0.02057378, -0.08728716, -0.01187828, 0.01679842},
      {0.23094011, -0.12171612, -0.07027284, 0.09938080, 0.00000000, 0.00000000, -0.10286890, 0.00000000, -0.05939139, -0.06719368},
      {0.23094011, -0.12171612, 0.07027284, -0.09938080, 0.00000000, -0.10079053, 0.02057378, -0.08728716, -0.01187828, 0.01679842},
      {0.23094011, 0.00000000, -0.14054567, -0.09938080, -0.13012001, 0.00000000, 0.00000000, 0.02909572, 0.02375655, 0.01679842}};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[dof][r]*basisvalues[r];
      }// end loop over 'r'
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values[3] = {0.00000000, 0.00000000, 0.00000000};
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 30; r++)
    {
      evaluate_basis(r, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 3; s++)
      {
        values[r*3 + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K_00, K_01, K_02}, {K_10, K_11, K_12}, {K_20, K_21, K_22}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 3*num_derivatives; r++)
    {
      values[r] = 0.00000000;
    }// end loop over 'r'
    
    if (0 <= i && i <= 9)
    {
      // Map degree of freedom to element degree of freedom
      const unsigned int dof = i;
      
      // Array of basisvalues.
      double basisvalues[10] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10][10] = \
      {{-0.05773503, -0.06085806, -0.03513642, -0.02484520, 0.06506000, 0.05039526, 0.04114756, 0.02909572, 0.02375655, 0.01679842},
      {-0.05773503, 0.06085806, -0.03513642, -0.02484520, 0.06506000, -0.05039526, -0.04114756, 0.02909572, 0.02375655, 0.01679842},
      {-0.05773503, 0.00000000, 0.07027284, -0.02484520, 0.00000000, 0.00000000, 0.00000000, 0.08728716, -0.04751311, 0.01679842},
      {-0.05773503, 0.00000000, 0.00000000, 0.07453560, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.10079053},
      {0.23094011, 0.00000000, 0.14054567, 0.09938080, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.11878277, -0.06719368},
      {0.23094011, 0.12171612, -0.07027284, 0.09938080, 0.00000000, 0.00000000, 0.10286890, 0.00000000, -0.05939139, -0.06719368},
      {0.23094011, 0.12171612, 0.07027284, -0.09938080, 0.00000000, 0.10079053, -0.02057378, -0.08728716, -0.01187828, 0.01679842},
      {0.23094011, -0.12171612, -0.07027284, 0.09938080, 0.00000000, 0.00000000, -0.10286890, 0.00000000, -0.05939139, -0.06719368},
      {0.23094011, -0.12171612, 0.07027284, -0.09938080, 0.00000000, -0.10079053, 0.02057378, -0.08728716, -0.01187828, 0.01679842},
      {0.23094011, 0.00000000, -0.14054567, -0.09938080, -0.13012001, 0.00000000, 0.00000000, 0.02909572, 0.02375655, 0.01679842}};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.22497216, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.58257569, 0.00000000, 8.36660027, -1.18321596, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.74165739, 0.00000000, 0.00000000, 8.69482605, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[10][10] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 7.24568837, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 0.00000000, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.64575131, 0.00000000, 9.66091783, 0.68313005, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.24037035, 0.00000000, 0.00000000, 7.52994024, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[10][10] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 1.44913767, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 7.09929574, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32287566, 0.00000000, 3.86436713, -0.34156503, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.08012345, 0.00000000, 7.09929574, 2.50998008, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.81881308, 0.00000000, 0.00000000, 8.87411967, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[dof][s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
    }
    
    if (10 <= i && i <= 19)
    {
      // Map degree of freedom to element degree of freedom
      const unsigned int dof = i - 10;
      
      // Array of basisvalues.
      double basisvalues[10] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10][10] = \
      {{-0.05773503, -0.06085806, -0.03513642, -0.02484520, 0.06506000, 0.05039526, 0.04114756, 0.02909572, 0.02375655, 0.01679842},
      {-0.05773503, 0.06085806, -0.03513642, -0.02484520, 0.06506000, -0.05039526, -0.04114756, 0.02909572, 0.02375655, 0.01679842},
      {-0.05773503, 0.00000000, 0.07027284, -0.02484520, 0.00000000, 0.00000000, 0.00000000, 0.08728716, -0.04751311, 0.01679842},
      {-0.05773503, 0.00000000, 0.00000000, 0.07453560, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.10079053},
      {0.23094011, 0.00000000, 0.14054567, 0.09938080, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.11878277, -0.06719368},
      {0.23094011, 0.12171612, -0.07027284, 0.09938080, 0.00000000, 0.00000000, 0.10286890, 0.00000000, -0.05939139, -0.06719368},
      {0.23094011, 0.12171612, 0.07027284, -0.09938080, 0.00000000, 0.10079053, -0.02057378, -0.08728716, -0.01187828, 0.01679842},
      {0.23094011, -0.12171612, -0.07027284, 0.09938080, 0.00000000, 0.00000000, -0.10286890, 0.00000000, -0.05939139, -0.06719368},
      {0.23094011, -0.12171612, 0.07027284, -0.09938080, 0.00000000, -0.10079053, 0.02057378, -0.08728716, -0.01187828, 0.01679842},
      {0.23094011, 0.00000000, -0.14054567, -0.09938080, -0.13012001, 0.00000000, 0.00000000, 0.02909572, 0.02375655, 0.01679842}};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.22497216, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.58257569, 0.00000000, 8.36660027, -1.18321596, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.74165739, 0.00000000, 0.00000000, 8.69482605, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[10][10] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 7.24568837, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 0.00000000, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.64575131, 0.00000000, 9.66091783, 0.68313005, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.24037035, 0.00000000, 0.00000000, 7.52994024, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[10][10] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 1.44913767, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 7.09929574, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32287566, 0.00000000, 3.86436713, -0.34156503, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.08012345, 0.00000000, 7.09929574, 2.50998008, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.81881308, 0.00000000, 0.00000000, 8.87411967, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[dof][s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
    }
    
    if (20 <= i && i <= 29)
    {
      // Map degree of freedom to element degree of freedom
      const unsigned int dof = i - 20;
      
      // Array of basisvalues.
      double basisvalues[10] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          for (unsigned int t = 1; t < 2 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          for (unsigned int t = 0; t < 3 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[10][10] = \
      {{-0.05773503, -0.06085806, -0.03513642, -0.02484520, 0.06506000, 0.05039526, 0.04114756, 0.02909572, 0.02375655, 0.01679842},
      {-0.05773503, 0.06085806, -0.03513642, -0.02484520, 0.06506000, -0.05039526, -0.04114756, 0.02909572, 0.02375655, 0.01679842},
      {-0.05773503, 0.00000000, 0.07027284, -0.02484520, 0.00000000, 0.00000000, 0.00000000, 0.08728716, -0.04751311, 0.01679842},
      {-0.05773503, 0.00000000, 0.00000000, 0.07453560, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.10079053},
      {0.23094011, 0.00000000, 0.14054567, 0.09938080, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.11878277, -0.06719368},
      {0.23094011, 0.12171612, -0.07027284, 0.09938080, 0.00000000, 0.00000000, 0.10286890, 0.00000000, -0.05939139, -0.06719368},
      {0.23094011, 0.12171612, 0.07027284, -0.09938080, 0.00000000, 0.10079053, -0.02057378, -0.08728716, -0.01187828, 0.01679842},
      {0.23094011, -0.12171612, -0.07027284, 0.09938080, 0.00000000, 0.00000000, -0.10286890, 0.00000000, -0.05939139, -0.06719368},
      {0.23094011, -0.12171612, 0.07027284, -0.09938080, 0.00000000, -0.10079053, 0.02057378, -0.08728716, -0.01187828, 0.01679842},
      {0.23094011, 0.00000000, -0.14054567, -0.09938080, -0.13012001, 0.00000000, 0.00000000, 0.02909572, 0.02375655, 0.01679842}};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.22497216, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.58257569, 0.00000000, 8.36660027, -1.18321596, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.74165739, 0.00000000, 0.00000000, 8.69482605, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[10][10] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 7.24568837, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 0.00000000, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.64575131, 0.00000000, 9.66091783, 0.68313005, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.24037035, 0.00000000, 0.00000000, 7.52994024, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[10][10] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 1.44913767, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 7.09929574, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32287566, 0.00000000, 3.86436713, -0.34156503, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.08012345, 0.00000000, 7.09929574, 2.50998008, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.81881308, 0.00000000, 0.00000000, 8.87411967, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[dof][s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[3*num_derivatives];
    for (unsigned int r = 0; r < 3*num_derivatives; r++)
    {
      dof_values[r] = 0.00000000;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 30; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 3*num_derivatives; s++)
      {
        values[r*3*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[3];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      y[2] = x[0][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      y[2] = x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      y[2] = x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = x[3][0];
      y[1] = x[3][1];
      y[2] = x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.50000000*x[2][0] + 0.50000000*x[3][0];
      y[1] = 0.50000000*x[2][1] + 0.50000000*x[3][1];
      y[2] = 0.50000000*x[2][2] + 0.50000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.50000000*x[1][0] + 0.50000000*x[3][0];
      y[1] = 0.50000000*x[1][1] + 0.50000000*x[3][1];
      y[2] = 0.50000000*x[1][2] + 0.50000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.50000000*x[1][0] + 0.50000000*x[2][0];
      y[1] = 0.50000000*x[1][1] + 0.50000000*x[2][1];
      y[2] = 0.50000000*x[1][2] + 0.50000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.50000000*x[0][0] + 0.50000000*x[3][0];
      y[1] = 0.50000000*x[0][1] + 0.50000000*x[3][1];
      y[2] = 0.50000000*x[0][2] + 0.50000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.50000000*x[0][0] + 0.50000000*x[2][0];
      y[1] = 0.50000000*x[0][1] + 0.50000000*x[2][1];
      y[2] = 0.50000000*x[0][2] + 0.50000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.50000000*x[0][0] + 0.50000000*x[1][0];
      y[1] = 0.50000000*x[0][1] + 0.50000000*x[1][1];
      y[2] = 0.50000000*x[0][2] + 0.50000000*x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 10:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      y[2] = x[0][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 11:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      y[2] = x[1][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 12:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      y[2] = x[2][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 13:
      {
        y[0] = x[3][0];
      y[1] = x[3][1];
      y[2] = x[3][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 14:
      {
        y[0] = 0.50000000*x[2][0] + 0.50000000*x[3][0];
      y[1] = 0.50000000*x[2][1] + 0.50000000*x[3][1];
      y[2] = 0.50000000*x[2][2] + 0.50000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 15:
      {
        y[0] = 0.50000000*x[1][0] + 0.50000000*x[3][0];
      y[1] = 0.50000000*x[1][1] + 0.50000000*x[3][1];
      y[2] = 0.50000000*x[1][2] + 0.50000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 16:
      {
        y[0] = 0.50000000*x[1][0] + 0.50000000*x[2][0];
      y[1] = 0.50000000*x[1][1] + 0.50000000*x[2][1];
      y[2] = 0.50000000*x[1][2] + 0.50000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 17:
      {
        y[0] = 0.50000000*x[0][0] + 0.50000000*x[3][0];
      y[1] = 0.50000000*x[0][1] + 0.50000000*x[3][1];
      y[2] = 0.50000000*x[0][2] + 0.50000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 18:
      {
        y[0] = 0.50000000*x[0][0] + 0.50000000*x[2][0];
      y[1] = 0.50000000*x[0][1] + 0.50000000*x[2][1];
      y[2] = 0.50000000*x[0][2] + 0.50000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 19:
      {
        y[0] = 0.50000000*x[0][0] + 0.50000000*x[1][0];
      y[1] = 0.50000000*x[0][1] + 0.50000000*x[1][1];
      y[2] = 0.50000000*x[0][2] + 0.50000000*x[1][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 20:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      y[2] = x[0][2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 21:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      y[2] = x[1][2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 22:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      y[2] = x[2][2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 23:
      {
        y[0] = x[3][0];
      y[1] = x[3][1];
      y[2] = x[3][2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 24:
      {
        y[0] = 0.50000000*x[2][0] + 0.50000000*x[3][0];
      y[1] = 0.50000000*x[2][1] + 0.50000000*x[3][1];
      y[2] = 0.50000000*x[2][2] + 0.50000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 25:
      {
        y[0] = 0.50000000*x[1][0] + 0.50000000*x[3][0];
      y[1] = 0.50000000*x[1][1] + 0.50000000*x[3][1];
      y[2] = 0.50000000*x[1][2] + 0.50000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 26:
      {
        y[0] = 0.50000000*x[1][0] + 0.50000000*x[2][0];
      y[1] = 0.50000000*x[1][1] + 0.50000000*x[2][1];
      y[2] = 0.50000000*x[1][2] + 0.50000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 27:
      {
        y[0] = 0.50000000*x[0][0] + 0.50000000*x[3][0];
      y[1] = 0.50000000*x[0][1] + 0.50000000*x[3][1];
      y[2] = 0.50000000*x[0][2] + 0.50000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 28:
      {
        y[0] = 0.50000000*x[0][0] + 0.50000000*x[2][0];
      y[1] = 0.50000000*x[0][1] + 0.50000000*x[2][1];
      y[2] = 0.50000000*x[0][2] + 0.50000000*x[2][2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 29:
      {
        y[0] = 0.50000000*x[0][0] + 0.50000000*x[1][0];
      y[1] = 0.50000000*x[0][1] + 0.50000000*x[1][1];
      y[2] = 0.50000000*x[0][2] + 0.50000000*x[1][2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    }
    
    return 0.00000000;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[3];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    y[2] = x[0][2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    y[2] = x[1][2];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    y[2] = x[2][2];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = x[3][0];
    y[1] = x[3][1];
    y[2] = x[3][2];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.50000000*x[2][0] + 0.50000000*x[3][0];
    y[1] = 0.50000000*x[2][1] + 0.50000000*x[3][1];
    y[2] = 0.50000000*x[2][2] + 0.50000000*x[3][2];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.50000000*x[1][0] + 0.50000000*x[3][0];
    y[1] = 0.50000000*x[1][1] + 0.50000000*x[3][1];
    y[2] = 0.50000000*x[1][2] + 0.50000000*x[3][2];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.50000000*x[1][0] + 0.50000000*x[2][0];
    y[1] = 0.50000000*x[1][1] + 0.50000000*x[2][1];
    y[2] = 0.50000000*x[1][2] + 0.50000000*x[2][2];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.50000000*x[0][0] + 0.50000000*x[3][0];
    y[1] = 0.50000000*x[0][1] + 0.50000000*x[3][1];
    y[2] = 0.50000000*x[0][2] + 0.50000000*x[3][2];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.50000000*x[0][0] + 0.50000000*x[2][0];
    y[1] = 0.50000000*x[0][1] + 0.50000000*x[2][1];
    y[2] = 0.50000000*x[0][2] + 0.50000000*x[2][2];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.50000000*x[0][0] + 0.50000000*x[1][0];
    y[1] = 0.50000000*x[0][1] + 0.50000000*x[1][1];
    y[2] = 0.50000000*x[0][2] + 0.50000000*x[1][2];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
    y[0] = x[0][0];
    y[1] = x[0][1];
    y[2] = x[0][2];
    f.evaluate(vals, y, c);
    values[10] = vals[1];
    y[0] = x[1][0];
    y[1] = x[1][1];
    y[2] = x[1][2];
    f.evaluate(vals, y, c);
    values[11] = vals[1];
    y[0] = x[2][0];
    y[1] = x[2][1];
    y[2] = x[2][2];
    f.evaluate(vals, y, c);
    values[12] = vals[1];
    y[0] = x[3][0];
    y[1] = x[3][1];
    y[2] = x[3][2];
    f.evaluate(vals, y, c);
    values[13] = vals[1];
    y[0] = 0.50000000*x[2][0] + 0.50000000*x[3][0];
    y[1] = 0.50000000*x[2][1] + 0.50000000*x[3][1];
    y[2] = 0.50000000*x[2][2] + 0.50000000*x[3][2];
    f.evaluate(vals, y, c);
    values[14] = vals[1];
    y[0] = 0.50000000*x[1][0] + 0.50000000*x[3][0];
    y[1] = 0.50000000*x[1][1] + 0.50000000*x[3][1];
    y[2] = 0.50000000*x[1][2] + 0.50000000*x[3][2];
    f.evaluate(vals, y, c);
    values[15] = vals[1];
    y[0] = 0.50000000*x[1][0] + 0.50000000*x[2][0];
    y[1] = 0.50000000*x[1][1] + 0.50000000*x[2][1];
    y[2] = 0.50000000*x[1][2] + 0.50000000*x[2][2];
    f.evaluate(vals, y, c);
    values[16] = vals[1];
    y[0] = 0.50000000*x[0][0] + 0.50000000*x[3][0];
    y[1] = 0.50000000*x[0][1] + 0.50000000*x[3][1];
    y[2] = 0.50000000*x[0][2] + 0.50000000*x[3][2];
    f.evaluate(vals, y, c);
    values[17] = vals[1];
    y[0] = 0.50000000*x[0][0] + 0.50000000*x[2][0];
    y[1] = 0.50000000*x[0][1] + 0.50000000*x[2][1];
    y[2] = 0.50000000*x[0][2] + 0.50000000*x[2][2];
    f.evaluate(vals, y, c);
    values[18] = vals[1];
    y[0] = 0.50000000*x[0][0] + 0.50000000*x[1][0];
    y[1] = 0.50000000*x[0][1] + 0.50000000*x[1][1];
    y[2] = 0.50000000*x[0][2] + 0.50000000*x[1][2];
    f.evaluate(vals, y, c);
    values[19] = vals[1];
    y[0] = x[0][0];
    y[1] = x[0][1];
    y[2] = x[0][2];
    f.evaluate(vals, y, c);
    values[20] = vals[2];
    y[0] = x[1][0];
    y[1] = x[1][1];
    y[2] = x[1][2];
    f.evaluate(vals, y, c);
    values[21] = vals[2];
    y[0] = x[2][0];
    y[1] = x[2][1];
    y[2] = x[2][2];
    f.evaluate(vals, y, c);
    values[22] = vals[2];
    y[0] = x[3][0];
    y[1] = x[3][1];
    y[2] = x[3][2];
    f.evaluate(vals, y, c);
    values[23] = vals[2];
    y[0] = 0.50000000*x[2][0] + 0.50000000*x[3][0];
    y[1] = 0.50000000*x[2][1] + 0.50000000*x[3][1];
    y[2] = 0.50000000*x[2][2] + 0.50000000*x[3][2];
    f.evaluate(vals, y, c);
    values[24] = vals[2];
    y[0] = 0.50000000*x[1][0] + 0.50000000*x[3][0];
    y[1] = 0.50000000*x[1][1] + 0.50000000*x[3][1];
    y[2] = 0.50000000*x[1][2] + 0.50000000*x[3][2];
    f.evaluate(vals, y, c);
    values[25] = vals[2];
    y[0] = 0.50000000*x[1][0] + 0.50000000*x[2][0];
    y[1] = 0.50000000*x[1][1] + 0.50000000*x[2][1];
    y[2] = 0.50000000*x[1][2] + 0.50000000*x[2][2];
    f.evaluate(vals, y, c);
    values[26] = vals[2];
    y[0] = 0.50000000*x[0][0] + 0.50000000*x[3][0];
    y[1] = 0.50000000*x[0][1] + 0.50000000*x[3][1];
    y[2] = 0.50000000*x[0][2] + 0.50000000*x[3][2];
    f.evaluate(vals, y, c);
    values[27] = vals[2];
    y[0] = 0.50000000*x[0][0] + 0.50000000*x[2][0];
    y[1] = 0.50000000*x[0][1] + 0.50000000*x[2][1];
    y[2] = 0.50000000*x[0][2] + 0.50000000*x[2][2];
    f.evaluate(vals, y, c);
    values[28] = vals[2];
    y[0] = 0.50000000*x[0][0] + 0.50000000*x[1][0];
    y[1] = 0.50000000*x[0][1] + 0.50000000*x[1][1];
    y[2] = 0.50000000*x[0][2] + 0.50000000*x[1][2];
    f.evaluate(vals, y, c);
    values[29] = vals[2];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[3] = dof_values[1];
    vertex_values[6] = dof_values[2];
    vertex_values[9] = dof_values[3];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[10];
    vertex_values[4] = dof_values[11];
    vertex_values[7] = dof_values[12];
    vertex_values[10] = dof_values[13];
    // Evaluate function and change variables
    vertex_values[2] = dof_values[20];
    vertex_values[5] = dof_values[21];
    vertex_values[8] = dof_values[22];
    vertex_values[11] = dof_values[23];
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 3;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new vectorlaplacegradcurl_finite_element_0();
        break;
      }
    case 1:
      {
        return new vectorlaplacegradcurl_finite_element_0();
        break;
      }
    case 2:
      {
        return new vectorlaplacegradcurl_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

};

/// This class defines the interface for a finite element.

class vectorlaplacegradcurl_finite_element_2: public ufc::finite_element
{
public:

  /// Constructor
  vectorlaplacegradcurl_finite_element_2() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vectorlaplacegradcurl_finite_element_2()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 4;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Reset values.
    *values = 0.00000000;
    
    // Map degree of freedom to element degree of freedom
    const unsigned int dof = i;
    
    // Array of basisvalues.
    double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
    
    // Declare helper variables.
    unsigned int rr = 0;
    unsigned int ss = 0;
    double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
    
    // Compute basisvalues.
    basisvalues[0] = 1.00000000;
    basisvalues[1] = tmp0;
    for (unsigned int r = 0; r < 1; r++)
    {
      rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
      ss = r*(r + 1)*(r + 2)/6;
      basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
    }// end loop over 'r'
    for (unsigned int r = 0; r < 1; r++)
    {
      for (unsigned int s = 0; s < 1 - r; s++)
      {
        rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
        ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 2; r++)
    {
      for (unsigned int s = 0; s < 2 - r; s++)
      {
        for (unsigned int t = 0; t < 2 - r - s; t++)
        {
          rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    
    // Table(s) of coefficients.
    static const double coefficients0[4][4] = \
    {{0.28867513, -0.18257419, -0.10540926, -0.07453560},
    {0.28867513, 0.18257419, -0.10540926, -0.07453560},
    {0.28867513, 0.00000000, 0.21081851, -0.07453560},
    {0.28867513, 0.00000000, 0.00000000, 0.22360680}};
    
    // Compute value(s).
    for (unsigned int r = 0; r < 4; r++)
    {
      *values += coefficients0[dof][r]*basisvalues[r];
    }// end loop over 'r'
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.00000000;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 4; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K_00, K_01, K_02}, {K_10, K_11, K_12}, {K_20, K_21, K_22}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.00000000;
    }// end loop over 'r'
    
    // Map degree of freedom to element degree of freedom
    const unsigned int dof = i;
    
    // Array of basisvalues.
    double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
    
    // Declare helper variables.
    unsigned int rr = 0;
    unsigned int ss = 0;
    double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
    
    // Compute basisvalues.
    basisvalues[0] = 1.00000000;
    basisvalues[1] = tmp0;
    for (unsigned int r = 0; r < 1; r++)
    {
      rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
      ss = r*(r + 1)*(r + 2)/6;
      basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
    }// end loop over 'r'
    for (unsigned int r = 0; r < 1; r++)
    {
      for (unsigned int s = 0; s < 1 - r; s++)
      {
        rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
        ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 2; r++)
    {
      for (unsigned int s = 0; s < 2 - r; s++)
      {
        for (unsigned int t = 0; t < 2 - r - s; t++)
        {
          rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    
    // Table(s) of coefficients.
    static const double coefficients0[4][4] = \
    {{0.28867513, -0.18257419, -0.10540926, -0.07453560},
    {0.28867513, 0.18257419, -0.10540926, -0.07453560},
    {0.28867513, 0.00000000, 0.21081851, -0.07453560},
    {0.28867513, 0.00000000, 0.00000000, 0.22360680}};
    
    // Tables of derivatives of the polynomial base (transpose).
    static const double dmats0[4][4] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {6.32455532, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
    
    static const double dmats1[4][4] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {3.16227766, 0.00000000, 0.00000000, 0.00000000},
    {5.47722558, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
    
    static const double dmats2[4][4] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {3.16227766, 0.00000000, 0.00000000, 0.00000000},
    {1.82574186, 0.00000000, 0.00000000, 0.00000000},
    {5.16397779, 0.00000000, 0.00000000, 0.00000000}};
    
    // Compute reference derivatives.
    // Declare pointer to array of derivatives on FIAT element.
    double *derivatives = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      derivatives[r] = 0.00000000;
    }// end loop over 'r'
    
    // Declare derivative matrix (of polynomial basis).
    double dmats[4][4] = \
    {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 1.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 1.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
    
    // Declare (auxiliary) derivative matrix (of polynomial basis).
    double dmats_old[4][4] = \
    {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 1.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 1.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
    
    // Loop possible derivatives.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      // Resetting dmats values to compute next derivative.
      for (unsigned int t = 0; t < 4; t++)
      {
        for (unsigned int u = 0; u < 4; u++)
        {
          dmats[t][u] = 0.00000000;
          if (t == u)
          {
          dmats[t][u] = 1.00000000;
          }
          
        }// end loop over 'u'
      }// end loop over 't'
      
      // Looping derivative order to generate dmats.
      for (unsigned int s = 0; s < n; s++)
      {
        // Updating dmats_old with new values and resetting dmats.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats_old[t][u] = dmats[t][u];
            dmats[t][u] = 0.00000000;
          }// end loop over 'u'
        }// end loop over 't'
        
        // Update dmats using an inner product.
        if (combinations[r][s] == 0)
        {
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            for (unsigned int tu = 0; tu < 4; tu++)
            {
              dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
        if (combinations[r][s] == 1)
        {
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            for (unsigned int tu = 0; tu < 4; tu++)
            {
              dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
        if (combinations[r][s] == 2)
        {
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            for (unsigned int tu = 0; tu < 4; tu++)
            {
              dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
      }// end loop over 's'
      for (unsigned int s = 0; s < 4; s++)
      {
        for (unsigned int t = 0; t < 4; t++)
        {
          derivatives[r] += coefficients0[dof][s]*dmats[s][t]*basisvalues[t];
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    
    // Transform derivatives back to physical element
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r] += transform[r][s]*derivatives[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer to array of derivatives on FIAT element
    delete [] derivatives;
    
    // Delete pointer to array of combinations of derivatives and transform
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] combinations[r];
    }// end loop over 'r'
    delete [] combinations;
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] transform[r];
    }// end loop over 'r'
    delete [] transform;
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.00000000;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 4; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      y[2] = x[0][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      y[2] = x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      y[2] = x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = x[3][0];
      y[1] = x[3][1];
      y[2] = x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.00000000;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    y[2] = x[0][2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    y[2] = x[1][2];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    y[2] = x[2][2];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = x[3][0];
    y[1] = x[3][1];
    y[2] = x[3][2];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
    vertex_values[3] = dof_values[3];
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for a finite element.

class vectorlaplacegradcurl_finite_element_3: public ufc::finite_element
{
public:

  /// Constructor
  vectorlaplacegradcurl_finite_element_3() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vectorlaplacegradcurl_finite_element_3()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 6;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 1;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return 3;
        break;
      }
    }
    
    return 0;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Reset values.
    values[0] = 0.00000000;
    values[1] = 0.00000000;
    values[2] = 0.00000000;
    
    // Map degree of freedom to element degree of freedom
    const unsigned int dof = i;
    
    // Array of basisvalues.
    double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
    
    // Declare helper variables.
    unsigned int rr = 0;
    unsigned int ss = 0;
    double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
    
    // Compute basisvalues.
    basisvalues[0] = 1.00000000;
    basisvalues[1] = tmp0;
    for (unsigned int r = 0; r < 1; r++)
    {
      rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
      ss = r*(r + 1)*(r + 2)/6;
      basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
    }// end loop over 'r'
    for (unsigned int r = 0; r < 1; r++)
    {
      for (unsigned int s = 0; s < 1 - r; s++)
      {
        rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
        ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 2; r++)
    {
      for (unsigned int s = 0; s < 2 - r; s++)
      {
        for (unsigned int t = 0; t < 2 - r - s; t++)
        {
          rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    
    // Table(s) of coefficients.
    static const double coefficients0[6][4] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-0.28867513, 0.00000000, 0.00000000, -0.22360680},
    {-0.28867513, 0.00000000, -0.21081851, 0.07453560},
    {0.28867513, 0.00000000, 0.00000000, 0.22360680},
    {0.28867513, 0.00000000, 0.21081851, -0.07453560},
    {0.57735027, 0.00000000, -0.21081851, -0.14907120}};
    
    static const double coefficients1[6][4] = \
    {{-0.28867513, 0.00000000, 0.00000000, -0.22360680},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.28867513, 0.18257419, -0.10540926, -0.07453560},
    {0.28867513, 0.00000000, 0.00000000, 0.22360680},
    {0.57735027, -0.18257419, 0.10540926, -0.14907120},
    {0.28867513, 0.18257419, -0.10540926, -0.07453560}};
    
    static const double coefficients2[6][4] = \
    {{0.28867513, 0.00000000, 0.21081851, -0.07453560},
    {0.28867513, 0.18257419, -0.10540926, -0.07453560},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.57735027, -0.18257419, -0.10540926, 0.14907120},
    {0.28867513, 0.00000000, 0.21081851, -0.07453560},
    {0.28867513, 0.18257419, -0.10540926, -0.07453560}};
    
    // Compute value(s).
    for (unsigned int r = 0; r < 4; r++)
    {
      values[0] += coefficients0[dof][r]*basisvalues[r];
      values[1] += coefficients1[dof][r]*basisvalues[r];
      values[2] += coefficients2[dof][r]*basisvalues[r];
    }// end loop over 'r'
    
    // Using covariant Piola transform to map values back to the physical element.
    const double tmp_ref0 = values[0];
    const double tmp_ref1 = values[1];
    const double tmp_ref2 = values[2];
    values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1 + K_20*tmp_ref2);
    values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1 + K_21*tmp_ref2);
    values[2] = (K_02*tmp_ref0 + K_12*tmp_ref1 + K_22*tmp_ref2);
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values[3] = {0.00000000, 0.00000000, 0.00000000};
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 6; r++)
    {
      evaluate_basis(r, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 3; s++)
      {
        values[r*3 + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K_00, K_01, K_02}, {K_10, K_11, K_12}, {K_20, K_21, K_22}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 3*num_derivatives; r++)
    {
      values[r] = 0.00000000;
    }// end loop over 'r'
    
    // Map degree of freedom to element degree of freedom
    const unsigned int dof = i;
    
    // Array of basisvalues.
    double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
    
    // Declare helper variables.
    unsigned int rr = 0;
    unsigned int ss = 0;
    double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
    
    // Compute basisvalues.
    basisvalues[0] = 1.00000000;
    basisvalues[1] = tmp0;
    for (unsigned int r = 0; r < 1; r++)
    {
      rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
      ss = r*(r + 1)*(r + 2)/6;
      basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
    }// end loop over 'r'
    for (unsigned int r = 0; r < 1; r++)
    {
      for (unsigned int s = 0; s < 1 - r; s++)
      {
        rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
        ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
      }// end loop over 's'
    }// end loop over 'r'
    for (unsigned int r = 0; r < 2; r++)
    {
      for (unsigned int s = 0; s < 2 - r; s++)
      {
        for (unsigned int t = 0; t < 2 - r - s; t++)
        {
          rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    
    // Table(s) of coefficients.
    static const double coefficients0[6][4] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-0.28867513, 0.00000000, 0.00000000, -0.22360680},
    {-0.28867513, 0.00000000, -0.21081851, 0.07453560},
    {0.28867513, 0.00000000, 0.00000000, 0.22360680},
    {0.28867513, 0.00000000, 0.21081851, -0.07453560},
    {0.57735027, 0.00000000, -0.21081851, -0.14907120}};
    
    static const double coefficients1[6][4] = \
    {{-0.28867513, 0.00000000, 0.00000000, -0.22360680},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.28867513, 0.18257419, -0.10540926, -0.07453560},
    {0.28867513, 0.00000000, 0.00000000, 0.22360680},
    {0.57735027, -0.18257419, 0.10540926, -0.14907120},
    {0.28867513, 0.18257419, -0.10540926, -0.07453560}};
    
    static const double coefficients2[6][4] = \
    {{0.28867513, 0.00000000, 0.21081851, -0.07453560},
    {0.28867513, 0.18257419, -0.10540926, -0.07453560},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.57735027, -0.18257419, -0.10540926, 0.14907120},
    {0.28867513, 0.00000000, 0.21081851, -0.07453560},
    {0.28867513, 0.18257419, -0.10540926, -0.07453560}};
    
    // Tables of derivatives of the polynomial base (transpose).
    static const double dmats0[4][4] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {6.32455532, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
    
    static const double dmats1[4][4] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {3.16227766, 0.00000000, 0.00000000, 0.00000000},
    {5.47722558, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
    
    static const double dmats2[4][4] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {3.16227766, 0.00000000, 0.00000000, 0.00000000},
    {1.82574186, 0.00000000, 0.00000000, 0.00000000},
    {5.16397779, 0.00000000, 0.00000000, 0.00000000}};
    
    // Compute reference derivatives.
    // Declare pointer to array of derivatives on FIAT element.
    double *derivatives = new double[3*num_derivatives];
    for (unsigned int r = 0; r < 3*num_derivatives; r++)
    {
      derivatives[r] = 0.00000000;
    }// end loop over 'r'
    
    // Declare derivative matrix (of polynomial basis).
    double dmats[4][4] = \
    {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 1.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 1.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
    
    // Declare (auxiliary) derivative matrix (of polynomial basis).
    double dmats_old[4][4] = \
    {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 1.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 1.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
    
    // Loop possible derivatives.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      // Resetting dmats values to compute next derivative.
      for (unsigned int t = 0; t < 4; t++)
      {
        for (unsigned int u = 0; u < 4; u++)
        {
          dmats[t][u] = 0.00000000;
          if (t == u)
          {
          dmats[t][u] = 1.00000000;
          }
          
        }// end loop over 'u'
      }// end loop over 't'
      
      // Looping derivative order to generate dmats.
      for (unsigned int s = 0; s < n; s++)
      {
        // Updating dmats_old with new values and resetting dmats.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats_old[t][u] = dmats[t][u];
            dmats[t][u] = 0.00000000;
          }// end loop over 'u'
        }// end loop over 't'
        
        // Update dmats using an inner product.
        if (combinations[r][s] == 0)
        {
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            for (unsigned int tu = 0; tu < 4; tu++)
            {
              dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
        if (combinations[r][s] == 1)
        {
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            for (unsigned int tu = 0; tu < 4; tu++)
            {
              dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
        if (combinations[r][s] == 2)
        {
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            for (unsigned int tu = 0; tu < 4; tu++)
            {
              dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
      }// end loop over 's'
      for (unsigned int s = 0; s < 4; s++)
      {
        for (unsigned int t = 0; t < 4; t++)
        {
          derivatives[r] += coefficients0[dof][s]*dmats[s][t]*basisvalues[t];
          derivatives[num_derivatives + r] += coefficients1[dof][s]*dmats[s][t]*basisvalues[t];
          derivatives[2*num_derivatives + r] += coefficients2[dof][s]*dmats[s][t]*basisvalues[t];
        }// end loop over 't'
      }// end loop over 's'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = derivatives[r];
      const double tmp_ref1 = derivatives[num_derivatives + r];
      const double tmp_ref2 = derivatives[2*num_derivatives + r];
      derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1 + K_20*tmp_ref2);
      derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1 + K_21*tmp_ref2);
      derivatives[2*num_derivatives + r] = (K_02*tmp_ref0 + K_12*tmp_ref1 + K_22*tmp_ref2);
    }// end loop over 'r'
    
    // Transform derivatives back to physical element
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r] += transform[r][s]*derivatives[s];
        values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        values[2*num_derivatives + r] += transform[r][s]*derivatives[2*num_derivatives + s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer to array of derivatives on FIAT element
    delete [] derivatives;
    
    // Delete pointer to array of combinations of derivatives and transform
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] combinations[r];
    }// end loop over 'r'
    delete [] combinations;
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] transform[r];
    }// end loop over 'r'
    delete [] transform;
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[3*num_derivatives];
    for (unsigned int r = 0; r < 3*num_derivatives; r++)
    {
      dof_values[r] = 0.00000000;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 6; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 3*num_derivatives; s++)
      {
        values[r*3*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[3];
    
    // Declare variable for physical coordinates.
    double y[3];
    double result;
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];switch (i)
    {
    case 0:
      {
        y[0] = 0.50000000*x[2][0] + 0.50000000*x[3][0];
      y[1] = 0.50000000*x[2][1] + 0.50000000*x[3][1];
      y[2] = 0.50000000*x[2][2] + 0.50000000*x[3][2];
      f.evaluate(vals, y, c);
      result = (-1.0)*(J_01*vals[0] + J_11*vals[1] + J_21*vals[2]) + (J_02*vals[0] + J_12*vals[1] + J_22*vals[2]);
      return result;
        break;
      }
    case 1:
      {
        y[0] = 0.50000000*x[1][0] + 0.50000000*x[3][0];
      y[1] = 0.50000000*x[1][1] + 0.50000000*x[3][1];
      y[2] = 0.50000000*x[1][2] + 0.50000000*x[3][2];
      f.evaluate(vals, y, c);
      result = (-1.0)*(J_00*vals[0] + J_10*vals[1] + J_20*vals[2]) + (J_02*vals[0] + J_12*vals[1] + J_22*vals[2]);
      return result;
        break;
      }
    case 2:
      {
        y[0] = 0.50000000*x[1][0] + 0.50000000*x[2][0];
      y[1] = 0.50000000*x[1][1] + 0.50000000*x[2][1];
      y[2] = 0.50000000*x[1][2] + 0.50000000*x[2][2];
      f.evaluate(vals, y, c);
      result = (-1.0)*(J_00*vals[0] + J_10*vals[1] + J_20*vals[2]) + (J_01*vals[0] + J_11*vals[1] + J_21*vals[2]);
      return result;
        break;
      }
    case 3:
      {
        y[0] = 0.50000000*x[0][0] + 0.50000000*x[3][0];
      y[1] = 0.50000000*x[0][1] + 0.50000000*x[3][1];
      y[2] = 0.50000000*x[0][2] + 0.50000000*x[3][2];
      f.evaluate(vals, y, c);
      result = (J_02*vals[0] + J_12*vals[1] + J_22*vals[2]);
      return result;
        break;
      }
    case 4:
      {
        y[0] = 0.50000000*x[0][0] + 0.50000000*x[2][0];
      y[1] = 0.50000000*x[0][1] + 0.50000000*x[2][1];
      y[2] = 0.50000000*x[0][2] + 0.50000000*x[2][2];
      f.evaluate(vals, y, c);
      result = (J_01*vals[0] + J_11*vals[1] + J_21*vals[2]);
      return result;
        break;
      }
    case 5:
      {
        y[0] = 0.50000000*x[0][0] + 0.50000000*x[1][0];
      y[1] = 0.50000000*x[0][1] + 0.50000000*x[1][1];
      y[2] = 0.50000000*x[0][2] + 0.50000000*x[1][2];
      f.evaluate(vals, y, c);
      result = (J_00*vals[0] + J_10*vals[1] + J_20*vals[2]);
      return result;
        break;
      }
    }
    
    return 0.00000000;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[3];
    
    // Declare variable for physical coordinates.
    double y[3];
    double result;
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];y[0] = 0.50000000*x[2][0] + 0.50000000*x[3][0];
    y[1] = 0.50000000*x[2][1] + 0.50000000*x[3][1];
    y[2] = 0.50000000*x[2][2] + 0.50000000*x[3][2];
    f.evaluate(vals, y, c);
    result = (-1.0)*(J_01*vals[0] + J_11*vals[1] + J_21*vals[2]) + (J_02*vals[0] + J_12*vals[1] + J_22*vals[2]);
    values[0] = result;
    y[0] = 0.50000000*x[1][0] + 0.50000000*x[3][0];
    y[1] = 0.50000000*x[1][1] + 0.50000000*x[3][1];
    y[2] = 0.50000000*x[1][2] + 0.50000000*x[3][2];
    f.evaluate(vals, y, c);
    result = (-1.0)*(J_00*vals[0] + J_10*vals[1] + J_20*vals[2]) + (J_02*vals[0] + J_12*vals[1] + J_22*vals[2]);
    values[1] = result;
    y[0] = 0.50000000*x[1][0] + 0.50000000*x[2][0];
    y[1] = 0.50000000*x[1][1] + 0.50000000*x[2][1];
    y[2] = 0.50000000*x[1][2] + 0.50000000*x[2][2];
    f.evaluate(vals, y, c);
    result = (-1.0)*(J_00*vals[0] + J_10*vals[1] + J_20*vals[2]) + (J_01*vals[0] + J_11*vals[1] + J_21*vals[2]);
    values[2] = result;
    y[0] = 0.50000000*x[0][0] + 0.50000000*x[3][0];
    y[1] = 0.50000000*x[0][1] + 0.50000000*x[3][1];
    y[2] = 0.50000000*x[0][2] + 0.50000000*x[3][2];
    f.evaluate(vals, y, c);
    result = (J_02*vals[0] + J_12*vals[1] + J_22*vals[2]);
    values[3] = result;
    y[0] = 0.50000000*x[0][0] + 0.50000000*x[2][0];
    y[1] = 0.50000000*x[0][1] + 0.50000000*x[2][1];
    y[2] = 0.50000000*x[0][2] + 0.50000000*x[2][2];
    f.evaluate(vals, y, c);
    result = (J_01*vals[0] + J_11*vals[1] + J_21*vals[2]);
    values[4] = result;
    y[0] = 0.50000000*x[0][0] + 0.50000000*x[1][0];
    y[1] = 0.50000000*x[0][1] + 0.50000000*x[1][1];
    y[2] = 0.50000000*x[0][2] + 0.50000000*x[1][2];
    f.evaluate(vals, y, c);
    result = (J_00*vals[0] + J_10*vals[1] + J_20*vals[2]);
    values[5] = result;
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    // Evaluate function and change variables
    vertex_values[0] = dof_values[3]*K_20 + dof_values[4]*K_10 + dof_values[5]*K_00;
    vertex_values[3] = dof_values[1]*K_20 + dof_values[2]*K_10 + dof_values[5]*(K_00 + K_10 + K_20);
    vertex_values[6] = dof_values[0]*K_20 + dof_values[2]*(K_00*(-1.0)) + dof_values[4]*(K_00 + K_10 + K_20);
    vertex_values[9] = dof_values[0]*(K_10*(-1.0)) + dof_values[1]*(K_00*(-1.0)) + dof_values[3]*(K_00 + K_10 + K_20);
    vertex_values[1] = dof_values[3]*K_21 + dof_values[4]*K_11 + dof_values[5]*K_01;
    vertex_values[4] = dof_values[1]*K_21 + dof_values[2]*K_11 + dof_values[5]*(K_01 + K_11 + K_21);
    vertex_values[7] = dof_values[0]*K_21 + dof_values[2]*(K_01*(-1.0)) + dof_values[4]*(K_01 + K_11 + K_21);
    vertex_values[10] = dof_values[0]*(K_11*(-1.0)) + dof_values[1]*(K_01*(-1.0)) + dof_values[3]*(K_01 + K_11 + K_21);
    vertex_values[2] = dof_values[3]*K_22 + dof_values[4]*K_12 + dof_values[5]*K_02;
    vertex_values[5] = dof_values[1]*K_22 + dof_values[2]*K_12 + dof_values[5]*(K_02 + K_12 + K_22);
    vertex_values[8] = dof_values[0]*K_22 + dof_values[2]*(K_02*(-1.0)) + dof_values[4]*(K_02 + K_12 + K_22);
    vertex_values[11] = dof_values[0]*(K_12*(-1.0)) + dof_values[1]*(K_02*(-1.0)) + dof_values[3]*(K_02 + K_12 + K_22);
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for a finite element.

class vectorlaplacegradcurl_finite_element_4: public ufc::finite_element
{
public:

  /// Constructor
  vectorlaplacegradcurl_finite_element_4() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vectorlaplacegradcurl_finite_element_4()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1), FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)], **{'value_shape': (4,) })";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 10;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 1;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return 4;
        break;
      }
    }
    
    return 0;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Reset values.
    values[0] = 0.00000000;
    values[1] = 0.00000000;
    values[2] = 0.00000000;
    values[3] = 0.00000000;
    if (0 <= i && i <= 3)
    {
      // Map degree of freedom to element degree of freedom
      const unsigned int dof = i;
      
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4][4] = \
      {{0.28867513, -0.18257419, -0.10540926, -0.07453560},
      {0.28867513, 0.18257419, -0.10540926, -0.07453560},
      {0.28867513, 0.00000000, 0.21081851, -0.07453560},
      {0.28867513, 0.00000000, 0.00000000, 0.22360680}};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[dof][r]*basisvalues[r];
      }// end loop over 'r'
    }
    
    if (4 <= i && i <= 9)
    {
      // Map degree of freedom to element degree of freedom
      const unsigned int dof = i - 4;
      
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[6][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-0.28867513, 0.00000000, 0.00000000, -0.22360680},
      {-0.28867513, 0.00000000, -0.21081851, 0.07453560},
      {0.28867513, 0.00000000, 0.00000000, 0.22360680},
      {0.28867513, 0.00000000, 0.21081851, -0.07453560},
      {0.57735027, 0.00000000, -0.21081851, -0.14907120}};
      
      static const double coefficients1[6][4] = \
      {{-0.28867513, 0.00000000, 0.00000000, -0.22360680},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.28867513, 0.18257419, -0.10540926, -0.07453560},
      {0.28867513, 0.00000000, 0.00000000, 0.22360680},
      {0.57735027, -0.18257419, 0.10540926, -0.14907120},
      {0.28867513, 0.18257419, -0.10540926, -0.07453560}};
      
      static const double coefficients2[6][4] = \
      {{0.28867513, 0.00000000, 0.21081851, -0.07453560},
      {0.28867513, 0.18257419, -0.10540926, -0.07453560},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.57735027, -0.18257419, -0.10540926, 0.14907120},
      {0.28867513, 0.00000000, 0.21081851, -0.07453560},
      {0.28867513, 0.18257419, -0.10540926, -0.07453560}};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[dof][r]*basisvalues[r];
        values[2] += coefficients1[dof][r]*basisvalues[r];
        values[3] += coefficients2[dof][r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[1];
      const double tmp_ref1 = values[2];
      const double tmp_ref2 = values[3];
      values[1] = (K_00*tmp_ref0 + K_10*tmp_ref1 + K_20*tmp_ref2);
      values[2] = (K_01*tmp_ref0 + K_11*tmp_ref1 + K_21*tmp_ref2);
      values[3] = (K_02*tmp_ref0 + K_12*tmp_ref1 + K_22*tmp_ref2);
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis(r, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 4; s++)
      {
        values[r*4 + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K_00, K_01, K_02}, {K_10, K_11, K_12}, {K_20, K_21, K_22}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 4*num_derivatives; r++)
    {
      values[r] = 0.00000000;
    }// end loop over 'r'
    
    if (0 <= i && i <= 3)
    {
      // Map degree of freedom to element degree of freedom
      const unsigned int dof = i;
      
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4][4] = \
      {{0.28867513, -0.18257419, -0.10540926, -0.07453560},
      {0.28867513, 0.18257419, -0.10540926, -0.07453560},
      {0.28867513, 0.00000000, 0.21081851, -0.07453560},
      {0.28867513, 0.00000000, 0.00000000, 0.22360680}};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[dof][s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
    }
    
    if (4 <= i && i <= 9)
    {
      // Map degree of freedom to element degree of freedom
      const unsigned int dof = i - 4;
      
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[6][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-0.28867513, 0.00000000, 0.00000000, -0.22360680},
      {-0.28867513, 0.00000000, -0.21081851, 0.07453560},
      {0.28867513, 0.00000000, 0.00000000, 0.22360680},
      {0.28867513, 0.00000000, 0.21081851, -0.07453560},
      {0.57735027, 0.00000000, -0.21081851, -0.14907120}};
      
      static const double coefficients1[6][4] = \
      {{-0.28867513, 0.00000000, 0.00000000, -0.22360680},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.28867513, 0.18257419, -0.10540926, -0.07453560},
      {0.28867513, 0.00000000, 0.00000000, 0.22360680},
      {0.57735027, -0.18257419, 0.10540926, -0.14907120},
      {0.28867513, 0.18257419, -0.10540926, -0.07453560}};
      
      static const double coefficients2[6][4] = \
      {{0.28867513, 0.00000000, 0.21081851, -0.07453560},
      {0.28867513, 0.18257419, -0.10540926, -0.07453560},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.57735027, -0.18257419, -0.10540926, 0.14907120},
      {0.28867513, 0.00000000, 0.21081851, -0.07453560},
      {0.28867513, 0.18257419, -0.10540926, -0.07453560}};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[3*num_derivatives];
      for (unsigned int r = 0; r < 3*num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[dof][s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[dof][s]*dmats[s][t]*basisvalues[t];
            derivatives[2*num_derivatives + r] += coefficients2[dof][s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        const double tmp_ref2 = derivatives[2*num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1 + K_20*tmp_ref2);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1 + K_21*tmp_ref2);
        derivatives[2*num_derivatives + r] = (K_02*tmp_ref0 + K_12*tmp_ref1 + K_22*tmp_ref2);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
          values[2*num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
          values[3*num_derivatives + r] += transform[r][s]*derivatives[2*num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[4*num_derivatives];
    for (unsigned int r = 0; r < 4*num_derivatives; r++)
    {
      dof_values[r] = 0.00000000;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 4*num_derivatives; s++)
      {
        values[r*4*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[4];
    
    // Declare variable for physical coordinates.
    double y[3];
    double result;
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      y[2] = x[0][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      y[2] = x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      y[2] = x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = x[3][0];
      y[1] = x[3][1];
      y[2] = x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.50000000*x[2][0] + 0.50000000*x[3][0];
      y[1] = 0.50000000*x[2][1] + 0.50000000*x[3][1];
      y[2] = 0.50000000*x[2][2] + 0.50000000*x[3][2];
      f.evaluate(vals, y, c);
      result = (-1.0)*(J_01*vals[1] + J_11*vals[2] + J_21*vals[3]) + (J_02*vals[1] + J_12*vals[2] + J_22*vals[3]);
      return result;
        break;
      }
    case 5:
      {
        y[0] = 0.50000000*x[1][0] + 0.50000000*x[3][0];
      y[1] = 0.50000000*x[1][1] + 0.50000000*x[3][1];
      y[2] = 0.50000000*x[1][2] + 0.50000000*x[3][2];
      f.evaluate(vals, y, c);
      result = (-1.0)*(J_00*vals[1] + J_10*vals[2] + J_20*vals[3]) + (J_02*vals[1] + J_12*vals[2] + J_22*vals[3]);
      return result;
        break;
      }
    case 6:
      {
        y[0] = 0.50000000*x[1][0] + 0.50000000*x[2][0];
      y[1] = 0.50000000*x[1][1] + 0.50000000*x[2][1];
      y[2] = 0.50000000*x[1][2] + 0.50000000*x[2][2];
      f.evaluate(vals, y, c);
      result = (-1.0)*(J_00*vals[1] + J_10*vals[2] + J_20*vals[3]) + (J_01*vals[1] + J_11*vals[2] + J_21*vals[3]);
      return result;
        break;
      }
    case 7:
      {
        y[0] = 0.50000000*x[0][0] + 0.50000000*x[3][0];
      y[1] = 0.50000000*x[0][1] + 0.50000000*x[3][1];
      y[2] = 0.50000000*x[0][2] + 0.50000000*x[3][2];
      f.evaluate(vals, y, c);
      result = (J_02*vals[1] + J_12*vals[2] + J_22*vals[3]);
      return result;
        break;
      }
    case 8:
      {
        y[0] = 0.50000000*x[0][0] + 0.50000000*x[2][0];
      y[1] = 0.50000000*x[0][1] + 0.50000000*x[2][1];
      y[2] = 0.50000000*x[0][2] + 0.50000000*x[2][2];
      f.evaluate(vals, y, c);
      result = (J_01*vals[1] + J_11*vals[2] + J_21*vals[3]);
      return result;
        break;
      }
    case 9:
      {
        y[0] = 0.50000000*x[0][0] + 0.50000000*x[1][0];
      y[1] = 0.50000000*x[0][1] + 0.50000000*x[1][1];
      y[2] = 0.50000000*x[0][2] + 0.50000000*x[1][2];
      f.evaluate(vals, y, c);
      result = (J_00*vals[1] + J_10*vals[2] + J_20*vals[3]);
      return result;
        break;
      }
    }
    
    return 0.00000000;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[4];
    
    // Declare variable for physical coordinates.
    double y[3];
    double result;
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];y[0] = x[0][0];
    y[1] = x[0][1];
    y[2] = x[0][2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    y[2] = x[1][2];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    y[2] = x[2][2];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = x[3][0];
    y[1] = x[3][1];
    y[2] = x[3][2];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.50000000*x[2][0] + 0.50000000*x[3][0];
    y[1] = 0.50000000*x[2][1] + 0.50000000*x[3][1];
    y[2] = 0.50000000*x[2][2] + 0.50000000*x[3][2];
    f.evaluate(vals, y, c);
    result = (-1.0)*(J_01*vals[1] + J_11*vals[2] + J_21*vals[3]) + (J_02*vals[1] + J_12*vals[2] + J_22*vals[3]);
    values[4] = result;
    y[0] = 0.50000000*x[1][0] + 0.50000000*x[3][0];
    y[1] = 0.50000000*x[1][1] + 0.50000000*x[3][1];
    y[2] = 0.50000000*x[1][2] + 0.50000000*x[3][2];
    f.evaluate(vals, y, c);
    result = (-1.0)*(J_00*vals[1] + J_10*vals[2] + J_20*vals[3]) + (J_02*vals[1] + J_12*vals[2] + J_22*vals[3]);
    values[5] = result;
    y[0] = 0.50000000*x[1][0] + 0.50000000*x[2][0];
    y[1] = 0.50000000*x[1][1] + 0.50000000*x[2][1];
    y[2] = 0.50000000*x[1][2] + 0.50000000*x[2][2];
    f.evaluate(vals, y, c);
    result = (-1.0)*(J_00*vals[1] + J_10*vals[2] + J_20*vals[3]) + (J_01*vals[1] + J_11*vals[2] + J_21*vals[3]);
    values[6] = result;
    y[0] = 0.50000000*x[0][0] + 0.50000000*x[3][0];
    y[1] = 0.50000000*x[0][1] + 0.50000000*x[3][1];
    y[2] = 0.50000000*x[0][2] + 0.50000000*x[3][2];
    f.evaluate(vals, y, c);
    result = (J_02*vals[1] + J_12*vals[2] + J_22*vals[3]);
    values[7] = result;
    y[0] = 0.50000000*x[0][0] + 0.50000000*x[2][0];
    y[1] = 0.50000000*x[0][1] + 0.50000000*x[2][1];
    y[2] = 0.50000000*x[0][2] + 0.50000000*x[2][2];
    f.evaluate(vals, y, c);
    result = (J_01*vals[1] + J_11*vals[2] + J_21*vals[3]);
    values[8] = result;
    y[0] = 0.50000000*x[0][0] + 0.50000000*x[1][0];
    y[1] = 0.50000000*x[0][1] + 0.50000000*x[1][1];
    y[2] = 0.50000000*x[0][2] + 0.50000000*x[1][2];
    f.evaluate(vals, y, c);
    result = (J_00*vals[1] + J_10*vals[2] + J_20*vals[3]);
    values[9] = result;
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[4] = dof_values[1];
    vertex_values[8] = dof_values[2];
    vertex_values[12] = dof_values[3];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[7]*K_20 + dof_values[8]*K_10 + dof_values[9]*K_00;
    vertex_values[5] = dof_values[5]*K_20 + dof_values[6]*K_10 + dof_values[9]*(K_00 + K_10 + K_20);
    vertex_values[9] = dof_values[4]*K_20 + dof_values[6]*(K_00*(-1.0)) + dof_values[8]*(K_00 + K_10 + K_20);
    vertex_values[13] = dof_values[4]*(K_10*(-1.0)) + dof_values[5]*(K_00*(-1.0)) + dof_values[7]*(K_00 + K_10 + K_20);
    vertex_values[2] = dof_values[7]*K_21 + dof_values[8]*K_11 + dof_values[9]*K_01;
    vertex_values[6] = dof_values[5]*K_21 + dof_values[6]*K_11 + dof_values[9]*(K_01 + K_11 + K_21);
    vertex_values[10] = dof_values[4]*K_21 + dof_values[6]*(K_01*(-1.0)) + dof_values[8]*(K_01 + K_11 + K_21);
    vertex_values[14] = dof_values[4]*(K_11*(-1.0)) + dof_values[5]*(K_01*(-1.0)) + dof_values[7]*(K_01 + K_11 + K_21);
    vertex_values[3] = dof_values[7]*K_22 + dof_values[8]*K_12 + dof_values[9]*K_02;
    vertex_values[7] = dof_values[5]*K_22 + dof_values[6]*K_12 + dof_values[9]*(K_02 + K_12 + K_22);
    vertex_values[11] = dof_values[4]*K_22 + dof_values[6]*(K_02*(-1.0)) + dof_values[8]*(K_02 + K_12 + K_22);
    vertex_values[15] = dof_values[4]*(K_12*(-1.0)) + dof_values[5]*(K_02*(-1.0)) + dof_values[7]*(K_02 + K_12 + K_22);
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 2;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new vectorlaplacegradcurl_finite_element_2();
        break;
      }
    case 1:
      {
        return new vectorlaplacegradcurl_finite_element_3();
        break;
      }
    }
    
    return 0;
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class vectorlaplacegradcurl_dof_map_0: public ufc::dof_map
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  vectorlaplacegradcurl_dof_map_0() : ufc::dof_map()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~vectorlaplacegradcurl_dof_map_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dof map
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 2)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dof map for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + m.num_entities[1];
    return false;
  }

  /// Initialize dof map for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dof map for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 10;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 10;
  }

  // Return the geometric dimension of the coordinates this dof map provides
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 6;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 1;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    dofs[3] = offset + c.entity_indices[0][3];
    offset += m.num_entities[0];
    dofs[4] = offset + c.entity_indices[1][0];
    dofs[5] = offset + c.entity_indices[1][1];
    dofs[6] = offset + c.entity_indices[1][2];
    dofs[7] = offset + c.entity_indices[1][3];
    dofs[8] = offset + c.entity_indices[1][4];
    dofs[9] = offset + c.entity_indices[1][5];
    offset += m.num_entities[1];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 7;
      dofs[5] = 8;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 5;
      dofs[4] = 7;
      dofs[5] = 9;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 6;
      dofs[4] = 8;
      dofs[5] = 9;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 3)
    {
    std::cerr << "*** FFC warning: " << "d is larger than dimension (3)" << std::endl;
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (3)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 5)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (5)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 4;
          break;
        }
      case 1:
        {
          dofs[0] = 5;
          break;
        }
      case 2:
        {
          dofs[0] = 6;
          break;
        }
      case 3:
        {
          dofs[0] = 7;
          break;
        }
      case 4:
        {
          dofs[0] = 8;
          break;
        }
      case 5:
        {
          dofs[0] = 9;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[0][2] = x[0][2];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[1][2] = x[1][2];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[2][2] = x[2][2];
    coordinates[3][0] = x[3][0];
    coordinates[3][1] = x[3][1];
    coordinates[3][2] = x[3][2];
    coordinates[4][0] = 0.50000000*x[2][0] + 0.50000000*x[3][0];
    coordinates[4][1] = 0.50000000*x[2][1] + 0.50000000*x[3][1];
    coordinates[4][2] = 0.50000000*x[2][2] + 0.50000000*x[3][2];
    coordinates[5][0] = 0.50000000*x[1][0] + 0.50000000*x[3][0];
    coordinates[5][1] = 0.50000000*x[1][1] + 0.50000000*x[3][1];
    coordinates[5][2] = 0.50000000*x[1][2] + 0.50000000*x[3][2];
    coordinates[6][0] = 0.50000000*x[1][0] + 0.50000000*x[2][0];
    coordinates[6][1] = 0.50000000*x[1][1] + 0.50000000*x[2][1];
    coordinates[6][2] = 0.50000000*x[1][2] + 0.50000000*x[2][2];
    coordinates[7][0] = 0.50000000*x[0][0] + 0.50000000*x[3][0];
    coordinates[7][1] = 0.50000000*x[0][1] + 0.50000000*x[3][1];
    coordinates[7][2] = 0.50000000*x[0][2] + 0.50000000*x[3][2];
    coordinates[8][0] = 0.50000000*x[0][0] + 0.50000000*x[2][0];
    coordinates[8][1] = 0.50000000*x[0][1] + 0.50000000*x[2][1];
    coordinates[8][2] = 0.50000000*x[0][2] + 0.50000000*x[2][2];
    coordinates[9][0] = 0.50000000*x[0][0] + 0.50000000*x[1][0];
    coordinates[9][1] = 0.50000000*x[0][1] + 0.50000000*x[1][1];
    coordinates[9][2] = 0.50000000*x[0][2] + 0.50000000*x[1][2];
  }

  /// Return the number of sub dof maps (for a mixed element)
  virtual unsigned int num_sub_dof_maps() const
  {
    return 0;
  }

  /// Create a new dof_map for sub dof map i (for a mixed element)
  virtual ufc::dof_map* create_sub_dof_map(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class vectorlaplacegradcurl_dof_map_1: public ufc::dof_map
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  vectorlaplacegradcurl_dof_map_1() : ufc::dof_map()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~vectorlaplacegradcurl_dof_map_1()
  {
    // Do nothing
  }

  /// Return a string identifying the dof map
  virtual const char* signature() const
  {
    return "FFC dofmap for VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 2, 3)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dof map for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = 3.00000000*m.num_entities[0] + 3.00000000*m.num_entities[1];
    return false;
  }

  /// Initialize dof map for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dof map for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 30;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 30;
  }

  // Return the geometric dimension of the coordinates this dof map provides
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 18;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 3;
        break;
      }
    case 1:
      {
        return 3;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    dofs[3] = offset + c.entity_indices[0][3];
    offset += m.num_entities[0];
    dofs[4] = offset + c.entity_indices[1][0];
    dofs[5] = offset + c.entity_indices[1][1];
    dofs[6] = offset + c.entity_indices[1][2];
    dofs[7] = offset + c.entity_indices[1][3];
    dofs[8] = offset + c.entity_indices[1][4];
    dofs[9] = offset + c.entity_indices[1][5];
    offset += m.num_entities[1];
    dofs[10] = offset + c.entity_indices[0][0];
    dofs[11] = offset + c.entity_indices[0][1];
    dofs[12] = offset + c.entity_indices[0][2];
    dofs[13] = offset + c.entity_indices[0][3];
    offset += m.num_entities[0];
    dofs[14] = offset + c.entity_indices[1][0];
    dofs[15] = offset + c.entity_indices[1][1];
    dofs[16] = offset + c.entity_indices[1][2];
    dofs[17] = offset + c.entity_indices[1][3];
    dofs[18] = offset + c.entity_indices[1][4];
    dofs[19] = offset + c.entity_indices[1][5];
    offset += m.num_entities[1];
    dofs[20] = offset + c.entity_indices[0][0];
    dofs[21] = offset + c.entity_indices[0][1];
    dofs[22] = offset + c.entity_indices[0][2];
    dofs[23] = offset + c.entity_indices[0][3];
    offset += m.num_entities[0];
    dofs[24] = offset + c.entity_indices[1][0];
    dofs[25] = offset + c.entity_indices[1][1];
    dofs[26] = offset + c.entity_indices[1][2];
    dofs[27] = offset + c.entity_indices[1][3];
    dofs[28] = offset + c.entity_indices[1][4];
    dofs[29] = offset + c.entity_indices[1][5];
    offset += m.num_entities[1];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
      dofs[6] = 11;
      dofs[7] = 12;
      dofs[8] = 13;
      dofs[9] = 14;
      dofs[10] = 15;
      dofs[11] = 16;
      dofs[12] = 21;
      dofs[13] = 22;
      dofs[14] = 23;
      dofs[15] = 24;
      dofs[16] = 25;
      dofs[17] = 26;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 7;
      dofs[5] = 8;
      dofs[6] = 10;
      dofs[7] = 12;
      dofs[8] = 13;
      dofs[9] = 14;
      dofs[10] = 17;
      dofs[11] = 18;
      dofs[12] = 20;
      dofs[13] = 22;
      dofs[14] = 23;
      dofs[15] = 24;
      dofs[16] = 27;
      dofs[17] = 28;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 5;
      dofs[4] = 7;
      dofs[5] = 9;
      dofs[6] = 10;
      dofs[7] = 11;
      dofs[8] = 13;
      dofs[9] = 15;
      dofs[10] = 17;
      dofs[11] = 19;
      dofs[12] = 20;
      dofs[13] = 21;
      dofs[14] = 23;
      dofs[15] = 25;
      dofs[16] = 27;
      dofs[17] = 29;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 6;
      dofs[4] = 8;
      dofs[5] = 9;
      dofs[6] = 10;
      dofs[7] = 11;
      dofs[8] = 12;
      dofs[9] = 16;
      dofs[10] = 18;
      dofs[11] = 19;
      dofs[12] = 20;
      dofs[13] = 21;
      dofs[14] = 22;
      dofs[15] = 26;
      dofs[16] = 28;
      dofs[17] = 29;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 3)
    {
    std::cerr << "*** FFC warning: " << "d is larger than dimension (3)" << std::endl;
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (3)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 10;
        dofs[2] = 20;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 11;
        dofs[2] = 21;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 12;
        dofs[2] = 22;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
        dofs[1] = 13;
        dofs[2] = 23;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 5)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (5)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 4;
        dofs[1] = 14;
        dofs[2] = 24;
          break;
        }
      case 1:
        {
          dofs[0] = 5;
        dofs[1] = 15;
        dofs[2] = 25;
          break;
        }
      case 2:
        {
          dofs[0] = 6;
        dofs[1] = 16;
        dofs[2] = 26;
          break;
        }
      case 3:
        {
          dofs[0] = 7;
        dofs[1] = 17;
        dofs[2] = 27;
          break;
        }
      case 4:
        {
          dofs[0] = 8;
        dofs[1] = 18;
        dofs[2] = 28;
          break;
        }
      case 5:
        {
          dofs[0] = 9;
        dofs[1] = 19;
        dofs[2] = 29;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[0][2] = x[0][2];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[1][2] = x[1][2];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[2][2] = x[2][2];
    coordinates[3][0] = x[3][0];
    coordinates[3][1] = x[3][1];
    coordinates[3][2] = x[3][2];
    coordinates[4][0] = 0.50000000*x[2][0] + 0.50000000*x[3][0];
    coordinates[4][1] = 0.50000000*x[2][1] + 0.50000000*x[3][1];
    coordinates[4][2] = 0.50000000*x[2][2] + 0.50000000*x[3][2];
    coordinates[5][0] = 0.50000000*x[1][0] + 0.50000000*x[3][0];
    coordinates[5][1] = 0.50000000*x[1][1] + 0.50000000*x[3][1];
    coordinates[5][2] = 0.50000000*x[1][2] + 0.50000000*x[3][2];
    coordinates[6][0] = 0.50000000*x[1][0] + 0.50000000*x[2][0];
    coordinates[6][1] = 0.50000000*x[1][1] + 0.50000000*x[2][1];
    coordinates[6][2] = 0.50000000*x[1][2] + 0.50000000*x[2][2];
    coordinates[7][0] = 0.50000000*x[0][0] + 0.50000000*x[3][0];
    coordinates[7][1] = 0.50000000*x[0][1] + 0.50000000*x[3][1];
    coordinates[7][2] = 0.50000000*x[0][2] + 0.50000000*x[3][2];
    coordinates[8][0] = 0.50000000*x[0][0] + 0.50000000*x[2][0];
    coordinates[8][1] = 0.50000000*x[0][1] + 0.50000000*x[2][1];
    coordinates[8][2] = 0.50000000*x[0][2] + 0.50000000*x[2][2];
    coordinates[9][0] = 0.50000000*x[0][0] + 0.50000000*x[1][0];
    coordinates[9][1] = 0.50000000*x[0][1] + 0.50000000*x[1][1];
    coordinates[9][2] = 0.50000000*x[0][2] + 0.50000000*x[1][2];
    coordinates[10][0] = x[0][0];
    coordinates[10][1] = x[0][1];
    coordinates[10][2] = x[0][2];
    coordinates[11][0] = x[1][0];
    coordinates[11][1] = x[1][1];
    coordinates[11][2] = x[1][2];
    coordinates[12][0] = x[2][0];
    coordinates[12][1] = x[2][1];
    coordinates[12][2] = x[2][2];
    coordinates[13][0] = x[3][0];
    coordinates[13][1] = x[3][1];
    coordinates[13][2] = x[3][2];
    coordinates[14][0] = 0.50000000*x[2][0] + 0.50000000*x[3][0];
    coordinates[14][1] = 0.50000000*x[2][1] + 0.50000000*x[3][1];
    coordinates[14][2] = 0.50000000*x[2][2] + 0.50000000*x[3][2];
    coordinates[15][0] = 0.50000000*x[1][0] + 0.50000000*x[3][0];
    coordinates[15][1] = 0.50000000*x[1][1] + 0.50000000*x[3][1];
    coordinates[15][2] = 0.50000000*x[1][2] + 0.50000000*x[3][2];
    coordinates[16][0] = 0.50000000*x[1][0] + 0.50000000*x[2][0];
    coordinates[16][1] = 0.50000000*x[1][1] + 0.50000000*x[2][1];
    coordinates[16][2] = 0.50000000*x[1][2] + 0.50000000*x[2][2];
    coordinates[17][0] = 0.50000000*x[0][0] + 0.50000000*x[3][0];
    coordinates[17][1] = 0.50000000*x[0][1] + 0.50000000*x[3][1];
    coordinates[17][2] = 0.50000000*x[0][2] + 0.50000000*x[3][2];
    coordinates[18][0] = 0.50000000*x[0][0] + 0.50000000*x[2][0];
    coordinates[18][1] = 0.50000000*x[0][1] + 0.50000000*x[2][1];
    coordinates[18][2] = 0.50000000*x[0][2] + 0.50000000*x[2][2];
    coordinates[19][0] = 0.50000000*x[0][0] + 0.50000000*x[1][0];
    coordinates[19][1] = 0.50000000*x[0][1] + 0.50000000*x[1][1];
    coordinates[19][2] = 0.50000000*x[0][2] + 0.50000000*x[1][2];
    coordinates[20][0] = x[0][0];
    coordinates[20][1] = x[0][1];
    coordinates[20][2] = x[0][2];
    coordinates[21][0] = x[1][0];
    coordinates[21][1] = x[1][1];
    coordinates[21][2] = x[1][2];
    coordinates[22][0] = x[2][0];
    coordinates[22][1] = x[2][1];
    coordinates[22][2] = x[2][2];
    coordinates[23][0] = x[3][0];
    coordinates[23][1] = x[3][1];
    coordinates[23][2] = x[3][2];
    coordinates[24][0] = 0.50000000*x[2][0] + 0.50000000*x[3][0];
    coordinates[24][1] = 0.50000000*x[2][1] + 0.50000000*x[3][1];
    coordinates[24][2] = 0.50000000*x[2][2] + 0.50000000*x[3][2];
    coordinates[25][0] = 0.50000000*x[1][0] + 0.50000000*x[3][0];
    coordinates[25][1] = 0.50000000*x[1][1] + 0.50000000*x[3][1];
    coordinates[25][2] = 0.50000000*x[1][2] + 0.50000000*x[3][2];
    coordinates[26][0] = 0.50000000*x[1][0] + 0.50000000*x[2][0];
    coordinates[26][1] = 0.50000000*x[1][1] + 0.50000000*x[2][1];
    coordinates[26][2] = 0.50000000*x[1][2] + 0.50000000*x[2][2];
    coordinates[27][0] = 0.50000000*x[0][0] + 0.50000000*x[3][0];
    coordinates[27][1] = 0.50000000*x[0][1] + 0.50000000*x[3][1];
    coordinates[27][2] = 0.50000000*x[0][2] + 0.50000000*x[3][2];
    coordinates[28][0] = 0.50000000*x[0][0] + 0.50000000*x[2][0];
    coordinates[28][1] = 0.50000000*x[0][1] + 0.50000000*x[2][1];
    coordinates[28][2] = 0.50000000*x[0][2] + 0.50000000*x[2][2];
    coordinates[29][0] = 0.50000000*x[0][0] + 0.50000000*x[1][0];
    coordinates[29][1] = 0.50000000*x[0][1] + 0.50000000*x[1][1];
    coordinates[29][2] = 0.50000000*x[0][2] + 0.50000000*x[1][2];
  }

  /// Return the number of sub dof maps (for a mixed element)
  virtual unsigned int num_sub_dof_maps() const
  {
    return 3;
  }

  /// Create a new dof_map for sub dof map i (for a mixed element)
  virtual ufc::dof_map* create_sub_dof_map(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new vectorlaplacegradcurl_dof_map_0();
        break;
      }
    case 1:
      {
        return new vectorlaplacegradcurl_dof_map_0();
        break;
      }
    case 2:
      {
        return new vectorlaplacegradcurl_dof_map_0();
        break;
      }
    }
    
    return 0;
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class vectorlaplacegradcurl_dof_map_2: public ufc::dof_map
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  vectorlaplacegradcurl_dof_map_2() : ufc::dof_map()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~vectorlaplacegradcurl_dof_map_2()
  {
    // Do nothing
  }

  /// Return a string identifying the dof map
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dof map for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0];
    return false;
  }

  /// Initialize dof map for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dof map for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 4;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 4;
  }

  // Return the geometric dimension of the coordinates this dof map provides
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 3;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    dofs[0] = c.entity_indices[0][0];
    dofs[1] = c.entity_indices[0][1];
    dofs[2] = c.entity_indices[0][2];
    dofs[3] = c.entity_indices[0][3];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 3)
    {
    std::cerr << "*** FFC warning: " << "d is larger than dimension (3)" << std::endl;
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (3)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[0][2] = x[0][2];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[1][2] = x[1][2];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[2][2] = x[2][2];
    coordinates[3][0] = x[3][0];
    coordinates[3][1] = x[3][1];
    coordinates[3][2] = x[3][2];
  }

  /// Return the number of sub dof maps (for a mixed element)
  virtual unsigned int num_sub_dof_maps() const
  {
    return 0;
  }

  /// Create a new dof_map for sub dof map i (for a mixed element)
  virtual ufc::dof_map* create_sub_dof_map(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class vectorlaplacegradcurl_dof_map_3: public ufc::dof_map
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  vectorlaplacegradcurl_dof_map_3() : ufc::dof_map()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~vectorlaplacegradcurl_dof_map_3()
  {
    // Do nothing
  }

  /// Return a string identifying the dof map
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dof map for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[1];
    return false;
  }

  /// Initialize dof map for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dof map for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 6;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 6;
  }

  // Return the geometric dimension of the coordinates this dof map provides
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 3;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 1;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    dofs[0] = c.entity_indices[1][0];
    dofs[1] = c.entity_indices[1][1];
    dofs[2] = c.entity_indices[1][2];
    dofs[3] = c.entity_indices[1][3];
    dofs[4] = c.entity_indices[1][4];
    dofs[5] = c.entity_indices[1][5];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 3;
      dofs[2] = 4;
        break;
      }
    case 2:
      {
        dofs[0] = 1;
      dofs[1] = 3;
      dofs[2] = 5;
        break;
      }
    case 3:
      {
        dofs[0] = 2;
      dofs[1] = 4;
      dofs[2] = 5;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 3)
    {
    std::cerr << "*** FFC warning: " << "d is larger than dimension (3)" << std::endl;
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        if (i > 5)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (5)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      case 4:
        {
          dofs[0] = 4;
          break;
        }
      case 5:
        {
          dofs[0] = 5;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = 0.50000000*x[2][0] + 0.50000000*x[3][0];
    coordinates[0][1] = 0.50000000*x[2][1] + 0.50000000*x[3][1];
    coordinates[0][2] = 0.50000000*x[2][2] + 0.50000000*x[3][2];
    coordinates[1][0] = 0.50000000*x[1][0] + 0.50000000*x[3][0];
    coordinates[1][1] = 0.50000000*x[1][1] + 0.50000000*x[3][1];
    coordinates[1][2] = 0.50000000*x[1][2] + 0.50000000*x[3][2];
    coordinates[2][0] = 0.50000000*x[1][0] + 0.50000000*x[2][0];
    coordinates[2][1] = 0.50000000*x[1][1] + 0.50000000*x[2][1];
    coordinates[2][2] = 0.50000000*x[1][2] + 0.50000000*x[2][2];
    coordinates[3][0] = 0.50000000*x[0][0] + 0.50000000*x[3][0];
    coordinates[3][1] = 0.50000000*x[0][1] + 0.50000000*x[3][1];
    coordinates[3][2] = 0.50000000*x[0][2] + 0.50000000*x[3][2];
    coordinates[4][0] = 0.50000000*x[0][0] + 0.50000000*x[2][0];
    coordinates[4][1] = 0.50000000*x[0][1] + 0.50000000*x[2][1];
    coordinates[4][2] = 0.50000000*x[0][2] + 0.50000000*x[2][2];
    coordinates[5][0] = 0.50000000*x[0][0] + 0.50000000*x[1][0];
    coordinates[5][1] = 0.50000000*x[0][1] + 0.50000000*x[1][1];
    coordinates[5][2] = 0.50000000*x[0][2] + 0.50000000*x[1][2];
  }

  /// Return the number of sub dof maps (for a mixed element)
  virtual unsigned int num_sub_dof_maps() const
  {
    return 0;
  }

  /// Create a new dof_map for sub dof map i (for a mixed element)
  virtual ufc::dof_map* create_sub_dof_map(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class vectorlaplacegradcurl_dof_map_4: public ufc::dof_map
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  vectorlaplacegradcurl_dof_map_4() : ufc::dof_map()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~vectorlaplacegradcurl_dof_map_4()
  {
    // Do nothing
  }

  /// Return a string identifying the dof map
  virtual const char* signature() const
  {
    return "FFC dofmap for MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1), FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)], **{'value_shape': (4,) })";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dof map for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + m.num_entities[1];
    return false;
  }

  /// Initialize dof map for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dof map for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 10;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 10;
  }

  // Return the geometric dimension of the coordinates this dof map provides
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 6;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 1;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    dofs[3] = offset + c.entity_indices[0][3];
    offset += m.num_entities[0];
    dofs[4] = offset + c.entity_indices[1][0];
    dofs[5] = offset + c.entity_indices[1][1];
    dofs[6] = offset + c.entity_indices[1][2];
    dofs[7] = offset + c.entity_indices[1][3];
    dofs[8] = offset + c.entity_indices[1][4];
    dofs[9] = offset + c.entity_indices[1][5];
    offset += m.num_entities[1];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 7;
      dofs[5] = 8;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 5;
      dofs[4] = 7;
      dofs[5] = 9;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 6;
      dofs[4] = 8;
      dofs[5] = 9;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 3)
    {
    std::cerr << "*** FFC warning: " << "d is larger than dimension (3)" << std::endl;
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (3)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 5)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (5)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 4;
          break;
        }
      case 1:
        {
          dofs[0] = 5;
          break;
        }
      case 2:
        {
          dofs[0] = 6;
          break;
        }
      case 3:
        {
          dofs[0] = 7;
          break;
        }
      case 4:
        {
          dofs[0] = 8;
          break;
        }
      case 5:
        {
          dofs[0] = 9;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[0][2] = x[0][2];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[1][2] = x[1][2];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[2][2] = x[2][2];
    coordinates[3][0] = x[3][0];
    coordinates[3][1] = x[3][1];
    coordinates[3][2] = x[3][2];
    coordinates[4][0] = 0.50000000*x[2][0] + 0.50000000*x[3][0];
    coordinates[4][1] = 0.50000000*x[2][1] + 0.50000000*x[3][1];
    coordinates[4][2] = 0.50000000*x[2][2] + 0.50000000*x[3][2];
    coordinates[5][0] = 0.50000000*x[1][0] + 0.50000000*x[3][0];
    coordinates[5][1] = 0.50000000*x[1][1] + 0.50000000*x[3][1];
    coordinates[5][2] = 0.50000000*x[1][2] + 0.50000000*x[3][2];
    coordinates[6][0] = 0.50000000*x[1][0] + 0.50000000*x[2][0];
    coordinates[6][1] = 0.50000000*x[1][1] + 0.50000000*x[2][1];
    coordinates[6][2] = 0.50000000*x[1][2] + 0.50000000*x[2][2];
    coordinates[7][0] = 0.50000000*x[0][0] + 0.50000000*x[3][0];
    coordinates[7][1] = 0.50000000*x[0][1] + 0.50000000*x[3][1];
    coordinates[7][2] = 0.50000000*x[0][2] + 0.50000000*x[3][2];
    coordinates[8][0] = 0.50000000*x[0][0] + 0.50000000*x[2][0];
    coordinates[8][1] = 0.50000000*x[0][1] + 0.50000000*x[2][1];
    coordinates[8][2] = 0.50000000*x[0][2] + 0.50000000*x[2][2];
    coordinates[9][0] = 0.50000000*x[0][0] + 0.50000000*x[1][0];
    coordinates[9][1] = 0.50000000*x[0][1] + 0.50000000*x[1][1];
    coordinates[9][2] = 0.50000000*x[0][2] + 0.50000000*x[1][2];
  }

  /// Return the number of sub dof maps (for a mixed element)
  virtual unsigned int num_sub_dof_maps() const
  {
    return 2;
  }

  /// Create a new dof_map for sub dof map i (for a mixed element)
  virtual ufc::dof_map* create_sub_dof_map(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new vectorlaplacegradcurl_dof_map_2();
        break;
      }
    case 1:
      {
        return new vectorlaplacegradcurl_dof_map_3();
        break;
      }
    }
    
    return 0;
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class vectorlaplacegradcurl_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  vectorlaplacegradcurl_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vectorlaplacegradcurl_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Array of quadrature weights.
    static const double W8[8] = {0.03697986, 0.01602704, 0.02115701, 0.00916943, 0.03697986, 0.01602704, 0.02115701, 0.00916943};
    // Quadrature points on the UFC reference element: (0.15668264, 0.13605498, 0.12251482), (0.08139567, 0.07067972, 0.54415184), (0.06583869, 0.56593317, 0.12251482), (0.03420279, 0.29399880, 0.54415184), (0.58474756, 0.13605498, 0.12251482), (0.30377276, 0.07067972, 0.54415184), (0.24571333, 0.56593317, 0.12251482), (0.12764656, 0.29399880, 0.54415184)
    
    // Value of basis functions at quadrature points.
    static const double FE0_C0[8][10] = \
    {{0.58474756, 0.15668264, 0.13605498, 0.12251482, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.30377276, 0.08139567, 0.07067972, 0.54415184, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.24571333, 0.06583869, 0.56593317, 0.12251482, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.12764656, 0.03420279, 0.29399880, 0.54415184, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.15668264, 0.58474756, 0.13605498, 0.12251482, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.08139567, 0.30377276, 0.07067972, 0.54415184, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.06583869, 0.24571333, 0.56593317, 0.12251482, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.03420279, 0.12764656, 0.29399880, 0.54415184, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
    
    static const double FE0_C0_D001[8][10] = \
    {{-1.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
    
    static const double FE0_C0_D010[8][10] = \
    {{-1.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
    
    static const double FE0_C0_D100[8][10] = \
    {{-1.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
    
    static const double FE0_C1[8][10] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.12251482, -0.13605498, 0.12251482, 0.13605498, 0.74143020},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.54415184, -0.07067972, 0.54415184, 0.07067972, 0.38516843},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.12251482, -0.56593317, 0.12251482, 0.56593317, 0.31155201},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.54415184, -0.29399880, 0.54415184, 0.29399880, 0.16184936},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.12251482, -0.13605498, 0.12251482, 0.13605498, 0.74143020},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.54415184, -0.07067972, 0.54415184, 0.07067972, 0.38516843},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.12251482, -0.56593317, 0.12251482, 0.56593317, 0.31155201},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.54415184, -0.29399880, 0.54415184, 0.29399880, 0.16184936}};
    
    static const double FE0_C1_D001[8][10] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, 0.00000000, -1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, 0.00000000, -1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, 0.00000000, -1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, 0.00000000, -1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, 0.00000000, -1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, 0.00000000, -1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, 0.00000000, -1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, 0.00000000, -1.00000000}};
    
    static const double FE0_C1_D010[8][10] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, -1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, -1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, -1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, -1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, -1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, -1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, -1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, -1.00000000}};
    
    static const double FE0_C1_D100[8][10] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
    
    static const double FE0_C2[8][10] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.12251482, 0.00000000, 0.15668264, 0.12251482, 0.72080254, 0.15668264},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.54415184, 0.00000000, 0.08139567, 0.54415184, 0.37445249, 0.08139567},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.12251482, 0.00000000, 0.06583869, 0.12251482, 0.81164649, 0.06583869},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.54415184, 0.00000000, 0.03420279, 0.54415184, 0.42164536, 0.03420279},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.12251482, 0.00000000, 0.58474756, 0.12251482, 0.29273761, 0.58474756},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.54415184, 0.00000000, 0.30377276, 0.54415184, 0.15207539, 0.30377276},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.12251482, 0.00000000, 0.24571333, 0.12251482, 0.63177185, 0.24571333},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.54415184, 0.00000000, 0.12764656, 0.54415184, 0.32820159, 0.12764656}};
    
    static const double FE0_C2_D001[8][10] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 0.00000000, 1.00000000, -1.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 0.00000000, 1.00000000, -1.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 0.00000000, 1.00000000, -1.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 0.00000000, 1.00000000, -1.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 0.00000000, 1.00000000, -1.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 0.00000000, 1.00000000, -1.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 0.00000000, 1.00000000, -1.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 0.00000000, 1.00000000, -1.00000000, 0.00000000}};
    
    static const double FE0_C2_D100[8][10] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, -1.00000000, 1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, -1.00000000, 1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, -1.00000000, 1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, -1.00000000, 1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, -1.00000000, 1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, -1.00000000, 1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, -1.00000000, 1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, -1.00000000, 1.00000000}};
    
    static const double FE0_C3[8][10] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.13605498, 0.15668264, 0.00000000, 0.70726239, 0.13605498, 0.15668264},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.07067972, 0.08139567, 0.00000000, 0.84792461, 0.07067972, 0.08139567},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.56593317, 0.06583869, 0.00000000, 0.36822815, 0.56593317, 0.06583869},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.29399880, 0.03420279, 0.00000000, 0.67179841, 0.29399880, 0.03420279},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.13605498, 0.58474756, 0.00000000, 0.27919746, 0.13605498, 0.58474756},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.07067972, 0.30377276, 0.00000000, 0.62554751, 0.07067972, 0.30377276},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.56593317, 0.24571333, 0.00000000, 0.18835351, 0.56593317, 0.24571333},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.29399880, 0.12764656, 0.00000000, 0.57835464, 0.29399880, 0.12764656}};
    
    static const double FE0_C3_D010[8][10] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, -1.00000000, 1.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, -1.00000000, 1.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, -1.00000000, 1.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, -1.00000000, 1.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, -1.00000000, 1.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, -1.00000000, 1.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, -1.00000000, 1.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, -1.00000000, 1.00000000, 0.00000000}};
    
    static const double FE0_C3_D100[8][10] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000}};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 100; r++)
    {
      A[r] = 0.00000000;
    }// end loop over 'r'
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('simplify expressions', False), ('ignore zero tables', False), ('non zero columns', False), ('remove zero terms', False), ('ignore ones', False)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 325600
    for (unsigned int ip = 0; ip < 8; ip++)
    {
      
      // Number of operations for primary indices: 40700
      for (unsigned int j = 0; j < 10; j++)
      {
        for (unsigned int k = 0; k < 10; k++)
        {
          // Number of operations to compute entry: 407
          A[j*10 + k] += ((((((K_02*K_01*FE0_C1_D100[ip][j] + K_02*K_11*FE0_C2_D100[ip][j] + K_02*K_21*FE0_C3_D100[ip][j] + K_12*K_01*FE0_C1_D010[ip][j] + K_12*K_11*FE0_C1_D100[ip][j] + K_12*K_21*FE0_C3_D010[ip][j] + K_22*K_01*FE0_C1_D001[ip][j] + K_22*K_11*FE0_C2_D001[ip][j] + K_22*K_21*FE0_C1_D100[ip][j]))*(-1.00000000) + (K_01*K_02*FE0_C1_D100[ip][j] + K_01*K_12*FE0_C2_D100[ip][j] + K_01*K_22*FE0_C3_D100[ip][j] + K_11*K_02*FE0_C1_D010[ip][j] + K_11*K_12*FE0_C1_D100[ip][j] + K_11*K_22*FE0_C3_D010[ip][j] + K_21*K_02*FE0_C1_D001[ip][j] + K_21*K_12*FE0_C2_D001[ip][j] + K_21*K_22*FE0_C1_D100[ip][j])))*((((K_02*K_01*FE0_C1_D100[ip][k] + K_02*K_11*FE0_C2_D100[ip][k] + K_02*K_21*FE0_C3_D100[ip][k] + K_12*K_01*FE0_C1_D010[ip][k] + K_12*K_11*FE0_C1_D100[ip][k] + K_12*K_21*FE0_C3_D010[ip][k] + K_22*K_01*FE0_C1_D001[ip][k] + K_22*K_11*FE0_C2_D001[ip][k] + K_22*K_21*FE0_C1_D100[ip][k]))*(-1.00000000) + (K_01*K_02*FE0_C1_D100[ip][k] + K_01*K_12*FE0_C2_D100[ip][k] + K_01*K_22*FE0_C3_D100[ip][k] + K_11*K_02*FE0_C1_D010[ip][k] + K_11*K_12*FE0_C1_D100[ip][k] + K_11*K_22*FE0_C3_D010[ip][k] + K_21*K_02*FE0_C1_D001[ip][k] + K_21*K_12*FE0_C2_D001[ip][k] + K_21*K_22*FE0_C1_D100[ip][k]))) + (((K_00*K_01*FE0_C1_D100[ip][j] + K_00*K_11*FE0_C2_D100[ip][j] + K_00*K_21*FE0_C3_D100[ip][j] + K_10*K_01*FE0_C1_D010[ip][j] + K_10*K_11*FE0_C1_D100[ip][j] + K_10*K_21*FE0_C3_D010[ip][j] + K_20*K_01*FE0_C1_D001[ip][j] + K_20*K_11*FE0_C2_D001[ip][j] + K_20*K_21*FE0_C1_D100[ip][j]) + ((K_01*K_00*FE0_C1_D100[ip][j] + K_01*K_10*FE0_C2_D100[ip][j] + K_01*K_20*FE0_C3_D100[ip][j] + K_11*K_00*FE0_C1_D010[ip][j] + K_11*K_10*FE0_C1_D100[ip][j] + K_11*K_20*FE0_C3_D010[ip][j] + K_21*K_00*FE0_C1_D001[ip][j] + K_21*K_10*FE0_C2_D001[ip][j] + K_21*K_20*FE0_C1_D100[ip][j]))*(-1.00000000)))*(((K_00*K_01*FE0_C1_D100[ip][k] + K_00*K_11*FE0_C2_D100[ip][k] + K_00*K_21*FE0_C3_D100[ip][k] + K_10*K_01*FE0_C1_D010[ip][k] + K_10*K_11*FE0_C1_D100[ip][k] + K_10*K_21*FE0_C3_D010[ip][k] + K_20*K_01*FE0_C1_D001[ip][k] + K_20*K_11*FE0_C2_D001[ip][k] + K_20*K_21*FE0_C1_D100[ip][k]) + ((K_01*K_00*FE0_C1_D100[ip][k] + K_01*K_10*FE0_C2_D100[ip][k] + K_01*K_20*FE0_C3_D100[ip][k] + K_11*K_00*FE0_C1_D010[ip][k] + K_11*K_10*FE0_C1_D100[ip][k] + K_11*K_20*FE0_C3_D010[ip][k] + K_21*K_00*FE0_C1_D001[ip][k] + K_21*K_10*FE0_C2_D001[ip][k] + K_21*K_20*FE0_C1_D100[ip][k]))*(-1.00000000))) + (((K_02*K_00*FE0_C1_D100[ip][j] + K_02*K_10*FE0_C2_D100[ip][j] + K_02*K_20*FE0_C3_D100[ip][j] + K_12*K_00*FE0_C1_D010[ip][j] + K_12*K_10*FE0_C1_D100[ip][j] + K_12*K_20*FE0_C3_D010[ip][j] + K_22*K_00*FE0_C1_D001[ip][j] + K_22*K_10*FE0_C2_D001[ip][j] + K_22*K_20*FE0_C1_D100[ip][j]) + ((K_00*K_02*FE0_C1_D100[ip][j] + K_00*K_12*FE0_C2_D100[ip][j] + K_00*K_22*FE0_C3_D100[ip][j] + K_10*K_02*FE0_C1_D010[ip][j] + K_10*K_12*FE0_C1_D100[ip][j] + K_10*K_22*FE0_C3_D010[ip][j] + K_20*K_02*FE0_C1_D001[ip][j] + K_20*K_12*FE0_C2_D001[ip][j] + K_20*K_22*FE0_C1_D100[ip][j]))*(-1.00000000)))*(((K_02*K_00*FE0_C1_D100[ip][k] + K_02*K_10*FE0_C2_D100[ip][k] + K_02*K_20*FE0_C3_D100[ip][k] + K_12*K_00*FE0_C1_D010[ip][k] + K_12*K_10*FE0_C1_D100[ip][k] + K_12*K_20*FE0_C3_D010[ip][k] + K_22*K_00*FE0_C1_D001[ip][k] + K_22*K_10*FE0_C2_D001[ip][k] + K_22*K_20*FE0_C1_D100[ip][k]) + ((K_00*K_02*FE0_C1_D100[ip][k] + K_00*K_12*FE0_C2_D100[ip][k] + K_00*K_22*FE0_C3_D100[ip][k] + K_10*K_02*FE0_C1_D010[ip][k] + K_10*K_12*FE0_C1_D100[ip][k] + K_10*K_22*FE0_C3_D010[ip][k] + K_20*K_02*FE0_C1_D001[ip][k] + K_20*K_12*FE0_C2_D001[ip][k] + K_20*K_22*FE0_C1_D100[ip][k]))*(-1.00000000)))) + ((((K_00*FE0_C0_D100[ip][k] + K_10*FE0_C0_D010[ip][k] + K_20*FE0_C0_D001[ip][k]))*((K_00*FE0_C1[ip][j] + K_10*FE0_C2[ip][j] + K_20*FE0_C3[ip][j])) + ((K_01*FE0_C0_D100[ip][k] + K_11*FE0_C0_D010[ip][k] + K_21*FE0_C0_D001[ip][k]))*((K_01*FE0_C1[ip][j] + K_11*FE0_C2[ip][j] + K_21*FE0_C3[ip][j])) + ((K_02*FE0_C0_D100[ip][k] + K_12*FE0_C0_D010[ip][k] + K_22*FE0_C0_D001[ip][k]))*((K_02*FE0_C1[ip][j] + K_12*FE0_C2[ip][j] + K_22*FE0_C3[ip][j]))) + (((((K_00*FE0_C0_D100[ip][j] + K_10*FE0_C0_D010[ip][j] + K_20*FE0_C0_D001[ip][j]))*((K_00*FE0_C1[ip][k] + K_10*FE0_C2[ip][k] + K_20*FE0_C3[ip][k])) + ((K_01*FE0_C0_D100[ip][j] + K_11*FE0_C0_D010[ip][j] + K_21*FE0_C0_D001[ip][j]))*((K_01*FE0_C1[ip][k] + K_11*FE0_C2[ip][k] + K_21*FE0_C3[ip][k])) + ((K_02*FE0_C0_D100[ip][j] + K_12*FE0_C0_D010[ip][j] + K_22*FE0_C0_D001[ip][j]))*((K_02*FE0_C1[ip][k] + K_12*FE0_C2[ip][k] + K_22*FE0_C3[ip][k]))))*(-1.00000000) + FE0_C0[ip][j]*FE0_C0[ip][k])))*W8[ip]*det;
        }// end loop over 'k'
      }// end loop over 'j'
    }// end loop over 'ip'
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class vectorlaplacegradcurl_cell_integral_1_0: public ufc::cell_integral
{
public:

  /// Constructor
  vectorlaplacegradcurl_cell_integral_1_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vectorlaplacegradcurl_cell_integral_1_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      32
    // Number of operations (multiply-add pairs) for geometry tensor:    135
    // Number of operations (multiply-add pairs) for tensor contraction: 411
    // Total number of operations (multiply-add pairs):                  578
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_20 = det*w[0][20]*K_02*(1.0);
    const double G0_0_21 = det*w[0][21]*K_02*(1.0);
    const double G0_0_22 = det*w[0][22]*K_02*(1.0);
    const double G0_0_23 = det*w[0][23]*K_02*(1.0);
    const double G0_0_24 = det*w[0][24]*K_02*(1.0);
    const double G0_0_25 = det*w[0][25]*K_02*(1.0);
    const double G0_0_26 = det*w[0][26]*K_02*(1.0);
    const double G0_0_27 = det*w[0][27]*K_02*(1.0);
    const double G0_0_28 = det*w[0][28]*K_02*(1.0);
    const double G0_0_29 = det*w[0][29]*K_02*(1.0);
    const double G0_1_20 = det*w[0][20]*K_12*(1.0);
    const double G0_1_21 = det*w[0][21]*K_12*(1.0);
    const double G0_1_22 = det*w[0][22]*K_12*(1.0);
    const double G0_1_23 = det*w[0][23]*K_12*(1.0);
    const double G0_1_24 = det*w[0][24]*K_12*(1.0);
    const double G0_1_25 = det*w[0][25]*K_12*(1.0);
    const double G0_1_26 = det*w[0][26]*K_12*(1.0);
    const double G0_1_27 = det*w[0][27]*K_12*(1.0);
    const double G0_1_28 = det*w[0][28]*K_12*(1.0);
    const double G0_1_29 = det*w[0][29]*K_12*(1.0);
    const double G0_2_20 = det*w[0][20]*K_22*(1.0);
    const double G0_2_21 = det*w[0][21]*K_22*(1.0);
    const double G0_2_22 = det*w[0][22]*K_22*(1.0);
    const double G0_2_23 = det*w[0][23]*K_22*(1.0);
    const double G0_2_24 = det*w[0][24]*K_22*(1.0);
    const double G0_2_25 = det*w[0][25]*K_22*(1.0);
    const double G0_2_26 = det*w[0][26]*K_22*(1.0);
    const double G0_2_27 = det*w[0][27]*K_22*(1.0);
    const double G0_2_28 = det*w[0][28]*K_22*(1.0);
    const double G0_2_29 = det*w[0][29]*K_22*(1.0);
    const double G1_0_0 = det*w[0][0]*K_00*(1.0);
    const double G1_0_1 = det*w[0][1]*K_00*(1.0);
    const double G1_0_2 = det*w[0][2]*K_00*(1.0);
    const double G1_0_3 = det*w[0][3]*K_00*(1.0);
    const double G1_0_4 = det*w[0][4]*K_00*(1.0);
    const double G1_0_5 = det*w[0][5]*K_00*(1.0);
    const double G1_0_6 = det*w[0][6]*K_00*(1.0);
    const double G1_0_7 = det*w[0][7]*K_00*(1.0);
    const double G1_0_8 = det*w[0][8]*K_00*(1.0);
    const double G1_0_9 = det*w[0][9]*K_00*(1.0);
    const double G1_1_0 = det*w[0][0]*K_10*(1.0);
    const double G1_1_1 = det*w[0][1]*K_10*(1.0);
    const double G1_1_2 = det*w[0][2]*K_10*(1.0);
    const double G1_1_3 = det*w[0][3]*K_10*(1.0);
    const double G1_1_4 = det*w[0][4]*K_10*(1.0);
    const double G1_1_5 = det*w[0][5]*K_10*(1.0);
    const double G1_1_6 = det*w[0][6]*K_10*(1.0);
    const double G1_1_7 = det*w[0][7]*K_10*(1.0);
    const double G1_1_8 = det*w[0][8]*K_10*(1.0);
    const double G1_1_9 = det*w[0][9]*K_10*(1.0);
    const double G1_2_0 = det*w[0][0]*K_20*(1.0);
    const double G1_2_1 = det*w[0][1]*K_20*(1.0);
    const double G1_2_2 = det*w[0][2]*K_20*(1.0);
    const double G1_2_3 = det*w[0][3]*K_20*(1.0);
    const double G1_2_4 = det*w[0][4]*K_20*(1.0);
    const double G1_2_5 = det*w[0][5]*K_20*(1.0);
    const double G1_2_6 = det*w[0][6]*K_20*(1.0);
    const double G1_2_7 = det*w[0][7]*K_20*(1.0);
    const double G1_2_8 = det*w[0][8]*K_20*(1.0);
    const double G1_2_9 = det*w[0][9]*K_20*(1.0);
    const double G2_0_10 = det*w[0][10]*K_01*(1.0);
    const double G2_0_11 = det*w[0][11]*K_01*(1.0);
    const double G2_0_12 = det*w[0][12]*K_01*(1.0);
    const double G2_0_13 = det*w[0][13]*K_01*(1.0);
    const double G2_0_14 = det*w[0][14]*K_01*(1.0);
    const double G2_0_15 = det*w[0][15]*K_01*(1.0);
    const double G2_0_16 = det*w[0][16]*K_01*(1.0);
    const double G2_0_17 = det*w[0][17]*K_01*(1.0);
    const double G2_0_18 = det*w[0][18]*K_01*(1.0);
    const double G2_0_19 = det*w[0][19]*K_01*(1.0);
    const double G2_1_10 = det*w[0][10]*K_11*(1.0);
    const double G2_1_11 = det*w[0][11]*K_11*(1.0);
    const double G2_1_12 = det*w[0][12]*K_11*(1.0);
    const double G2_1_13 = det*w[0][13]*K_11*(1.0);
    const double G2_1_14 = det*w[0][14]*K_11*(1.0);
    const double G2_1_15 = det*w[0][15]*K_11*(1.0);
    const double G2_1_16 = det*w[0][16]*K_11*(1.0);
    const double G2_1_17 = det*w[0][17]*K_11*(1.0);
    const double G2_1_18 = det*w[0][18]*K_11*(1.0);
    const double G2_1_19 = det*w[0][19]*K_11*(1.0);
    const double G2_2_10 = det*w[0][10]*K_21*(1.0);
    const double G2_2_11 = det*w[0][11]*K_21*(1.0);
    const double G2_2_12 = det*w[0][12]*K_21*(1.0);
    const double G2_2_13 = det*w[0][13]*K_21*(1.0);
    const double G2_2_14 = det*w[0][14]*K_21*(1.0);
    const double G2_2_15 = det*w[0][15]*K_21*(1.0);
    const double G2_2_16 = det*w[0][16]*K_21*(1.0);
    const double G2_2_17 = det*w[0][17]*K_21*(1.0);
    const double G2_2_18 = det*w[0][18]*K_21*(1.0);
    const double G2_2_19 = det*w[0][19]*K_21*(1.0);
    
    // Compute element tensor
    A[0] = 0.00000000;
    A[1] = 0.00000000;
    A[2] = 0.00000000;
    A[3] = 0.00000000;
    A[4] = 0.00277778*G0_1_20 + 0.00277778*G0_1_21 + 0.00277778*G0_1_22 - 0.01111111*G0_1_24 - 0.01111111*G0_1_25 - 0.00555556*G0_1_26 - 0.01111111*G0_1_27 - 0.00555556*G0_1_28 - 0.00555556*G0_1_29 - 0.00277778*G0_2_20 - 0.00277778*G0_2_21 - 0.00277778*G0_2_23 + 0.01111111*G0_2_24 + 0.00555556*G0_2_25 + 0.01111111*G0_2_26 + 0.00555556*G0_2_27 + 0.01111111*G0_2_28 + 0.00555556*G0_2_29 + 0.00277778*G1_1_0 + 0.00277778*G1_1_1 + 0.00277778*G1_1_2 - 0.01111111*G1_1_4 - 0.01111111*G1_1_5 - 0.00555556*G1_1_6 - 0.01111111*G1_1_7 - 0.00555556*G1_1_8 - 0.00555556*G1_1_9 - 0.00277778*G1_2_0 - 0.00277778*G1_2_1 - 0.00277778*G1_2_3 + 0.01111111*G1_2_4 + 0.00555556*G1_2_5 + 0.01111111*G1_2_6 + 0.00555556*G1_2_7 + 0.01111111*G1_2_8 + 0.00555556*G1_2_9 + 0.00277778*G2_1_10 + 0.00277778*G2_1_11 + 0.00277778*G2_1_12 - 0.01111111*G2_1_14 - 0.01111111*G2_1_15 - 0.00555556*G2_1_16 - 0.01111111*G2_1_17 - 0.00555556*G2_1_18 - 0.00555556*G2_1_19 - 0.00277778*G2_2_10 - 0.00277778*G2_2_11 - 0.00277778*G2_2_13 + 0.01111111*G2_2_14 + 0.00555556*G2_2_15 + 0.01111111*G2_2_16 + 0.00555556*G2_2_17 + 0.01111111*G2_2_18 + 0.00555556*G2_2_19;
    A[5] = 0.00277778*G0_0_20 + 0.00277778*G0_0_21 + 0.00277778*G0_0_22 - 0.01111111*G0_0_24 - 0.01111111*G0_0_25 - 0.00555556*G0_0_26 - 0.01111111*G0_0_27 - 0.00555556*G0_0_28 - 0.00555556*G0_0_29 - 0.00277778*G0_2_20 - 0.00277778*G0_2_22 - 0.00277778*G0_2_23 + 0.00555556*G0_2_24 + 0.01111111*G0_2_25 + 0.01111111*G0_2_26 + 0.00555556*G0_2_27 + 0.00555556*G0_2_28 + 0.01111111*G0_2_29 + 0.00277778*G1_0_0 + 0.00277778*G1_0_1 + 0.00277778*G1_0_2 - 0.01111111*G1_0_4 - 0.01111111*G1_0_5 - 0.00555556*G1_0_6 - 0.01111111*G1_0_7 - 0.00555556*G1_0_8 - 0.00555556*G1_0_9 - 0.00277778*G1_2_0 - 0.00277778*G1_2_2 - 0.00277778*G1_2_3 + 0.00555556*G1_2_4 + 0.01111111*G1_2_5 + 0.01111111*G1_2_6 + 0.00555556*G1_2_7 + 0.00555556*G1_2_8 + 0.01111111*G1_2_9 + 0.00277778*G2_0_10 + 0.00277778*G2_0_11 + 0.00277778*G2_0_12 - 0.01111111*G2_0_14 - 0.01111111*G2_0_15 - 0.00555556*G2_0_16 - 0.01111111*G2_0_17 - 0.00555556*G2_0_18 - 0.00555556*G2_0_19 - 0.00277778*G2_2_10 - 0.00277778*G2_2_12 - 0.00277778*G2_2_13 + 0.00555556*G2_2_14 + 0.01111111*G2_2_15 + 0.01111111*G2_2_16 + 0.00555556*G2_2_17 + 0.00555556*G2_2_18 + 0.01111111*G2_2_19;
    A[6] = 0.00277778*G0_0_20 + 0.00277778*G0_0_21 + 0.00277778*G0_0_23 - 0.01111111*G0_0_24 - 0.00555556*G0_0_25 - 0.01111111*G0_0_26 - 0.00555556*G0_0_27 - 0.01111111*G0_0_28 - 0.00555556*G0_0_29 - 0.00277778*G0_1_20 - 0.00277778*G0_1_22 - 0.00277778*G0_1_23 + 0.00555556*G0_1_24 + 0.01111111*G0_1_25 + 0.01111111*G0_1_26 + 0.00555556*G0_1_27 + 0.00555556*G0_1_28 + 0.01111111*G0_1_29 + 0.00277778*G1_0_0 + 0.00277778*G1_0_1 + 0.00277778*G1_0_3 - 0.01111111*G1_0_4 - 0.00555556*G1_0_5 - 0.01111111*G1_0_6 - 0.00555556*G1_0_7 - 0.01111111*G1_0_8 - 0.00555556*G1_0_9 - 0.00277778*G1_1_0 - 0.00277778*G1_1_2 - 0.00277778*G1_1_3 + 0.00555556*G1_1_4 + 0.01111111*G1_1_5 + 0.01111111*G1_1_6 + 0.00555556*G1_1_7 + 0.00555556*G1_1_8 + 0.01111111*G1_1_9 + 0.00277778*G2_0_10 + 0.00277778*G2_0_11 + 0.00277778*G2_0_13 - 0.01111111*G2_0_14 - 0.00555556*G2_0_15 - 0.01111111*G2_0_16 - 0.00555556*G2_0_17 - 0.01111111*G2_0_18 - 0.00555556*G2_0_19 - 0.00277778*G2_1_10 - 0.00277778*G2_1_12 - 0.00277778*G2_1_13 + 0.00555556*G2_1_14 + 0.01111111*G2_1_15 + 0.01111111*G2_1_16 + 0.00555556*G2_1_17 + 0.00555556*G2_1_18 + 0.01111111*G2_1_19;
    A[7] = -0.00277778*G0_0_20 - 0.00277778*G0_0_21 - 0.00277778*G0_0_22 + 0.01111111*G0_0_24 + 0.01111111*G0_0_25 + 0.00555556*G0_0_26 + 0.01111111*G0_0_27 + 0.00555556*G0_0_28 + 0.00555556*G0_0_29 - 0.00277778*G0_1_20 - 0.00277778*G0_1_21 - 0.00277778*G0_1_22 + 0.01111111*G0_1_24 + 0.01111111*G0_1_25 + 0.00555556*G0_1_26 + 0.01111111*G0_1_27 + 0.00555556*G0_1_28 + 0.00555556*G0_1_29 - 0.00277778*G0_2_20 - 0.00555556*G0_2_21 - 0.00555556*G0_2_22 - 0.00277778*G0_2_23 + 0.01666667*G0_2_24 + 0.01666667*G0_2_25 + 0.01111111*G0_2_26 + 0.02222222*G0_2_27 + 0.01666667*G0_2_28 + 0.01666667*G0_2_29 - 0.00277778*G1_0_0 - 0.00277778*G1_0_1 - 0.00277778*G1_0_2 + 0.01111111*G1_0_4 + 0.01111111*G1_0_5 + 0.00555556*G1_0_6 + 0.01111111*G1_0_7 + 0.00555556*G1_0_8 + 0.00555556*G1_0_9 - 0.00277778*G1_1_0 - 0.00277778*G1_1_1 - 0.00277778*G1_1_2 + 0.01111111*G1_1_4 + 0.01111111*G1_1_5 + 0.00555556*G1_1_6 + 0.01111111*G1_1_7 + 0.00555556*G1_1_8 + 0.00555556*G1_1_9 - 0.00277778*G1_2_0 - 0.00555556*G1_2_1 - 0.00555556*G1_2_2 - 0.00277778*G1_2_3 + 0.01666667*G1_2_4 + 0.01666667*G1_2_5 + 0.01111111*G1_2_6 + 0.02222222*G1_2_7 + 0.01666667*G1_2_8 + 0.01666667*G1_2_9 - 0.00277778*G2_0_10 - 0.00277778*G2_0_11 - 0.00277778*G2_0_12 + 0.01111111*G2_0_14 + 0.01111111*G2_0_15 + 0.00555556*G2_0_16 + 0.01111111*G2_0_17 + 0.00555556*G2_0_18 + 0.00555556*G2_0_19 - 0.00277778*G2_1_10 - 0.00277778*G2_1_11 - 0.00277778*G2_1_12 + 0.01111111*G2_1_14 + 0.01111111*G2_1_15 + 0.00555556*G2_1_16 + 0.01111111*G2_1_17 + 0.00555556*G2_1_18 + 0.00555556*G2_1_19 - 0.00277778*G2_2_10 - 0.00555556*G2_2_11 - 0.00555556*G2_2_12 - 0.00277778*G2_2_13 + 0.01666667*G2_2_14 + 0.01666667*G2_2_15 + 0.01111111*G2_2_16 + 0.02222222*G2_2_17 + 0.01666667*G2_2_18 + 0.01666667*G2_2_19;
    A[8] = -0.00277778*G0_0_20 - 0.00277778*G0_0_21 - 0.00277778*G0_0_23 + 0.01111111*G0_0_24 + 0.00555556*G0_0_25 + 0.01111111*G0_0_26 + 0.00555556*G0_0_27 + 0.01111111*G0_0_28 + 0.00555556*G0_0_29 - 0.00277778*G0_1_20 - 0.00555556*G0_1_21 - 0.00277778*G0_1_22 - 0.00555556*G0_1_23 + 0.01666667*G0_1_24 + 0.01111111*G0_1_25 + 0.01666667*G0_1_26 + 0.01666667*G0_1_27 + 0.02222222*G0_1_28 + 0.01666667*G0_1_29 - 0.00277778*G0_2_20 - 0.00277778*G0_2_21 - 0.00277778*G0_2_23 + 0.01111111*G0_2_24 + 0.00555556*G0_2_25 + 0.01111111*G0_2_26 + 0.00555556*G0_2_27 + 0.01111111*G0_2_28 + 0.00555556*G0_2_29 - 0.00277778*G1_0_0 - 0.00277778*G1_0_1 - 0.00277778*G1_0_3 + 0.01111111*G1_0_4 + 0.00555556*G1_0_5 + 0.01111111*G1_0_6 + 0.00555556*G1_0_7 + 0.01111111*G1_0_8 + 0.00555556*G1_0_9 - 0.00277778*G1_1_0 - 0.00555556*G1_1_1 - 0.00277778*G1_1_2 - 0.00555556*G1_1_3 + 0.01666667*G1_1_4 + 0.01111111*G1_1_5 + 0.01666667*G1_1_6 + 0.01666667*G1_1_7 + 0.02222222*G1_1_8 + 0.01666667*G1_1_9 - 0.00277778*G1_2_0 - 0.00277778*G1_2_1 - 0.00277778*G1_2_3 + 0.01111111*G1_2_4 + 0.00555556*G1_2_5 + 0.01111111*G1_2_6 + 0.00555556*G1_2_7 + 0.01111111*G1_2_8 + 0.00555556*G1_2_9 - 0.00277778*G2_0_10 - 0.00277778*G2_0_11 - 0.00277778*G2_0_13 + 0.01111111*G2_0_14 + 0.00555556*G2_0_15 + 0.01111111*G2_0_16 + 0.00555556*G2_0_17 + 0.01111111*G2_0_18 + 0.00555556*G2_0_19 - 0.00277778*G2_1_10 - 0.00555556*G2_1_11 - 0.00277778*G2_1_12 - 0.00555556*G2_1_13 + 0.01666667*G2_1_14 + 0.01111111*G2_1_15 + 0.01666667*G2_1_16 + 0.01666667*G2_1_17 + 0.02222222*G2_1_18 + 0.01666667*G2_1_19 - 0.00277778*G2_2_10 - 0.00277778*G2_2_11 - 0.00277778*G2_2_13 + 0.01111111*G2_2_14 + 0.00555556*G2_2_15 + 0.01111111*G2_2_16 + 0.00555556*G2_2_17 + 0.01111111*G2_2_18 + 0.00555556*G2_2_19;
    A[9] = -0.00277778*G0_0_20 - 0.00277778*G0_0_21 - 0.00555556*G0_0_22 - 0.00555556*G0_0_23 + 0.01111111*G0_0_24 + 0.01666667*G0_0_25 + 0.01666667*G0_0_26 + 0.01666667*G0_0_27 + 0.01666667*G0_0_28 + 0.02222222*G0_0_29 - 0.00277778*G0_1_20 - 0.00277778*G0_1_22 - 0.00277778*G0_1_23 + 0.00555556*G0_1_24 + 0.01111111*G0_1_25 + 0.01111111*G0_1_26 + 0.00555556*G0_1_27 + 0.00555556*G0_1_28 + 0.01111111*G0_1_29 - 0.00277778*G0_2_20 - 0.00277778*G0_2_22 - 0.00277778*G0_2_23 + 0.00555556*G0_2_24 + 0.01111111*G0_2_25 + 0.01111111*G0_2_26 + 0.00555556*G0_2_27 + 0.00555556*G0_2_28 + 0.01111111*G0_2_29 - 0.00277778*G1_0_0 - 0.00277778*G1_0_1 - 0.00555556*G1_0_2 - 0.00555556*G1_0_3 + 0.01111111*G1_0_4 + 0.01666667*G1_0_5 + 0.01666667*G1_0_6 + 0.01666667*G1_0_7 + 0.01666667*G1_0_8 + 0.02222222*G1_0_9 - 0.00277778*G1_1_0 - 0.00277778*G1_1_2 - 0.00277778*G1_1_3 + 0.00555556*G1_1_4 + 0.01111111*G1_1_5 + 0.01111111*G1_1_6 + 0.00555556*G1_1_7 + 0.00555556*G1_1_8 + 0.01111111*G1_1_9 - 0.00277778*G1_2_0 - 0.00277778*G1_2_2 - 0.00277778*G1_2_3 + 0.00555556*G1_2_4 + 0.01111111*G1_2_5 + 0.01111111*G1_2_6 + 0.00555556*G1_2_7 + 0.00555556*G1_2_8 + 0.01111111*G1_2_9 - 0.00277778*G2_0_10 - 0.00277778*G2_0_11 - 0.00555556*G2_0_12 - 0.00555556*G2_0_13 + 0.01111111*G2_0_14 + 0.01666667*G2_0_15 + 0.01666667*G2_0_16 + 0.01666667*G2_0_17 + 0.01666667*G2_0_18 + 0.02222222*G2_0_19 - 0.00277778*G2_1_10 - 0.00277778*G2_1_12 - 0.00277778*G2_1_13 + 0.00555556*G2_1_14 + 0.01111111*G2_1_15 + 0.01111111*G2_1_16 + 0.00555556*G2_1_17 + 0.00555556*G2_1_18 + 0.01111111*G2_1_19 - 0.00277778*G2_2_10 - 0.00277778*G2_2_12 - 0.00277778*G2_2_13 + 0.00555556*G2_2_14 + 0.01111111*G2_2_15 + 0.01111111*G2_2_16 + 0.00555556*G2_2_17 + 0.00555556*G2_2_18 + 0.01111111*G2_2_19;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class vectorlaplacegradcurl_form_0: public ufc::form
{
public:

  /// Constructor
  vectorlaplacegradcurl_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vectorlaplacegradcurl_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Sum(IndexSum(Product(Indexed(ListTensor(Sum(Indexed(SpatialDerivative(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1), FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)], **{'value_shape': (4,) }), 0), MultiIndex((FixedIndex(1),), {FixedIndex(1): 3})), MultiIndex((FixedIndex(3),), {FixedIndex(3): 4})), Product(IntValue(-1, (), (), {}), Indexed(SpatialDerivative(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1), FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)], **{'value_shape': (4,) }), 0), MultiIndex((FixedIndex(2),), {FixedIndex(2): 3})), MultiIndex((FixedIndex(2),), {FixedIndex(2): 4})))), Sum(Indexed(SpatialDerivative(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1), FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)], **{'value_shape': (4,) }), 0), MultiIndex((FixedIndex(2),), {FixedIndex(2): 3})), MultiIndex((FixedIndex(1),), {FixedIndex(1): 4})), Product(IntValue(-1, (), (), {}), Indexed(SpatialDerivative(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1), FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)], **{'value_shape': (4,) }), 0), MultiIndex((FixedIndex(0),), {FixedIndex(0): 3})), MultiIndex((FixedIndex(3),), {FixedIndex(3): 4})))), Sum(Indexed(SpatialDerivative(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1), FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)], **{'value_shape': (4,) }), 0), MultiIndex((FixedIndex(0),), {FixedIndex(0): 3})), MultiIndex((FixedIndex(2),), {FixedIndex(2): 4})), Product(IntValue(-1, (), (), {}), Indexed(SpatialDerivative(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1), FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)], **{'value_shape': (4,) }), 0), MultiIndex((FixedIndex(1),), {FixedIndex(1): 3})), MultiIndex((FixedIndex(1),), {FixedIndex(1): 4}))))), MultiIndex((Index(0),), {Index(0): 3})), Indexed(ListTensor(Sum(Indexed(SpatialDerivative(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1), FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)], **{'value_shape': (4,) }), 1), MultiIndex((FixedIndex(1),), {FixedIndex(1): 3})), MultiIndex((FixedIndex(3),), {FixedIndex(3): 4})), Product(IntValue(-1, (), (), {}), Indexed(SpatialDerivative(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1), FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)], **{'value_shape': (4,) }), 1), MultiIndex((FixedIndex(2),), {FixedIndex(2): 3})), MultiIndex((FixedIndex(2),), {FixedIndex(2): 4})))), Sum(Indexed(SpatialDerivative(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1), FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)], **{'value_shape': (4,) }), 1), MultiIndex((FixedIndex(2),), {FixedIndex(2): 3})), MultiIndex((FixedIndex(1),), {FixedIndex(1): 4})), Product(IntValue(-1, (), (), {}), Indexed(SpatialDerivative(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1), FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)], **{'value_shape': (4,) }), 1), MultiIndex((FixedIndex(0),), {FixedIndex(0): 3})), MultiIndex((FixedIndex(3),), {FixedIndex(3): 4})))), Sum(Indexed(SpatialDerivative(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1), FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)], **{'value_shape': (4,) }), 1), MultiIndex((FixedIndex(0),), {FixedIndex(0): 3})), MultiIndex((FixedIndex(2),), {FixedIndex(2): 4})), Product(IntValue(-1, (), (), {}), Indexed(SpatialDerivative(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1), FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)], **{'value_shape': (4,) }), 1), MultiIndex((FixedIndex(1),), {FixedIndex(1): 3})), MultiIndex((FixedIndex(1),), {FixedIndex(1): 4}))))), MultiIndex((Index(0),), {Index(0): 3}))), MultiIndex((Index(0),), {Index(0): 3})), Sum(IndexSum(Product(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1), FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)], **{'value_shape': (4,) }), 1), MultiIndex((Index(1),), {Index(1): 3})), MultiIndex((FixedIndex(0),), {})), MultiIndex((Index(1),), {Index(1): 3})), MultiIndex((Index(2),), {Index(2): 3})), Indexed(ListTensor(Indexed(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1), FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)], **{'value_shape': (4,) }), 0), MultiIndex((FixedIndex(1),), {FixedIndex(1): 4})), Indexed(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1), FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)], **{'value_shape': (4,) }), 0), MultiIndex((FixedIndex(2),), {FixedIndex(2): 4})), Indexed(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1), FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)], **{'value_shape': (4,) }), 0), MultiIndex((FixedIndex(3),), {FixedIndex(3): 4}))), MultiIndex((Index(2),), {Index(2): 3}))), MultiIndex((Index(2),), {Index(2): 3})), Sum(Product(Indexed(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1), FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)], **{'value_shape': (4,) }), 0), MultiIndex((FixedIndex(0),), {FixedIndex(0): 4})), Indexed(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1), FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)], **{'value_shape': (4,) }), 1), MultiIndex((FixedIndex(0),), {FixedIndex(0): 4}))), Product(IntValue(-1, (), (), {}), IndexSum(Product(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1), FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)], **{'value_shape': (4,) }), 0), MultiIndex((Index(3),), {Index(3): 3})), MultiIndex((FixedIndex(0),), {})), MultiIndex((Index(3),), {Index(3): 3})), MultiIndex((Index(4),), {Index(4): 3})), Indexed(ListTensor(Indexed(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1), FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)], **{'value_shape': (4,) }), 1), MultiIndex((FixedIndex(1),), {FixedIndex(1): 4})), Indexed(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1), FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)], **{'value_shape': (4,) }), 1), MultiIndex((FixedIndex(2),), {FixedIndex(2): 4})), Indexed(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1), FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)], **{'value_shape': (4,) }), 1), MultiIndex((FixedIndex(3),), {FixedIndex(3): 4}))), MultiIndex((Index(4),), {Index(4): 3}))), MultiIndex((Index(4),), {Index(4): 3})))))), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 0;
  }

  /// Return the number of cell integrals
  virtual unsigned int num_cell_integrals() const
  {
    return 1;
  }

  /// Return the number of exterior facet integrals
  virtual unsigned int num_exterior_facet_integrals() const
  {
    return 0;
  }

  /// Return the number of interior facet integrals
  virtual unsigned int num_interior_facet_integrals() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new vectorlaplacegradcurl_finite_element_4();
        break;
      }
    case 1:
      {
        return new vectorlaplacegradcurl_finite_element_4();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dof map for argument function i
  virtual ufc::dof_map* create_dof_map(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new vectorlaplacegradcurl_dof_map_4();
        break;
      }
    case 1:
      {
        return new vectorlaplacegradcurl_dof_map_4();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new vectorlaplacegradcurl_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class vectorlaplacegradcurl_form_1: public ufc::form
{
public:

  /// Constructor
  vectorlaplacegradcurl_form_1() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vectorlaplacegradcurl_form_1()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(IndexSum(Product(Indexed(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 2, 3), 0), MultiIndex((Index(0),), {Index(0): 3})), Indexed(ListTensor(Indexed(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1), FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)], **{'value_shape': (4,) }), 0), MultiIndex((FixedIndex(1),), {FixedIndex(1): 4})), Indexed(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1), FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)], **{'value_shape': (4,) }), 0), MultiIndex((FixedIndex(2),), {FixedIndex(2): 4})), Indexed(Argument(MixedElement(*[FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1), FiniteElement('Nedelec 1st kind H(curl)', Cell('tetrahedron', 1, Space(3)), 1)], **{'value_shape': (4,) }), 0), MultiIndex((FixedIndex(3),), {FixedIndex(3): 4}))), MultiIndex((Index(0),), {Index(0): 3}))), MultiIndex((Index(0),), {Index(0): 3})), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 1;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 1;
  }

  /// Return the number of cell integrals
  virtual unsigned int num_cell_integrals() const
  {
    return 1;
  }

  /// Return the number of exterior facet integrals
  virtual unsigned int num_exterior_facet_integrals() const
  {
    return 0;
  }

  /// Return the number of interior facet integrals
  virtual unsigned int num_interior_facet_integrals() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new vectorlaplacegradcurl_finite_element_4();
        break;
      }
    case 1:
      {
        return new vectorlaplacegradcurl_finite_element_1();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dof map for argument function i
  virtual ufc::dof_map* create_dof_map(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new vectorlaplacegradcurl_dof_map_4();
        break;
      }
    case 1:
      {
        return new vectorlaplacegradcurl_dof_map_1();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new vectorlaplacegradcurl_cell_integral_1_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

#endif
