// This code conforms with the UFC specification version 2.2.0
// and was automatically generated by FFC version 1.2.0.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: True
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      20
//   log_prefix:                     ''
//   optimize:                       False
//   output_dir:                     '.'
//   precision:                      '8'
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __RESTRICTEDELEMENT_H
#define __RESTRICTEDELEMENT_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class restrictedelement_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  restrictedelement_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~restrictedelement_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "RestrictedElement(FiniteElement('Lagrange', Domain(Cell('triangle', 2), 'triangle_multiverse', 2, 2), 4, None), Cell('interval', 2))";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual std::size_t topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual std::size_t space_dimension() const
  {
    return 12;
  }

  /// Return the rank of the value space
  virtual std::size_t value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual std::size_t value_dimension(std::size_t i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point x in cell
  virtual void evaluate_basis(std::size_t i,
                              double* values,
                              const double* x,
                              const double* vertex_coordinates,
                              int cell_orientation) const
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[2] + vertex_coordinates[4];
    const double C1 = vertex_coordinates[3] + vertex_coordinates[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Reset values
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.6666667*tmp0 - basisvalues[1]*0.66666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.028571429 + Y*1.8) - basisvalues[5]*0.77142857;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.28571429 + Y*2.0) - basisvalues[4]*0.71428571;
      basisvalues[12] = basisvalues[7]*(1.0204082 + Y*2.5714286) - basisvalues[3]*0.55102041;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients
      static const double coefficients0[15] = \
      {0.0, -0.041239305, -0.023809524, 0.028980029, 0.022447834, 0.012960263, -0.039594258, -0.033463256, -0.025920526, -0.014965223, 0.032124725, 0.028331345, 0.023944357, 0.018547219, 0.010708242};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.6666667*tmp0 - basisvalues[1]*0.66666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.028571429 + Y*1.8) - basisvalues[5]*0.77142857;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.28571429 + Y*2.0) - basisvalues[4]*0.71428571;
      basisvalues[12] = basisvalues[7]*(1.0204082 + Y*2.5714286) - basisvalues[3]*0.55102041;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients
      static const double coefficients0[15] = \
      {0.0, 0.041239305, -0.023809524, 0.028980029, -0.022447834, 0.012960263, 0.039594258, -0.033463256, 0.025920526, -0.014965223, 0.032124725, -0.028331345, 0.023944357, -0.018547219, 0.010708242};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.6666667*tmp0 - basisvalues[1]*0.66666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.028571429 + Y*1.8) - basisvalues[5]*0.77142857;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.28571429 + Y*2.0) - basisvalues[4]*0.71428571;
      basisvalues[12] = basisvalues[7]*(1.0204082 + Y*2.5714286) - basisvalues[3]*0.55102041;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients
      static const double coefficients0[15] = \
      {0.0, 0.0, 0.047619048, 0.0, 0.0, 0.03888079, 0.0, 0.0, 0.0, 0.059860892, 0.0, 0.0, 0.0, 0.0, 0.053541209};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.6666667*tmp0 - basisvalues[1]*0.66666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.028571429 + Y*1.8) - basisvalues[5]*0.77142857;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.28571429 + Y*2.0) - basisvalues[4]*0.71428571;
      basisvalues[12] = basisvalues[7]*(1.0204082 + Y*2.5714286) - basisvalues[3]*0.55102041;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients
      static const double coefficients0[15] = \
      {0.12570787, 0.13196578, -0.025396825, 0.13910414, -0.07183307, 0.031104632, 0.063350813, 0.026770605, -0.062209263, 0.047888713, 0.0, 0.05666269, -0.083805248, 0.083462485, -0.053541209};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.6666667*tmp0 - basisvalues[1]*0.66666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.028571429 + Y*1.8) - basisvalues[5]*0.77142857;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.28571429 + Y*2.0) - basisvalues[4]*0.71428571;
      basisvalues[12] = basisvalues[7]*(1.0204082 + Y*2.5714286) - basisvalues[3]*0.55102041;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients
      static const double coefficients0[15] = \
      {-0.031426968, 0.010997148, 0.0063492063, 0.0, 0.18856181, -0.16329932, 0.0, 0.093697116, 0.0, -0.041902624, 0.0, 0.0, 0.083805248, -0.13910414, 0.10708242};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.6666667*tmp0 - basisvalues[1]*0.66666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.028571429 + Y*1.8) - basisvalues[5]*0.77142857;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.28571429 + Y*2.0) - basisvalues[4]*0.71428571;
      basisvalues[12] = basisvalues[7]*(1.0204082 + Y*2.5714286) - basisvalues[3]*0.55102041;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients
      static const double coefficients0[15] = \
      {0.12570787, 0.043988592, 0.12698413, 0.0, 0.035916535, 0.15552316, 0.0, 0.0, 0.10368211, -0.011972178, 0.0, 0.0, 0.0, 0.092736094, -0.10708242};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.6666667*tmp0 - basisvalues[1]*0.66666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.028571429 + Y*1.8) - basisvalues[5]*0.77142857;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.28571429 + Y*2.0) - basisvalues[4]*0.71428571;
      basisvalues[12] = basisvalues[7]*(1.0204082 + Y*2.5714286) - basisvalues[3]*0.55102041;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients
      static const double coefficients0[15] = \
      {0.12570787, -0.13196578, -0.025396825, 0.13910414, 0.07183307, 0.031104632, -0.063350813, 0.026770605, 0.062209263, 0.047888713, 0.0, -0.05666269, -0.083805248, -0.083462485, -0.053541209};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.6666667*tmp0 - basisvalues[1]*0.66666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.028571429 + Y*1.8) - basisvalues[5]*0.77142857;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.28571429 + Y*2.0) - basisvalues[4]*0.71428571;
      basisvalues[12] = basisvalues[7]*(1.0204082 + Y*2.5714286) - basisvalues[3]*0.55102041;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients
      static const double coefficients0[15] = \
      {-0.031426968, -0.010997148, 0.0063492063, 0.0, -0.18856181, -0.16329932, 0.0, 0.093697116, 0.0, -0.041902624, 0.0, 0.0, 0.083805248, 0.13910414, 0.10708242};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.6666667*tmp0 - basisvalues[1]*0.66666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.028571429 + Y*1.8) - basisvalues[5]*0.77142857;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.28571429 + Y*2.0) - basisvalues[4]*0.71428571;
      basisvalues[12] = basisvalues[7]*(1.0204082 + Y*2.5714286) - basisvalues[3]*0.55102041;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients
      static const double coefficients0[15] = \
      {0.12570787, -0.043988592, 0.12698413, 0.0, -0.035916535, 0.15552316, 0.0, 0.0, -0.10368211, -0.011972178, 0.0, 0.0, 0.0, -0.092736094, -0.10708242};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.6666667*tmp0 - basisvalues[1]*0.66666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.028571429 + Y*1.8) - basisvalues[5]*0.77142857;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.28571429 + Y*2.0) - basisvalues[4]*0.71428571;
      basisvalues[12] = basisvalues[7]*(1.0204082 + Y*2.5714286) - basisvalues[3]*0.55102041;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients
      static const double coefficients0[15] = \
      {0.12570787, -0.087977184, -0.1015873, 0.092736094, 0.1077496, 0.072577474, 0.079188516, -0.013385302, -0.051841053, -0.041902624, -0.1284989, -0.05666269, -0.011972178, 0.0092736094, 0.010708242};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.6666667*tmp0 - basisvalues[1]*0.66666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.028571429 + Y*1.8) - basisvalues[5]*0.77142857;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.28571429 + Y*2.0) - basisvalues[4]*0.71428571;
      basisvalues[12] = basisvalues[7]*(1.0204082 + Y*2.5714286) - basisvalues[3]*0.55102041;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients
      static const double coefficients0[15] = \
      {-0.031426968, 0.0, -0.012698413, -0.24343225, 0.0, 0.054433105, 0.0, 0.093697116, 0.0, -0.041902624, 0.19274835, 0.0, -0.023944357, 0.0, 0.010708242};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.6666667*tmp0 - basisvalues[1]*0.66666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.028571429 + Y*1.8) - basisvalues[5]*0.77142857;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.28571429 + Y*2.0) - basisvalues[4]*0.71428571;
      basisvalues[12] = basisvalues[7]*(1.0204082 + Y*2.5714286) - basisvalues[3]*0.55102041;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients
      static const double coefficients0[15] = \
      {0.12570787, 0.087977184, -0.1015873, 0.092736094, -0.1077496, 0.072577474, -0.079188516, -0.013385302, 0.051841053, -0.041902624, -0.1284989, 0.05666269, -0.011972178, -0.0092736094, 0.010708242};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point x in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* x,
                                  const double* vertex_coordinates,
                                  int cell_orientation) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 12; r++)
    {
      evaluate_basis(r, &dof_values, x, vertex_coordinates, cell_orientation);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point x in cell
  virtual void evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double* values,
                                          const double* x,
                                          const double* vertex_coordinates,
                                          int cell_orientation) const
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[2] + vertex_coordinates[4];
    const double C1 = vertex_coordinates[3] + vertex_coordinates[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K[0], K[1]}, {K[2], K[3]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.6666667*tmp0 - basisvalues[1]*0.66666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.028571429 + Y*1.8) - basisvalues[5]*0.77142857;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.28571429 + Y*2.0) - basisvalues[4]*0.71428571;
      basisvalues[12] = basisvalues[7]*(1.0204082 + Y*2.5714286) - basisvalues[3]*0.55102041;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients
      static const double coefficients0[15] = \
      {0.0, -0.041239305, -0.023809524, 0.028980029, 0.022447834, 0.012960263, -0.039594258, -0.033463256, -0.025920526, -0.014965223, 0.032124725, 0.028331345, 0.023944357, 0.018547219, 0.010708242};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.8989795, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.486833, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.0710678, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.2915026, 0.0, -2.9933259, 13.662601, 0.0, 0.61101009, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.3817805, 0.0, 0.0, 12.521981, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.4641016, 0.0, 7.8383672, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.954451, 0.0, 0.0, -3.8332594, 0.0, 17.748239, 0.0, 0.55328334, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638, 0.0, 3.3466401, 4.3643578, 0.0, -5.0746804, 0.0, 17.008401, 0.0, 1.5212777, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.4494897, 0.0, 0.0, 9.1428571, 0.0, 0.0, 0.0, 14.84615, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.0983867, 0.0, 7.6681158, 0.0, 0.0, 10.733126, 0.0, 0.0, 0.0, 9.29516, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426407, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5819889, 4.7434165, -0.91287093, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.1237244, 3.5355339, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094011, 0.0, 8.1649658, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6457513, 5.1845926, -1.496663, 6.8313005, -1.0583005, 0.30550505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.236068, 2.1908902, 2.5298221, 8.0829038, 6.2609903, -1.8073922, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7320508, -5.0911688, 3.9191836, 0.0, 9.6994845, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.0, 0.0, -2.8284271, 0.0, 0.0, 12.124356, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6832816, 5.4772256, -1.8973666, 7.4230749, -1.9166297, 0.66394, 8.8741197, -1.0714286, 0.27664167, -0.095831485, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.3664319, 2.8982753, 1.6733201, 2.1821789, 5.7470489, -2.5373402, 10.062306, 8.5042006, -2.1957752, 0.76063883, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.2247449, 3.5355339, -7.3771111, 4.5714286, 1.6495722, 0.0, 11.499778, 7.4230749, -2.5714286, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5491933, 6.6407831, 3.8340579, 0.0, -6.1967734, 5.3665631, 0.0, 0.0, 13.416408, 4.64758, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.5777088, 0.0, 8.8543774, 0.0, 0.0, -3.0983867, 0.0, 0.0, 0.0, 16.099689, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.6666667*tmp0 - basisvalues[1]*0.66666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.028571429 + Y*1.8) - basisvalues[5]*0.77142857;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.28571429 + Y*2.0) - basisvalues[4]*0.71428571;
      basisvalues[12] = basisvalues[7]*(1.0204082 + Y*2.5714286) - basisvalues[3]*0.55102041;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients
      static const double coefficients0[15] = \
      {0.0, 0.041239305, -0.023809524, 0.028980029, -0.022447834, 0.012960263, 0.039594258, -0.033463256, 0.025920526, -0.014965223, 0.032124725, -0.028331345, 0.023944357, -0.018547219, 0.010708242};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.8989795, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.486833, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.0710678, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.2915026, 0.0, -2.9933259, 13.662601, 0.0, 0.61101009, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.3817805, 0.0, 0.0, 12.521981, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.4641016, 0.0, 7.8383672, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.954451, 0.0, 0.0, -3.8332594, 0.0, 17.748239, 0.0, 0.55328334, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638, 0.0, 3.3466401, 4.3643578, 0.0, -5.0746804, 0.0, 17.008401, 0.0, 1.5212777, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.4494897, 0.0, 0.0, 9.1428571, 0.0, 0.0, 0.0, 14.84615, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.0983867, 0.0, 7.6681158, 0.0, 0.0, 10.733126, 0.0, 0.0, 0.0, 9.29516, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426407, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5819889, 4.7434165, -0.91287093, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.1237244, 3.5355339, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094011, 0.0, 8.1649658, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6457513, 5.1845926, -1.496663, 6.8313005, -1.0583005, 0.30550505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.236068, 2.1908902, 2.5298221, 8.0829038, 6.2609903, -1.8073922, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7320508, -5.0911688, 3.9191836, 0.0, 9.6994845, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.0, 0.0, -2.8284271, 0.0, 0.0, 12.124356, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6832816, 5.4772256, -1.8973666, 7.4230749, -1.9166297, 0.66394, 8.8741197, -1.0714286, 0.27664167, -0.095831485, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.3664319, 2.8982753, 1.6733201, 2.1821789, 5.7470489, -2.5373402, 10.062306, 8.5042006, -2.1957752, 0.76063883, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.2247449, 3.5355339, -7.3771111, 4.5714286, 1.6495722, 0.0, 11.499778, 7.4230749, -2.5714286, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5491933, 6.6407831, 3.8340579, 0.0, -6.1967734, 5.3665631, 0.0, 0.0, 13.416408, 4.64758, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.5777088, 0.0, 8.8543774, 0.0, 0.0, -3.0983867, 0.0, 0.0, 0.0, 16.099689, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.6666667*tmp0 - basisvalues[1]*0.66666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.028571429 + Y*1.8) - basisvalues[5]*0.77142857;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.28571429 + Y*2.0) - basisvalues[4]*0.71428571;
      basisvalues[12] = basisvalues[7]*(1.0204082 + Y*2.5714286) - basisvalues[3]*0.55102041;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients
      static const double coefficients0[15] = \
      {0.0, 0.0, 0.047619048, 0.0, 0.0, 0.03888079, 0.0, 0.0, 0.0, 0.059860892, 0.0, 0.0, 0.0, 0.0, 0.053541209};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.8989795, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.486833, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.0710678, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.2915026, 0.0, -2.9933259, 13.662601, 0.0, 0.61101009, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.3817805, 0.0, 0.0, 12.521981, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.4641016, 0.0, 7.8383672, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.954451, 0.0, 0.0, -3.8332594, 0.0, 17.748239, 0.0, 0.55328334, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638, 0.0, 3.3466401, 4.3643578, 0.0, -5.0746804, 0.0, 17.008401, 0.0, 1.5212777, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.4494897, 0.0, 0.0, 9.1428571, 0.0, 0.0, 0.0, 14.84615, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.0983867, 0.0, 7.6681158, 0.0, 0.0, 10.733126, 0.0, 0.0, 0.0, 9.29516, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426407, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5819889, 4.7434165, -0.91287093, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.1237244, 3.5355339, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094011, 0.0, 8.1649658, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6457513, 5.1845926, -1.496663, 6.8313005, -1.0583005, 0.30550505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.236068, 2.1908902, 2.5298221, 8.0829038, 6.2609903, -1.8073922, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7320508, -5.0911688, 3.9191836, 0.0, 9.6994845, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.0, 0.0, -2.8284271, 0.0, 0.0, 12.124356, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6832816, 5.4772256, -1.8973666, 7.4230749, -1.9166297, 0.66394, 8.8741197, -1.0714286, 0.27664167, -0.095831485, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.3664319, 2.8982753, 1.6733201, 2.1821789, 5.7470489, -2.5373402, 10.062306, 8.5042006, -2.1957752, 0.76063883, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.2247449, 3.5355339, -7.3771111, 4.5714286, 1.6495722, 0.0, 11.499778, 7.4230749, -2.5714286, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5491933, 6.6407831, 3.8340579, 0.0, -6.1967734, 5.3665631, 0.0, 0.0, 13.416408, 4.64758, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.5777088, 0.0, 8.8543774, 0.0, 0.0, -3.0983867, 0.0, 0.0, 0.0, 16.099689, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.6666667*tmp0 - basisvalues[1]*0.66666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.028571429 + Y*1.8) - basisvalues[5]*0.77142857;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.28571429 + Y*2.0) - basisvalues[4]*0.71428571;
      basisvalues[12] = basisvalues[7]*(1.0204082 + Y*2.5714286) - basisvalues[3]*0.55102041;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients
      static const double coefficients0[15] = \
      {0.12570787, 0.13196578, -0.025396825, 0.13910414, -0.07183307, 0.031104632, 0.063350813, 0.026770605, -0.062209263, 0.047888713, 0.0, 0.05666269, -0.083805248, 0.083462485, -0.053541209};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.8989795, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.486833, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.0710678, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.2915026, 0.0, -2.9933259, 13.662601, 0.0, 0.61101009, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.3817805, 0.0, 0.0, 12.521981, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.4641016, 0.0, 7.8383672, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.954451, 0.0, 0.0, -3.8332594, 0.0, 17.748239, 0.0, 0.55328334, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638, 0.0, 3.3466401, 4.3643578, 0.0, -5.0746804, 0.0, 17.008401, 0.0, 1.5212777, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.4494897, 0.0, 0.0, 9.1428571, 0.0, 0.0, 0.0, 14.84615, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.0983867, 0.0, 7.6681158, 0.0, 0.0, 10.733126, 0.0, 0.0, 0.0, 9.29516, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426407, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5819889, 4.7434165, -0.91287093, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.1237244, 3.5355339, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094011, 0.0, 8.1649658, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6457513, 5.1845926, -1.496663, 6.8313005, -1.0583005, 0.30550505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.236068, 2.1908902, 2.5298221, 8.0829038, 6.2609903, -1.8073922, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7320508, -5.0911688, 3.9191836, 0.0, 9.6994845, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.0, 0.0, -2.8284271, 0.0, 0.0, 12.124356, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6832816, 5.4772256, -1.8973666, 7.4230749, -1.9166297, 0.66394, 8.8741197, -1.0714286, 0.27664167, -0.095831485, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.3664319, 2.8982753, 1.6733201, 2.1821789, 5.7470489, -2.5373402, 10.062306, 8.5042006, -2.1957752, 0.76063883, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.2247449, 3.5355339, -7.3771111, 4.5714286, 1.6495722, 0.0, 11.499778, 7.4230749, -2.5714286, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5491933, 6.6407831, 3.8340579, 0.0, -6.1967734, 5.3665631, 0.0, 0.0, 13.416408, 4.64758, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.5777088, 0.0, 8.8543774, 0.0, 0.0, -3.0983867, 0.0, 0.0, 0.0, 16.099689, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.6666667*tmp0 - basisvalues[1]*0.66666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.028571429 + Y*1.8) - basisvalues[5]*0.77142857;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.28571429 + Y*2.0) - basisvalues[4]*0.71428571;
      basisvalues[12] = basisvalues[7]*(1.0204082 + Y*2.5714286) - basisvalues[3]*0.55102041;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients
      static const double coefficients0[15] = \
      {-0.031426968, 0.010997148, 0.0063492063, 0.0, 0.18856181, -0.16329932, 0.0, 0.093697116, 0.0, -0.041902624, 0.0, 0.0, 0.083805248, -0.13910414, 0.10708242};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.8989795, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.486833, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.0710678, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.2915026, 0.0, -2.9933259, 13.662601, 0.0, 0.61101009, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.3817805, 0.0, 0.0, 12.521981, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.4641016, 0.0, 7.8383672, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.954451, 0.0, 0.0, -3.8332594, 0.0, 17.748239, 0.0, 0.55328334, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638, 0.0, 3.3466401, 4.3643578, 0.0, -5.0746804, 0.0, 17.008401, 0.0, 1.5212777, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.4494897, 0.0, 0.0, 9.1428571, 0.0, 0.0, 0.0, 14.84615, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.0983867, 0.0, 7.6681158, 0.0, 0.0, 10.733126, 0.0, 0.0, 0.0, 9.29516, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426407, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5819889, 4.7434165, -0.91287093, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.1237244, 3.5355339, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094011, 0.0, 8.1649658, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6457513, 5.1845926, -1.496663, 6.8313005, -1.0583005, 0.30550505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.236068, 2.1908902, 2.5298221, 8.0829038, 6.2609903, -1.8073922, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7320508, -5.0911688, 3.9191836, 0.0, 9.6994845, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.0, 0.0, -2.8284271, 0.0, 0.0, 12.124356, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6832816, 5.4772256, -1.8973666, 7.4230749, -1.9166297, 0.66394, 8.8741197, -1.0714286, 0.27664167, -0.095831485, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.3664319, 2.8982753, 1.6733201, 2.1821789, 5.7470489, -2.5373402, 10.062306, 8.5042006, -2.1957752, 0.76063883, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.2247449, 3.5355339, -7.3771111, 4.5714286, 1.6495722, 0.0, 11.499778, 7.4230749, -2.5714286, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5491933, 6.6407831, 3.8340579, 0.0, -6.1967734, 5.3665631, 0.0, 0.0, 13.416408, 4.64758, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.5777088, 0.0, 8.8543774, 0.0, 0.0, -3.0983867, 0.0, 0.0, 0.0, 16.099689, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.6666667*tmp0 - basisvalues[1]*0.66666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.028571429 + Y*1.8) - basisvalues[5]*0.77142857;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.28571429 + Y*2.0) - basisvalues[4]*0.71428571;
      basisvalues[12] = basisvalues[7]*(1.0204082 + Y*2.5714286) - basisvalues[3]*0.55102041;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients
      static const double coefficients0[15] = \
      {0.12570787, 0.043988592, 0.12698413, 0.0, 0.035916535, 0.15552316, 0.0, 0.0, 0.10368211, -0.011972178, 0.0, 0.0, 0.0, 0.092736094, -0.10708242};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.8989795, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.486833, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.0710678, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.2915026, 0.0, -2.9933259, 13.662601, 0.0, 0.61101009, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.3817805, 0.0, 0.0, 12.521981, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.4641016, 0.0, 7.8383672, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.954451, 0.0, 0.0, -3.8332594, 0.0, 17.748239, 0.0, 0.55328334, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638, 0.0, 3.3466401, 4.3643578, 0.0, -5.0746804, 0.0, 17.008401, 0.0, 1.5212777, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.4494897, 0.0, 0.0, 9.1428571, 0.0, 0.0, 0.0, 14.84615, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.0983867, 0.0, 7.6681158, 0.0, 0.0, 10.733126, 0.0, 0.0, 0.0, 9.29516, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426407, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5819889, 4.7434165, -0.91287093, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.1237244, 3.5355339, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094011, 0.0, 8.1649658, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6457513, 5.1845926, -1.496663, 6.8313005, -1.0583005, 0.30550505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.236068, 2.1908902, 2.5298221, 8.0829038, 6.2609903, -1.8073922, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7320508, -5.0911688, 3.9191836, 0.0, 9.6994845, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.0, 0.0, -2.8284271, 0.0, 0.0, 12.124356, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6832816, 5.4772256, -1.8973666, 7.4230749, -1.9166297, 0.66394, 8.8741197, -1.0714286, 0.27664167, -0.095831485, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.3664319, 2.8982753, 1.6733201, 2.1821789, 5.7470489, -2.5373402, 10.062306, 8.5042006, -2.1957752, 0.76063883, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.2247449, 3.5355339, -7.3771111, 4.5714286, 1.6495722, 0.0, 11.499778, 7.4230749, -2.5714286, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5491933, 6.6407831, 3.8340579, 0.0, -6.1967734, 5.3665631, 0.0, 0.0, 13.416408, 4.64758, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.5777088, 0.0, 8.8543774, 0.0, 0.0, -3.0983867, 0.0, 0.0, 0.0, 16.099689, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.6666667*tmp0 - basisvalues[1]*0.66666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.028571429 + Y*1.8) - basisvalues[5]*0.77142857;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.28571429 + Y*2.0) - basisvalues[4]*0.71428571;
      basisvalues[12] = basisvalues[7]*(1.0204082 + Y*2.5714286) - basisvalues[3]*0.55102041;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients
      static const double coefficients0[15] = \
      {0.12570787, -0.13196578, -0.025396825, 0.13910414, 0.07183307, 0.031104632, -0.063350813, 0.026770605, 0.062209263, 0.047888713, 0.0, -0.05666269, -0.083805248, -0.083462485, -0.053541209};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.8989795, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.486833, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.0710678, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.2915026, 0.0, -2.9933259, 13.662601, 0.0, 0.61101009, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.3817805, 0.0, 0.0, 12.521981, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.4641016, 0.0, 7.8383672, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.954451, 0.0, 0.0, -3.8332594, 0.0, 17.748239, 0.0, 0.55328334, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638, 0.0, 3.3466401, 4.3643578, 0.0, -5.0746804, 0.0, 17.008401, 0.0, 1.5212777, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.4494897, 0.0, 0.0, 9.1428571, 0.0, 0.0, 0.0, 14.84615, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.0983867, 0.0, 7.6681158, 0.0, 0.0, 10.733126, 0.0, 0.0, 0.0, 9.29516, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426407, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5819889, 4.7434165, -0.91287093, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.1237244, 3.5355339, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094011, 0.0, 8.1649658, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6457513, 5.1845926, -1.496663, 6.8313005, -1.0583005, 0.30550505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.236068, 2.1908902, 2.5298221, 8.0829038, 6.2609903, -1.8073922, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7320508, -5.0911688, 3.9191836, 0.0, 9.6994845, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.0, 0.0, -2.8284271, 0.0, 0.0, 12.124356, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6832816, 5.4772256, -1.8973666, 7.4230749, -1.9166297, 0.66394, 8.8741197, -1.0714286, 0.27664167, -0.095831485, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.3664319, 2.8982753, 1.6733201, 2.1821789, 5.7470489, -2.5373402, 10.062306, 8.5042006, -2.1957752, 0.76063883, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.2247449, 3.5355339, -7.3771111, 4.5714286, 1.6495722, 0.0, 11.499778, 7.4230749, -2.5714286, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5491933, 6.6407831, 3.8340579, 0.0, -6.1967734, 5.3665631, 0.0, 0.0, 13.416408, 4.64758, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.5777088, 0.0, 8.8543774, 0.0, 0.0, -3.0983867, 0.0, 0.0, 0.0, 16.099689, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.6666667*tmp0 - basisvalues[1]*0.66666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.028571429 + Y*1.8) - basisvalues[5]*0.77142857;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.28571429 + Y*2.0) - basisvalues[4]*0.71428571;
      basisvalues[12] = basisvalues[7]*(1.0204082 + Y*2.5714286) - basisvalues[3]*0.55102041;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients
      static const double coefficients0[15] = \
      {-0.031426968, -0.010997148, 0.0063492063, 0.0, -0.18856181, -0.16329932, 0.0, 0.093697116, 0.0, -0.041902624, 0.0, 0.0, 0.083805248, 0.13910414, 0.10708242};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.8989795, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.486833, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.0710678, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.2915026, 0.0, -2.9933259, 13.662601, 0.0, 0.61101009, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.3817805, 0.0, 0.0, 12.521981, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.4641016, 0.0, 7.8383672, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.954451, 0.0, 0.0, -3.8332594, 0.0, 17.748239, 0.0, 0.55328334, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638, 0.0, 3.3466401, 4.3643578, 0.0, -5.0746804, 0.0, 17.008401, 0.0, 1.5212777, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.4494897, 0.0, 0.0, 9.1428571, 0.0, 0.0, 0.0, 14.84615, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.0983867, 0.0, 7.6681158, 0.0, 0.0, 10.733126, 0.0, 0.0, 0.0, 9.29516, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426407, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5819889, 4.7434165, -0.91287093, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.1237244, 3.5355339, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094011, 0.0, 8.1649658, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6457513, 5.1845926, -1.496663, 6.8313005, -1.0583005, 0.30550505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.236068, 2.1908902, 2.5298221, 8.0829038, 6.2609903, -1.8073922, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7320508, -5.0911688, 3.9191836, 0.0, 9.6994845, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.0, 0.0, -2.8284271, 0.0, 0.0, 12.124356, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6832816, 5.4772256, -1.8973666, 7.4230749, -1.9166297, 0.66394, 8.8741197, -1.0714286, 0.27664167, -0.095831485, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.3664319, 2.8982753, 1.6733201, 2.1821789, 5.7470489, -2.5373402, 10.062306, 8.5042006, -2.1957752, 0.76063883, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.2247449, 3.5355339, -7.3771111, 4.5714286, 1.6495722, 0.0, 11.499778, 7.4230749, -2.5714286, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5491933, 6.6407831, 3.8340579, 0.0, -6.1967734, 5.3665631, 0.0, 0.0, 13.416408, 4.64758, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.5777088, 0.0, 8.8543774, 0.0, 0.0, -3.0983867, 0.0, 0.0, 0.0, 16.099689, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.6666667*tmp0 - basisvalues[1]*0.66666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.028571429 + Y*1.8) - basisvalues[5]*0.77142857;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.28571429 + Y*2.0) - basisvalues[4]*0.71428571;
      basisvalues[12] = basisvalues[7]*(1.0204082 + Y*2.5714286) - basisvalues[3]*0.55102041;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients
      static const double coefficients0[15] = \
      {0.12570787, -0.043988592, 0.12698413, 0.0, -0.035916535, 0.15552316, 0.0, 0.0, -0.10368211, -0.011972178, 0.0, 0.0, 0.0, -0.092736094, -0.10708242};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.8989795, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.486833, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.0710678, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.2915026, 0.0, -2.9933259, 13.662601, 0.0, 0.61101009, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.3817805, 0.0, 0.0, 12.521981, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.4641016, 0.0, 7.8383672, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.954451, 0.0, 0.0, -3.8332594, 0.0, 17.748239, 0.0, 0.55328334, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638, 0.0, 3.3466401, 4.3643578, 0.0, -5.0746804, 0.0, 17.008401, 0.0, 1.5212777, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.4494897, 0.0, 0.0, 9.1428571, 0.0, 0.0, 0.0, 14.84615, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.0983867, 0.0, 7.6681158, 0.0, 0.0, 10.733126, 0.0, 0.0, 0.0, 9.29516, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426407, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5819889, 4.7434165, -0.91287093, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.1237244, 3.5355339, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094011, 0.0, 8.1649658, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6457513, 5.1845926, -1.496663, 6.8313005, -1.0583005, 0.30550505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.236068, 2.1908902, 2.5298221, 8.0829038, 6.2609903, -1.8073922, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7320508, -5.0911688, 3.9191836, 0.0, 9.6994845, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.0, 0.0, -2.8284271, 0.0, 0.0, 12.124356, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6832816, 5.4772256, -1.8973666, 7.4230749, -1.9166297, 0.66394, 8.8741197, -1.0714286, 0.27664167, -0.095831485, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.3664319, 2.8982753, 1.6733201, 2.1821789, 5.7470489, -2.5373402, 10.062306, 8.5042006, -2.1957752, 0.76063883, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.2247449, 3.5355339, -7.3771111, 4.5714286, 1.6495722, 0.0, 11.499778, 7.4230749, -2.5714286, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5491933, 6.6407831, 3.8340579, 0.0, -6.1967734, 5.3665631, 0.0, 0.0, 13.416408, 4.64758, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.5777088, 0.0, 8.8543774, 0.0, 0.0, -3.0983867, 0.0, 0.0, 0.0, 16.099689, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.6666667*tmp0 - basisvalues[1]*0.66666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.028571429 + Y*1.8) - basisvalues[5]*0.77142857;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.28571429 + Y*2.0) - basisvalues[4]*0.71428571;
      basisvalues[12] = basisvalues[7]*(1.0204082 + Y*2.5714286) - basisvalues[3]*0.55102041;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients
      static const double coefficients0[15] = \
      {0.12570787, -0.087977184, -0.1015873, 0.092736094, 0.1077496, 0.072577474, 0.079188516, -0.013385302, -0.051841053, -0.041902624, -0.1284989, -0.05666269, -0.011972178, 0.0092736094, 0.010708242};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.8989795, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.486833, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.0710678, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.2915026, 0.0, -2.9933259, 13.662601, 0.0, 0.61101009, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.3817805, 0.0, 0.0, 12.521981, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.4641016, 0.0, 7.8383672, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.954451, 0.0, 0.0, -3.8332594, 0.0, 17.748239, 0.0, 0.55328334, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638, 0.0, 3.3466401, 4.3643578, 0.0, -5.0746804, 0.0, 17.008401, 0.0, 1.5212777, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.4494897, 0.0, 0.0, 9.1428571, 0.0, 0.0, 0.0, 14.84615, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.0983867, 0.0, 7.6681158, 0.0, 0.0, 10.733126, 0.0, 0.0, 0.0, 9.29516, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426407, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5819889, 4.7434165, -0.91287093, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.1237244, 3.5355339, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094011, 0.0, 8.1649658, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6457513, 5.1845926, -1.496663, 6.8313005, -1.0583005, 0.30550505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.236068, 2.1908902, 2.5298221, 8.0829038, 6.2609903, -1.8073922, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7320508, -5.0911688, 3.9191836, 0.0, 9.6994845, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.0, 0.0, -2.8284271, 0.0, 0.0, 12.124356, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6832816, 5.4772256, -1.8973666, 7.4230749, -1.9166297, 0.66394, 8.8741197, -1.0714286, 0.27664167, -0.095831485, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.3664319, 2.8982753, 1.6733201, 2.1821789, 5.7470489, -2.5373402, 10.062306, 8.5042006, -2.1957752, 0.76063883, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.2247449, 3.5355339, -7.3771111, 4.5714286, 1.6495722, 0.0, 11.499778, 7.4230749, -2.5714286, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5491933, 6.6407831, 3.8340579, 0.0, -6.1967734, 5.3665631, 0.0, 0.0, 13.416408, 4.64758, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.5777088, 0.0, 8.8543774, 0.0, 0.0, -3.0983867, 0.0, 0.0, 0.0, 16.099689, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 10:
      {
        
      // Array of basisvalues
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.6666667*tmp0 - basisvalues[1]*0.66666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.028571429 + Y*1.8) - basisvalues[5]*0.77142857;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.28571429 + Y*2.0) - basisvalues[4]*0.71428571;
      basisvalues[12] = basisvalues[7]*(1.0204082 + Y*2.5714286) - basisvalues[3]*0.55102041;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients
      static const double coefficients0[15] = \
      {-0.031426968, 0.0, -0.012698413, -0.24343225, 0.0, 0.054433105, 0.0, 0.093697116, 0.0, -0.041902624, 0.19274835, 0.0, -0.023944357, 0.0, 0.010708242};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.8989795, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.486833, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.0710678, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.2915026, 0.0, -2.9933259, 13.662601, 0.0, 0.61101009, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.3817805, 0.0, 0.0, 12.521981, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.4641016, 0.0, 7.8383672, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.954451, 0.0, 0.0, -3.8332594, 0.0, 17.748239, 0.0, 0.55328334, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638, 0.0, 3.3466401, 4.3643578, 0.0, -5.0746804, 0.0, 17.008401, 0.0, 1.5212777, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.4494897, 0.0, 0.0, 9.1428571, 0.0, 0.0, 0.0, 14.84615, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.0983867, 0.0, 7.6681158, 0.0, 0.0, 10.733126, 0.0, 0.0, 0.0, 9.29516, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426407, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5819889, 4.7434165, -0.91287093, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.1237244, 3.5355339, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094011, 0.0, 8.1649658, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6457513, 5.1845926, -1.496663, 6.8313005, -1.0583005, 0.30550505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.236068, 2.1908902, 2.5298221, 8.0829038, 6.2609903, -1.8073922, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7320508, -5.0911688, 3.9191836, 0.0, 9.6994845, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.0, 0.0, -2.8284271, 0.0, 0.0, 12.124356, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6832816, 5.4772256, -1.8973666, 7.4230749, -1.9166297, 0.66394, 8.8741197, -1.0714286, 0.27664167, -0.095831485, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.3664319, 2.8982753, 1.6733201, 2.1821789, 5.7470489, -2.5373402, 10.062306, 8.5042006, -2.1957752, 0.76063883, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.2247449, 3.5355339, -7.3771111, 4.5714286, 1.6495722, 0.0, 11.499778, 7.4230749, -2.5714286, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5491933, 6.6407831, 3.8340579, 0.0, -6.1967734, 5.3665631, 0.0, 0.0, 13.416408, 4.64758, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.5777088, 0.0, 8.8543774, 0.0, 0.0, -3.0983867, 0.0, 0.0, 0.0, 16.099689, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 11:
      {
        
      // Array of basisvalues
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.6666667*tmp0 - basisvalues[1]*0.66666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.11111111 + Y*1.6666667) - basisvalues[0]*0.55555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.028571429 + Y*1.8) - basisvalues[5]*0.77142857;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.28571429 + Y*2.0) - basisvalues[4]*0.71428571;
      basisvalues[12] = basisvalues[7]*(1.0204082 + Y*2.5714286) - basisvalues[3]*0.55102041;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients
      static const double coefficients0[15] = \
      {0.12570787, 0.087977184, -0.1015873, 0.092736094, -0.1077496, 0.072577474, -0.079188516, -0.013385302, 0.051841053, -0.041902624, -0.1284989, 0.05666269, -0.011972178, -0.0092736094, 0.010708242};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.8989795, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.486833, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.0710678, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.2915026, 0.0, -2.9933259, 13.662601, 0.0, 0.61101009, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.3817805, 0.0, 0.0, 12.521981, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.4641016, 0.0, 7.8383672, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.954451, 0.0, 0.0, -3.8332594, 0.0, 17.748239, 0.0, 0.55328334, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.7328638, 0.0, 3.3466401, 4.3643578, 0.0, -5.0746804, 0.0, 17.008401, 0.0, 1.5212777, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.4494897, 0.0, 0.0, 9.1428571, 0.0, 0.0, 0.0, 14.84615, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.0983867, 0.0, 7.6681158, 0.0, 0.0, 10.733126, 0.0, 0.0, 0.0, 9.29516, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.4494897, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.2426407, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.5819889, 4.7434165, -0.91287093, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.1237244, 3.5355339, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094011, 0.0, 8.1649658, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6457513, 5.1845926, -1.496663, 6.8313005, -1.0583005, 0.30550505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.236068, 2.1908902, 2.5298221, 8.0829038, 6.2609903, -1.8073922, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.7320508, -5.0911688, 3.9191836, 0.0, 9.6994845, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.0, 0.0, -2.8284271, 0.0, 0.0, 12.124356, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.6832816, 5.4772256, -1.8973666, 7.4230749, -1.9166297, 0.66394, 8.8741197, -1.0714286, 0.27664167, -0.095831485, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.3664319, 2.8982753, 1.6733201, 2.1821789, 5.7470489, -2.5373402, 10.062306, 8.5042006, -2.1957752, 0.76063883, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 1.2247449, 3.5355339, -7.3771111, 4.5714286, 1.6495722, 0.0, 11.499778, 7.4230749, -2.5714286, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.5491933, 6.6407831, 3.8340579, 0.0, -6.1967734, 5.3665631, 0.0, 0.0, 13.416408, 4.64758, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.5777088, 0.0, 8.8543774, 0.0, 0.0, -3.0983867, 0.0, 0.0, 0.0, 16.099689, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point x in cell
  virtual void evaluate_basis_derivatives_all(std::size_t n,
                                              double* values,
                                              const double* x,
                                              const double* vertex_coordinates,
                                              int cell_orientation) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 12; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, x, vertex_coordinates, cell_orientation);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(std::size_t i,
                              const ufc::function& f,
                              const double* vertex_coordinates,
                              int cell_orientation,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    switch (i)
    {
    case 0:
      {
        y[0] = vertex_coordinates[0];
      y[1] = vertex_coordinates[1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = vertex_coordinates[2];
      y[1] = vertex_coordinates[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = vertex_coordinates[4];
      y[1] = vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.75*vertex_coordinates[2] + 0.25*vertex_coordinates[4];
      y[1] = 0.75*vertex_coordinates[3] + 0.25*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[4];
      y[1] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.25*vertex_coordinates[2] + 0.75*vertex_coordinates[4];
      y[1] = 0.25*vertex_coordinates[3] + 0.75*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.75*vertex_coordinates[0] + 0.25*vertex_coordinates[4];
      y[1] = 0.75*vertex_coordinates[1] + 0.25*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[4];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.25*vertex_coordinates[0] + 0.75*vertex_coordinates[4];
      y[1] = 0.25*vertex_coordinates[1] + 0.75*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.75*vertex_coordinates[0] + 0.25*vertex_coordinates[2];
      y[1] = 0.75*vertex_coordinates[1] + 0.25*vertex_coordinates[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 10:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[2];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 11:
      {
        y[0] = 0.25*vertex_coordinates[0] + 0.75*vertex_coordinates[2];
      y[1] = 0.25*vertex_coordinates[1] + 0.75*vertex_coordinates[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const double* vertex_coordinates,
                             int cell_orientation,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    y[0] = vertex_coordinates[0];
    y[1] = vertex_coordinates[1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = vertex_coordinates[2];
    y[1] = vertex_coordinates[3];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = vertex_coordinates[4];
    y[1] = vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.75*vertex_coordinates[2] + 0.25*vertex_coordinates[4];
    y[1] = 0.75*vertex_coordinates[3] + 0.25*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[4];
    y[1] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.25*vertex_coordinates[2] + 0.75*vertex_coordinates[4];
    y[1] = 0.25*vertex_coordinates[3] + 0.75*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.75*vertex_coordinates[0] + 0.25*vertex_coordinates[4];
    y[1] = 0.75*vertex_coordinates[1] + 0.25*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[4];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.25*vertex_coordinates[0] + 0.75*vertex_coordinates[4];
    y[1] = 0.25*vertex_coordinates[1] + 0.75*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.75*vertex_coordinates[0] + 0.25*vertex_coordinates[2];
    y[1] = 0.75*vertex_coordinates[1] + 0.25*vertex_coordinates[3];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[2];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[3];
    f.evaluate(vals, y, c);
    values[10] = vals[0];
    y[0] = 0.25*vertex_coordinates[0] + 0.75*vertex_coordinates[2];
    y[1] = 0.25*vertex_coordinates[1] + 0.75*vertex_coordinates[3];
    f.evaluate(vals, y, c);
    values[11] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const double* vertex_coordinates,
                                         int cell_orientation,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    std::cerr << "*** FFC warning: " << "map_from_reference_cell not yet implemented." << std::endl;
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    std::cerr << "*** FFC warning: " << "map_to_reference_cell not yet implemented." << std::endl;
  }

  /// Return the number of sub elements (for a mixed element)
  virtual std::size_t num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(std::size_t i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new restrictedelement_finite_element_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class restrictedelement_dofmap_0: public ufc::dofmap
{
public:

  /// Constructor
  restrictedelement_dofmap_0() : ufc::dofmap()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~restrictedelement_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for RestrictedElement(FiniteElement('Lagrange', Domain(Cell('triangle', 2), 'triangle_multiverse', 2, 2), 4, None), Cell('interval', 2))";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Return the topological dimension of the associated cell shape
  virtual std::size_t topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual std::size_t global_dimension(const std::vector<std::size_t>&
                                       num_global_entities) const
  {
    return num_global_entities[0] + 3*num_global_entities[1];
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual std::size_t local_dimension(const ufc::cell& c) const
  {
    return 12;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual std::size_t max_local_dimension() const
  {
    return 12;
  }

  /// Return the number of dofs on each cell facet
  virtual std::size_t num_facet_dofs() const
  {
    return 5;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual std::size_t num_entity_dofs(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 3;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(std::size_t* dofs,
                             const std::vector<std::size_t>& num_global_entities,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += num_global_entities[0];
    dofs[3] = offset + 3*c.entity_indices[1][0];
    dofs[4] = offset + 3*c.entity_indices[1][0] + 1;
    dofs[5] = offset + 3*c.entity_indices[1][0] + 2;
    dofs[6] = offset + 3*c.entity_indices[1][1];
    dofs[7] = offset + 3*c.entity_indices[1][1] + 1;
    dofs[8] = offset + 3*c.entity_indices[1][1] + 2;
    dofs[9] = offset + 3*c.entity_indices[1][2];
    dofs[10] = offset + 3*c.entity_indices[1][2] + 1;
    dofs[11] = offset + 3*c.entity_indices[1][2] + 2;
    offset += 3*num_global_entities[1];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(std::size_t* dofs,
                                   std::size_t facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 6;
      dofs[3] = 7;
      dofs[4] = 8;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 9;
      dofs[3] = 10;
      dofs[4] = 11;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(std::size_t* dofs,
                                    std::size_t d, std::size_t i) const
  {
    if (d > 2)
    {
    std::cerr << "*** FFC warning: " << "d is larger than dimension (2)" << std::endl;
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (2)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (2)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 4;
        dofs[2] = 5;
          break;
        }
      case 1:
        {
          dofs[0] = 6;
        dofs[1] = 7;
        dofs[2] = 8;
          break;
        }
      case 2:
        {
          dofs[0] = 9;
        dofs[1] = 10;
        dofs[2] = 11;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** dof_coordinates,
                                    const double* vertex_coordinates) const
  {
    dof_coordinates[0][0] = vertex_coordinates[0];
    dof_coordinates[0][1] = vertex_coordinates[1];
    dof_coordinates[1][0] = vertex_coordinates[2];
    dof_coordinates[1][1] = vertex_coordinates[3];
    dof_coordinates[2][0] = vertex_coordinates[4];
    dof_coordinates[2][1] = vertex_coordinates[5];
    dof_coordinates[3][0] = 0.75*vertex_coordinates[2] + 0.25*vertex_coordinates[4];
    dof_coordinates[3][1] = 0.75*vertex_coordinates[3] + 0.25*vertex_coordinates[5];
    dof_coordinates[4][0] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[4];
    dof_coordinates[4][1] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[5];
    dof_coordinates[5][0] = 0.25*vertex_coordinates[2] + 0.75*vertex_coordinates[4];
    dof_coordinates[5][1] = 0.25*vertex_coordinates[3] + 0.75*vertex_coordinates[5];
    dof_coordinates[6][0] = 0.75*vertex_coordinates[0] + 0.25*vertex_coordinates[4];
    dof_coordinates[6][1] = 0.75*vertex_coordinates[1] + 0.25*vertex_coordinates[5];
    dof_coordinates[7][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[4];
    dof_coordinates[7][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[5];
    dof_coordinates[8][0] = 0.25*vertex_coordinates[0] + 0.75*vertex_coordinates[4];
    dof_coordinates[8][1] = 0.25*vertex_coordinates[1] + 0.75*vertex_coordinates[5];
    dof_coordinates[9][0] = 0.75*vertex_coordinates[0] + 0.25*vertex_coordinates[2];
    dof_coordinates[9][1] = 0.75*vertex_coordinates[1] + 0.25*vertex_coordinates[3];
    dof_coordinates[10][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[2];
    dof_coordinates[10][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[3];
    dof_coordinates[11][0] = 0.25*vertex_coordinates[0] + 0.75*vertex_coordinates[2];
    dof_coordinates[11][1] = 0.25*vertex_coordinates[1] + 0.75*vertex_coordinates[3];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual std::size_t num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(std::size_t i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new restrictedelement_dofmap_0();
  }

};

/// This class defines the interface for the tabulation of the
/// exterior facet tensor corresponding to the local contribution to
/// a form from the integral over an exterior facet.

class restrictedelement_exterior_facet_integral_0_otherwise: public ufc::exterior_facet_integral
{
public:

  /// Constructor
  restrictedelement_exterior_facet_integral_0_otherwise() : ufc::exterior_facet_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~restrictedelement_exterior_facet_integral_0_otherwise()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local exterior facet
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const double* vertex_coordinates,
                               std::size_t facet) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      10
    // Number of operations (multiply-add pairs) for geometry tensor:    0
    // Number of operations (multiply-add pairs) for tensor contraction: 37
    // Total number of operations (multiply-add pairs):                  47
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Get vertices on edge
    static unsigned int edge_vertices[3][2] = {{1, 2}, {0, 2}, {0, 1}};
    const unsigned int v0 = edge_vertices[facet][0];
    const unsigned int v1 = edge_vertices[facet][1];
    
    // Compute scale factor (length of edge scaled by length of reference interval)
    const double dx0 = vertex_coordinates[2*v1 + 0] - vertex_coordinates[2*v0 + 0];
    const double dx1 = vertex_coordinates[2*v1 + 1] - vertex_coordinates[2*v0 + 1];
    const double det = std::sqrt(dx0*dx0 + dx1*dx1);
    
    
    // Compute geometry tensor
    const double G0_ = det;
    
    // Compute element tensor
    switch (facet)
    {
    case 0:
      {
        A[0] = 0.0;
      A[1] = 0.0;
      A[2] = 0.0;
      A[3] = 0.0;
      A[4] = 0.0;
      A[5] = 0.0;
      A[6] = 0.0;
      A[7] = 0.0;
      A[8] = 0.0;
      A[9] = 0.0;
      A[10] = 0.0;
      A[11] = 0.0;
      A[12] = 0.0;
      A[13] = 0.051499118*G0_;
      A[14] = -0.0051146384*G0_;
      A[15] = 0.052204586*G0_;
      A[16] = -0.030687831*G0_;
      A[17] = 0.0098765432*G0_;
      A[18] = 0.0;
      A[19] = 0.0;
      A[20] = 0.0;
      A[21] = 0.0;
      A[22] = 0.0;
      A[23] = 0.0;
      A[24] = 0.0;
      A[25] = -0.0051146384*G0_;
      A[26] = 0.051499118*G0_;
      A[27] = 0.0098765432*G0_;
      A[28] = -0.030687831*G0_;
      A[29] = 0.052204586*G0_;
      A[30] = 0.0;
      A[31] = 0.0;
      A[32] = 0.0;
      A[33] = 0.0;
      A[34] = 0.0;
      A[35] = 0.0;
      A[36] = 0.0;
      A[37] = 0.052204586*G0_;
      A[38] = 0.0098765432*G0_;
      A[39] = 0.31604938*G0_;
      A[40] = -0.067724868*G0_;
      A[41] = 0.045149912*G0_;
      A[42] = 0.0;
      A[43] = 0.0;
      A[44] = 0.0;
      A[45] = 0.0;
      A[46] = 0.0;
      A[47] = 0.0;
      A[48] = 0.0;
      A[49] = -0.030687831*G0_;
      A[50] = -0.030687831*G0_;
      A[51] = -0.067724868*G0_;
      A[52] = 0.33015873*G0_;
      A[53] = -0.067724868*G0_;
      A[54] = 0.0;
      A[55] = 0.0;
      A[56] = 0.0;
      A[57] = 0.0;
      A[58] = 0.0;
      A[59] = 0.0;
      A[60] = 0.0;
      A[61] = 0.0098765432*G0_;
      A[62] = 0.052204586*G0_;
      A[63] = 0.045149912*G0_;
      A[64] = -0.067724868*G0_;
      A[65] = 0.31604938*G0_;
      A[66] = 0.0;
      A[67] = 0.0;
      A[68] = 0.0;
      A[69] = 0.0;
      A[70] = 0.0;
      A[71] = 0.0;
      A[72] = 0.0;
      A[73] = 0.0;
      A[74] = 0.0;
      A[75] = 0.0;
      A[76] = 0.0;
      A[77] = 0.0;
      A[78] = 0.0;
      A[79] = 0.0;
      A[80] = 0.0;
      A[81] = 0.0;
      A[82] = 0.0;
      A[83] = 0.0;
      A[84] = 0.0;
      A[85] = 0.0;
      A[86] = 0.0;
      A[87] = 0.0;
      A[88] = 0.0;
      A[89] = 0.0;
      A[90] = 0.0;
      A[91] = 0.0;
      A[92] = 0.0;
      A[93] = 0.0;
      A[94] = 0.0;
      A[95] = 0.0;
      A[96] = 0.0;
      A[97] = 0.0;
      A[98] = 0.0;
      A[99] = 0.0;
      A[100] = 0.0;
      A[101] = 0.0;
      A[102] = 0.0;
      A[103] = 0.0;
      A[104] = 0.0;
      A[105] = 0.0;
      A[106] = 0.0;
      A[107] = 0.0;
      A[108] = 0.0;
      A[109] = 0.0;
      A[110] = 0.0;
      A[111] = 0.0;
      A[112] = 0.0;
      A[113] = 0.0;
      A[114] = 0.0;
      A[115] = 0.0;
      A[116] = 0.0;
      A[117] = 0.0;
      A[118] = 0.0;
      A[119] = 0.0;
      A[120] = 0.0;
      A[121] = 0.0;
      A[122] = 0.0;
      A[123] = 0.0;
      A[124] = 0.0;
      A[125] = 0.0;
      A[126] = 0.0;
      A[127] = 0.0;
      A[128] = 0.0;
      A[129] = 0.0;
      A[130] = 0.0;
      A[131] = 0.0;
      A[132] = 0.0;
      A[133] = 0.0;
      A[134] = 0.0;
      A[135] = 0.0;
      A[136] = 0.0;
      A[137] = 0.0;
      A[138] = 0.0;
      A[139] = 0.0;
      A[140] = 0.0;
      A[141] = 0.0;
      A[142] = 0.0;
      A[143] = 0.0;
        break;
      }
    case 1:
      {
        A[0] = 0.051499118*G0_;
      A[1] = 0.0;
      A[2] = -0.0051146384*G0_;
      A[3] = 0.0;
      A[4] = 0.0;
      A[5] = 0.0;
      A[6] = 0.052204586*G0_;
      A[7] = -0.030687831*G0_;
      A[8] = 0.0098765432*G0_;
      A[9] = 0.0;
      A[10] = 0.0;
      A[11] = 0.0;
      A[12] = 0.0;
      A[13] = 0.0;
      A[14] = 0.0;
      A[15] = 0.0;
      A[16] = 0.0;
      A[17] = 0.0;
      A[18] = 0.0;
      A[19] = 0.0;
      A[20] = 0.0;
      A[21] = 0.0;
      A[22] = 0.0;
      A[23] = 0.0;
      A[24] = -0.0051146384*G0_;
      A[25] = 0.0;
      A[26] = 0.051499118*G0_;
      A[27] = 0.0;
      A[28] = 0.0;
      A[29] = 0.0;
      A[30] = 0.0098765432*G0_;
      A[31] = -0.030687831*G0_;
      A[32] = 0.052204586*G0_;
      A[33] = 0.0;
      A[34] = 0.0;
      A[35] = 0.0;
      A[36] = 0.0;
      A[37] = 0.0;
      A[38] = 0.0;
      A[39] = 0.0;
      A[40] = 0.0;
      A[41] = 0.0;
      A[42] = 0.0;
      A[43] = 0.0;
      A[44] = 0.0;
      A[45] = 0.0;
      A[46] = 0.0;
      A[47] = 0.0;
      A[48] = 0.0;
      A[49] = 0.0;
      A[50] = 0.0;
      A[51] = 0.0;
      A[52] = 0.0;
      A[53] = 0.0;
      A[54] = 0.0;
      A[55] = 0.0;
      A[56] = 0.0;
      A[57] = 0.0;
      A[58] = 0.0;
      A[59] = 0.0;
      A[60] = 0.0;
      A[61] = 0.0;
      A[62] = 0.0;
      A[63] = 0.0;
      A[64] = 0.0;
      A[65] = 0.0;
      A[66] = 0.0;
      A[67] = 0.0;
      A[68] = 0.0;
      A[69] = 0.0;
      A[70] = 0.0;
      A[71] = 0.0;
      A[72] = 0.052204586*G0_;
      A[73] = 0.0;
      A[74] = 0.0098765432*G0_;
      A[75] = 0.0;
      A[76] = 0.0;
      A[77] = 0.0;
      A[78] = 0.31604938*G0_;
      A[79] = -0.067724868*G0_;
      A[80] = 0.045149912*G0_;
      A[81] = 0.0;
      A[82] = 0.0;
      A[83] = 0.0;
      A[84] = -0.030687831*G0_;
      A[85] = 0.0;
      A[86] = -0.030687831*G0_;
      A[87] = 0.0;
      A[88] = 0.0;
      A[89] = 0.0;
      A[90] = -0.067724868*G0_;
      A[91] = 0.33015873*G0_;
      A[92] = -0.067724868*G0_;
      A[93] = 0.0;
      A[94] = 0.0;
      A[95] = 0.0;
      A[96] = 0.0098765432*G0_;
      A[97] = 0.0;
      A[98] = 0.052204586*G0_;
      A[99] = 0.0;
      A[100] = 0.0;
      A[101] = 0.0;
      A[102] = 0.045149912*G0_;
      A[103] = -0.067724868*G0_;
      A[104] = 0.31604938*G0_;
      A[105] = 0.0;
      A[106] = 0.0;
      A[107] = 0.0;
      A[108] = 0.0;
      A[109] = 0.0;
      A[110] = 0.0;
      A[111] = 0.0;
      A[112] = 0.0;
      A[113] = 0.0;
      A[114] = 0.0;
      A[115] = 0.0;
      A[116] = 0.0;
      A[117] = 0.0;
      A[118] = 0.0;
      A[119] = 0.0;
      A[120] = 0.0;
      A[121] = 0.0;
      A[122] = 0.0;
      A[123] = 0.0;
      A[124] = 0.0;
      A[125] = 0.0;
      A[126] = 0.0;
      A[127] = 0.0;
      A[128] = 0.0;
      A[129] = 0.0;
      A[130] = 0.0;
      A[131] = 0.0;
      A[132] = 0.0;
      A[133] = 0.0;
      A[134] = 0.0;
      A[135] = 0.0;
      A[136] = 0.0;
      A[137] = 0.0;
      A[138] = 0.0;
      A[139] = 0.0;
      A[140] = 0.0;
      A[141] = 0.0;
      A[142] = 0.0;
      A[143] = 0.0;
        break;
      }
    case 2:
      {
        A[0] = 0.051499118*G0_;
      A[1] = -0.0051146384*G0_;
      A[2] = 0.0;
      A[3] = 0.0;
      A[4] = 0.0;
      A[5] = 0.0;
      A[6] = 0.0;
      A[7] = 0.0;
      A[8] = 0.0;
      A[9] = 0.052204586*G0_;
      A[10] = -0.030687831*G0_;
      A[11] = 0.0098765432*G0_;
      A[12] = -0.0051146384*G0_;
      A[13] = 0.051499118*G0_;
      A[14] = 0.0;
      A[15] = 0.0;
      A[16] = 0.0;
      A[17] = 0.0;
      A[18] = 0.0;
      A[19] = 0.0;
      A[20] = 0.0;
      A[21] = 0.0098765432*G0_;
      A[22] = -0.030687831*G0_;
      A[23] = 0.052204586*G0_;
      A[24] = 0.0;
      A[25] = 0.0;
      A[26] = 0.0;
      A[27] = 0.0;
      A[28] = 0.0;
      A[29] = 0.0;
      A[30] = 0.0;
      A[31] = 0.0;
      A[32] = 0.0;
      A[33] = 0.0;
      A[34] = 0.0;
      A[35] = 0.0;
      A[36] = 0.0;
      A[37] = 0.0;
      A[38] = 0.0;
      A[39] = 0.0;
      A[40] = 0.0;
      A[41] = 0.0;
      A[42] = 0.0;
      A[43] = 0.0;
      A[44] = 0.0;
      A[45] = 0.0;
      A[46] = 0.0;
      A[47] = 0.0;
      A[48] = 0.0;
      A[49] = 0.0;
      A[50] = 0.0;
      A[51] = 0.0;
      A[52] = 0.0;
      A[53] = 0.0;
      A[54] = 0.0;
      A[55] = 0.0;
      A[56] = 0.0;
      A[57] = 0.0;
      A[58] = 0.0;
      A[59] = 0.0;
      A[60] = 0.0;
      A[61] = 0.0;
      A[62] = 0.0;
      A[63] = 0.0;
      A[64] = 0.0;
      A[65] = 0.0;
      A[66] = 0.0;
      A[67] = 0.0;
      A[68] = 0.0;
      A[69] = 0.0;
      A[70] = 0.0;
      A[71] = 0.0;
      A[72] = 0.0;
      A[73] = 0.0;
      A[74] = 0.0;
      A[75] = 0.0;
      A[76] = 0.0;
      A[77] = 0.0;
      A[78] = 0.0;
      A[79] = 0.0;
      A[80] = 0.0;
      A[81] = 0.0;
      A[82] = 0.0;
      A[83] = 0.0;
      A[84] = 0.0;
      A[85] = 0.0;
      A[86] = 0.0;
      A[87] = 0.0;
      A[88] = 0.0;
      A[89] = 0.0;
      A[90] = 0.0;
      A[91] = 0.0;
      A[92] = 0.0;
      A[93] = 0.0;
      A[94] = 0.0;
      A[95] = 0.0;
      A[96] = 0.0;
      A[97] = 0.0;
      A[98] = 0.0;
      A[99] = 0.0;
      A[100] = 0.0;
      A[101] = 0.0;
      A[102] = 0.0;
      A[103] = 0.0;
      A[104] = 0.0;
      A[105] = 0.0;
      A[106] = 0.0;
      A[107] = 0.0;
      A[108] = 0.052204586*G0_;
      A[109] = 0.0098765432*G0_;
      A[110] = 0.0;
      A[111] = 0.0;
      A[112] = 0.0;
      A[113] = 0.0;
      A[114] = 0.0;
      A[115] = 0.0;
      A[116] = 0.0;
      A[117] = 0.31604938*G0_;
      A[118] = -0.067724868*G0_;
      A[119] = 0.045149912*G0_;
      A[120] = -0.030687831*G0_;
      A[121] = -0.030687831*G0_;
      A[122] = 0.0;
      A[123] = 0.0;
      A[124] = 0.0;
      A[125] = 0.0;
      A[126] = 0.0;
      A[127] = 0.0;
      A[128] = 0.0;
      A[129] = -0.067724868*G0_;
      A[130] = 0.33015873*G0_;
      A[131] = -0.067724868*G0_;
      A[132] = 0.0098765432*G0_;
      A[133] = 0.052204586*G0_;
      A[134] = 0.0;
      A[135] = 0.0;
      A[136] = 0.0;
      A[137] = 0.0;
      A[138] = 0.0;
      A[139] = 0.0;
      A[140] = 0.0;
      A[141] = 0.045149912*G0_;
      A[142] = -0.067724868*G0_;
      A[143] = 0.31604938*G0_;
        break;
      }
    }
    
  }

};

/// This class defines the interface for the tabulation of the
/// interior facet tensor corresponding to the local contribution to
/// a form from the integral over an interior facet.

class restrictedelement_interior_facet_integral_0_otherwise: public ufc::interior_facet_integral
{
public:

  /// Constructor
  restrictedelement_interior_facet_integral_0_otherwise() : ufc::interior_facet_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~restrictedelement_interior_facet_integral_0_otherwise()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local interior facet
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const double* vertex_coordinates_0,
                               const double* vertex_coordinates_1,
                               std::size_t facet_0,
                               std::size_t facet_1) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      12
    // Number of operations (multiply-add pairs) for geometry tensor:    0
    // Number of operations (multiply-add pairs) for tensor contraction: 450
    // Total number of operations (multiply-add pairs):                  462
    
    // Compute Jacobian
    double J_0[4];
    compute_jacobian_triangle_2d(J_0, vertex_coordinates_0);
    
    // Compute Jacobian inverse and determinant
    double K_0[4];
    double detJ_0;
    compute_jacobian_inverse_triangle_2d(K_0, detJ_0, J_0);
    
    // Compute Jacobian
    double J_1[4];
    compute_jacobian_triangle_2d(J_1, vertex_coordinates_1);
    
    // Compute Jacobian inverse and determinant
    double K_1[4];
    double detJ_1;
    compute_jacobian_inverse_triangle_2d(K_1, detJ_1, J_1);
    
    // Get vertices on edge
    static unsigned int edge_vertices[3][2] = {{1, 2}, {0, 2}, {0, 1}};
    const unsigned int v0 = edge_vertices[facet_0][0];
    const unsigned int v1 = edge_vertices[facet_0][1];
    
    // Compute scale factor (length of edge scaled by length of reference interval)
    const double dx0 = vertex_coordinates_0[2*v1 + 0] - vertex_coordinates_0[2*v0 + 0];
    const double dx1 = vertex_coordinates_0[2*v1 + 1] - vertex_coordinates_0[2*v0 + 1];
    const double det = std::sqrt(dx0*dx0 + dx1*dx1);
    
    
    
    // Compute geometry tensor
    const double G0_ = det;
    const double G1_ = det;
    const double G2_ = det;
    const double G3_ = det;
    
    // Compute element tensor
    switch (facet_0)
    {
    case 0:
      {
        switch (facet_1)
      {
      case 0:
        {
          A[0] = 0.0;
        A[1] = 0.0;
        A[2] = 0.0;
        A[3] = 0.0;
        A[4] = 0.0;
        A[5] = 0.0;
        A[6] = 0.0;
        A[7] = 0.0;
        A[8] = 0.0;
        A[9] = 0.0;
        A[10] = 0.0;
        A[11] = 0.0;
        A[12] = 0.0;
        A[13] = 0.0;
        A[14] = 0.0;
        A[15] = 0.0;
        A[16] = 0.0;
        A[17] = 0.0;
        A[18] = 0.0;
        A[19] = 0.0;
        A[20] = 0.0;
        A[21] = 0.0;
        A[22] = 0.0;
        A[23] = 0.0;
        A[24] = 0.0;
        A[25] = 0.01287478*G3_;
        A[26] = -0.0012786596*G3_;
        A[27] = 0.013051146*G3_;
        A[28] = -0.0076719577*G3_;
        A[29] = 0.0024691358*G3_;
        A[30] = 0.0;
        A[31] = 0.0;
        A[32] = 0.0;
        A[33] = 0.0;
        A[34] = 0.0;
        A[35] = 0.0;
        A[36] = 0.0;
        A[37] = 0.01287478*G2_;
        A[38] = -0.0012786596*G2_;
        A[39] = 0.013051146*G2_;
        A[40] = -0.0076719577*G2_;
        A[41] = 0.0024691358*G2_;
        A[42] = 0.0;
        A[43] = 0.0;
        A[44] = 0.0;
        A[45] = 0.0;
        A[46] = 0.0;
        A[47] = 0.0;
        A[48] = 0.0;
        A[49] = -0.0012786596*G3_;
        A[50] = 0.01287478*G3_;
        A[51] = 0.0024691358*G3_;
        A[52] = -0.0076719577*G3_;
        A[53] = 0.013051146*G3_;
        A[54] = 0.0;
        A[55] = 0.0;
        A[56] = 0.0;
        A[57] = 0.0;
        A[58] = 0.0;
        A[59] = 0.0;
        A[60] = 0.0;
        A[61] = -0.0012786596*G2_;
        A[62] = 0.01287478*G2_;
        A[63] = 0.0024691358*G2_;
        A[64] = -0.0076719577*G2_;
        A[65] = 0.013051146*G2_;
        A[66] = 0.0;
        A[67] = 0.0;
        A[68] = 0.0;
        A[69] = 0.0;
        A[70] = 0.0;
        A[71] = 0.0;
        A[72] = 0.0;
        A[73] = 0.013051146*G3_;
        A[74] = 0.0024691358*G3_;
        A[75] = 0.079012346*G3_;
        A[76] = -0.016931217*G3_;
        A[77] = 0.011287478*G3_;
        A[78] = 0.0;
        A[79] = 0.0;
        A[80] = 0.0;
        A[81] = 0.0;
        A[82] = 0.0;
        A[83] = 0.0;
        A[84] = 0.0;
        A[85] = 0.013051146*G2_;
        A[86] = 0.0024691358*G2_;
        A[87] = 0.079012346*G2_;
        A[88] = -0.016931217*G2_;
        A[89] = 0.011287478*G2_;
        A[90] = 0.0;
        A[91] = 0.0;
        A[92] = 0.0;
        A[93] = 0.0;
        A[94] = 0.0;
        A[95] = 0.0;
        A[96] = 0.0;
        A[97] = -0.0076719577*G3_;
        A[98] = -0.0076719577*G3_;
        A[99] = -0.016931217*G3_;
        A[100] = 0.082539683*G3_;
        A[101] = -0.016931217*G3_;
        A[102] = 0.0;
        A[103] = 0.0;
        A[104] = 0.0;
        A[105] = 0.0;
        A[106] = 0.0;
        A[107] = 0.0;
        A[108] = 0.0;
        A[109] = -0.0076719577*G2_;
        A[110] = -0.0076719577*G2_;
        A[111] = -0.016931217*G2_;
        A[112] = 0.082539683*G2_;
        A[113] = -0.016931217*G2_;
        A[114] = 0.0;
        A[115] = 0.0;
        A[116] = 0.0;
        A[117] = 0.0;
        A[118] = 0.0;
        A[119] = 0.0;
        A[120] = 0.0;
        A[121] = 0.0024691358*G3_;
        A[122] = 0.013051146*G3_;
        A[123] = 0.011287478*G3_;
        A[124] = -0.016931217*G3_;
        A[125] = 0.079012346*G3_;
        A[126] = 0.0;
        A[127] = 0.0;
        A[128] = 0.0;
        A[129] = 0.0;
        A[130] = 0.0;
        A[131] = 0.0;
        A[132] = 0.0;
        A[133] = 0.0024691358*G2_;
        A[134] = 0.013051146*G2_;
        A[135] = 0.011287478*G2_;
        A[136] = -0.016931217*G2_;
        A[137] = 0.079012346*G2_;
        A[138] = 0.0;
        A[139] = 0.0;
        A[140] = 0.0;
        A[141] = 0.0;
        A[142] = 0.0;
        A[143] = 0.0;
        A[144] = 0.0;
        A[145] = 0.0;
        A[146] = 0.0;
        A[147] = 0.0;
        A[148] = 0.0;
        A[149] = 0.0;
        A[150] = 0.0;
        A[151] = 0.0;
        A[152] = 0.0;
        A[153] = 0.0;
        A[154] = 0.0;
        A[155] = 0.0;
        A[156] = 0.0;
        A[157] = 0.0;
        A[158] = 0.0;
        A[159] = 0.0;
        A[160] = 0.0;
        A[161] = 0.0;
        A[162] = 0.0;
        A[163] = 0.0;
        A[164] = 0.0;
        A[165] = 0.0;
        A[166] = 0.0;
        A[167] = 0.0;
        A[168] = 0.0;
        A[169] = 0.0;
        A[170] = 0.0;
        A[171] = 0.0;
        A[172] = 0.0;
        A[173] = 0.0;
        A[174] = 0.0;
        A[175] = 0.0;
        A[176] = 0.0;
        A[177] = 0.0;
        A[178] = 0.0;
        A[179] = 0.0;
        A[180] = 0.0;
        A[181] = 0.0;
        A[182] = 0.0;
        A[183] = 0.0;
        A[184] = 0.0;
        A[185] = 0.0;
        A[186] = 0.0;
        A[187] = 0.0;
        A[188] = 0.0;
        A[189] = 0.0;
        A[190] = 0.0;
        A[191] = 0.0;
        A[192] = 0.0;
        A[193] = 0.0;
        A[194] = 0.0;
        A[195] = 0.0;
        A[196] = 0.0;
        A[197] = 0.0;
        A[198] = 0.0;
        A[199] = 0.0;
        A[200] = 0.0;
        A[201] = 0.0;
        A[202] = 0.0;
        A[203] = 0.0;
        A[204] = 0.0;
        A[205] = 0.0;
        A[206] = 0.0;
        A[207] = 0.0;
        A[208] = 0.0;
        A[209] = 0.0;
        A[210] = 0.0;
        A[211] = 0.0;
        A[212] = 0.0;
        A[213] = 0.0;
        A[214] = 0.0;
        A[215] = 0.0;
        A[216] = 0.0;
        A[217] = 0.0;
        A[218] = 0.0;
        A[219] = 0.0;
        A[220] = 0.0;
        A[221] = 0.0;
        A[222] = 0.0;
        A[223] = 0.0;
        A[224] = 0.0;
        A[225] = 0.0;
        A[226] = 0.0;
        A[227] = 0.0;
        A[228] = 0.0;
        A[229] = 0.0;
        A[230] = 0.0;
        A[231] = 0.0;
        A[232] = 0.0;
        A[233] = 0.0;
        A[234] = 0.0;
        A[235] = 0.0;
        A[236] = 0.0;
        A[237] = 0.0;
        A[238] = 0.0;
        A[239] = 0.0;
        A[240] = 0.0;
        A[241] = 0.0;
        A[242] = 0.0;
        A[243] = 0.0;
        A[244] = 0.0;
        A[245] = 0.0;
        A[246] = 0.0;
        A[247] = 0.0;
        A[248] = 0.0;
        A[249] = 0.0;
        A[250] = 0.0;
        A[251] = 0.0;
        A[252] = 0.0;
        A[253] = 0.0;
        A[254] = 0.0;
        A[255] = 0.0;
        A[256] = 0.0;
        A[257] = 0.0;
        A[258] = 0.0;
        A[259] = 0.0;
        A[260] = 0.0;
        A[261] = 0.0;
        A[262] = 0.0;
        A[263] = 0.0;
        A[264] = 0.0;
        A[265] = 0.0;
        A[266] = 0.0;
        A[267] = 0.0;
        A[268] = 0.0;
        A[269] = 0.0;
        A[270] = 0.0;
        A[271] = 0.0;
        A[272] = 0.0;
        A[273] = 0.0;
        A[274] = 0.0;
        A[275] = 0.0;
        A[276] = 0.0;
        A[277] = 0.0;
        A[278] = 0.0;
        A[279] = 0.0;
        A[280] = 0.0;
        A[281] = 0.0;
        A[282] = 0.0;
        A[283] = 0.0;
        A[284] = 0.0;
        A[285] = 0.0;
        A[286] = 0.0;
        A[287] = 0.0;
        A[288] = 0.0;
        A[289] = 0.0;
        A[290] = 0.0;
        A[291] = 0.0;
        A[292] = 0.0;
        A[293] = 0.0;
        A[294] = 0.0;
        A[295] = 0.0;
        A[296] = 0.0;
        A[297] = 0.0;
        A[298] = 0.0;
        A[299] = 0.0;
        A[300] = 0.0;
        A[301] = 0.0;
        A[302] = 0.0;
        A[303] = 0.0;
        A[304] = 0.0;
        A[305] = 0.0;
        A[306] = 0.0;
        A[307] = 0.0;
        A[308] = 0.0;
        A[309] = 0.0;
        A[310] = 0.0;
        A[311] = 0.0;
        A[312] = 0.0;
        A[313] = 0.01287478*G1_;
        A[314] = -0.0012786596*G1_;
        A[315] = 0.013051146*G1_;
        A[316] = -0.0076719577*G1_;
        A[317] = 0.0024691358*G1_;
        A[318] = 0.0;
        A[319] = 0.0;
        A[320] = 0.0;
        A[321] = 0.0;
        A[322] = 0.0;
        A[323] = 0.0;
        A[324] = 0.0;
        A[325] = 0.01287478*G0_;
        A[326] = -0.0012786596*G0_;
        A[327] = 0.013051146*G0_;
        A[328] = -0.0076719577*G0_;
        A[329] = 0.0024691358*G0_;
        A[330] = 0.0;
        A[331] = 0.0;
        A[332] = 0.0;
        A[333] = 0.0;
        A[334] = 0.0;
        A[335] = 0.0;
        A[336] = 0.0;
        A[337] = -0.0012786596*G1_;
        A[338] = 0.01287478*G1_;
        A[339] = 0.0024691358*G1_;
        A[340] = -0.0076719577*G1_;
        A[341] = 0.013051146*G1_;
        A[342] = 0.0;
        A[343] = 0.0;
        A[344] = 0.0;
        A[345] = 0.0;
        A[346] = 0.0;
        A[347] = 0.0;
        A[348] = 0.0;
        A[349] = -0.0012786596*G0_;
        A[350] = 0.01287478*G0_;
        A[351] = 0.0024691358*G0_;
        A[352] = -0.0076719577*G0_;
        A[353] = 0.013051146*G0_;
        A[354] = 0.0;
        A[355] = 0.0;
        A[356] = 0.0;
        A[357] = 0.0;
        A[358] = 0.0;
        A[359] = 0.0;
        A[360] = 0.0;
        A[361] = 0.013051146*G1_;
        A[362] = 0.0024691358*G1_;
        A[363] = 0.079012346*G1_;
        A[364] = -0.016931217*G1_;
        A[365] = 0.011287478*G1_;
        A[366] = 0.0;
        A[367] = 0.0;
        A[368] = 0.0;
        A[369] = 0.0;
        A[370] = 0.0;
        A[371] = 0.0;
        A[372] = 0.0;
        A[373] = 0.013051146*G0_;
        A[374] = 0.0024691358*G0_;
        A[375] = 0.079012346*G0_;
        A[376] = -0.016931217*G0_;
        A[377] = 0.011287478*G0_;
        A[378] = 0.0;
        A[379] = 0.0;
        A[380] = 0.0;
        A[381] = 0.0;
        A[382] = 0.0;
        A[383] = 0.0;
        A[384] = 0.0;
        A[385] = -0.0076719577*G1_;
        A[386] = -0.0076719577*G1_;
        A[387] = -0.016931217*G1_;
        A[388] = 0.082539683*G1_;
        A[389] = -0.016931217*G1_;
        A[390] = 0.0;
        A[391] = 0.0;
        A[392] = 0.0;
        A[393] = 0.0;
        A[394] = 0.0;
        A[395] = 0.0;
        A[396] = 0.0;
        A[397] = -0.0076719577*G0_;
        A[398] = -0.0076719577*G0_;
        A[399] = -0.016931217*G0_;
        A[400] = 0.082539683*G0_;
        A[401] = -0.016931217*G0_;
        A[402] = 0.0;
        A[403] = 0.0;
        A[404] = 0.0;
        A[405] = 0.0;
        A[406] = 0.0;
        A[407] = 0.0;
        A[408] = 0.0;
        A[409] = 0.0024691358*G1_;
        A[410] = 0.013051146*G1_;
        A[411] = 0.011287478*G1_;
        A[412] = -0.016931217*G1_;
        A[413] = 0.079012346*G1_;
        A[414] = 0.0;
        A[415] = 0.0;
        A[416] = 0.0;
        A[417] = 0.0;
        A[418] = 0.0;
        A[419] = 0.0;
        A[420] = 0.0;
        A[421] = 0.0024691358*G0_;
        A[422] = 0.013051146*G0_;
        A[423] = 0.011287478*G0_;
        A[424] = -0.016931217*G0_;
        A[425] = 0.079012346*G0_;
        A[426] = 0.0;
        A[427] = 0.0;
        A[428] = 0.0;
        A[429] = 0.0;
        A[430] = 0.0;
        A[431] = 0.0;
        A[432] = 0.0;
        A[433] = 0.0;
        A[434] = 0.0;
        A[435] = 0.0;
        A[436] = 0.0;
        A[437] = 0.0;
        A[438] = 0.0;
        A[439] = 0.0;
        A[440] = 0.0;
        A[441] = 0.0;
        A[442] = 0.0;
        A[443] = 0.0;
        A[444] = 0.0;
        A[445] = 0.0;
        A[446] = 0.0;
        A[447] = 0.0;
        A[448] = 0.0;
        A[449] = 0.0;
        A[450] = 0.0;
        A[451] = 0.0;
        A[452] = 0.0;
        A[453] = 0.0;
        A[454] = 0.0;
        A[455] = 0.0;
        A[456] = 0.0;
        A[457] = 0.0;
        A[458] = 0.0;
        A[459] = 0.0;
        A[460] = 0.0;
        A[461] = 0.0;
        A[462] = 0.0;
        A[463] = 0.0;
        A[464] = 0.0;
        A[465] = 0.0;
        A[466] = 0.0;
        A[467] = 0.0;
        A[468] = 0.0;
        A[469] = 0.0;
        A[470] = 0.0;
        A[471] = 0.0;
        A[472] = 0.0;
        A[473] = 0.0;
        A[474] = 0.0;
        A[475] = 0.0;
        A[476] = 0.0;
        A[477] = 0.0;
        A[478] = 0.0;
        A[479] = 0.0;
        A[480] = 0.0;
        A[481] = 0.0;
        A[482] = 0.0;
        A[483] = 0.0;
        A[484] = 0.0;
        A[485] = 0.0;
        A[486] = 0.0;
        A[487] = 0.0;
        A[488] = 0.0;
        A[489] = 0.0;
        A[490] = 0.0;
        A[491] = 0.0;
        A[492] = 0.0;
        A[493] = 0.0;
        A[494] = 0.0;
        A[495] = 0.0;
        A[496] = 0.0;
        A[497] = 0.0;
        A[498] = 0.0;
        A[499] = 0.0;
        A[500] = 0.0;
        A[501] = 0.0;
        A[502] = 0.0;
        A[503] = 0.0;
        A[504] = 0.0;
        A[505] = 0.0;
        A[506] = 0.0;
        A[507] = 0.0;
        A[508] = 0.0;
        A[509] = 0.0;
        A[510] = 0.0;
        A[511] = 0.0;
        A[512] = 0.0;
        A[513] = 0.0;
        A[514] = 0.0;
        A[515] = 0.0;
        A[516] = 0.0;
        A[517] = 0.0;
        A[518] = 0.0;
        A[519] = 0.0;
        A[520] = 0.0;
        A[521] = 0.0;
        A[522] = 0.0;
        A[523] = 0.0;
        A[524] = 0.0;
        A[525] = 0.0;
        A[526] = 0.0;
        A[527] = 0.0;
        A[528] = 0.0;
        A[529] = 0.0;
        A[530] = 0.0;
        A[531] = 0.0;
        A[532] = 0.0;
        A[533] = 0.0;
        A[534] = 0.0;
        A[535] = 0.0;
        A[536] = 0.0;
        A[537] = 0.0;
        A[538] = 0.0;
        A[539] = 0.0;
        A[540] = 0.0;
        A[541] = 0.0;
        A[542] = 0.0;
        A[543] = 0.0;
        A[544] = 0.0;
        A[545] = 0.0;
        A[546] = 0.0;
        A[547] = 0.0;
        A[548] = 0.0;
        A[549] = 0.0;
        A[550] = 0.0;
        A[551] = 0.0;
        A[552] = 0.0;
        A[553] = 0.0;
        A[554] = 0.0;
        A[555] = 0.0;
        A[556] = 0.0;
        A[557] = 0.0;
        A[558] = 0.0;
        A[559] = 0.0;
        A[560] = 0.0;
        A[561] = 0.0;
        A[562] = 0.0;
        A[563] = 0.0;
        A[564] = 0.0;
        A[565] = 0.0;
        A[566] = 0.0;
        A[567] = 0.0;
        A[568] = 0.0;
        A[569] = 0.0;
        A[570] = 0.0;
        A[571] = 0.0;
        A[572] = 0.0;
        A[573] = 0.0;
        A[574] = 0.0;
        A[575] = 0.0;
          break;
        }
      case 1:
        {
          A[0] = 0.0;
        A[1] = 0.0;
        A[2] = 0.0;
        A[3] = 0.0;
        A[4] = 0.0;
        A[5] = 0.0;
        A[6] = 0.0;
        A[7] = 0.0;
        A[8] = 0.0;
        A[9] = 0.0;
        A[10] = 0.0;
        A[11] = 0.0;
        A[12] = 0.0;
        A[13] = 0.0;
        A[14] = 0.0;
        A[15] = 0.0;
        A[16] = 0.0;
        A[17] = 0.0;
        A[18] = 0.0;
        A[19] = 0.0;
        A[20] = 0.0;
        A[21] = 0.0;
        A[22] = 0.0;
        A[23] = 0.0;
        A[24] = 0.0;
        A[25] = 0.01287478*G3_;
        A[26] = -0.0012786596*G3_;
        A[27] = 0.013051146*G3_;
        A[28] = -0.0076719577*G3_;
        A[29] = 0.0024691358*G3_;
        A[30] = 0.0;
        A[31] = 0.0;
        A[32] = 0.0;
        A[33] = 0.0;
        A[34] = 0.0;
        A[35] = 0.0;
        A[36] = 0.01287478*G2_;
        A[37] = 0.0;
        A[38] = -0.0012786596*G2_;
        A[39] = 0.0;
        A[40] = 0.0;
        A[41] = 0.0;
        A[42] = 0.013051146*G2_;
        A[43] = -0.0076719577*G2_;
        A[44] = 0.0024691358*G2_;
        A[45] = 0.0;
        A[46] = 0.0;
        A[47] = 0.0;
        A[48] = 0.0;
        A[49] = -0.0012786596*G3_;
        A[50] = 0.01287478*G3_;
        A[51] = 0.0024691358*G3_;
        A[52] = -0.0076719577*G3_;
        A[53] = 0.013051146*G3_;
        A[54] = 0.0;
        A[55] = 0.0;
        A[56] = 0.0;
        A[57] = 0.0;
        A[58] = 0.0;
        A[59] = 0.0;
        A[60] = -0.0012786596*G2_;
        A[61] = 0.0;
        A[62] = 0.01287478*G2_;
        A[63] = 0.0;
        A[64] = 0.0;
        A[65] = 0.0;
        A[66] = 0.0024691358*G2_;
        A[67] = -0.0076719577*G2_;
        A[68] = 0.013051146*G2_;
        A[69] = 0.0;
        A[70] = 0.0;
        A[71] = 0.0;
        A[72] = 0.0;
        A[73] = 0.013051146*G3_;
        A[74] = 0.0024691358*G3_;
        A[75] = 0.079012346*G3_;
        A[76] = -0.016931217*G3_;
        A[77] = 0.011287478*G3_;
        A[78] = 0.0;
        A[79] = 0.0;
        A[80] = 0.0;
        A[81] = 0.0;
        A[82] = 0.0;
        A[83] = 0.0;
        A[84] = 0.013051146*G2_;
        A[85] = 0.0;
        A[86] = 0.0024691358*G2_;
        A[87] = 0.0;
        A[88] = 0.0;
        A[89] = 0.0;
        A[90] = 0.079012346*G2_;
        A[91] = -0.016931217*G2_;
        A[92] = 0.011287478*G2_;
        A[93] = 0.0;
        A[94] = 0.0;
        A[95] = 0.0;
        A[96] = 0.0;
        A[97] = -0.0076719577*G3_;
        A[98] = -0.0076719577*G3_;
        A[99] = -0.016931217*G3_;
        A[100] = 0.082539683*G3_;
        A[101] = -0.016931217*G3_;
        A[102] = 0.0;
        A[103] = 0.0;
        A[104] = 0.0;
        A[105] = 0.0;
        A[106] = 0.0;
        A[107] = 0.0;
        A[108] = -0.0076719577*G2_;
        A[109] = 0.0;
        A[110] = -0.0076719577*G2_;
        A[111] = 0.0;
        A[112] = 0.0;
        A[113] = 0.0;
        A[114] = -0.016931217*G2_;
        A[115] = 0.082539683*G2_;
        A[116] = -0.016931217*G2_;
        A[117] = 0.0;
        A[118] = 0.0;
        A[119] = 0.0;
        A[120] = 0.0;
        A[121] = 0.0024691358*G3_;
        A[122] = 0.013051146*G3_;
        A[123] = 0.011287478*G3_;
        A[124] = -0.016931217*G3_;
        A[125] = 0.079012346*G3_;
        A[126] = 0.0;
        A[127] = 0.0;
        A[128] = 0.0;
        A[129] = 0.0;
        A[130] = 0.0;
        A[131] = 0.0;
        A[132] = 0.0024691358*G2_;
        A[133] = 0.0;
        A[134] = 0.013051146*G2_;
        A[135] = 0.0;
        A[136] = 0.0;
        A[137] = 0.0;
        A[138] = 0.011287478*G2_;
        A[139] = -0.016931217*G2_;
        A[140] = 0.079012346*G2_;
        A[141] = 0.0;
        A[142] = 0.0;
        A[143] = 0.0;
        A[144] = 0.0;
        A[145] = 0.0;
        A[146] = 0.0;
        A[147] = 0.0;
        A[148] = 0.0;
        A[149] = 0.0;
        A[150] = 0.0;
        A[151] = 0.0;
        A[152] = 0.0;
        A[153] = 0.0;
        A[154] = 0.0;
        A[155] = 0.0;
        A[156] = 0.0;
        A[157] = 0.0;
        A[158] = 0.0;
        A[159] = 0.0;
        A[160] = 0.0;
        A[161] = 0.0;
        A[162] = 0.0;
        A[163] = 0.0;
        A[164] = 0.0;
        A[165] = 0.0;
        A[166] = 0.0;
        A[167] = 0.0;
        A[168] = 0.0;
        A[169] = 0.0;
        A[170] = 0.0;
        A[171] = 0.0;
        A[172] = 0.0;
        A[173] = 0.0;
        A[174] = 0.0;
        A[175] = 0.0;
        A[176] = 0.0;
        A[177] = 0.0;
        A[178] = 0.0;
        A[179] = 0.0;
        A[180] = 0.0;
        A[181] = 0.0;
        A[182] = 0.0;
        A[183] = 0.0;
        A[184] = 0.0;
        A[185] = 0.0;
        A[186] = 0.0;
        A[187] = 0.0;
        A[188] = 0.0;
        A[189] = 0.0;
        A[190] = 0.0;
        A[191] = 0.0;
        A[192] = 0.0;
        A[193] = 0.0;
        A[194] = 0.0;
        A[195] = 0.0;
        A[196] = 0.0;
        A[197] = 0.0;
        A[198] = 0.0;
        A[199] = 0.0;
        A[200] = 0.0;
        A[201] = 0.0;
        A[202] = 0.0;
        A[203] = 0.0;
        A[204] = 0.0;
        A[205] = 0.0;
        A[206] = 0.0;
        A[207] = 0.0;
        A[208] = 0.0;
        A[209] = 0.0;
        A[210] = 0.0;
        A[211] = 0.0;
        A[212] = 0.0;
        A[213] = 0.0;
        A[214] = 0.0;
        A[215] = 0.0;
        A[216] = 0.0;
        A[217] = 0.0;
        A[218] = 0.0;
        A[219] = 0.0;
        A[220] = 0.0;
        A[221] = 0.0;
        A[222] = 0.0;
        A[223] = 0.0;
        A[224] = 0.0;
        A[225] = 0.0;
        A[226] = 0.0;
        A[227] = 0.0;
        A[228] = 0.0;
        A[229] = 0.0;
        A[230] = 0.0;
        A[231] = 0.0;
        A[232] = 0.0;
        A[233] = 0.0;
        A[234] = 0.0;
        A[235] = 0.0;
        A[236] = 0.0;
        A[237] = 0.0;
        A[238] = 0.0;
        A[239] = 0.0;
        A[240] = 0.0;
        A[241] = 0.0;
        A[242] = 0.0;
        A[243] = 0.0;
        A[244] = 0.0;
        A[245] = 0.0;
        A[246] = 0.0;
        A[247] = 0.0;
        A[248] = 0.0;
        A[249] = 0.0;
        A[250] = 0.0;
        A[251] = 0.0;
        A[252] = 0.0;
        A[253] = 0.0;
        A[254] = 0.0;
        A[255] = 0.0;
        A[256] = 0.0;
        A[257] = 0.0;
        A[258] = 0.0;
        A[259] = 0.0;
        A[260] = 0.0;
        A[261] = 0.0;
        A[262] = 0.0;
        A[263] = 0.0;
        A[264] = 0.0;
        A[265] = 0.0;
        A[266] = 0.0;
        A[267] = 0.0;
        A[268] = 0.0;
        A[269] = 0.0;
        A[270] = 0.0;
        A[271] = 0.0;
        A[272] = 0.0;
        A[273] = 0.0;
        A[274] = 0.0;
        A[275] = 0.0;
        A[276] = 0.0;
        A[277] = 0.0;
        A[278] = 0.0;
        A[279] = 0.0;
        A[280] = 0.0;
        A[281] = 0.0;
        A[282] = 0.0;
        A[283] = 0.0;
        A[284] = 0.0;
        A[285] = 0.0;
        A[286] = 0.0;
        A[287] = 0.0;
        A[288] = 0.0;
        A[289] = 0.01287478*G1_;
        A[290] = -0.0012786596*G1_;
        A[291] = 0.013051146*G1_;
        A[292] = -0.0076719577*G1_;
        A[293] = 0.0024691358*G1_;
        A[294] = 0.0;
        A[295] = 0.0;
        A[296] = 0.0;
        A[297] = 0.0;
        A[298] = 0.0;
        A[299] = 0.0;
        A[300] = 0.01287478*G0_;
        A[301] = 0.0;
        A[302] = -0.0012786596*G0_;
        A[303] = 0.0;
        A[304] = 0.0;
        A[305] = 0.0;
        A[306] = 0.013051146*G0_;
        A[307] = -0.0076719577*G0_;
        A[308] = 0.0024691358*G0_;
        A[309] = 0.0;
        A[310] = 0.0;
        A[311] = 0.0;
        A[312] = 0.0;
        A[313] = 0.0;
        A[314] = 0.0;
        A[315] = 0.0;
        A[316] = 0.0;
        A[317] = 0.0;
        A[318] = 0.0;
        A[319] = 0.0;
        A[320] = 0.0;
        A[321] = 0.0;
        A[322] = 0.0;
        A[323] = 0.0;
        A[324] = 0.0;
        A[325] = 0.0;
        A[326] = 0.0;
        A[327] = 0.0;
        A[328] = 0.0;
        A[329] = 0.0;
        A[330] = 0.0;
        A[331] = 0.0;
        A[332] = 0.0;
        A[333] = 0.0;
        A[334] = 0.0;
        A[335] = 0.0;
        A[336] = 0.0;
        A[337] = -0.0012786596*G1_;
        A[338] = 0.01287478*G1_;
        A[339] = 0.0024691358*G1_;
        A[340] = -0.0076719577*G1_;
        A[341] = 0.013051146*G1_;
        A[342] = 0.0;
        A[343] = 0.0;
        A[344] = 0.0;
        A[345] = 0.0;
        A[346] = 0.0;
        A[347] = 0.0;
        A[348] = -0.0012786596*G0_;
        A[349] = 0.0;
        A[350] = 0.01287478*G0_;
        A[351] = 0.0;
        A[352] = 0.0;
        A[353] = 0.0;
        A[354] = 0.0024691358*G0_;
        A[355] = -0.0076719577*G0_;
        A[356] = 0.013051146*G0_;
        A[357] = 0.0;
        A[358] = 0.0;
        A[359] = 0.0;
        A[360] = 0.0;
        A[361] = 0.0;
        A[362] = 0.0;
        A[363] = 0.0;
        A[364] = 0.0;
        A[365] = 0.0;
        A[366] = 0.0;
        A[367] = 0.0;
        A[368] = 0.0;
        A[369] = 0.0;
        A[370] = 0.0;
        A[371] = 0.0;
        A[372] = 0.0;
        A[373] = 0.0;
        A[374] = 0.0;
        A[375] = 0.0;
        A[376] = 0.0;
        A[377] = 0.0;
        A[378] = 0.0;
        A[379] = 0.0;
        A[380] = 0.0;
        A[381] = 0.0;
        A[382] = 0.0;
        A[383] = 0.0;
        A[384] = 0.0;
        A[385] = 0.0;
        A[386] = 0.0;
        A[387] = 0.0;
        A[388] = 0.0;
        A[389] = 0.0;
        A[390] = 0.0;
        A[391] = 0.0;
        A[392] = 0.0;
        A[393] = 0.0;
        A[394] = 0.0;
        A[395] = 0.0;
        A[396] = 0.0;
        A[397] = 0.0;
        A[398] = 0.0;
        A[399] = 0.0;
        A[400] = 0.0;
        A[401] = 0.0;
        A[402] = 0.0;
        A[403] = 0.0;
        A[404] = 0.0;
        A[405] = 0.0;
        A[406] = 0.0;
        A[407] = 0.0;
        A[408] = 0.0;
        A[409] = 0.0;
        A[410] = 0.0;
        A[411] = 0.0;
        A[412] = 0.0;
        A[413] = 0.0;
        A[414] = 0.0;
        A[415] = 0.0;
        A[416] = 0.0;
        A[417] = 0.0;
        A[418] = 0.0;
        A[419] = 0.0;
        A[420] = 0.0;
        A[421] = 0.0;
        A[422] = 0.0;
        A[423] = 0.0;
        A[424] = 0.0;
        A[425] = 0.0;
        A[426] = 0.0;
        A[427] = 0.0;
        A[428] = 0.0;
        A[429] = 0.0;
        A[430] = 0.0;
        A[431] = 0.0;
        A[432] = 0.0;
        A[433] = 0.013051146*G1_;
        A[434] = 0.0024691358*G1_;
        A[435] = 0.079012346*G1_;
        A[436] = -0.016931217*G1_;
        A[437] = 0.011287478*G1_;
        A[438] = 0.0;
        A[439] = 0.0;
        A[440] = 0.0;
        A[441] = 0.0;
        A[442] = 0.0;
        A[443] = 0.0;
        A[444] = 0.013051146*G0_;
        A[445] = 0.0;
        A[446] = 0.0024691358*G0_;
        A[447] = 0.0;
        A[448] = 0.0;
        A[449] = 0.0;
        A[450] = 0.079012346*G0_;
        A[451] = -0.016931217*G0_;
        A[452] = 0.011287478*G0_;
        A[453] = 0.0;
        A[454] = 0.0;
        A[455] = 0.0;
        A[456] = 0.0;
        A[457] = -0.0076719577*G1_;
        A[458] = -0.0076719577*G1_;
        A[459] = -0.016931217*G1_;
        A[460] = 0.082539683*G1_;
        A[461] = -0.016931217*G1_;
        A[462] = 0.0;
        A[463] = 0.0;
        A[464] = 0.0;
        A[465] = 0.0;
        A[466] = 0.0;
        A[467] = 0.0;
        A[468] = -0.0076719577*G0_;
        A[469] = 0.0;
        A[470] = -0.0076719577*G0_;
        A[471] = 0.0;
        A[472] = 0.0;
        A[473] = 0.0;
        A[474] = -0.016931217*G0_;
        A[475] = 0.082539683*G0_;
        A[476] = -0.016931217*G0_;
        A[477] = 0.0;
        A[478] = 0.0;
        A[479] = 0.0;
        A[480] = 0.0;
        A[481] = 0.0024691358*G1_;
        A[482] = 0.013051146*G1_;
        A[483] = 0.011287478*G1_;
        A[484] = -0.016931217*G1_;
        A[485] = 0.079012346*G1_;
        A[486] = 0.0;
        A[487] = 0.0;
        A[488] = 0.0;
        A[489] = 0.0;
        A[490] = 0.0;
        A[491] = 0.0;
        A[492] = 0.0024691358*G0_;
        A[493] = 0.0;
        A[494] = 0.013051146*G0_;
        A[495] = 0.0;
        A[496] = 0.0;
        A[497] = 0.0;
        A[498] = 0.011287478*G0_;
        A[499] = -0.016931217*G0_;
        A[500] = 0.079012346*G0_;
        A[501] = 0.0;
        A[502] = 0.0;
        A[503] = 0.0;
        A[504] = 0.0;
        A[505] = 0.0;
        A[506] = 0.0;
        A[507] = 0.0;
        A[508] = 0.0;
        A[509] = 0.0;
        A[510] = 0.0;
        A[511] = 0.0;
        A[512] = 0.0;
        A[513] = 0.0;
        A[514] = 0.0;
        A[515] = 0.0;
        A[516] = 0.0;
        A[517] = 0.0;
        A[518] = 0.0;
        A[519] = 0.0;
        A[520] = 0.0;
        A[521] = 0.0;
        A[522] = 0.0;
        A[523] = 0.0;
        A[524] = 0.0;
        A[525] = 0.0;
        A[526] = 0.0;
        A[527] = 0.0;
        A[528] = 0.0;
        A[529] = 0.0;
        A[530] = 0.0;
        A[531] = 0.0;
        A[532] = 0.0;
        A[533] = 0.0;
        A[534] = 0.0;
        A[535] = 0.0;
        A[536] = 0.0;
        A[537] = 0.0;
        A[538] = 0.0;
        A[539] = 0.0;
        A[540] = 0.0;
        A[541] = 0.0;
        A[542] = 0.0;
        A[543] = 0.0;
        A[544] = 0.0;
        A[545] = 0.0;
        A[546] = 0.0;
        A[547] = 0.0;
        A[548] = 0.0;
        A[549] = 0.0;
        A[550] = 0.0;
        A[551] = 0.0;
        A[552] = 0.0;
        A[553] = 0.0;
        A[554] = 0.0;
        A[555] = 0.0;
        A[556] = 0.0;
        A[557] = 0.0;
        A[558] = 0.0;
        A[559] = 0.0;
        A[560] = 0.0;
        A[561] = 0.0;
        A[562] = 0.0;
        A[563] = 0.0;
        A[564] = 0.0;
        A[565] = 0.0;
        A[566] = 0.0;
        A[567] = 0.0;
        A[568] = 0.0;
        A[569] = 0.0;
        A[570] = 0.0;
        A[571] = 0.0;
        A[572] = 0.0;
        A[573] = 0.0;
        A[574] = 0.0;
        A[575] = 0.0;
          break;
        }
      case 2:
        {
          A[0] = 0.0;
        A[1] = 0.0;
        A[2] = 0.0;
        A[3] = 0.0;
        A[4] = 0.0;
        A[5] = 0.0;
        A[6] = 0.0;
        A[7] = 0.0;
        A[8] = 0.0;
        A[9] = 0.0;
        A[10] = 0.0;
        A[11] = 0.0;
        A[12] = 0.0;
        A[13] = 0.0;
        A[14] = 0.0;
        A[15] = 0.0;
        A[16] = 0.0;
        A[17] = 0.0;
        A[18] = 0.0;
        A[19] = 0.0;
        A[20] = 0.0;
        A[21] = 0.0;
        A[22] = 0.0;
        A[23] = 0.0;
        A[24] = 0.0;
        A[25] = 0.01287478*G3_;
        A[26] = -0.0012786596*G3_;
        A[27] = 0.013051146*G3_;
        A[28] = -0.0076719577*G3_;
        A[29] = 0.0024691358*G3_;
        A[30] = 0.0;
        A[31] = 0.0;
        A[32] = 0.0;
        A[33] = 0.0;
        A[34] = 0.0;
        A[35] = 0.0;
        A[36] = 0.01287478*G2_;
        A[37] = -0.0012786596*G2_;
        A[38] = 0.0;
        A[39] = 0.0;
        A[40] = 0.0;
        A[41] = 0.0;
        A[42] = 0.0;
        A[43] = 0.0;
        A[44] = 0.0;
        A[45] = 0.013051146*G2_;
        A[46] = -0.0076719577*G2_;
        A[47] = 0.0024691358*G2_;
        A[48] = 0.0;
        A[49] = -0.0012786596*G3_;
        A[50] = 0.01287478*G3_;
        A[51] = 0.0024691358*G3_;
        A[52] = -0.0076719577*G3_;
        A[53] = 0.013051146*G3_;
        A[54] = 0.0;
        A[55] = 0.0;
        A[56] = 0.0;
        A[57] = 0.0;
        A[58] = 0.0;
        A[59] = 0.0;
        A[60] = -0.0012786596*G2_;
        A[61] = 0.01287478*G2_;
        A[62] = 0.0;
        A[63] = 0.0;
        A[64] = 0.0;
        A[65] = 0.0;
        A[66] = 0.0;
        A[67] = 0.0;
        A[68] = 0.0;
        A[69] = 0.0024691358*G2_;
        A[70] = -0.0076719577*G2_;
        A[71] = 0.013051146*G2_;
        A[72] = 0.0;
        A[73] = 0.013051146*G3_;
        A[74] = 0.0024691358*G3_;
        A[75] = 0.079012346*G3_;
        A[76] = -0.016931217*G3_;
        A[77] = 0.011287478*G3_;
        A[78] = 0.0;
        A[79] = 0.0;
        A[80] = 0.0;
        A[81] = 0.0;
        A[82] = 0.0;
        A[83] = 0.0;
        A[84] = 0.013051146*G2_;
        A[85] = 0.0024691358*G2_;
        A[86] = 0.0;
        A[87] = 0.0;
        A[88] = 0.0;
        A[89] = 0.0;
        A[90] = 0.0;
        A[91] = 0.0;
        A[92] = 0.0;
        A[93] = 0.079012346*G2_;
        A[94] = -0.016931217*G2_;
        A[95] = 0.011287478*G2_;
        A[96] = 0.0;
        A[97] = -0.0076719577*G3_;
        A[98] = -0.0076719577*G3_;
        A[99] = -0.016931217*G3_;
        A[100] = 0.082539683*G3_;
        A[101] = -0.016931217*G3_;
        A[102] = 0.0;
        A[103] = 0.0;
        A[104] = 0.0;
        A[105] = 0.0;
        A[106] = 0.0;
        A[107] = 0.0;
        A[108] = -0.0076719577*G2_;
        A[109] = -0.0076719577*G2_;
        A[110] = 0.0;
        A[111] = 0.0;
        A[112] = 0.0;
        A[113] = 0.0;
        A[114] = 0.0;
        A[115] = 0.0;
        A[116] = 0.0;
        A[117] = -0.016931217*G2_;
        A[118] = 0.082539683*G2_;
        A[119] = -0.016931217*G2_;
        A[120] = 0.0;
        A[121] = 0.0024691358*G3_;
        A[122] = 0.013051146*G3_;
        A[123] = 0.011287478*G3_;
        A[124] = -0.016931217*G3_;
        A[125] = 0.079012346*G3_;
        A[126] = 0.0;
        A[127] = 0.0;
        A[128] = 0.0;
        A[129] = 0.0;
        A[130] = 0.0;
        A[131] = 0.0;
        A[132] = 0.0024691358*G2_;
        A[133] = 0.013051146*G2_;
        A[134] = 0.0;
        A[135] = 0.0;
        A[136] = 0.0;
        A[137] = 0.0;
        A[138] = 0.0;
        A[139] = 0.0;
        A[140] = 0.0;
        A[141] = 0.011287478*G2_;
        A[142] = -0.016931217*G2_;
        A[143] = 0.079012346*G2_;
        A[144] = 0.0;
        A[145] = 0.0;
        A[146] = 0.0;
        A[147] = 0.0;
        A[148] = 0.0;
        A[149] = 0.0;
        A[150] = 0.0;
        A[151] = 0.0;
        A[152] = 0.0;
        A[153] = 0.0;
        A[154] = 0.0;
        A[155] = 0.0;
        A[156] = 0.0;
        A[157] = 0.0;
        A[158] = 0.0;
        A[159] = 0.0;
        A[160] = 0.0;
        A[161] = 0.0;
        A[162] = 0.0;
        A[163] = 0.0;
        A[164] = 0.0;
        A[165] = 0.0;
        A[166] = 0.0;
        A[167] = 0.0;
        A[168] = 0.0;
        A[169] = 0.0;
        A[170] = 0.0;
        A[171] = 0.0;
        A[172] = 0.0;
        A[173] = 0.0;
        A[174] = 0.0;
        A[175] = 0.0;
        A[176] = 0.0;
        A[177] = 0.0;
        A[178] = 0.0;
        A[179] = 0.0;
        A[180] = 0.0;
        A[181] = 0.0;
        A[182] = 0.0;
        A[183] = 0.0;
        A[184] = 0.0;
        A[185] = 0.0;
        A[186] = 0.0;
        A[187] = 0.0;
        A[188] = 0.0;
        A[189] = 0.0;
        A[190] = 0.0;
        A[191] = 0.0;
        A[192] = 0.0;
        A[193] = 0.0;
        A[194] = 0.0;
        A[195] = 0.0;
        A[196] = 0.0;
        A[197] = 0.0;
        A[198] = 0.0;
        A[199] = 0.0;
        A[200] = 0.0;
        A[201] = 0.0;
        A[202] = 0.0;
        A[203] = 0.0;
        A[204] = 0.0;
        A[205] = 0.0;
        A[206] = 0.0;
        A[207] = 0.0;
        A[208] = 0.0;
        A[209] = 0.0;
        A[210] = 0.0;
        A[211] = 0.0;
        A[212] = 0.0;
        A[213] = 0.0;
        A[214] = 0.0;
        A[215] = 0.0;
        A[216] = 0.0;
        A[217] = 0.0;
        A[218] = 0.0;
        A[219] = 0.0;
        A[220] = 0.0;
        A[221] = 0.0;
        A[222] = 0.0;
        A[223] = 0.0;
        A[224] = 0.0;
        A[225] = 0.0;
        A[226] = 0.0;
        A[227] = 0.0;
        A[228] = 0.0;
        A[229] = 0.0;
        A[230] = 0.0;
        A[231] = 0.0;
        A[232] = 0.0;
        A[233] = 0.0;
        A[234] = 0.0;
        A[235] = 0.0;
        A[236] = 0.0;
        A[237] = 0.0;
        A[238] = 0.0;
        A[239] = 0.0;
        A[240] = 0.0;
        A[241] = 0.0;
        A[242] = 0.0;
        A[243] = 0.0;
        A[244] = 0.0;
        A[245] = 0.0;
        A[246] = 0.0;
        A[247] = 0.0;
        A[248] = 0.0;
        A[249] = 0.0;
        A[250] = 0.0;
        A[251] = 0.0;
        A[252] = 0.0;
        A[253] = 0.0;
        A[254] = 0.0;
        A[255] = 0.0;
        A[256] = 0.0;
        A[257] = 0.0;
        A[258] = 0.0;
        A[259] = 0.0;
        A[260] = 0.0;
        A[261] = 0.0;
        A[262] = 0.0;
        A[263] = 0.0;
        A[264] = 0.0;
        A[265] = 0.0;
        A[266] = 0.0;
        A[267] = 0.0;
        A[268] = 0.0;
        A[269] = 0.0;
        A[270] = 0.0;
        A[271] = 0.0;
        A[272] = 0.0;
        A[273] = 0.0;
        A[274] = 0.0;
        A[275] = 0.0;
        A[276] = 0.0;
        A[277] = 0.0;
        A[278] = 0.0;
        A[279] = 0.0;
        A[280] = 0.0;
        A[281] = 0.0;
        A[282] = 0.0;
        A[283] = 0.0;
        A[284] = 0.0;
        A[285] = 0.0;
        A[286] = 0.0;
        A[287] = 0.0;
        A[288] = 0.0;
        A[289] = 0.01287478*G1_;
        A[290] = -0.0012786596*G1_;
        A[291] = 0.013051146*G1_;
        A[292] = -0.0076719577*G1_;
        A[293] = 0.0024691358*G1_;
        A[294] = 0.0;
        A[295] = 0.0;
        A[296] = 0.0;
        A[297] = 0.0;
        A[298] = 0.0;
        A[299] = 0.0;
        A[300] = 0.01287478*G0_;
        A[301] = -0.0012786596*G0_;
        A[302] = 0.0;
        A[303] = 0.0;
        A[304] = 0.0;
        A[305] = 0.0;
        A[306] = 0.0;
        A[307] = 0.0;
        A[308] = 0.0;
        A[309] = 0.013051146*G0_;
        A[310] = -0.0076719577*G0_;
        A[311] = 0.0024691358*G0_;
        A[312] = 0.0;
        A[313] = -0.0012786596*G1_;
        A[314] = 0.01287478*G1_;
        A[315] = 0.0024691358*G1_;
        A[316] = -0.0076719577*G1_;
        A[317] = 0.013051146*G1_;
        A[318] = 0.0;
        A[319] = 0.0;
        A[320] = 0.0;
        A[321] = 0.0;
        A[322] = 0.0;
        A[323] = 0.0;
        A[324] = -0.0012786596*G0_;
        A[325] = 0.01287478*G0_;
        A[326] = 0.0;
        A[327] = 0.0;
        A[328] = 0.0;
        A[329] = 0.0;
        A[330] = 0.0;
        A[331] = 0.0;
        A[332] = 0.0;
        A[333] = 0.0024691358*G0_;
        A[334] = -0.0076719577*G0_;
        A[335] = 0.013051146*G0_;
        A[336] = 0.0;
        A[337] = 0.0;
        A[338] = 0.0;
        A[339] = 0.0;
        A[340] = 0.0;
        A[341] = 0.0;
        A[342] = 0.0;
        A[343] = 0.0;
        A[344] = 0.0;
        A[345] = 0.0;
        A[346] = 0.0;
        A[347] = 0.0;
        A[348] = 0.0;
        A[349] = 0.0;
        A[350] = 0.0;
        A[351] = 0.0;
        A[352] = 0.0;
        A[353] = 0.0;
        A[354] = 0.0;
        A[355] = 0.0;
        A[356] = 0.0;
        A[357] = 0.0;
        A[358] = 0.0;
        A[359] = 0.0;
        A[360] = 0.0;
        A[361] = 0.0;
        A[362] = 0.0;
        A[363] = 0.0;
        A[364] = 0.0;
        A[365] = 0.0;
        A[366] = 0.0;
        A[367] = 0.0;
        A[368] = 0.0;
        A[369] = 0.0;
        A[370] = 0.0;
        A[371] = 0.0;
        A[372] = 0.0;
        A[373] = 0.0;
        A[374] = 0.0;
        A[375] = 0.0;
        A[376] = 0.0;
        A[377] = 0.0;
        A[378] = 0.0;
        A[379] = 0.0;
        A[380] = 0.0;
        A[381] = 0.0;
        A[382] = 0.0;
        A[383] = 0.0;
        A[384] = 0.0;
        A[385] = 0.0;
        A[386] = 0.0;
        A[387] = 0.0;
        A[388] = 0.0;
        A[389] = 0.0;
        A[390] = 0.0;
        A[391] = 0.0;
        A[392] = 0.0;
        A[393] = 0.0;
        A[394] = 0.0;
        A[395] = 0.0;
        A[396] = 0.0;
        A[397] = 0.0;
        A[398] = 0.0;
        A[399] = 0.0;
        A[400] = 0.0;
        A[401] = 0.0;
        A[402] = 0.0;
        A[403] = 0.0;
        A[404] = 0.0;
        A[405] = 0.0;
        A[406] = 0.0;
        A[407] = 0.0;
        A[408] = 0.0;
        A[409] = 0.0;
        A[410] = 0.0;
        A[411] = 0.0;
        A[412] = 0.0;
        A[413] = 0.0;
        A[414] = 0.0;
        A[415] = 0.0;
        A[416] = 0.0;
        A[417] = 0.0;
        A[418] = 0.0;
        A[419] = 0.0;
        A[420] = 0.0;
        A[421] = 0.0;
        A[422] = 0.0;
        A[423] = 0.0;
        A[424] = 0.0;
        A[425] = 0.0;
        A[426] = 0.0;
        A[427] = 0.0;
        A[428] = 0.0;
        A[429] = 0.0;
        A[430] = 0.0;
        A[431] = 0.0;
        A[432] = 0.0;
        A[433] = 0.0;
        A[434] = 0.0;
        A[435] = 0.0;
        A[436] = 0.0;
        A[437] = 0.0;
        A[438] = 0.0;
        A[439] = 0.0;
        A[440] = 0.0;
        A[441] = 0.0;
        A[442] = 0.0;
        A[443] = 0.0;
        A[444] = 0.0;
        A[445] = 0.0;
        A[446] = 0.0;
        A[447] = 0.0;
        A[448] = 0.0;
        A[449] = 0.0;
        A[450] = 0.0;
        A[451] = 0.0;
        A[452] = 0.0;
        A[453] = 0.0;
        A[454] = 0.0;
        A[455] = 0.0;
        A[456] = 0.0;
        A[457] = 0.0;
        A[458] = 0.0;
        A[459] = 0.0;
        A[460] = 0.0;
        A[461] = 0.0;
        A[462] = 0.0;
        A[463] = 0.0;
        A[464] = 0.0;
        A[465] = 0.0;
        A[466] = 0.0;
        A[467] = 0.0;
        A[468] = 0.0;
        A[469] = 0.0;
        A[470] = 0.0;
        A[471] = 0.0;
        A[472] = 0.0;
        A[473] = 0.0;
        A[474] = 0.0;
        A[475] = 0.0;
        A[476] = 0.0;
        A[477] = 0.0;
        A[478] = 0.0;
        A[479] = 0.0;
        A[480] = 0.0;
        A[481] = 0.0;
        A[482] = 0.0;
        A[483] = 0.0;
        A[484] = 0.0;
        A[485] = 0.0;
        A[486] = 0.0;
        A[487] = 0.0;
        A[488] = 0.0;
        A[489] = 0.0;
        A[490] = 0.0;
        A[491] = 0.0;
        A[492] = 0.0;
        A[493] = 0.0;
        A[494] = 0.0;
        A[495] = 0.0;
        A[496] = 0.0;
        A[497] = 0.0;
        A[498] = 0.0;
        A[499] = 0.0;
        A[500] = 0.0;
        A[501] = 0.0;
        A[502] = 0.0;
        A[503] = 0.0;
        A[504] = 0.0;
        A[505] = 0.013051146*G1_;
        A[506] = 0.0024691358*G1_;
        A[507] = 0.079012346*G1_;
        A[508] = -0.016931217*G1_;
        A[509] = 0.011287478*G1_;
        A[510] = 0.0;
        A[511] = 0.0;
        A[512] = 0.0;
        A[513] = 0.0;
        A[514] = 0.0;
        A[515] = 0.0;
        A[516] = 0.013051146*G0_;
        A[517] = 0.0024691358*G0_;
        A[518] = 0.0;
        A[519] = 0.0;
        A[520] = 0.0;
        A[521] = 0.0;
        A[522] = 0.0;
        A[523] = 0.0;
        A[524] = 0.0;
        A[525] = 0.079012346*G0_;
        A[526] = -0.016931217*G0_;
        A[527] = 0.011287478*G0_;
        A[528] = 0.0;
        A[529] = -0.0076719577*G1_;
        A[530] = -0.0076719577*G1_;
        A[531] = -0.016931217*G1_;
        A[532] = 0.082539683*G1_;
        A[533] = -0.016931217*G1_;
        A[534] = 0.0;
        A[535] = 0.0;
        A[536] = 0.0;
        A[537] = 0.0;
        A[538] = 0.0;
        A[539] = 0.0;
        A[540] = -0.0076719577*G0_;
        A[541] = -0.0076719577*G0_;
        A[542] = 0.0;
        A[543] = 0.0;
        A[544] = 0.0;
        A[545] = 0.0;
        A[546] = 0.0;
        A[547] = 0.0;
        A[548] = 0.0;
        A[549] = -0.016931217*G0_;
        A[550] = 0.082539683*G0_;
        A[551] = -0.016931217*G0_;
        A[552] = 0.0;
        A[553] = 0.0024691358*G1_;
        A[554] = 0.013051146*G1_;
        A[555] = 0.011287478*G1_;
        A[556] = -0.016931217*G1_;
        A[557] = 0.079012346*G1_;
        A[558] = 0.0;
        A[559] = 0.0;
        A[560] = 0.0;
        A[561] = 0.0;
        A[562] = 0.0;
        A[563] = 0.0;
        A[564] = 0.0024691358*G0_;
        A[565] = 0.013051146*G0_;
        A[566] = 0.0;
        A[567] = 0.0;
        A[568] = 0.0;
        A[569] = 0.0;
        A[570] = 0.0;
        A[571] = 0.0;
        A[572] = 0.0;
        A[573] = 0.011287478*G0_;
        A[574] = -0.016931217*G0_;
        A[575] = 0.079012346*G0_;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        switch (facet_1)
      {
      case 0:
        {
          A[0] = 0.01287478*G3_;
        A[1] = 0.0;
        A[2] = -0.0012786596*G3_;
        A[3] = 0.0;
        A[4] = 0.0;
        A[5] = 0.0;
        A[6] = 0.013051146*G3_;
        A[7] = -0.0076719577*G3_;
        A[8] = 0.0024691358*G3_;
        A[9] = 0.0;
        A[10] = 0.0;
        A[11] = 0.0;
        A[12] = 0.0;
        A[13] = 0.01287478*G2_;
        A[14] = -0.0012786596*G2_;
        A[15] = 0.013051146*G2_;
        A[16] = -0.0076719577*G2_;
        A[17] = 0.0024691358*G2_;
        A[18] = 0.0;
        A[19] = 0.0;
        A[20] = 0.0;
        A[21] = 0.0;
        A[22] = 0.0;
        A[23] = 0.0;
        A[24] = 0.0;
        A[25] = 0.0;
        A[26] = 0.0;
        A[27] = 0.0;
        A[28] = 0.0;
        A[29] = 0.0;
        A[30] = 0.0;
        A[31] = 0.0;
        A[32] = 0.0;
        A[33] = 0.0;
        A[34] = 0.0;
        A[35] = 0.0;
        A[36] = 0.0;
        A[37] = 0.0;
        A[38] = 0.0;
        A[39] = 0.0;
        A[40] = 0.0;
        A[41] = 0.0;
        A[42] = 0.0;
        A[43] = 0.0;
        A[44] = 0.0;
        A[45] = 0.0;
        A[46] = 0.0;
        A[47] = 0.0;
        A[48] = -0.0012786596*G3_;
        A[49] = 0.0;
        A[50] = 0.01287478*G3_;
        A[51] = 0.0;
        A[52] = 0.0;
        A[53] = 0.0;
        A[54] = 0.0024691358*G3_;
        A[55] = -0.0076719577*G3_;
        A[56] = 0.013051146*G3_;
        A[57] = 0.0;
        A[58] = 0.0;
        A[59] = 0.0;
        A[60] = 0.0;
        A[61] = -0.0012786596*G2_;
        A[62] = 0.01287478*G2_;
        A[63] = 0.0024691358*G2_;
        A[64] = -0.0076719577*G2_;
        A[65] = 0.013051146*G2_;
        A[66] = 0.0;
        A[67] = 0.0;
        A[68] = 0.0;
        A[69] = 0.0;
        A[70] = 0.0;
        A[71] = 0.0;
        A[72] = 0.0;
        A[73] = 0.0;
        A[74] = 0.0;
        A[75] = 0.0;
        A[76] = 0.0;
        A[77] = 0.0;
        A[78] = 0.0;
        A[79] = 0.0;
        A[80] = 0.0;
        A[81] = 0.0;
        A[82] = 0.0;
        A[83] = 0.0;
        A[84] = 0.0;
        A[85] = 0.0;
        A[86] = 0.0;
        A[87] = 0.0;
        A[88] = 0.0;
        A[89] = 0.0;
        A[90] = 0.0;
        A[91] = 0.0;
        A[92] = 0.0;
        A[93] = 0.0;
        A[94] = 0.0;
        A[95] = 0.0;
        A[96] = 0.0;
        A[97] = 0.0;
        A[98] = 0.0;
        A[99] = 0.0;
        A[100] = 0.0;
        A[101] = 0.0;
        A[102] = 0.0;
        A[103] = 0.0;
        A[104] = 0.0;
        A[105] = 0.0;
        A[106] = 0.0;
        A[107] = 0.0;
        A[108] = 0.0;
        A[109] = 0.0;
        A[110] = 0.0;
        A[111] = 0.0;
        A[112] = 0.0;
        A[113] = 0.0;
        A[114] = 0.0;
        A[115] = 0.0;
        A[116] = 0.0;
        A[117] = 0.0;
        A[118] = 0.0;
        A[119] = 0.0;
        A[120] = 0.0;
        A[121] = 0.0;
        A[122] = 0.0;
        A[123] = 0.0;
        A[124] = 0.0;
        A[125] = 0.0;
        A[126] = 0.0;
        A[127] = 0.0;
        A[128] = 0.0;
        A[129] = 0.0;
        A[130] = 0.0;
        A[131] = 0.0;
        A[132] = 0.0;
        A[133] = 0.0;
        A[134] = 0.0;
        A[135] = 0.0;
        A[136] = 0.0;
        A[137] = 0.0;
        A[138] = 0.0;
        A[139] = 0.0;
        A[140] = 0.0;
        A[141] = 0.0;
        A[142] = 0.0;
        A[143] = 0.0;
        A[144] = 0.013051146*G3_;
        A[145] = 0.0;
        A[146] = 0.0024691358*G3_;
        A[147] = 0.0;
        A[148] = 0.0;
        A[149] = 0.0;
        A[150] = 0.079012346*G3_;
        A[151] = -0.016931217*G3_;
        A[152] = 0.011287478*G3_;
        A[153] = 0.0;
        A[154] = 0.0;
        A[155] = 0.0;
        A[156] = 0.0;
        A[157] = 0.013051146*G2_;
        A[158] = 0.0024691358*G2_;
        A[159] = 0.079012346*G2_;
        A[160] = -0.016931217*G2_;
        A[161] = 0.011287478*G2_;
        A[162] = 0.0;
        A[163] = 0.0;
        A[164] = 0.0;
        A[165] = 0.0;
        A[166] = 0.0;
        A[167] = 0.0;
        A[168] = -0.0076719577*G3_;
        A[169] = 0.0;
        A[170] = -0.0076719577*G3_;
        A[171] = 0.0;
        A[172] = 0.0;
        A[173] = 0.0;
        A[174] = -0.016931217*G3_;
        A[175] = 0.082539683*G3_;
        A[176] = -0.016931217*G3_;
        A[177] = 0.0;
        A[178] = 0.0;
        A[179] = 0.0;
        A[180] = 0.0;
        A[181] = -0.0076719577*G2_;
        A[182] = -0.0076719577*G2_;
        A[183] = -0.016931217*G2_;
        A[184] = 0.082539683*G2_;
        A[185] = -0.016931217*G2_;
        A[186] = 0.0;
        A[187] = 0.0;
        A[188] = 0.0;
        A[189] = 0.0;
        A[190] = 0.0;
        A[191] = 0.0;
        A[192] = 0.0024691358*G3_;
        A[193] = 0.0;
        A[194] = 0.013051146*G3_;
        A[195] = 0.0;
        A[196] = 0.0;
        A[197] = 0.0;
        A[198] = 0.011287478*G3_;
        A[199] = -0.016931217*G3_;
        A[200] = 0.079012346*G3_;
        A[201] = 0.0;
        A[202] = 0.0;
        A[203] = 0.0;
        A[204] = 0.0;
        A[205] = 0.0024691358*G2_;
        A[206] = 0.013051146*G2_;
        A[207] = 0.011287478*G2_;
        A[208] = -0.016931217*G2_;
        A[209] = 0.079012346*G2_;
        A[210] = 0.0;
        A[211] = 0.0;
        A[212] = 0.0;
        A[213] = 0.0;
        A[214] = 0.0;
        A[215] = 0.0;
        A[216] = 0.0;
        A[217] = 0.0;
        A[218] = 0.0;
        A[219] = 0.0;
        A[220] = 0.0;
        A[221] = 0.0;
        A[222] = 0.0;
        A[223] = 0.0;
        A[224] = 0.0;
        A[225] = 0.0;
        A[226] = 0.0;
        A[227] = 0.0;
        A[228] = 0.0;
        A[229] = 0.0;
        A[230] = 0.0;
        A[231] = 0.0;
        A[232] = 0.0;
        A[233] = 0.0;
        A[234] = 0.0;
        A[235] = 0.0;
        A[236] = 0.0;
        A[237] = 0.0;
        A[238] = 0.0;
        A[239] = 0.0;
        A[240] = 0.0;
        A[241] = 0.0;
        A[242] = 0.0;
        A[243] = 0.0;
        A[244] = 0.0;
        A[245] = 0.0;
        A[246] = 0.0;
        A[247] = 0.0;
        A[248] = 0.0;
        A[249] = 0.0;
        A[250] = 0.0;
        A[251] = 0.0;
        A[252] = 0.0;
        A[253] = 0.0;
        A[254] = 0.0;
        A[255] = 0.0;
        A[256] = 0.0;
        A[257] = 0.0;
        A[258] = 0.0;
        A[259] = 0.0;
        A[260] = 0.0;
        A[261] = 0.0;
        A[262] = 0.0;
        A[263] = 0.0;
        A[264] = 0.0;
        A[265] = 0.0;
        A[266] = 0.0;
        A[267] = 0.0;
        A[268] = 0.0;
        A[269] = 0.0;
        A[270] = 0.0;
        A[271] = 0.0;
        A[272] = 0.0;
        A[273] = 0.0;
        A[274] = 0.0;
        A[275] = 0.0;
        A[276] = 0.0;
        A[277] = 0.0;
        A[278] = 0.0;
        A[279] = 0.0;
        A[280] = 0.0;
        A[281] = 0.0;
        A[282] = 0.0;
        A[283] = 0.0;
        A[284] = 0.0;
        A[285] = 0.0;
        A[286] = 0.0;
        A[287] = 0.0;
        A[288] = 0.0;
        A[289] = 0.0;
        A[290] = 0.0;
        A[291] = 0.0;
        A[292] = 0.0;
        A[293] = 0.0;
        A[294] = 0.0;
        A[295] = 0.0;
        A[296] = 0.0;
        A[297] = 0.0;
        A[298] = 0.0;
        A[299] = 0.0;
        A[300] = 0.0;
        A[301] = 0.0;
        A[302] = 0.0;
        A[303] = 0.0;
        A[304] = 0.0;
        A[305] = 0.0;
        A[306] = 0.0;
        A[307] = 0.0;
        A[308] = 0.0;
        A[309] = 0.0;
        A[310] = 0.0;
        A[311] = 0.0;
        A[312] = 0.01287478*G1_;
        A[313] = 0.0;
        A[314] = -0.0012786596*G1_;
        A[315] = 0.0;
        A[316] = 0.0;
        A[317] = 0.0;
        A[318] = 0.013051146*G1_;
        A[319] = -0.0076719577*G1_;
        A[320] = 0.0024691358*G1_;
        A[321] = 0.0;
        A[322] = 0.0;
        A[323] = 0.0;
        A[324] = 0.0;
        A[325] = 0.01287478*G0_;
        A[326] = -0.0012786596*G0_;
        A[327] = 0.013051146*G0_;
        A[328] = -0.0076719577*G0_;
        A[329] = 0.0024691358*G0_;
        A[330] = 0.0;
        A[331] = 0.0;
        A[332] = 0.0;
        A[333] = 0.0;
        A[334] = 0.0;
        A[335] = 0.0;
        A[336] = -0.0012786596*G1_;
        A[337] = 0.0;
        A[338] = 0.01287478*G1_;
        A[339] = 0.0;
        A[340] = 0.0;
        A[341] = 0.0;
        A[342] = 0.0024691358*G1_;
        A[343] = -0.0076719577*G1_;
        A[344] = 0.013051146*G1_;
        A[345] = 0.0;
        A[346] = 0.0;
        A[347] = 0.0;
        A[348] = 0.0;
        A[349] = -0.0012786596*G0_;
        A[350] = 0.01287478*G0_;
        A[351] = 0.0024691358*G0_;
        A[352] = -0.0076719577*G0_;
        A[353] = 0.013051146*G0_;
        A[354] = 0.0;
        A[355] = 0.0;
        A[356] = 0.0;
        A[357] = 0.0;
        A[358] = 0.0;
        A[359] = 0.0;
        A[360] = 0.013051146*G1_;
        A[361] = 0.0;
        A[362] = 0.0024691358*G1_;
        A[363] = 0.0;
        A[364] = 0.0;
        A[365] = 0.0;
        A[366] = 0.079012346*G1_;
        A[367] = -0.016931217*G1_;
        A[368] = 0.011287478*G1_;
        A[369] = 0.0;
        A[370] = 0.0;
        A[371] = 0.0;
        A[372] = 0.0;
        A[373] = 0.013051146*G0_;
        A[374] = 0.0024691358*G0_;
        A[375] = 0.079012346*G0_;
        A[376] = -0.016931217*G0_;
        A[377] = 0.011287478*G0_;
        A[378] = 0.0;
        A[379] = 0.0;
        A[380] = 0.0;
        A[381] = 0.0;
        A[382] = 0.0;
        A[383] = 0.0;
        A[384] = -0.0076719577*G1_;
        A[385] = 0.0;
        A[386] = -0.0076719577*G1_;
        A[387] = 0.0;
        A[388] = 0.0;
        A[389] = 0.0;
        A[390] = -0.016931217*G1_;
        A[391] = 0.082539683*G1_;
        A[392] = -0.016931217*G1_;
        A[393] = 0.0;
        A[394] = 0.0;
        A[395] = 0.0;
        A[396] = 0.0;
        A[397] = -0.0076719577*G0_;
        A[398] = -0.0076719577*G0_;
        A[399] = -0.016931217*G0_;
        A[400] = 0.082539683*G0_;
        A[401] = -0.016931217*G0_;
        A[402] = 0.0;
        A[403] = 0.0;
        A[404] = 0.0;
        A[405] = 0.0;
        A[406] = 0.0;
        A[407] = 0.0;
        A[408] = 0.0024691358*G1_;
        A[409] = 0.0;
        A[410] = 0.013051146*G1_;
        A[411] = 0.0;
        A[412] = 0.0;
        A[413] = 0.0;
        A[414] = 0.011287478*G1_;
        A[415] = -0.016931217*G1_;
        A[416] = 0.079012346*G1_;
        A[417] = 0.0;
        A[418] = 0.0;
        A[419] = 0.0;
        A[420] = 0.0;
        A[421] = 0.0024691358*G0_;
        A[422] = 0.013051146*G0_;
        A[423] = 0.011287478*G0_;
        A[424] = -0.016931217*G0_;
        A[425] = 0.079012346*G0_;
        A[426] = 0.0;
        A[427] = 0.0;
        A[428] = 0.0;
        A[429] = 0.0;
        A[430] = 0.0;
        A[431] = 0.0;
        A[432] = 0.0;
        A[433] = 0.0;
        A[434] = 0.0;
        A[435] = 0.0;
        A[436] = 0.0;
        A[437] = 0.0;
        A[438] = 0.0;
        A[439] = 0.0;
        A[440] = 0.0;
        A[441] = 0.0;
        A[442] = 0.0;
        A[443] = 0.0;
        A[444] = 0.0;
        A[445] = 0.0;
        A[446] = 0.0;
        A[447] = 0.0;
        A[448] = 0.0;
        A[449] = 0.0;
        A[450] = 0.0;
        A[451] = 0.0;
        A[452] = 0.0;
        A[453] = 0.0;
        A[454] = 0.0;
        A[455] = 0.0;
        A[456] = 0.0;
        A[457] = 0.0;
        A[458] = 0.0;
        A[459] = 0.0;
        A[460] = 0.0;
        A[461] = 0.0;
        A[462] = 0.0;
        A[463] = 0.0;
        A[464] = 0.0;
        A[465] = 0.0;
        A[466] = 0.0;
        A[467] = 0.0;
        A[468] = 0.0;
        A[469] = 0.0;
        A[470] = 0.0;
        A[471] = 0.0;
        A[472] = 0.0;
        A[473] = 0.0;
        A[474] = 0.0;
        A[475] = 0.0;
        A[476] = 0.0;
        A[477] = 0.0;
        A[478] = 0.0;
        A[479] = 0.0;
        A[480] = 0.0;
        A[481] = 0.0;
        A[482] = 0.0;
        A[483] = 0.0;
        A[484] = 0.0;
        A[485] = 0.0;
        A[486] = 0.0;
        A[487] = 0.0;
        A[488] = 0.0;
        A[489] = 0.0;
        A[490] = 0.0;
        A[491] = 0.0;
        A[492] = 0.0;
        A[493] = 0.0;
        A[494] = 0.0;
        A[495] = 0.0;
        A[496] = 0.0;
        A[497] = 0.0;
        A[498] = 0.0;
        A[499] = 0.0;
        A[500] = 0.0;
        A[501] = 0.0;
        A[502] = 0.0;
        A[503] = 0.0;
        A[504] = 0.0;
        A[505] = 0.0;
        A[506] = 0.0;
        A[507] = 0.0;
        A[508] = 0.0;
        A[509] = 0.0;
        A[510] = 0.0;
        A[511] = 0.0;
        A[512] = 0.0;
        A[513] = 0.0;
        A[514] = 0.0;
        A[515] = 0.0;
        A[516] = 0.0;
        A[517] = 0.0;
        A[518] = 0.0;
        A[519] = 0.0;
        A[520] = 0.0;
        A[521] = 0.0;
        A[522] = 0.0;
        A[523] = 0.0;
        A[524] = 0.0;
        A[525] = 0.0;
        A[526] = 0.0;
        A[527] = 0.0;
        A[528] = 0.0;
        A[529] = 0.0;
        A[530] = 0.0;
        A[531] = 0.0;
        A[532] = 0.0;
        A[533] = 0.0;
        A[534] = 0.0;
        A[535] = 0.0;
        A[536] = 0.0;
        A[537] = 0.0;
        A[538] = 0.0;
        A[539] = 0.0;
        A[540] = 0.0;
        A[541] = 0.0;
        A[542] = 0.0;
        A[543] = 0.0;
        A[544] = 0.0;
        A[545] = 0.0;
        A[546] = 0.0;
        A[547] = 0.0;
        A[548] = 0.0;
        A[549] = 0.0;
        A[550] = 0.0;
        A[551] = 0.0;
        A[552] = 0.0;
        A[553] = 0.0;
        A[554] = 0.0;
        A[555] = 0.0;
        A[556] = 0.0;
        A[557] = 0.0;
        A[558] = 0.0;
        A[559] = 0.0;
        A[560] = 0.0;
        A[561] = 0.0;
        A[562] = 0.0;
        A[563] = 0.0;
        A[564] = 0.0;
        A[565] = 0.0;
        A[566] = 0.0;
        A[567] = 0.0;
        A[568] = 0.0;
        A[569] = 0.0;
        A[570] = 0.0;
        A[571] = 0.0;
        A[572] = 0.0;
        A[573] = 0.0;
        A[574] = 0.0;
        A[575] = 0.0;
          break;
        }
      case 1:
        {
          A[0] = 0.01287478*G3_;
        A[1] = 0.0;
        A[2] = -0.0012786596*G3_;
        A[3] = 0.0;
        A[4] = 0.0;
        A[5] = 0.0;
        A[6] = 0.013051146*G3_;
        A[7] = -0.0076719577*G3_;
        A[8] = 0.0024691358*G3_;
        A[9] = 0.0;
        A[10] = 0.0;
        A[11] = 0.0;
        A[12] = 0.01287478*G2_;
        A[13] = 0.0;
        A[14] = -0.0012786596*G2_;
        A[15] = 0.0;
        A[16] = 0.0;
        A[17] = 0.0;
        A[18] = 0.013051146*G2_;
        A[19] = -0.0076719577*G2_;
        A[20] = 0.0024691358*G2_;
        A[21] = 0.0;
        A[22] = 0.0;
        A[23] = 0.0;
        A[24] = 0.0;
        A[25] = 0.0;
        A[26] = 0.0;
        A[27] = 0.0;
        A[28] = 0.0;
        A[29] = 0.0;
        A[30] = 0.0;
        A[31] = 0.0;
        A[32] = 0.0;
        A[33] = 0.0;
        A[34] = 0.0;
        A[35] = 0.0;
        A[36] = 0.0;
        A[37] = 0.0;
        A[38] = 0.0;
        A[39] = 0.0;
        A[40] = 0.0;
        A[41] = 0.0;
        A[42] = 0.0;
        A[43] = 0.0;
        A[44] = 0.0;
        A[45] = 0.0;
        A[46] = 0.0;
        A[47] = 0.0;
        A[48] = -0.0012786596*G3_;
        A[49] = 0.0;
        A[50] = 0.01287478*G3_;
        A[51] = 0.0;
        A[52] = 0.0;
        A[53] = 0.0;
        A[54] = 0.0024691358*G3_;
        A[55] = -0.0076719577*G3_;
        A[56] = 0.013051146*G3_;
        A[57] = 0.0;
        A[58] = 0.0;
        A[59] = 0.0;
        A[60] = -0.0012786596*G2_;
        A[61] = 0.0;
        A[62] = 0.01287478*G2_;
        A[63] = 0.0;
        A[64] = 0.0;
        A[65] = 0.0;
        A[66] = 0.0024691358*G2_;
        A[67] = -0.0076719577*G2_;
        A[68] = 0.013051146*G2_;
        A[69] = 0.0;
        A[70] = 0.0;
        A[71] = 0.0;
        A[72] = 0.0;
        A[73] = 0.0;
        A[74] = 0.0;
        A[75] = 0.0;
        A[76] = 0.0;
        A[77] = 0.0;
        A[78] = 0.0;
        A[79] = 0.0;
        A[80] = 0.0;
        A[81] = 0.0;
        A[82] = 0.0;
        A[83] = 0.0;
        A[84] = 0.0;
        A[85] = 0.0;
        A[86] = 0.0;
        A[87] = 0.0;
        A[88] = 0.0;
        A[89] = 0.0;
        A[90] = 0.0;
        A[91] = 0.0;
        A[92] = 0.0;
        A[93] = 0.0;
        A[94] = 0.0;
        A[95] = 0.0;
        A[96] = 0.0;
        A[97] = 0.0;
        A[98] = 0.0;
        A[99] = 0.0;
        A[100] = 0.0;
        A[101] = 0.0;
        A[102] = 0.0;
        A[103] = 0.0;
        A[104] = 0.0;
        A[105] = 0.0;
        A[106] = 0.0;
        A[107] = 0.0;
        A[108] = 0.0;
        A[109] = 0.0;
        A[110] = 0.0;
        A[111] = 0.0;
        A[112] = 0.0;
        A[113] = 0.0;
        A[114] = 0.0;
        A[115] = 0.0;
        A[116] = 0.0;
        A[117] = 0.0;
        A[118] = 0.0;
        A[119] = 0.0;
        A[120] = 0.0;
        A[121] = 0.0;
        A[122] = 0.0;
        A[123] = 0.0;
        A[124] = 0.0;
        A[125] = 0.0;
        A[126] = 0.0;
        A[127] = 0.0;
        A[128] = 0.0;
        A[129] = 0.0;
        A[130] = 0.0;
        A[131] = 0.0;
        A[132] = 0.0;
        A[133] = 0.0;
        A[134] = 0.0;
        A[135] = 0.0;
        A[136] = 0.0;
        A[137] = 0.0;
        A[138] = 0.0;
        A[139] = 0.0;
        A[140] = 0.0;
        A[141] = 0.0;
        A[142] = 0.0;
        A[143] = 0.0;
        A[144] = 0.013051146*G3_;
        A[145] = 0.0;
        A[146] = 0.0024691358*G3_;
        A[147] = 0.0;
        A[148] = 0.0;
        A[149] = 0.0;
        A[150] = 0.079012346*G3_;
        A[151] = -0.016931217*G3_;
        A[152] = 0.011287478*G3_;
        A[153] = 0.0;
        A[154] = 0.0;
        A[155] = 0.0;
        A[156] = 0.013051146*G2_;
        A[157] = 0.0;
        A[158] = 0.0024691358*G2_;
        A[159] = 0.0;
        A[160] = 0.0;
        A[161] = 0.0;
        A[162] = 0.079012346*G2_;
        A[163] = -0.016931217*G2_;
        A[164] = 0.011287478*G2_;
        A[165] = 0.0;
        A[166] = 0.0;
        A[167] = 0.0;
        A[168] = -0.0076719577*G3_;
        A[169] = 0.0;
        A[170] = -0.0076719577*G3_;
        A[171] = 0.0;
        A[172] = 0.0;
        A[173] = 0.0;
        A[174] = -0.016931217*G3_;
        A[175] = 0.082539683*G3_;
        A[176] = -0.016931217*G3_;
        A[177] = 0.0;
        A[178] = 0.0;
        A[179] = 0.0;
        A[180] = -0.0076719577*G2_;
        A[181] = 0.0;
        A[182] = -0.0076719577*G2_;
        A[183] = 0.0;
        A[184] = 0.0;
        A[185] = 0.0;
        A[186] = -0.016931217*G2_;
        A[187] = 0.082539683*G2_;
        A[188] = -0.016931217*G2_;
        A[189] = 0.0;
        A[190] = 0.0;
        A[191] = 0.0;
        A[192] = 0.0024691358*G3_;
        A[193] = 0.0;
        A[194] = 0.013051146*G3_;
        A[195] = 0.0;
        A[196] = 0.0;
        A[197] = 0.0;
        A[198] = 0.011287478*G3_;
        A[199] = -0.016931217*G3_;
        A[200] = 0.079012346*G3_;
        A[201] = 0.0;
        A[202] = 0.0;
        A[203] = 0.0;
        A[204] = 0.0024691358*G2_;
        A[205] = 0.0;
        A[206] = 0.013051146*G2_;
        A[207] = 0.0;
        A[208] = 0.0;
        A[209] = 0.0;
        A[210] = 0.011287478*G2_;
        A[211] = -0.016931217*G2_;
        A[212] = 0.079012346*G2_;
        A[213] = 0.0;
        A[214] = 0.0;
        A[215] = 0.0;
        A[216] = 0.0;
        A[217] = 0.0;
        A[218] = 0.0;
        A[219] = 0.0;
        A[220] = 0.0;
        A[221] = 0.0;
        A[222] = 0.0;
        A[223] = 0.0;
        A[224] = 0.0;
        A[225] = 0.0;
        A[226] = 0.0;
        A[227] = 0.0;
        A[228] = 0.0;
        A[229] = 0.0;
        A[230] = 0.0;
        A[231] = 0.0;
        A[232] = 0.0;
        A[233] = 0.0;
        A[234] = 0.0;
        A[235] = 0.0;
        A[236] = 0.0;
        A[237] = 0.0;
        A[238] = 0.0;
        A[239] = 0.0;
        A[240] = 0.0;
        A[241] = 0.0;
        A[242] = 0.0;
        A[243] = 0.0;
        A[244] = 0.0;
        A[245] = 0.0;
        A[246] = 0.0;
        A[247] = 0.0;
        A[248] = 0.0;
        A[249] = 0.0;
        A[250] = 0.0;
        A[251] = 0.0;
        A[252] = 0.0;
        A[253] = 0.0;
        A[254] = 0.0;
        A[255] = 0.0;
        A[256] = 0.0;
        A[257] = 0.0;
        A[258] = 0.0;
        A[259] = 0.0;
        A[260] = 0.0;
        A[261] = 0.0;
        A[262] = 0.0;
        A[263] = 0.0;
        A[264] = 0.0;
        A[265] = 0.0;
        A[266] = 0.0;
        A[267] = 0.0;
        A[268] = 0.0;
        A[269] = 0.0;
        A[270] = 0.0;
        A[271] = 0.0;
        A[272] = 0.0;
        A[273] = 0.0;
        A[274] = 0.0;
        A[275] = 0.0;
        A[276] = 0.0;
        A[277] = 0.0;
        A[278] = 0.0;
        A[279] = 0.0;
        A[280] = 0.0;
        A[281] = 0.0;
        A[282] = 0.0;
        A[283] = 0.0;
        A[284] = 0.0;
        A[285] = 0.0;
        A[286] = 0.0;
        A[287] = 0.0;
        A[288] = 0.01287478*G1_;
        A[289] = 0.0;
        A[290] = -0.0012786596*G1_;
        A[291] = 0.0;
        A[292] = 0.0;
        A[293] = 0.0;
        A[294] = 0.013051146*G1_;
        A[295] = -0.0076719577*G1_;
        A[296] = 0.0024691358*G1_;
        A[297] = 0.0;
        A[298] = 0.0;
        A[299] = 0.0;
        A[300] = 0.01287478*G0_;
        A[301] = 0.0;
        A[302] = -0.0012786596*G0_;
        A[303] = 0.0;
        A[304] = 0.0;
        A[305] = 0.0;
        A[306] = 0.013051146*G0_;
        A[307] = -0.0076719577*G0_;
        A[308] = 0.0024691358*G0_;
        A[309] = 0.0;
        A[310] = 0.0;
        A[311] = 0.0;
        A[312] = 0.0;
        A[313] = 0.0;
        A[314] = 0.0;
        A[315] = 0.0;
        A[316] = 0.0;
        A[317] = 0.0;
        A[318] = 0.0;
        A[319] = 0.0;
        A[320] = 0.0;
        A[321] = 0.0;
        A[322] = 0.0;
        A[323] = 0.0;
        A[324] = 0.0;
        A[325] = 0.0;
        A[326] = 0.0;
        A[327] = 0.0;
        A[328] = 0.0;
        A[329] = 0.0;
        A[330] = 0.0;
        A[331] = 0.0;
        A[332] = 0.0;
        A[333] = 0.0;
        A[334] = 0.0;
        A[335] = 0.0;
        A[336] = -0.0012786596*G1_;
        A[337] = 0.0;
        A[338] = 0.01287478*G1_;
        A[339] = 0.0;
        A[340] = 0.0;
        A[341] = 0.0;
        A[342] = 0.0024691358*G1_;
        A[343] = -0.0076719577*G1_;
        A[344] = 0.013051146*G1_;
        A[345] = 0.0;
        A[346] = 0.0;
        A[347] = 0.0;
        A[348] = -0.0012786596*G0_;
        A[349] = 0.0;
        A[350] = 0.01287478*G0_;
        A[351] = 0.0;
        A[352] = 0.0;
        A[353] = 0.0;
        A[354] = 0.0024691358*G0_;
        A[355] = -0.0076719577*G0_;
        A[356] = 0.013051146*G0_;
        A[357] = 0.0;
        A[358] = 0.0;
        A[359] = 0.0;
        A[360] = 0.0;
        A[361] = 0.0;
        A[362] = 0.0;
        A[363] = 0.0;
        A[364] = 0.0;
        A[365] = 0.0;
        A[366] = 0.0;
        A[367] = 0.0;
        A[368] = 0.0;
        A[369] = 0.0;
        A[370] = 0.0;
        A[371] = 0.0;
        A[372] = 0.0;
        A[373] = 0.0;
        A[374] = 0.0;
        A[375] = 0.0;
        A[376] = 0.0;
        A[377] = 0.0;
        A[378] = 0.0;
        A[379] = 0.0;
        A[380] = 0.0;
        A[381] = 0.0;
        A[382] = 0.0;
        A[383] = 0.0;
        A[384] = 0.0;
        A[385] = 0.0;
        A[386] = 0.0;
        A[387] = 0.0;
        A[388] = 0.0;
        A[389] = 0.0;
        A[390] = 0.0;
        A[391] = 0.0;
        A[392] = 0.0;
        A[393] = 0.0;
        A[394] = 0.0;
        A[395] = 0.0;
        A[396] = 0.0;
        A[397] = 0.0;
        A[398] = 0.0;
        A[399] = 0.0;
        A[400] = 0.0;
        A[401] = 0.0;
        A[402] = 0.0;
        A[403] = 0.0;
        A[404] = 0.0;
        A[405] = 0.0;
        A[406] = 0.0;
        A[407] = 0.0;
        A[408] = 0.0;
        A[409] = 0.0;
        A[410] = 0.0;
        A[411] = 0.0;
        A[412] = 0.0;
        A[413] = 0.0;
        A[414] = 0.0;
        A[415] = 0.0;
        A[416] = 0.0;
        A[417] = 0.0;
        A[418] = 0.0;
        A[419] = 0.0;
        A[420] = 0.0;
        A[421] = 0.0;
        A[422] = 0.0;
        A[423] = 0.0;
        A[424] = 0.0;
        A[425] = 0.0;
        A[426] = 0.0;
        A[427] = 0.0;
        A[428] = 0.0;
        A[429] = 0.0;
        A[430] = 0.0;
        A[431] = 0.0;
        A[432] = 0.013051146*G1_;
        A[433] = 0.0;
        A[434] = 0.0024691358*G1_;
        A[435] = 0.0;
        A[436] = 0.0;
        A[437] = 0.0;
        A[438] = 0.079012346*G1_;
        A[439] = -0.016931217*G1_;
        A[440] = 0.011287478*G1_;
        A[441] = 0.0;
        A[442] = 0.0;
        A[443] = 0.0;
        A[444] = 0.013051146*G0_;
        A[445] = 0.0;
        A[446] = 0.0024691358*G0_;
        A[447] = 0.0;
        A[448] = 0.0;
        A[449] = 0.0;
        A[450] = 0.079012346*G0_;
        A[451] = -0.016931217*G0_;
        A[452] = 0.011287478*G0_;
        A[453] = 0.0;
        A[454] = 0.0;
        A[455] = 0.0;
        A[456] = -0.0076719577*G1_;
        A[457] = 0.0;
        A[458] = -0.0076719577*G1_;
        A[459] = 0.0;
        A[460] = 0.0;
        A[461] = 0.0;
        A[462] = -0.016931217*G1_;
        A[463] = 0.082539683*G1_;
        A[464] = -0.016931217*G1_;
        A[465] = 0.0;
        A[466] = 0.0;
        A[467] = 0.0;
        A[468] = -0.0076719577*G0_;
        A[469] = 0.0;
        A[470] = -0.0076719577*G0_;
        A[471] = 0.0;
        A[472] = 0.0;
        A[473] = 0.0;
        A[474] = -0.016931217*G0_;
        A[475] = 0.082539683*G0_;
        A[476] = -0.016931217*G0_;
        A[477] = 0.0;
        A[478] = 0.0;
        A[479] = 0.0;
        A[480] = 0.0024691358*G1_;
        A[481] = 0.0;
        A[482] = 0.013051146*G1_;
        A[483] = 0.0;
        A[484] = 0.0;
        A[485] = 0.0;
        A[486] = 0.011287478*G1_;
        A[487] = -0.016931217*G1_;
        A[488] = 0.079012346*G1_;
        A[489] = 0.0;
        A[490] = 0.0;
        A[491] = 0.0;
        A[492] = 0.0024691358*G0_;
        A[493] = 0.0;
        A[494] = 0.013051146*G0_;
        A[495] = 0.0;
        A[496] = 0.0;
        A[497] = 0.0;
        A[498] = 0.011287478*G0_;
        A[499] = -0.016931217*G0_;
        A[500] = 0.079012346*G0_;
        A[501] = 0.0;
        A[502] = 0.0;
        A[503] = 0.0;
        A[504] = 0.0;
        A[505] = 0.0;
        A[506] = 0.0;
        A[507] = 0.0;
        A[508] = 0.0;
        A[509] = 0.0;
        A[510] = 0.0;
        A[511] = 0.0;
        A[512] = 0.0;
        A[513] = 0.0;
        A[514] = 0.0;
        A[515] = 0.0;
        A[516] = 0.0;
        A[517] = 0.0;
        A[518] = 0.0;
        A[519] = 0.0;
        A[520] = 0.0;
        A[521] = 0.0;
        A[522] = 0.0;
        A[523] = 0.0;
        A[524] = 0.0;
        A[525] = 0.0;
        A[526] = 0.0;
        A[527] = 0.0;
        A[528] = 0.0;
        A[529] = 0.0;
        A[530] = 0.0;
        A[531] = 0.0;
        A[532] = 0.0;
        A[533] = 0.0;
        A[534] = 0.0;
        A[535] = 0.0;
        A[536] = 0.0;
        A[537] = 0.0;
        A[538] = 0.0;
        A[539] = 0.0;
        A[540] = 0.0;
        A[541] = 0.0;
        A[542] = 0.0;
        A[543] = 0.0;
        A[544] = 0.0;
        A[545] = 0.0;
        A[546] = 0.0;
        A[547] = 0.0;
        A[548] = 0.0;
        A[549] = 0.0;
        A[550] = 0.0;
        A[551] = 0.0;
        A[552] = 0.0;
        A[553] = 0.0;
        A[554] = 0.0;
        A[555] = 0.0;
        A[556] = 0.0;
        A[557] = 0.0;
        A[558] = 0.0;
        A[559] = 0.0;
        A[560] = 0.0;
        A[561] = 0.0;
        A[562] = 0.0;
        A[563] = 0.0;
        A[564] = 0.0;
        A[565] = 0.0;
        A[566] = 0.0;
        A[567] = 0.0;
        A[568] = 0.0;
        A[569] = 0.0;
        A[570] = 0.0;
        A[571] = 0.0;
        A[572] = 0.0;
        A[573] = 0.0;
        A[574] = 0.0;
        A[575] = 0.0;
          break;
        }
      case 2:
        {
          A[0] = 0.01287478*G3_;
        A[1] = 0.0;
        A[2] = -0.0012786596*G3_;
        A[3] = 0.0;
        A[4] = 0.0;
        A[5] = 0.0;
        A[6] = 0.013051146*G3_;
        A[7] = -0.0076719577*G3_;
        A[8] = 0.0024691358*G3_;
        A[9] = 0.0;
        A[10] = 0.0;
        A[11] = 0.0;
        A[12] = 0.01287478*G2_;
        A[13] = -0.0012786596*G2_;
        A[14] = 0.0;
        A[15] = 0.0;
        A[16] = 0.0;
        A[17] = 0.0;
        A[18] = 0.0;
        A[19] = 0.0;
        A[20] = 0.0;
        A[21] = 0.013051146*G2_;
        A[22] = -0.0076719577*G2_;
        A[23] = 0.0024691358*G2_;
        A[24] = 0.0;
        A[25] = 0.0;
        A[26] = 0.0;
        A[27] = 0.0;
        A[28] = 0.0;
        A[29] = 0.0;
        A[30] = 0.0;
        A[31] = 0.0;
        A[32] = 0.0;
        A[33] = 0.0;
        A[34] = 0.0;
        A[35] = 0.0;
        A[36] = 0.0;
        A[37] = 0.0;
        A[38] = 0.0;
        A[39] = 0.0;
        A[40] = 0.0;
        A[41] = 0.0;
        A[42] = 0.0;
        A[43] = 0.0;
        A[44] = 0.0;
        A[45] = 0.0;
        A[46] = 0.0;
        A[47] = 0.0;
        A[48] = -0.0012786596*G3_;
        A[49] = 0.0;
        A[50] = 0.01287478*G3_;
        A[51] = 0.0;
        A[52] = 0.0;
        A[53] = 0.0;
        A[54] = 0.0024691358*G3_;
        A[55] = -0.0076719577*G3_;
        A[56] = 0.013051146*G3_;
        A[57] = 0.0;
        A[58] = 0.0;
        A[59] = 0.0;
        A[60] = -0.0012786596*G2_;
        A[61] = 0.01287478*G2_;
        A[62] = 0.0;
        A[63] = 0.0;
        A[64] = 0.0;
        A[65] = 0.0;
        A[66] = 0.0;
        A[67] = 0.0;
        A[68] = 0.0;
        A[69] = 0.0024691358*G2_;
        A[70] = -0.0076719577*G2_;
        A[71] = 0.013051146*G2_;
        A[72] = 0.0;
        A[73] = 0.0;
        A[74] = 0.0;
        A[75] = 0.0;
        A[76] = 0.0;
        A[77] = 0.0;
        A[78] = 0.0;
        A[79] = 0.0;
        A[80] = 0.0;
        A[81] = 0.0;
        A[82] = 0.0;
        A[83] = 0.0;
        A[84] = 0.0;
        A[85] = 0.0;
        A[86] = 0.0;
        A[87] = 0.0;
        A[88] = 0.0;
        A[89] = 0.0;
        A[90] = 0.0;
        A[91] = 0.0;
        A[92] = 0.0;
        A[93] = 0.0;
        A[94] = 0.0;
        A[95] = 0.0;
        A[96] = 0.0;
        A[97] = 0.0;
        A[98] = 0.0;
        A[99] = 0.0;
        A[100] = 0.0;
        A[101] = 0.0;
        A[102] = 0.0;
        A[103] = 0.0;
        A[104] = 0.0;
        A[105] = 0.0;
        A[106] = 0.0;
        A[107] = 0.0;
        A[108] = 0.0;
        A[109] = 0.0;
        A[110] = 0.0;
        A[111] = 0.0;
        A[112] = 0.0;
        A[113] = 0.0;
        A[114] = 0.0;
        A[115] = 0.0;
        A[116] = 0.0;
        A[117] = 0.0;
        A[118] = 0.0;
        A[119] = 0.0;
        A[120] = 0.0;
        A[121] = 0.0;
        A[122] = 0.0;
        A[123] = 0.0;
        A[124] = 0.0;
        A[125] = 0.0;
        A[126] = 0.0;
        A[127] = 0.0;
        A[128] = 0.0;
        A[129] = 0.0;
        A[130] = 0.0;
        A[131] = 0.0;
        A[132] = 0.0;
        A[133] = 0.0;
        A[134] = 0.0;
        A[135] = 0.0;
        A[136] = 0.0;
        A[137] = 0.0;
        A[138] = 0.0;
        A[139] = 0.0;
        A[140] = 0.0;
        A[141] = 0.0;
        A[142] = 0.0;
        A[143] = 0.0;
        A[144] = 0.013051146*G3_;
        A[145] = 0.0;
        A[146] = 0.0024691358*G3_;
        A[147] = 0.0;
        A[148] = 0.0;
        A[149] = 0.0;
        A[150] = 0.079012346*G3_;
        A[151] = -0.016931217*G3_;
        A[152] = 0.011287478*G3_;
        A[153] = 0.0;
        A[154] = 0.0;
        A[155] = 0.0;
        A[156] = 0.013051146*G2_;
        A[157] = 0.0024691358*G2_;
        A[158] = 0.0;
        A[159] = 0.0;
        A[160] = 0.0;
        A[161] = 0.0;
        A[162] = 0.0;
        A[163] = 0.0;
        A[164] = 0.0;
        A[165] = 0.079012346*G2_;
        A[166] = -0.016931217*G2_;
        A[167] = 0.011287478*G2_;
        A[168] = -0.0076719577*G3_;
        A[169] = 0.0;
        A[170] = -0.0076719577*G3_;
        A[171] = 0.0;
        A[172] = 0.0;
        A[173] = 0.0;
        A[174] = -0.016931217*G3_;
        A[175] = 0.082539683*G3_;
        A[176] = -0.016931217*G3_;
        A[177] = 0.0;
        A[178] = 0.0;
        A[179] = 0.0;
        A[180] = -0.0076719577*G2_;
        A[181] = -0.0076719577*G2_;
        A[182] = 0.0;
        A[183] = 0.0;
        A[184] = 0.0;
        A[185] = 0.0;
        A[186] = 0.0;
        A[187] = 0.0;
        A[188] = 0.0;
        A[189] = -0.016931217*G2_;
        A[190] = 0.082539683*G2_;
        A[191] = -0.016931217*G2_;
        A[192] = 0.0024691358*G3_;
        A[193] = 0.0;
        A[194] = 0.013051146*G3_;
        A[195] = 0.0;
        A[196] = 0.0;
        A[197] = 0.0;
        A[198] = 0.011287478*G3_;
        A[199] = -0.016931217*G3_;
        A[200] = 0.079012346*G3_;
        A[201] = 0.0;
        A[202] = 0.0;
        A[203] = 0.0;
        A[204] = 0.0024691358*G2_;
        A[205] = 0.013051146*G2_;
        A[206] = 0.0;
        A[207] = 0.0;
        A[208] = 0.0;
        A[209] = 0.0;
        A[210] = 0.0;
        A[211] = 0.0;
        A[212] = 0.0;
        A[213] = 0.011287478*G2_;
        A[214] = -0.016931217*G2_;
        A[215] = 0.079012346*G2_;
        A[216] = 0.0;
        A[217] = 0.0;
        A[218] = 0.0;
        A[219] = 0.0;
        A[220] = 0.0;
        A[221] = 0.0;
        A[222] = 0.0;
        A[223] = 0.0;
        A[224] = 0.0;
        A[225] = 0.0;
        A[226] = 0.0;
        A[227] = 0.0;
        A[228] = 0.0;
        A[229] = 0.0;
        A[230] = 0.0;
        A[231] = 0.0;
        A[232] = 0.0;
        A[233] = 0.0;
        A[234] = 0.0;
        A[235] = 0.0;
        A[236] = 0.0;
        A[237] = 0.0;
        A[238] = 0.0;
        A[239] = 0.0;
        A[240] = 0.0;
        A[241] = 0.0;
        A[242] = 0.0;
        A[243] = 0.0;
        A[244] = 0.0;
        A[245] = 0.0;
        A[246] = 0.0;
        A[247] = 0.0;
        A[248] = 0.0;
        A[249] = 0.0;
        A[250] = 0.0;
        A[251] = 0.0;
        A[252] = 0.0;
        A[253] = 0.0;
        A[254] = 0.0;
        A[255] = 0.0;
        A[256] = 0.0;
        A[257] = 0.0;
        A[258] = 0.0;
        A[259] = 0.0;
        A[260] = 0.0;
        A[261] = 0.0;
        A[262] = 0.0;
        A[263] = 0.0;
        A[264] = 0.0;
        A[265] = 0.0;
        A[266] = 0.0;
        A[267] = 0.0;
        A[268] = 0.0;
        A[269] = 0.0;
        A[270] = 0.0;
        A[271] = 0.0;
        A[272] = 0.0;
        A[273] = 0.0;
        A[274] = 0.0;
        A[275] = 0.0;
        A[276] = 0.0;
        A[277] = 0.0;
        A[278] = 0.0;
        A[279] = 0.0;
        A[280] = 0.0;
        A[281] = 0.0;
        A[282] = 0.0;
        A[283] = 0.0;
        A[284] = 0.0;
        A[285] = 0.0;
        A[286] = 0.0;
        A[287] = 0.0;
        A[288] = 0.01287478*G1_;
        A[289] = 0.0;
        A[290] = -0.0012786596*G1_;
        A[291] = 0.0;
        A[292] = 0.0;
        A[293] = 0.0;
        A[294] = 0.013051146*G1_;
        A[295] = -0.0076719577*G1_;
        A[296] = 0.0024691358*G1_;
        A[297] = 0.0;
        A[298] = 0.0;
        A[299] = 0.0;
        A[300] = 0.01287478*G0_;
        A[301] = -0.0012786596*G0_;
        A[302] = 0.0;
        A[303] = 0.0;
        A[304] = 0.0;
        A[305] = 0.0;
        A[306] = 0.0;
        A[307] = 0.0;
        A[308] = 0.0;
        A[309] = 0.013051146*G0_;
        A[310] = -0.0076719577*G0_;
        A[311] = 0.0024691358*G0_;
        A[312] = -0.0012786596*G1_;
        A[313] = 0.0;
        A[314] = 0.01287478*G1_;
        A[315] = 0.0;
        A[316] = 0.0;
        A[317] = 0.0;
        A[318] = 0.0024691358*G1_;
        A[319] = -0.0076719577*G1_;
        A[320] = 0.013051146*G1_;
        A[321] = 0.0;
        A[322] = 0.0;
        A[323] = 0.0;
        A[324] = -0.0012786596*G0_;
        A[325] = 0.01287478*G0_;
        A[326] = 0.0;
        A[327] = 0.0;
        A[328] = 0.0;
        A[329] = 0.0;
        A[330] = 0.0;
        A[331] = 0.0;
        A[332] = 0.0;
        A[333] = 0.0024691358*G0_;
        A[334] = -0.0076719577*G0_;
        A[335] = 0.013051146*G0_;
        A[336] = 0.0;
        A[337] = 0.0;
        A[338] = 0.0;
        A[339] = 0.0;
        A[340] = 0.0;
        A[341] = 0.0;
        A[342] = 0.0;
        A[343] = 0.0;
        A[344] = 0.0;
        A[345] = 0.0;
        A[346] = 0.0;
        A[347] = 0.0;
        A[348] = 0.0;
        A[349] = 0.0;
        A[350] = 0.0;
        A[351] = 0.0;
        A[352] = 0.0;
        A[353] = 0.0;
        A[354] = 0.0;
        A[355] = 0.0;
        A[356] = 0.0;
        A[357] = 0.0;
        A[358] = 0.0;
        A[359] = 0.0;
        A[360] = 0.0;
        A[361] = 0.0;
        A[362] = 0.0;
        A[363] = 0.0;
        A[364] = 0.0;
        A[365] = 0.0;
        A[366] = 0.0;
        A[367] = 0.0;
        A[368] = 0.0;
        A[369] = 0.0;
        A[370] = 0.0;
        A[371] = 0.0;
        A[372] = 0.0;
        A[373] = 0.0;
        A[374] = 0.0;
        A[375] = 0.0;
        A[376] = 0.0;
        A[377] = 0.0;
        A[378] = 0.0;
        A[379] = 0.0;
        A[380] = 0.0;
        A[381] = 0.0;
        A[382] = 0.0;
        A[383] = 0.0;
        A[384] = 0.0;
        A[385] = 0.0;
        A[386] = 0.0;
        A[387] = 0.0;
        A[388] = 0.0;
        A[389] = 0.0;
        A[390] = 0.0;
        A[391] = 0.0;
        A[392] = 0.0;
        A[393] = 0.0;
        A[394] = 0.0;
        A[395] = 0.0;
        A[396] = 0.0;
        A[397] = 0.0;
        A[398] = 0.0;
        A[399] = 0.0;
        A[400] = 0.0;
        A[401] = 0.0;
        A[402] = 0.0;
        A[403] = 0.0;
        A[404] = 0.0;
        A[405] = 0.0;
        A[406] = 0.0;
        A[407] = 0.0;
        A[408] = 0.0;
        A[409] = 0.0;
        A[410] = 0.0;
        A[411] = 0.0;
        A[412] = 0.0;
        A[413] = 0.0;
        A[414] = 0.0;
        A[415] = 0.0;
        A[416] = 0.0;
        A[417] = 0.0;
        A[418] = 0.0;
        A[419] = 0.0;
        A[420] = 0.0;
        A[421] = 0.0;
        A[422] = 0.0;
        A[423] = 0.0;
        A[424] = 0.0;
        A[425] = 0.0;
        A[426] = 0.0;
        A[427] = 0.0;
        A[428] = 0.0;
        A[429] = 0.0;
        A[430] = 0.0;
        A[431] = 0.0;
        A[432] = 0.0;
        A[433] = 0.0;
        A[434] = 0.0;
        A[435] = 0.0;
        A[436] = 0.0;
        A[437] = 0.0;
        A[438] = 0.0;
        A[439] = 0.0;
        A[440] = 0.0;
        A[441] = 0.0;
        A[442] = 0.0;
        A[443] = 0.0;
        A[444] = 0.0;
        A[445] = 0.0;
        A[446] = 0.0;
        A[447] = 0.0;
        A[448] = 0.0;
        A[449] = 0.0;
        A[450] = 0.0;
        A[451] = 0.0;
        A[452] = 0.0;
        A[453] = 0.0;
        A[454] = 0.0;
        A[455] = 0.0;
        A[456] = 0.0;
        A[457] = 0.0;
        A[458] = 0.0;
        A[459] = 0.0;
        A[460] = 0.0;
        A[461] = 0.0;
        A[462] = 0.0;
        A[463] = 0.0;
        A[464] = 0.0;
        A[465] = 0.0;
        A[466] = 0.0;
        A[467] = 0.0;
        A[468] = 0.0;
        A[469] = 0.0;
        A[470] = 0.0;
        A[471] = 0.0;
        A[472] = 0.0;
        A[473] = 0.0;
        A[474] = 0.0;
        A[475] = 0.0;
        A[476] = 0.0;
        A[477] = 0.0;
        A[478] = 0.0;
        A[479] = 0.0;
        A[480] = 0.0;
        A[481] = 0.0;
        A[482] = 0.0;
        A[483] = 0.0;
        A[484] = 0.0;
        A[485] = 0.0;
        A[486] = 0.0;
        A[487] = 0.0;
        A[488] = 0.0;
        A[489] = 0.0;
        A[490] = 0.0;
        A[491] = 0.0;
        A[492] = 0.0;
        A[493] = 0.0;
        A[494] = 0.0;
        A[495] = 0.0;
        A[496] = 0.0;
        A[497] = 0.0;
        A[498] = 0.0;
        A[499] = 0.0;
        A[500] = 0.0;
        A[501] = 0.0;
        A[502] = 0.0;
        A[503] = 0.0;
        A[504] = 0.013051146*G1_;
        A[505] = 0.0;
        A[506] = 0.0024691358*G1_;
        A[507] = 0.0;
        A[508] = 0.0;
        A[509] = 0.0;
        A[510] = 0.079012346*G1_;
        A[511] = -0.016931217*G1_;
        A[512] = 0.011287478*G1_;
        A[513] = 0.0;
        A[514] = 0.0;
        A[515] = 0.0;
        A[516] = 0.013051146*G0_;
        A[517] = 0.0024691358*G0_;
        A[518] = 0.0;
        A[519] = 0.0;
        A[520] = 0.0;
        A[521] = 0.0;
        A[522] = 0.0;
        A[523] = 0.0;
        A[524] = 0.0;
        A[525] = 0.079012346*G0_;
        A[526] = -0.016931217*G0_;
        A[527] = 0.011287478*G0_;
        A[528] = -0.0076719577*G1_;
        A[529] = 0.0;
        A[530] = -0.0076719577*G1_;
        A[531] = 0.0;
        A[532] = 0.0;
        A[533] = 0.0;
        A[534] = -0.016931217*G1_;
        A[535] = 0.082539683*G1_;
        A[536] = -0.016931217*G1_;
        A[537] = 0.0;
        A[538] = 0.0;
        A[539] = 0.0;
        A[540] = -0.0076719577*G0_;
        A[541] = -0.0076719577*G0_;
        A[542] = 0.0;
        A[543] = 0.0;
        A[544] = 0.0;
        A[545] = 0.0;
        A[546] = 0.0;
        A[547] = 0.0;
        A[548] = 0.0;
        A[549] = -0.016931217*G0_;
        A[550] = 0.082539683*G0_;
        A[551] = -0.016931217*G0_;
        A[552] = 0.0024691358*G1_;
        A[553] = 0.0;
        A[554] = 0.013051146*G1_;
        A[555] = 0.0;
        A[556] = 0.0;
        A[557] = 0.0;
        A[558] = 0.011287478*G1_;
        A[559] = -0.016931217*G1_;
        A[560] = 0.079012346*G1_;
        A[561] = 0.0;
        A[562] = 0.0;
        A[563] = 0.0;
        A[564] = 0.0024691358*G0_;
        A[565] = 0.013051146*G0_;
        A[566] = 0.0;
        A[567] = 0.0;
        A[568] = 0.0;
        A[569] = 0.0;
        A[570] = 0.0;
        A[571] = 0.0;
        A[572] = 0.0;
        A[573] = 0.011287478*G0_;
        A[574] = -0.016931217*G0_;
        A[575] = 0.079012346*G0_;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        switch (facet_1)
      {
      case 0:
        {
          A[0] = 0.01287478*G3_;
        A[1] = -0.0012786596*G3_;
        A[2] = 0.0;
        A[3] = 0.0;
        A[4] = 0.0;
        A[5] = 0.0;
        A[6] = 0.0;
        A[7] = 0.0;
        A[8] = 0.0;
        A[9] = 0.013051146*G3_;
        A[10] = -0.0076719577*G3_;
        A[11] = 0.0024691358*G3_;
        A[12] = 0.0;
        A[13] = 0.01287478*G2_;
        A[14] = -0.0012786596*G2_;
        A[15] = 0.013051146*G2_;
        A[16] = -0.0076719577*G2_;
        A[17] = 0.0024691358*G2_;
        A[18] = 0.0;
        A[19] = 0.0;
        A[20] = 0.0;
        A[21] = 0.0;
        A[22] = 0.0;
        A[23] = 0.0;
        A[24] = -0.0012786596*G3_;
        A[25] = 0.01287478*G3_;
        A[26] = 0.0;
        A[27] = 0.0;
        A[28] = 0.0;
        A[29] = 0.0;
        A[30] = 0.0;
        A[31] = 0.0;
        A[32] = 0.0;
        A[33] = 0.0024691358*G3_;
        A[34] = -0.0076719577*G3_;
        A[35] = 0.013051146*G3_;
        A[36] = 0.0;
        A[37] = -0.0012786596*G2_;
        A[38] = 0.01287478*G2_;
        A[39] = 0.0024691358*G2_;
        A[40] = -0.0076719577*G2_;
        A[41] = 0.013051146*G2_;
        A[42] = 0.0;
        A[43] = 0.0;
        A[44] = 0.0;
        A[45] = 0.0;
        A[46] = 0.0;
        A[47] = 0.0;
        A[48] = 0.0;
        A[49] = 0.0;
        A[50] = 0.0;
        A[51] = 0.0;
        A[52] = 0.0;
        A[53] = 0.0;
        A[54] = 0.0;
        A[55] = 0.0;
        A[56] = 0.0;
        A[57] = 0.0;
        A[58] = 0.0;
        A[59] = 0.0;
        A[60] = 0.0;
        A[61] = 0.0;
        A[62] = 0.0;
        A[63] = 0.0;
        A[64] = 0.0;
        A[65] = 0.0;
        A[66] = 0.0;
        A[67] = 0.0;
        A[68] = 0.0;
        A[69] = 0.0;
        A[70] = 0.0;
        A[71] = 0.0;
        A[72] = 0.0;
        A[73] = 0.0;
        A[74] = 0.0;
        A[75] = 0.0;
        A[76] = 0.0;
        A[77] = 0.0;
        A[78] = 0.0;
        A[79] = 0.0;
        A[80] = 0.0;
        A[81] = 0.0;
        A[82] = 0.0;
        A[83] = 0.0;
        A[84] = 0.0;
        A[85] = 0.0;
        A[86] = 0.0;
        A[87] = 0.0;
        A[88] = 0.0;
        A[89] = 0.0;
        A[90] = 0.0;
        A[91] = 0.0;
        A[92] = 0.0;
        A[93] = 0.0;
        A[94] = 0.0;
        A[95] = 0.0;
        A[96] = 0.0;
        A[97] = 0.0;
        A[98] = 0.0;
        A[99] = 0.0;
        A[100] = 0.0;
        A[101] = 0.0;
        A[102] = 0.0;
        A[103] = 0.0;
        A[104] = 0.0;
        A[105] = 0.0;
        A[106] = 0.0;
        A[107] = 0.0;
        A[108] = 0.0;
        A[109] = 0.0;
        A[110] = 0.0;
        A[111] = 0.0;
        A[112] = 0.0;
        A[113] = 0.0;
        A[114] = 0.0;
        A[115] = 0.0;
        A[116] = 0.0;
        A[117] = 0.0;
        A[118] = 0.0;
        A[119] = 0.0;
        A[120] = 0.0;
        A[121] = 0.0;
        A[122] = 0.0;
        A[123] = 0.0;
        A[124] = 0.0;
        A[125] = 0.0;
        A[126] = 0.0;
        A[127] = 0.0;
        A[128] = 0.0;
        A[129] = 0.0;
        A[130] = 0.0;
        A[131] = 0.0;
        A[132] = 0.0;
        A[133] = 0.0;
        A[134] = 0.0;
        A[135] = 0.0;
        A[136] = 0.0;
        A[137] = 0.0;
        A[138] = 0.0;
        A[139] = 0.0;
        A[140] = 0.0;
        A[141] = 0.0;
        A[142] = 0.0;
        A[143] = 0.0;
        A[144] = 0.0;
        A[145] = 0.0;
        A[146] = 0.0;
        A[147] = 0.0;
        A[148] = 0.0;
        A[149] = 0.0;
        A[150] = 0.0;
        A[151] = 0.0;
        A[152] = 0.0;
        A[153] = 0.0;
        A[154] = 0.0;
        A[155] = 0.0;
        A[156] = 0.0;
        A[157] = 0.0;
        A[158] = 0.0;
        A[159] = 0.0;
        A[160] = 0.0;
        A[161] = 0.0;
        A[162] = 0.0;
        A[163] = 0.0;
        A[164] = 0.0;
        A[165] = 0.0;
        A[166] = 0.0;
        A[167] = 0.0;
        A[168] = 0.0;
        A[169] = 0.0;
        A[170] = 0.0;
        A[171] = 0.0;
        A[172] = 0.0;
        A[173] = 0.0;
        A[174] = 0.0;
        A[175] = 0.0;
        A[176] = 0.0;
        A[177] = 0.0;
        A[178] = 0.0;
        A[179] = 0.0;
        A[180] = 0.0;
        A[181] = 0.0;
        A[182] = 0.0;
        A[183] = 0.0;
        A[184] = 0.0;
        A[185] = 0.0;
        A[186] = 0.0;
        A[187] = 0.0;
        A[188] = 0.0;
        A[189] = 0.0;
        A[190] = 0.0;
        A[191] = 0.0;
        A[192] = 0.0;
        A[193] = 0.0;
        A[194] = 0.0;
        A[195] = 0.0;
        A[196] = 0.0;
        A[197] = 0.0;
        A[198] = 0.0;
        A[199] = 0.0;
        A[200] = 0.0;
        A[201] = 0.0;
        A[202] = 0.0;
        A[203] = 0.0;
        A[204] = 0.0;
        A[205] = 0.0;
        A[206] = 0.0;
        A[207] = 0.0;
        A[208] = 0.0;
        A[209] = 0.0;
        A[210] = 0.0;
        A[211] = 0.0;
        A[212] = 0.0;
        A[213] = 0.0;
        A[214] = 0.0;
        A[215] = 0.0;
        A[216] = 0.013051146*G3_;
        A[217] = 0.0024691358*G3_;
        A[218] = 0.0;
        A[219] = 0.0;
        A[220] = 0.0;
        A[221] = 0.0;
        A[222] = 0.0;
        A[223] = 0.0;
        A[224] = 0.0;
        A[225] = 0.079012346*G3_;
        A[226] = -0.016931217*G3_;
        A[227] = 0.011287478*G3_;
        A[228] = 0.0;
        A[229] = 0.013051146*G2_;
        A[230] = 0.0024691358*G2_;
        A[231] = 0.079012346*G2_;
        A[232] = -0.016931217*G2_;
        A[233] = 0.011287478*G2_;
        A[234] = 0.0;
        A[235] = 0.0;
        A[236] = 0.0;
        A[237] = 0.0;
        A[238] = 0.0;
        A[239] = 0.0;
        A[240] = -0.0076719577*G3_;
        A[241] = -0.0076719577*G3_;
        A[242] = 0.0;
        A[243] = 0.0;
        A[244] = 0.0;
        A[245] = 0.0;
        A[246] = 0.0;
        A[247] = 0.0;
        A[248] = 0.0;
        A[249] = -0.016931217*G3_;
        A[250] = 0.082539683*G3_;
        A[251] = -0.016931217*G3_;
        A[252] = 0.0;
        A[253] = -0.0076719577*G2_;
        A[254] = -0.0076719577*G2_;
        A[255] = -0.016931217*G2_;
        A[256] = 0.082539683*G2_;
        A[257] = -0.016931217*G2_;
        A[258] = 0.0;
        A[259] = 0.0;
        A[260] = 0.0;
        A[261] = 0.0;
        A[262] = 0.0;
        A[263] = 0.0;
        A[264] = 0.0024691358*G3_;
        A[265] = 0.013051146*G3_;
        A[266] = 0.0;
        A[267] = 0.0;
        A[268] = 0.0;
        A[269] = 0.0;
        A[270] = 0.0;
        A[271] = 0.0;
        A[272] = 0.0;
        A[273] = 0.011287478*G3_;
        A[274] = -0.016931217*G3_;
        A[275] = 0.079012346*G3_;
        A[276] = 0.0;
        A[277] = 0.0024691358*G2_;
        A[278] = 0.013051146*G2_;
        A[279] = 0.011287478*G2_;
        A[280] = -0.016931217*G2_;
        A[281] = 0.079012346*G2_;
        A[282] = 0.0;
        A[283] = 0.0;
        A[284] = 0.0;
        A[285] = 0.0;
        A[286] = 0.0;
        A[287] = 0.0;
        A[288] = 0.0;
        A[289] = 0.0;
        A[290] = 0.0;
        A[291] = 0.0;
        A[292] = 0.0;
        A[293] = 0.0;
        A[294] = 0.0;
        A[295] = 0.0;
        A[296] = 0.0;
        A[297] = 0.0;
        A[298] = 0.0;
        A[299] = 0.0;
        A[300] = 0.0;
        A[301] = 0.0;
        A[302] = 0.0;
        A[303] = 0.0;
        A[304] = 0.0;
        A[305] = 0.0;
        A[306] = 0.0;
        A[307] = 0.0;
        A[308] = 0.0;
        A[309] = 0.0;
        A[310] = 0.0;
        A[311] = 0.0;
        A[312] = 0.01287478*G1_;
        A[313] = -0.0012786596*G1_;
        A[314] = 0.0;
        A[315] = 0.0;
        A[316] = 0.0;
        A[317] = 0.0;
        A[318] = 0.0;
        A[319] = 0.0;
        A[320] = 0.0;
        A[321] = 0.013051146*G1_;
        A[322] = -0.0076719577*G1_;
        A[323] = 0.0024691358*G1_;
        A[324] = 0.0;
        A[325] = 0.01287478*G0_;
        A[326] = -0.0012786596*G0_;
        A[327] = 0.013051146*G0_;
        A[328] = -0.0076719577*G0_;
        A[329] = 0.0024691358*G0_;
        A[330] = 0.0;
        A[331] = 0.0;
        A[332] = 0.0;
        A[333] = 0.0;
        A[334] = 0.0;
        A[335] = 0.0;
        A[336] = -0.0012786596*G1_;
        A[337] = 0.01287478*G1_;
        A[338] = 0.0;
        A[339] = 0.0;
        A[340] = 0.0;
        A[341] = 0.0;
        A[342] = 0.0;
        A[343] = 0.0;
        A[344] = 0.0;
        A[345] = 0.0024691358*G1_;
        A[346] = -0.0076719577*G1_;
        A[347] = 0.013051146*G1_;
        A[348] = 0.0;
        A[349] = -0.0012786596*G0_;
        A[350] = 0.01287478*G0_;
        A[351] = 0.0024691358*G0_;
        A[352] = -0.0076719577*G0_;
        A[353] = 0.013051146*G0_;
        A[354] = 0.0;
        A[355] = 0.0;
        A[356] = 0.0;
        A[357] = 0.0;
        A[358] = 0.0;
        A[359] = 0.0;
        A[360] = 0.013051146*G1_;
        A[361] = 0.0024691358*G1_;
        A[362] = 0.0;
        A[363] = 0.0;
        A[364] = 0.0;
        A[365] = 0.0;
        A[366] = 0.0;
        A[367] = 0.0;
        A[368] = 0.0;
        A[369] = 0.079012346*G1_;
        A[370] = -0.016931217*G1_;
        A[371] = 0.011287478*G1_;
        A[372] = 0.0;
        A[373] = 0.013051146*G0_;
        A[374] = 0.0024691358*G0_;
        A[375] = 0.079012346*G0_;
        A[376] = -0.016931217*G0_;
        A[377] = 0.011287478*G0_;
        A[378] = 0.0;
        A[379] = 0.0;
        A[380] = 0.0;
        A[381] = 0.0;
        A[382] = 0.0;
        A[383] = 0.0;
        A[384] = -0.0076719577*G1_;
        A[385] = -0.0076719577*G1_;
        A[386] = 0.0;
        A[387] = 0.0;
        A[388] = 0.0;
        A[389] = 0.0;
        A[390] = 0.0;
        A[391] = 0.0;
        A[392] = 0.0;
        A[393] = -0.016931217*G1_;
        A[394] = 0.082539683*G1_;
        A[395] = -0.016931217*G1_;
        A[396] = 0.0;
        A[397] = -0.0076719577*G0_;
        A[398] = -0.0076719577*G0_;
        A[399] = -0.016931217*G0_;
        A[400] = 0.082539683*G0_;
        A[401] = -0.016931217*G0_;
        A[402] = 0.0;
        A[403] = 0.0;
        A[404] = 0.0;
        A[405] = 0.0;
        A[406] = 0.0;
        A[407] = 0.0;
        A[408] = 0.0024691358*G1_;
        A[409] = 0.013051146*G1_;
        A[410] = 0.0;
        A[411] = 0.0;
        A[412] = 0.0;
        A[413] = 0.0;
        A[414] = 0.0;
        A[415] = 0.0;
        A[416] = 0.0;
        A[417] = 0.011287478*G1_;
        A[418] = -0.016931217*G1_;
        A[419] = 0.079012346*G1_;
        A[420] = 0.0;
        A[421] = 0.0024691358*G0_;
        A[422] = 0.013051146*G0_;
        A[423] = 0.011287478*G0_;
        A[424] = -0.016931217*G0_;
        A[425] = 0.079012346*G0_;
        A[426] = 0.0;
        A[427] = 0.0;
        A[428] = 0.0;
        A[429] = 0.0;
        A[430] = 0.0;
        A[431] = 0.0;
        A[432] = 0.0;
        A[433] = 0.0;
        A[434] = 0.0;
        A[435] = 0.0;
        A[436] = 0.0;
        A[437] = 0.0;
        A[438] = 0.0;
        A[439] = 0.0;
        A[440] = 0.0;
        A[441] = 0.0;
        A[442] = 0.0;
        A[443] = 0.0;
        A[444] = 0.0;
        A[445] = 0.0;
        A[446] = 0.0;
        A[447] = 0.0;
        A[448] = 0.0;
        A[449] = 0.0;
        A[450] = 0.0;
        A[451] = 0.0;
        A[452] = 0.0;
        A[453] = 0.0;
        A[454] = 0.0;
        A[455] = 0.0;
        A[456] = 0.0;
        A[457] = 0.0;
        A[458] = 0.0;
        A[459] = 0.0;
        A[460] = 0.0;
        A[461] = 0.0;
        A[462] = 0.0;
        A[463] = 0.0;
        A[464] = 0.0;
        A[465] = 0.0;
        A[466] = 0.0;
        A[467] = 0.0;
        A[468] = 0.0;
        A[469] = 0.0;
        A[470] = 0.0;
        A[471] = 0.0;
        A[472] = 0.0;
        A[473] = 0.0;
        A[474] = 0.0;
        A[475] = 0.0;
        A[476] = 0.0;
        A[477] = 0.0;
        A[478] = 0.0;
        A[479] = 0.0;
        A[480] = 0.0;
        A[481] = 0.0;
        A[482] = 0.0;
        A[483] = 0.0;
        A[484] = 0.0;
        A[485] = 0.0;
        A[486] = 0.0;
        A[487] = 0.0;
        A[488] = 0.0;
        A[489] = 0.0;
        A[490] = 0.0;
        A[491] = 0.0;
        A[492] = 0.0;
        A[493] = 0.0;
        A[494] = 0.0;
        A[495] = 0.0;
        A[496] = 0.0;
        A[497] = 0.0;
        A[498] = 0.0;
        A[499] = 0.0;
        A[500] = 0.0;
        A[501] = 0.0;
        A[502] = 0.0;
        A[503] = 0.0;
        A[504] = 0.0;
        A[505] = 0.0;
        A[506] = 0.0;
        A[507] = 0.0;
        A[508] = 0.0;
        A[509] = 0.0;
        A[510] = 0.0;
        A[511] = 0.0;
        A[512] = 0.0;
        A[513] = 0.0;
        A[514] = 0.0;
        A[515] = 0.0;
        A[516] = 0.0;
        A[517] = 0.0;
        A[518] = 0.0;
        A[519] = 0.0;
        A[520] = 0.0;
        A[521] = 0.0;
        A[522] = 0.0;
        A[523] = 0.0;
        A[524] = 0.0;
        A[525] = 0.0;
        A[526] = 0.0;
        A[527] = 0.0;
        A[528] = 0.0;
        A[529] = 0.0;
        A[530] = 0.0;
        A[531] = 0.0;
        A[532] = 0.0;
        A[533] = 0.0;
        A[534] = 0.0;
        A[535] = 0.0;
        A[536] = 0.0;
        A[537] = 0.0;
        A[538] = 0.0;
        A[539] = 0.0;
        A[540] = 0.0;
        A[541] = 0.0;
        A[542] = 0.0;
        A[543] = 0.0;
        A[544] = 0.0;
        A[545] = 0.0;
        A[546] = 0.0;
        A[547] = 0.0;
        A[548] = 0.0;
        A[549] = 0.0;
        A[550] = 0.0;
        A[551] = 0.0;
        A[552] = 0.0;
        A[553] = 0.0;
        A[554] = 0.0;
        A[555] = 0.0;
        A[556] = 0.0;
        A[557] = 0.0;
        A[558] = 0.0;
        A[559] = 0.0;
        A[560] = 0.0;
        A[561] = 0.0;
        A[562] = 0.0;
        A[563] = 0.0;
        A[564] = 0.0;
        A[565] = 0.0;
        A[566] = 0.0;
        A[567] = 0.0;
        A[568] = 0.0;
        A[569] = 0.0;
        A[570] = 0.0;
        A[571] = 0.0;
        A[572] = 0.0;
        A[573] = 0.0;
        A[574] = 0.0;
        A[575] = 0.0;
          break;
        }
      case 1:
        {
          A[0] = 0.01287478*G3_;
        A[1] = -0.0012786596*G3_;
        A[2] = 0.0;
        A[3] = 0.0;
        A[4] = 0.0;
        A[5] = 0.0;
        A[6] = 0.0;
        A[7] = 0.0;
        A[8] = 0.0;
        A[9] = 0.013051146*G3_;
        A[10] = -0.0076719577*G3_;
        A[11] = 0.0024691358*G3_;
        A[12] = 0.01287478*G2_;
        A[13] = 0.0;
        A[14] = -0.0012786596*G2_;
        A[15] = 0.0;
        A[16] = 0.0;
        A[17] = 0.0;
        A[18] = 0.013051146*G2_;
        A[19] = -0.0076719577*G2_;
        A[20] = 0.0024691358*G2_;
        A[21] = 0.0;
        A[22] = 0.0;
        A[23] = 0.0;
        A[24] = -0.0012786596*G3_;
        A[25] = 0.01287478*G3_;
        A[26] = 0.0;
        A[27] = 0.0;
        A[28] = 0.0;
        A[29] = 0.0;
        A[30] = 0.0;
        A[31] = 0.0;
        A[32] = 0.0;
        A[33] = 0.0024691358*G3_;
        A[34] = -0.0076719577*G3_;
        A[35] = 0.013051146*G3_;
        A[36] = -0.0012786596*G2_;
        A[37] = 0.0;
        A[38] = 0.01287478*G2_;
        A[39] = 0.0;
        A[40] = 0.0;
        A[41] = 0.0;
        A[42] = 0.0024691358*G2_;
        A[43] = -0.0076719577*G2_;
        A[44] = 0.013051146*G2_;
        A[45] = 0.0;
        A[46] = 0.0;
        A[47] = 0.0;
        A[48] = 0.0;
        A[49] = 0.0;
        A[50] = 0.0;
        A[51] = 0.0;
        A[52] = 0.0;
        A[53] = 0.0;
        A[54] = 0.0;
        A[55] = 0.0;
        A[56] = 0.0;
        A[57] = 0.0;
        A[58] = 0.0;
        A[59] = 0.0;
        A[60] = 0.0;
        A[61] = 0.0;
        A[62] = 0.0;
        A[63] = 0.0;
        A[64] = 0.0;
        A[65] = 0.0;
        A[66] = 0.0;
        A[67] = 0.0;
        A[68] = 0.0;
        A[69] = 0.0;
        A[70] = 0.0;
        A[71] = 0.0;
        A[72] = 0.0;
        A[73] = 0.0;
        A[74] = 0.0;
        A[75] = 0.0;
        A[76] = 0.0;
        A[77] = 0.0;
        A[78] = 0.0;
        A[79] = 0.0;
        A[80] = 0.0;
        A[81] = 0.0;
        A[82] = 0.0;
        A[83] = 0.0;
        A[84] = 0.0;
        A[85] = 0.0;
        A[86] = 0.0;
        A[87] = 0.0;
        A[88] = 0.0;
        A[89] = 0.0;
        A[90] = 0.0;
        A[91] = 0.0;
        A[92] = 0.0;
        A[93] = 0.0;
        A[94] = 0.0;
        A[95] = 0.0;
        A[96] = 0.0;
        A[97] = 0.0;
        A[98] = 0.0;
        A[99] = 0.0;
        A[100] = 0.0;
        A[101] = 0.0;
        A[102] = 0.0;
        A[103] = 0.0;
        A[104] = 0.0;
        A[105] = 0.0;
        A[106] = 0.0;
        A[107] = 0.0;
        A[108] = 0.0;
        A[109] = 0.0;
        A[110] = 0.0;
        A[111] = 0.0;
        A[112] = 0.0;
        A[113] = 0.0;
        A[114] = 0.0;
        A[115] = 0.0;
        A[116] = 0.0;
        A[117] = 0.0;
        A[118] = 0.0;
        A[119] = 0.0;
        A[120] = 0.0;
        A[121] = 0.0;
        A[122] = 0.0;
        A[123] = 0.0;
        A[124] = 0.0;
        A[125] = 0.0;
        A[126] = 0.0;
        A[127] = 0.0;
        A[128] = 0.0;
        A[129] = 0.0;
        A[130] = 0.0;
        A[131] = 0.0;
        A[132] = 0.0;
        A[133] = 0.0;
        A[134] = 0.0;
        A[135] = 0.0;
        A[136] = 0.0;
        A[137] = 0.0;
        A[138] = 0.0;
        A[139] = 0.0;
        A[140] = 0.0;
        A[141] = 0.0;
        A[142] = 0.0;
        A[143] = 0.0;
        A[144] = 0.0;
        A[145] = 0.0;
        A[146] = 0.0;
        A[147] = 0.0;
        A[148] = 0.0;
        A[149] = 0.0;
        A[150] = 0.0;
        A[151] = 0.0;
        A[152] = 0.0;
        A[153] = 0.0;
        A[154] = 0.0;
        A[155] = 0.0;
        A[156] = 0.0;
        A[157] = 0.0;
        A[158] = 0.0;
        A[159] = 0.0;
        A[160] = 0.0;
        A[161] = 0.0;
        A[162] = 0.0;
        A[163] = 0.0;
        A[164] = 0.0;
        A[165] = 0.0;
        A[166] = 0.0;
        A[167] = 0.0;
        A[168] = 0.0;
        A[169] = 0.0;
        A[170] = 0.0;
        A[171] = 0.0;
        A[172] = 0.0;
        A[173] = 0.0;
        A[174] = 0.0;
        A[175] = 0.0;
        A[176] = 0.0;
        A[177] = 0.0;
        A[178] = 0.0;
        A[179] = 0.0;
        A[180] = 0.0;
        A[181] = 0.0;
        A[182] = 0.0;
        A[183] = 0.0;
        A[184] = 0.0;
        A[185] = 0.0;
        A[186] = 0.0;
        A[187] = 0.0;
        A[188] = 0.0;
        A[189] = 0.0;
        A[190] = 0.0;
        A[191] = 0.0;
        A[192] = 0.0;
        A[193] = 0.0;
        A[194] = 0.0;
        A[195] = 0.0;
        A[196] = 0.0;
        A[197] = 0.0;
        A[198] = 0.0;
        A[199] = 0.0;
        A[200] = 0.0;
        A[201] = 0.0;
        A[202] = 0.0;
        A[203] = 0.0;
        A[204] = 0.0;
        A[205] = 0.0;
        A[206] = 0.0;
        A[207] = 0.0;
        A[208] = 0.0;
        A[209] = 0.0;
        A[210] = 0.0;
        A[211] = 0.0;
        A[212] = 0.0;
        A[213] = 0.0;
        A[214] = 0.0;
        A[215] = 0.0;
        A[216] = 0.013051146*G3_;
        A[217] = 0.0024691358*G3_;
        A[218] = 0.0;
        A[219] = 0.0;
        A[220] = 0.0;
        A[221] = 0.0;
        A[222] = 0.0;
        A[223] = 0.0;
        A[224] = 0.0;
        A[225] = 0.079012346*G3_;
        A[226] = -0.016931217*G3_;
        A[227] = 0.011287478*G3_;
        A[228] = 0.013051146*G2_;
        A[229] = 0.0;
        A[230] = 0.0024691358*G2_;
        A[231] = 0.0;
        A[232] = 0.0;
        A[233] = 0.0;
        A[234] = 0.079012346*G2_;
        A[235] = -0.016931217*G2_;
        A[236] = 0.011287478*G2_;
        A[237] = 0.0;
        A[238] = 0.0;
        A[239] = 0.0;
        A[240] = -0.0076719577*G3_;
        A[241] = -0.0076719577*G3_;
        A[242] = 0.0;
        A[243] = 0.0;
        A[244] = 0.0;
        A[245] = 0.0;
        A[246] = 0.0;
        A[247] = 0.0;
        A[248] = 0.0;
        A[249] = -0.016931217*G3_;
        A[250] = 0.082539683*G3_;
        A[251] = -0.016931217*G3_;
        A[252] = -0.0076719577*G2_;
        A[253] = 0.0;
        A[254] = -0.0076719577*G2_;
        A[255] = 0.0;
        A[256] = 0.0;
        A[257] = 0.0;
        A[258] = -0.016931217*G2_;
        A[259] = 0.082539683*G2_;
        A[260] = -0.016931217*G2_;
        A[261] = 0.0;
        A[262] = 0.0;
        A[263] = 0.0;
        A[264] = 0.0024691358*G3_;
        A[265] = 0.013051146*G3_;
        A[266] = 0.0;
        A[267] = 0.0;
        A[268] = 0.0;
        A[269] = 0.0;
        A[270] = 0.0;
        A[271] = 0.0;
        A[272] = 0.0;
        A[273] = 0.011287478*G3_;
        A[274] = -0.016931217*G3_;
        A[275] = 0.079012346*G3_;
        A[276] = 0.0024691358*G2_;
        A[277] = 0.0;
        A[278] = 0.013051146*G2_;
        A[279] = 0.0;
        A[280] = 0.0;
        A[281] = 0.0;
        A[282] = 0.011287478*G2_;
        A[283] = -0.016931217*G2_;
        A[284] = 0.079012346*G2_;
        A[285] = 0.0;
        A[286] = 0.0;
        A[287] = 0.0;
        A[288] = 0.01287478*G1_;
        A[289] = -0.0012786596*G1_;
        A[290] = 0.0;
        A[291] = 0.0;
        A[292] = 0.0;
        A[293] = 0.0;
        A[294] = 0.0;
        A[295] = 0.0;
        A[296] = 0.0;
        A[297] = 0.013051146*G1_;
        A[298] = -0.0076719577*G1_;
        A[299] = 0.0024691358*G1_;
        A[300] = 0.01287478*G0_;
        A[301] = 0.0;
        A[302] = -0.0012786596*G0_;
        A[303] = 0.0;
        A[304] = 0.0;
        A[305] = 0.0;
        A[306] = 0.013051146*G0_;
        A[307] = -0.0076719577*G0_;
        A[308] = 0.0024691358*G0_;
        A[309] = 0.0;
        A[310] = 0.0;
        A[311] = 0.0;
        A[312] = 0.0;
        A[313] = 0.0;
        A[314] = 0.0;
        A[315] = 0.0;
        A[316] = 0.0;
        A[317] = 0.0;
        A[318] = 0.0;
        A[319] = 0.0;
        A[320] = 0.0;
        A[321] = 0.0;
        A[322] = 0.0;
        A[323] = 0.0;
        A[324] = 0.0;
        A[325] = 0.0;
        A[326] = 0.0;
        A[327] = 0.0;
        A[328] = 0.0;
        A[329] = 0.0;
        A[330] = 0.0;
        A[331] = 0.0;
        A[332] = 0.0;
        A[333] = 0.0;
        A[334] = 0.0;
        A[335] = 0.0;
        A[336] = -0.0012786596*G1_;
        A[337] = 0.01287478*G1_;
        A[338] = 0.0;
        A[339] = 0.0;
        A[340] = 0.0;
        A[341] = 0.0;
        A[342] = 0.0;
        A[343] = 0.0;
        A[344] = 0.0;
        A[345] = 0.0024691358*G1_;
        A[346] = -0.0076719577*G1_;
        A[347] = 0.013051146*G1_;
        A[348] = -0.0012786596*G0_;
        A[349] = 0.0;
        A[350] = 0.01287478*G0_;
        A[351] = 0.0;
        A[352] = 0.0;
        A[353] = 0.0;
        A[354] = 0.0024691358*G0_;
        A[355] = -0.0076719577*G0_;
        A[356] = 0.013051146*G0_;
        A[357] = 0.0;
        A[358] = 0.0;
        A[359] = 0.0;
        A[360] = 0.0;
        A[361] = 0.0;
        A[362] = 0.0;
        A[363] = 0.0;
        A[364] = 0.0;
        A[365] = 0.0;
        A[366] = 0.0;
        A[367] = 0.0;
        A[368] = 0.0;
        A[369] = 0.0;
        A[370] = 0.0;
        A[371] = 0.0;
        A[372] = 0.0;
        A[373] = 0.0;
        A[374] = 0.0;
        A[375] = 0.0;
        A[376] = 0.0;
        A[377] = 0.0;
        A[378] = 0.0;
        A[379] = 0.0;
        A[380] = 0.0;
        A[381] = 0.0;
        A[382] = 0.0;
        A[383] = 0.0;
        A[384] = 0.0;
        A[385] = 0.0;
        A[386] = 0.0;
        A[387] = 0.0;
        A[388] = 0.0;
        A[389] = 0.0;
        A[390] = 0.0;
        A[391] = 0.0;
        A[392] = 0.0;
        A[393] = 0.0;
        A[394] = 0.0;
        A[395] = 0.0;
        A[396] = 0.0;
        A[397] = 0.0;
        A[398] = 0.0;
        A[399] = 0.0;
        A[400] = 0.0;
        A[401] = 0.0;
        A[402] = 0.0;
        A[403] = 0.0;
        A[404] = 0.0;
        A[405] = 0.0;
        A[406] = 0.0;
        A[407] = 0.0;
        A[408] = 0.0;
        A[409] = 0.0;
        A[410] = 0.0;
        A[411] = 0.0;
        A[412] = 0.0;
        A[413] = 0.0;
        A[414] = 0.0;
        A[415] = 0.0;
        A[416] = 0.0;
        A[417] = 0.0;
        A[418] = 0.0;
        A[419] = 0.0;
        A[420] = 0.0;
        A[421] = 0.0;
        A[422] = 0.0;
        A[423] = 0.0;
        A[424] = 0.0;
        A[425] = 0.0;
        A[426] = 0.0;
        A[427] = 0.0;
        A[428] = 0.0;
        A[429] = 0.0;
        A[430] = 0.0;
        A[431] = 0.0;
        A[432] = 0.013051146*G1_;
        A[433] = 0.0024691358*G1_;
        A[434] = 0.0;
        A[435] = 0.0;
        A[436] = 0.0;
        A[437] = 0.0;
        A[438] = 0.0;
        A[439] = 0.0;
        A[440] = 0.0;
        A[441] = 0.079012346*G1_;
        A[442] = -0.016931217*G1_;
        A[443] = 0.011287478*G1_;
        A[444] = 0.013051146*G0_;
        A[445] = 0.0;
        A[446] = 0.0024691358*G0_;
        A[447] = 0.0;
        A[448] = 0.0;
        A[449] = 0.0;
        A[450] = 0.079012346*G0_;
        A[451] = -0.016931217*G0_;
        A[452] = 0.011287478*G0_;
        A[453] = 0.0;
        A[454] = 0.0;
        A[455] = 0.0;
        A[456] = -0.0076719577*G1_;
        A[457] = -0.0076719577*G1_;
        A[458] = 0.0;
        A[459] = 0.0;
        A[460] = 0.0;
        A[461] = 0.0;
        A[462] = 0.0;
        A[463] = 0.0;
        A[464] = 0.0;
        A[465] = -0.016931217*G1_;
        A[466] = 0.082539683*G1_;
        A[467] = -0.016931217*G1_;
        A[468] = -0.0076719577*G0_;
        A[469] = 0.0;
        A[470] = -0.0076719577*G0_;
        A[471] = 0.0;
        A[472] = 0.0;
        A[473] = 0.0;
        A[474] = -0.016931217*G0_;
        A[475] = 0.082539683*G0_;
        A[476] = -0.016931217*G0_;
        A[477] = 0.0;
        A[478] = 0.0;
        A[479] = 0.0;
        A[480] = 0.0024691358*G1_;
        A[481] = 0.013051146*G1_;
        A[482] = 0.0;
        A[483] = 0.0;
        A[484] = 0.0;
        A[485] = 0.0;
        A[486] = 0.0;
        A[487] = 0.0;
        A[488] = 0.0;
        A[489] = 0.011287478*G1_;
        A[490] = -0.016931217*G1_;
        A[491] = 0.079012346*G1_;
        A[492] = 0.0024691358*G0_;
        A[493] = 0.0;
        A[494] = 0.013051146*G0_;
        A[495] = 0.0;
        A[496] = 0.0;
        A[497] = 0.0;
        A[498] = 0.011287478*G0_;
        A[499] = -0.016931217*G0_;
        A[500] = 0.079012346*G0_;
        A[501] = 0.0;
        A[502] = 0.0;
        A[503] = 0.0;
        A[504] = 0.0;
        A[505] = 0.0;
        A[506] = 0.0;
        A[507] = 0.0;
        A[508] = 0.0;
        A[509] = 0.0;
        A[510] = 0.0;
        A[511] = 0.0;
        A[512] = 0.0;
        A[513] = 0.0;
        A[514] = 0.0;
        A[515] = 0.0;
        A[516] = 0.0;
        A[517] = 0.0;
        A[518] = 0.0;
        A[519] = 0.0;
        A[520] = 0.0;
        A[521] = 0.0;
        A[522] = 0.0;
        A[523] = 0.0;
        A[524] = 0.0;
        A[525] = 0.0;
        A[526] = 0.0;
        A[527] = 0.0;
        A[528] = 0.0;
        A[529] = 0.0;
        A[530] = 0.0;
        A[531] = 0.0;
        A[532] = 0.0;
        A[533] = 0.0;
        A[534] = 0.0;
        A[535] = 0.0;
        A[536] = 0.0;
        A[537] = 0.0;
        A[538] = 0.0;
        A[539] = 0.0;
        A[540] = 0.0;
        A[541] = 0.0;
        A[542] = 0.0;
        A[543] = 0.0;
        A[544] = 0.0;
        A[545] = 0.0;
        A[546] = 0.0;
        A[547] = 0.0;
        A[548] = 0.0;
        A[549] = 0.0;
        A[550] = 0.0;
        A[551] = 0.0;
        A[552] = 0.0;
        A[553] = 0.0;
        A[554] = 0.0;
        A[555] = 0.0;
        A[556] = 0.0;
        A[557] = 0.0;
        A[558] = 0.0;
        A[559] = 0.0;
        A[560] = 0.0;
        A[561] = 0.0;
        A[562] = 0.0;
        A[563] = 0.0;
        A[564] = 0.0;
        A[565] = 0.0;
        A[566] = 0.0;
        A[567] = 0.0;
        A[568] = 0.0;
        A[569] = 0.0;
        A[570] = 0.0;
        A[571] = 0.0;
        A[572] = 0.0;
        A[573] = 0.0;
        A[574] = 0.0;
        A[575] = 0.0;
          break;
        }
      case 2:
        {
          A[0] = 0.01287478*G3_;
        A[1] = -0.0012786596*G3_;
        A[2] = 0.0;
        A[3] = 0.0;
        A[4] = 0.0;
        A[5] = 0.0;
        A[6] = 0.0;
        A[7] = 0.0;
        A[8] = 0.0;
        A[9] = 0.013051146*G3_;
        A[10] = -0.0076719577*G3_;
        A[11] = 0.0024691358*G3_;
        A[12] = 0.01287478*G2_;
        A[13] = -0.0012786596*G2_;
        A[14] = 0.0;
        A[15] = 0.0;
        A[16] = 0.0;
        A[17] = 0.0;
        A[18] = 0.0;
        A[19] = 0.0;
        A[20] = 0.0;
        A[21] = 0.013051146*G2_;
        A[22] = -0.0076719577*G2_;
        A[23] = 0.0024691358*G2_;
        A[24] = -0.0012786596*G3_;
        A[25] = 0.01287478*G3_;
        A[26] = 0.0;
        A[27] = 0.0;
        A[28] = 0.0;
        A[29] = 0.0;
        A[30] = 0.0;
        A[31] = 0.0;
        A[32] = 0.0;
        A[33] = 0.0024691358*G3_;
        A[34] = -0.0076719577*G3_;
        A[35] = 0.013051146*G3_;
        A[36] = -0.0012786596*G2_;
        A[37] = 0.01287478*G2_;
        A[38] = 0.0;
        A[39] = 0.0;
        A[40] = 0.0;
        A[41] = 0.0;
        A[42] = 0.0;
        A[43] = 0.0;
        A[44] = 0.0;
        A[45] = 0.0024691358*G2_;
        A[46] = -0.0076719577*G2_;
        A[47] = 0.013051146*G2_;
        A[48] = 0.0;
        A[49] = 0.0;
        A[50] = 0.0;
        A[51] = 0.0;
        A[52] = 0.0;
        A[53] = 0.0;
        A[54] = 0.0;
        A[55] = 0.0;
        A[56] = 0.0;
        A[57] = 0.0;
        A[58] = 0.0;
        A[59] = 0.0;
        A[60] = 0.0;
        A[61] = 0.0;
        A[62] = 0.0;
        A[63] = 0.0;
        A[64] = 0.0;
        A[65] = 0.0;
        A[66] = 0.0;
        A[67] = 0.0;
        A[68] = 0.0;
        A[69] = 0.0;
        A[70] = 0.0;
        A[71] = 0.0;
        A[72] = 0.0;
        A[73] = 0.0;
        A[74] = 0.0;
        A[75] = 0.0;
        A[76] = 0.0;
        A[77] = 0.0;
        A[78] = 0.0;
        A[79] = 0.0;
        A[80] = 0.0;
        A[81] = 0.0;
        A[82] = 0.0;
        A[83] = 0.0;
        A[84] = 0.0;
        A[85] = 0.0;
        A[86] = 0.0;
        A[87] = 0.0;
        A[88] = 0.0;
        A[89] = 0.0;
        A[90] = 0.0;
        A[91] = 0.0;
        A[92] = 0.0;
        A[93] = 0.0;
        A[94] = 0.0;
        A[95] = 0.0;
        A[96] = 0.0;
        A[97] = 0.0;
        A[98] = 0.0;
        A[99] = 0.0;
        A[100] = 0.0;
        A[101] = 0.0;
        A[102] = 0.0;
        A[103] = 0.0;
        A[104] = 0.0;
        A[105] = 0.0;
        A[106] = 0.0;
        A[107] = 0.0;
        A[108] = 0.0;
        A[109] = 0.0;
        A[110] = 0.0;
        A[111] = 0.0;
        A[112] = 0.0;
        A[113] = 0.0;
        A[114] = 0.0;
        A[115] = 0.0;
        A[116] = 0.0;
        A[117] = 0.0;
        A[118] = 0.0;
        A[119] = 0.0;
        A[120] = 0.0;
        A[121] = 0.0;
        A[122] = 0.0;
        A[123] = 0.0;
        A[124] = 0.0;
        A[125] = 0.0;
        A[126] = 0.0;
        A[127] = 0.0;
        A[128] = 0.0;
        A[129] = 0.0;
        A[130] = 0.0;
        A[131] = 0.0;
        A[132] = 0.0;
        A[133] = 0.0;
        A[134] = 0.0;
        A[135] = 0.0;
        A[136] = 0.0;
        A[137] = 0.0;
        A[138] = 0.0;
        A[139] = 0.0;
        A[140] = 0.0;
        A[141] = 0.0;
        A[142] = 0.0;
        A[143] = 0.0;
        A[144] = 0.0;
        A[145] = 0.0;
        A[146] = 0.0;
        A[147] = 0.0;
        A[148] = 0.0;
        A[149] = 0.0;
        A[150] = 0.0;
        A[151] = 0.0;
        A[152] = 0.0;
        A[153] = 0.0;
        A[154] = 0.0;
        A[155] = 0.0;
        A[156] = 0.0;
        A[157] = 0.0;
        A[158] = 0.0;
        A[159] = 0.0;
        A[160] = 0.0;
        A[161] = 0.0;
        A[162] = 0.0;
        A[163] = 0.0;
        A[164] = 0.0;
        A[165] = 0.0;
        A[166] = 0.0;
        A[167] = 0.0;
        A[168] = 0.0;
        A[169] = 0.0;
        A[170] = 0.0;
        A[171] = 0.0;
        A[172] = 0.0;
        A[173] = 0.0;
        A[174] = 0.0;
        A[175] = 0.0;
        A[176] = 0.0;
        A[177] = 0.0;
        A[178] = 0.0;
        A[179] = 0.0;
        A[180] = 0.0;
        A[181] = 0.0;
        A[182] = 0.0;
        A[183] = 0.0;
        A[184] = 0.0;
        A[185] = 0.0;
        A[186] = 0.0;
        A[187] = 0.0;
        A[188] = 0.0;
        A[189] = 0.0;
        A[190] = 0.0;
        A[191] = 0.0;
        A[192] = 0.0;
        A[193] = 0.0;
        A[194] = 0.0;
        A[195] = 0.0;
        A[196] = 0.0;
        A[197] = 0.0;
        A[198] = 0.0;
        A[199] = 0.0;
        A[200] = 0.0;
        A[201] = 0.0;
        A[202] = 0.0;
        A[203] = 0.0;
        A[204] = 0.0;
        A[205] = 0.0;
        A[206] = 0.0;
        A[207] = 0.0;
        A[208] = 0.0;
        A[209] = 0.0;
        A[210] = 0.0;
        A[211] = 0.0;
        A[212] = 0.0;
        A[213] = 0.0;
        A[214] = 0.0;
        A[215] = 0.0;
        A[216] = 0.013051146*G3_;
        A[217] = 0.0024691358*G3_;
        A[218] = 0.0;
        A[219] = 0.0;
        A[220] = 0.0;
        A[221] = 0.0;
        A[222] = 0.0;
        A[223] = 0.0;
        A[224] = 0.0;
        A[225] = 0.079012346*G3_;
        A[226] = -0.016931217*G3_;
        A[227] = 0.011287478*G3_;
        A[228] = 0.013051146*G2_;
        A[229] = 0.0024691358*G2_;
        A[230] = 0.0;
        A[231] = 0.0;
        A[232] = 0.0;
        A[233] = 0.0;
        A[234] = 0.0;
        A[235] = 0.0;
        A[236] = 0.0;
        A[237] = 0.079012346*G2_;
        A[238] = -0.016931217*G2_;
        A[239] = 0.011287478*G2_;
        A[240] = -0.0076719577*G3_;
        A[241] = -0.0076719577*G3_;
        A[242] = 0.0;
        A[243] = 0.0;
        A[244] = 0.0;
        A[245] = 0.0;
        A[246] = 0.0;
        A[247] = 0.0;
        A[248] = 0.0;
        A[249] = -0.016931217*G3_;
        A[250] = 0.082539683*G3_;
        A[251] = -0.016931217*G3_;
        A[252] = -0.0076719577*G2_;
        A[253] = -0.0076719577*G2_;
        A[254] = 0.0;
        A[255] = 0.0;
        A[256] = 0.0;
        A[257] = 0.0;
        A[258] = 0.0;
        A[259] = 0.0;
        A[260] = 0.0;
        A[261] = -0.016931217*G2_;
        A[262] = 0.082539683*G2_;
        A[263] = -0.016931217*G2_;
        A[264] = 0.0024691358*G3_;
        A[265] = 0.013051146*G3_;
        A[266] = 0.0;
        A[267] = 0.0;
        A[268] = 0.0;
        A[269] = 0.0;
        A[270] = 0.0;
        A[271] = 0.0;
        A[272] = 0.0;
        A[273] = 0.011287478*G3_;
        A[274] = -0.016931217*G3_;
        A[275] = 0.079012346*G3_;
        A[276] = 0.0024691358*G2_;
        A[277] = 0.013051146*G2_;
        A[278] = 0.0;
        A[279] = 0.0;
        A[280] = 0.0;
        A[281] = 0.0;
        A[282] = 0.0;
        A[283] = 0.0;
        A[284] = 0.0;
        A[285] = 0.011287478*G2_;
        A[286] = -0.016931217*G2_;
        A[287] = 0.079012346*G2_;
        A[288] = 0.01287478*G1_;
        A[289] = -0.0012786596*G1_;
        A[290] = 0.0;
        A[291] = 0.0;
        A[292] = 0.0;
        A[293] = 0.0;
        A[294] = 0.0;
        A[295] = 0.0;
        A[296] = 0.0;
        A[297] = 0.013051146*G1_;
        A[298] = -0.0076719577*G1_;
        A[299] = 0.0024691358*G1_;
        A[300] = 0.01287478*G0_;
        A[301] = -0.0012786596*G0_;
        A[302] = 0.0;
        A[303] = 0.0;
        A[304] = 0.0;
        A[305] = 0.0;
        A[306] = 0.0;
        A[307] = 0.0;
        A[308] = 0.0;
        A[309] = 0.013051146*G0_;
        A[310] = -0.0076719577*G0_;
        A[311] = 0.0024691358*G0_;
        A[312] = -0.0012786596*G1_;
        A[313] = 0.01287478*G1_;
        A[314] = 0.0;
        A[315] = 0.0;
        A[316] = 0.0;
        A[317] = 0.0;
        A[318] = 0.0;
        A[319] = 0.0;
        A[320] = 0.0;
        A[321] = 0.0024691358*G1_;
        A[322] = -0.0076719577*G1_;
        A[323] = 0.013051146*G1_;
        A[324] = -0.0012786596*G0_;
        A[325] = 0.01287478*G0_;
        A[326] = 0.0;
        A[327] = 0.0;
        A[328] = 0.0;
        A[329] = 0.0;
        A[330] = 0.0;
        A[331] = 0.0;
        A[332] = 0.0;
        A[333] = 0.0024691358*G0_;
        A[334] = -0.0076719577*G0_;
        A[335] = 0.013051146*G0_;
        A[336] = 0.0;
        A[337] = 0.0;
        A[338] = 0.0;
        A[339] = 0.0;
        A[340] = 0.0;
        A[341] = 0.0;
        A[342] = 0.0;
        A[343] = 0.0;
        A[344] = 0.0;
        A[345] = 0.0;
        A[346] = 0.0;
        A[347] = 0.0;
        A[348] = 0.0;
        A[349] = 0.0;
        A[350] = 0.0;
        A[351] = 0.0;
        A[352] = 0.0;
        A[353] = 0.0;
        A[354] = 0.0;
        A[355] = 0.0;
        A[356] = 0.0;
        A[357] = 0.0;
        A[358] = 0.0;
        A[359] = 0.0;
        A[360] = 0.0;
        A[361] = 0.0;
        A[362] = 0.0;
        A[363] = 0.0;
        A[364] = 0.0;
        A[365] = 0.0;
        A[366] = 0.0;
        A[367] = 0.0;
        A[368] = 0.0;
        A[369] = 0.0;
        A[370] = 0.0;
        A[371] = 0.0;
        A[372] = 0.0;
        A[373] = 0.0;
        A[374] = 0.0;
        A[375] = 0.0;
        A[376] = 0.0;
        A[377] = 0.0;
        A[378] = 0.0;
        A[379] = 0.0;
        A[380] = 0.0;
        A[381] = 0.0;
        A[382] = 0.0;
        A[383] = 0.0;
        A[384] = 0.0;
        A[385] = 0.0;
        A[386] = 0.0;
        A[387] = 0.0;
        A[388] = 0.0;
        A[389] = 0.0;
        A[390] = 0.0;
        A[391] = 0.0;
        A[392] = 0.0;
        A[393] = 0.0;
        A[394] = 0.0;
        A[395] = 0.0;
        A[396] = 0.0;
        A[397] = 0.0;
        A[398] = 0.0;
        A[399] = 0.0;
        A[400] = 0.0;
        A[401] = 0.0;
        A[402] = 0.0;
        A[403] = 0.0;
        A[404] = 0.0;
        A[405] = 0.0;
        A[406] = 0.0;
        A[407] = 0.0;
        A[408] = 0.0;
        A[409] = 0.0;
        A[410] = 0.0;
        A[411] = 0.0;
        A[412] = 0.0;
        A[413] = 0.0;
        A[414] = 0.0;
        A[415] = 0.0;
        A[416] = 0.0;
        A[417] = 0.0;
        A[418] = 0.0;
        A[419] = 0.0;
        A[420] = 0.0;
        A[421] = 0.0;
        A[422] = 0.0;
        A[423] = 0.0;
        A[424] = 0.0;
        A[425] = 0.0;
        A[426] = 0.0;
        A[427] = 0.0;
        A[428] = 0.0;
        A[429] = 0.0;
        A[430] = 0.0;
        A[431] = 0.0;
        A[432] = 0.0;
        A[433] = 0.0;
        A[434] = 0.0;
        A[435] = 0.0;
        A[436] = 0.0;
        A[437] = 0.0;
        A[438] = 0.0;
        A[439] = 0.0;
        A[440] = 0.0;
        A[441] = 0.0;
        A[442] = 0.0;
        A[443] = 0.0;
        A[444] = 0.0;
        A[445] = 0.0;
        A[446] = 0.0;
        A[447] = 0.0;
        A[448] = 0.0;
        A[449] = 0.0;
        A[450] = 0.0;
        A[451] = 0.0;
        A[452] = 0.0;
        A[453] = 0.0;
        A[454] = 0.0;
        A[455] = 0.0;
        A[456] = 0.0;
        A[457] = 0.0;
        A[458] = 0.0;
        A[459] = 0.0;
        A[460] = 0.0;
        A[461] = 0.0;
        A[462] = 0.0;
        A[463] = 0.0;
        A[464] = 0.0;
        A[465] = 0.0;
        A[466] = 0.0;
        A[467] = 0.0;
        A[468] = 0.0;
        A[469] = 0.0;
        A[470] = 0.0;
        A[471] = 0.0;
        A[472] = 0.0;
        A[473] = 0.0;
        A[474] = 0.0;
        A[475] = 0.0;
        A[476] = 0.0;
        A[477] = 0.0;
        A[478] = 0.0;
        A[479] = 0.0;
        A[480] = 0.0;
        A[481] = 0.0;
        A[482] = 0.0;
        A[483] = 0.0;
        A[484] = 0.0;
        A[485] = 0.0;
        A[486] = 0.0;
        A[487] = 0.0;
        A[488] = 0.0;
        A[489] = 0.0;
        A[490] = 0.0;
        A[491] = 0.0;
        A[492] = 0.0;
        A[493] = 0.0;
        A[494] = 0.0;
        A[495] = 0.0;
        A[496] = 0.0;
        A[497] = 0.0;
        A[498] = 0.0;
        A[499] = 0.0;
        A[500] = 0.0;
        A[501] = 0.0;
        A[502] = 0.0;
        A[503] = 0.0;
        A[504] = 0.013051146*G1_;
        A[505] = 0.0024691358*G1_;
        A[506] = 0.0;
        A[507] = 0.0;
        A[508] = 0.0;
        A[509] = 0.0;
        A[510] = 0.0;
        A[511] = 0.0;
        A[512] = 0.0;
        A[513] = 0.079012346*G1_;
        A[514] = -0.016931217*G1_;
        A[515] = 0.011287478*G1_;
        A[516] = 0.013051146*G0_;
        A[517] = 0.0024691358*G0_;
        A[518] = 0.0;
        A[519] = 0.0;
        A[520] = 0.0;
        A[521] = 0.0;
        A[522] = 0.0;
        A[523] = 0.0;
        A[524] = 0.0;
        A[525] = 0.079012346*G0_;
        A[526] = -0.016931217*G0_;
        A[527] = 0.011287478*G0_;
        A[528] = -0.0076719577*G1_;
        A[529] = -0.0076719577*G1_;
        A[530] = 0.0;
        A[531] = 0.0;
        A[532] = 0.0;
        A[533] = 0.0;
        A[534] = 0.0;
        A[535] = 0.0;
        A[536] = 0.0;
        A[537] = -0.016931217*G1_;
        A[538] = 0.082539683*G1_;
        A[539] = -0.016931217*G1_;
        A[540] = -0.0076719577*G0_;
        A[541] = -0.0076719577*G0_;
        A[542] = 0.0;
        A[543] = 0.0;
        A[544] = 0.0;
        A[545] = 0.0;
        A[546] = 0.0;
        A[547] = 0.0;
        A[548] = 0.0;
        A[549] = -0.016931217*G0_;
        A[550] = 0.082539683*G0_;
        A[551] = -0.016931217*G0_;
        A[552] = 0.0024691358*G1_;
        A[553] = 0.013051146*G1_;
        A[554] = 0.0;
        A[555] = 0.0;
        A[556] = 0.0;
        A[557] = 0.0;
        A[558] = 0.0;
        A[559] = 0.0;
        A[560] = 0.0;
        A[561] = 0.011287478*G1_;
        A[562] = -0.016931217*G1_;
        A[563] = 0.079012346*G1_;
        A[564] = 0.0024691358*G0_;
        A[565] = 0.013051146*G0_;
        A[566] = 0.0;
        A[567] = 0.0;
        A[568] = 0.0;
        A[569] = 0.0;
        A[570] = 0.0;
        A[571] = 0.0;
        A[572] = 0.0;
        A[573] = 0.011287478*G0_;
        A[574] = -0.016931217*G0_;
        A[575] = 0.079012346*G0_;
          break;
        }
      }
      
        break;
      }
    }
    
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class restrictedelement_form_0: public ufc::form
{
public:

  /// Constructor
  restrictedelement_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~restrictedelement_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "8aa5d1e48a8fa1bbac945fa2a194daf27b72c71fe203c4e431e3a498f3f047579a6d8e27bc2adc1d1593d7fe765607b14c7e8317f8a1d513c0ff35ca24db6da7";
  }

  /// Return the rank of the global tensor (r)
  virtual std::size_t rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual std::size_t num_coefficients() const
  {
    return 0;
  }

  /// Return the number of cell domains
  virtual std::size_t num_cell_domains() const
  {
    return 0;
  }

  /// Return the number of exterior facet domains
  virtual std::size_t num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual std::size_t num_interior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of point domains
  virtual std::size_t num_point_domains() const
  {
    return 0;
  }

  /// Return whether the form has any cell integrals
  virtual bool has_cell_integrals() const
  {
    return false;
  }

  /// Return whether the form has any exterior facet integrals
  virtual bool has_exterior_facet_integrals() const
  {
    return true;
  }

  /// Return whether the form has any interior facet integrals
  virtual bool has_interior_facet_integrals() const
  {
    return true;
  }

  /// Return whether the form has any point integrals
  virtual bool has_point_integrals() const
  {
    return false;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new restrictedelement_finite_element_0();
        break;
      }
    case 1:
      {
        return new restrictedelement_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new restrictedelement_dofmap_0();
        break;
      }
    case 1:
      {
        return new restrictedelement_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new point integral on sub domain i
  virtual ufc::point_integral* create_point_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new cell integral on everywhere else
  virtual ufc::cell_integral* create_default_cell_integral() const
  {
    return 0;
  }

  /// Create a new exterior facet integral on everywhere else
  virtual ufc::exterior_facet_integral* create_default_exterior_facet_integral() const
  {
    return new restrictedelement_exterior_facet_integral_0_otherwise();
  }

  /// Create a new interior facet integral on everywhere else
  virtual ufc::interior_facet_integral* create_default_interior_facet_integral() const
  {
    return new restrictedelement_interior_facet_integral_0_otherwise();
  }

  /// Create a new point integral on everywhere else
  virtual ufc::point_integral* create_default_point_integral() const
  {
    return 0;
  }

};

#endif
