// This code conforms with the UFC specification version 2.2.0
// and was automatically generated by FFC version 1.2.0.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: True
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      20
//   log_prefix:                     ''
//   optimize:                       False
//   output_dir:                     '.'
//   precision:                      '8'
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'quadrature'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __VECTORLAPLACEGRADCURL_H
#define __VECTORLAPLACEGRADCURL_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class vectorlaplacegradcurl_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  vectorlaplacegradcurl_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vectorlaplacegradcurl_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Domain(Cell('tetrahedron', 3), 'tetrahedron_multiverse', 3, 3), 2, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the topological dimension of the cell shape
  virtual std::size_t topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual std::size_t space_dimension() const
  {
    return 10;
  }

  /// Return the rank of the value space
  virtual std::size_t value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual std::size_t value_dimension(std::size_t i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point x in cell
  virtual void evaluate_basis(std::size_t i,
                              double* values,
                              const double* x,
                              const double* vertex_coordinates,
                              int cell_orientation) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Reset values
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, -0.060858062, -0.035136418, -0.0248452, 0.065060005, 0.050395263, 0.04114756, 0.029095719, 0.023756555, 0.016798421};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, 0.060858062, -0.035136418, -0.0248452, 0.065060005, -0.050395263, -0.04114756, 0.029095719, 0.023756555, 0.016798421};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, 0.0, 0.070272837, -0.0248452, 0.0, 0.0, 0.0, 0.087287156, -0.04751311, 0.016798421};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, 0.0, 0.0, 0.074535599, 0.0, 0.0, 0.0, 0.0, 0.0, 0.10079053};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.0, 0.14054567, 0.099380799, 0.0, 0.0, 0.0, 0.0, 0.11878277, -0.067193684};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.12171612, -0.070272837, 0.099380799, 0.0, 0.0, 0.1028689, 0.0, -0.059391387, -0.067193684};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.12171612, 0.070272837, -0.099380799, 0.0, 0.10079053, -0.02057378, -0.087287156, -0.011878277, 0.016798421};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, -0.12171612, -0.070272837, 0.099380799, 0.0, 0.0, -0.1028689, 0.0, -0.059391387, -0.067193684};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, -0.12171612, 0.070272837, -0.099380799, 0.0, -0.10079053, 0.02057378, -0.087287156, -0.011878277, 0.016798421};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.0, -0.14054567, -0.099380799, -0.13012001, 0.0, 0.0, 0.029095719, 0.023756555, 0.016798421};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point x in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* x,
                                  const double* vertex_coordinates,
                                  int cell_orientation) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis(r, &dof_values, x, vertex_coordinates, cell_orientation);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point x in cell
  virtual void evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double* values,
                                          const double* x,
                                          const double* vertex_coordinates,
                                          int cell_orientation) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, -0.060858062, -0.035136418, -0.0248452, 0.065060005, 0.050395263, 0.04114756, 0.029095719, 0.023756555, 0.016798421};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, 0.060858062, -0.035136418, -0.0248452, 0.065060005, -0.050395263, -0.04114756, 0.029095719, 0.023756555, 0.016798421};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, 0.0, 0.070272837, -0.0248452, 0.0, 0.0, 0.0, 0.087287156, -0.04751311, 0.016798421};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, 0.0, 0.0, 0.074535599, 0.0, 0.0, 0.0, 0.0, 0.0, 0.10079053};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.0, 0.14054567, 0.099380799, 0.0, 0.0, 0.0, 0.0, 0.11878277, -0.067193684};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.12171612, -0.070272837, 0.099380799, 0.0, 0.0, 0.1028689, 0.0, -0.059391387, -0.067193684};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.12171612, 0.070272837, -0.099380799, 0.0, 0.10079053, -0.02057378, -0.087287156, -0.011878277, 0.016798421};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, -0.12171612, -0.070272837, 0.099380799, 0.0, 0.0, -0.1028689, 0.0, -0.059391387, -0.067193684};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, -0.12171612, 0.070272837, -0.099380799, 0.0, -0.10079053, 0.02057378, -0.087287156, -0.011878277, 0.016798421};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.0, -0.14054567, -0.099380799, -0.13012001, 0.0, 0.0, 0.029095719, 0.023756555, 0.016798421};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point x in cell
  virtual void evaluate_basis_derivatives_all(std::size_t n,
                                              double* values,
                                              const double* x,
                                              const double* vertex_coordinates,
                                              int cell_orientation) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, x, vertex_coordinates, cell_orientation);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(std::size_t i,
                              const ufc::function& f,
                              const double* vertex_coordinates,
                              int cell_orientation,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = vertex_coordinates[0];
      y[1] = vertex_coordinates[1];
      y[2] = vertex_coordinates[2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = vertex_coordinates[3];
      y[1] = vertex_coordinates[4];
      y[2] = vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = vertex_coordinates[6];
      y[1] = vertex_coordinates[7];
      y[2] = vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = vertex_coordinates[9];
      y[1] = vertex_coordinates[10];
      y[2] = vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
      y[1] = 0.5*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
      y[2] = 0.5*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[9];
      y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[10];
      y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
      y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
      y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[9];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[10];
      y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
      y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
      y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const double* vertex_coordinates,
                             int cell_orientation,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = vertex_coordinates[0];
    y[1] = vertex_coordinates[1];
    y[2] = vertex_coordinates[2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = vertex_coordinates[3];
    y[1] = vertex_coordinates[4];
    y[2] = vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = vertex_coordinates[6];
    y[1] = vertex_coordinates[7];
    y[2] = vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = vertex_coordinates[9];
    y[1] = vertex_coordinates[10];
    y[2] = vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
    y[1] = 0.5*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
    y[2] = 0.5*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[9];
    y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[10];
    y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
    y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
    y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[9];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[10];
    y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
    y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
    y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const double* vertex_coordinates,
                                         int cell_orientation,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
    vertex_values[3] = dof_values[3];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    std::cerr << "*** FFC warning: " << "map_from_reference_cell not yet implemented." << std::endl;
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    std::cerr << "*** FFC warning: " << "map_to_reference_cell not yet implemented." << std::endl;
  }

  /// Return the number of sub elements (for a mixed element)
  virtual std::size_t num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(std::size_t i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new vectorlaplacegradcurl_finite_element_0();
  }

};

/// This class defines the interface for a finite element.

class vectorlaplacegradcurl_finite_element_1: public ufc::finite_element
{
public:

  /// Constructor
  vectorlaplacegradcurl_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vectorlaplacegradcurl_finite_element_1()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "VectorElement('Lagrange', Domain(Cell('tetrahedron', 3), 'tetrahedron_multiverse', 3, 3), 2, 3, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the topological dimension of the cell shape
  virtual std::size_t topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual std::size_t space_dimension() const
  {
    return 30;
  }

  /// Return the rank of the value space
  virtual std::size_t value_rank() const
  {
    return 1;
  }

  /// Return the dimension of the value space for axis i
  virtual std::size_t value_dimension(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return 3;
        break;
      }
    }
    
    return 0;
  }

  /// Evaluate basis function i at given point x in cell
  virtual void evaluate_basis(std::size_t i,
                              double* values,
                              const double* x,
                              const double* vertex_coordinates,
                              int cell_orientation) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Reset values
    values[0] = 0.0;
    values[1] = 0.0;
    values[2] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, -0.060858062, -0.035136418, -0.0248452, 0.065060005, 0.050395263, 0.04114756, 0.029095719, 0.023756555, 0.016798421};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, 0.060858062, -0.035136418, -0.0248452, 0.065060005, -0.050395263, -0.04114756, 0.029095719, 0.023756555, 0.016798421};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, 0.0, 0.070272837, -0.0248452, 0.0, 0.0, 0.0, 0.087287156, -0.04751311, 0.016798421};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, 0.0, 0.0, 0.074535599, 0.0, 0.0, 0.0, 0.0, 0.0, 0.10079053};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.0, 0.14054567, 0.099380799, 0.0, 0.0, 0.0, 0.0, 0.11878277, -0.067193684};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.12171612, -0.070272837, 0.099380799, 0.0, 0.0, 0.1028689, 0.0, -0.059391387, -0.067193684};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.12171612, 0.070272837, -0.099380799, 0.0, 0.10079053, -0.02057378, -0.087287156, -0.011878277, 0.016798421};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, -0.12171612, -0.070272837, 0.099380799, 0.0, 0.0, -0.1028689, 0.0, -0.059391387, -0.067193684};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, -0.12171612, 0.070272837, -0.099380799, 0.0, -0.10079053, 0.02057378, -0.087287156, -0.011878277, 0.016798421};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.0, -0.14054567, -0.099380799, -0.13012001, 0.0, 0.0, 0.029095719, 0.023756555, 0.016798421};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, -0.060858062, -0.035136418, -0.0248452, 0.065060005, 0.050395263, 0.04114756, 0.029095719, 0.023756555, 0.016798421};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, 0.060858062, -0.035136418, -0.0248452, 0.065060005, -0.050395263, -0.04114756, 0.029095719, 0.023756555, 0.016798421};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, 0.0, 0.070272837, -0.0248452, 0.0, 0.0, 0.0, 0.087287156, -0.04751311, 0.016798421};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, 0.0, 0.0, 0.074535599, 0.0, 0.0, 0.0, 0.0, 0.0, 0.10079053};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.0, 0.14054567, 0.099380799, 0.0, 0.0, 0.0, 0.0, 0.11878277, -0.067193684};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 15:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.12171612, -0.070272837, 0.099380799, 0.0, 0.0, 0.1028689, 0.0, -0.059391387, -0.067193684};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 16:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.12171612, 0.070272837, -0.099380799, 0.0, 0.10079053, -0.02057378, -0.087287156, -0.011878277, 0.016798421};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 17:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, -0.12171612, -0.070272837, 0.099380799, 0.0, 0.0, -0.1028689, 0.0, -0.059391387, -0.067193684};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 18:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, -0.12171612, 0.070272837, -0.099380799, 0.0, -0.10079053, 0.02057378, -0.087287156, -0.011878277, 0.016798421};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 19:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.0, -0.14054567, -0.099380799, -0.13012001, 0.0, 0.0, 0.029095719, 0.023756555, 0.016798421};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 20:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, -0.060858062, -0.035136418, -0.0248452, 0.065060005, 0.050395263, 0.04114756, 0.029095719, 0.023756555, 0.016798421};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 21:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, 0.060858062, -0.035136418, -0.0248452, 0.065060005, -0.050395263, -0.04114756, 0.029095719, 0.023756555, 0.016798421};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 22:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, 0.0, 0.070272837, -0.0248452, 0.0, 0.0, 0.0, 0.087287156, -0.04751311, 0.016798421};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 23:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, 0.0, 0.0, 0.074535599, 0.0, 0.0, 0.0, 0.0, 0.0, 0.10079053};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 24:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.0, 0.14054567, 0.099380799, 0.0, 0.0, 0.0, 0.0, 0.11878277, -0.067193684};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 25:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.12171612, -0.070272837, 0.099380799, 0.0, 0.0, 0.1028689, 0.0, -0.059391387, -0.067193684};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 26:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.12171612, 0.070272837, -0.099380799, 0.0, 0.10079053, -0.02057378, -0.087287156, -0.011878277, 0.016798421};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 27:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, -0.12171612, -0.070272837, 0.099380799, 0.0, 0.0, -0.1028689, 0.0, -0.059391387, -0.067193684};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 28:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, -0.12171612, 0.070272837, -0.099380799, 0.0, -0.10079053, 0.02057378, -0.087287156, -0.011878277, 0.016798421};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 29:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.0, -0.14054567, -0.099380799, -0.13012001, 0.0, 0.0, 0.029095719, 0.023756555, 0.016798421};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 10; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point x in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* x,
                                  const double* vertex_coordinates,
                                  int cell_orientation) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values[3] = {0.0, 0.0, 0.0};
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 30; r++)
    {
      evaluate_basis(r, dof_values, x, vertex_coordinates, cell_orientation);
      for (unsigned int s = 0; s < 3; s++)
      {
        values[r*3 + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point x in cell
  virtual void evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double* values,
                                          const double* x,
                                          const double* vertex_coordinates,
                                          int cell_orientation) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 3*num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, -0.060858062, -0.035136418, -0.0248452, 0.065060005, 0.050395263, 0.04114756, 0.029095719, 0.023756555, 0.016798421};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, 0.060858062, -0.035136418, -0.0248452, 0.065060005, -0.050395263, -0.04114756, 0.029095719, 0.023756555, 0.016798421};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, 0.0, 0.070272837, -0.0248452, 0.0, 0.0, 0.0, 0.087287156, -0.04751311, 0.016798421};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, 0.0, 0.0, 0.074535599, 0.0, 0.0, 0.0, 0.0, 0.0, 0.10079053};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.0, 0.14054567, 0.099380799, 0.0, 0.0, 0.0, 0.0, 0.11878277, -0.067193684};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.12171612, -0.070272837, 0.099380799, 0.0, 0.0, 0.1028689, 0.0, -0.059391387, -0.067193684};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.12171612, 0.070272837, -0.099380799, 0.0, 0.10079053, -0.02057378, -0.087287156, -0.011878277, 0.016798421};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, -0.12171612, -0.070272837, 0.099380799, 0.0, 0.0, -0.1028689, 0.0, -0.059391387, -0.067193684};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, -0.12171612, 0.070272837, -0.099380799, 0.0, -0.10079053, 0.02057378, -0.087287156, -0.011878277, 0.016798421};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.0, -0.14054567, -0.099380799, -0.13012001, 0.0, 0.0, 0.029095719, 0.023756555, 0.016798421};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 10:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, -0.060858062, -0.035136418, -0.0248452, 0.065060005, 0.050395263, 0.04114756, 0.029095719, 0.023756555, 0.016798421};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 11:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, 0.060858062, -0.035136418, -0.0248452, 0.065060005, -0.050395263, -0.04114756, 0.029095719, 0.023756555, 0.016798421};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 12:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, 0.0, 0.070272837, -0.0248452, 0.0, 0.0, 0.0, 0.087287156, -0.04751311, 0.016798421};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 13:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, 0.0, 0.0, 0.074535599, 0.0, 0.0, 0.0, 0.0, 0.0, 0.10079053};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 14:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.0, 0.14054567, 0.099380799, 0.0, 0.0, 0.0, 0.0, 0.11878277, -0.067193684};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 15:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.12171612, -0.070272837, 0.099380799, 0.0, 0.0, 0.1028689, 0.0, -0.059391387, -0.067193684};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 16:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.12171612, 0.070272837, -0.099380799, 0.0, 0.10079053, -0.02057378, -0.087287156, -0.011878277, 0.016798421};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 17:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, -0.12171612, -0.070272837, 0.099380799, 0.0, 0.0, -0.1028689, 0.0, -0.059391387, -0.067193684};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 18:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, -0.12171612, 0.070272837, -0.099380799, 0.0, -0.10079053, 0.02057378, -0.087287156, -0.011878277, 0.016798421};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 19:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.0, -0.14054567, -0.099380799, -0.13012001, 0.0, 0.0, 0.029095719, 0.023756555, 0.016798421};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 20:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, -0.060858062, -0.035136418, -0.0248452, 0.065060005, 0.050395263, 0.04114756, 0.029095719, 0.023756555, 0.016798421};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 21:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, 0.060858062, -0.035136418, -0.0248452, 0.065060005, -0.050395263, -0.04114756, 0.029095719, 0.023756555, 0.016798421};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 22:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, 0.0, 0.070272837, -0.0248452, 0.0, 0.0, 0.0, 0.087287156, -0.04751311, 0.016798421};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 23:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {-0.057735027, 0.0, 0.0, 0.074535599, 0.0, 0.0, 0.0, 0.0, 0.0, 0.10079053};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 24:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.0, 0.14054567, 0.099380799, 0.0, 0.0, 0.0, 0.0, 0.11878277, -0.067193684};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 25:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.12171612, -0.070272837, 0.099380799, 0.0, 0.0, 0.1028689, 0.0, -0.059391387, -0.067193684};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 26:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.12171612, 0.070272837, -0.099380799, 0.0, 0.10079053, -0.02057378, -0.087287156, -0.011878277, 0.016798421};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 27:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, -0.12171612, -0.070272837, 0.099380799, 0.0, 0.0, -0.1028689, 0.0, -0.059391387, -0.067193684};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 28:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, -0.12171612, 0.070272837, -0.099380799, 0.0, -0.10079053, 0.02057378, -0.087287156, -0.011878277, 0.016798421};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 29:
      {
        
      // Array of basisvalues
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[7] = (1.6666667*tmp2 + 0.11111111*tmp3)*basisvalues[2] - 0.55555556*tmp4*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[4] *= std::sqrt(26.25);
      
      // Table(s) of coefficients
      static const double coefficients0[10] = \
      {0.23094011, 0.0, -0.14054567, -0.099380799, -0.13012001, 0.0, 0.0, 0.029095719, 0.023756555, 0.016798421};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 11.224972, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.5825757, 0.0, 8.3666003, -1.183216, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.7416574, 0.0, 0.0, 8.694826, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 7.2456884, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 0.0, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.6457513, 0.0, 9.6609178, 0.68313005, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.2403703, 0.0, 0.0, 7.5299402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580399, 5.6124861, -1.0801234, -0.76376262, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.2912878, 1.4491377, 4.1833001, -0.59160798, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.8708287, 7.0992957, 0.0, 4.347413, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228757, 0.0, 3.8643671, -0.34156503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.0801234, 0.0, 7.0992957, 2.5099801, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.8188131, 0.0, 0.0, 8.8741197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point x in cell
  virtual void evaluate_basis_derivatives_all(std::size_t n,
                                              double* values,
                                              const double* x,
                                              const double* vertex_coordinates,
                                              int cell_orientation) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[3*num_derivatives];
    for (unsigned int r = 0; r < 3*num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 30; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, x, vertex_coordinates, cell_orientation);
      for (unsigned int s = 0; s < 3*num_derivatives; s++)
      {
        values[r*3*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(std::size_t i,
                              const ufc::function& f,
                              const double* vertex_coordinates,
                              int cell_orientation,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[3];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = vertex_coordinates[0];
      y[1] = vertex_coordinates[1];
      y[2] = vertex_coordinates[2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = vertex_coordinates[3];
      y[1] = vertex_coordinates[4];
      y[2] = vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = vertex_coordinates[6];
      y[1] = vertex_coordinates[7];
      y[2] = vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = vertex_coordinates[9];
      y[1] = vertex_coordinates[10];
      y[2] = vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
      y[1] = 0.5*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
      y[2] = 0.5*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[9];
      y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[10];
      y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
      y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
      y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[9];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[10];
      y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
      y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
      y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 10:
      {
        y[0] = vertex_coordinates[0];
      y[1] = vertex_coordinates[1];
      y[2] = vertex_coordinates[2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 11:
      {
        y[0] = vertex_coordinates[3];
      y[1] = vertex_coordinates[4];
      y[2] = vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 12:
      {
        y[0] = vertex_coordinates[6];
      y[1] = vertex_coordinates[7];
      y[2] = vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 13:
      {
        y[0] = vertex_coordinates[9];
      y[1] = vertex_coordinates[10];
      y[2] = vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 14:
      {
        y[0] = 0.5*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
      y[1] = 0.5*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
      y[2] = 0.5*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 15:
      {
        y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[9];
      y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[10];
      y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 16:
      {
        y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
      y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
      y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 17:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[9];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[10];
      y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 18:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
      y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 19:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
      y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 20:
      {
        y[0] = vertex_coordinates[0];
      y[1] = vertex_coordinates[1];
      y[2] = vertex_coordinates[2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 21:
      {
        y[0] = vertex_coordinates[3];
      y[1] = vertex_coordinates[4];
      y[2] = vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 22:
      {
        y[0] = vertex_coordinates[6];
      y[1] = vertex_coordinates[7];
      y[2] = vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 23:
      {
        y[0] = vertex_coordinates[9];
      y[1] = vertex_coordinates[10];
      y[2] = vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 24:
      {
        y[0] = 0.5*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
      y[1] = 0.5*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
      y[2] = 0.5*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 25:
      {
        y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[9];
      y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[10];
      y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 26:
      {
        y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
      y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
      y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 27:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[9];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[10];
      y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 28:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
      y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 29:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
      y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const double* vertex_coordinates,
                             int cell_orientation,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[3];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = vertex_coordinates[0];
    y[1] = vertex_coordinates[1];
    y[2] = vertex_coordinates[2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = vertex_coordinates[3];
    y[1] = vertex_coordinates[4];
    y[2] = vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = vertex_coordinates[6];
    y[1] = vertex_coordinates[7];
    y[2] = vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = vertex_coordinates[9];
    y[1] = vertex_coordinates[10];
    y[2] = vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
    y[1] = 0.5*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
    y[2] = 0.5*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[9];
    y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[10];
    y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
    y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
    y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[9];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[10];
    y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
    y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
    y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
    y[0] = vertex_coordinates[0];
    y[1] = vertex_coordinates[1];
    y[2] = vertex_coordinates[2];
    f.evaluate(vals, y, c);
    values[10] = vals[1];
    y[0] = vertex_coordinates[3];
    y[1] = vertex_coordinates[4];
    y[2] = vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[11] = vals[1];
    y[0] = vertex_coordinates[6];
    y[1] = vertex_coordinates[7];
    y[2] = vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[12] = vals[1];
    y[0] = vertex_coordinates[9];
    y[1] = vertex_coordinates[10];
    y[2] = vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[13] = vals[1];
    y[0] = 0.5*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
    y[1] = 0.5*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
    y[2] = 0.5*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[14] = vals[1];
    y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[9];
    y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[10];
    y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[15] = vals[1];
    y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
    y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
    y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[16] = vals[1];
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[9];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[10];
    y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[17] = vals[1];
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
    y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[18] = vals[1];
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
    y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[19] = vals[1];
    y[0] = vertex_coordinates[0];
    y[1] = vertex_coordinates[1];
    y[2] = vertex_coordinates[2];
    f.evaluate(vals, y, c);
    values[20] = vals[2];
    y[0] = vertex_coordinates[3];
    y[1] = vertex_coordinates[4];
    y[2] = vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[21] = vals[2];
    y[0] = vertex_coordinates[6];
    y[1] = vertex_coordinates[7];
    y[2] = vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[22] = vals[2];
    y[0] = vertex_coordinates[9];
    y[1] = vertex_coordinates[10];
    y[2] = vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[23] = vals[2];
    y[0] = 0.5*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
    y[1] = 0.5*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
    y[2] = 0.5*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[24] = vals[2];
    y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[9];
    y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[10];
    y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[25] = vals[2];
    y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
    y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
    y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[26] = vals[2];
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[9];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[10];
    y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[27] = vals[2];
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
    y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[28] = vals[2];
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
    y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[29] = vals[2];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const double* vertex_coordinates,
                                         int cell_orientation,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[3] = dof_values[1];
    vertex_values[6] = dof_values[2];
    vertex_values[9] = dof_values[3];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[10];
    vertex_values[4] = dof_values[11];
    vertex_values[7] = dof_values[12];
    vertex_values[10] = dof_values[13];
    // Evaluate function and change variables
    vertex_values[2] = dof_values[20];
    vertex_values[5] = dof_values[21];
    vertex_values[8] = dof_values[22];
    vertex_values[11] = dof_values[23];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    std::cerr << "*** FFC warning: " << "map_from_reference_cell not yet implemented." << std::endl;
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    std::cerr << "*** FFC warning: " << "map_to_reference_cell not yet implemented." << std::endl;
  }

  /// Return the number of sub elements (for a mixed element)
  virtual std::size_t num_sub_elements() const
  {
    return 3;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new vectorlaplacegradcurl_finite_element_0();
        break;
      }
    case 1:
      {
        return new vectorlaplacegradcurl_finite_element_0();
        break;
      }
    case 2:
      {
        return new vectorlaplacegradcurl_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new vectorlaplacegradcurl_finite_element_1();
  }

};

/// This class defines the interface for a finite element.

class vectorlaplacegradcurl_finite_element_2: public ufc::finite_element
{
public:

  /// Constructor
  vectorlaplacegradcurl_finite_element_2() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vectorlaplacegradcurl_finite_element_2()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Domain(Cell('tetrahedron', 3), 'tetrahedron_multiverse', 3, 3), 1, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the topological dimension of the cell shape
  virtual std::size_t topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual std::size_t space_dimension() const
  {
    return 4;
  }

  /// Return the rank of the value space
  virtual std::size_t value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual std::size_t value_dimension(std::size_t i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point x in cell
  virtual void evaluate_basis(std::size_t i,
                              double* values,
                              const double* x,
                              const double* vertex_coordinates,
                              int cell_orientation) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Reset values
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, -0.18257419, -0.10540926, -0.074535599};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.074535599};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.21081851, -0.074535599};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.0, 0.2236068};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point x in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* x,
                                  const double* vertex_coordinates,
                                  int cell_orientation) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 4; r++)
    {
      evaluate_basis(r, &dof_values, x, vertex_coordinates, cell_orientation);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point x in cell
  virtual void evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double* values,
                                          const double* x,
                                          const double* vertex_coordinates,
                                          int cell_orientation) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, -0.18257419, -0.10540926, -0.074535599};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.074535599};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.21081851, -0.074535599};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.0, 0.2236068};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point x in cell
  virtual void evaluate_basis_derivatives_all(std::size_t n,
                                              double* values,
                                              const double* x,
                                              const double* vertex_coordinates,
                                              int cell_orientation) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 4; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, x, vertex_coordinates, cell_orientation);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(std::size_t i,
                              const ufc::function& f,
                              const double* vertex_coordinates,
                              int cell_orientation,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = vertex_coordinates[0];
      y[1] = vertex_coordinates[1];
      y[2] = vertex_coordinates[2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = vertex_coordinates[3];
      y[1] = vertex_coordinates[4];
      y[2] = vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = vertex_coordinates[6];
      y[1] = vertex_coordinates[7];
      y[2] = vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = vertex_coordinates[9];
      y[1] = vertex_coordinates[10];
      y[2] = vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const double* vertex_coordinates,
                             int cell_orientation,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = vertex_coordinates[0];
    y[1] = vertex_coordinates[1];
    y[2] = vertex_coordinates[2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = vertex_coordinates[3];
    y[1] = vertex_coordinates[4];
    y[2] = vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = vertex_coordinates[6];
    y[1] = vertex_coordinates[7];
    y[2] = vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = vertex_coordinates[9];
    y[1] = vertex_coordinates[10];
    y[2] = vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const double* vertex_coordinates,
                                         int cell_orientation,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
    vertex_values[3] = dof_values[3];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    std::cerr << "*** FFC warning: " << "map_from_reference_cell not yet implemented." << std::endl;
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    std::cerr << "*** FFC warning: " << "map_to_reference_cell not yet implemented." << std::endl;
  }

  /// Return the number of sub elements (for a mixed element)
  virtual std::size_t num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(std::size_t i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new vectorlaplacegradcurl_finite_element_2();
  }

};

/// This class defines the interface for a finite element.

class vectorlaplacegradcurl_finite_element_3: public ufc::finite_element
{
public:

  /// Constructor
  vectorlaplacegradcurl_finite_element_3() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vectorlaplacegradcurl_finite_element_3()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Nedelec 1st kind H(curl)', Domain(Cell('tetrahedron', 3), 'tetrahedron_multiverse', 3, 3), 1, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the topological dimension of the cell shape
  virtual std::size_t topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual std::size_t space_dimension() const
  {
    return 6;
  }

  /// Return the rank of the value space
  virtual std::size_t value_rank() const
  {
    return 1;
  }

  /// Return the dimension of the value space for axis i
  virtual std::size_t value_dimension(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return 3;
        break;
      }
    }
    
    return 0;
  }

  /// Evaluate basis function i at given point x in cell
  virtual void evaluate_basis(std::size_t i,
                              double* values,
                              const double* x,
                              const double* vertex_coordinates,
                              int cell_orientation) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Reset values
    values[0] = 0.0;
    values[1] = 0.0;
    values[2] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.0, 0.0, 0.0, 0.0};
      
      static const double coefficients1[4] = \
      {-0.28867513, 0.0, 0.0, -0.2236068};
      
      static const double coefficients2[4] = \
      {0.28867513, 0.0, 0.21081851, -0.074535599};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
        values[2] += coefficients2[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      const double tmp_ref2 = values[2];
      values[0] = (K[0]*tmp_ref0 + K[3]*tmp_ref1 + K[6]*tmp_ref2);
      values[1] = (K[1]*tmp_ref0 + K[4]*tmp_ref1 + K[7]*tmp_ref2);
      values[2] = (K[2]*tmp_ref0 + K[5]*tmp_ref1 + K[8]*tmp_ref2);
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {-0.28867513, 0.0, 0.0, -0.2236068};
      
      static const double coefficients1[4] = \
      {0.0, 0.0, 0.0, 0.0};
      
      static const double coefficients2[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.074535599};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
        values[2] += coefficients2[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      const double tmp_ref2 = values[2];
      values[0] = (K[0]*tmp_ref0 + K[3]*tmp_ref1 + K[6]*tmp_ref2);
      values[1] = (K[1]*tmp_ref0 + K[4]*tmp_ref1 + K[7]*tmp_ref2);
      values[2] = (K[2]*tmp_ref0 + K[5]*tmp_ref1 + K[8]*tmp_ref2);
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {-0.28867513, 0.0, -0.21081851, 0.074535599};
      
      static const double coefficients1[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.074535599};
      
      static const double coefficients2[4] = \
      {0.0, 0.0, 0.0, 0.0};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
        values[2] += coefficients2[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      const double tmp_ref2 = values[2];
      values[0] = (K[0]*tmp_ref0 + K[3]*tmp_ref1 + K[6]*tmp_ref2);
      values[1] = (K[1]*tmp_ref0 + K[4]*tmp_ref1 + K[7]*tmp_ref2);
      values[2] = (K[2]*tmp_ref0 + K[5]*tmp_ref1 + K[8]*tmp_ref2);
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.0, 0.2236068};
      
      static const double coefficients1[4] = \
      {0.28867513, 0.0, 0.0, 0.2236068};
      
      static const double coefficients2[4] = \
      {0.57735027, -0.18257419, -0.10540926, 0.1490712};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
        values[2] += coefficients2[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      const double tmp_ref2 = values[2];
      values[0] = (K[0]*tmp_ref0 + K[3]*tmp_ref1 + K[6]*tmp_ref2);
      values[1] = (K[1]*tmp_ref0 + K[4]*tmp_ref1 + K[7]*tmp_ref2);
      values[2] = (K[2]*tmp_ref0 + K[5]*tmp_ref1 + K[8]*tmp_ref2);
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.21081851, -0.074535599};
      
      static const double coefficients1[4] = \
      {0.57735027, -0.18257419, 0.10540926, -0.1490712};
      
      static const double coefficients2[4] = \
      {0.28867513, 0.0, 0.21081851, -0.074535599};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
        values[2] += coefficients2[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      const double tmp_ref2 = values[2];
      values[0] = (K[0]*tmp_ref0 + K[3]*tmp_ref1 + K[6]*tmp_ref2);
      values[1] = (K[1]*tmp_ref0 + K[4]*tmp_ref1 + K[7]*tmp_ref2);
      values[2] = (K[2]*tmp_ref0 + K[5]*tmp_ref1 + K[8]*tmp_ref2);
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.57735027, 0.0, -0.21081851, -0.1490712};
      
      static const double coefficients1[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.074535599};
      
      static const double coefficients2[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.074535599};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
        values[2] += coefficients2[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      const double tmp_ref2 = values[2];
      values[0] = (K[0]*tmp_ref0 + K[3]*tmp_ref1 + K[6]*tmp_ref2);
      values[1] = (K[1]*tmp_ref0 + K[4]*tmp_ref1 + K[7]*tmp_ref2);
      values[2] = (K[2]*tmp_ref0 + K[5]*tmp_ref1 + K[8]*tmp_ref2);
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point x in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* x,
                                  const double* vertex_coordinates,
                                  int cell_orientation) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values[3] = {0.0, 0.0, 0.0};
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 6; r++)
    {
      evaluate_basis(r, dof_values, x, vertex_coordinates, cell_orientation);
      for (unsigned int s = 0; s < 3; s++)
      {
        values[r*3 + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point x in cell
  virtual void evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double* values,
                                          const double* x,
                                          const double* vertex_coordinates,
                                          int cell_orientation) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 3*num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.0, 0.0, 0.0, 0.0};
      
      static const double coefficients1[4] = \
      {-0.28867513, 0.0, 0.0, -0.2236068};
      
      static const double coefficients2[4] = \
      {0.28867513, 0.0, 0.21081851, -0.074535599};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[3*num_derivatives];
      for (unsigned int r = 0; r < 3*num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare pointer to array of reference derivatives on physical element.
      double *derivatives_p = new double[3*num_derivatives];
      for (unsigned int r = 0; r < 3*num_derivatives; r++)
      {
        derivatives_p[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
            derivatives[2*num_derivatives + r] += coefficients2[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        const double tmp_ref2 = derivatives[2*num_derivatives + r];
        derivatives_p[r] = (K[0]*tmp_ref0 + K[3]*tmp_ref1 + K[6]*tmp_ref2);
        derivatives_p[num_derivatives + r] = (K[1]*tmp_ref0 + K[4]*tmp_ref1 + K[7]*tmp_ref2);
        derivatives_p[2*num_derivatives + r] = (K[2]*tmp_ref0 + K[5]*tmp_ref1 + K[8]*tmp_ref2);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives_p[s];
          values[num_derivatives + r] += transform[r][s]*derivatives_p[num_derivatives + s];
          values[2*num_derivatives + r] += transform[r][s]*derivatives_p[2*num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of reference derivatives on physical element.
      delete [] derivatives_p;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {-0.28867513, 0.0, 0.0, -0.2236068};
      
      static const double coefficients1[4] = \
      {0.0, 0.0, 0.0, 0.0};
      
      static const double coefficients2[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.074535599};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[3*num_derivatives];
      for (unsigned int r = 0; r < 3*num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare pointer to array of reference derivatives on physical element.
      double *derivatives_p = new double[3*num_derivatives];
      for (unsigned int r = 0; r < 3*num_derivatives; r++)
      {
        derivatives_p[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
            derivatives[2*num_derivatives + r] += coefficients2[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        const double tmp_ref2 = derivatives[2*num_derivatives + r];
        derivatives_p[r] = (K[0]*tmp_ref0 + K[3]*tmp_ref1 + K[6]*tmp_ref2);
        derivatives_p[num_derivatives + r] = (K[1]*tmp_ref0 + K[4]*tmp_ref1 + K[7]*tmp_ref2);
        derivatives_p[2*num_derivatives + r] = (K[2]*tmp_ref0 + K[5]*tmp_ref1 + K[8]*tmp_ref2);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives_p[s];
          values[num_derivatives + r] += transform[r][s]*derivatives_p[num_derivatives + s];
          values[2*num_derivatives + r] += transform[r][s]*derivatives_p[2*num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of reference derivatives on physical element.
      delete [] derivatives_p;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {-0.28867513, 0.0, -0.21081851, 0.074535599};
      
      static const double coefficients1[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.074535599};
      
      static const double coefficients2[4] = \
      {0.0, 0.0, 0.0, 0.0};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[3*num_derivatives];
      for (unsigned int r = 0; r < 3*num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare pointer to array of reference derivatives on physical element.
      double *derivatives_p = new double[3*num_derivatives];
      for (unsigned int r = 0; r < 3*num_derivatives; r++)
      {
        derivatives_p[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
            derivatives[2*num_derivatives + r] += coefficients2[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        const double tmp_ref2 = derivatives[2*num_derivatives + r];
        derivatives_p[r] = (K[0]*tmp_ref0 + K[3]*tmp_ref1 + K[6]*tmp_ref2);
        derivatives_p[num_derivatives + r] = (K[1]*tmp_ref0 + K[4]*tmp_ref1 + K[7]*tmp_ref2);
        derivatives_p[2*num_derivatives + r] = (K[2]*tmp_ref0 + K[5]*tmp_ref1 + K[8]*tmp_ref2);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives_p[s];
          values[num_derivatives + r] += transform[r][s]*derivatives_p[num_derivatives + s];
          values[2*num_derivatives + r] += transform[r][s]*derivatives_p[2*num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of reference derivatives on physical element.
      delete [] derivatives_p;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.0, 0.2236068};
      
      static const double coefficients1[4] = \
      {0.28867513, 0.0, 0.0, 0.2236068};
      
      static const double coefficients2[4] = \
      {0.57735027, -0.18257419, -0.10540926, 0.1490712};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[3*num_derivatives];
      for (unsigned int r = 0; r < 3*num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare pointer to array of reference derivatives on physical element.
      double *derivatives_p = new double[3*num_derivatives];
      for (unsigned int r = 0; r < 3*num_derivatives; r++)
      {
        derivatives_p[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
            derivatives[2*num_derivatives + r] += coefficients2[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        const double tmp_ref2 = derivatives[2*num_derivatives + r];
        derivatives_p[r] = (K[0]*tmp_ref0 + K[3]*tmp_ref1 + K[6]*tmp_ref2);
        derivatives_p[num_derivatives + r] = (K[1]*tmp_ref0 + K[4]*tmp_ref1 + K[7]*tmp_ref2);
        derivatives_p[2*num_derivatives + r] = (K[2]*tmp_ref0 + K[5]*tmp_ref1 + K[8]*tmp_ref2);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives_p[s];
          values[num_derivatives + r] += transform[r][s]*derivatives_p[num_derivatives + s];
          values[2*num_derivatives + r] += transform[r][s]*derivatives_p[2*num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of reference derivatives on physical element.
      delete [] derivatives_p;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.21081851, -0.074535599};
      
      static const double coefficients1[4] = \
      {0.57735027, -0.18257419, 0.10540926, -0.1490712};
      
      static const double coefficients2[4] = \
      {0.28867513, 0.0, 0.21081851, -0.074535599};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[3*num_derivatives];
      for (unsigned int r = 0; r < 3*num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare pointer to array of reference derivatives on physical element.
      double *derivatives_p = new double[3*num_derivatives];
      for (unsigned int r = 0; r < 3*num_derivatives; r++)
      {
        derivatives_p[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
            derivatives[2*num_derivatives + r] += coefficients2[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        const double tmp_ref2 = derivatives[2*num_derivatives + r];
        derivatives_p[r] = (K[0]*tmp_ref0 + K[3]*tmp_ref1 + K[6]*tmp_ref2);
        derivatives_p[num_derivatives + r] = (K[1]*tmp_ref0 + K[4]*tmp_ref1 + K[7]*tmp_ref2);
        derivatives_p[2*num_derivatives + r] = (K[2]*tmp_ref0 + K[5]*tmp_ref1 + K[8]*tmp_ref2);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives_p[s];
          values[num_derivatives + r] += transform[r][s]*derivatives_p[num_derivatives + s];
          values[2*num_derivatives + r] += transform[r][s]*derivatives_p[2*num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of reference derivatives on physical element.
      delete [] derivatives_p;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.57735027, 0.0, -0.21081851, -0.1490712};
      
      static const double coefficients1[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.074535599};
      
      static const double coefficients2[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.074535599};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[3*num_derivatives];
      for (unsigned int r = 0; r < 3*num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare pointer to array of reference derivatives on physical element.
      double *derivatives_p = new double[3*num_derivatives];
      for (unsigned int r = 0; r < 3*num_derivatives; r++)
      {
        derivatives_p[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
            derivatives[2*num_derivatives + r] += coefficients2[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        const double tmp_ref2 = derivatives[2*num_derivatives + r];
        derivatives_p[r] = (K[0]*tmp_ref0 + K[3]*tmp_ref1 + K[6]*tmp_ref2);
        derivatives_p[num_derivatives + r] = (K[1]*tmp_ref0 + K[4]*tmp_ref1 + K[7]*tmp_ref2);
        derivatives_p[2*num_derivatives + r] = (K[2]*tmp_ref0 + K[5]*tmp_ref1 + K[8]*tmp_ref2);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives_p[s];
          values[num_derivatives + r] += transform[r][s]*derivatives_p[num_derivatives + s];
          values[2*num_derivatives + r] += transform[r][s]*derivatives_p[2*num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of reference derivatives on physical element.
      delete [] derivatives_p;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point x in cell
  virtual void evaluate_basis_derivatives_all(std::size_t n,
                                              double* values,
                                              const double* x,
                                              const double* vertex_coordinates,
                                              int cell_orientation) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[3*num_derivatives];
    for (unsigned int r = 0; r < 3*num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 6; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, x, vertex_coordinates, cell_orientation);
      for (unsigned int s = 0; s < 3*num_derivatives; s++)
      {
        values[r*3*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(std::size_t i,
                              const ufc::function& f,
                              const double* vertex_coordinates,
                              int cell_orientation,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[3];
    
    // Declare variable for physical coordinates
    double y[3];
    
    double result;
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    switch (i)
    {
    case 0:
      {
        y[0] = 0.5*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
      y[1] = 0.5*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
      y[2] = 0.5*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      result = (-1.0)*(J[1]*vals[0] + J[4]*vals[1] + J[7]*vals[2]) + (J[2]*vals[0] + J[5]*vals[1] + J[8]*vals[2]);
      return result;
        break;
      }
    case 1:
      {
        y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[9];
      y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[10];
      y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      result = (-1.0)*(J[0]*vals[0] + J[3]*vals[1] + J[6]*vals[2]) + (J[2]*vals[0] + J[5]*vals[1] + J[8]*vals[2]);
      return result;
        break;
      }
    case 2:
      {
        y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
      y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
      y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      result = (-1.0)*(J[0]*vals[0] + J[3]*vals[1] + J[6]*vals[2]) + (J[1]*vals[0] + J[4]*vals[1] + J[7]*vals[2]);
      return result;
        break;
      }
    case 3:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[9];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[10];
      y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      result = (J[2]*vals[0] + J[5]*vals[1] + J[8]*vals[2]);
      return result;
        break;
      }
    case 4:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
      y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      result = (J[1]*vals[0] + J[4]*vals[1] + J[7]*vals[2]);
      return result;
        break;
      }
    case 5:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
      y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      result = (J[0]*vals[0] + J[3]*vals[1] + J[6]*vals[2]);
      return result;
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const double* vertex_coordinates,
                             int cell_orientation,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[3];
    
    // Declare variable for physical coordinates
    double y[3];
    
    double result;
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    y[0] = 0.5*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
    y[1] = 0.5*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
    y[2] = 0.5*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    result = (-1.0)*(J[1]*vals[0] + J[4]*vals[1] + J[7]*vals[2]) + (J[2]*vals[0] + J[5]*vals[1] + J[8]*vals[2]);
    values[0] = result;
    y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[9];
    y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[10];
    y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    result = (-1.0)*(J[0]*vals[0] + J[3]*vals[1] + J[6]*vals[2]) + (J[2]*vals[0] + J[5]*vals[1] + J[8]*vals[2]);
    values[1] = result;
    y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
    y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
    y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    result = (-1.0)*(J[0]*vals[0] + J[3]*vals[1] + J[6]*vals[2]) + (J[1]*vals[0] + J[4]*vals[1] + J[7]*vals[2]);
    values[2] = result;
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[9];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[10];
    y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    result = (J[2]*vals[0] + J[5]*vals[1] + J[8]*vals[2]);
    values[3] = result;
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
    y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    result = (J[1]*vals[0] + J[4]*vals[1] + J[7]*vals[2]);
    values[4] = result;
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
    y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    result = (J[0]*vals[0] + J[3]*vals[1] + J[6]*vals[2]);
    values[5] = result;
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const double* vertex_coordinates,
                                         int cell_orientation,
                                         const ufc::cell& c) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    // Evaluate function and change variables
    vertex_values[0] = dof_values[3]*K[6] + dof_values[4]*K[3] + dof_values[5]*K[0];
    vertex_values[3] = dof_values[1]*K[6] + dof_values[2]*K[3] + dof_values[5]*(K[0] + K[3] + K[6]);
    vertex_values[6] = dof_values[0]*K[6] + dof_values[2]*(K[0]*(-1.0)) + dof_values[4]*(K[0] + K[3] + K[6]);
    vertex_values[9] = dof_values[0]*(K[3]*(-1.0)) + dof_values[1]*(K[0]*(-1.0)) + dof_values[3]*(K[0] + K[3] + K[6]);
    vertex_values[1] = dof_values[3]*K[7] + dof_values[4]*K[4] + dof_values[5]*K[1];
    vertex_values[4] = dof_values[1]*K[7] + dof_values[2]*K[4] + dof_values[5]*(K[1] + K[4] + K[7]);
    vertex_values[7] = dof_values[0]*K[7] + dof_values[2]*(K[1]*(-1.0)) + dof_values[4]*(K[1] + K[4] + K[7]);
    vertex_values[10] = dof_values[0]*(K[4]*(-1.0)) + dof_values[1]*(K[1]*(-1.0)) + dof_values[3]*(K[1] + K[4] + K[7]);
    vertex_values[2] = dof_values[3]*K[8] + dof_values[4]*K[5] + dof_values[5]*K[2];
    vertex_values[5] = dof_values[1]*K[8] + dof_values[2]*K[5] + dof_values[5]*(K[2] + K[5] + K[8]);
    vertex_values[8] = dof_values[0]*K[8] + dof_values[2]*(K[2]*(-1.0)) + dof_values[4]*(K[2] + K[5] + K[8]);
    vertex_values[11] = dof_values[0]*(K[5]*(-1.0)) + dof_values[1]*(K[2]*(-1.0)) + dof_values[3]*(K[2] + K[5] + K[8]);
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    std::cerr << "*** FFC warning: " << "map_from_reference_cell not yet implemented." << std::endl;
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    std::cerr << "*** FFC warning: " << "map_to_reference_cell not yet implemented." << std::endl;
  }

  /// Return the number of sub elements (for a mixed element)
  virtual std::size_t num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(std::size_t i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new vectorlaplacegradcurl_finite_element_3();
  }

};

/// This class defines the interface for a finite element.

class vectorlaplacegradcurl_finite_element_4: public ufc::finite_element
{
public:

  /// Constructor
  vectorlaplacegradcurl_finite_element_4() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vectorlaplacegradcurl_finite_element_4()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "MixedElement(*[FiniteElement('Lagrange', Domain(Cell('tetrahedron', 3), 'tetrahedron_multiverse', 3, 3), 1, None), FiniteElement('Nedelec 1st kind H(curl)', Domain(Cell('tetrahedron', 3), 'tetrahedron_multiverse', 3, 3), 1, None)], **{'value_shape': (4,) })";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the topological dimension of the cell shape
  virtual std::size_t topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual std::size_t space_dimension() const
  {
    return 10;
  }

  /// Return the rank of the value space
  virtual std::size_t value_rank() const
  {
    return 1;
  }

  /// Return the dimension of the value space for axis i
  virtual std::size_t value_dimension(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return 4;
        break;
      }
    }
    
    return 0;
  }

  /// Evaluate basis function i at given point x in cell
  virtual void evaluate_basis(std::size_t i,
                              double* values,
                              const double* x,
                              const double* vertex_coordinates,
                              int cell_orientation) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Reset values
    values[0] = 0.0;
    values[1] = 0.0;
    values[2] = 0.0;
    values[3] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, -0.18257419, -0.10540926, -0.074535599};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.074535599};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.21081851, -0.074535599};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.0, 0.2236068};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.0, 0.0, 0.0, 0.0};
      
      static const double coefficients1[4] = \
      {-0.28867513, 0.0, 0.0, -0.2236068};
      
      static const double coefficients2[4] = \
      {0.28867513, 0.0, 0.21081851, -0.074535599};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
        values[2] += coefficients1[r]*basisvalues[r];
        values[3] += coefficients2[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[1];
      const double tmp_ref1 = values[2];
      const double tmp_ref2 = values[3];
      values[1] = (K[0]*tmp_ref0 + K[3]*tmp_ref1 + K[6]*tmp_ref2);
      values[2] = (K[1]*tmp_ref0 + K[4]*tmp_ref1 + K[7]*tmp_ref2);
      values[3] = (K[2]*tmp_ref0 + K[5]*tmp_ref1 + K[8]*tmp_ref2);
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {-0.28867513, 0.0, 0.0, -0.2236068};
      
      static const double coefficients1[4] = \
      {0.0, 0.0, 0.0, 0.0};
      
      static const double coefficients2[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.074535599};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
        values[2] += coefficients1[r]*basisvalues[r];
        values[3] += coefficients2[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[1];
      const double tmp_ref1 = values[2];
      const double tmp_ref2 = values[3];
      values[1] = (K[0]*tmp_ref0 + K[3]*tmp_ref1 + K[6]*tmp_ref2);
      values[2] = (K[1]*tmp_ref0 + K[4]*tmp_ref1 + K[7]*tmp_ref2);
      values[3] = (K[2]*tmp_ref0 + K[5]*tmp_ref1 + K[8]*tmp_ref2);
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {-0.28867513, 0.0, -0.21081851, 0.074535599};
      
      static const double coefficients1[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.074535599};
      
      static const double coefficients2[4] = \
      {0.0, 0.0, 0.0, 0.0};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
        values[2] += coefficients1[r]*basisvalues[r];
        values[3] += coefficients2[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[1];
      const double tmp_ref1 = values[2];
      const double tmp_ref2 = values[3];
      values[1] = (K[0]*tmp_ref0 + K[3]*tmp_ref1 + K[6]*tmp_ref2);
      values[2] = (K[1]*tmp_ref0 + K[4]*tmp_ref1 + K[7]*tmp_ref2);
      values[3] = (K[2]*tmp_ref0 + K[5]*tmp_ref1 + K[8]*tmp_ref2);
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.0, 0.2236068};
      
      static const double coefficients1[4] = \
      {0.28867513, 0.0, 0.0, 0.2236068};
      
      static const double coefficients2[4] = \
      {0.57735027, -0.18257419, -0.10540926, 0.1490712};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
        values[2] += coefficients1[r]*basisvalues[r];
        values[3] += coefficients2[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[1];
      const double tmp_ref1 = values[2];
      const double tmp_ref2 = values[3];
      values[1] = (K[0]*tmp_ref0 + K[3]*tmp_ref1 + K[6]*tmp_ref2);
      values[2] = (K[1]*tmp_ref0 + K[4]*tmp_ref1 + K[7]*tmp_ref2);
      values[3] = (K[2]*tmp_ref0 + K[5]*tmp_ref1 + K[8]*tmp_ref2);
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.21081851, -0.074535599};
      
      static const double coefficients1[4] = \
      {0.57735027, -0.18257419, 0.10540926, -0.1490712};
      
      static const double coefficients2[4] = \
      {0.28867513, 0.0, 0.21081851, -0.074535599};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
        values[2] += coefficients1[r]*basisvalues[r];
        values[3] += coefficients2[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[1];
      const double tmp_ref1 = values[2];
      const double tmp_ref2 = values[3];
      values[1] = (K[0]*tmp_ref0 + K[3]*tmp_ref1 + K[6]*tmp_ref2);
      values[2] = (K[1]*tmp_ref0 + K[4]*tmp_ref1 + K[7]*tmp_ref2);
      values[3] = (K[2]*tmp_ref0 + K[5]*tmp_ref1 + K[8]*tmp_ref2);
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.57735027, 0.0, -0.21081851, -0.1490712};
      
      static const double coefficients1[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.074535599};
      
      static const double coefficients2[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.074535599};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
        values[2] += coefficients1[r]*basisvalues[r];
        values[3] += coefficients2[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[1];
      const double tmp_ref1 = values[2];
      const double tmp_ref2 = values[3];
      values[1] = (K[0]*tmp_ref0 + K[3]*tmp_ref1 + K[6]*tmp_ref2);
      values[2] = (K[1]*tmp_ref0 + K[4]*tmp_ref1 + K[7]*tmp_ref2);
      values[3] = (K[2]*tmp_ref0 + K[5]*tmp_ref1 + K[8]*tmp_ref2);
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point x in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* x,
                                  const double* vertex_coordinates,
                                  int cell_orientation) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values[4] = {0.0, 0.0, 0.0, 0.0};
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis(r, dof_values, x, vertex_coordinates, cell_orientation);
      for (unsigned int s = 0; s < 4; s++)
      {
        values[r*4 + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point x in cell
  virtual void evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double* values,
                                          const double* x,
                                          const double* vertex_coordinates,
                                          int cell_orientation) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 4*num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, -0.18257419, -0.10540926, -0.074535599};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.074535599};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.21081851, -0.074535599};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.0, 0.2236068};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.0, 0.0, 0.0, 0.0};
      
      static const double coefficients1[4] = \
      {-0.28867513, 0.0, 0.0, -0.2236068};
      
      static const double coefficients2[4] = \
      {0.28867513, 0.0, 0.21081851, -0.074535599};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[3*num_derivatives];
      for (unsigned int r = 0; r < 3*num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare pointer to array of reference derivatives on physical element.
      double *derivatives_p = new double[3*num_derivatives];
      for (unsigned int r = 0; r < 3*num_derivatives; r++)
      {
        derivatives_p[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
            derivatives[2*num_derivatives + r] += coefficients2[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        const double tmp_ref2 = derivatives[2*num_derivatives + r];
        derivatives_p[r] = (K[0]*tmp_ref0 + K[3]*tmp_ref1 + K[6]*tmp_ref2);
        derivatives_p[num_derivatives + r] = (K[1]*tmp_ref0 + K[4]*tmp_ref1 + K[7]*tmp_ref2);
        derivatives_p[2*num_derivatives + r] = (K[2]*tmp_ref0 + K[5]*tmp_ref1 + K[8]*tmp_ref2);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives_p[s];
          values[2*num_derivatives + r] += transform[r][s]*derivatives_p[num_derivatives + s];
          values[3*num_derivatives + r] += transform[r][s]*derivatives_p[2*num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of reference derivatives on physical element.
      delete [] derivatives_p;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {-0.28867513, 0.0, 0.0, -0.2236068};
      
      static const double coefficients1[4] = \
      {0.0, 0.0, 0.0, 0.0};
      
      static const double coefficients2[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.074535599};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[3*num_derivatives];
      for (unsigned int r = 0; r < 3*num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare pointer to array of reference derivatives on physical element.
      double *derivatives_p = new double[3*num_derivatives];
      for (unsigned int r = 0; r < 3*num_derivatives; r++)
      {
        derivatives_p[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
            derivatives[2*num_derivatives + r] += coefficients2[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        const double tmp_ref2 = derivatives[2*num_derivatives + r];
        derivatives_p[r] = (K[0]*tmp_ref0 + K[3]*tmp_ref1 + K[6]*tmp_ref2);
        derivatives_p[num_derivatives + r] = (K[1]*tmp_ref0 + K[4]*tmp_ref1 + K[7]*tmp_ref2);
        derivatives_p[2*num_derivatives + r] = (K[2]*tmp_ref0 + K[5]*tmp_ref1 + K[8]*tmp_ref2);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives_p[s];
          values[2*num_derivatives + r] += transform[r][s]*derivatives_p[num_derivatives + s];
          values[3*num_derivatives + r] += transform[r][s]*derivatives_p[2*num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of reference derivatives on physical element.
      delete [] derivatives_p;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {-0.28867513, 0.0, -0.21081851, 0.074535599};
      
      static const double coefficients1[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.074535599};
      
      static const double coefficients2[4] = \
      {0.0, 0.0, 0.0, 0.0};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[3*num_derivatives];
      for (unsigned int r = 0; r < 3*num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare pointer to array of reference derivatives on physical element.
      double *derivatives_p = new double[3*num_derivatives];
      for (unsigned int r = 0; r < 3*num_derivatives; r++)
      {
        derivatives_p[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
            derivatives[2*num_derivatives + r] += coefficients2[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        const double tmp_ref2 = derivatives[2*num_derivatives + r];
        derivatives_p[r] = (K[0]*tmp_ref0 + K[3]*tmp_ref1 + K[6]*tmp_ref2);
        derivatives_p[num_derivatives + r] = (K[1]*tmp_ref0 + K[4]*tmp_ref1 + K[7]*tmp_ref2);
        derivatives_p[2*num_derivatives + r] = (K[2]*tmp_ref0 + K[5]*tmp_ref1 + K[8]*tmp_ref2);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives_p[s];
          values[2*num_derivatives + r] += transform[r][s]*derivatives_p[num_derivatives + s];
          values[3*num_derivatives + r] += transform[r][s]*derivatives_p[2*num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of reference derivatives on physical element.
      delete [] derivatives_p;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.0, 0.2236068};
      
      static const double coefficients1[4] = \
      {0.28867513, 0.0, 0.0, 0.2236068};
      
      static const double coefficients2[4] = \
      {0.57735027, -0.18257419, -0.10540926, 0.1490712};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[3*num_derivatives];
      for (unsigned int r = 0; r < 3*num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare pointer to array of reference derivatives on physical element.
      double *derivatives_p = new double[3*num_derivatives];
      for (unsigned int r = 0; r < 3*num_derivatives; r++)
      {
        derivatives_p[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
            derivatives[2*num_derivatives + r] += coefficients2[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        const double tmp_ref2 = derivatives[2*num_derivatives + r];
        derivatives_p[r] = (K[0]*tmp_ref0 + K[3]*tmp_ref1 + K[6]*tmp_ref2);
        derivatives_p[num_derivatives + r] = (K[1]*tmp_ref0 + K[4]*tmp_ref1 + K[7]*tmp_ref2);
        derivatives_p[2*num_derivatives + r] = (K[2]*tmp_ref0 + K[5]*tmp_ref1 + K[8]*tmp_ref2);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives_p[s];
          values[2*num_derivatives + r] += transform[r][s]*derivatives_p[num_derivatives + s];
          values[3*num_derivatives + r] += transform[r][s]*derivatives_p[2*num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of reference derivatives on physical element.
      delete [] derivatives_p;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.21081851, -0.074535599};
      
      static const double coefficients1[4] = \
      {0.57735027, -0.18257419, 0.10540926, -0.1490712};
      
      static const double coefficients2[4] = \
      {0.28867513, 0.0, 0.21081851, -0.074535599};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[3*num_derivatives];
      for (unsigned int r = 0; r < 3*num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare pointer to array of reference derivatives on physical element.
      double *derivatives_p = new double[3*num_derivatives];
      for (unsigned int r = 0; r < 3*num_derivatives; r++)
      {
        derivatives_p[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
            derivatives[2*num_derivatives + r] += coefficients2[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        const double tmp_ref2 = derivatives[2*num_derivatives + r];
        derivatives_p[r] = (K[0]*tmp_ref0 + K[3]*tmp_ref1 + K[6]*tmp_ref2);
        derivatives_p[num_derivatives + r] = (K[1]*tmp_ref0 + K[4]*tmp_ref1 + K[7]*tmp_ref2);
        derivatives_p[2*num_derivatives + r] = (K[2]*tmp_ref0 + K[5]*tmp_ref1 + K[8]*tmp_ref2);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives_p[s];
          values[2*num_derivatives + r] += transform[r][s]*derivatives_p[num_derivatives + s];
          values[3*num_derivatives + r] += transform[r][s]*derivatives_p[2*num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of reference derivatives on physical element.
      delete [] derivatives_p;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.57735027, 0.0, -0.21081851, -0.1490712};
      
      static const double coefficients1[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.074535599};
      
      static const double coefficients2[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.074535599};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[3*num_derivatives];
      for (unsigned int r = 0; r < 3*num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare pointer to array of reference derivatives on physical element.
      double *derivatives_p = new double[3*num_derivatives];
      for (unsigned int r = 0; r < 3*num_derivatives; r++)
      {
        derivatives_p[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
            derivatives[2*num_derivatives + r] += coefficients2[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        const double tmp_ref2 = derivatives[2*num_derivatives + r];
        derivatives_p[r] = (K[0]*tmp_ref0 + K[3]*tmp_ref1 + K[6]*tmp_ref2);
        derivatives_p[num_derivatives + r] = (K[1]*tmp_ref0 + K[4]*tmp_ref1 + K[7]*tmp_ref2);
        derivatives_p[2*num_derivatives + r] = (K[2]*tmp_ref0 + K[5]*tmp_ref1 + K[8]*tmp_ref2);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives_p[s];
          values[2*num_derivatives + r] += transform[r][s]*derivatives_p[num_derivatives + s];
          values[3*num_derivatives + r] += transform[r][s]*derivatives_p[2*num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of reference derivatives on physical element.
      delete [] derivatives_p;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point x in cell
  virtual void evaluate_basis_derivatives_all(std::size_t n,
                                              double* values,
                                              const double* x,
                                              const double* vertex_coordinates,
                                              int cell_orientation) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[4*num_derivatives];
    for (unsigned int r = 0; r < 4*num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, x, vertex_coordinates, cell_orientation);
      for (unsigned int s = 0; s < 4*num_derivatives; s++)
      {
        values[r*4*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(std::size_t i,
                              const ufc::function& f,
                              const double* vertex_coordinates,
                              int cell_orientation,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[4];
    
    // Declare variable for physical coordinates
    double y[3];
    
    double result;
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    switch (i)
    {
    case 0:
      {
        y[0] = vertex_coordinates[0];
      y[1] = vertex_coordinates[1];
      y[2] = vertex_coordinates[2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = vertex_coordinates[3];
      y[1] = vertex_coordinates[4];
      y[2] = vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = vertex_coordinates[6];
      y[1] = vertex_coordinates[7];
      y[2] = vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = vertex_coordinates[9];
      y[1] = vertex_coordinates[10];
      y[2] = vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
      y[1] = 0.5*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
      y[2] = 0.5*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      result = (-1.0)*(J[1]*vals[1] + J[4]*vals[2] + J[7]*vals[3]) + (J[2]*vals[1] + J[5]*vals[2] + J[8]*vals[3]);
      return result;
        break;
      }
    case 5:
      {
        y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[9];
      y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[10];
      y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      result = (-1.0)*(J[0]*vals[1] + J[3]*vals[2] + J[6]*vals[3]) + (J[2]*vals[1] + J[5]*vals[2] + J[8]*vals[3]);
      return result;
        break;
      }
    case 6:
      {
        y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
      y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
      y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      result = (-1.0)*(J[0]*vals[1] + J[3]*vals[2] + J[6]*vals[3]) + (J[1]*vals[1] + J[4]*vals[2] + J[7]*vals[3]);
      return result;
        break;
      }
    case 7:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[9];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[10];
      y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      result = (J[2]*vals[1] + J[5]*vals[2] + J[8]*vals[3]);
      return result;
        break;
      }
    case 8:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
      y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      result = (J[1]*vals[1] + J[4]*vals[2] + J[7]*vals[3]);
      return result;
        break;
      }
    case 9:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
      y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      result = (J[0]*vals[1] + J[3]*vals[2] + J[6]*vals[3]);
      return result;
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const double* vertex_coordinates,
                             int cell_orientation,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[4];
    
    // Declare variable for physical coordinates
    double y[3];
    
    double result;
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    y[0] = vertex_coordinates[0];
    y[1] = vertex_coordinates[1];
    y[2] = vertex_coordinates[2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = vertex_coordinates[3];
    y[1] = vertex_coordinates[4];
    y[2] = vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = vertex_coordinates[6];
    y[1] = vertex_coordinates[7];
    y[2] = vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = vertex_coordinates[9];
    y[1] = vertex_coordinates[10];
    y[2] = vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
    y[1] = 0.5*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
    y[2] = 0.5*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    result = (-1.0)*(J[1]*vals[1] + J[4]*vals[2] + J[7]*vals[3]) + (J[2]*vals[1] + J[5]*vals[2] + J[8]*vals[3]);
    values[4] = result;
    y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[9];
    y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[10];
    y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    result = (-1.0)*(J[0]*vals[1] + J[3]*vals[2] + J[6]*vals[3]) + (J[2]*vals[1] + J[5]*vals[2] + J[8]*vals[3]);
    values[5] = result;
    y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
    y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
    y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    result = (-1.0)*(J[0]*vals[1] + J[3]*vals[2] + J[6]*vals[3]) + (J[1]*vals[1] + J[4]*vals[2] + J[7]*vals[3]);
    values[6] = result;
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[9];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[10];
    y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    result = (J[2]*vals[1] + J[5]*vals[2] + J[8]*vals[3]);
    values[7] = result;
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
    y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    result = (J[1]*vals[1] + J[4]*vals[2] + J[7]*vals[3]);
    values[8] = result;
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
    y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    result = (J[0]*vals[1] + J[3]*vals[2] + J[6]*vals[3]);
    values[9] = result;
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const double* vertex_coordinates,
                                         int cell_orientation,
                                         const ufc::cell& c) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[4] = dof_values[1];
    vertex_values[8] = dof_values[2];
    vertex_values[12] = dof_values[3];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[7]*K[6] + dof_values[8]*K[3] + dof_values[9]*K[0];
    vertex_values[5] = dof_values[5]*K[6] + dof_values[6]*K[3] + dof_values[9]*(K[0] + K[3] + K[6]);
    vertex_values[9] = dof_values[4]*K[6] + dof_values[6]*(K[0]*(-1.0)) + dof_values[8]*(K[0] + K[3] + K[6]);
    vertex_values[13] = dof_values[4]*(K[3]*(-1.0)) + dof_values[5]*(K[0]*(-1.0)) + dof_values[7]*(K[0] + K[3] + K[6]);
    vertex_values[2] = dof_values[7]*K[7] + dof_values[8]*K[4] + dof_values[9]*K[1];
    vertex_values[6] = dof_values[5]*K[7] + dof_values[6]*K[4] + dof_values[9]*(K[1] + K[4] + K[7]);
    vertex_values[10] = dof_values[4]*K[7] + dof_values[6]*(K[1]*(-1.0)) + dof_values[8]*(K[1] + K[4] + K[7]);
    vertex_values[14] = dof_values[4]*(K[4]*(-1.0)) + dof_values[5]*(K[1]*(-1.0)) + dof_values[7]*(K[1] + K[4] + K[7]);
    vertex_values[3] = dof_values[7]*K[8] + dof_values[8]*K[5] + dof_values[9]*K[2];
    vertex_values[7] = dof_values[5]*K[8] + dof_values[6]*K[5] + dof_values[9]*(K[2] + K[5] + K[8]);
    vertex_values[11] = dof_values[4]*K[8] + dof_values[6]*(K[2]*(-1.0)) + dof_values[8]*(K[2] + K[5] + K[8]);
    vertex_values[15] = dof_values[4]*(K[5]*(-1.0)) + dof_values[5]*(K[2]*(-1.0)) + dof_values[7]*(K[2] + K[5] + K[8]);
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    std::cerr << "*** FFC warning: " << "map_from_reference_cell not yet implemented." << std::endl;
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    std::cerr << "*** FFC warning: " << "map_to_reference_cell not yet implemented." << std::endl;
  }

  /// Return the number of sub elements (for a mixed element)
  virtual std::size_t num_sub_elements() const
  {
    return 2;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new vectorlaplacegradcurl_finite_element_2();
        break;
      }
    case 1:
      {
        return new vectorlaplacegradcurl_finite_element_3();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new vectorlaplacegradcurl_finite_element_4();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class vectorlaplacegradcurl_dofmap_0: public ufc::dofmap
{
public:

  /// Constructor
  vectorlaplacegradcurl_dofmap_0() : ufc::dofmap()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vectorlaplacegradcurl_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Domain(Cell('tetrahedron', 3), 'tetrahedron_multiverse', 3, 3), 2, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Return the topological dimension of the associated cell shape
  virtual std::size_t topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the global finite element function space
  virtual std::size_t global_dimension(const std::vector<std::size_t>&
                                       num_global_entities) const
  {
    return num_global_entities[0] + num_global_entities[1];
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual std::size_t local_dimension(const ufc::cell& c) const
  {
    return 10;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual std::size_t max_local_dimension() const
  {
    return 10;
  }

  /// Return the number of dofs on each cell facet
  virtual std::size_t num_facet_dofs() const
  {
    return 6;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual std::size_t num_entity_dofs(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 1;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(std::size_t* dofs,
                             const std::vector<std::size_t>& num_global_entities,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    dofs[3] = offset + c.entity_indices[0][3];
    offset += num_global_entities[0];
    dofs[4] = offset + c.entity_indices[1][0];
    dofs[5] = offset + c.entity_indices[1][1];
    dofs[6] = offset + c.entity_indices[1][2];
    dofs[7] = offset + c.entity_indices[1][3];
    dofs[8] = offset + c.entity_indices[1][4];
    dofs[9] = offset + c.entity_indices[1][5];
    offset += num_global_entities[1];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(std::size_t* dofs,
                                   std::size_t facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 7;
      dofs[5] = 8;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 5;
      dofs[4] = 7;
      dofs[5] = 9;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 6;
      dofs[4] = 8;
      dofs[5] = 9;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(std::size_t* dofs,
                                    std::size_t d, std::size_t i) const
  {
    if (d > 3)
    {
    std::cerr << "*** FFC warning: " << "d is larger than dimension (3)" << std::endl;
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (3)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 5)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (5)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 4;
          break;
        }
      case 1:
        {
          dofs[0] = 5;
          break;
        }
      case 2:
        {
          dofs[0] = 6;
          break;
        }
      case 3:
        {
          dofs[0] = 7;
          break;
        }
      case 4:
        {
          dofs[0] = 8;
          break;
        }
      case 5:
        {
          dofs[0] = 9;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** dof_coordinates,
                                    const double* vertex_coordinates) const
  {
    dof_coordinates[0][0] = vertex_coordinates[0];
    dof_coordinates[0][1] = vertex_coordinates[1];
    dof_coordinates[0][2] = vertex_coordinates[2];
    dof_coordinates[1][0] = vertex_coordinates[3];
    dof_coordinates[1][1] = vertex_coordinates[4];
    dof_coordinates[1][2] = vertex_coordinates[5];
    dof_coordinates[2][0] = vertex_coordinates[6];
    dof_coordinates[2][1] = vertex_coordinates[7];
    dof_coordinates[2][2] = vertex_coordinates[8];
    dof_coordinates[3][0] = vertex_coordinates[9];
    dof_coordinates[3][1] = vertex_coordinates[10];
    dof_coordinates[3][2] = vertex_coordinates[11];
    dof_coordinates[4][0] = 0.5*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
    dof_coordinates[4][1] = 0.5*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
    dof_coordinates[4][2] = 0.5*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
    dof_coordinates[5][0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[9];
    dof_coordinates[5][1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[10];
    dof_coordinates[5][2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[11];
    dof_coordinates[6][0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
    dof_coordinates[6][1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
    dof_coordinates[6][2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
    dof_coordinates[7][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[9];
    dof_coordinates[7][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[10];
    dof_coordinates[7][2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[11];
    dof_coordinates[8][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
    dof_coordinates[8][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
    dof_coordinates[8][2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
    dof_coordinates[9][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
    dof_coordinates[9][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
    dof_coordinates[9][2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual std::size_t num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(std::size_t i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new vectorlaplacegradcurl_dofmap_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class vectorlaplacegradcurl_dofmap_1: public ufc::dofmap
{
public:

  /// Constructor
  vectorlaplacegradcurl_dofmap_1() : ufc::dofmap()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vectorlaplacegradcurl_dofmap_1()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for VectorElement('Lagrange', Domain(Cell('tetrahedron', 3), 'tetrahedron_multiverse', 3, 3), 2, 3, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Return the topological dimension of the associated cell shape
  virtual std::size_t topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the global finite element function space
  virtual std::size_t global_dimension(const std::vector<std::size_t>&
                                       num_global_entities) const
  {
    return 3*num_global_entities[0] + 3*num_global_entities[1];
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual std::size_t local_dimension(const ufc::cell& c) const
  {
    return 30;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual std::size_t max_local_dimension() const
  {
    return 30;
  }

  /// Return the number of dofs on each cell facet
  virtual std::size_t num_facet_dofs() const
  {
    return 18;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual std::size_t num_entity_dofs(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return 3;
        break;
      }
    case 1:
      {
        return 3;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(std::size_t* dofs,
                             const std::vector<std::size_t>& num_global_entities,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    dofs[3] = offset + c.entity_indices[0][3];
    offset += num_global_entities[0];
    dofs[4] = offset + c.entity_indices[1][0];
    dofs[5] = offset + c.entity_indices[1][1];
    dofs[6] = offset + c.entity_indices[1][2];
    dofs[7] = offset + c.entity_indices[1][3];
    dofs[8] = offset + c.entity_indices[1][4];
    dofs[9] = offset + c.entity_indices[1][5];
    offset += num_global_entities[1];
    dofs[10] = offset + c.entity_indices[0][0];
    dofs[11] = offset + c.entity_indices[0][1];
    dofs[12] = offset + c.entity_indices[0][2];
    dofs[13] = offset + c.entity_indices[0][3];
    offset += num_global_entities[0];
    dofs[14] = offset + c.entity_indices[1][0];
    dofs[15] = offset + c.entity_indices[1][1];
    dofs[16] = offset + c.entity_indices[1][2];
    dofs[17] = offset + c.entity_indices[1][3];
    dofs[18] = offset + c.entity_indices[1][4];
    dofs[19] = offset + c.entity_indices[1][5];
    offset += num_global_entities[1];
    dofs[20] = offset + c.entity_indices[0][0];
    dofs[21] = offset + c.entity_indices[0][1];
    dofs[22] = offset + c.entity_indices[0][2];
    dofs[23] = offset + c.entity_indices[0][3];
    offset += num_global_entities[0];
    dofs[24] = offset + c.entity_indices[1][0];
    dofs[25] = offset + c.entity_indices[1][1];
    dofs[26] = offset + c.entity_indices[1][2];
    dofs[27] = offset + c.entity_indices[1][3];
    dofs[28] = offset + c.entity_indices[1][4];
    dofs[29] = offset + c.entity_indices[1][5];
    offset += num_global_entities[1];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(std::size_t* dofs,
                                   std::size_t facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
      dofs[6] = 11;
      dofs[7] = 12;
      dofs[8] = 13;
      dofs[9] = 14;
      dofs[10] = 15;
      dofs[11] = 16;
      dofs[12] = 21;
      dofs[13] = 22;
      dofs[14] = 23;
      dofs[15] = 24;
      dofs[16] = 25;
      dofs[17] = 26;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 7;
      dofs[5] = 8;
      dofs[6] = 10;
      dofs[7] = 12;
      dofs[8] = 13;
      dofs[9] = 14;
      dofs[10] = 17;
      dofs[11] = 18;
      dofs[12] = 20;
      dofs[13] = 22;
      dofs[14] = 23;
      dofs[15] = 24;
      dofs[16] = 27;
      dofs[17] = 28;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 5;
      dofs[4] = 7;
      dofs[5] = 9;
      dofs[6] = 10;
      dofs[7] = 11;
      dofs[8] = 13;
      dofs[9] = 15;
      dofs[10] = 17;
      dofs[11] = 19;
      dofs[12] = 20;
      dofs[13] = 21;
      dofs[14] = 23;
      dofs[15] = 25;
      dofs[16] = 27;
      dofs[17] = 29;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 6;
      dofs[4] = 8;
      dofs[5] = 9;
      dofs[6] = 10;
      dofs[7] = 11;
      dofs[8] = 12;
      dofs[9] = 16;
      dofs[10] = 18;
      dofs[11] = 19;
      dofs[12] = 20;
      dofs[13] = 21;
      dofs[14] = 22;
      dofs[15] = 26;
      dofs[16] = 28;
      dofs[17] = 29;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(std::size_t* dofs,
                                    std::size_t d, std::size_t i) const
  {
    if (d > 3)
    {
    std::cerr << "*** FFC warning: " << "d is larger than dimension (3)" << std::endl;
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (3)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 10;
        dofs[2] = 20;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 11;
        dofs[2] = 21;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 12;
        dofs[2] = 22;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
        dofs[1] = 13;
        dofs[2] = 23;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 5)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (5)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 4;
        dofs[1] = 14;
        dofs[2] = 24;
          break;
        }
      case 1:
        {
          dofs[0] = 5;
        dofs[1] = 15;
        dofs[2] = 25;
          break;
        }
      case 2:
        {
          dofs[0] = 6;
        dofs[1] = 16;
        dofs[2] = 26;
          break;
        }
      case 3:
        {
          dofs[0] = 7;
        dofs[1] = 17;
        dofs[2] = 27;
          break;
        }
      case 4:
        {
          dofs[0] = 8;
        dofs[1] = 18;
        dofs[2] = 28;
          break;
        }
      case 5:
        {
          dofs[0] = 9;
        dofs[1] = 19;
        dofs[2] = 29;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** dof_coordinates,
                                    const double* vertex_coordinates) const
  {
    dof_coordinates[0][0] = vertex_coordinates[0];
    dof_coordinates[0][1] = vertex_coordinates[1];
    dof_coordinates[0][2] = vertex_coordinates[2];
    dof_coordinates[1][0] = vertex_coordinates[3];
    dof_coordinates[1][1] = vertex_coordinates[4];
    dof_coordinates[1][2] = vertex_coordinates[5];
    dof_coordinates[2][0] = vertex_coordinates[6];
    dof_coordinates[2][1] = vertex_coordinates[7];
    dof_coordinates[2][2] = vertex_coordinates[8];
    dof_coordinates[3][0] = vertex_coordinates[9];
    dof_coordinates[3][1] = vertex_coordinates[10];
    dof_coordinates[3][2] = vertex_coordinates[11];
    dof_coordinates[4][0] = 0.5*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
    dof_coordinates[4][1] = 0.5*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
    dof_coordinates[4][2] = 0.5*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
    dof_coordinates[5][0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[9];
    dof_coordinates[5][1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[10];
    dof_coordinates[5][2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[11];
    dof_coordinates[6][0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
    dof_coordinates[6][1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
    dof_coordinates[6][2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
    dof_coordinates[7][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[9];
    dof_coordinates[7][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[10];
    dof_coordinates[7][2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[11];
    dof_coordinates[8][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
    dof_coordinates[8][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
    dof_coordinates[8][2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
    dof_coordinates[9][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
    dof_coordinates[9][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
    dof_coordinates[9][2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
    dof_coordinates[10][0] = vertex_coordinates[0];
    dof_coordinates[10][1] = vertex_coordinates[1];
    dof_coordinates[10][2] = vertex_coordinates[2];
    dof_coordinates[11][0] = vertex_coordinates[3];
    dof_coordinates[11][1] = vertex_coordinates[4];
    dof_coordinates[11][2] = vertex_coordinates[5];
    dof_coordinates[12][0] = vertex_coordinates[6];
    dof_coordinates[12][1] = vertex_coordinates[7];
    dof_coordinates[12][2] = vertex_coordinates[8];
    dof_coordinates[13][0] = vertex_coordinates[9];
    dof_coordinates[13][1] = vertex_coordinates[10];
    dof_coordinates[13][2] = vertex_coordinates[11];
    dof_coordinates[14][0] = 0.5*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
    dof_coordinates[14][1] = 0.5*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
    dof_coordinates[14][2] = 0.5*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
    dof_coordinates[15][0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[9];
    dof_coordinates[15][1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[10];
    dof_coordinates[15][2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[11];
    dof_coordinates[16][0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
    dof_coordinates[16][1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
    dof_coordinates[16][2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
    dof_coordinates[17][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[9];
    dof_coordinates[17][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[10];
    dof_coordinates[17][2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[11];
    dof_coordinates[18][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
    dof_coordinates[18][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
    dof_coordinates[18][2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
    dof_coordinates[19][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
    dof_coordinates[19][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
    dof_coordinates[19][2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
    dof_coordinates[20][0] = vertex_coordinates[0];
    dof_coordinates[20][1] = vertex_coordinates[1];
    dof_coordinates[20][2] = vertex_coordinates[2];
    dof_coordinates[21][0] = vertex_coordinates[3];
    dof_coordinates[21][1] = vertex_coordinates[4];
    dof_coordinates[21][2] = vertex_coordinates[5];
    dof_coordinates[22][0] = vertex_coordinates[6];
    dof_coordinates[22][1] = vertex_coordinates[7];
    dof_coordinates[22][2] = vertex_coordinates[8];
    dof_coordinates[23][0] = vertex_coordinates[9];
    dof_coordinates[23][1] = vertex_coordinates[10];
    dof_coordinates[23][2] = vertex_coordinates[11];
    dof_coordinates[24][0] = 0.5*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
    dof_coordinates[24][1] = 0.5*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
    dof_coordinates[24][2] = 0.5*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
    dof_coordinates[25][0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[9];
    dof_coordinates[25][1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[10];
    dof_coordinates[25][2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[11];
    dof_coordinates[26][0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
    dof_coordinates[26][1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
    dof_coordinates[26][2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
    dof_coordinates[27][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[9];
    dof_coordinates[27][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[10];
    dof_coordinates[27][2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[11];
    dof_coordinates[28][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
    dof_coordinates[28][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
    dof_coordinates[28][2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
    dof_coordinates[29][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
    dof_coordinates[29][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
    dof_coordinates[29][2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual std::size_t num_sub_dofmaps() const
  {
    return 3;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new vectorlaplacegradcurl_dofmap_0();
        break;
      }
    case 1:
      {
        return new vectorlaplacegradcurl_dofmap_0();
        break;
      }
    case 2:
      {
        return new vectorlaplacegradcurl_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new vectorlaplacegradcurl_dofmap_1();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class vectorlaplacegradcurl_dofmap_2: public ufc::dofmap
{
public:

  /// Constructor
  vectorlaplacegradcurl_dofmap_2() : ufc::dofmap()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vectorlaplacegradcurl_dofmap_2()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Domain(Cell('tetrahedron', 3), 'tetrahedron_multiverse', 3, 3), 1, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Return the topological dimension of the associated cell shape
  virtual std::size_t topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the global finite element function space
  virtual std::size_t global_dimension(const std::vector<std::size_t>&
                                       num_global_entities) const
  {
    return num_global_entities[0];
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual std::size_t local_dimension(const ufc::cell& c) const
  {
    return 4;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual std::size_t max_local_dimension() const
  {
    return 4;
  }

  /// Return the number of dofs on each cell facet
  virtual std::size_t num_facet_dofs() const
  {
    return 3;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual std::size_t num_entity_dofs(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(std::size_t* dofs,
                             const std::vector<std::size_t>& num_global_entities,
                             const ufc::cell& c) const
  {
    dofs[0] = c.entity_indices[0][0];
    dofs[1] = c.entity_indices[0][1];
    dofs[2] = c.entity_indices[0][2];
    dofs[3] = c.entity_indices[0][3];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(std::size_t* dofs,
                                   std::size_t facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(std::size_t* dofs,
                                    std::size_t d, std::size_t i) const
  {
    if (d > 3)
    {
    std::cerr << "*** FFC warning: " << "d is larger than dimension (3)" << std::endl;
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (3)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** dof_coordinates,
                                    const double* vertex_coordinates) const
  {
    dof_coordinates[0][0] = vertex_coordinates[0];
    dof_coordinates[0][1] = vertex_coordinates[1];
    dof_coordinates[0][2] = vertex_coordinates[2];
    dof_coordinates[1][0] = vertex_coordinates[3];
    dof_coordinates[1][1] = vertex_coordinates[4];
    dof_coordinates[1][2] = vertex_coordinates[5];
    dof_coordinates[2][0] = vertex_coordinates[6];
    dof_coordinates[2][1] = vertex_coordinates[7];
    dof_coordinates[2][2] = vertex_coordinates[8];
    dof_coordinates[3][0] = vertex_coordinates[9];
    dof_coordinates[3][1] = vertex_coordinates[10];
    dof_coordinates[3][2] = vertex_coordinates[11];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual std::size_t num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(std::size_t i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new vectorlaplacegradcurl_dofmap_2();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class vectorlaplacegradcurl_dofmap_3: public ufc::dofmap
{
public:

  /// Constructor
  vectorlaplacegradcurl_dofmap_3() : ufc::dofmap()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vectorlaplacegradcurl_dofmap_3()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Nedelec 1st kind H(curl)', Domain(Cell('tetrahedron', 3), 'tetrahedron_multiverse', 3, 3), 1, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Return the topological dimension of the associated cell shape
  virtual std::size_t topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the global finite element function space
  virtual std::size_t global_dimension(const std::vector<std::size_t>&
                                       num_global_entities) const
  {
    return num_global_entities[1];
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual std::size_t local_dimension(const ufc::cell& c) const
  {
    return 6;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual std::size_t max_local_dimension() const
  {
    return 6;
  }

  /// Return the number of dofs on each cell facet
  virtual std::size_t num_facet_dofs() const
  {
    return 3;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual std::size_t num_entity_dofs(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 1;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(std::size_t* dofs,
                             const std::vector<std::size_t>& num_global_entities,
                             const ufc::cell& c) const
  {
    dofs[0] = c.entity_indices[1][0];
    dofs[1] = c.entity_indices[1][1];
    dofs[2] = c.entity_indices[1][2];
    dofs[3] = c.entity_indices[1][3];
    dofs[4] = c.entity_indices[1][4];
    dofs[5] = c.entity_indices[1][5];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(std::size_t* dofs,
                                   std::size_t facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 3;
      dofs[2] = 4;
        break;
      }
    case 2:
      {
        dofs[0] = 1;
      dofs[1] = 3;
      dofs[2] = 5;
        break;
      }
    case 3:
      {
        dofs[0] = 2;
      dofs[1] = 4;
      dofs[2] = 5;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(std::size_t* dofs,
                                    std::size_t d, std::size_t i) const
  {
    if (d > 3)
    {
    std::cerr << "*** FFC warning: " << "d is larger than dimension (3)" << std::endl;
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        if (i > 5)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (5)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      case 4:
        {
          dofs[0] = 4;
          break;
        }
      case 5:
        {
          dofs[0] = 5;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** dof_coordinates,
                                    const double* vertex_coordinates) const
  {
    dof_coordinates[0][0] = 0.5*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
    dof_coordinates[0][1] = 0.5*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
    dof_coordinates[0][2] = 0.5*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
    dof_coordinates[1][0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[9];
    dof_coordinates[1][1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[10];
    dof_coordinates[1][2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[11];
    dof_coordinates[2][0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
    dof_coordinates[2][1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
    dof_coordinates[2][2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
    dof_coordinates[3][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[9];
    dof_coordinates[3][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[10];
    dof_coordinates[3][2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[11];
    dof_coordinates[4][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
    dof_coordinates[4][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
    dof_coordinates[4][2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
    dof_coordinates[5][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
    dof_coordinates[5][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
    dof_coordinates[5][2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual std::size_t num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(std::size_t i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new vectorlaplacegradcurl_dofmap_3();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class vectorlaplacegradcurl_dofmap_4: public ufc::dofmap
{
public:

  /// Constructor
  vectorlaplacegradcurl_dofmap_4() : ufc::dofmap()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vectorlaplacegradcurl_dofmap_4()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for MixedElement(*[FiniteElement('Lagrange', Domain(Cell('tetrahedron', 3), 'tetrahedron_multiverse', 3, 3), 1, None), FiniteElement('Nedelec 1st kind H(curl)', Domain(Cell('tetrahedron', 3), 'tetrahedron_multiverse', 3, 3), 1, None)], **{'value_shape': (4,) })";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Return the topological dimension of the associated cell shape
  virtual std::size_t topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the global finite element function space
  virtual std::size_t global_dimension(const std::vector<std::size_t>&
                                       num_global_entities) const
  {
    return num_global_entities[0] + num_global_entities[1];
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual std::size_t local_dimension(const ufc::cell& c) const
  {
    return 10;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual std::size_t max_local_dimension() const
  {
    return 10;
  }

  /// Return the number of dofs on each cell facet
  virtual std::size_t num_facet_dofs() const
  {
    return 6;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual std::size_t num_entity_dofs(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 1;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(std::size_t* dofs,
                             const std::vector<std::size_t>& num_global_entities,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    dofs[3] = offset + c.entity_indices[0][3];
    offset += num_global_entities[0];
    dofs[4] = offset + c.entity_indices[1][0];
    dofs[5] = offset + c.entity_indices[1][1];
    dofs[6] = offset + c.entity_indices[1][2];
    dofs[7] = offset + c.entity_indices[1][3];
    dofs[8] = offset + c.entity_indices[1][4];
    dofs[9] = offset + c.entity_indices[1][5];
    offset += num_global_entities[1];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(std::size_t* dofs,
                                   std::size_t facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 7;
      dofs[5] = 8;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 5;
      dofs[4] = 7;
      dofs[5] = 9;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 6;
      dofs[4] = 8;
      dofs[5] = 9;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(std::size_t* dofs,
                                    std::size_t d, std::size_t i) const
  {
    if (d > 3)
    {
    std::cerr << "*** FFC warning: " << "d is larger than dimension (3)" << std::endl;
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (3)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 5)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (5)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 4;
          break;
        }
      case 1:
        {
          dofs[0] = 5;
          break;
        }
      case 2:
        {
          dofs[0] = 6;
          break;
        }
      case 3:
        {
          dofs[0] = 7;
          break;
        }
      case 4:
        {
          dofs[0] = 8;
          break;
        }
      case 5:
        {
          dofs[0] = 9;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** dof_coordinates,
                                    const double* vertex_coordinates) const
  {
    dof_coordinates[0][0] = vertex_coordinates[0];
    dof_coordinates[0][1] = vertex_coordinates[1];
    dof_coordinates[0][2] = vertex_coordinates[2];
    dof_coordinates[1][0] = vertex_coordinates[3];
    dof_coordinates[1][1] = vertex_coordinates[4];
    dof_coordinates[1][2] = vertex_coordinates[5];
    dof_coordinates[2][0] = vertex_coordinates[6];
    dof_coordinates[2][1] = vertex_coordinates[7];
    dof_coordinates[2][2] = vertex_coordinates[8];
    dof_coordinates[3][0] = vertex_coordinates[9];
    dof_coordinates[3][1] = vertex_coordinates[10];
    dof_coordinates[3][2] = vertex_coordinates[11];
    dof_coordinates[4][0] = 0.5*vertex_coordinates[6] + 0.5*vertex_coordinates[9];
    dof_coordinates[4][1] = 0.5*vertex_coordinates[7] + 0.5*vertex_coordinates[10];
    dof_coordinates[4][2] = 0.5*vertex_coordinates[8] + 0.5*vertex_coordinates[11];
    dof_coordinates[5][0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[9];
    dof_coordinates[5][1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[10];
    dof_coordinates[5][2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[11];
    dof_coordinates[6][0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
    dof_coordinates[6][1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
    dof_coordinates[6][2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
    dof_coordinates[7][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[9];
    dof_coordinates[7][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[10];
    dof_coordinates[7][2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[11];
    dof_coordinates[8][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
    dof_coordinates[8][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
    dof_coordinates[8][2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
    dof_coordinates[9][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
    dof_coordinates[9][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
    dof_coordinates[9][2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual std::size_t num_sub_dofmaps() const
  {
    return 2;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new vectorlaplacegradcurl_dofmap_2();
        break;
      }
    case 1:
      {
        return new vectorlaplacegradcurl_dofmap_3();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new vectorlaplacegradcurl_dofmap_4();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class vectorlaplacegradcurl_cell_integral_0_otherwise: public ufc::cell_integral
{
public:

  /// Constructor
  vectorlaplacegradcurl_cell_integral_0_otherwise() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vectorlaplacegradcurl_cell_integral_0_otherwise()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const double* vertex_coordinates,
                               int cell_orientation) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Cell volume
    
    // Compute circumradius
    
    
    // Facet area (divide by two because 'det' is scaled by area of reference triangle)
    
    // Array of quadrature weights.
    static const double W4[4] = {0.041666667, 0.041666667, 0.041666667, 0.041666667};
    // Quadrature points on the UFC reference element: (0.5854102, 0.1381966, 0.1381966), (0.1381966, 0.5854102, 0.1381966), (0.1381966, 0.1381966, 0.5854102), (0.1381966, 0.1381966, 0.1381966)
    
    // Value of basis functions at quadrature points.
    static const double FE0_C0[4][10] = \
    {{0.1381966, 0.5854102, 0.1381966, 0.1381966, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.1381966, 0.1381966, 0.5854102, 0.1381966, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.1381966, 0.1381966, 0.1381966, 0.5854102, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.5854102, 0.1381966, 0.1381966, 0.1381966, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE0_C0_D001[4][10] = \
    {{-1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE0_C0_D010[4][10] = \
    {{-1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE0_C0_D100[4][10] = \
    {{-1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE0_C1[4][10] = \
    {{0.0, 0.0, 0.0, 0.0, 0.0, -0.1381966, -0.1381966, 0.1381966, 0.1381966, 0.7236068},
    {0.0, 0.0, 0.0, 0.0, 0.0, -0.1381966, -0.5854102, 0.1381966, 0.5854102, 0.2763932},
    {0.0, 0.0, 0.0, 0.0, 0.0, -0.5854102, -0.1381966, 0.5854102, 0.1381966, 0.2763932},
    {0.0, 0.0, 0.0, 0.0, 0.0, -0.1381966, -0.1381966, 0.1381966, 0.1381966, 0.7236068}};
    
    static const double FE0_C1_D001[4][10] = \
    {{0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0, -1.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0, -1.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0, -1.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0, -1.0}};
    
    static const double FE0_C1_D010[4][10] = \
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, -1.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, -1.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, -1.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, -1.0}};
    
    static const double FE0_C1_D100[4][10] = \
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE0_C2[4][10] = \
    {{0.0, 0.0, 0.0, 0.0, -0.1381966, 0.0, 0.5854102, 0.1381966, 0.2763932, 0.5854102},
    {0.0, 0.0, 0.0, 0.0, -0.1381966, 0.0, 0.1381966, 0.1381966, 0.7236068, 0.1381966},
    {0.0, 0.0, 0.0, 0.0, -0.5854102, 0.0, 0.1381966, 0.5854102, 0.2763932, 0.1381966},
    {0.0, 0.0, 0.0, 0.0, -0.1381966, 0.0, 0.1381966, 0.1381966, 0.7236068, 0.1381966}};
    
    static const double FE0_C2_D001[4][10] = \
    {{0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 1.0, -1.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 1.0, -1.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 1.0, -1.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 1.0, -1.0, 0.0}};
    
    static const double FE0_C2_D100[4][10] = \
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -1.0, 1.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -1.0, 1.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -1.0, 1.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -1.0, 1.0}};
    
    static const double FE0_C3[4][10] = \
    {{0.0, 0.0, 0.0, 0.0, 0.1381966, 0.5854102, 0.0, 0.2763932, 0.1381966, 0.5854102},
    {0.0, 0.0, 0.0, 0.0, 0.5854102, 0.1381966, 0.0, 0.2763932, 0.5854102, 0.1381966},
    {0.0, 0.0, 0.0, 0.0, 0.1381966, 0.1381966, 0.0, 0.7236068, 0.1381966, 0.1381966},
    {0.0, 0.0, 0.0, 0.0, 0.1381966, 0.1381966, 0.0, 0.7236068, 0.1381966, 0.1381966}};
    
    static const double FE0_C3_D010[4][10] = \
    {{0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, -1.0, 1.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, -1.0, 1.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, -1.0, 1.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, -1.0, 1.0, 0.0}};
    
    static const double FE0_C3_D100[4][10] = \
    {{0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -1.0, 0.0, 1.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -1.0, 0.0, 1.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -1.0, 0.0, 1.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -1.0, 0.0, 1.0}};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 100; r++)
    {
      A[r] = 0.0;
    }// end loop over 'r'
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', False), ('ignore ones', False), ('ignore zero tables', False), ('optimisation', False), ('remove zero terms', False)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 162800
    for (unsigned int ip = 0; ip < 4; ip++)
    {
      
      // Number of operations for primary indices: 40700
      for (unsigned int j = 0; j < 10; j++)
      {
        for (unsigned int k = 0; k < 10; k++)
        {
          // Number of operations to compute entry: 407
          A[j*10 + k] += (((((K[2]*K[0]*FE0_C1_D100[ip][j] + K[2]*K[3]*FE0_C2_D100[ip][j] + K[2]*K[6]*FE0_C3_D100[ip][j] + K[5]*K[0]*FE0_C1_D010[ip][j] + K[5]*K[3]*FE0_C1_D100[ip][j] + K[5]*K[6]*FE0_C3_D010[ip][j] + K[8]*K[0]*FE0_C1_D001[ip][j] + K[8]*K[3]*FE0_C2_D001[ip][j] + K[8]*K[6]*FE0_C1_D100[ip][j]) + ((K[0]*K[2]*FE0_C1_D100[ip][j] + K[0]*K[5]*FE0_C2_D100[ip][j] + K[0]*K[8]*FE0_C3_D100[ip][j] + K[3]*K[2]*FE0_C1_D010[ip][j] + K[3]*K[5]*FE0_C1_D100[ip][j] + K[3]*K[8]*FE0_C3_D010[ip][j] + K[6]*K[2]*FE0_C1_D001[ip][j] + K[6]*K[5]*FE0_C2_D001[ip][j] + K[6]*K[8]*FE0_C1_D100[ip][j]))*(-1.0)))*(((K[2]*K[0]*FE0_C1_D100[ip][k] + K[2]*K[3]*FE0_C2_D100[ip][k] + K[2]*K[6]*FE0_C3_D100[ip][k] + K[5]*K[0]*FE0_C1_D010[ip][k] + K[5]*K[3]*FE0_C1_D100[ip][k] + K[5]*K[6]*FE0_C3_D010[ip][k] + K[8]*K[0]*FE0_C1_D001[ip][k] + K[8]*K[3]*FE0_C2_D001[ip][k] + K[8]*K[6]*FE0_C1_D100[ip][k]) + ((K[0]*K[2]*FE0_C1_D100[ip][k] + K[0]*K[5]*FE0_C2_D100[ip][k] + K[0]*K[8]*FE0_C3_D100[ip][k] + K[3]*K[2]*FE0_C1_D010[ip][k] + K[3]*K[5]*FE0_C1_D100[ip][k] + K[3]*K[8]*FE0_C3_D010[ip][k] + K[6]*K[2]*FE0_C1_D001[ip][k] + K[6]*K[5]*FE0_C2_D001[ip][k] + K[6]*K[8]*FE0_C1_D100[ip][k]))*(-1.0))) + (((K[1]*K[2]*FE0_C1_D100[ip][j] + K[1]*K[5]*FE0_C2_D100[ip][j] + K[1]*K[8]*FE0_C3_D100[ip][j] + K[4]*K[2]*FE0_C1_D010[ip][j] + K[4]*K[5]*FE0_C1_D100[ip][j] + K[4]*K[8]*FE0_C3_D010[ip][j] + K[7]*K[2]*FE0_C1_D001[ip][j] + K[7]*K[5]*FE0_C2_D001[ip][j] + K[7]*K[8]*FE0_C1_D100[ip][j]) + ((K[2]*K[1]*FE0_C1_D100[ip][j] + K[2]*K[4]*FE0_C2_D100[ip][j] + K[2]*K[7]*FE0_C3_D100[ip][j] + K[5]*K[1]*FE0_C1_D010[ip][j] + K[5]*K[4]*FE0_C1_D100[ip][j] + K[5]*K[7]*FE0_C3_D010[ip][j] + K[8]*K[1]*FE0_C1_D001[ip][j] + K[8]*K[4]*FE0_C2_D001[ip][j] + K[8]*K[7]*FE0_C1_D100[ip][j]))*(-1.0)))*(((K[1]*K[2]*FE0_C1_D100[ip][k] + K[1]*K[5]*FE0_C2_D100[ip][k] + K[1]*K[8]*FE0_C3_D100[ip][k] + K[4]*K[2]*FE0_C1_D010[ip][k] + K[4]*K[5]*FE0_C1_D100[ip][k] + K[4]*K[8]*FE0_C3_D010[ip][k] + K[7]*K[2]*FE0_C1_D001[ip][k] + K[7]*K[5]*FE0_C2_D001[ip][k] + K[7]*K[8]*FE0_C1_D100[ip][k]) + ((K[2]*K[1]*FE0_C1_D100[ip][k] + K[2]*K[4]*FE0_C2_D100[ip][k] + K[2]*K[7]*FE0_C3_D100[ip][k] + K[5]*K[1]*FE0_C1_D010[ip][k] + K[5]*K[4]*FE0_C1_D100[ip][k] + K[5]*K[7]*FE0_C3_D010[ip][k] + K[8]*K[1]*FE0_C1_D001[ip][k] + K[8]*K[4]*FE0_C2_D001[ip][k] + K[8]*K[7]*FE0_C1_D100[ip][k]))*(-1.0))) + ((((K[1]*K[0]*FE0_C1_D100[ip][j] + K[1]*K[3]*FE0_C2_D100[ip][j] + K[1]*K[6]*FE0_C3_D100[ip][j] + K[4]*K[0]*FE0_C1_D010[ip][j] + K[4]*K[3]*FE0_C1_D100[ip][j] + K[4]*K[6]*FE0_C3_D010[ip][j] + K[7]*K[0]*FE0_C1_D001[ip][j] + K[7]*K[3]*FE0_C2_D001[ip][j] + K[7]*K[6]*FE0_C1_D100[ip][j]))*(-1.0) + (K[0]*K[1]*FE0_C1_D100[ip][j] + K[0]*K[4]*FE0_C2_D100[ip][j] + K[0]*K[7]*FE0_C3_D100[ip][j] + K[3]*K[1]*FE0_C1_D010[ip][j] + K[3]*K[4]*FE0_C1_D100[ip][j] + K[3]*K[7]*FE0_C3_D010[ip][j] + K[6]*K[1]*FE0_C1_D001[ip][j] + K[6]*K[4]*FE0_C2_D001[ip][j] + K[6]*K[7]*FE0_C1_D100[ip][j])))*(((K[0]*K[1]*FE0_C1_D100[ip][k] + K[0]*K[4]*FE0_C2_D100[ip][k] + K[0]*K[7]*FE0_C3_D100[ip][k] + K[3]*K[1]*FE0_C1_D010[ip][k] + K[3]*K[4]*FE0_C1_D100[ip][k] + K[3]*K[7]*FE0_C3_D010[ip][k] + K[6]*K[1]*FE0_C1_D001[ip][k] + K[6]*K[4]*FE0_C2_D001[ip][k] + K[6]*K[7]*FE0_C1_D100[ip][k]) + ((K[1]*K[0]*FE0_C1_D100[ip][k] + K[1]*K[3]*FE0_C2_D100[ip][k] + K[1]*K[6]*FE0_C3_D100[ip][k] + K[4]*K[0]*FE0_C1_D010[ip][k] + K[4]*K[3]*FE0_C1_D100[ip][k] + K[4]*K[6]*FE0_C3_D010[ip][k] + K[7]*K[0]*FE0_C1_D001[ip][k] + K[7]*K[3]*FE0_C2_D001[ip][k] + K[7]*K[6]*FE0_C1_D100[ip][k]))*(-1.0)))) + ((FE0_C0[ip][j]*FE0_C0[ip][k] + ((((K[1]*FE0_C0_D100[ip][j] + K[4]*FE0_C0_D010[ip][j] + K[7]*FE0_C0_D001[ip][j]))*((K[1]*FE0_C1[ip][k] + K[4]*FE0_C2[ip][k] + K[7]*FE0_C3[ip][k])) + ((K[0]*FE0_C0_D100[ip][j] + K[3]*FE0_C0_D010[ip][j] + K[6]*FE0_C0_D001[ip][j]))*((K[0]*FE0_C1[ip][k] + K[3]*FE0_C2[ip][k] + K[6]*FE0_C3[ip][k])) + ((K[2]*FE0_C0_D100[ip][j] + K[5]*FE0_C0_D010[ip][j] + K[8]*FE0_C0_D001[ip][j]))*((K[2]*FE0_C1[ip][k] + K[5]*FE0_C2[ip][k] + K[8]*FE0_C3[ip][k]))))*(-1.0)) + (((K[0]*FE0_C0_D100[ip][k] + K[3]*FE0_C0_D010[ip][k] + K[6]*FE0_C0_D001[ip][k]))*((K[0]*FE0_C1[ip][j] + K[3]*FE0_C2[ip][j] + K[6]*FE0_C3[ip][j])) + ((K[2]*FE0_C0_D100[ip][k] + K[5]*FE0_C0_D010[ip][k] + K[8]*FE0_C0_D001[ip][k]))*((K[2]*FE0_C1[ip][j] + K[5]*FE0_C2[ip][j] + K[8]*FE0_C3[ip][j])) + ((K[1]*FE0_C0_D100[ip][k] + K[4]*FE0_C0_D010[ip][k] + K[7]*FE0_C0_D001[ip][k]))*((K[1]*FE0_C1[ip][j] + K[4]*FE0_C2[ip][j] + K[7]*FE0_C3[ip][j])))))*W4[ip]*det;
        }// end loop over 'k'
      }// end loop over 'j'
    }// end loop over 'ip'
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class vectorlaplacegradcurl_cell_integral_1_otherwise: public ufc::cell_integral
{
public:

  /// Constructor
  vectorlaplacegradcurl_cell_integral_1_otherwise() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vectorlaplacegradcurl_cell_integral_1_otherwise()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const double* vertex_coordinates,
                               int cell_orientation) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Cell volume
    
    // Compute circumradius
    
    
    // Facet area (divide by two because 'det' is scaled by area of reference triangle)
    
    // Array of quadrature weights.
    static const double W5[5] = {-0.13333333, 0.075, 0.075, 0.075, 0.075};
    // Quadrature points on the UFC reference element: (0.25, 0.25, 0.25), (0.5, 0.16666667, 0.16666667), (0.16666667, 0.5, 0.16666667), (0.16666667, 0.16666667, 0.5), (0.16666667, 0.16666667, 0.16666667)
    
    // Value of basis functions at quadrature points.
    static const double FE0_C0[5][30] = \
    {{-0.125, -0.125, -0.125, -0.125, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-0.11111111, 0.0, -0.11111111, -0.11111111, 0.11111111, 0.33333333, 0.33333333, 0.11111111, 0.11111111, 0.33333333, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-0.11111111, -0.11111111, 0.0, -0.11111111, 0.33333333, 0.11111111, 0.33333333, 0.11111111, 0.33333333, 0.11111111, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-0.11111111, -0.11111111, -0.11111111, 0.0, 0.33333333, 0.33333333, 0.11111111, 0.33333333, 0.11111111, 0.11111111, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, -0.11111111, -0.11111111, -0.11111111, 0.11111111, 0.11111111, 0.11111111, 0.33333333, 0.33333333, 0.33333333, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE0_C1[5][30] = \
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.125, -0.125, -0.125, -0.125, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.11111111, 0.0, -0.11111111, -0.11111111, 0.11111111, 0.33333333, 0.33333333, 0.11111111, 0.11111111, 0.33333333, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.11111111, -0.11111111, 0.0, -0.11111111, 0.33333333, 0.11111111, 0.33333333, 0.11111111, 0.33333333, 0.11111111, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.11111111, -0.11111111, -0.11111111, 0.0, 0.33333333, 0.33333333, 0.11111111, 0.33333333, 0.11111111, 0.11111111, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.11111111, -0.11111111, -0.11111111, 0.11111111, 0.11111111, 0.11111111, 0.33333333, 0.33333333, 0.33333333, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE0_C2[5][30] = \
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.125, -0.125, -0.125, -0.125, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.11111111, 0.0, -0.11111111, -0.11111111, 0.11111111, 0.33333333, 0.33333333, 0.11111111, 0.11111111, 0.33333333},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.11111111, -0.11111111, 0.0, -0.11111111, 0.33333333, 0.11111111, 0.33333333, 0.11111111, 0.33333333, 0.11111111},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.11111111, -0.11111111, -0.11111111, 0.0, 0.33333333, 0.33333333, 0.11111111, 0.33333333, 0.11111111, 0.11111111},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.11111111, -0.11111111, -0.11111111, 0.11111111, 0.11111111, 0.11111111, 0.33333333, 0.33333333, 0.33333333}};
    
    static const double FE1_C1[5][10] = \
    {{0.0, 0.0, 0.0, 0.0, 0.0, -0.25, -0.25, 0.25, 0.25, 0.5},
    {0.0, 0.0, 0.0, 0.0, 0.0, -0.16666667, -0.16666667, 0.16666667, 0.16666667, 0.66666667},
    {0.0, 0.0, 0.0, 0.0, 0.0, -0.16666667, -0.5, 0.16666667, 0.5, 0.33333333},
    {0.0, 0.0, 0.0, 0.0, 0.0, -0.5, -0.16666667, 0.5, 0.16666667, 0.33333333},
    {0.0, 0.0, 0.0, 0.0, 0.0, -0.16666667, -0.16666667, 0.16666667, 0.16666667, 0.66666667}};
    
    static const double FE1_C2[5][10] = \
    {{0.0, 0.0, 0.0, 0.0, -0.25, 0.0, 0.25, 0.25, 0.5, 0.25},
    {0.0, 0.0, 0.0, 0.0, -0.16666667, 0.0, 0.5, 0.16666667, 0.33333333, 0.5},
    {0.0, 0.0, 0.0, 0.0, -0.16666667, 0.0, 0.16666667, 0.16666667, 0.66666667, 0.16666667},
    {0.0, 0.0, 0.0, 0.0, -0.5, 0.0, 0.16666667, 0.5, 0.33333333, 0.16666667},
    {0.0, 0.0, 0.0, 0.0, -0.16666667, 0.0, 0.16666667, 0.16666667, 0.66666667, 0.16666667}};
    
    static const double FE1_C3[5][10] = \
    {{0.0, 0.0, 0.0, 0.0, 0.25, 0.25, 0.0, 0.5, 0.25, 0.25},
    {0.0, 0.0, 0.0, 0.0, 0.16666667, 0.5, 0.0, 0.33333333, 0.16666667, 0.5},
    {0.0, 0.0, 0.0, 0.0, 0.5, 0.16666667, 0.0, 0.33333333, 0.5, 0.16666667},
    {0.0, 0.0, 0.0, 0.0, 0.16666667, 0.16666667, 0.0, 0.66666667, 0.16666667, 0.16666667},
    {0.0, 0.0, 0.0, 0.0, 0.16666667, 0.16666667, 0.0, 0.66666667, 0.16666667, 0.16666667}};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 10; r++)
    {
      A[r] = 0.0;
    }// end loop over 'r'
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', False), ('ignore ones', False), ('ignore zero tables', False), ('optimisation', False), ('remove zero terms', False)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 2050
    for (unsigned int ip = 0; ip < 5; ip++)
    {
      
      // Coefficient declarations.
      double F0 = 0.0;
      double F1 = 0.0;
      double F2 = 0.0;
      
      // Total number of operations to compute function values = 180
      for (unsigned int r = 0; r < 30; r++)
      {
        F0 += FE0_C0[ip][r]*w[0][r];
        F1 += FE0_C1[ip][r]*w[0][r];
        F2 += FE0_C2[ip][r]*w[0][r];
      }// end loop over 'r'
      
      // Number of operations for primary indices: 230
      for (unsigned int j = 0; j < 10; j++)
      {
        // Number of operations to compute entry: 23
        A[j] += (((K[0]*FE1_C1[ip][j] + K[3]*FE1_C2[ip][j] + K[6]*FE1_C3[ip][j]))*F0 + ((K[1]*FE1_C1[ip][j] + K[4]*FE1_C2[ip][j] + K[7]*FE1_C3[ip][j]))*F1 + ((K[2]*FE1_C1[ip][j] + K[5]*FE1_C2[ip][j] + K[8]*FE1_C3[ip][j]))*F2)*W5[ip]*det;
      }// end loop over 'j'
    }// end loop over 'ip'
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class vectorlaplacegradcurl_form_0: public ufc::form
{
public:

  /// Constructor
  vectorlaplacegradcurl_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vectorlaplacegradcurl_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "21638a5f016dc70548307d171bfaa2484743db799a21068da88edc43dee512fba9b99dee5dee5bc59f1536e4db963d19c848e1811201577c56afe2171bd2396f";
  }

  /// Return the rank of the global tensor (r)
  virtual std::size_t rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual std::size_t num_coefficients() const
  {
    return 0;
  }

  /// Return the number of cell domains
  virtual std::size_t num_cell_domains() const
  {
    return 0;
  }

  /// Return the number of exterior facet domains
  virtual std::size_t num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual std::size_t num_interior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of point domains
  virtual std::size_t num_point_domains() const
  {
    return 0;
  }

  /// Return whether the form has any cell integrals
  virtual bool has_cell_integrals() const
  {
    return true;
  }

  /// Return whether the form has any exterior facet integrals
  virtual bool has_exterior_facet_integrals() const
  {
    return false;
  }

  /// Return whether the form has any interior facet integrals
  virtual bool has_interior_facet_integrals() const
  {
    return false;
  }

  /// Return whether the form has any point integrals
  virtual bool has_point_integrals() const
  {
    return false;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new vectorlaplacegradcurl_finite_element_4();
        break;
      }
    case 1:
      {
        return new vectorlaplacegradcurl_finite_element_4();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new vectorlaplacegradcurl_dofmap_4();
        break;
      }
    case 1:
      {
        return new vectorlaplacegradcurl_dofmap_4();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new point integral on sub domain i
  virtual ufc::point_integral* create_point_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new cell integral on everywhere else
  virtual ufc::cell_integral* create_default_cell_integral() const
  {
    return new vectorlaplacegradcurl_cell_integral_0_otherwise();
  }

  /// Create a new exterior facet integral on everywhere else
  virtual ufc::exterior_facet_integral* create_default_exterior_facet_integral() const
  {
    return 0;
  }

  /// Create a new interior facet integral on everywhere else
  virtual ufc::interior_facet_integral* create_default_interior_facet_integral() const
  {
    return 0;
  }

  /// Create a new point integral on everywhere else
  virtual ufc::point_integral* create_default_point_integral() const
  {
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class vectorlaplacegradcurl_form_1: public ufc::form
{
public:

  /// Constructor
  vectorlaplacegradcurl_form_1() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vectorlaplacegradcurl_form_1()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "6fbff25224d7378af49ccd6fbc6eb19764b9e3f4cec945adedbfdf5b96d55a0b26799ed50a938a1b82aac6615cd9cfd3890ddd923aac7664fd5bb15bd107f1c1";
  }

  /// Return the rank of the global tensor (r)
  virtual std::size_t rank() const
  {
    return 1;
  }

  /// Return the number of coefficients (n)
  virtual std::size_t num_coefficients() const
  {
    return 1;
  }

  /// Return the number of cell domains
  virtual std::size_t num_cell_domains() const
  {
    return 0;
  }

  /// Return the number of exterior facet domains
  virtual std::size_t num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual std::size_t num_interior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of point domains
  virtual std::size_t num_point_domains() const
  {
    return 0;
  }

  /// Return whether the form has any cell integrals
  virtual bool has_cell_integrals() const
  {
    return true;
  }

  /// Return whether the form has any exterior facet integrals
  virtual bool has_exterior_facet_integrals() const
  {
    return false;
  }

  /// Return whether the form has any interior facet integrals
  virtual bool has_interior_facet_integrals() const
  {
    return false;
  }

  /// Return whether the form has any point integrals
  virtual bool has_point_integrals() const
  {
    return false;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new vectorlaplacegradcurl_finite_element_4();
        break;
      }
    case 1:
      {
        return new vectorlaplacegradcurl_finite_element_1();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new vectorlaplacegradcurl_dofmap_4();
        break;
      }
    case 1:
      {
        return new vectorlaplacegradcurl_dofmap_1();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new point integral on sub domain i
  virtual ufc::point_integral* create_point_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new cell integral on everywhere else
  virtual ufc::cell_integral* create_default_cell_integral() const
  {
    return new vectorlaplacegradcurl_cell_integral_1_otherwise();
  }

  /// Create a new exterior facet integral on everywhere else
  virtual ufc::exterior_facet_integral* create_default_exterior_facet_integral() const
  {
    return 0;
  }

  /// Create a new interior facet integral on everywhere else
  virtual ufc::interior_facet_integral* create_default_interior_facet_integral() const
  {
    return 0;
  }

  /// Create a new point integral on everywhere else
  virtual ufc::point_integral* create_default_point_integral() const
  {
    return 0;
  }

};

#endif
