/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Jul  5 21:56:51 EDT 2003 */

#include "codelet-rdft.h"

/* Generated by: /homee/stevenj/cvs/fftw3.0.1/genfft/gen_hc2hc -compact -variables 4 -n 3 -dit -name hf_3 -include hf.h */

/*
 * This function contains 16 FP additions, 12 FP multiplications,
 * (or, 10 additions, 6 multiplications, 6 fused multiply/add),
 * 15 stack variables, and 12 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.9 2003/04/17 19:25:50 athena Exp $
 */

#include "hf.h"

static const R *hf_3(R *rio, R *iio, const R *W, stride ios, int m, int dist)
{
     DK(KP866025403, +0.866025403784438646763723170752936183471402627);
     DK(KP500000000, +0.500000000000000000000000000000000000000000000);
     int i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 4) {
	  E T1, Ti, T6, Te, Tb, Tf, Tc, Th;
	  T1 = rio[0];
	  Ti = iio[-WS(ios, 2)];
	  {
	       E T3, T5, T2, T4;
	       T3 = rio[WS(ios, 1)];
	       T5 = iio[-WS(ios, 1)];
	       T2 = W[0];
	       T4 = W[1];
	       T6 = FMA(T2, T3, T4 * T5);
	       Te = FNMS(T4, T3, T2 * T5);
	  }
	  {
	       E T8, Ta, T7, T9;
	       T8 = rio[WS(ios, 2)];
	       Ta = iio[0];
	       T7 = W[2];
	       T9 = W[3];
	       Tb = FMA(T7, T8, T9 * Ta);
	       Tf = FNMS(T9, T8, T7 * Ta);
	  }
	  Tc = T6 + Tb;
	  Th = Te + Tf;
	  rio[0] = T1 + Tc;
	  iio[0] = Th + Ti;
	  {
	       E Td, Tg, Tj, Tk;
	       Td = FNMS(KP500000000, Tc, T1);
	       Tg = KP866025403 * (Te - Tf);
	       iio[-WS(ios, 2)] = Td - Tg;
	       rio[WS(ios, 1)] = Td + Tg;
	       Tj = KP866025403 * (Tb - T6);
	       Tk = FNMS(KP500000000, Th, Ti);
	       rio[WS(ios, 2)] = Tj - Tk;
	       iio[-WS(ios, 1)] = Tj + Tk;
	  }
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_FULL, 0, 3},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 3, "hf_3", twinstr, {10, 6, 6, 0}, &GENUS, 0, 0, 0 };

void X(codelet_hf_3) (planner *p) {
     X(khc2hc_dit_register) (p, hf_3, &desc);
}
