#!/bin/sh
#
#	fhist - file history and comparison tools
#	Copyright (C) 1993-1995, 1998, 2000, 2003, 2004 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the fhist functionality
#

work=/tmp/$$
PAGER=cat
export PAGER
LINES=24
export LINES
COLS=80
export COLS

fail()
{
	set +x
	echo FAILED test of the fhist functionality 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	echo PASSED 1>&2
	cd $here
	rm -rf $work
	exit 0
}
trap "fail" 1 2 3 15

#
# use the built-in error messages
#
FHIST_MESSAGE_LIBRARY=$$work/no-such-dir
export FHIST_MESSAGE_LIBRARY
unset LANG
unset LANGUAGE

here=`pwd`
if test $? -ne 0 ; then exit 1; fi
mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

if [ "$1" != "" ]; then bin=$here/$1/bin; else bin=$here/bin; fi

#
# create the history storage directory
#
mkdir FHIST
if test $? -ne 0 ; then fail; fi

#
# create a file to chew on
#
cat > fred << 'fubar'
This is just a test
fubar

#
# create the history
#
$bin/fhist fred -creat -rem > test.out 2>&1
if test $? -ne 0 ; then cat test.out; fail; fi

#
# now do another rev
#
cat > fred << 'fubar'
This is just a test
to see if
fubar

#
# add to the history
#
$bin/fhist fred -upd -rem > test.out 2>&1
if test $? -ne 0 ; then cat test.out; fail; fi

#
# list the history
#
$bin/fhist fred -list > test.out 2>&1
if test $? -ne 0 ; then cat test.out; fail; fi

#
# name this rev
#
$bin/fhist fred -name two > test.out 2>&1
if test $? -ne 0 ; then cat test.out; fail; fi

#
# now do another rev
#
cat > fred3 << 'fubar'
This is just a test
to see if
everything works
fubar

#
# add to the history
#
$bin/fhist fred -cu -r -i fred3 > test.out 2>&1
if test $? -ne 0 ; then cat test.out; fail; fi

#
# extract the older rev
#	and make sure it is ok
#
$bin/fhist fred -e 2 -o fred2.maybe > test.out 2>&1
if test $? -ne 0 ; then cat test.out; fail; fi
diff fred fred2.maybe
if test $? -ne 0 ; then fail; fi

#
# difference
#
cat > test.ok << 'fubar'
TOTALS: 1 inserted  0 deleted  1 matched

******************** INSERT [A 2, B 2]:
to see if
fubar
if test $? -ne 0 ; then fail; fi
$bin/fhist fred -d oldest 2 -o test.out > test.out 2>&1
if test $? -ne 0 ; then cat test.out; fail; fi
sed '1,2d' < test.out > test.out2
if test $? -ne 0 ; then fail; fi
diff test.ok test.out2
if test $? -ne 0 ; then fail; fi

#
# prune
#
$bin/fhist fred -prune 2 -fu > test.out 2>&1
if test $? -ne 0 ; then cat test.out; fail; fi
$bin/fhist fred -list > test.out 2>&1
if test $? -ne 0 ; then cat test.out; fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
