<?php
/*
    FibuSQL 0.4.1  -  (c) 2003 Martin Pitt <martin@piware.de>

    This software is protected by the GNU General Public License (see
    file COPYING).

    Backend module: db administration (initialisation, import, export)
    These functions return null on success or DB::Error object on failure 
*/

include_once 'backend/base.inc';

# initialize database: drop old tables, create tables, initialize root account
# returns null on success or DB::Error object on DB failure
function init_db()
{
    global $db;
    global $LANG_balsheet;

    # drop old tables that possibly exist
    $db->query( 'drop table balances' );
    $db->query( 'drop table journal' );
    $db->query( 'drop table repeated' );
    $db->query( 'drop table accounts' );

    $res = $db->query(
	"create table accounts ( account smallint not null, ".
	"parent smallint not null, acronym character(15), ".
	"name character varying(200) not null, type smallint not null,".
	"primary key( account ), " .
	"foreign key (parent) references accounts( account ) )" );
    if( DB::isError( $res ) ) return $res;

    $res = $db->query(
	"create table journal ( id integer not null, ".
	"debit_acc smallint not null, credit_acc smallint not null, ".	    
	"value numeric (9,2) not null, receipt integer, ".
	"description character varying(255) not null, ".
	"time timestamp not null, ".
	"primary key (id), ".
	"foreign key (debit_acc) references accounts (account), ".
	"foreign key (credit_acc) references accounts (account) )" );
    if( DB::isError( $res ) ) return $res;

    $res = $db->query(
	"create table repeated( id integer not null, ".
	"debit_acc smallint not null, credit_acc smallint not null, ".
	"value numeric (9,2) not null, receipt integer, ".
	"description character varying(255) not null, ".
	"nextDue timestamp not null, repDays smallint, ".
	"repMonths smallint, primary key (id), ".
	"foreign key (debit_acc) references accounts (account), ".
	"foreign key (credit_acc) references accounts (account) )" );
    if( DB::isError( $res ) ) return $res;

    $res = $db->query(
	"create table balances( account integer not null, ".
	"bal numeric (9,2) not null, ".
	"primary key (account) )" );
    if( DB::isError( $res ) ) return $res;

    $res = $db->query( "insert into accounts values( 0, 0, null, '$LANG_balsheet', 0)" );
    if( DB::isError( $res ) ) return $res;

    return null;
}

?>
