powder_dict = {'_pd_block_[pd]': '<pre><h2>_pd_block_[pd]</h2> _pd_block_id is used to assign a unique ID code '
                   'to a data block.\n'
                   ' This code is then used for references between different blocks\n'
                   ' (see _pd_block_diffractogram_id, _pd_calib_std_external_block_id\n'
                   ' and _pd_phase_block_id).\n'
                   '\n'
                   ' Note that a data block may contain only a single diffraction\n'
                   ' data set or information about a single crystalline phase. \n'
                   ' However, a single diffraction measurement may yield structural \n'
                   ' information on more than one phase, or a single structure \n'
                   ' determination may use more than one data set. Alternatively, \n'
                   ' results from a single data set, such as calibration parameters \n'
                   ' from measurements of a standard, may be used for many subsequent \n'
                   ' analyses. Through use of the ID code, a reference made between \n'
                   ' data sets may be preserved when the file is exported from the \n'
                   ' laboratory from which the CIF originated.\n'
                   '\n'
                   ' The ID code assigned to each data block should be unique with\n'
                   ' respect to an ID code assigned for any other data block in the\n'
                   ' world. The naming scheme chosen for the block-ID format is\n'
                   ' designed to ensure uniqueness.\n'
                   '\n'
                   ' It is the responsibility of a data archive site or local\n'
                   " laboratory to create a catalogue of block ID's if that site\n"
                   ' wishes to resolve these references.</pre>',
 '_pd_block_diffractogram_id': '<pre><h2>_pd_block_diffractogram_id</h2> A block ID code (see '
                               '_pd_block_id) that identifies\n'
                               ' diffraction data contained in a data block other\n'
                               ' than the current block. This will occur most frequently\n'
                               ' when more than one set of diffraction data\n'
                               ' is used for a structure determination. The data\n'
                               ' block containing the diffraction data will contain\n'
                               ' a _pd_block_id code matching the code in\n'
                               ' _pd_block_diffractogram_id.</pre>',
 '_pd_block_id': '<pre><h2>_pd_block_id</h2> Used to assign a unique character string to a block.\n'
                 ' Note that this code is not intended to be parsed; the\n'
                 ' concatenation of several strings is used in order to\n'
                 ' generate a string that can reasonably be expected to\n'
                 ' be unique.\n'
                 '\n'
                 ' This code is assigned by the originator of the data set and\n'
                 ' is used for references between different CIF blocks.\n'
                 ' The ID will normally be created when the block is first\n'
                 ' created. It is possible to loop more than one ID for a\n'
                 ' block: if changes or additions are made to the\n'
                 ' block later, a new ID may be assigned, but the original name\n'
                 ' should be retained.\n'
                 '\n'
                 ' The format for the ID code is:\n'
                 '   &lt;date-time&gt;|&lt;block_name&gt;|&lt;creator_name&gt;|&lt;instr_name&gt;\n'
                 '\n'
                 '  &lt;date-time&gt;    is the date and time the CIF was created\n'
                 '                 or modified.\n'
                 '\n'
                 '  &lt;block_name&gt;   is an arbitrary name assigned by the\n'
                 '                 originator of the data set. It will\n'
                 '                 usually match the name of the phase\n'
                 '                 and possibly the name of the current CIF\n'
                 '                 data block (i.e. the string xxxx in a\n'
                 '                 data_xxxx identifier). It may be a sample name.\n'
                 '\n'
                 '  &lt;creator_name&gt; is the name of the person who measured the\n'
                 '                 diffractogram, or prepared or modified the CIF.\n'
                 '\n'
                 '  &lt;instr_name&gt;  is a unique name (as far as possible) for\n'
                 '                 the data-collection instrument, preferably\n'
                 '                 containing the instrument serial number for\n'
                 '                 commercial instruments. It is also possible to\n'
                 '                 use the Internet name or address for the\n'
                 '                 instrument computer as a unique name.\n'
                 '\n'
                 ' As blocks are created in a CIF, the original sample identifier\n'
                 ' (i.e. &lt;block_name&gt;) should be retained, but the &lt;creator_name&gt;\n'
                 ' may be changed and the &lt;date-time&gt; will always change.\n'
                 ' The &lt;date-time&gt; will usually match either the\n'
                 ' _pd_meas_datetime_initiated or the _pd_proc_info_datetime\n'
                 ' entry.\n'
                 '\n'
                 ' Within each section of the code, the following characters\n'
                 ' may be used:\n'
                 '               A-Z a-z 0-9 # &amp; * . : , - _ + / ( ) \\ [ ]\n'
                 '\n'
                 " The sections are separated with vertical rules '|' which are\n"
                 ' not allowed within the sections. Blank spaces may also\n'
                 ' not be used.  Capitalization may be used within the ID code\n'
                 ' but should not be considered significant - searches for\n'
                 ' data-set ID names should be case-insensitive.\n'
                 '\n'
                 ' Date-time entries are in the standard CIF format\n'
                 " 'yyyy-mm-ddThh:mm:ss+zz' Use of seconds and a time zone\n"
                 ' is optional, but use of hours and minutes is strongly\n'
                 ' encouraged as this will help ensure that the ID code is unique.\n'
                 '\n'
                 ' An archive site that wishes to make CIFs available via\n'
                 ' the web may substitute the URL for the file containing the\n'
                 ' appropriate block for the final two sections of the ID\n'
                 ' (&lt;creator_name&gt; and &lt;instr_name&gt;). Note that this should\n'
                 ' not be done unless the archive site is prepared to keep the\n'
                 ' file available online indefinitely.\n'
                 '\n'
                 '<h3>Example:</h3>\n'
                 '1991-15-09T16:54|Si-std|B.Toby|D500#1234-987\n'
                 '1991-15-09T16:54|SEPD7234|B.Toby|SEPD.IPNS.ANL.GOV</pre>',
 '_pd_calc_[pd]': '<pre><h2>_pd_calc_[pd]</h2> This section is used for storing a computed '
                  'diffractogram trace.\n'
                  ' This may be a simulated powder pattern for a material from a\n'
                  ' program such as LAZY/PULVERIX or the computed intensities from a\n'
                  ' Rietveld refinement.</pre>',
 '_pd_calc_intensity_net': '<pre><h2>_pd_calc_intensity_net</h2> Intensity values for a computed '
                           'diffractogram at\n'
                           ' each angle setting. Values should be computed at the\n'
                           ' same locations as the processed diffractogram, and thus\n'
                           ' the numbers of points will be defined by\n'
                           ' _pd_proc_number_of_points and point positions may\n'
                           ' be defined using _pd_proc_2theta_range_ or\n'
                           ' _pd_proc_2theta_corrected.\n'
                           '\n'
                           ' Use _pd_calc_intensity_net if the computed diffractogram\n'
                           ' does not contain background or normalization corrections\n'
                           ' and thus is specified on the same scale as the\n'
                           ' _pd_proc_intensity_net values.\n'
                           '\n'
                           ' Use _pd_calc_intensity_total if the computed diffraction\n'
                           ' pattern includes background or normalization corrections\n'
                           ' (or both) and thus is specified on the same scale as the\n'
                           ' observed intensities (_pd_meas_counts_ or _pd_meas_intensity_).\n'
                           '\n'
                           ' If an observed pattern is included, _pd_calc_intensity_\n'
                           ' should be looped with either _pd_proc_intensity_net,\n'
                           ' _pd_meas_counts_ or _pd_meas_intensity_.</pre>',
 '_pd_calc_intensity_total': '<pre><h2>_pd_calc_intensity_total</h2> Intensity values for a '
                             'computed diffractogram at\n'
                             ' each angle setting. Values should be computed at the\n'
                             ' same locations as the processed diffractogram, and thus\n'
                             ' the numbers of points will be defined by\n'
                             ' _pd_proc_number_of_points and point positions may\n'
                             ' be defined using _pd_proc_2theta_range_ or\n'
                             ' _pd_proc_2theta_corrected.\n'
                             '\n'
                             ' Use _pd_calc_intensity_net if the computed diffractogram\n'
                             ' does not contain background or normalization corrections\n'
                             ' and thus is specified on the same scale as the\n'
                             ' _pd_proc_intensity_net values.\n'
                             '\n'
                             ' Use _pd_calc_intensity_total if the computed diffraction\n'
                             ' pattern includes background or normalization corrections\n'
                             ' (or both) and thus is specified on the same scale as the\n'
                             ' observed intensities (_pd_meas_counts_ or _pd_meas_intensity_).\n'
                             '\n'
                             ' If an observed pattern is included, _pd_calc_intensity_\n'
                             ' should be looped with either _pd_proc_intensity_net,\n'
                             ' _pd_meas_counts_ or _pd_meas_intensity_.</pre>',
 '_pd_calc_method': '<pre><h2>_pd_calc_method</h2> A description of the method used for the '
                    'calculation of\n'
                    ' the intensities in _pd_calc_intensity_. If the pattern was\n'
                    ' calculated from crystal structure data, the atom coordinates\n'
                    ' and other crystallographic information should be included\n'
                    ' using the core CIF _atom_site_ and _cell_ data items.</pre>',
 '_pd_calc_point_id': '<pre><h2>_pd_calc_point_id</h2> Arbitrary label identifying a calculated '
                      'data point. Used to\n'
                      ' identify a specific entry in a list of values forming the\n'
                      ' calculated diffractogram. The role of this identifier may\n'
                      ' be adopted by _pd_data_point_id if measured, processed and\n'
                      ' calculated intensity values are combined in a single list.</pre>',
 '_pd_calib_2theta_off_max': '<pre><h2>_pd_calib_2theta_off_max</h2> _pd_calib_2theta_offset '
                             'defines an offset angle (in degrees)\n'
                             ' used to calibrate 2\\q (as defined in _pd_meas_2theta_).\n'
                             ' Calibration is done by adding the offset:\n'
                             '\n'
                             '      2\\q~calibrated~ = 2\\q~measured~ + 2\\q~offset~\n'
                             '\n'
                             ' For cases where the _pd_calib_2theta_offset value is\n'
                             ' not a constant, but rather varies with 2\\q, a set\n'
                             ' of offset values can be supplied in a loop. In this case,\n'
                             ' the value where the offset has been determined can be\n'
                             ' specified as _pd_calib_2theta_off_point. Alternatively, a\n'
                             ' range where the offset is applicable can be specified using\n'
                             ' _pd_calib_2theta_off_min and _pd_calib_2theta_off_max.</pre>',
 '_pd_calib_2theta_off_min': '<pre><h2>_pd_calib_2theta_off_min</h2> _pd_calib_2theta_offset '
                             'defines an offset angle (in degrees)\n'
                             ' used to calibrate 2\\q (as defined in _pd_meas_2theta_).\n'
                             ' Calibration is done by adding the offset:\n'
                             '\n'
                             '      2\\q~calibrated~ = 2\\q~measured~ + 2\\q~offset~\n'
                             '\n'
                             ' For cases where the _pd_calib_2theta_offset value is\n'
                             ' not a constant, but rather varies with 2\\q, a set\n'
                             ' of offset values can be supplied in a loop. In this case,\n'
                             ' the value where the offset has been determined can be\n'
                             ' specified as _pd_calib_2theta_off_point. Alternatively, a\n'
                             ' range where the offset is applicable can be specified using\n'
                             ' _pd_calib_2theta_off_min and _pd_calib_2theta_off_max.</pre>',
 '_pd_calib_2theta_off_point': '<pre><h2>_pd_calib_2theta_off_point</h2> _pd_calib_2theta_offset '
                               'defines an offset angle (in degrees)\n'
                               ' used to calibrate 2\\q (as defined in _pd_meas_2theta_).\n'
                               ' Calibration is done by adding the offset:\n'
                               '\n'
                               '      2\\q~calibrated~ = 2\\q~measured~ + 2\\q~offset~\n'
                               '\n'
                               ' For cases where the _pd_calib_2theta_offset value is\n'
                               ' not a constant, but rather varies with 2\\q, a set\n'
                               ' of offset values can be supplied in a loop. In this case,\n'
                               ' the value where the offset has been determined can be\n'
                               ' specified as _pd_calib_2theta_off_point. Alternatively, a\n'
                               ' range where the offset is applicable can be specified using\n'
                               ' _pd_calib_2theta_off_min and _pd_calib_2theta_off_max.</pre>',
 '_pd_calib_2theta_offset': '<pre><h2>_pd_calib_2theta_offset</h2> _pd_calib_2theta_offset defines '
                            'an offset angle (in degrees)\n'
                            ' used to calibrate 2\\q (as defined in _pd_meas_2theta_).\n'
                            ' Calibration is done by adding the offset:\n'
                            '\n'
                            '      2\\q~calibrated~ = 2\\q~measured~ + 2\\q~offset~\n'
                            '\n'
                            ' For cases where the _pd_calib_2theta_offset value is\n'
                            ' not a constant, but rather varies with 2\\q, a set\n'
                            ' of offset values can be supplied in a loop. In this case,\n'
                            ' the value where the offset has been determined can be\n'
                            ' specified as _pd_calib_2theta_off_point. Alternatively, a\n'
                            ' range where the offset is applicable can be specified using\n'
                            ' _pd_calib_2theta_off_min and _pd_calib_2theta_off_max.</pre>',
 '_pd_calib_[pd]': '<pre><h2>_pd_calib_[pd]</h2> This section defines the parameters used for the '
                   'calibration \n'
                   ' of the instrument that are used directly or indirectly in the \n'
                   ' interpretation of this data set. The information in this \n'
                   ' section of the CIF should generally be written when the \n'
                   ' intensities are first measured, but from then on should remain \n'
                   ' unchanged. Loops may be used for calibration information that \n'
                   ' differs by detector channel. The _pd_calibration_ items, \n'
                   ' however, are never looped.\n'
                   '\n'
                   '<h3>Example:</h3>\n'
                   '\n'
                   '   _pd_calib_std_external_block_id\n'
                   ' QuartzPlate|D500#1234-987|B.Toby|91-15-09|14:02\n'
                   '   _pd_calib_std_external_name\n'
                   " 'Arkansas Stone quartz plate'\n"
                   '\n'
                   '    _pd_calibration_conversion_eqn\n'
                   '    ; 2\\q~actual~ = 2\\q~setting~ + arctan(\n'
                   '      cos(P~1~)/{1/[P~0~ (CC - CH~0~ - P~2~ CC^2^)] - sin(P~1~)})\n'
                   '    ;</pre>',
 '_pd_calib_detector_id': '<pre><h2>_pd_calib_detector_id</h2> A code which identifies the '
                          'detector or channel number in a\n'
                          ' position-sensitive, energy-dispersive or other multiple-detector\n'
                          ' instrument. Note that this code should match the code name used\n'
                          ' for _pd_meas_detector_id.</pre>',
 '_pd_calib_detector_response': '<pre><h2>_pd_calib_detector_response</h2> A value that indicates '
                                'the relative sensitivity of each\n'
                                ' detector. This can compensate for differences in electronics,\n'
                                ' size and collimation. Usually, one detector or the mean for\n'
                                ' all detectors will be assigned the value of 1.</pre>',
 '_pd_calib_std_external_block_id': '<pre><h2>_pd_calib_std_external_block_id</h2> Identifies the '
                                    'data set used as an external standard for\n'
                                    ' the diffraction angle or the intensity calibrations.\n'
                                    ' *_name specifies the name of the material and\n'
                                    ' *_id the _pd_block_id for the CIF containing calibration\n'
                                    ' measurements. If more than one data set is used for\n'
                                    ' calibration, these fields may be looped.</pre>',
 '_pd_calib_std_external_name': '<pre><h2>_pd_calib_std_external_name</h2> Identifies the data set '
                                'used as an external standard for\n'
                                ' the diffraction angle or the intensity calibrations.\n'
                                ' *_name specifies the name of the material and\n'
                                ' *_id the _pd_block_id for the CIF containing calibration\n'
                                ' measurements. If more than one data set is used for\n'
                                ' calibration, these fields may be looped.</pre>',
 '_pd_calib_std_internal_mass_%': '<pre><h2>_pd_calib_std_internal_mass_%</h2> Per cent presence '
                                  'of the internal standard specified by the\n'
                                  ' data item _pd_calib_std_internal_name expressed as 100 times\n'
                                  ' the ratio of the amount of standard added to the original\n'
                                  ' sample mass.</pre>',
 '_pd_calib_std_internal_name': '<pre><h2>_pd_calib_std_internal_name</h2> Identity of material(s) '
                                'used as an internal intensity standard.\n'
                                '\n'
                                '<h3>Example:</h3>\n'
                                'NIST 640a Silicon standard\n'
                                'Al2O3</pre>',
 '_pd_calibration_conversion_eqn': '<pre><h2>_pd_calibration_conversion_eqn</h2> The calibration '
                                   'function for converting a channel number\n'
                                   ' supplied in _pd_meas_detector_id for a position-sensitive\n'
                                   ' or energy-dispersive detector or the distance supplied in\n'
                                   ' _pd_meas_position to Q, energy, angle etc.\n'
                                   ' Use _pd_calib_std_external_ to define a pointer\n'
                                   ' to the file or data block containing the information used\n'
                                   ' to define this function.\n'
                                   '\n'
                                   '<h3>Example:</h3>\n'
                                   ' 2\\q~actual~ = 2\\q~setting~ + arctan(\n'
                                   'os(P~1~) / {1/[P~0~ (CC - CH~0~ - P~2~ CC^2^)] - sin(P~1~)} '
                                   ')</pre>',
 '_pd_calibration_special_details': '<pre><h2>_pd_calibration_special_details</h2> Description of '
                                    'how the instrument was\n'
                                    ' calibrated, particularly for instruments where\n'
                                    ' calibration information is used to make hardware\n'
                                    ' settings that would otherwise be invisible once data\n'
                                    ' collection is completed. Do not use this item to specify\n'
                                    ' information that can be specified using other _pd_calib_\n'
                                    ' items.</pre>',
 '_pd_char_[pd]': '<pre><h2>_pd_char_[pd]</h2>   This section contains experimental '
                  '(non-diffraction) information\n'
                  '    relevant to the chemical and physical nature of the material.</pre>',
 '_pd_char_atten_coef_mu_calc': '<pre><h2>_pd_char_atten_coef_mu_calc</h2> The observed and '
                                'calculated linear attenuation coefficient,\n'
                                ' \\m, in units of inverse millimetres. Note that this quantity\n'
                                ' is sometimes referred to as the mass absorption coefficient;\n'
                                ' however, this term accounts for other potentially significant\n'
                                ' losses of incident radiation, for example incoherent\n'
                                ' scattering of neutrons.\n'
                                '\n'
                                ' The calculated \\m will be obtained from the atomic content of\n'
                                ' the cell, the average density (allowing for specimen packing)\n'
                                ' and the radiation wavelength. The observed \\m will be\n'
                                ' determined by a transmission measurement.\n'
                                ' Note that _pd_char_atten_coef_mu_calc will differ from\n'
                                ' _exptl_absorpt_coefficient_mu if the packing density is\n'
                                ' not unity.</pre>',
 '_pd_char_atten_coef_mu_obs': '<pre><h2>_pd_char_atten_coef_mu_obs</h2> The observed and '
                               'calculated linear attenuation coefficient,\n'
                               ' \\m, in units of inverse millimetres. Note that this quantity\n'
                               ' is sometimes referred to as the mass absorption coefficient;\n'
                               ' however, this term accounts for other potentially significant\n'
                               ' losses of incident radiation, for example incoherent\n'
                               ' scattering of neutrons.\n'
                               '\n'
                               ' The calculated \\m will be obtained from the atomic content of\n'
                               ' the cell, the average density (allowing for specimen packing)\n'
                               ' and the radiation wavelength. The observed \\m will be\n'
                               ' determined by a transmission measurement.\n'
                               ' Note that _pd_char_atten_coef_mu_calc will differ from\n'
                               ' _exptl_absorpt_coefficient_mu if the packing density is\n'
                               ' not unity.</pre>',
 '_pd_char_colour': '<pre><h2>_pd_char_colour</h2> The colour of the material used for the '
                    'measurement.\n'
                    ' To facilitate more standardized use of names, the\n'
                    ' following guidelines for colour naming developed by\n'
                    ' Peter Bayliss for the International Centre for \n'
                    ' Diffraction Data (ICDD) should be followed. Note that\n'
                    ' combinations of descriptors are separated by an\n'
                    ' underscore.\n'
                    '\n'
                    ' Allowed colours are:\n'
                    '   colourless, white, black, gray, brown, red, pink,\n'
                    '   orange, yellow, green, blue, violet.\n'
                    '\n'
                    ' Colours may be modified using prefixes of:\n'
                    '   light, dark, whitish, blackish, grayish, brownish,\n'
                    '   reddish, pinkish, orangish, yellowish, greenish, bluish.\n'
                    '\n'
                    ' Intermediate hues may be indicated with two colours:\n'
                    ' e.g. blue_green or bluish_green.\n'
                    '\n'
                    ' For metallic materials, the term metallic may be added:\n'
                    ' e.g. reddish_orange_metallic for copper.\n'
                    '\n'
                    ' The ICDD standard allows commas to be used for minerals\n'
                    ' that occur with ranges of colours; however this usage is\n'
                    ' not appropriate for the description of a single sample.\n'
                    '\n'
                    '<h3>Example:</h3>\n'
                    'dark_green\n'
                    'orange_red\n'
                    'brownish_red\n'
                    'yellow_metallic</pre>',
 '_pd_char_particle_morphology': '<pre><h2>_pd_char_particle_morphology</h2> A description of the '
                                 'sample morphology and estimates for\n'
                                 ' particle sizes (before grinding/sieving, if noted by\n'
                                 ' _pd_spec_preparation). Include the method used for\n'
                                 ' these estimates (SEM, visual estimate etc.).</pre>',
 '_pd_char_special_details': '<pre><h2>_pd_char_special_details</h2> Additional characterization '
                             'information relevant to the sample\n'
                             ' or documentation of non-routine processing steps used\n'
                             ' for characterization.</pre>',
 '_pd_data_[pd]': '<pre><h2>_pd_data_[pd]</h2> The PD_DATA category contains raw, processed and '
                  'calculated\n'
                  ' data points in a diffraction data set. In many cases, it is\n'
                  ' convenient to tabulate calculated values against the\n'
                  ' raw and processed measurements, and so the various\n'
                  ' _pd_meas_, _pd_proc_ and _pd_calc_ data items belonging\n'
                  ' to this category may be looped together. In some instances,\n'
                  ' however, it makes more sense to maintain separate tables of\n'
                  ' the data contributing to the measured and processed\n'
                  ' diffractograms (for example, a profile may be calculated\n'
                  ' at 2theta values different from those of the measured\n'
                  ' data points). To facilitate the identification of equivalent\n'
                  ' points in these separate tables, separate identifiers are\n'
                  ' defined.\n'
                  '\n'
                  '<h3>Example:</h3>\n'
                  '\n'
                  '    loop_\n'
                  '      _pd_data_point_id\n'
                  '      _pd_meas_intensity_total\n'
                  '      _pd_proc_ls_weight\n'
                  '      _pd_proc_intensity_bkg_calc\n'
                  '      _pd_calc_intensity_total\n'
                  '    1    240(15)       0.00417     214.5   214.5 \n'
                  '    2    219(15)       0.00457     214.3   214.2 \n'
                  '    3    206(14)       0.00485     214.0   214.0 \n'
                  '    4    212(15)       0.00472     213.8   213.7 \n'
                  '    5    190(14)       0.00526     213.5   213.5 \n'
                  '    6    203(14)       0.00493     213.2   213.2 \n'
                  '     # - - - - data truncated for brevity - - - -\n'
                  '\n'
                  '     loop_\n'
                  '      _pd_meas_point_id\n'
                  '      _pd_meas_intensity_total\n'
                  '    1  240(15) 2  219(15) 3  206(14) 4  212(15) 5  190(14) 6  203(14)\n'
                  '\n'
                  '     loop_\n'
                  '      _pd_proc_point_id\n'
                  '      _pd_proc_ls_weight\n'
                  '      _pd_proc_intensity_bkg_calc\n'
                  '    1  0.00417  214.5      2  0.00457  214.3\n'
                  '    3  0.00485  214.0      4  0.00472  213.8\n'
                  '    5  0.00526  213.5      6  0.00493  213.2\n'
                  '\n'
                  '     loop_\n'
                  '      _pd_calc_point_id\n'
                  '      _pd_calc_intensity_total\n'
                  '    1   214.5 2   214.2 3   214.0 4   213.7 5   213.5 6   213.2 \n'
                  '\n'
                  '\n'
                  '   loop_ \n'
                  '     _pd_meas_point_id\n'
                  '     _pd_meas_2theta_scan\n'
                  '     _pd_meas_intensity_total\n'
                  '            1  21.0   24\n'
                  '            2  21.2   32\n'
                  '            3  21.4   67\n'
                  '            4  21.6   98\n'
                  '\n'
                  '   loop_ \n'
                  '     _pd_calc_point_id\n'
                  '     _pd_proc_2theta_corrected\n'
                  '     _pd_calc_intensity_total\n'
                  '            1   21.0  26\n'
                  '            1a  21.3  56\n'
                  '            4   21.6  76\n'
                  '            4a  21.9  90\n'
                  '</pre>',
 '_pd_data_point_id': '<pre><h2>_pd_data_point_id</h2> Arbitrary label identifying an entry in the '
                      'table of\n'
                      ' diffractogram intensity values.</pre>',
 '_pd_instr_2theta_monochr_post': '<pre><h2>_pd_instr_2theta_monochr_post</h2> The 2\\q angle for '
                                  'a pre-specimen or post-specimen\n'
                                  ' monochromator (see _pd_instr_monochr_pre_spec and\n'
                                  ' _pd_instr_monochr_post_spec).</pre>',
 '_pd_instr_2theta_monochr_pre': '<pre><h2>_pd_instr_2theta_monochr_pre</h2> The 2\\q angle for a '
                                 'pre-specimen or post-specimen\n'
                                 ' monochromator (see _pd_instr_monochr_pre_spec and\n'
                                 ' _pd_instr_monochr_post_spec).</pre>',
 '_pd_instr_[pd]': '<pre><h2>_pd_instr_[pd]</h2> This section contains information relevant to the '
                   'instrument\n'
                   ' used for the diffraction measurement. For most laboratories,\n'
                   ' very little of this information will change, so a standard file\n'
                   ' may be prepared and included with each data set.\n'
                   '\n'
                   ' Note that several definitions in the core CIF dictionary\n'
                   ' are relevant here. For example, use:\n'
                   '   _diffrn_radiation_wavelength for the source wavelength,\n'
                   '   _diffrn_radiation_type for the X-ray wavelength type,\n'
                   '   _diffrn_source for the radiation source,\n'
                   '   _diffrn_radiation_polarisn_ratio for the source polarization,\n'
                   '   _diffrn_radiation_probe for the radiation type.\n'
                   ' For data sets measured with partially monochromatized radiation,\n'
                   ' for example, where both K\\a~1~ and K\\a~2~ are present, it is\n'
                   ' important that all wavelengths present are included in a\n'
                   ' loop_ using _diffrn_radiation_wavelength to define the \n'
                   ' wavelength and _diffrn_radiation_wavelength_wt to define the \n'
                   ' relative intensity of that wavelength. It is required that \n'
                   ' _diffrn_radiation_wavelength_id also be present in the \n'
                   ' wavelength loop. It may also be useful to\n'
                   ' create a "dummy" ID to use for labelling\n'
                   ' peaks/reflections where the K\\a~1~ and K\\a~2~ wavelengths are\n'
                   ' not resolved. Set _diffrn_radiation_wavelength_wt to be 0 for\n'
                   ' such a dummy ID.\n'
                   '\n'
                   ' In the _pd_instr_ definitions, the term monochromator refers\n'
                   ' to a primary beam (pre-specimen) monochromator and the term\n'
                   ' analyser refers to post-diffraction (post-specimen)\n'
                   ' monochromator.  The analyser may be fixed for specific\n'
                   ' wavelength or may be capable of being scanned.\n'
                   '\n'
                   ' For multiple-detector instruments it may be necessary to loop the\n'
                   ' *_anal/detc or *_spec/detc values (for  _pd_instr_dist_,\n'
                   ' _pd_instr_divg_, _pd_instr_slit_ and  _pd_instr_soller_) with\n'
                   " the detector ID's (_pd_calib_detector_id).\n"
                   '\n'
                   ' It is strongly recommended that the core dictionary term\n'
                   ' _diffrn_radiation_probe (specifying the nature of the radiation\n'
                   ' used) is employed for all data sets.\n'
                   '\n'
                   '<h3>Example:</h3>\n'
                   '\n'
                   '    _pd_instr_slit_eq_src/spec       1.\n'
                   '    _pd_instr_slit_eq_anal/detc      0.2\n'
                   '\n'
                   '    _pd_instr_geometry              Bragg-Brentano\n'
                   "    _pd_instr_monochr_post_spec     'graphite (0001)'\n"
                   '    _pd_instr_cons_illum_flag       no</pre>',
 '_pd_instr_beam_size_ax': '<pre><h2>_pd_instr_beam_size_ax</h2> Axial and equatorial dimensions '
                           'of the radiation beam\n'
                           ' at the specimen position (in millimetres).\n'
                           ' The perpendicular to the plane containing the incident\n'
                           ' and scattered beam is the axial (*_ax) direction.</pre>',
 '_pd_instr_beam_size_eq': '<pre><h2>_pd_instr_beam_size_eq</h2> Axial and equatorial dimensions '
                           'of the radiation beam\n'
                           ' at the specimen position (in millimetres).\n'
                           ' The perpendicular to the plane containing the incident\n'
                           ' and scattered beam is the axial (*_ax) direction.</pre>',
 '_pd_instr_cons_illum_flag': "<pre><h2>_pd_instr_cons_illum_flag</h2> Use 'yes' for instruments "
                              'where the divergence slit is\n'
                              ' \\q-compensated to yield a constant illumination length\n'
                              ' (also see _pd_instr_cons_illum_len).\n'
                              '\n'
                              ' For other flat-plate instruments, where the illumination\n'
                              " length changes with 2\\q, specify 'no'. Note that\n"
                              ' if the length is known, it may be specified using\n'
                              ' _pd_instr_var_illum_len.\n'
                              '\n'
                              '<h3>Example:</h3>\n'
                              'yes\n'
                              'no</pre>',
 '_pd_instr_cons_illum_len': '<pre><h2>_pd_instr_cons_illum_len</h2> Length of the specimen that '
                             'is illuminated by the radiation\n'
                             ' source (in millimetres).\n'
                             '\n'
                             ' Use _pd_instr_cons_illum_len for instruments where\n'
                             ' the illumination length does not vary with 2\\q, by\n'
                             ' adjustment of the divergence slits (sometimes known\n'
                             ' as \\q-compensated slits).\n'
                             ' Use _pd_instr_var_illum_len for instruments where\n'
                             ' the illuminated length of the specimen has been \n'
                             ' characterized as a function of 2\\q, most commonly true\n'
                             ' with a fixed divergence slit.</pre>',
 '_pd_instr_dist_anal/detc': '<pre><h2>_pd_instr_dist_anal/detc</h2> Specifies distances in '
                             'millimetres for the instrument geometry:\n'
                             '   *_src/mono, the distance from the radiation source\n'
                             '       to the monochromator;\n'
                             '   *_mono/spec, the distance from the monochromator to\n'
                             '       the specimen;\n'
                             '   *_src/spec, the distance from the radiation source\n'
                             '       to the specimen;\n'
                             '   *_spec/anal, the distance from the specimen to the\n'
                             '       analyser;\n'
                             '   *_anal/detc, the distance from the analyser to the\n'
                             '       detector;\n'
                             '   *_spec/detc, the distance from the specimen to the\n'
                             '       detector.\n'
                             '\n'
                             ' Note that *_src/spec is used in place of *_src/mono and \n'
                             ' *_mono/spec if there is no monochromator in use, and \n'
                             ' *_spec/detc is used in place of *_spec/anal and *_anal/detc \n'
                             ' if there is no analyser in use.</pre>',
 '_pd_instr_dist_mono/spec': '<pre><h2>_pd_instr_dist_mono/spec</h2> Specifies distances in '
                             'millimetres for the instrument geometry:\n'
                             '   *_src/mono, the distance from the radiation source\n'
                             '       to the monochromator;\n'
                             '   *_mono/spec, the distance from the monochromator to\n'
                             '       the specimen;\n'
                             '   *_src/spec, the distance from the radiation source\n'
                             '       to the specimen;\n'
                             '   *_spec/anal, the distance from the specimen to the\n'
                             '       analyser;\n'
                             '   *_anal/detc, the distance from the analyser to the\n'
                             '       detector;\n'
                             '   *_spec/detc, the distance from the specimen to the\n'
                             '       detector.\n'
                             '\n'
                             ' Note that *_src/spec is used in place of *_src/mono and \n'
                             ' *_mono/spec if there is no monochromator in use, and \n'
                             ' *_spec/detc is used in place of *_spec/anal and *_anal/detc \n'
                             ' if there is no analyser in use.</pre>',
 '_pd_instr_dist_spec/anal': '<pre><h2>_pd_instr_dist_spec/anal</h2> Specifies distances in '
                             'millimetres for the instrument geometry:\n'
                             '   *_src/mono, the distance from the radiation source\n'
                             '       to the monochromator;\n'
                             '   *_mono/spec, the distance from the monochromator to\n'
                             '       the specimen;\n'
                             '   *_src/spec, the distance from the radiation source\n'
                             '       to the specimen;\n'
                             '   *_spec/anal, the distance from the specimen to the\n'
                             '       analyser;\n'
                             '   *_anal/detc, the distance from the analyser to the\n'
                             '       detector;\n'
                             '   *_spec/detc, the distance from the specimen to the\n'
                             '       detector.\n'
                             '\n'
                             ' Note that *_src/spec is used in place of *_src/mono and \n'
                             ' *_mono/spec if there is no monochromator in use, and \n'
                             ' *_spec/detc is used in place of *_spec/anal and *_anal/detc \n'
                             ' if there is no analyser in use.</pre>',
 '_pd_instr_dist_spec/detc': '<pre><h2>_pd_instr_dist_spec/detc</h2> Specifies distances in '
                             'millimetres for the instrument geometry:\n'
                             '   *_src/mono, the distance from the radiation source\n'
                             '       to the monochromator;\n'
                             '   *_mono/spec, the distance from the monochromator to\n'
                             '       the specimen;\n'
                             '   *_src/spec, the distance from the radiation source\n'
                             '       to the specimen;\n'
                             '   *_spec/anal, the distance from the specimen to the\n'
                             '       analyser;\n'
                             '   *_anal/detc, the distance from the analyser to the\n'
                             '       detector;\n'
                             '   *_spec/detc, the distance from the specimen to the\n'
                             '       detector.\n'
                             '\n'
                             ' Note that *_src/spec is used in place of *_src/mono and \n'
                             ' *_mono/spec if there is no monochromator in use, and \n'
                             ' *_spec/detc is used in place of *_spec/anal and *_anal/detc \n'
                             ' if there is no analyser in use.</pre>',
 '_pd_instr_dist_src/mono': '<pre><h2>_pd_instr_dist_src/mono</h2> Specifies distances in '
                            'millimetres for the instrument geometry:\n'
                            '   *_src/mono, the distance from the radiation source\n'
                            '       to the monochromator;\n'
                            '   *_mono/spec, the distance from the monochromator to\n'
                            '       the specimen;\n'
                            '   *_src/spec, the distance from the radiation source\n'
                            '       to the specimen;\n'
                            '   *_spec/anal, the distance from the specimen to the\n'
                            '       analyser;\n'
                            '   *_anal/detc, the distance from the analyser to the\n'
                            '       detector;\n'
                            '   *_spec/detc, the distance from the specimen to the\n'
                            '       detector.\n'
                            '\n'
                            ' Note that *_src/spec is used in place of *_src/mono and \n'
                            ' *_mono/spec if there is no monochromator in use, and \n'
                            ' *_spec/detc is used in place of *_spec/anal and *_anal/detc \n'
                            ' if there is no analyser in use.</pre>',
 '_pd_instr_dist_src/spec': '<pre><h2>_pd_instr_dist_src/spec</h2> Specifies distances in '
                            'millimetres for the instrument geometry:\n'
                            '   *_src/mono, the distance from the radiation source\n'
                            '       to the monochromator;\n'
                            '   *_mono/spec, the distance from the monochromator to\n'
                            '       the specimen;\n'
                            '   *_src/spec, the distance from the radiation source\n'
                            '       to the specimen;\n'
                            '   *_spec/anal, the distance from the specimen to the\n'
                            '       analyser;\n'
                            '   *_anal/detc, the distance from the analyser to the\n'
                            '       detector;\n'
                            '   *_spec/detc, the distance from the specimen to the\n'
                            '       detector.\n'
                            '\n'
                            ' Note that *_src/spec is used in place of *_src/mono and \n'
                            ' *_mono/spec if there is no monochromator in use, and \n'
                            ' *_spec/detc is used in place of *_spec/anal and *_anal/detc \n'
                            ' if there is no analyser in use.</pre>',
 '_pd_instr_divg_ax_anal/detc': '<pre><h2>_pd_instr_divg_ax_anal/detc</h2> Describes collimation '
                                'in the axial direction\n'
                                ' (perpendicular to the plane containing the incident\n'
                                ' and diffracted beams) for the instrument.\n'
                                ' Values are the maximum divergence angles in\n'
                                ' degrees, as limited by slits or beamline optics\n'
                                ' other than Soller slits (see _pd_instr_soller_ax_):\n'
                                '   *_src/mono, collimation between the radiation source\n'
                                '       and the monochromator;\n'
                                '   *_mono/spec, collimation between the monochromator and\n'
                                '       the specimen;\n'
                                '   *_src/spec, collimation between the radiation source\n'
                                '       and the specimen;\n'
                                '   *_spec/anal, collimation between the specimen and the\n'
                                '       analyser;\n'
                                '   *_anal/detc, collimation between the analyser and the\n'
                                '       detector;\n'
                                '   *_spec/detc, collimation between the specimen and the\n'
                                '       detector.\n'
                                '\n'
                                ' Note that *_src/spec is used in place of *_src/mono and \n'
                                ' *_mono/spec if there is no monochromator in use, and \n'
                                ' *_spec/detc is used in place of *_spec/anal and *_anal/detc \n'
                                ' if there is no analyser in use.</pre>',
 '_pd_instr_divg_ax_mono/spec': '<pre><h2>_pd_instr_divg_ax_mono/spec</h2> Describes collimation '
                                'in the axial direction\n'
                                ' (perpendicular to the plane containing the incident\n'
                                ' and diffracted beams) for the instrument.\n'
                                ' Values are the maximum divergence angles in\n'
                                ' degrees, as limited by slits or beamline optics\n'
                                ' other than Soller slits (see _pd_instr_soller_ax_):\n'
                                '   *_src/mono, collimation between the radiation source\n'
                                '       and the monochromator;\n'
                                '   *_mono/spec, collimation between the monochromator and\n'
                                '       the specimen;\n'
                                '   *_src/spec, collimation between the radiation source\n'
                                '       and the specimen;\n'
                                '   *_spec/anal, collimation between the specimen and the\n'
                                '       analyser;\n'
                                '   *_anal/detc, collimation between the analyser and the\n'
                                '       detector;\n'
                                '   *_spec/detc, collimation between the specimen and the\n'
                                '       detector.\n'
                                '\n'
                                ' Note that *_src/spec is used in place of *_src/mono and \n'
                                ' *_mono/spec if there is no monochromator in use, and \n'
                                ' *_spec/detc is used in place of *_spec/anal and *_anal/detc \n'
                                ' if there is no analyser in use.</pre>',
 '_pd_instr_divg_ax_spec/anal': '<pre><h2>_pd_instr_divg_ax_spec/anal</h2> Describes collimation '
                                'in the axial direction\n'
                                ' (perpendicular to the plane containing the incident\n'
                                ' and diffracted beams) for the instrument.\n'
                                ' Values are the maximum divergence angles in\n'
                                ' degrees, as limited by slits or beamline optics\n'
                                ' other than Soller slits (see _pd_instr_soller_ax_):\n'
                                '   *_src/mono, collimation between the radiation source\n'
                                '       and the monochromator;\n'
                                '   *_mono/spec, collimation between the monochromator and\n'
                                '       the specimen;\n'
                                '   *_src/spec, collimation between the radiation source\n'
                                '       and the specimen;\n'
                                '   *_spec/anal, collimation between the specimen and the\n'
                                '       analyser;\n'
                                '   *_anal/detc, collimation between the analyser and the\n'
                                '       detector;\n'
                                '   *_spec/detc, collimation between the specimen and the\n'
                                '       detector.\n'
                                '\n'
                                ' Note that *_src/spec is used in place of *_src/mono and \n'
                                ' *_mono/spec if there is no monochromator in use, and \n'
                                ' *_spec/detc is used in place of *_spec/anal and *_anal/detc \n'
                                ' if there is no analyser in use.</pre>',
 '_pd_instr_divg_ax_spec/detc': '<pre><h2>_pd_instr_divg_ax_spec/detc</h2> Describes collimation '
                                'in the axial direction\n'
                                ' (perpendicular to the plane containing the incident\n'
                                ' and diffracted beams) for the instrument.\n'
                                ' Values are the maximum divergence angles in\n'
                                ' degrees, as limited by slits or beamline optics\n'
                                ' other than Soller slits (see _pd_instr_soller_ax_):\n'
                                '   *_src/mono, collimation between the radiation source\n'
                                '       and the monochromator;\n'
                                '   *_mono/spec, collimation between the monochromator and\n'
                                '       the specimen;\n'
                                '   *_src/spec, collimation between the radiation source\n'
                                '       and the specimen;\n'
                                '   *_spec/anal, collimation between the specimen and the\n'
                                '       analyser;\n'
                                '   *_anal/detc, collimation between the analyser and the\n'
                                '       detector;\n'
                                '   *_spec/detc, collimation between the specimen and the\n'
                                '       detector.\n'
                                '\n'
                                ' Note that *_src/spec is used in place of *_src/mono and \n'
                                ' *_mono/spec if there is no monochromator in use, and \n'
                                ' *_spec/detc is used in place of *_spec/anal and *_anal/detc \n'
                                ' if there is no analyser in use.</pre>',
 '_pd_instr_divg_ax_src/mono': '<pre><h2>_pd_instr_divg_ax_src/mono</h2> Describes collimation in '
                               'the axial direction\n'
                               ' (perpendicular to the plane containing the incident\n'
                               ' and diffracted beams) for the instrument.\n'
                               ' Values are the maximum divergence angles in\n'
                               ' degrees, as limited by slits or beamline optics\n'
                               ' other than Soller slits (see _pd_instr_soller_ax_):\n'
                               '   *_src/mono, collimation between the radiation source\n'
                               '       and the monochromator;\n'
                               '   *_mono/spec, collimation between the monochromator and\n'
                               '       the specimen;\n'
                               '   *_src/spec, collimation between the radiation source\n'
                               '       and the specimen;\n'
                               '   *_spec/anal, collimation between the specimen and the\n'
                               '       analyser;\n'
                               '   *_anal/detc, collimation between the analyser and the\n'
                               '       detector;\n'
                               '   *_spec/detc, collimation between the specimen and the\n'
                               '       detector.\n'
                               '\n'
                               ' Note that *_src/spec is used in place of *_src/mono and \n'
                               ' *_mono/spec if there is no monochromator in use, and \n'
                               ' *_spec/detc is used in place of *_spec/anal and *_anal/detc \n'
                               ' if there is no analyser in use.</pre>',
 '_pd_instr_divg_ax_src/spec': '<pre><h2>_pd_instr_divg_ax_src/spec</h2> Describes collimation in '
                               'the axial direction\n'
                               ' (perpendicular to the plane containing the incident\n'
                               ' and diffracted beams) for the instrument.\n'
                               ' Values are the maximum divergence angles in\n'
                               ' degrees, as limited by slits or beamline optics\n'
                               ' other than Soller slits (see _pd_instr_soller_ax_):\n'
                               '   *_src/mono, collimation between the radiation source\n'
                               '       and the monochromator;\n'
                               '   *_mono/spec, collimation between the monochromator and\n'
                               '       the specimen;\n'
                               '   *_src/spec, collimation between the radiation source\n'
                               '       and the specimen;\n'
                               '   *_spec/anal, collimation between the specimen and the\n'
                               '       analyser;\n'
                               '   *_anal/detc, collimation between the analyser and the\n'
                               '       detector;\n'
                               '   *_spec/detc, collimation between the specimen and the\n'
                               '       detector.\n'
                               '\n'
                               ' Note that *_src/spec is used in place of *_src/mono and \n'
                               ' *_mono/spec if there is no monochromator in use, and \n'
                               ' *_spec/detc is used in place of *_spec/anal and *_anal/detc \n'
                               ' if there is no analyser in use.</pre>',
 '_pd_instr_divg_eq_anal/detc': '<pre><h2>_pd_instr_divg_eq_anal/detc</h2> Describes collimation '
                                'in the equatorial plane (the plane\n'
                                ' containing the incident and diffracted beams) for\n'
                                ' the instrument. Values are the maximum divergence angles in\n'
                                ' degrees, as limited by slits or beamline optics\n'
                                ' other than Soller slits (see _pd_instr_soller_eq_):\n'
                                '   *_src/mono, collimation between the radiation source\n'
                                '       and the monochromator;\n'
                                '   *_mono/spec, collimation between the monochromator and\n'
                                '       the specimen;\n'
                                '   *_src/spec, collimation between the radiation source\n'
                                '       and the specimen;\n'
                                '   *_spec/anal, collimation between the specimen and the\n'
                                '       analyser;\n'
                                '   *_anal/detc, collimation between the analyser and the\n'
                                '       detector;\n'
                                '   *_spec/detc, collimation between the specimen and the\n'
                                '       detector.\n'
                                '\n'
                                ' Note that *_src/spec is used in place of *_src/mono and \n'
                                ' *_mono/spec if there is no monochromator in use, and \n'
                                ' *_spec/detc is used in place of *_spec/anal and *_anal/detc \n'
                                ' if there is no analyser in use.</pre>',
 '_pd_instr_divg_eq_mono/spec': '<pre><h2>_pd_instr_divg_eq_mono/spec</h2> Describes collimation '
                                'in the equatorial plane (the plane\n'
                                ' containing the incident and diffracted beams) for\n'
                                ' the instrument. Values are the maximum divergence angles in\n'
                                ' degrees, as limited by slits or beamline optics\n'
                                ' other than Soller slits (see _pd_instr_soller_eq_):\n'
                                '   *_src/mono, collimation between the radiation source\n'
                                '       and the monochromator;\n'
                                '   *_mono/spec, collimation between the monochromator and\n'
                                '       the specimen;\n'
                                '   *_src/spec, collimation between the radiation source\n'
                                '       and the specimen;\n'
                                '   *_spec/anal, collimation between the specimen and the\n'
                                '       analyser;\n'
                                '   *_anal/detc, collimation between the analyser and the\n'
                                '       detector;\n'
                                '   *_spec/detc, collimation between the specimen and the\n'
                                '       detector.\n'
                                '\n'
                                ' Note that *_src/spec is used in place of *_src/mono and \n'
                                ' *_mono/spec if there is no monochromator in use, and \n'
                                ' *_spec/detc is used in place of *_spec/anal and *_anal/detc \n'
                                ' if there is no analyser in use.</pre>',
 '_pd_instr_divg_eq_spec/anal': '<pre><h2>_pd_instr_divg_eq_spec/anal</h2> Describes collimation '
                                'in the equatorial plane (the plane\n'
                                ' containing the incident and diffracted beams) for\n'
                                ' the instrument. Values are the maximum divergence angles in\n'
                                ' degrees, as limited by slits or beamline optics\n'
                                ' other than Soller slits (see _pd_instr_soller_eq_):\n'
                                '   *_src/mono, collimation between the radiation source\n'
                                '       and the monochromator;\n'
                                '   *_mono/spec, collimation between the monochromator and\n'
                                '       the specimen;\n'
                                '   *_src/spec, collimation between the radiation source\n'
                                '       and the specimen;\n'
                                '   *_spec/anal, collimation between the specimen and the\n'
                                '       analyser;\n'
                                '   *_anal/detc, collimation between the analyser and the\n'
                                '       detector;\n'
                                '   *_spec/detc, collimation between the specimen and the\n'
                                '       detector.\n'
                                '\n'
                                ' Note that *_src/spec is used in place of *_src/mono and \n'
                                ' *_mono/spec if there is no monochromator in use, and \n'
                                ' *_spec/detc is used in place of *_spec/anal and *_anal/detc \n'
                                ' if there is no analyser in use.</pre>',
 '_pd_instr_divg_eq_spec/detc': '<pre><h2>_pd_instr_divg_eq_spec/detc</h2> Describes collimation '
                                'in the equatorial plane (the plane\n'
                                ' containing the incident and diffracted beams) for\n'
                                ' the instrument. Values are the maximum divergence angles in\n'
                                ' degrees, as limited by slits or beamline optics\n'
                                ' other than Soller slits (see _pd_instr_soller_eq_):\n'
                                '   *_src/mono, collimation between the radiation source\n'
                                '       and the monochromator;\n'
                                '   *_mono/spec, collimation between the monochromator and\n'
                                '       the specimen;\n'
                                '   *_src/spec, collimation between the radiation source\n'
                                '       and the specimen;\n'
                                '   *_spec/anal, collimation between the specimen and the\n'
                                '       analyser;\n'
                                '   *_anal/detc, collimation between the analyser and the\n'
                                '       detector;\n'
                                '   *_spec/detc, collimation between the specimen and the\n'
                                '       detector.\n'
                                '\n'
                                ' Note that *_src/spec is used in place of *_src/mono and \n'
                                ' *_mono/spec if there is no monochromator in use, and \n'
                                ' *_spec/detc is used in place of *_spec/anal and *_anal/detc \n'
                                ' if there is no analyser in use.</pre>',
 '_pd_instr_divg_eq_src/mono': '<pre><h2>_pd_instr_divg_eq_src/mono</h2> Describes collimation in '
                               'the equatorial plane (the plane\n'
                               ' containing the incident and diffracted beams) for\n'
                               ' the instrument. Values are the maximum divergence angles in\n'
                               ' degrees, as limited by slits or beamline optics\n'
                               ' other than Soller slits (see _pd_instr_soller_eq_):\n'
                               '   *_src/mono, collimation between the radiation source\n'
                               '       and the monochromator;\n'
                               '   *_mono/spec, collimation between the monochromator and\n'
                               '       the specimen;\n'
                               '   *_src/spec, collimation between the radiation source\n'
                               '       and the specimen;\n'
                               '   *_spec/anal, collimation between the specimen and the\n'
                               '       analyser;\n'
                               '   *_anal/detc, collimation between the analyser and the\n'
                               '       detector;\n'
                               '   *_spec/detc, collimation between the specimen and the\n'
                               '       detector.\n'
                               '\n'
                               ' Note that *_src/spec is used in place of *_src/mono and \n'
                               ' *_mono/spec if there is no monochromator in use, and \n'
                               ' *_spec/detc is used in place of *_spec/anal and *_anal/detc \n'
                               ' if there is no analyser in use.</pre>',
 '_pd_instr_divg_eq_src/spec': '<pre><h2>_pd_instr_divg_eq_src/spec</h2> Describes collimation in '
                               'the equatorial plane (the plane\n'
                               ' containing the incident and diffracted beams) for\n'
                               ' the instrument. Values are the maximum divergence angles in\n'
                               ' degrees, as limited by slits or beamline optics\n'
                               ' other than Soller slits (see _pd_instr_soller_eq_):\n'
                               '   *_src/mono, collimation between the radiation source\n'
                               '       and the monochromator;\n'
                               '   *_mono/spec, collimation between the monochromator and\n'
                               '       the specimen;\n'
                               '   *_src/spec, collimation between the radiation source\n'
                               '       and the specimen;\n'
                               '   *_spec/anal, collimation between the specimen and the\n'
                               '       analyser;\n'
                               '   *_anal/detc, collimation between the analyser and the\n'
                               '       detector;\n'
                               '   *_spec/detc, collimation between the specimen and the\n'
                               '       detector.\n'
                               '\n'
                               ' Note that *_src/spec is used in place of *_src/mono and \n'
                               ' *_mono/spec if there is no monochromator in use, and \n'
                               ' *_spec/detc is used in place of *_spec/anal and *_anal/detc \n'
                               ' if there is no analyser in use.</pre>',
 '_pd_instr_geometry': '<pre><h2>_pd_instr_geometry</h2> A description of the diffractometer type '
                       'or geometry.\n'
                       '\n'
                       '<h3>Example:</h3>\n'
                       'Bragg-Brentano\n'
                       'Guinier\n'
                       '           Parallel-beam non-focusing optics with\n'
                       '            channel-cut monochromator and linear\n'
                       '            position-sensitive detector</pre>',
 '_pd_instr_location': '<pre><h2>_pd_instr_location</h2> The name and location of the instrument '
                       'where measurements\n'
                       ' were made. This is used primarily to identify data sets\n'
                       " measured away from the author's home facility, at shared\n"
                       ' resources such as a reactor or spallation source.\n'
                       '\n'
                       '<h3>Example:</h3>\n'
                       'SEPD diffractometer, IPNS, Argonne National Lab (USA)</pre>',
 '_pd_instr_monochr_post_spec': '<pre><h2>_pd_instr_monochr_post_spec</h2> Indicates the method '
                                'used to obtain monochromatic radiation.\n'
                                ' Use _pd_instr_monochr_pre_spec to describe the primary beam\n'
                                ' monochromator (pre-specimen monochromation). Use\n'
                                ' _pd_instr_monochr_post_spec to specify the\n'
                                ' post-diffraction analyser (post-specimen monochromation).\n'
                                '\n'
                                ' When a monochromator crystal is used, the material and the\n'
                                ' indices of the Bragg reflection are specified.\n'
                                '\n'
                                " Note that monochromators may have either 'parallel' or\n"
                                " 'antiparallel' orientation. It is assumed that the\n"
                                ' geometry is parallel unless specified otherwise.\n'
                                ' In a parallel geometry, the position of the monochromator\n'
                                ' allows the incident beam and the final post-specimen\n'
                                ' and post-monochromator beam to be as close to parallel\n'
                                ' as possible. In a parallel geometry, the diffracting\n'
                                ' planes in the specimen and monochromator will be parallel\n'
                                ' when 2\\q~monochromator~ is equal to 2\\q~specimen~.\n'
                                ' For further discussion see R. Jenkins &amp; R. Snyder (1996).\n'
                                ' Introduction to X-ray Powder Diffraction, \n'
                                ' pp. 164-165. New York: Wiley.\n'
                                '\n'
                                '<h3>Example:</h3>\n'
                                'Zr filter\n'
                                'Ge 220\n'
                                'none\n'
                                'equatorial mounted graphite (0001)\n'
                                'Si (111), antiparallel</pre>',
 '_pd_instr_monochr_pre_spec': '<pre><h2>_pd_instr_monochr_pre_spec</h2> Indicates the method used '
                               'to obtain monochromatic radiation.\n'
                               ' Use _pd_instr_monochr_pre_spec to describe the primary beam\n'
                               ' monochromator (pre-specimen monochromation). Use\n'
                               ' _pd_instr_monochr_post_spec to specify the\n'
                               ' post-diffraction analyser (post-specimen monochromation).\n'
                               '\n'
                               ' When a monochromator crystal is used, the material and the\n'
                               ' indices of the Bragg reflection are specified.\n'
                               '\n'
                               " Note that monochromators may have either 'parallel' or\n"
                               " 'antiparallel' orientation. It is assumed that the\n"
                               ' geometry is parallel unless specified otherwise.\n'
                               ' In a parallel geometry, the position of the monochromator\n'
                               ' allows the incident beam and the final post-specimen\n'
                               ' and post-monochromator beam to be as close to parallel\n'
                               ' as possible. In a parallel geometry, the diffracting\n'
                               ' planes in the specimen and monochromator will be parallel\n'
                               ' when 2\\q~monochromator~ is equal to 2\\q~specimen~.\n'
                               ' For further discussion see R. Jenkins &amp; R. Snyder (1996).\n'
                               ' Introduction to X-ray Powder Diffraction, \n'
                               ' pp. 164-165. New York: Wiley.\n'
                               '\n'
                               '<h3>Example:</h3>\n'
                               'Zr filter\n'
                               'Ge 220\n'
                               'none\n'
                               'equatorial mounted graphite (0001)\n'
                               'Si (111), antiparallel</pre>',
 '_pd_instr_slit_ax_anal/detc': '<pre><h2>_pd_instr_slit_ax_anal/detc</h2> Describes collimation '
                                'in the axial direction\n'
                                ' (perpendicular to the plane containing the incident\n'
                                ' and diffracted beams) for the instrument as a slit width\n'
                                ' (as opposed to a divergence angle).\n'
                                ' Values are the width of the slit (in millimetres) defining:\n'
                                '   *_src/mono, collimation between the radiation source\n'
                                '       and the monochromator;\n'
                                '   *_mono/spec, collimation between the monochromator and\n'
                                '       the specimen;\n'
                                '   *_src/spec, collimation between the radiation source\n'
                                '       and the specimen;\n'
                                '   *_spec/anal, collimation between the specimen and the\n'
                                '       analyser;\n'
                                '   *_anal/detc, collimation between the analyser and the\n'
                                '       detector;\n'
                                '   *_spec/detc, collimation between the specimen and the\n'
                                '       detector.\n'
                                '\n'
                                ' Note that *_src/spec is used in place of *_src/mono and \n'
                                ' *_mono/spec if there is no monochromator in use, and \n'
                                ' *_spec/detc is used in place of *_spec/anal and *_anal/detc \n'
                                ' if there is no analyser in use.</pre>',
 '_pd_instr_slit_ax_mono/spec': '<pre><h2>_pd_instr_slit_ax_mono/spec</h2> Describes collimation '
                                'in the axial direction\n'
                                ' (perpendicular to the plane containing the incident\n'
                                ' and diffracted beams) for the instrument as a slit width\n'
                                ' (as opposed to a divergence angle).\n'
                                ' Values are the width of the slit (in millimetres) defining:\n'
                                '   *_src/mono, collimation between the radiation source\n'
                                '       and the monochromator;\n'
                                '   *_mono/spec, collimation between the monochromator and\n'
                                '       the specimen;\n'
                                '   *_src/spec, collimation between the radiation source\n'
                                '       and the specimen;\n'
                                '   *_spec/anal, collimation between the specimen and the\n'
                                '       analyser;\n'
                                '   *_anal/detc, collimation between the analyser and the\n'
                                '       detector;\n'
                                '   *_spec/detc, collimation between the specimen and the\n'
                                '       detector.\n'
                                '\n'
                                ' Note that *_src/spec is used in place of *_src/mono and \n'
                                ' *_mono/spec if there is no monochromator in use, and \n'
                                ' *_spec/detc is used in place of *_spec/anal and *_anal/detc \n'
                                ' if there is no analyser in use.</pre>',
 '_pd_instr_slit_ax_spec/anal': '<pre><h2>_pd_instr_slit_ax_spec/anal</h2> Describes collimation '
                                'in the axial direction\n'
                                ' (perpendicular to the plane containing the incident\n'
                                ' and diffracted beams) for the instrument as a slit width\n'
                                ' (as opposed to a divergence angle).\n'
                                ' Values are the width of the slit (in millimetres) defining:\n'
                                '   *_src/mono, collimation between the radiation source\n'
                                '       and the monochromator;\n'
                                '   *_mono/spec, collimation between the monochromator and\n'
                                '       the specimen;\n'
                                '   *_src/spec, collimation between the radiation source\n'
                                '       and the specimen;\n'
                                '   *_spec/anal, collimation between the specimen and the\n'
                                '       analyser;\n'
                                '   *_anal/detc, collimation between the analyser and the\n'
                                '       detector;\n'
                                '   *_spec/detc, collimation between the specimen and the\n'
                                '       detector.\n'
                                '\n'
                                ' Note that *_src/spec is used in place of *_src/mono and \n'
                                ' *_mono/spec if there is no monochromator in use, and \n'
                                ' *_spec/detc is used in place of *_spec/anal and *_anal/detc \n'
                                ' if there is no analyser in use.</pre>',
 '_pd_instr_slit_ax_spec/detc': '<pre><h2>_pd_instr_slit_ax_spec/detc</h2> Describes collimation '
                                'in the axial direction\n'
                                ' (perpendicular to the plane containing the incident\n'
                                ' and diffracted beams) for the instrument as a slit width\n'
                                ' (as opposed to a divergence angle).\n'
                                ' Values are the width of the slit (in millimetres) defining:\n'
                                '   *_src/mono, collimation between the radiation source\n'
                                '       and the monochromator;\n'
                                '   *_mono/spec, collimation between the monochromator and\n'
                                '       the specimen;\n'
                                '   *_src/spec, collimation between the radiation source\n'
                                '       and the specimen;\n'
                                '   *_spec/anal, collimation between the specimen and the\n'
                                '       analyser;\n'
                                '   *_anal/detc, collimation between the analyser and the\n'
                                '       detector;\n'
                                '   *_spec/detc, collimation between the specimen and the\n'
                                '       detector.\n'
                                '\n'
                                ' Note that *_src/spec is used in place of *_src/mono and \n'
                                ' *_mono/spec if there is no monochromator in use, and \n'
                                ' *_spec/detc is used in place of *_spec/anal and *_anal/detc \n'
                                ' if there is no analyser in use.</pre>',
 '_pd_instr_slit_ax_src/mono': '<pre><h2>_pd_instr_slit_ax_src/mono</h2> Describes collimation in '
                               'the axial direction\n'
                               ' (perpendicular to the plane containing the incident\n'
                               ' and diffracted beams) for the instrument as a slit width\n'
                               ' (as opposed to a divergence angle).\n'
                               ' Values are the width of the slit (in millimetres) defining:\n'
                               '   *_src/mono, collimation between the radiation source\n'
                               '       and the monochromator;\n'
                               '   *_mono/spec, collimation between the monochromator and\n'
                               '       the specimen;\n'
                               '   *_src/spec, collimation between the radiation source\n'
                               '       and the specimen;\n'
                               '   *_spec/anal, collimation between the specimen and the\n'
                               '       analyser;\n'
                               '   *_anal/detc, collimation between the analyser and the\n'
                               '       detector;\n'
                               '   *_spec/detc, collimation between the specimen and the\n'
                               '       detector.\n'
                               '\n'
                               ' Note that *_src/spec is used in place of *_src/mono and \n'
                               ' *_mono/spec if there is no monochromator in use, and \n'
                               ' *_spec/detc is used in place of *_spec/anal and *_anal/detc \n'
                               ' if there is no analyser in use.</pre>',
 '_pd_instr_slit_ax_src/spec': '<pre><h2>_pd_instr_slit_ax_src/spec</h2> Describes collimation in '
                               'the axial direction\n'
                               ' (perpendicular to the plane containing the incident\n'
                               ' and diffracted beams) for the instrument as a slit width\n'
                               ' (as opposed to a divergence angle).\n'
                               ' Values are the width of the slit (in millimetres) defining:\n'
                               '   *_src/mono, collimation between the radiation source\n'
                               '       and the monochromator;\n'
                               '   *_mono/spec, collimation between the monochromator and\n'
                               '       the specimen;\n'
                               '   *_src/spec, collimation between the radiation source\n'
                               '       and the specimen;\n'
                               '   *_spec/anal, collimation between the specimen and the\n'
                               '       analyser;\n'
                               '   *_anal/detc, collimation between the analyser and the\n'
                               '       detector;\n'
                               '   *_spec/detc, collimation between the specimen and the\n'
                               '       detector.\n'
                               '\n'
                               ' Note that *_src/spec is used in place of *_src/mono and \n'
                               ' *_mono/spec if there is no monochromator in use, and \n'
                               ' *_spec/detc is used in place of *_spec/anal and *_anal/detc \n'
                               ' if there is no analyser in use.</pre>',
 '_pd_instr_slit_eq_anal/detc': '<pre><h2>_pd_instr_slit_eq_anal/detc</h2> Describes collimation '
                                'in the equatorial plane (the plane\n'
                                ' containing the incident and diffracted beams) for the\n'
                                ' instrument as a slit width (as opposed to a divergence angle).\n'
                                ' Values are the width of the slit (in millimetres) defining:\n'
                                '   *_src/mono, collimation between the radiation source\n'
                                '       and the monochromator;\n'
                                '   *_mono/spec, collimation between the monochromator and\n'
                                '       the specimen;\n'
                                '   *_src/spec, collimation between the radiation source\n'
                                '       and the specimen;\n'
                                '   *_spec/anal, collimation between the specimen and the\n'
                                '       analyser;\n'
                                '   *_anal/detc, collimation between the analyser and the\n'
                                '       detector;\n'
                                '   *_spec/detc, collimation between the specimen and the\n'
                                '       detector.\n'
                                '\n'
                                ' Note that *_src/spec is used in place of *_src/mono and \n'
                                ' *_mono/spec if there is no monochromator in use, and \n'
                                ' *_spec/detc is used in place of *_spec/anal and \n'
                                ' *_anal/detc if there is no analyser in use.</pre>',
 '_pd_instr_slit_eq_mono/spec': '<pre><h2>_pd_instr_slit_eq_mono/spec</h2> Describes collimation '
                                'in the equatorial plane (the plane\n'
                                ' containing the incident and diffracted beams) for the\n'
                                ' instrument as a slit width (as opposed to a divergence angle).\n'
                                ' Values are the width of the slit (in millimetres) defining:\n'
                                '   *_src/mono, collimation between the radiation source\n'
                                '       and the monochromator;\n'
                                '   *_mono/spec, collimation between the monochromator and\n'
                                '       the specimen;\n'
                                '   *_src/spec, collimation between the radiation source\n'
                                '       and the specimen;\n'
                                '   *_spec/anal, collimation between the specimen and the\n'
                                '       analyser;\n'
                                '   *_anal/detc, collimation between the analyser and the\n'
                                '       detector;\n'
                                '   *_spec/detc, collimation between the specimen and the\n'
                                '       detector.\n'
                                '\n'
                                ' Note that *_src/spec is used in place of *_src/mono and \n'
                                ' *_mono/spec if there is no monochromator in use, and \n'
                                ' *_spec/detc is used in place of *_spec/anal and \n'
                                ' *_anal/detc if there is no analyser in use.</pre>',
 '_pd_instr_slit_eq_spec/anal': '<pre><h2>_pd_instr_slit_eq_spec/anal</h2> Describes collimation '
                                'in the equatorial plane (the plane\n'
                                ' containing the incident and diffracted beams) for the\n'
                                ' instrument as a slit width (as opposed to a divergence angle).\n'
                                ' Values are the width of the slit (in millimetres) defining:\n'
                                '   *_src/mono, collimation between the radiation source\n'
                                '       and the monochromator;\n'
                                '   *_mono/spec, collimation between the monochromator and\n'
                                '       the specimen;\n'
                                '   *_src/spec, collimation between the radiation source\n'
                                '       and the specimen;\n'
                                '   *_spec/anal, collimation between the specimen and the\n'
                                '       analyser;\n'
                                '   *_anal/detc, collimation between the analyser and the\n'
                                '       detector;\n'
                                '   *_spec/detc, collimation between the specimen and the\n'
                                '       detector.\n'
                                '\n'
                                ' Note that *_src/spec is used in place of *_src/mono and \n'
                                ' *_mono/spec if there is no monochromator in use, and \n'
                                ' *_spec/detc is used in place of *_spec/anal and \n'
                                ' *_anal/detc if there is no analyser in use.</pre>',
 '_pd_instr_slit_eq_spec/detc': '<pre><h2>_pd_instr_slit_eq_spec/detc</h2> Describes collimation '
                                'in the equatorial plane (the plane\n'
                                ' containing the incident and diffracted beams) for the\n'
                                ' instrument as a slit width (as opposed to a divergence angle).\n'
                                ' Values are the width of the slit (in millimetres) defining:\n'
                                '   *_src/mono, collimation between the radiation source\n'
                                '       and the monochromator;\n'
                                '   *_mono/spec, collimation between the monochromator and\n'
                                '       the specimen;\n'
                                '   *_src/spec, collimation between the radiation source\n'
                                '       and the specimen;\n'
                                '   *_spec/anal, collimation between the specimen and the\n'
                                '       analyser;\n'
                                '   *_anal/detc, collimation between the analyser and the\n'
                                '       detector;\n'
                                '   *_spec/detc, collimation between the specimen and the\n'
                                '       detector.\n'
                                '\n'
                                ' Note that *_src/spec is used in place of *_src/mono and \n'
                                ' *_mono/spec if there is no monochromator in use, and \n'
                                ' *_spec/detc is used in place of *_spec/anal and \n'
                                ' *_anal/detc if there is no analyser in use.</pre>',
 '_pd_instr_slit_eq_src/mono': '<pre><h2>_pd_instr_slit_eq_src/mono</h2> Describes collimation in '
                               'the equatorial plane (the plane\n'
                               ' containing the incident and diffracted beams) for the\n'
                               ' instrument as a slit width (as opposed to a divergence angle).\n'
                               ' Values are the width of the slit (in millimetres) defining:\n'
                               '   *_src/mono, collimation between the radiation source\n'
                               '       and the monochromator;\n'
                               '   *_mono/spec, collimation between the monochromator and\n'
                               '       the specimen;\n'
                               '   *_src/spec, collimation between the radiation source\n'
                               '       and the specimen;\n'
                               '   *_spec/anal, collimation between the specimen and the\n'
                               '       analyser;\n'
                               '   *_anal/detc, collimation between the analyser and the\n'
                               '       detector;\n'
                               '   *_spec/detc, collimation between the specimen and the\n'
                               '       detector.\n'
                               '\n'
                               ' Note that *_src/spec is used in place of *_src/mono and \n'
                               ' *_mono/spec if there is no monochromator in use, and \n'
                               ' *_spec/detc is used in place of *_spec/anal and \n'
                               ' *_anal/detc if there is no analyser in use.</pre>',
 '_pd_instr_slit_eq_src/spec': '<pre><h2>_pd_instr_slit_eq_src/spec</h2> Describes collimation in '
                               'the equatorial plane (the plane\n'
                               ' containing the incident and diffracted beams) for the\n'
                               ' instrument as a slit width (as opposed to a divergence angle).\n'
                               ' Values are the width of the slit (in millimetres) defining:\n'
                               '   *_src/mono, collimation between the radiation source\n'
                               '       and the monochromator;\n'
                               '   *_mono/spec, collimation between the monochromator and\n'
                               '       the specimen;\n'
                               '   *_src/spec, collimation between the radiation source\n'
                               '       and the specimen;\n'
                               '   *_spec/anal, collimation between the specimen and the\n'
                               '       analyser;\n'
                               '   *_anal/detc, collimation between the analyser and the\n'
                               '       detector;\n'
                               '   *_spec/detc, collimation between the specimen and the\n'
                               '       detector.\n'
                               '\n'
                               ' Note that *_src/spec is used in place of *_src/mono and \n'
                               ' *_mono/spec if there is no monochromator in use, and \n'
                               ' *_spec/detc is used in place of *_spec/anal and \n'
                               ' *_anal/detc if there is no analyser in use.</pre>',
 '_pd_instr_soller_ax_anal/detc': '<pre><h2>_pd_instr_soller_ax_anal/detc</h2> Describes '
                                  'collimation in the axial direction\n'
                                  ' (perpendicular to the plane containing the incident\n'
                                  ' and diffracted beams) for the instrument.\n'
                                  ' Values are the maximum divergence angles in\n'
                                  ' degrees, as limited by Soller slits located thus:\n'
                                  '   *_src/mono, collimation between the radiation source\n'
                                  '       and the monochromator;\n'
                                  '   *_mono/spec, collimation between the monochromator and\n'
                                  '       the specimen;\n'
                                  '   *_src/spec, collimation between the radiation source\n'
                                  '       and the specimen;\n'
                                  '   *_spec/anal, collimation between the specimen and the\n'
                                  '       analyser;\n'
                                  '   *_anal/detc, collimation between the analyser and the\n'
                                  '       detector;\n'
                                  '   *_spec/detc, collimation between the specimen and the\n'
                                  '       detector.\n'
                                  '\n'
                                  ' Note that *_src/spec is used in place of *_src/mono and \n'
                                  ' *_mono/spec if there is no monochromator in use, and \n'
                                  ' *_spec/detc is used in place of *_spec/anal and \n'
                                  ' *_anal/detc if there is no analyser in use.</pre>',
 '_pd_instr_soller_ax_mono/spec': '<pre><h2>_pd_instr_soller_ax_mono/spec</h2> Describes '
                                  'collimation in the axial direction\n'
                                  ' (perpendicular to the plane containing the incident\n'
                                  ' and diffracted beams) for the instrument.\n'
                                  ' Values are the maximum divergence angles in\n'
                                  ' degrees, as limited by Soller slits located thus:\n'
                                  '   *_src/mono, collimation between the radiation source\n'
                                  '       and the monochromator;\n'
                                  '   *_mono/spec, collimation between the monochromator and\n'
                                  '       the specimen;\n'
                                  '   *_src/spec, collimation between the radiation source\n'
                                  '       and the specimen;\n'
                                  '   *_spec/anal, collimation between the specimen and the\n'
                                  '       analyser;\n'
                                  '   *_anal/detc, collimation between the analyser and the\n'
                                  '       detector;\n'
                                  '   *_spec/detc, collimation between the specimen and the\n'
                                  '       detector.\n'
                                  '\n'
                                  ' Note that *_src/spec is used in place of *_src/mono and \n'
                                  ' *_mono/spec if there is no monochromator in use, and \n'
                                  ' *_spec/detc is used in place of *_spec/anal and \n'
                                  ' *_anal/detc if there is no analyser in use.</pre>',
 '_pd_instr_soller_ax_spec/anal': '<pre><h2>_pd_instr_soller_ax_spec/anal</h2> Describes '
                                  'collimation in the axial direction\n'
                                  ' (perpendicular to the plane containing the incident\n'
                                  ' and diffracted beams) for the instrument.\n'
                                  ' Values are the maximum divergence angles in\n'
                                  ' degrees, as limited by Soller slits located thus:\n'
                                  '   *_src/mono, collimation between the radiation source\n'
                                  '       and the monochromator;\n'
                                  '   *_mono/spec, collimation between the monochromator and\n'
                                  '       the specimen;\n'
                                  '   *_src/spec, collimation between the radiation source\n'
                                  '       and the specimen;\n'
                                  '   *_spec/anal, collimation between the specimen and the\n'
                                  '       analyser;\n'
                                  '   *_anal/detc, collimation between the analyser and the\n'
                                  '       detector;\n'
                                  '   *_spec/detc, collimation between the specimen and the\n'
                                  '       detector.\n'
                                  '\n'
                                  ' Note that *_src/spec is used in place of *_src/mono and \n'
                                  ' *_mono/spec if there is no monochromator in use, and \n'
                                  ' *_spec/detc is used in place of *_spec/anal and \n'
                                  ' *_anal/detc if there is no analyser in use.</pre>',
 '_pd_instr_soller_ax_spec/detc': '<pre><h2>_pd_instr_soller_ax_spec/detc</h2> Describes '
                                  'collimation in the axial direction\n'
                                  ' (perpendicular to the plane containing the incident\n'
                                  ' and diffracted beams) for the instrument.\n'
                                  ' Values are the maximum divergence angles in\n'
                                  ' degrees, as limited by Soller slits located thus:\n'
                                  '   *_src/mono, collimation between the radiation source\n'
                                  '       and the monochromator;\n'
                                  '   *_mono/spec, collimation between the monochromator and\n'
                                  '       the specimen;\n'
                                  '   *_src/spec, collimation between the radiation source\n'
                                  '       and the specimen;\n'
                                  '   *_spec/anal, collimation between the specimen and the\n'
                                  '       analyser;\n'
                                  '   *_anal/detc, collimation between the analyser and the\n'
                                  '       detector;\n'
                                  '   *_spec/detc, collimation between the specimen and the\n'
                                  '       detector.\n'
                                  '\n'
                                  ' Note that *_src/spec is used in place of *_src/mono and \n'
                                  ' *_mono/spec if there is no monochromator in use, and \n'
                                  ' *_spec/detc is used in place of *_spec/anal and \n'
                                  ' *_anal/detc if there is no analyser in use.</pre>',
 '_pd_instr_soller_ax_src/mono': '<pre><h2>_pd_instr_soller_ax_src/mono</h2> Describes collimation '
                                 'in the axial direction\n'
                                 ' (perpendicular to the plane containing the incident\n'
                                 ' and diffracted beams) for the instrument.\n'
                                 ' Values are the maximum divergence angles in\n'
                                 ' degrees, as limited by Soller slits located thus:\n'
                                 '   *_src/mono, collimation between the radiation source\n'
                                 '       and the monochromator;\n'
                                 '   *_mono/spec, collimation between the monochromator and\n'
                                 '       the specimen;\n'
                                 '   *_src/spec, collimation between the radiation source\n'
                                 '       and the specimen;\n'
                                 '   *_spec/anal, collimation between the specimen and the\n'
                                 '       analyser;\n'
                                 '   *_anal/detc, collimation between the analyser and the\n'
                                 '       detector;\n'
                                 '   *_spec/detc, collimation between the specimen and the\n'
                                 '       detector.\n'
                                 '\n'
                                 ' Note that *_src/spec is used in place of *_src/mono and \n'
                                 ' *_mono/spec if there is no monochromator in use, and \n'
                                 ' *_spec/detc is used in place of *_spec/anal and \n'
                                 ' *_anal/detc if there is no analyser in use.</pre>',
 '_pd_instr_soller_ax_src/spec': '<pre><h2>_pd_instr_soller_ax_src/spec</h2> Describes collimation '
                                 'in the axial direction\n'
                                 ' (perpendicular to the plane containing the incident\n'
                                 ' and diffracted beams) for the instrument.\n'
                                 ' Values are the maximum divergence angles in\n'
                                 ' degrees, as limited by Soller slits located thus:\n'
                                 '   *_src/mono, collimation between the radiation source\n'
                                 '       and the monochromator;\n'
                                 '   *_mono/spec, collimation between the monochromator and\n'
                                 '       the specimen;\n'
                                 '   *_src/spec, collimation between the radiation source\n'
                                 '       and the specimen;\n'
                                 '   *_spec/anal, collimation between the specimen and the\n'
                                 '       analyser;\n'
                                 '   *_anal/detc, collimation between the analyser and the\n'
                                 '       detector;\n'
                                 '   *_spec/detc, collimation between the specimen and the\n'
                                 '       detector.\n'
                                 '\n'
                                 ' Note that *_src/spec is used in place of *_src/mono and \n'
                                 ' *_mono/spec if there is no monochromator in use, and \n'
                                 ' *_spec/detc is used in place of *_spec/anal and \n'
                                 ' *_anal/detc if there is no analyser in use.</pre>',
 '_pd_instr_soller_eq_anal/detc': '<pre><h2>_pd_instr_soller_eq_anal/detc</h2> Describes '
                                  'collimation in the equatorial plane (the plane\n'
                                  ' containing the incident and diffracted beams) for\n'
                                  ' the instrument. Values are the maximum divergence angles in\n'
                                  ' degrees, as limited by Soller slits located thus:\n'
                                  '   *_src/mono, collimation between the radiation source\n'
                                  '       and the monochromator;\n'
                                  '   *_mono/spec, collimation between the monochromator and\n'
                                  '       the specimen;\n'
                                  '   *_src/spec, collimation between the radiation source\n'
                                  '       and the specimen;\n'
                                  '   *_spec/anal, collimation between the specimen and the\n'
                                  '       analyser;\n'
                                  '   *_anal/detc, collimation between the analyser and the\n'
                                  '       detector;\n'
                                  '   *_spec/detc, collimation between the specimen and the\n'
                                  '       detector.\n'
                                  '\n'
                                  ' Note that *_src/spec is used in place of *_src/mono and \n'
                                  ' *_mono/spec if there is no monochromator in use, and \n'
                                  ' *_spec/detc is used in place of *_spec/anal and \n'
                                  ' *_anal/detc if there is no analyser in use.</pre>',
 '_pd_instr_soller_eq_mono/spec': '<pre><h2>_pd_instr_soller_eq_mono/spec</h2> Describes '
                                  'collimation in the equatorial plane (the plane\n'
                                  ' containing the incident and diffracted beams) for\n'
                                  ' the instrument. Values are the maximum divergence angles in\n'
                                  ' degrees, as limited by Soller slits located thus:\n'
                                  '   *_src/mono, collimation between the radiation source\n'
                                  '       and the monochromator;\n'
                                  '   *_mono/spec, collimation between the monochromator and\n'
                                  '       the specimen;\n'
                                  '   *_src/spec, collimation between the radiation source\n'
                                  '       and the specimen;\n'
                                  '   *_spec/anal, collimation between the specimen and the\n'
                                  '       analyser;\n'
                                  '   *_anal/detc, collimation between the analyser and the\n'
                                  '       detector;\n'
                                  '   *_spec/detc, collimation between the specimen and the\n'
                                  '       detector.\n'
                                  '\n'
                                  ' Note that *_src/spec is used in place of *_src/mono and \n'
                                  ' *_mono/spec if there is no monochromator in use, and \n'
                                  ' *_spec/detc is used in place of *_spec/anal and \n'
                                  ' *_anal/detc if there is no analyser in use.</pre>',
 '_pd_instr_soller_eq_spec/anal': '<pre><h2>_pd_instr_soller_eq_spec/anal</h2> Describes '
                                  'collimation in the equatorial plane (the plane\n'
                                  ' containing the incident and diffracted beams) for\n'
                                  ' the instrument. Values are the maximum divergence angles in\n'
                                  ' degrees, as limited by Soller slits located thus:\n'
                                  '   *_src/mono, collimation between the radiation source\n'
                                  '       and the monochromator;\n'
                                  '   *_mono/spec, collimation between the monochromator and\n'
                                  '       the specimen;\n'
                                  '   *_src/spec, collimation between the radiation source\n'
                                  '       and the specimen;\n'
                                  '   *_spec/anal, collimation between the specimen and the\n'
                                  '       analyser;\n'
                                  '   *_anal/detc, collimation between the analyser and the\n'
                                  '       detector;\n'
                                  '   *_spec/detc, collimation between the specimen and the\n'
                                  '       detector.\n'
                                  '\n'
                                  ' Note that *_src/spec is used in place of *_src/mono and \n'
                                  ' *_mono/spec if there is no monochromator in use, and \n'
                                  ' *_spec/detc is used in place of *_spec/anal and \n'
                                  ' *_anal/detc if there is no analyser in use.</pre>',
 '_pd_instr_soller_eq_spec/detc': '<pre><h2>_pd_instr_soller_eq_spec/detc</h2> Describes '
                                  'collimation in the equatorial plane (the plane\n'
                                  ' containing the incident and diffracted beams) for\n'
                                  ' the instrument. Values are the maximum divergence angles in\n'
                                  ' degrees, as limited by Soller slits located thus:\n'
                                  '   *_src/mono, collimation between the radiation source\n'
                                  '       and the monochromator;\n'
                                  '   *_mono/spec, collimation between the monochromator and\n'
                                  '       the specimen;\n'
                                  '   *_src/spec, collimation between the radiation source\n'
                                  '       and the specimen;\n'
                                  '   *_spec/anal, collimation between the specimen and the\n'
                                  '       analyser;\n'
                                  '   *_anal/detc, collimation between the analyser and the\n'
                                  '       detector;\n'
                                  '   *_spec/detc, collimation between the specimen and the\n'
                                  '       detector.\n'
                                  '\n'
                                  ' Note that *_src/spec is used in place of *_src/mono and \n'
                                  ' *_mono/spec if there is no monochromator in use, and \n'
                                  ' *_spec/detc is used in place of *_spec/anal and \n'
                                  ' *_anal/detc if there is no analyser in use.</pre>',
 '_pd_instr_soller_eq_src/mono': '<pre><h2>_pd_instr_soller_eq_src/mono</h2> Describes collimation '
                                 'in the equatorial plane (the plane\n'
                                 ' containing the incident and diffracted beams) for\n'
                                 ' the instrument. Values are the maximum divergence angles in\n'
                                 ' degrees, as limited by Soller slits located thus:\n'
                                 '   *_src/mono, collimation between the radiation source\n'
                                 '       and the monochromator;\n'
                                 '   *_mono/spec, collimation between the monochromator and\n'
                                 '       the specimen;\n'
                                 '   *_src/spec, collimation between the radiation source\n'
                                 '       and the specimen;\n'
                                 '   *_spec/anal, collimation between the specimen and the\n'
                                 '       analyser;\n'
                                 '   *_anal/detc, collimation between the analyser and the\n'
                                 '       detector;\n'
                                 '   *_spec/detc, collimation between the specimen and the\n'
                                 '       detector.\n'
                                 '\n'
                                 ' Note that *_src/spec is used in place of *_src/mono and \n'
                                 ' *_mono/spec if there is no monochromator in use, and \n'
                                 ' *_spec/detc is used in place of *_spec/anal and \n'
                                 ' *_anal/detc if there is no analyser in use.</pre>',
 '_pd_instr_soller_eq_src/spec': '<pre><h2>_pd_instr_soller_eq_src/spec</h2> Describes collimation '
                                 'in the equatorial plane (the plane\n'
                                 ' containing the incident and diffracted beams) for\n'
                                 ' the instrument. Values are the maximum divergence angles in\n'
                                 ' degrees, as limited by Soller slits located thus:\n'
                                 '   *_src/mono, collimation between the radiation source\n'
                                 '       and the monochromator;\n'
                                 '   *_mono/spec, collimation between the monochromator and\n'
                                 '       the specimen;\n'
                                 '   *_src/spec, collimation between the radiation source\n'
                                 '       and the specimen;\n'
                                 '   *_spec/anal, collimation between the specimen and the\n'
                                 '       analyser;\n'
                                 '   *_anal/detc, collimation between the analyser and the\n'
                                 '       detector;\n'
                                 '   *_spec/detc, collimation between the specimen and the\n'
                                 '       detector.\n'
                                 '\n'
                                 ' Note that *_src/spec is used in place of *_src/mono and \n'
                                 ' *_mono/spec if there is no monochromator in use, and \n'
                                 ' *_spec/detc is used in place of *_spec/anal and \n'
                                 ' *_anal/detc if there is no analyser in use.</pre>',
 '_pd_instr_source_size_ax': '<pre><h2>_pd_instr_source_size_ax</h2> Axial and equatorial '
                             'intrinsic dimensions\n'
                             ' of the radiation source (in millimetres).\n'
                             ' The perpendicular to the plane containing the incident\n'
                             ' and scattered beam is the axial (*_ax) direction.</pre>',
 '_pd_instr_source_size_eq': '<pre><h2>_pd_instr_source_size_eq</h2> Axial and equatorial '
                             'intrinsic dimensions\n'
                             ' of the radiation source (in millimetres).\n'
                             ' The perpendicular to the plane containing the incident\n'
                             ' and scattered beam is the axial (*_ax) direction.</pre>',
 '_pd_instr_special_details': '<pre><h2>_pd_instr_special_details</h2> A brief description of the '
                              'instrument giving\n'
                              ' details that cannot be given in other\n'
                              ' _pd_instr_ entries.</pre>',
 '_pd_instr_var_illum_len': '<pre><h2>_pd_instr_var_illum_len</h2> Length of the specimen that is '
                            'illuminated by the radiation\n'
                            ' source (in millimetres) for instruments where\n'
                            ' the illumination length varies with 2\\q (fixed\n'
                            ' divergence slits). The _pd_instr_var_illum_len\n'
                            ' values should be included in the same loop as the\n'
                            ' intensity measurements (_pd_meas_).\n'
                            '\n'
                            ' See _pd_instr_cons_illum_len for instruments where\n'
                            ' the divergence slit is \\q-compensated to yield a\n'
                            ' constant illumination length.</pre>',
 '_pd_meas_2theta_fixed': '<pre><h2>_pd_meas_2theta_fixed</h2> The 2\\q diffraction angle in '
                          'degrees for measurements\n'
                          ' in a white-beam fixed-angle experiment. For measurements\n'
                          ' where 2\\q is scanned, see _pd_meas_2theta_scan or\n'
                          ' _pd_meas_2theta_range_.</pre>',
 '_pd_meas_2theta_range_inc': '<pre><h2>_pd_meas_2theta_range_inc</h2> The range of 2\\q '
                              'diffraction angles in degrees for the\n'
                              ' measurement of intensities. These may be used in place of the\n'
                              ' _pd_meas_2theta_scan values for data sets measured with a\n'
                              ' constant step size.</pre>',
 '_pd_meas_2theta_range_max': '<pre><h2>_pd_meas_2theta_range_max</h2> The range of 2\\q '
                              'diffraction angles in degrees for the\n'
                              ' measurement of intensities. These may be used in place of the\n'
                              ' _pd_meas_2theta_scan values for data sets measured with a\n'
                              ' constant step size.</pre>',
 '_pd_meas_2theta_range_min': '<pre><h2>_pd_meas_2theta_range_min</h2> The range of 2\\q '
                              'diffraction angles in degrees for the\n'
                              ' measurement of intensities. These may be used in place of the\n'
                              ' _pd_meas_2theta_scan values for data sets measured with a\n'
                              ' constant step size.</pre>',
 '_pd_meas_2theta_scan': '<pre><h2>_pd_meas_2theta_scan</h2> 2\\q diffraction angle (in degrees) '
                         'for intensity\n'
                         ' points measured in a scanning method. The scan method used\n'
                         ' (e.g. continuous or step scan) should be specified in\n'
                         ' the item _pd_meas_scan_method. For fixed 2\\q (white-beam)\n'
                         ' experiments, use _pd_meas_2theta_fixed. In the case of\n'
                         ' continuous-scan data sets, the 2\\q value should be the\n'
                         ' value at the midpoint of the counting period. Associated\n'
                         ' with each _pd_meas_2theta_scan value will be\n'
                         ' _pd_meas_counts_ items. The 2\\q values should\n'
                         ' not be corrected for nonlinearity,\n'
                         ' zero offset etc. Corrected values may be specified\n'
                         ' using _pd_proc_2theta_corrected.\n'
                         '\n'
                         ' Note that for data sets collected with constant step size,\n'
                         ' _pd_meas_2theta_range_ (*_min, *_max and *_inc) may be\n'
                         ' used instead of _pd_meas_2theta_scan.</pre>',
 '_pd_meas_[pd]': '<pre><h2>_pd_meas_[pd]</h2> This section contains the measured diffractogram '
                  'and information\n'
                  ' about the conditions used for the measurement of the diffraction \n'
                  ' data set, prior to processing and application of correction\n'
                  ' terms. While additional information may be added to the CIF\n'
                  ' as data are processed and transported between laboratories\n'
                  ' (possibly with the addition of a new _pd_block_id entry), the\n'
                  ' information in this section of the CIF will rarely be changed\n'
                  ' once data collection is complete.\n'
                  '\n'
                  ' Where possible, measurements in this section should have no\n'
                  ' post-collection processing applied (normalizations, corrections,\n'
                  ' smoothing, zero-offset corrections etc.). Such corrected\n'
                  ' measurements should be recorded in the _pd_proc_ section.\n'
                  '\n'
                  ' Data sets that are measured as counts, where a standard\n'
                  ' uncertainty can be considered equivalent to the standard\n'
                  ' deviation and where the standard deviation can be estimated\n'
                  ' as the square root of the number of counts recorded, should\n'
                  ' use the _pd_meas_counts_ fields. All other intensity values\n'
                  ' should be recorded using _pd_meas_intensity_.\n'
                  '\n'
                  '<h3>Example:</h3>\n'
                  '\n'
                  "    _pd_meas_info_author_name        'Cranswick, Lachlan'\n"
                  '    _pd_meas_info_author_email       lachlan@dmp.csiro.au\n'
                  '    _pd_meas_info_author_address     ?\n'
                  '    _pd_meas_datetime_initiated      1992-03-23T17:20\n'
                  '\n'
                  '    _pd_meas_scan_method             step\n'
                  '    _pd_meas_2theta_range_min        6.0\n'
                  '    _pd_meas_2theta_range_max        164.0\n'
                  '    _pd_meas_2theta_range_inc        0.025\n'
                  '    _pd_meas_step_count_time         2.0</pre>',
 '_pd_meas_angle_2theta': '<pre><h2>_pd_meas_angle_2theta</h2> The diffractometer angles in '
                          'degrees for an instrument with a\n'
                          ' Euler circle. The definitions for these angles follow the\n'
                          ' convention of International Tables for X-ray Crystallography\n'
                          ' (1974), Vol. IV, p. 276.</pre>',
 '_pd_meas_angle_chi': '<pre><h2>_pd_meas_angle_chi</h2> The diffractometer angles in degrees for '
                       'an instrument with a\n'
                       ' Euler circle. The definitions for these angles follow the\n'
                       ' convention of International Tables for X-ray Crystallography\n'
                       ' (1974), Vol. IV, p. 276.</pre>',
 '_pd_meas_angle_omega': '<pre><h2>_pd_meas_angle_omega</h2> The diffractometer angles in degrees '
                         'for an instrument with a\n'
                         ' Euler circle. The definitions for these angles follow the\n'
                         ' convention of International Tables for X-ray Crystallography\n'
                         ' (1974), Vol. IV, p. 276.</pre>',
 '_pd_meas_angle_phi': '<pre><h2>_pd_meas_angle_phi</h2> The diffractometer angles in degrees for '
                       'an instrument with a\n'
                       ' Euler circle. The definitions for these angles follow the\n'
                       ' convention of International Tables for X-ray Crystallography\n'
                       ' (1974), Vol. IV, p. 276.</pre>',
 '_pd_meas_counts_background': '<pre><h2>_pd_meas_counts_background</h2> Counts measured at the '
                               'measurement point as a function of\n'
                               ' angle, time, channel or some other variable (see\n'
                               ' _pd_meas_2theta_ etc.).\n'
                               '\n'
                               ' The defined fields are:\n'
                               '   _pd_meas_counts_total, scattering from the specimen\n'
                               '     (with background, specimen mounting or container\n'
                               '     scattering included);\n'
                               '   _pd_meas_counts_background, scattering measured\n'
                               '     without a specimen, specimen mounting etc., often\n'
                               '     referred to as the instrument background;\n'
                               '   _pd_meas_counts_container, the specimen container or\n'
                               '     mounting without a specimen, includes background;\n'
                               '   _pd_meas_counts_monitor, counts measured by an \n'
                               '     incident-beam monitor to calibrate the flux on the \n'
                               '     specimen.\n'
                               '\n'
                               ' Corrections for background, detector dead time etc.\n'
                               ' should not have been made to these values. Instead use\n'
                               ' _pd_proc_intensity_ for corrected diffractograms.\n'
                               '\n'
                               ' Note that counts-per-second values should be converted to\n'
                               ' total counts. If the counting time varies for different\n'
                               ' points, it may be included in the loop using\n'
                               ' _pd_meas_step_count_time.\n'
                               '\n'
                               ' Standard uncertainties should not be quoted for these values.\n'
                               ' If the standard uncertainties differ from the square root of\n'
                               ' the number of counts, _pd_meas_intensity_ should be used.</pre>',
 '_pd_meas_counts_container': '<pre><h2>_pd_meas_counts_container</h2> Counts measured at the '
                              'measurement point as a function of\n'
                              ' angle, time, channel or some other variable (see\n'
                              ' _pd_meas_2theta_ etc.).\n'
                              '\n'
                              ' The defined fields are:\n'
                              '   _pd_meas_counts_total, scattering from the specimen\n'
                              '     (with background, specimen mounting or container\n'
                              '     scattering included);\n'
                              '   _pd_meas_counts_background, scattering measured\n'
                              '     without a specimen, specimen mounting etc., often\n'
                              '     referred to as the instrument background;\n'
                              '   _pd_meas_counts_container, the specimen container or\n'
                              '     mounting without a specimen, includes background;\n'
                              '   _pd_meas_counts_monitor, counts measured by an \n'
                              '     incident-beam monitor to calibrate the flux on the \n'
                              '     specimen.\n'
                              '\n'
                              ' Corrections for background, detector dead time etc.\n'
                              ' should not have been made to these values. Instead use\n'
                              ' _pd_proc_intensity_ for corrected diffractograms.\n'
                              '\n'
                              ' Note that counts-per-second values should be converted to\n'
                              ' total counts. If the counting time varies for different\n'
                              ' points, it may be included in the loop using\n'
                              ' _pd_meas_step_count_time.\n'
                              '\n'
                              ' Standard uncertainties should not be quoted for these values.\n'
                              ' If the standard uncertainties differ from the square root of\n'
                              ' the number of counts, _pd_meas_intensity_ should be used.</pre>',
 '_pd_meas_counts_monitor': '<pre><h2>_pd_meas_counts_monitor</h2> Counts measured at the '
                            'measurement point as a function of\n'
                            ' angle, time, channel or some other variable (see\n'
                            ' _pd_meas_2theta_ etc.).\n'
                            '\n'
                            ' The defined fields are:\n'
                            '   _pd_meas_counts_total, scattering from the specimen\n'
                            '     (with background, specimen mounting or container\n'
                            '     scattering included);\n'
                            '   _pd_meas_counts_background, scattering measured\n'
                            '     without a specimen, specimen mounting etc., often\n'
                            '     referred to as the instrument background;\n'
                            '   _pd_meas_counts_container, the specimen container or\n'
                            '     mounting without a specimen, includes background;\n'
                            '   _pd_meas_counts_monitor, counts measured by an \n'
                            '     incident-beam monitor to calibrate the flux on the \n'
                            '     specimen.\n'
                            '\n'
                            ' Corrections for background, detector dead time etc.\n'
                            ' should not have been made to these values. Instead use\n'
                            ' _pd_proc_intensity_ for corrected diffractograms.\n'
                            '\n'
                            ' Note that counts-per-second values should be converted to\n'
                            ' total counts. If the counting time varies for different\n'
                            ' points, it may be included in the loop using\n'
                            ' _pd_meas_step_count_time.\n'
                            '\n'
                            ' Standard uncertainties should not be quoted for these values.\n'
                            ' If the standard uncertainties differ from the square root of\n'
                            ' the number of counts, _pd_meas_intensity_ should be used.</pre>',
 '_pd_meas_counts_total': '<pre><h2>_pd_meas_counts_total</h2> Counts measured at the measurement '
                          'point as a function of\n'
                          ' angle, time, channel or some other variable (see\n'
                          ' _pd_meas_2theta_ etc.).\n'
                          '\n'
                          ' The defined fields are:\n'
                          '   _pd_meas_counts_total, scattering from the specimen\n'
                          '     (with background, specimen mounting or container\n'
                          '     scattering included);\n'
                          '   _pd_meas_counts_background, scattering measured\n'
                          '     without a specimen, specimen mounting etc., often\n'
                          '     referred to as the instrument background;\n'
                          '   _pd_meas_counts_container, the specimen container or\n'
                          '     mounting without a specimen, includes background;\n'
                          '   _pd_meas_counts_monitor, counts measured by an \n'
                          '     incident-beam monitor to calibrate the flux on the \n'
                          '     specimen.\n'
                          '\n'
                          ' Corrections for background, detector dead time etc.\n'
                          ' should not have been made to these values. Instead use\n'
                          ' _pd_proc_intensity_ for corrected diffractograms.\n'
                          '\n'
                          ' Note that counts-per-second values should be converted to\n'
                          ' total counts. If the counting time varies for different\n'
                          ' points, it may be included in the loop using\n'
                          ' _pd_meas_step_count_time.\n'
                          '\n'
                          ' Standard uncertainties should not be quoted for these values.\n'
                          ' If the standard uncertainties differ from the square root of\n'
                          ' the number of counts, _pd_meas_intensity_ should be used.</pre>',
 '_pd_meas_datetime_initiated': '<pre><h2>_pd_meas_datetime_initiated</h2> The date and time of '
                                'the data-set measurement. Entries follow\n'
                                " the standard CIF format 'yyyy-mm-ddThh:mm:ss+zz'. Use\n"
                                ' of seconds and a time zone is optional, but use of hours\n'
                                ' and minutes is strongly encouraged. Where possible, give the\n'
                                ' time when the measurement was started rather than when\n'
                                ' it was completed.\n'
                                '\n'
                                '<h3>Example:</h3>\n'
                                '1990-07-13T14:40</pre>',
 '_pd_meas_detector_id': '<pre><h2>_pd_meas_detector_id</h2> A code or number which identifies the '
                         'measuring detector or\n'
                         ' channel number in a position-sensitive, energy-dispersive\n'
                         ' or other multiple-detector instrument.\n'
                         '\n'
                         ' Calibration information, such as angle offsets or\n'
                         ' a calibration function to convert channel numbers\n'
                         ' to Q, energy, wavelength, angle etc. should\n'
                         ' be described with _pd_calib_ values. If\n'
                         " _pd_calibration_conversion_eqn is used, the detector ID's\n"
                         ' should be the number to be used in the equation.</pre>',
 '_pd_meas_info_author_address': '<pre><h2>_pd_meas_info_author_address</h2> The address of the '
                                 'person who measured the data set. If there\n'
                                 ' is more than one person, this will be looped with\n'
                                 ' _pd_meas_info_author_name.</pre>',
 '_pd_meas_info_author_email': '<pre><h2>_pd_meas_info_author_email</h2> The e-mail address of the '
                               'person who measured the data set. If\n'
                               ' there is more than one person, this will be looped with\n'
                               ' _pd_meas_info_author_name.</pre>',
 '_pd_meas_info_author_fax': '<pre><h2>_pd_meas_info_author_fax</h2> The fax number of the person '
                             'who measured the data set. If\n'
                             ' there is more than one person, this will be looped with\n'
                             ' _pd_meas_info_author_name. The recommended style is\n'
                             ' the international dialing prefix, followed by the area code in\n'
                             ' parentheses, followed by the local number with no spaces.</pre>',
 '_pd_meas_info_author_name': '<pre><h2>_pd_meas_info_author_name</h2> The name of the person who '
                              'measured the data set. The family\n'
                              ' name(s), followed by a comma and including any dynastic\n'
                              ' components, precedes the first name(s) or initial(s).\n'
                              ' For more than one person use a loop to specify multiple '
                              'values.</pre>',
 '_pd_meas_info_author_phone': '<pre><h2>_pd_meas_info_author_phone</h2> The telephone number of '
                               'the person who measured the data set.\n'
                               ' If there is more than one person, this will be looped with\n'
                               ' _pd_meas_info_author_name. The recommended style is\n'
                               ' the international dialing prefix, followed by the area code in\n'
                               ' parentheses, followed by the local number with no spaces.</pre>',
 '_pd_meas_intensity_background': '<pre><h2>_pd_meas_intensity_background</h2> Intensity '
                                  'measurements at the measurement point (see\n'
                                  ' the definition of _pd_meas_2theta_).\n'
                                  '\n'
                                  ' The defined fields are:\n'
                                  '   _pd_meas_intensity_total, scattering from the specimen\n'
                                  '     (with background, specimen mounting or container\n'
                                  '     scattering included);\n'
                                  '   _pd_meas_intensity_background, scattering measured\n'
                                  '     without a specimen, specimen mounting etc., often\n'
                                  '     referred to as the instrument background;\n'
                                  '   _pd_meas_intensity_container, the specimen container or\n'
                                  '     mounting without a specimen, includes background;\n'
                                  '   _pd_meas_intensity_monitor, intensity measured by an\n'
                                  '     incident-beam monitor to calibrate the flux on the '
                                  'specimen.\n'
                                  '\n'
                                  ' Use these entries for measurements where intensity\n'
                                  ' values are not counts (use _pd_meas_counts_ for '
                                  'event-counting\n'
                                  ' measurements where the standard uncertainty is\n'
                                  ' estimated as the square root of the number of counts).\n'
                                  '\n'
                                  ' Corrections for background, detector dead time etc.,\n'
                                  ' should not have been made to these values. Instead use\n'
                                  ' _pd_proc_intensity_ for corrected diffractograms.\n'
                                  '\n'
                                  ' _pd_meas_units_of_intensity should be used to specify\n'
                                  ' the units of the intensity measurements.</pre>',
 '_pd_meas_intensity_container': '<pre><h2>_pd_meas_intensity_container</h2> Intensity '
                                 'measurements at the measurement point (see\n'
                                 ' the definition of _pd_meas_2theta_).\n'
                                 '\n'
                                 ' The defined fields are:\n'
                                 '   _pd_meas_intensity_total, scattering from the specimen\n'
                                 '     (with background, specimen mounting or container\n'
                                 '     scattering included);\n'
                                 '   _pd_meas_intensity_background, scattering measured\n'
                                 '     without a specimen, specimen mounting etc., often\n'
                                 '     referred to as the instrument background;\n'
                                 '   _pd_meas_intensity_container, the specimen container or\n'
                                 '     mounting without a specimen, includes background;\n'
                                 '   _pd_meas_intensity_monitor, intensity measured by an\n'
                                 '     incident-beam monitor to calibrate the flux on the '
                                 'specimen.\n'
                                 '\n'
                                 ' Use these entries for measurements where intensity\n'
                                 ' values are not counts (use _pd_meas_counts_ for event-counting\n'
                                 ' measurements where the standard uncertainty is\n'
                                 ' estimated as the square root of the number of counts).\n'
                                 '\n'
                                 ' Corrections for background, detector dead time etc.,\n'
                                 ' should not have been made to these values. Instead use\n'
                                 ' _pd_proc_intensity_ for corrected diffractograms.\n'
                                 '\n'
                                 ' _pd_meas_units_of_intensity should be used to specify\n'
                                 ' the units of the intensity measurements.</pre>',
 '_pd_meas_intensity_monitor': '<pre><h2>_pd_meas_intensity_monitor</h2> Intensity measurements at '
                               'the measurement point (see\n'
                               ' the definition of _pd_meas_2theta_).\n'
                               '\n'
                               ' The defined fields are:\n'
                               '   _pd_meas_intensity_total, scattering from the specimen\n'
                               '     (with background, specimen mounting or container\n'
                               '     scattering included);\n'
                               '   _pd_meas_intensity_background, scattering measured\n'
                               '     without a specimen, specimen mounting etc., often\n'
                               '     referred to as the instrument background;\n'
                               '   _pd_meas_intensity_container, the specimen container or\n'
                               '     mounting without a specimen, includes background;\n'
                               '   _pd_meas_intensity_monitor, intensity measured by an\n'
                               '     incident-beam monitor to calibrate the flux on the specimen.\n'
                               '\n'
                               ' Use these entries for measurements where intensity\n'
                               ' values are not counts (use _pd_meas_counts_ for event-counting\n'
                               ' measurements where the standard uncertainty is\n'
                               ' estimated as the square root of the number of counts).\n'
                               '\n'
                               ' Corrections for background, detector dead time etc.,\n'
                               ' should not have been made to these values. Instead use\n'
                               ' _pd_proc_intensity_ for corrected diffractograms.\n'
                               '\n'
                               ' _pd_meas_units_of_intensity should be used to specify\n'
                               ' the units of the intensity measurements.</pre>',
 '_pd_meas_intensity_total': '<pre><h2>_pd_meas_intensity_total</h2> Intensity measurements at the '
                             'measurement point (see\n'
                             ' the definition of _pd_meas_2theta_).\n'
                             '\n'
                             ' The defined fields are:\n'
                             '   _pd_meas_intensity_total, scattering from the specimen\n'
                             '     (with background, specimen mounting or container\n'
                             '     scattering included);\n'
                             '   _pd_meas_intensity_background, scattering measured\n'
                             '     without a specimen, specimen mounting etc., often\n'
                             '     referred to as the instrument background;\n'
                             '   _pd_meas_intensity_container, the specimen container or\n'
                             '     mounting without a specimen, includes background;\n'
                             '   _pd_meas_intensity_monitor, intensity measured by an\n'
                             '     incident-beam monitor to calibrate the flux on the specimen.\n'
                             '\n'
                             ' Use these entries for measurements where intensity\n'
                             ' values are not counts (use _pd_meas_counts_ for event-counting\n'
                             ' measurements where the standard uncertainty is\n'
                             ' estimated as the square root of the number of counts).\n'
                             '\n'
                             ' Corrections for background, detector dead time etc.,\n'
                             ' should not have been made to these values. Instead use\n'
                             ' _pd_proc_intensity_ for corrected diffractograms.\n'
                             '\n'
                             ' _pd_meas_units_of_intensity should be used to specify\n'
                             ' the units of the intensity measurements.</pre>',
 '_pd_meas_number_of_points': '<pre><h2>_pd_meas_number_of_points</h2> The total number of points '
                              'in the measured\n'
                              ' diffractogram.</pre>',
 '_pd_meas_point_id': '<pre><h2>_pd_meas_point_id</h2> Arbitrary label identifying a measured data '
                      'point. Used to\n'
                      ' identify a specific entry in a list of measured intensities.\n'
                      ' The role of this identifier may be adopted by\n'
                      ' _pd_data_point_id if measured, processed and calculated\n'
                      ' intensity values are combined in a single list.</pre>',
 '_pd_meas_position': '<pre><h2>_pd_meas_position</h2> A linear distance in millimetres '
                      'corresponding to the\n'
                      ' location where an intensity measurement is made.\n'
                      ' Used for detectors where a distance measurement is made\n'
                      ' as a direct observable, such as from a microdensitometer\n'
                      ' trace from film or a strip chart recorder. This is an\n'
                      ' alternative to _pd_meas_2theta_scan, which should only be\n'
                      ' used for instruments that record intensities directly\n'
                      ' against 2\\q. For instruments where the position scale\n'
                      ' is nonlinear, the data item _pd_meas_detector_id should\n'
                      ' be used to record positions.\n'
                      '\n'
                      ' Calibration information, such as angle offsets or a\n'
                      ' function to convert this distance to a 2\\q angle\n'
                      ' or d-space, should be supplied with the _pd_calib_ values.\n'
                      '\n'
                      ' Do not confuse this with the instrument geometry\n'
                      ' descriptions given by _pd_instr_dist_.</pre>',
 '_pd_meas_rocking_angle': '<pre><h2>_pd_meas_rocking_angle</h2> The angular range in degrees '
                           'through which a sample is rotated\n'
                           ' or oscillated during a measurement step\n'
                           ' (see _pd_meas_rocking_axis).</pre>',
 '_pd_meas_rocking_axis': '<pre><h2>_pd_meas_rocking_axis</h2> Description of the axis (or axes) '
                          'used to rotate or rock the\n'
                          ' specimen for better randomization of crystallites\n'
                          ' (see _pd_meas_rocking_angle).\n'
                          '\n'
                          '<h3>Example:</h3>\n'
                          'chi\n'
                          'omega\n'
                          'phi</pre>',
 '_pd_meas_scan_method': '<pre><h2>_pd_meas_scan_method</h2> Code identifying the method for '
                         'scanning reciprocal space.\n'
                         " The designation `fixed' should be used for measurements where\n"
                         ' film, a stationary position-sensitive or area detector\n'
                         ' or other non-moving detection mechanism is used to\n'
                         ' measure diffraction intensities.\n'
                         '\n'
                         '<h3>Example:</h3>\n'
                         'step\n'
                         '\tstep scan\n'
                         '\n'
                         'cont\n'
                         '\tcontinuous scan\n'
                         '\n'
                         'tof\n'
                         '\ttime of flight\n'
                         '\n'
                         'disp\n'
                         '\tenergy dispersive\n'
                         '\n'
                         'fixed\n'
                         '\tstationary detector\n'
                         '</pre>',
 '_pd_meas_special_details': '<pre><h2>_pd_meas_special_details</h2> Special details of the '
                             'diffraction measurement process.\n'
                             ' Include information about source instability, degradation etc.\n'
                             ' However, this item should not be used to record information\n'
                             ' that can be specified in other _pd_meas_ entries.</pre>',
 '_pd_meas_step_count_time': '<pre><h2>_pd_meas_step_count_time</h2> The count time in seconds for '
                             'each intensity measurement.\n'
                             ' If this value varies for different intensity measurements,\n'
                             ' then this item will be placed in the loop with the\n'
                             ' diffraction measurements. If a single fixed value is used,\n'
                             ' it may be recorded outside the loop.</pre>',
 '_pd_meas_time_of_flight': '<pre><h2>_pd_meas_time_of_flight</h2> Measured time in microseconds '
                            'for time-of-flight neutron\n'
                            ' measurements. Note that the flight distance may be\n'
                            ' specified using _pd_instr_dist_ values.</pre>',
 '_pd_meas_units_of_intensity': '<pre><h2>_pd_meas_units_of_intensity</h2> Units for intensity '
                                'measurements when _pd_meas_intensity_\n'
                                " is used. Note that use of 'counts' or 'counts per second'\n"
                                ' here is strongly discouraged: convert the intensity\n'
                                ' measurements to counts and use _pd_meas_counts_ and\n'
                                ' _pd_meas_step_count_time instead of _pd_meas_intensity_.\n'
                                '\n'
                                '<h3>Example:</h3>\n'
                                'estimated from strip chart\n'
                                'arbitrary, from film density\n'
                                'counts, with automatic dead-time correction applied</pre>',
 '_pd_peak_2theta_centroid': '<pre><h2>_pd_peak_2theta_centroid</h2> Position of the centroid and '
                             'maximum of a peak as a\n'
                             ' 2\\q angle in degrees.</pre>',
 '_pd_peak_2theta_maximum': '<pre><h2>_pd_peak_2theta_maximum</h2> Position of the centroid and '
                            'maximum of a peak as a\n'
                            ' 2\\q angle in degrees.</pre>',
 '_pd_peak_[pd]': '<pre><h2>_pd_peak_[pd]</h2> This section contains peak information extracted '
                  'from the\n'
                  ' measured or, if present, the processed diffractogram. Each\n'
                  ' peak in this table will have a unique label (see _pd_peak_id).\n'
                  ' The reflections and phases associated with each peak will be\n'
                  ' specified in other sections (see the _pd_refln_ and\n'
                  ' _pd_phase_ sections).\n'
                  '\n'
                  ' Note that peak positions are customarily determined from the\n'
                  ' processed diffractogram and thus corrections for position\n'
                  ' and intensity will have been previously applied.</pre>',
 '_pd_peak_d_spacing': '<pre><h2>_pd_peak_d_spacing</h2> Peak position as a d-spacing in '
                       'angstroms.</pre>',
 '_pd_peak_id': '<pre><h2>_pd_peak_id</h2> An arbitrary code is assigned to each peak. Used to '
                'link with\n'
                ' _pd_refln_peak_id so that multiple hkl and/or phase\n'
                ' identifications can be assigned to a single peak.\n'
                ' Each peak will have a unique code. In cases\n'
                ' where two peaks are severely overlapped, it may be\n'
                ' desirable to list them as a single peak.\n'
                '\n'
                ' A peak ID must be included for every peak.</pre>',
 '_pd_peak_intensity': '<pre><h2>_pd_peak_intensity</h2> Integrated area for the peak, with the '
                       'same scaling as\n'
                       ' the _pd_proc_intensity_ values. It is good practice to\n'
                       " include s.u.'s for these values.</pre>",
 '_pd_peak_pk_height': '<pre><h2>_pd_peak_pk_height</h2> The maximum intensity of the peak, either '
                       'extrapolated\n'
                       ' or the highest observed intensity value. The same\n'
                       ' scaling is used for the _pd_proc_intensity_ values.\n'
                       " It is good practice to include s.u.'s for these values.</pre>",
 '_pd_peak_special_details': '<pre><h2>_pd_peak_special_details</h2> Detailed description of any '
                             'non-routine processing steps\n'
                             ' used for peak determination or other comments\n'
                             ' related to the peak table that cannot be given elsewhere.</pre>',
 '_pd_peak_wavelength_id': '<pre><h2>_pd_peak_wavelength_id</h2> Code identifying the wavelength '
                           'appropriate for this peak\n'
                           ' from the wavelengths in the _diffrn_radiation_ list.\n'
                           ' (See _diffrn_radiation_wavelength_id.) Most commonly used\n'
                           ' to distinguish K\\a~1~ peaks from K\\a~2~ or to designate\n'
                           ' where K\\a~1~ and K\\a~2~ peaks cannot be resolved. For\n'
                           ' complex peak tables with multiple superimposed peaks,\n'
                           ' specify wavelengths in the reflection table using\n'
                           ' _pd_refln_wavelength_id rather than identifying peaks by\n'
                           ' wavelength.</pre>',
 '_pd_peak_width_2theta': '<pre><h2>_pd_peak_width_2theta</h2> Peak width as full-width at '
                          'half-maximum expressed as\n'
                          ' a 2\\q value in degrees.</pre>',
 '_pd_peak_width_d_spacing': '<pre><h2>_pd_peak_width_d_spacing</h2> Peak width as full-width at '
                             'half-maximum expressed as\n'
                             ' a d-spacing in angstroms.</pre>',
 '_pd_phase_[pd]': '<pre><h2>_pd_phase_[pd]</h2> This section contains a description of the '
                   'crystalline phases\n'
                   ' contributing to the powder diffraction data set. Note that if\n'
                   ' multiple-phase Rietveld or other structural analysis is\n'
                   ' performed, the structural results will be placed in different\n'
                   ' data blocks, using CIF entries from the core CIF dictionary.\n'
                   '\n'
                   ' The _pd_phase_block_id entry points to the CIF block with\n'
                   ' structural parameters for each crystalline phase. The\n'
                   ' _pd_phase_id serves to link to _pd_refln_phase_id, which is\n'
                   ' used to label peaks by phase.</pre>',
 '_pd_phase_block_id': '<pre><h2>_pd_phase_block_id</h2> A block ID code identifying the phase '
                       'contributing to\n'
                       ' the diffraction peak. The data block containing the\n'
                       ' crystallographic information for this phase will be\n'
                       ' identified with a _pd_block_id code matching the\n'
                       ' code in _pd_phase_block_id.</pre>',
 '_pd_phase_id': '<pre><h2>_pd_phase_id</h2> A code for each crystal phase used to link with\n'
                 ' _pd_refln_phase_id.</pre>',
 '_pd_phase_mass_%': '<pre><h2>_pd_phase_mass_%</h2> Per cent composition of the specified crystal '
                     'phase\n'
                     ' expressed as the total mass of the component\n'
                     ' with respect to the total mass of the specimen.</pre>',
 '_pd_phase_name': '<pre><h2>_pd_phase_name</h2> The name of the crystal phase identified by '
                   '_pd_phase_id.\n'
                   ' It may be designated as unknown or by a structure type etc.</pre>',
 '_pd_prep_[pd]': '<pre><h2>_pd_prep_[pd]</h2> This section contains descriptive information about '
                  'how the\n'
                  ' sample was prepared.</pre>',
 '_pd_prep_conditions': '<pre><h2>_pd_prep_conditions</h2> A description of how the material was '
                        'prepared\n'
                        ' (reaction conditions etc.)</pre>',
 '_pd_prep_cool_rate': '<pre><h2>_pd_prep_cool_rate</h2> Cooling rate in kelvins per minute for '
                       'samples prepared\n'
                       ' at high temperatures. If the cooling rate is not linear\n'
                       ' or is unknown (e.g. quenched samples), it should be\n'
                       ' described in _pd_prep_conditions instead.</pre>',
 '_pd_prep_pressure': '<pre><h2>_pd_prep_pressure</h2> Preparation pressure of the sample in '
                      'kilopascals. This\n'
                      ' is particularly important for materials which are metastable\n'
                      ' at the measurement pressure, _diffrn_ambient_pressure.</pre>',
 '_pd_prep_temperature': '<pre><h2>_pd_prep_temperature</h2> Preparation temperature of the sample '
                         'in kelvins. This is\n'
                         ' particularly important for materials which are metastable\n'
                         ' at the measurement temperature, _diffrn_ambient_temperature.</pre>',
 '_pd_proc_2theta_corrected': '<pre><h2>_pd_proc_2theta_corrected</h2> The 2\\q diffraction angle '
                              'in degrees of an intensity\n'
                              ' measurement where 2\\q is not constant. Used if\n'
                              ' corrections such as for nonlinearity, zero offset etc.\n'
                              ' have been applied to the _pd_meas_2theta_ values or if\n'
                              ' 2\\q values are computed. If the 2\\q values\n'
                              ' are evenly spaced, _pd_proc_2theta_range_min,\n'
                              ' _pd_proc_2theta_range_max and _pd_proc_2theta_range_inc\n'
                              ' may be used to specify the 2\\q values.</pre>',
 '_pd_proc_2theta_range_inc': '<pre><h2>_pd_proc_2theta_range_inc</h2> The range of 2\\q '
                              'diffraction angles in degrees for the\n'
                              ' measurement of intensities. These may be used in place of the\n'
                              ' _pd_proc_2theta_corrected values, or in the case of white-beam\n'
                              ' experiments it will define the fixed 2\\q value.</pre>',
 '_pd_proc_2theta_range_max': '<pre><h2>_pd_proc_2theta_range_max</h2> The range of 2\\q '
                              'diffraction angles in degrees for the\n'
                              ' measurement of intensities. These may be used in place of the\n'
                              ' _pd_proc_2theta_corrected values, or in the case of white-beam\n'
                              ' experiments it will define the fixed 2\\q value.</pre>',
 '_pd_proc_2theta_range_min': '<pre><h2>_pd_proc_2theta_range_min</h2> The range of 2\\q '
                              'diffraction angles in degrees for the\n'
                              ' measurement of intensities. These may be used in place of the\n'
                              ' _pd_proc_2theta_corrected values, or in the case of white-beam\n'
                              ' experiments it will define the fixed 2\\q value.</pre>',
 '_pd_proc_[pd]': '<pre><h2>_pd_proc_[pd]</h2> This section contains the diffraction data set '
                  'after processing\n'
                  ' and application of correction terms. If the data set is\n'
                  ' reprocessed, this section may be replaced (with the addition of\n'
                  ' a new _pd_block_id entry).</pre>',
 '_pd_proc_d_spacing': '<pre><h2>_pd_proc_d_spacing</h2> d-spacing corresponding to an intensity '
                       'point\n'
                       " from Bragg's law, d = \\l/(2 sin\\q), in units of angstroms.</pre>",
 '_pd_proc_energy_detection': '<pre><h2>_pd_proc_energy_detection</h2> Incident energy in '
                              'electronvolts of the source computed\n'
                              ' from secondary calibration information (time-of-flight\n'
                              ' and synchrotron data).\n'
                              ' Detection energy in electronvolts selected by the analyser,\n'
                              ' if not the same as the incident energy (triple-axis or \n'
                              ' energy-dispersive data). This may be a single value or may \n'
                              ' vary for each data point (triple-axis and time-of-flight '
                              'data).</pre>',
 '_pd_proc_energy_incident': '<pre><h2>_pd_proc_energy_incident</h2> Incident energy in '
                             'electronvolts of the source computed\n'
                             ' from secondary calibration information (time-of-flight\n'
                             ' and synchrotron data).\n'
                             ' Detection energy in electronvolts selected by the analyser,\n'
                             ' if not the same as the incident energy (triple-axis or \n'
                             ' energy-dispersive data). This may be a single value or may \n'
                             ' vary for each data point (triple-axis and time-of-flight '
                             'data).</pre>',
 '_pd_proc_info_author_address': '<pre><h2>_pd_proc_info_author_address</h2>  The address of the '
                                 'person who processed the data.\n'
                                 '  If there is more than one person, this will be looped with\n'
                                 '  _pd_proc_info_author_name.</pre>',
 '_pd_proc_info_author_email': '<pre><h2>_pd_proc_info_author_email</h2>  The e-mail address of '
                               'the person who processed the\n'
                               '  data.  If there is more than one person, this will be looped\n'
                               '  with _pd_proc_info_author_name.</pre>',
 '_pd_proc_info_author_fax': '<pre><h2>_pd_proc_info_author_fax</h2>  The fax number of the person '
                             'who processed the data.\n'
                             '  If there is more than one person, this will be looped with\n'
                             '  _pd_proc_info_author_name. The recommended style is\n'
                             '  the international dialing prefix, followed by the area code in\n'
                             '  parentheses, followed by the local number with no spaces.</pre>',
 '_pd_proc_info_author_name': '<pre><h2>_pd_proc_info_author_name</h2>  The name of the person who '
                              'processed the data, if different\n'
                              '  from the person(s) who measured the data set. The family\n'
                              '  name(s), followed by a comma and including any dynastic\n'
                              '  components, precedes the first name(s) or initial(s). For\n'
                              '  more than one person use a loop to specify multiple values.</pre>',
 '_pd_proc_info_author_phone': '<pre><h2>_pd_proc_info_author_phone</h2>  The telephone number of '
                               'the person who processed the data.\n'
                               '  If there is more than one person, this will be looped\n'
                               '  with _pd_proc_info_author_name. The recommended style is\n'
                               '  the international dialing prefix, followed by the area code in\n'
                               '  parentheses, followed by the local number with no spaces.</pre>',
 '_pd_proc_info_data_reduction': '<pre><h2>_pd_proc_info_data_reduction</h2> Description of the '
                                 'processing steps applied in the data-reduction\n'
                                 ' process (background subtraction, \\a-2 stripping, smoothing\n'
                                 ' etc.). Include details of the program(s) used etc.</pre>',
 '_pd_proc_info_datetime': '<pre><h2>_pd_proc_info_datetime</h2> Date(s) and time(s) when the data '
                           'set was processed.\n'
                           ' May be looped if multiple processing steps were used.\n'
                           '\n'
                           ' Dates and times should be specified in the standard CIF\n'
                           " format 'yyyy-mm-ddThh:mm:ss+zz'. Use of seconds and a\n"
                           ' time zone is optional, but use of hours and minutes is\n'
                           ' strongly encouraged.\n'
                           '\n'
                           '<h3>Example:</h3>\n'
                           '1990-07-13T14:40</pre>',
 '_pd_proc_info_excluded_regions': '<pre><h2>_pd_proc_info_excluded_regions</h2> Description of '
                                   'regions in the diffractogram excluded\n'
                                   ' from processing along with a justification of why the\n'
                                   ' data points were not used.\n'
                                   '\n'
                                   '<h3>Example:</h3>\n'
                                   '20 to 21 degrees unreliable due to beam dump</pre>',
 '_pd_proc_info_special_details': '<pre><h2>_pd_proc_info_special_details</h2> Detailed '
                                  'description of any non-routine processing steps\n'
                                  ' applied due to any irregularities in this particular data '
                                  'set.</pre>',
 '_pd_proc_intensity_bkg_calc': '<pre><h2>_pd_proc_intensity_bkg_calc</h2> _pd_proc_intensity_net '
                                'contains intensity values for the\n'
                                ' processed diffractogram for each data point (see\n'
                                ' _pd_proc_2theta_, _pd_proc_wavelength etc.) after\n'
                                ' correction and normalization factors have been applied\n'
                                ' (in contrast to _pd_meas_counts_ values, which are\n'
                                ' uncorrected).\n'
                                '\n'
                                ' _pd_proc_intensity_total contains intensity values for the\n'
                                ' processed diffractogram for each data point where\n'
                                ' background, normalization and other corrections have not\n'
                                ' been applied.\n'
                                '\n'
                                " Inclusion of s.u.'s for these values is strongly recommended.\n"
                                '\n'
                                ' _pd_proc_intensity_bkg_calc is intended to contain the\n'
                                ' background intensity for every data point where the\n'
                                ' background function has been fitted or estimated (for example, '
                                'in\n'
                                ' all Rietveld and profile fits).\n'
                                '\n'
                                ' If the background is estimated for a limited number of points\n'
                                ' and the calculated background is then extrapolated from\n'
                                ' these fixed points, indicate the background values for\n'
                                ' these points with _pd_proc_intensity_bkg_fix. Use a value\n'
                                " of '.' for data points where a fixed background has not\n"
                                ' been defined. The extrapolated background at every point\n'
                                ' may be specified using _pd_proc_intensity_bkg_calc.\n'
                                '\n'
                                ' Background values should be on the same scale as the\n'
                                ' _pd_proc_intensity_net values. Thus normalization and\n'
                                ' correction factors should be applied before\n'
                                ' background subtraction (or should be applied to the\n'
                                ' background values equally).\n'
                                '\n'
                                ' If the intensities have been corrected for a variation of the\n'
                                ' incident intensity as a function of a data-collection\n'
                                ' variable (examples: source fluctuations in synchrotrons,\n'
                                ' \\q-compensated slits in conventional diffractometers,\n'
                                ' spectral corrections for white-beam experiments), the\n'
                                ' correction function should be specified as\n'
                                ' _pd_proc_intensity_incident. The normalization should be\n'
                                ' specified in _pd_proc_intensity_incident as a value to be\n'
                                ' used to divide the measured intensities to obtained the\n'
                                ' normalized diffractogram. Thus, the\n'
                                ' _pd_proc_intensity_incident values should increase as the\n'
                                ' incident flux is increased.\n'
                                '\n'
                                ' The other normalization factors applied to the data set (for\n'
                                ' example, Lp corrections, compensation for variation in\n'
                                ' counting time) may be specified in _pd_proc_intensity_norm.\n'
                                ' The function should be specified as the one used to divide the\n'
                                ' measured intensities.</pre>',
 '_pd_proc_intensity_bkg_fix': '<pre><h2>_pd_proc_intensity_bkg_fix</h2> _pd_proc_intensity_net '
                               'contains intensity values for the\n'
                               ' processed diffractogram for each data point (see\n'
                               ' _pd_proc_2theta_, _pd_proc_wavelength etc.) after\n'
                               ' correction and normalization factors have been applied\n'
                               ' (in contrast to _pd_meas_counts_ values, which are\n'
                               ' uncorrected).\n'
                               '\n'
                               ' _pd_proc_intensity_total contains intensity values for the\n'
                               ' processed diffractogram for each data point where\n'
                               ' background, normalization and other corrections have not\n'
                               ' been applied.\n'
                               '\n'
                               " Inclusion of s.u.'s for these values is strongly recommended.\n"
                               '\n'
                               ' _pd_proc_intensity_bkg_calc is intended to contain the\n'
                               ' background intensity for every data point where the\n'
                               ' background function has been fitted or estimated (for example, '
                               'in\n'
                               ' all Rietveld and profile fits).\n'
                               '\n'
                               ' If the background is estimated for a limited number of points\n'
                               ' and the calculated background is then extrapolated from\n'
                               ' these fixed points, indicate the background values for\n'
                               ' these points with _pd_proc_intensity_bkg_fix. Use a value\n'
                               " of '.' for data points where a fixed background has not\n"
                               ' been defined. The extrapolated background at every point\n'
                               ' may be specified using _pd_proc_intensity_bkg_calc.\n'
                               '\n'
                               ' Background values should be on the same scale as the\n'
                               ' _pd_proc_intensity_net values. Thus normalization and\n'
                               ' correction factors should be applied before\n'
                               ' background subtraction (or should be applied to the\n'
                               ' background values equally).\n'
                               '\n'
                               ' If the intensities have been corrected for a variation of the\n'
                               ' incident intensity as a function of a data-collection\n'
                               ' variable (examples: source fluctuations in synchrotrons,\n'
                               ' \\q-compensated slits in conventional diffractometers,\n'
                               ' spectral corrections for white-beam experiments), the\n'
                               ' correction function should be specified as\n'
                               ' _pd_proc_intensity_incident. The normalization should be\n'
                               ' specified in _pd_proc_intensity_incident as a value to be\n'
                               ' used to divide the measured intensities to obtained the\n'
                               ' normalized diffractogram. Thus, the\n'
                               ' _pd_proc_intensity_incident values should increase as the\n'
                               ' incident flux is increased.\n'
                               '\n'
                               ' The other normalization factors applied to the data set (for\n'
                               ' example, Lp corrections, compensation for variation in\n'
                               ' counting time) may be specified in _pd_proc_intensity_norm.\n'
                               ' The function should be specified as the one used to divide the\n'
                               ' measured intensities.</pre>',
 '_pd_proc_intensity_incident': '<pre><h2>_pd_proc_intensity_incident</h2> _pd_proc_intensity_net '
                                'contains intensity values for the\n'
                                ' processed diffractogram for each data point (see\n'
                                ' _pd_proc_2theta_, _pd_proc_wavelength etc.) after\n'
                                ' correction and normalization factors have been applied\n'
                                ' (in contrast to _pd_meas_counts_ values, which are\n'
                                ' uncorrected).\n'
                                '\n'
                                ' _pd_proc_intensity_total contains intensity values for the\n'
                                ' processed diffractogram for each data point where\n'
                                ' background, normalization and other corrections have not\n'
                                ' been applied.\n'
                                '\n'
                                " Inclusion of s.u.'s for these values is strongly recommended.\n"
                                '\n'
                                ' _pd_proc_intensity_bkg_calc is intended to contain the\n'
                                ' background intensity for every data point where the\n'
                                ' background function has been fitted or estimated (for example, '
                                'in\n'
                                ' all Rietveld and profile fits).\n'
                                '\n'
                                ' If the background is estimated for a limited number of points\n'
                                ' and the calculated background is then extrapolated from\n'
                                ' these fixed points, indicate the background values for\n'
                                ' these points with _pd_proc_intensity_bkg_fix. Use a value\n'
                                " of '.' for data points where a fixed background has not\n"
                                ' been defined. The extrapolated background at every point\n'
                                ' may be specified using _pd_proc_intensity_bkg_calc.\n'
                                '\n'
                                ' Background values should be on the same scale as the\n'
                                ' _pd_proc_intensity_net values. Thus normalization and\n'
                                ' correction factors should be applied before\n'
                                ' background subtraction (or should be applied to the\n'
                                ' background values equally).\n'
                                '\n'
                                ' If the intensities have been corrected for a variation of the\n'
                                ' incident intensity as a function of a data-collection\n'
                                ' variable (examples: source fluctuations in synchrotrons,\n'
                                ' \\q-compensated slits in conventional diffractometers,\n'
                                ' spectral corrections for white-beam experiments), the\n'
                                ' correction function should be specified as\n'
                                ' _pd_proc_intensity_incident. The normalization should be\n'
                                ' specified in _pd_proc_intensity_incident as a value to be\n'
                                ' used to divide the measured intensities to obtained the\n'
                                ' normalized diffractogram. Thus, the\n'
                                ' _pd_proc_intensity_incident values should increase as the\n'
                                ' incident flux is increased.\n'
                                '\n'
                                ' The other normalization factors applied to the data set (for\n'
                                ' example, Lp corrections, compensation for variation in\n'
                                ' counting time) may be specified in _pd_proc_intensity_norm.\n'
                                ' The function should be specified as the one used to divide the\n'
                                ' measured intensities.</pre>',
 '_pd_proc_intensity_net': '<pre><h2>_pd_proc_intensity_net</h2> _pd_proc_intensity_net contains '
                           'intensity values for the\n'
                           ' processed diffractogram for each data point (see\n'
                           ' _pd_proc_2theta_, _pd_proc_wavelength etc.) after\n'
                           ' correction and normalization factors have been applied\n'
                           ' (in contrast to _pd_meas_counts_ values, which are\n'
                           ' uncorrected).\n'
                           '\n'
                           ' _pd_proc_intensity_total contains intensity values for the\n'
                           ' processed diffractogram for each data point where\n'
                           ' background, normalization and other corrections have not\n'
                           ' been applied.\n'
                           '\n'
                           " Inclusion of s.u.'s for these values is strongly recommended.\n"
                           '\n'
                           ' _pd_proc_intensity_bkg_calc is intended to contain the\n'
                           ' background intensity for every data point where the\n'
                           ' background function has been fitted or estimated (for example, in\n'
                           ' all Rietveld and profile fits).\n'
                           '\n'
                           ' If the background is estimated for a limited number of points\n'
                           ' and the calculated background is then extrapolated from\n'
                           ' these fixed points, indicate the background values for\n'
                           ' these points with _pd_proc_intensity_bkg_fix. Use a value\n'
                           " of '.' for data points where a fixed background has not\n"
                           ' been defined. The extrapolated background at every point\n'
                           ' may be specified using _pd_proc_intensity_bkg_calc.\n'
                           '\n'
                           ' Background values should be on the same scale as the\n'
                           ' _pd_proc_intensity_net values. Thus normalization and\n'
                           ' correction factors should be applied before\n'
                           ' background subtraction (or should be applied to the\n'
                           ' background values equally).\n'
                           '\n'
                           ' If the intensities have been corrected for a variation of the\n'
                           ' incident intensity as a function of a data-collection\n'
                           ' variable (examples: source fluctuations in synchrotrons,\n'
                           ' \\q-compensated slits in conventional diffractometers,\n'
                           ' spectral corrections for white-beam experiments), the\n'
                           ' correction function should be specified as\n'
                           ' _pd_proc_intensity_incident. The normalization should be\n'
                           ' specified in _pd_proc_intensity_incident as a value to be\n'
                           ' used to divide the measured intensities to obtained the\n'
                           ' normalized diffractogram. Thus, the\n'
                           ' _pd_proc_intensity_incident values should increase as the\n'
                           ' incident flux is increased.\n'
                           '\n'
                           ' The other normalization factors applied to the data set (for\n'
                           ' example, Lp corrections, compensation for variation in\n'
                           ' counting time) may be specified in _pd_proc_intensity_norm.\n'
                           ' The function should be specified as the one used to divide the\n'
                           ' measured intensities.</pre>',
 '_pd_proc_intensity_norm': '<pre><h2>_pd_proc_intensity_norm</h2> _pd_proc_intensity_net contains '
                            'intensity values for the\n'
                            ' processed diffractogram for each data point (see\n'
                            ' _pd_proc_2theta_, _pd_proc_wavelength etc.) after\n'
                            ' correction and normalization factors have been applied\n'
                            ' (in contrast to _pd_meas_counts_ values, which are\n'
                            ' uncorrected).\n'
                            '\n'
                            ' _pd_proc_intensity_total contains intensity values for the\n'
                            ' processed diffractogram for each data point where\n'
                            ' background, normalization and other corrections have not\n'
                            ' been applied.\n'
                            '\n'
                            " Inclusion of s.u.'s for these values is strongly recommended.\n"
                            '\n'
                            ' _pd_proc_intensity_bkg_calc is intended to contain the\n'
                            ' background intensity for every data point where the\n'
                            ' background function has been fitted or estimated (for example, in\n'
                            ' all Rietveld and profile fits).\n'
                            '\n'
                            ' If the background is estimated for a limited number of points\n'
                            ' and the calculated background is then extrapolated from\n'
                            ' these fixed points, indicate the background values for\n'
                            ' these points with _pd_proc_intensity_bkg_fix. Use a value\n'
                            " of '.' for data points where a fixed background has not\n"
                            ' been defined. The extrapolated background at every point\n'
                            ' may be specified using _pd_proc_intensity_bkg_calc.\n'
                            '\n'
                            ' Background values should be on the same scale as the\n'
                            ' _pd_proc_intensity_net values. Thus normalization and\n'
                            ' correction factors should be applied before\n'
                            ' background subtraction (or should be applied to the\n'
                            ' background values equally).\n'
                            '\n'
                            ' If the intensities have been corrected for a variation of the\n'
                            ' incident intensity as a function of a data-collection\n'
                            ' variable (examples: source fluctuations in synchrotrons,\n'
                            ' \\q-compensated slits in conventional diffractometers,\n'
                            ' spectral corrections for white-beam experiments), the\n'
                            ' correction function should be specified as\n'
                            ' _pd_proc_intensity_incident. The normalization should be\n'
                            ' specified in _pd_proc_intensity_incident as a value to be\n'
                            ' used to divide the measured intensities to obtained the\n'
                            ' normalized diffractogram. Thus, the\n'
                            ' _pd_proc_intensity_incident values should increase as the\n'
                            ' incident flux is increased.\n'
                            '\n'
                            ' The other normalization factors applied to the data set (for\n'
                            ' example, Lp corrections, compensation for variation in\n'
                            ' counting time) may be specified in _pd_proc_intensity_norm.\n'
                            ' The function should be specified as the one used to divide the\n'
                            ' measured intensities.</pre>',
 '_pd_proc_intensity_total': '<pre><h2>_pd_proc_intensity_total</h2> _pd_proc_intensity_net '
                             'contains intensity values for the\n'
                             ' processed diffractogram for each data point (see\n'
                             ' _pd_proc_2theta_, _pd_proc_wavelength etc.) after\n'
                             ' correction and normalization factors have been applied\n'
                             ' (in contrast to _pd_meas_counts_ values, which are\n'
                             ' uncorrected).\n'
                             '\n'
                             ' _pd_proc_intensity_total contains intensity values for the\n'
                             ' processed diffractogram for each data point where\n'
                             ' background, normalization and other corrections have not\n'
                             ' been applied.\n'
                             '\n'
                             " Inclusion of s.u.'s for these values is strongly recommended.\n"
                             '\n'
                             ' _pd_proc_intensity_bkg_calc is intended to contain the\n'
                             ' background intensity for every data point where the\n'
                             ' background function has been fitted or estimated (for example, in\n'
                             ' all Rietveld and profile fits).\n'
                             '\n'
                             ' If the background is estimated for a limited number of points\n'
                             ' and the calculated background is then extrapolated from\n'
                             ' these fixed points, indicate the background values for\n'
                             ' these points with _pd_proc_intensity_bkg_fix. Use a value\n'
                             " of '.' for data points where a fixed background has not\n"
                             ' been defined. The extrapolated background at every point\n'
                             ' may be specified using _pd_proc_intensity_bkg_calc.\n'
                             '\n'
                             ' Background values should be on the same scale as the\n'
                             ' _pd_proc_intensity_net values. Thus normalization and\n'
                             ' correction factors should be applied before\n'
                             ' background subtraction (or should be applied to the\n'
                             ' background values equally).\n'
                             '\n'
                             ' If the intensities have been corrected for a variation of the\n'
                             ' incident intensity as a function of a data-collection\n'
                             ' variable (examples: source fluctuations in synchrotrons,\n'
                             ' \\q-compensated slits in conventional diffractometers,\n'
                             ' spectral corrections for white-beam experiments), the\n'
                             ' correction function should be specified as\n'
                             ' _pd_proc_intensity_incident. The normalization should be\n'
                             ' specified in _pd_proc_intensity_incident as a value to be\n'
                             ' used to divide the measured intensities to obtained the\n'
                             ' normalized diffractogram. Thus, the\n'
                             ' _pd_proc_intensity_incident values should increase as the\n'
                             ' incident flux is increased.\n'
                             '\n'
                             ' The other normalization factors applied to the data set (for\n'
                             ' example, Lp corrections, compensation for variation in\n'
                             ' counting time) may be specified in _pd_proc_intensity_norm.\n'
                             ' The function should be specified as the one used to divide the\n'
                             ' measured intensities.</pre>',
 '_pd_proc_ls_[pd]': '<pre><h2>_pd_proc_ls_[pd]</h2> This section is used to define parameters '
                     'relevant to a\n'
                     ' least-squares fit to a powder diffractogram, using a Rietveld\n'
                     ' or other full-profile (e.g. Pawley or Le Bail methods) fit.\n'
                     '\n'
                     ' Note that values in this section refer to full-pattern fitting.\n'
                     ' Use the appropriate items for single-crystal analyses from the\n'
                     ' core CIF dictionary for structure refinements using diffraction\n'
                     ' intensities estimated from a powder diffractogram by \n'
                     ' pattern-decomposition methods. Also note that many entries in \n'
                     ' the core _refine_ls_ entries may also be useful (for example\n'
                     ' _refine_ls_shift/su_*).</pre>',
 '_pd_proc_ls_background_function': '<pre><h2>_pd_proc_ls_background_function</h2> Description of '
                                    'the background treatment mechanism used to\n'
                                    ' fit the data set.\n'
                                    '\n'
                                    ' For refinements where the background is computed as a\n'
                                    ' function that is fitted to minimize the difference between \n'
                                    ' the observed and calculated patterns, it is\n'
                                    ' recommended that in addition to a description of the\n'
                                    ' function (e.g. Chebychev polynomial), the actual '
                                    'equation(s)\n'
                                    ' used are included in TeX, or a programming language such\n'
                                    ' as Fortran or C. Include also the values used for the\n'
                                    ' coefficients used in the background function with their\n'
                                    " s.u.'s. The background values for each data point\n"
                                    ' computed from the function should be specified in\n'
                                    ' _pd_proc_intensity_bkg_calc.\n'
                                    '\n'
                                    ' If background correction is performed using extrapolation\n'
                                    ' from a set of points at fixed locations, these points\n'
                                    ' should be defined using _pd_proc_intensity_bkg_fix, and\n'
                                    ' _pd_proc_ls_background_function should indicate the\n'
                                    ' extrapolation method (linear extrapolation, spline etc.).\n'
                                    ' _pd_proc_ls_background_function should also indicate how '
                                    'the\n'
                                    ' points were determined (automatically, by visual estimation\n'
                                    ' etc.) and whether the values were refined to improve the\n'
                                    ' agreement. The extrapolated background intensity value for\n'
                                    ' each data point should be specified in\n'
                                    ' _pd_proc_intensity_bkg_calc.</pre>',
 '_pd_proc_ls_peak_cutoff': '<pre><h2>_pd_proc_ls_peak_cutoff</h2> Describes where peak-intensity '
                            'computation is\n'
                            ' discontinued as a fraction of the intensity of the\n'
                            ' peak at maximum. Thus for a value of 0.005, the\n'
                            ' tails of a diffraction peak are neglected\n'
                            ' after the intensity has dropped below 0.5% of the\n'
                            ' diffraction intensity at the maximum.</pre>',
 '_pd_proc_ls_pref_orient_corr': '<pre><h2>_pd_proc_ls_pref_orient_corr</h2> Description of the '
                                 'preferred-orientation correction if\n'
                                 ' such a correction is used. Omitting this entry\n'
                                 ' implies that no preferred-orientation correction\n'
                                 ' has been used. If a function form is used, it is\n'
                                 ' recommended that the actual equation in TeX, or a\n'
                                 ' programming language, is used to specify the function as\n'
                                 ' well as a giving a description. Include the value(s) used \n'
                                 " for the correction with s.u.'s.</pre>",
 '_pd_proc_ls_prof_R_factor': '<pre><h2>_pd_proc_ls_prof_R_factor</h2> Rietveld/profile fit R '
                              'factors.\n'
                              '\n'
                              ' Note that the R factor computed for Rietveld refinements\n'
                              ' using the extracted reflection intensity values (often\n'
                              ' called the Rietveld or Bragg R factor, R~B~) is not properly\n'
                              ' a profile R factor. This R factor may be specified using\n'
                              ' _refine_ls_R_I_factor. (Some authors report\n'
                              ' _refine_ls_R_Fsqd_factor or _refine_ls_R_factor_all\n'
                              ' as the Rietveld or Bragg R factor. While it is appropriate\n'
                              ' to compute and report any or all of these R factors,\n'
                              ' the names "Rietveld or Bragg R factor" refer strictly to\n'
                              ' _refine_ls_R_I_factor.)\n'
                              '\n'
                              '_pd_proc_ls_prof_R_factor, often called R~p~, is an\n'
                              '  unweighted fitness metric for the agreement between the\n'
                              '  observed and computed diffraction patterns.\n'
                              '     R~p~ = sum~i~ | I~obs~(i) - I~calc~(i) |\n'
                              '            / sum~i~ ( I~obs~(i) )\n'
                              '_pd_proc_ls_prof_wR_factor, often called R~wp~, is a\n'
                              '  weighted fitness metric for the agreement between the\n'
                              '  observed and computed diffraction patterns.\n'
                              '    R~wp~ = SQRT {\n'
                              '             sum~i~ ( w(i) [ I~obs~(i) - I~calc~(i) ]^2^ )\n'
                              '             / sum~i~ ( w(i) [I~obs~(i)]^2^ ) }\n'
                              '\n'
                              '_pd_proc_ls_prof_wR_expected, sometimes called the\n'
                              '  theoretical R~wp~ or R~exp~, is a weighted fitness metric for\n'
                              '  the statistical precision of the data set. For an idealized fit,\n'
                              '  where all deviations between the observed intensities and\n'
                              '  those computed from the model are due to statistical\n'
                              '  fluctuations, the observed R~wp~ should match the expected\n'
                              '  R factor. In reality, R~wp~ will always be higher than\n'
                              '  R~exp~.\n'
                              '    R~exp~ = SQRT {\n'
                              '                   (n - p)  / sum~i~ ( w(i) [I~obs~(i)]^2^ ) }\n'
                              '\n'
                              '  Note that in the above equations,\n'
                              '     w(i) is the weight for the ith data point (see\n'
                              '          _pd_proc_ls_weight).\n'
                              '     I~obs~(i) is the observed intensity for the ith data\n'
                              '          point, sometimes referred to as y~i~(obs) or\n'
                              '          y~oi~. (See _pd_meas_counts_total,\n'
                              '          _pd_meas_intensity_total or _pd_proc_intensity_total.)\n'
                              '     I~calc~(i) is the computed intensity for the ith data\n'
                              '          point with background and other corrections\n'
                              '          applied to match the scale of the observed data set,\n'
                              '          sometimes referred to as y~i~(calc) or\n'
                              '          y~ci~. (See _pd_calc_intensity_total.)\n'
                              '     n is the total number of data points (see\n'
                              '          _pd_proc_number_of_points) less the number of\n'
                              '          data points excluded from the refinement.\n'
                              '     p is the total number of refined parameters.</pre>',
 '_pd_proc_ls_prof_wR_expected': '<pre><h2>_pd_proc_ls_prof_wR_expected</h2> Rietveld/profile fit '
                                 'R factors.\n'
                                 '\n'
                                 ' Note that the R factor computed for Rietveld refinements\n'
                                 ' using the extracted reflection intensity values (often\n'
                                 ' called the Rietveld or Bragg R factor, R~B~) is not properly\n'
                                 ' a profile R factor. This R factor may be specified using\n'
                                 ' _refine_ls_R_I_factor. (Some authors report\n'
                                 ' _refine_ls_R_Fsqd_factor or _refine_ls_R_factor_all\n'
                                 ' as the Rietveld or Bragg R factor. While it is appropriate\n'
                                 ' to compute and report any or all of these R factors,\n'
                                 ' the names "Rietveld or Bragg R factor" refer strictly to\n'
                                 ' _refine_ls_R_I_factor.)\n'
                                 '\n'
                                 '_pd_proc_ls_prof_R_factor, often called R~p~, is an\n'
                                 '  unweighted fitness metric for the agreement between the\n'
                                 '  observed and computed diffraction patterns.\n'
                                 '     R~p~ = sum~i~ | I~obs~(i) - I~calc~(i) |\n'
                                 '            / sum~i~ ( I~obs~(i) )\n'
                                 '_pd_proc_ls_prof_wR_factor, often called R~wp~, is a\n'
                                 '  weighted fitness metric for the agreement between the\n'
                                 '  observed and computed diffraction patterns.\n'
                                 '    R~wp~ = SQRT {\n'
                                 '             sum~i~ ( w(i) [ I~obs~(i) - I~calc~(i) ]^2^ )\n'
                                 '             / sum~i~ ( w(i) [I~obs~(i)]^2^ ) }\n'
                                 '\n'
                                 '_pd_proc_ls_prof_wR_expected, sometimes called the\n'
                                 '  theoretical R~wp~ or R~exp~, is a weighted fitness metric for\n'
                                 '  the statistical precision of the data set. For an idealized '
                                 'fit,\n'
                                 '  where all deviations between the observed intensities and\n'
                                 '  those computed from the model are due to statistical\n'
                                 '  fluctuations, the observed R~wp~ should match the expected\n'
                                 '  R factor. In reality, R~wp~ will always be higher than\n'
                                 '  R~exp~.\n'
                                 '    R~exp~ = SQRT {\n'
                                 '                   (n - p)  / sum~i~ ( w(i) [I~obs~(i)]^2^ ) }\n'
                                 '\n'
                                 '  Note that in the above equations,\n'
                                 '     w(i) is the weight for the ith data point (see\n'
                                 '          _pd_proc_ls_weight).\n'
                                 '     I~obs~(i) is the observed intensity for the ith data\n'
                                 '          point, sometimes referred to as y~i~(obs) or\n'
                                 '          y~oi~. (See _pd_meas_counts_total,\n'
                                 '          _pd_meas_intensity_total or '
                                 '_pd_proc_intensity_total.)\n'
                                 '     I~calc~(i) is the computed intensity for the ith data\n'
                                 '          point with background and other corrections\n'
                                 '          applied to match the scale of the observed data set,\n'
                                 '          sometimes referred to as y~i~(calc) or\n'
                                 '          y~ci~. (See _pd_calc_intensity_total.)\n'
                                 '     n is the total number of data points (see\n'
                                 '          _pd_proc_number_of_points) less the number of\n'
                                 '          data points excluded from the refinement.\n'
                                 '     p is the total number of refined parameters.</pre>',
 '_pd_proc_ls_prof_wR_factor': '<pre><h2>_pd_proc_ls_prof_wR_factor</h2> Rietveld/profile fit R '
                               'factors.\n'
                               '\n'
                               ' Note that the R factor computed for Rietveld refinements\n'
                               ' using the extracted reflection intensity values (often\n'
                               ' called the Rietveld or Bragg R factor, R~B~) is not properly\n'
                               ' a profile R factor. This R factor may be specified using\n'
                               ' _refine_ls_R_I_factor. (Some authors report\n'
                               ' _refine_ls_R_Fsqd_factor or _refine_ls_R_factor_all\n'
                               ' as the Rietveld or Bragg R factor. While it is appropriate\n'
                               ' to compute and report any or all of these R factors,\n'
                               ' the names "Rietveld or Bragg R factor" refer strictly to\n'
                               ' _refine_ls_R_I_factor.)\n'
                               '\n'
                               '_pd_proc_ls_prof_R_factor, often called R~p~, is an\n'
                               '  unweighted fitness metric for the agreement between the\n'
                               '  observed and computed diffraction patterns.\n'
                               '     R~p~ = sum~i~ | I~obs~(i) - I~calc~(i) |\n'
                               '            / sum~i~ ( I~obs~(i) )\n'
                               '_pd_proc_ls_prof_wR_factor, often called R~wp~, is a\n'
                               '  weighted fitness metric for the agreement between the\n'
                               '  observed and computed diffraction patterns.\n'
                               '    R~wp~ = SQRT {\n'
                               '             sum~i~ ( w(i) [ I~obs~(i) - I~calc~(i) ]^2^ )\n'
                               '             / sum~i~ ( w(i) [I~obs~(i)]^2^ ) }\n'
                               '\n'
                               '_pd_proc_ls_prof_wR_expected, sometimes called the\n'
                               '  theoretical R~wp~ or R~exp~, is a weighted fitness metric for\n'
                               '  the statistical precision of the data set. For an idealized '
                               'fit,\n'
                               '  where all deviations between the observed intensities and\n'
                               '  those computed from the model are due to statistical\n'
                               '  fluctuations, the observed R~wp~ should match the expected\n'
                               '  R factor. In reality, R~wp~ will always be higher than\n'
                               '  R~exp~.\n'
                               '    R~exp~ = SQRT {\n'
                               '                   (n - p)  / sum~i~ ( w(i) [I~obs~(i)]^2^ ) }\n'
                               '\n'
                               '  Note that in the above equations,\n'
                               '     w(i) is the weight for the ith data point (see\n'
                               '          _pd_proc_ls_weight).\n'
                               '     I~obs~(i) is the observed intensity for the ith data\n'
                               '          point, sometimes referred to as y~i~(obs) or\n'
                               '          y~oi~. (See _pd_meas_counts_total,\n'
                               '          _pd_meas_intensity_total or _pd_proc_intensity_total.)\n'
                               '     I~calc~(i) is the computed intensity for the ith data\n'
                               '          point with background and other corrections\n'
                               '          applied to match the scale of the observed data set,\n'
                               '          sometimes referred to as y~i~(calc) or\n'
                               '          y~ci~. (See _pd_calc_intensity_total.)\n'
                               '     n is the total number of data points (see\n'
                               '          _pd_proc_number_of_points) less the number of\n'
                               '          data points excluded from the refinement.\n'
                               '     p is the total number of refined parameters.</pre>',
 '_pd_proc_ls_profile_function': '<pre><h2>_pd_proc_ls_profile_function</h2> Description of the '
                                 'profile function used to\n'
                                 ' fit the data set. If a function form is used, it is\n'
                                 ' recommended that the actual equation in TeX, or a\n'
                                 ' programming language, is used to specify the function as\n'
                                 ' well as giving a description. Include the values used \n'
                                 " for the profile-function coefficients and their s.u.'s.</pre>",
 '_pd_proc_ls_special_details': '<pre><h2>_pd_proc_ls_special_details</h2> Additional '
                                'characterization information relevant to\n'
                                ' non-routine steps used for refinement of a structural model\n'
                                ' that cannot be specified elsewhere.</pre>',
 '_pd_proc_ls_weight': '<pre><h2>_pd_proc_ls_weight</h2> Weight applied to each profile point. '
                       'These values\n'
                       ' may be omitted if the weights are 1/u^2^, where\n'
                       ' u is the s.u. for the _pd_proc_intensity_net values.\n'
                       '\n'
                       ' A weight value of zero is used to indicate a data\n'
                       ' point not used for refinement (see\n'
                       ' _pd_proc_info_excluded_regions).</pre>',
 '_pd_proc_number_of_points': '<pre><h2>_pd_proc_number_of_points</h2> The total number of data '
                              'points in the processed diffractogram.</pre>',
 '_pd_proc_point_id': '<pre><h2>_pd_proc_point_id</h2> Arbitrary label identifying a processed '
                      'data point. Used to\n'
                      ' identify a specific entry in a list of processed intensities.\n'
                      ' The role of this identifier may be adopted by\n'
                      ' _pd_data_point_id if measured, processed and calculated\n'
                      ' intensity values are combined in a single list, or by\n'
                      ' _pd_meas_point_id if measured and processed lists are\n'
                      ' combined.</pre>',
 '_pd_proc_recip_len_Q': '<pre><h2>_pd_proc_recip_len_Q</h2> Length in reciprocal space (|Q|= '
                         '2\\p/d) corresponding to\n'
                         ' an intensity point. Units are inverse angstroms.</pre>',
 '_pd_proc_wavelength': '<pre><h2>_pd_proc_wavelength</h2> Wavelength in angstroms for the '
                        'incident radiation as\n'
                        ' computed from secondary calibration information. This will\n'
                        ' be most appropriate for time-of-flight and synchrotron\n'
                        ' measurements. This will be a single value for\n'
                        ' continuous-wavelength methods or may vary for each data point\n'
                        ' and be looped with the intensity values for energy-dispersive\n'
                        ' measurements.</pre>',
 '_pd_refln_[pd]': '<pre><h2>_pd_refln_[pd]</h2> This section provides a mechanism to identify '
                   'each peak in the\n'
                   ' peak-table section (_pd_peak_) with the phase(s) (_pd_phase_id)\n'
                   ' and the reflection indices (_refln_index_) associated with the\n'
                   ' peak.  There are no restrictions on the number of phases or\n'
                   ' reflections associated with an observed peak. Reflections may\n'
                   " also be included that are not observed; use '.' for the\n"
                   ' _pd_refln_peak_id.</pre>',
 '_pd_refln_peak_id': '<pre><h2>_pd_refln_peak_id</h2> Code which identifies the powder '
                      'diffraction peak that\n'
                      ' contains the current reflection. This code must match a\n'
                      ' _pd_peak_id code.</pre>',
 '_pd_refln_phase_id': '<pre><h2>_pd_refln_phase_id</h2> Code which identifies the crystal phase '
                       'associated with this\n'
                       ' reflection. This code must match a _pd_phase_id code.</pre>',
 '_pd_refln_wavelength_id': '<pre><h2>_pd_refln_wavelength_id</h2> Code which identifies the '
                            'wavelength associated with the\n'
                            ' reflection and the peak pointed to by _pd_refln_peak_id.\n'
                            ' This code must match a _diffrn_radiation_wavelength_id code.</pre>',
 '_pd_spec_[pd]': '<pre><h2>_pd_spec_[pd]</h2> This section contains information about the '
                  'specimen used\n'
                  ' for measurement of the diffraction data set. Note that \n'
                  ' information about the sample (the batch of material from which \n'
                  ' the specimen was obtained) is specified in _pd_prep_.\n'
                  '\n'
                  '<h3>Example:</h3>\n'
                  '\n'
                  '    _pd_spec_mounting               ?\n'
                  '    _pd_spec_mount_mode             transmission\n'
                  '    _pd_spec_orientation            horizontal\n'
                  '    _pd_spec_preparation            ?</pre>',
 '_pd_spec_description': '<pre><h2>_pd_spec_description</h2>  A description of the specimen, such '
                         'as the source of the\n'
                         '  specimen, identification of standards, mixtures etc.</pre>',
 '_pd_spec_mount_mode': '<pre><h2>_pd_spec_mount_mode</h2> A code describing the beam path through '
                        'the specimen.\n'
                        '\n'
                        '<h3>Example:</h3>\n'
                        'reflection\n'
                        'transmission</pre>',
 '_pd_spec_mounting': '<pre><h2>_pd_spec_mounting</h2> A description of how the specimen is '
                      'mounted.\n'
                      '\n'
                      '<h3>Example:</h3>\n'
                      'vanadium can with He exchange gas\n'
                      'quartz capillary\n'
                      'packed powder pellet\n'
                      'drifted powder on off-cut Si\n'
                      'drifted powder on Kapton film</pre>',
 '_pd_spec_orientation': '<pre><h2>_pd_spec_orientation</h2> The orientation of the \\w (\\q) and '
                         '2\\q axis.\n'
                         ' Note that this axis is parallel to the specimen axial axis\n'
                         ' and perpendicular to the plane containing the incident and\n'
                         ' scattered beams.\n'
                         '\n'
                         ' Thus for a horizontal orientation, scattering\n'
                         ' measurements are made in a plane perpendicular to the\n'
                         ' ground (the 2\\q axis is parallel to the ground);\n'
                         ' for vertical orientation, scattering measurements are\n'
                         ' made in a plane parallel with the ground (the 2\\q axis\n'
                         " is perpendicular to the ground). `Both' is appropriate for\n"
                         ' experiments where measurements are made in both planes,\n'
                         ' for example using two-dimensional detectors.\n'
                         '\n'
                         '<h3>Example:</h3>\n'
                         'horizontal\n'
                         'vertical\n'
                         'both</pre>',
 '_pd_spec_preparation': '<pre><h2>_pd_spec_preparation</h2> A description of the preparation '
                         'steps for producing the\n'
                         ' diffraction specimen from the sample. Include any procedures\n'
                         ' related to grinding, sieving, spray drying etc. For\n'
                         ' information relevant to how the sample is synthesized, use\n'
                         ' the _pd_prep_ entries.\n'
                         '\n'
                         '<h3>Example:</h3>\n'
                         'wet grinding in acetone\n'
                         'sieved through a 44 micron (325 mesh/inch) sieve\n'
                         'spray dried in water with 1% clay</pre>',
 '_pd_spec_shape': '<pre><h2>_pd_spec_shape</h2> A code describing the specimen shape.\n'
                   '\n'
                   '<h3>Example:</h3>\n'
                   'cylinder\n'
                   'flat_sheet\n'
                   'irregular</pre>',
 '_pd_spec_size_axial': '<pre><h2>_pd_spec_size_axial</h2> The size of the specimen in three '
                        'mutually perpendicular\n'
                        ' directions in millimetres.\n'
                        ' The perpendicular to the plane containing the incident\n'
                        ' and scattered beam is the *_axial direction.\n'
                        ' In transmission geometry, the scattering vector is parallel\n'
                        ' to *_equat and in reflection geometry the scattering vector is\n'
                        ' parallel to *_thick.\n'
                        '</pre>',
 '_pd_spec_size_equat': '<pre><h2>_pd_spec_size_equat</h2> The size of the specimen in three '
                        'mutually perpendicular\n'
                        ' directions in millimetres.\n'
                        ' The perpendicular to the plane containing the incident\n'
                        ' and scattered beam is the *_axial direction.\n'
                        ' In transmission geometry, the scattering vector is parallel\n'
                        ' to *_equat and in reflection geometry the scattering vector is\n'
                        ' parallel to *_thick.\n'
                        '</pre>',
 '_pd_spec_size_thick': '<pre><h2>_pd_spec_size_thick</h2> The size of the specimen in three '
                        'mutually perpendicular\n'
                        ' directions in millimetres.\n'
                        ' The perpendicular to the plane containing the incident\n'
                        ' and scattered beam is the *_axial direction.\n'
                        ' In transmission geometry, the scattering vector is parallel\n'
                        ' to *_equat and in reflection geometry the scattering vector is\n'
                        ' parallel to *_thick.\n'
                        '</pre>',
 '_pd_spec_special_details': '<pre><h2>_pd_spec_special_details</h2> Descriptive information about '
                             'the specimen that cannot be\n'
                             ' included in other data items.</pre>'}