<?
	
	/**
	 * Create miscellaneous icons and buttons.
	 */
	function createMiscButtons($dir) {
		$search = getPngFilenameFor(ACTIONS, 'system-search', 16);
		copy($search, $dir.'Search-bar.png');
		
		$info = getPngFilenameFor(STATUS, 'dialog-information', 16);
		copy($info, $dir.'Info.png');
		
		$bmfolder = getPngFilenameFor(MIMETYPES, 'text-html', 16);
		copy($bmfolder, $dir.'Bookmarks-folder.png');

		// render the HTTPS security state icon
		renderSecurityIcon($dir.'Secure.png', 'secure', 18);
		renderSecurityIcon($dir.'Security-broken.png', 'insecure', 18);
	}

	/**
	 * Render the secure-connection icon to a given file.
	 *
	 * The icon states are four rows in a single column:
	 * Normal, Hover, Pressed, Disabled
	 */
	function renderSecurityIcon($filename, $icon, $size) {
		// get the normal 16x16 icon
		$normal16 = getPngFilenameFor(STATUS, $icon, 16);

		// resize it to the desired size
		$normal = resizePng($normal16, $size);

		// create the different states
		$highlight = renderHighlight($normal);
		$pressed = renderDarkened($normal);
		$disabled = renderDisabled($normal);

		// combine all states into a single image
		$states = array($normal, $highlight, $pressed, $disabled);
		$securestates =
			renderColumnFromPngs(
				$states, $size, $size);

		// copy the end result to the desired filename
		copy($securestates, $filename);
	}
		
?>
