/*---[ firestarter.h ]------------------------------------------------
 * Copyright (C) 2000 Tomas Junnonen (majix@sci.fi)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * The main firestarter header file
 *--------------------------------------------------------------------*/

#ifndef _FIRESTARTER_MAIN
#define _FIRESTARTER_MAIN

#include <config.h>
#include <gnome.h>

typedef struct _Hit  Hit;

struct _Hit
{
	gchar *time;
	gchar *in;
	gchar *out;
	gchar *port;
	gchar *source;
	gchar *destination;
	gchar *length;
	gchar *tos;
	gchar *protocol;
	gchar *service;
};

typedef struct _Rule Rule;

struct _Rule
{
	gint type;
	gchar *host;
	gchar *port;
	gboolean active;
	gpointer extension;
};

typedef struct _Ex_Forward Forward;

struct _Ex_Forward
{
	gchar *int_host;
	gchar *int_port;
};

typedef enum
{
	STATUS_NONE,
	STATUS_STOPPED,
	STATUS_RUNNING,
	STATUS_HALTED,
	STATUS_HIT
} FirewallStatus;

typedef enum
{
	RULETYPE_GROUP,
	RULETYPE_TRUSTED_HOST,
	RULETYPE_BLOCKED_HOST,
	RULETYPE_FORWARD,
	RULETYPE_OPEN_PORT,
	RULETYPE_STEALTHED_PORT,
	RULETYPE_BLOCKED_PORT,
	NUM_RULETYPES
} RuleType;

void stop_firewall (void);
void start_firewall (void);
void halt_firewall (void);
void exit_firestarter (void);
void update_status (FirewallStatus status);
FirewallStatus get_current_status (void);

#endif
