/*---[ gui.c ]--------------------------------------------------------
 * Copyright (C) 2002 Tomas Junnonen (majix@sci.fi)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * The GUI builder
 *--------------------------------------------------------------------*/

#include <config.h>
#include <gnome.h>

#include "globals.h"
#include "firestarter.h"
#include "gui.h"
#include "hitview.h"
#include "ruleview.h"
#include "util.h"
#include "menus.h"
#include "xpm/firestarter-pixbufs.h"
#include "tray.h"
#include "preferences.h"

static GtkWidget *notebook;

gboolean
gui_toggle_visibility (void)
{
	static int window_x = -1;
	static int window_y = -1;

	if (GTK_WIDGET_VISIBLE (Firestarter.window)) {
		gtk_window_get_position (GTK_WINDOW (Firestarter.window),
		                         &window_x, &window_y);
		gtk_widget_hide (Firestarter.window);

		return FALSE;
	} else {
		gtk_window_present (GTK_WINDOW(Firestarter.window));
		if (window_x >= 0 && window_y >= 0) {
			gtk_window_move (GTK_WINDOW (Firestarter.window),
			                 window_x,
			                 window_y);
		}

		return TRUE;
	}
}

/* [ show_about ]
 * Creates the about dialog
 */
void 
show_about (GtkWidget *widget, gpointer data)
{
	GdkPixbuf *pixbuf;
	static GtkWidget *dialog = NULL;

	/* Don't create more than one about box */
	if (dialog != NULL) {
		g_assert (GTK_WIDGET_REALIZED (dialog));
		gdk_window_show (dialog->window);
		gdk_window_raise (dialog->window);
	}
	else {
		const gchar *authors[] = {
			"Tomas Junnonen <majix@sci.fi> - Main Developer, Maintainer",
			"Paul Drain <pd@cipherfunk.org> - Developer",
			NULL};

		pixbuf = gdk_pixbuf_new_from_inline (-1, pengo, FALSE, NULL);

		dialog = gnome_about_new (
			"Firestarter", VERSION,
			"(C) 2000-2002 Tomas Junnonen",
			_("An all-in-one Linux firewall utility for GNOME.\n"),
			authors,
			NULL,
			NULL, pixbuf);

		g_signal_connect (G_OBJECT (dialog), "destroy",
			G_CALLBACK (gtk_widget_destroyed), &dialog);

		g_object_unref (G_OBJECT(pixbuf));
		gtk_widget_show (dialog);
	}
}

/* [ gui_get_active_view ]
 * Return the view mode that is currently selected
 */
FirestarterView
gui_get_active_view (void)
{
	FirestarterView v;
	
	v = gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook));
	g_assert (v < NUM_VIEWS);
	
	return v;
}

/* [ close_main_window ]
 * Quit or hide, determined by the config files
 */
static gboolean
close_main_window (void)
{
	if (preferences_get_bool (PREFS_TRAY_MODE)) {
		gui_toggle_visibility ();
		return TRUE;
	} else {
		exit_firestarter ();
		return FALSE;
	}
}

/* [ gui_construct ]
 * Create the GUI
 */
void
gui_construct (gboolean visible)
{
	GtkWidget *tablabel;
	GtkWidget *hitview_page;
	GtkWidget *ruleview_page;

	gchar hostname[40];

	if (!gethostname (hostname, 39))
		Firestarter.window = gnome_app_new (PACKAGE, g_strconcat ("Firestarter ", hostname, NULL));
	else
		Firestarter.window = gnome_app_new (PACKAGE, "Firestarter");

	Firestarter.ttips = gtk_tooltips_new ();

/* Set up the main window */
	g_signal_connect (G_OBJECT (Firestarter.window), "delete_event",
			  G_CALLBACK (close_main_window), NULL);

	gnome_window_icon_set_default_from_file (
		"/usr/share/pixmaps/firestarter.png");

	install_menus_and_toolbar (Firestarter.window);

/* The main application is spread out over a set of notebook pages */
	notebook = gtk_notebook_new ();
	gnome_app_set_contents (GNOME_APP (Firestarter.window), notebook);

/* Set up the hitview page */
	hitview_page = create_hitview_page ();
	tablabel = gtk_label_new (_("Hits"));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), hitview_page, tablabel);

/* Set up the the rules page */
	ruleview_page = create_ruleview_page ();
	tablabel = gtk_label_new (_("Rules"));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), ruleview_page, tablabel);

	gtk_window_set_default_size (GTK_WINDOW (Firestarter.window), 350, 370);

	if (visible)
		gtk_widget_show_all (Firestarter.window);

	/* Show the tray icon */
	tray_init ();
}
