/*---[ logread.c ]----------------------------------------------------
 * Copyright (C) 2000-2002 Tomas Junnonen (majix@sci.fi)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Functions for reading from the syslog file
 *--------------------------------------------------------------------*/

#include <config.h>
#include <gnome.h>

#include "globals.h"
#include "logread.h"
#include "util.h"
#include "parse.h"
#include "hitview.h"

/* [ poll_log_timeout ]
 * Polls the logfile every 500ms for change, if change, parse lines
 */
static int
poll_log_timeout (gpointer file)
{
	/* The log entries are compared against this pattern */
	static GPatternSpec *pattern = NULL;
	gchar buf[512];
	Hit *h;

	if (pattern == NULL)
		pattern = g_pattern_spec_new ("* IN=* OUT=* SRC=*");

	while (fgets (buf, 512, file) != NULL) {
		if (g_pattern_match_string (pattern, buf)) { /* Is it a firewall entry? */
			h = parse_log_line (buf);
			if (hitview_append_hit (h))
				update_status (STATUS_HIT);
			free_hit (h);
		}
	}

	return TRUE; /* TRUE means we want to keep calling the function */
}

/* [ open_logfile ]
 * Open the system log and attach a reader function with a timeout
 */
void
open_logfile (char *logpath) {
	FILE *file;

	file = fopen (logpath, "r");

	/* If user has read access to the log file we add a timeout */
	if (file) {
		fseek (file, 0, SEEK_END); /* Move to the end of the file */
		gtk_timeout_add (500, poll_log_timeout, file);
	} else {
		perror ("Log file not found or access denied.\n"
			"Firewall log monitoring disabled.");
	}
}
