/*---[ hitview.h ]-----------------------------------------------------
 * Copyright (C) 2002 Tomas Junnonen (majix@sci.fi)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * The Hits page and related functions
 *--------------------------------------------------------------------*/

#ifndef _FIRESTARTER_RULEVIEW
#define _FIRESTARTER_RULEVIEW

#include <config.h>
#include <gnome.h>

#include "firestarter.h"

GtkTreeIter *ruleview_insert_rule (Rule *r);
void ruleview_remove_rule (GtkTreeIter iter);

Rule *get_rule (GtkTreeModel *model, GtkTreeIter iter);
Rule *ruleview_get_selected_rule (void);

GtkWidget *create_rule_dialog (Rule *r, gchar *title);
GtkWidget *create_ruleview_page (void);

GtkTreeIter *get_rulegroup_iter (RuleType type);
gboolean is_root_item (GtkTreeIter iter);

void copy_selected_rule (void);

typedef enum
{
	RULECOL_ACTIVE,
	RULECOL_DATA,
	RULECOL_TYPE,
	RULECOL_HOST,
	RULECOL_PORT,
	RULECOL_EXTRA1,
	RULECOL_EXTRA2,
	NUM_RULECOLUMNS
} RuleColumn;

#endif
