/*---[ service.c ]----------------------------------------------------
 * Copyright (C) 2000 Tomas Junnonen (majix@sci.fi)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Return the service used, based on the port and protocol given
 *--------------------------------------------------------------------*/

#include <netdb.h>
#include <netinet/in.h>

#include "service.h"

/* [ service ]
 * Return the service/exploit used, based on the port and protocol given
 */
gchar *
get_service_name (gint port, gchar *proto)
{
	struct servent *ent;

	if (port == 0 || proto == NULL)
		return (g_strdup ("unknown"));

	ent = getservbyport (htons (port), proto);

	if (ent)
		return (g_strdup (ent->s_name));
	else {
		/* Ports not provided by /etc/services */
		if (port==135) return (g_strdup ("ms-rpc"));
		if (port==555) return (g_strdup ("phAse zero"));
		if (port==600) return (g_strdup ("pc server backdoor"));
		if (port==635) return (g_strdup ("mountd bug"));
		if (port==1214) return (g_strdup ("kazaa"));
		if (port==1241) return (g_strdup ("nessus"));
		if (port==1234) return (g_strdup ("subseven"));
		if (port==1243) return (g_strdup ("subseven"));
		if (port==1524) return (g_strdup ("trin00"));
		if (port==1999) return (g_strdup ("backdoor-g/subseven"));
		if (port==2301) return (g_strdup ("cpq-wbem"));
		if (port==2772) return (g_strdup ("subseven (screencapture)"));
		if (port==2773) return (g_strdup ("subseven (keylogger)"));
		if (port==3129) return (g_strdup ("master's paradise"));
		if (port==3449) return (g_strdup ("hotU chat"));
		if (port==4500) return (g_strdup ("ms ipsec NAT-T"));
		if (port==4662) return (g_strdup ("eDonkey"));
		if (port==5000) return (g_strdup ("uPNP"));
		if (port==5060) return (g_strdup ("sip"));
		if (port==5061) return (g_strdup ("sip over tls"));
		if (port==5623) return (g_strdup ("pcAnywhere"));
		if (port==5999) return (g_strdup ("vnc reflector"));
		if (port==5900) return (g_strdup ("vnc"));
		if (port==5500) return (g_strdup ("vnc"));
		if (port==5800) return (g_strdup ("vnc"));
		if (port==6346) return (g_strdup ("gnutella"));
		if (port==6670) return (g_strdup ("deep throat"));
		if (port==6711) return (g_strdup ("sub-7"));
		if (port==6712) return (g_strdup ("sub-7"));
		if (port==6713) return (g_strdup ("sub-7"));
		if (port==6776) return (g_strdup ("backdoor-G or sub-7)"));
		if (port==6969) return (g_strdup ("gatecrasher"));
		if (port==6970) return (g_strdup ("realAudio"));
		if (port==7215) return (g_strdup ("sub-7 matrix chat"));
		if (port==7777) return (g_strdup ("unreal"));
		if (port==7778) return (g_strdup ("unreal tournament"));
		if (port==8767) return (g_strdup ("teamspeak server"));
		if (port==10000) return (g_strdup ("webadmin"));
		if (port==10008) return (g_strdup ("cheeseworm"));
		if (port==12345) return (g_strdup ("netbus"));
		if (port==12346) return (g_strdup ("netbus"));
		if (port==13223) return (g_strdup ("powWow"));
		if (port==14534) return (g_strdup ("teamspeak http server"));
		if (port==16660) return (g_strdup ("stacheldraht"));
		if (port==16959) return (g_strdup ("sub-7"));
		if (port==17027) return (g_strdup ("conducent"));
		if (port==17300) return (g_strdup ("kuang2"));
		if (port==20000) return (g_strdup ("useradmin"));
		if (port==20034) return (g_strdup ("netbus 2 pro"));
		if (port==20002) return (g_strdup ("acidkor)"));
		if (port==21544) return (g_strdup ("girlfriend"));
		if (port==22450) return (g_strdup ("sin"));
		if (port==23456) return (g_strdup ("evilftp"));
		if (port==26900) return (g_strdup ("hexen 2"));
		if (port==26950) return (g_strdup ("hexen world"));
		if (port==27015) return (g_strdup ("half-life"));
		if (port==27374) return (g_strdup ("backdoor-G or Sub-7"));
		if (port==27444) return (g_strdup ("trin 00"));
		if (port==27500) return (g_strdup ("quake world"));
		if (port>=27910 && port<=27961) return (g_strdup("quake"));
		if (port>=28000 && port<=28008) return (g_strdup("starsiege tribes"));
		if (port==28910) return (g_strdup ("heretic 2"));
		if (port==30100) return (g_strdup ("netsphere"));
		if (port==31335) return (g_strdup ("trin 00"));
		if (port==31337) return (g_strdup ("back orifice"));
		if (port==31338) return (g_strdup ("back orifice"));
		if (port==31789) return (g_strdup ("hack'a'tack"));
		if (port==31337) return (g_strdup ("back orifice"));
		if (port>=32770 && port<=32900) return (g_strdup("sun-rpc portmapper"));
		if (port==33270) return (g_strdup ("trinity v3"));
		if (port>=33434 && port<=33600) return (g_strdup("traceroute"));
		if (port==41508) return (g_strdup ("inoculan"));
		if (port==45647) return (g_strdup ("teamspeak network"));
		if (port==50505) return (g_strdup ("sockets de troi"));
		if (port==51234) return (g_strdup ("teamspeak query port"));
		if (port==54283) return (g_strdup ("sub-7 spy port"));
		if (port==54320) return (g_strdup ("back orifice 2K"));
		if (port==54321) return (g_strdup ("back orifice 2K"));
		if (port==60001) return (g_strdup ("stacheldraht"));
		if (port==65000) return (g_strdup ("stacheldraht"));
	}

	return (g_strdup ("unknown"));
}

gchar *
get_service_name_any_protocol (gint port) {
	gchar *name = NULL;

	name = get_service_name (port, "tcp");
	if (strcmp (name, "unknown") == 0)
		name = get_service_name (port, "udp");
		
	return name;
}
