
/* z_ucs.h
 *
 * This file is part of fizmo.
 *
 * Copyright (c) 2009-2011 Christoph Ender.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#ifndef z_ucs_h_INCLUDED
#define z_ucs_h_INCLUDED

#include <string.h>
#include <stdio.h>

#include "types.h"

#define UEOF ((z_ucs)-1)
#define UTF_8_MB_LEN 6
#define Z_UCS_NEWLINE ((z_ucs)'\n')
#define Z_UCS_SPACE ((z_ucs)' ')
#define Z_UCS_BACKSLASH ((z_ucs)'\\')

size_t z_ucs_len(/*@in@*/ /*@null@*/ z_ucs *string);
/*@dependent@*/ z_ucs *z_ucs_cpy(/*@out@*/ /*@dependent@*/ z_ucs *dst,
    /*@in@*/ /*@dependent@*/ z_ucs *src);
void z_ucs_ncpy(/*@out@*/ /*dependent@*/ z_ucs *dst,
    /*@in@*/ /*dependent@*/ z_ucs *src, size_t len);
void z_ucs_output_number(/*@out@*/ z_ucs *dst, long int number);
z_ucs parse_utf_8_char(FILE *fp);
z_ucs utf_8_to_z_ucs(char **src);
z_ucs latin1_to_z_ucs(char c);
/*@null@*/ /*@dependent@*/ char *latin1_string_to_z_ucs(
    /*@out@*/ /*@dependent@*/ z_ucs *dest,
    /*@in@*/ /*@dependent@*/ char *src, size_t max_dest_size);
/*@null@*/ /*@dependent@*/ char *utf_8_string_to_z_ucs(
    /*@out@*/ /*@dependent@*/ z_ucs *dest,
    /*@in@*/ char *src, int max_dest_size);
int z_ucs_to_utf_8(/*@out@*/ /*@null@*/ char *dst, z_ucs **src,
    size_t max_dst_size);
char z_ucs_to_latin1(z_ucs src);
int z_ucs_cmp(z_ucs *s1, z_ucs *s2);
int z_ucs_cmp_latin1(z_ucs *s1, char *s2);
/*@dependent@*/ /*@null@*/ z_ucs *z_ucs_chr(z_ucs *s1, z_ucs chr);
/*@dependent@*/ /*@null@*/ z_ucs *z_ucs_rchr(z_ucs *s1, z_ucs chr);

#endif // z_ucs_h_INCLUDED

