
/* Interpreter.h
 *
 * This file is part of fizmo.
 *
 * Copyright (c) 2009 Christoph Ender.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#ifndef Interpreter_h_INCLUDED 
#define Interpreter_h_INCLUDED

#include "types.h"
#include "ScreenInterface.h"
#include "../fizmo/i18n_codes.h"


class Interpreter
{
  private:
    static struct z_screen_interface cpp_screen_interface;

  public:
    static ScreenInterface *active_cpp_screen_interface;

    static void register_screen_interface(ScreenInterface *screen_interface);
    static void start(char* z_story_filename, char *blorb_filename,
        char *restore_on_start_filename);
    static void new_screen_size(int width, int height);
    static zscii unicode_char_to_zscii_input_char(z_ucs unicode_char);
    static int streams_z_ucs_output(z_ucs *z_ucs_output);
    static int streams_latin1_output(char *latin1_output);
    static int i18n_translate(int string_code, ...);
    static int i18n_translate_and_exit(int string_code,
        int exit_code, ...);
};

#endif /* Interpreter_h_INCLUDED */

