/***** BEGIN LICENSE BLOCK *****

    FlashGot - a Firefox extension for external download managers integration
    Copyright (C) 2004-2009 Giorgio Maone - g.maone@informaction.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
                             
***** END LICENSE BLOCK *****/

var gFlashGotService = (function() {
  var fg = null;
  for(var attempt = 1; attempt <= 2; attempt++) {
    try {
     fg = Components.classes["@maone.net/flashgot-service;1"].getService(Components.interfaces.nsISupports).wrappedJSObject;
     if(attempt == 2 && fg.dirtyJobs) fg.dirtyJobs();
     break;
    } catch(ex) {
      dump(ex.message);
      window.navigator.plugins.refresh();
    }
  }
  fg.init();
  return fg;
})();

var flashgotUtil = {
  browse: function(url, feature) {
    var w = gFlashGotService.dom.mostRecentBrowserWindow;
    if(w && !w.closed) {
      var browser = w.getBrowser();
      browser.selectedTab = browser.addTab(url, null);
    } else {
      window.open(url, "_blank", features || null)
    }
  }
};
