<?php
/*
 * Print main menu with options' icons
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070729
 */
function fncc_main() {
	// security conversions
	$mod = getparam("mod", PAR_GET, SAN_FLAT);
	// print html code
	$div_header_style = "float:left;width:100%;border-bottom:1px solid;font-weight:bold";
	$div_option_style = "float:left;padding:1em 0.5em 1em 0.5em;text-align:center";
	?>
	<!-- HEADER -->
	<div style="<?=$div_header_style?>">&nbsp;&#8226;&nbsp;<?=_FNCC_FNOPTIONS?></div>
	<div style="width:100%;float:left;">
	<!-- GENERAL INFOS -->
	<div style="<?=$div_option_style?>">
		<?= build_ahah_link($mod, "&amp;op=fnccinfo", "fn_adminpanel", "get"); ?>
			<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/info.png" alt="info" border="0" /><br /><?=_FNCC_SERVERINFOS?>
		</a>
	</div>
	<!-- GENERAL CONFIGURATION -->
	<div style="<?=$div_option_style?>">
		<?= build_ahah_link($mod, "&amp;op=fnccconf", "fn_adminpanel", "get"); ?>
			<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/kcontrol.png" alt="info" border="0" /><br /><?=_FNCC_GENERALCONF?>
		</a>
	</div>
	<!-- FTP MANAGER -->
	<div style="<?=$div_option_style?>">
		<a href="#" onclick="window.open('sections/<?=$mod?>/none_tools/webadmin.php','','toolbar=no,scrollbars=yes,resizable=yes');">
			<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/kfm.png" alt="file manager" border="0" /><br /><?=_FNCC_FILEMANAGER?>
		</a>
	</div>
	</div>
	<!-- HEADER -->
	<div style="<?=$div_header_style?>">&nbsp;&#8226;&nbsp;<?=_FNCC_MANAGEFN?></div>
	<div style="width:100%;float:left;">
	<!-- INSERT NEWS -->
	<div style="<?=$div_option_style?>">
		<?= build_ahah_link($mod, "&amp;op=fnccnews", "fn_adminpanel", "get"); ?>
			<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/app_knewsticker.png" alt="motd" border="0" /><br /><?=_FNCC_NEWS?>
		</a>
	</div>
	<!-- PROPOSED NEWS -->
	<div style="<?=$div_option_style?>">
		<?= build_ahah_link($mod, "&amp;op=fnccpropnews", "fn_adminpanel", "get"); ?>
			<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/app_lists.png" alt="motd" border="0" /><br /><?=_FNCC_NEWSBYUSERS?> (<?=fncc_countpropnews();?>)
		</a>
	</div>
	<!-- EDITING MOTD -->
	<div style="<?=$div_option_style?>">
		<?= build_ahah_link($mod, "&amp;op=fnccmotd", "fn_adminpanel", "get"); ?>
			<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/app_kate.png" alt="motd" border="0" /><br /><?=_FNCC_MOTD?>
		</a>
	</div>
	<!-- EDITING POLL -->
	<div style="<?=$div_option_style?>">
		<?= build_ahah_link($mod, "&amp;op=fnccpolledit", "fn_adminpanel", "get"); ?>
			<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/poll.png" alt="poll" border="0" /><br /><?=_FNCC_POLL?>
		</a>
	</div>
	</div>
	<!-- HEADER -->
	<div style="<?=$div_header_style?>">&nbsp;&#8226;&nbsp;<?=_FNCC_USERS?></div>
	<div style="width:100%;float:left;">
	<!-- MEMBERS LIST -->
	<div style="<?=$div_option_style?>">
		<?= build_ahah_link($mod, "&amp;op=fnccmembers", "fn_adminpanel", "get"); ?>
			<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/kdmconfig.png" alt="manage users" border="0" /><br /><?=_FNCC_USERSLIST?>
		</a>
	</div>
	<!-- ADD A MEMBER -->
	<div style="<?=$div_option_style?>">
		<?= build_ahah_link($mod, "&amp;op=fnccnewprofile", "fn_adminpanel", "get"); ?>
			<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/add_user.png" alt="add user" border="0" /><br /><?=_FNCC_ADDUSER?>
		</a>
	</div>
	<!-- WAITING MEMBER -->
	<div style="<?=$div_option_style?>">
		<?= build_ahah_link($mod, "&amp;op=fnccwaitingusers", "fn_adminpanel", "get"); ?>
			<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/waiting_user.png" alt="waiting" border="0" /><br /><?=_FNCC_USERSTOACTIVATE?> (<?=fncc_countwaitingusers()?>)
		</a>
	</div>
	</div>
	<!-- HEADER -->
	<div style="<?=$div_header_style?>">&nbsp;&#8226;&nbsp;<?=_FNCC_SECURITY?></div>
	<div style="width:100%;float:left;">
	<!-- BACKUPS -->
	<div style="<?=$div_option_style?>">
		<?= build_ahah_link($mod, "&amp;op=fnccbackup", "fn_adminpanel", "get"); ?>
			<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/hdd_unmount.png" alt="backup" border="0" /><br /><?=_FNCC_BACKUPS?>
		</a>
	</div>
	<!-- VIEW LOGS -->
	<div style="<?=$div_option_style?>">
		<?= build_ahah_link($mod, "&amp;op=fncclogs", "fn_adminpanel", "get"); ?>
			<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/mimetype_log.png" alt="logs" border="0" /><br /><?=_FNCC_LOGS?>
		</a>
	</div>
	<!-- MANAGE BLACKLISTS -->
	<div style="<?=$div_option_style?>">
		<?= build_ahah_link($mod, "&amp;op=fnccblacklists", "fn_adminpanel", "get"); ?>
			<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/security.png" alt="blacklists" border="0" /><br /><?=_FNCC_BLACKLISTS?>
		</a>
	</div>
	</div>
	<!-- HEADER -->
	<div style="<?=$div_header_style?>">&nbsp;&#8226;&nbsp;<?=_FNCC_THEME?></div>
	<div style="width:100%;float:left;">
	<!-- THEME STRUCTURE -->
	<div style="<?=$div_option_style?>">
		<?= build_ahah_link($mod, "&amp;op=fnccthemestruct", "fn_adminpanel", "get"); ?>
			<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/kig.png" alt="structure" border="0" /><br /><?=_FNCC_THEMESTRUCTURE?>
		</a>
	</div>
	<!-- THEME PERSONALIZATION -->
	<div style="<?=$div_option_style?>">
		<?= build_ahah_link($mod, "&amp;op=fnccthemestyle", "fn_adminpanel", "get"); ?>
			<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/gimp.png" alt="theme" border="0" /><br /><?=_FNCC_THEMESTYLE?>
		</a>
	</div>
	<!-- CSS EDITING -->
	<div style="<?=$div_option_style?>">
		<?= build_ahah_link($mod, "&amp;op=fnccthemecss", "fn_adminpanel", "get"); ?>
			<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/stylesheet1.png" alt="css" border="0" /><br /><?=_FNCC_CSSTHEME?>
		</a>
	</div>
	<div style="<?=$div_option_style?>">
		<?= build_ahah_link($mod, "&amp;op=fnccforumcss", "fn_adminpanel", "get"); ?>
			<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/stylesheet2.png" alt="css" border="0" /><br /><?=_FNCC_CSSFORUM?>
		</a>
	</div>
	</div><?
}

/*
 * Print AHAH link
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070729
 *
 * @param	string	$mod	FN mod to go to (GET)
 * @param	string	$option	FN option to execute (GET)
 * @param	string	$target	DIV target where to write results
 * @param	string	$method	'get' or 'post'
 * @param	string	$form	Form name from which keeping POST variables
 * @return string	$ahah_link	AHAH link for the option in input
 */
function build_ahah_link($mod, $option, $target, $method, $form="") {
	// security conversions
	$mod    = getparam($mod,    PAR_NULL, SAN_FLAT);
	$option = getparam($option, PAR_NULL, SAN_FLAT);
	$target = getparam($target, PAR_NULL, SAN_FLAT);
	$method = getparam($method, PAR_NULL, SAN_FLAT);
	// build the link
	switch($method) {
	case "get":
		$ahah_link = "<a href=\"javascript:completeAHAH.ahah('".get_fn_dir("sections")."/$mod/section.php?mod=$mod"."$option','$target','0','$method');\">";
	break;
	case "post":
		$ahah_link = "\n<form id=\"$form\" action=\"javascript:completeAHAH.likeSubmit('".get_fn_dir("sections")."/$mod/section.php?mod=$mod','$method','$form','$target');\">\n";
	break;
	}
	// return string result
	return($ahah_link);
}

/*
 * Print general informations about the site and the hosting
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070924
 */
function fncc_info() {
	// security conversions
	$mod = getparam("mod", PAR_GET, SAN_FLAT);
	$req = getparam("REQUEST_URI", PAR_SERVER, SAN_NULL);
	// print the back button
	echo _FNCC_HEADERBACK;
	// check if the GD library is installed or not
	if(function_exists("gd_info")) {
		$GDinfo = gd_info();
		$GDinfo = ereg_replace('[[:alpha:][:space:]()]+', '', $GDinfo['GD Version']);
	} else $GDinfo = _FNCC_NOGDLIB;
	// get siteurl
	$my_siteurl = $_SERVER["HTTP_HOST"].$_SERVER["PHP_SELF"];
	$my_siteurl = eregi_replace(get_fn_dir("sections")."\/".$mod."\/section\.php$","index.php",$my_siteurl);
	// print misc informations about the site
	?><div style="text-align: center;">
		<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/info.png" alt="info" border="0" />
	</div>
	<div style="padding: 2em 0.5em 2em 0.5em;">
	<center><h4><?=_FNCC_SERVERINFO?></h4></center>
	<div style="padding-top:1em;"><b><?=_FNCC_SITEURL?></b><?=$my_siteurl?></div>
	<div style="padding-top:1em;"><b><?=_FNCC_OS?></b><?=PHP_OS?></div>
	<div style="padding-top:1em;"><b><?=_FNCC_WEBSERVER?></b><?=$_SERVER["SERVER_SOFTWARE"]?></div>
	<div style="padding-top:1em;"><b><?=_FNCC_PHP?></b><?=phpversion();?> - <a href="<?=get_fn_dir("sections")?>/<?=$mod?>/none_tools/phpinfo.php" target="new" title="PHP informations">PHPInfo</a></div>
	<div style="padding-top:1em;"><b><?=_FNCC_GDLIB?></b><?=$GDinfo;?></div>
	<div style="padding-top:1em;"><b><?=_FNCC_FLATNUKE?></b><? if(function_exists("get_fn_version")) echo get_fn_version(); else echo _FNCC_FNUNKNOWN;?></div><?
	$total_space   = round(disk_free_space("./")/1024/1024,2);
	$site_space    = round(fncc_getsize("./")/1024/1024,2);
	$perc_occupied = round($site_space*100/$total_space,1);
	$perc_free     = round(100-($site_space*100/$total_space),1);
	?>
	<div style="padding-top:1em;"><b><?=_FNCC_SERVERSPACE?></b><?echo "$total_space Mb";?></div>
	<div style="padding:1em 0em 2em 0em;"><b><?=_FNCC_SITESPACE?></b><?echo "$site_space Mb";?>
		<p><table align="center" cellspacing="0"><tbody><tr>
		<td><?=$perc_occupied?>%&nbsp;</td>
		<td style="width:<?=$perc_occupied?>px;background-color:#FF0000;"></td>
		<td style="width:<?=$perc_free?>px;background-color:#00FF00;"></td>
		<td>&nbsp;<?=$perc_free?>%</td>
		</tr></tbody></table></p>
	</div>
	<center><h4><?=_FNCC_MYINFOS?></h4></center>
	<div style="padding-top:1em;"><b><?=_FNCC_IP?></b><?=$_SERVER["REMOTE_ADDR"]?></div>
	<div style="padding-top:1em;"><b><?=_FNCC_USERAGENT?></b><?=$_SERVER["HTTP_USER_AGENT"]?></div>
	</div><?
	// print the back button
	echo _FNCC_HEADERBACK;
}

/*
 * Return directory size
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20061101
 *
 * @param	string	$dirpath	Path of the directory to check
 * @return	integer	$totalsize	Size of the directory
 */
function fncc_getsize($dirpath) {
	// security conversions
	$dirpath = getparam($dirpath, PAR_NULL, SAN_FLAT);
	// go calculate
	require_once("include/filesystem/DeepDir.php");
	$totalsize = 0;
	$dir = new DeepDir();
	$dir->setDir($dirpath);
	$dir->load();
	foreach($dir->files as $n => $pathToFile)
		$totalsize += filesize($pathToFile);
	return $totalsize;
}

/*
 * Flatnuke general configuration
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070924
 */
function fncc_conf() {
	// security conversions
	$mod = getparam("mod", PAR_GET, SAN_FLAT);
	// print the back button
	echo _FNCC_HEADERBACK;
	// print html code
	?><div style="text-align: center;">
		<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/kcontrol.png" alt="configuration" border="0" />
	</div>
	<div style="padding: 2em 0.5em 2em 0.5em;">
		<center><h4><?=_FNCC_DESGENERALCONF?></h4></center>
		<div style="padding-top:1em;"><? fncc_generalconf(); ?></div>
	</div><?
	// print the back button
	echo _FNCC_HEADERBACK;
}

/*
 * Manage MOTD file
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070924
 */
function fncc_motd() {
	// security conversions
	$mod = getparam("mod", PAR_GET, SAN_FLAT);
	// print the back button
	echo _FNCC_HEADERBACK;
	// print html code
	?><div style="text-align: center;">
		<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/app_kate.png" alt="motd" border="0" />
	</div>
	<div style="padding: 2em 0.5em 2em 0.5em;">
		<center><h4><?=_FNCC_DESMOTD?></h4></center>
		<div style="padding-top:1em;"><? fncc_editconffile(get_fn_dir("var")."/motd.php"); ?></div>
	</div><?
	// print the back button
	echo _FNCC_HEADERBACK;
}

/*
 * Admin can add/modify a news
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070924
 */
function fncc_news() {
	// security conversions
	$mod = getparam("mod", PAR_GET, SAN_FLAT);
	// print the back button
	echo _FNCC_HEADERBACK;
	// print html code
	?><div style="text-align: center;">
		<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/app_knewsticker.png" alt="news" border="0" />
	</div>
	<div style="padding: 2em 0.5em 2em 0.5em;">
		<center><h4><?=_FNCC_DESNEWS?></h4></center>
		<div style="padding-top:1em;"><? fncc_managenews(); ?></div>
	</div><?
	// print the back button
	echo _FNCC_HEADERBACK;
}

/*
 * Admin can manage news proposed by users
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070924
 */
function fncc_propnews() {
	// security conversions
	$mod = getparam("mod", PAR_GET, SAN_FLAT);
	// print the back button
	echo _FNCC_HEADERBACK;
	// print html code
	?><div style="text-align: center;">
		<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/app_lists.png" alt="news" border="0" />
	</div>
	<div style="padding: 2em 0.5em 2em 0.5em;">
		<center><h4><?=_FNCC_DESNEWSBYUSERS?></h4></center>
		<div style="padding-top:1em;"><? fncc_managepropnews(); ?></div>
	</div><?
	// print the back button
	echo _FNCC_HEADERBACK;
}

/*
 * Returns the number of proposed news
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070721
 *
 * @return	integer	Number of news proposed by users
 */
function fncc_countpropnews() {
	$proplist = array();
	$handle = opendir(get_fn_dir("var"));
	while($file = readdir($handle)) {
		if(eregi("^news_[0-9]+\.xml$", $file)) {
			array_push($proplist, $file);
		}
	}	//echo "<pre>";print_r($proplist);echo "</pre>";	//-> TEST
	closedir($handle);
	return(count($proplist));
}

/*
 * Manage poll configuration
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070924
 */
function fncc_polledit() {
	// security conversions
	$mod = getparam("mod", PAR_GET, SAN_FLAT);
	// print the back button
	echo _FNCC_HEADERBACK;
	// print html code
	?><div style="text-align: center;">
		<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/poll.png" alt="poll" border="0" />
	</div>
	<div style="padding: 2em 0.5em 2em 0.5em;">
		<center><h4><?=_FNCC_DESPOLL?></h4></center>
		<div style="padding-top:1em;"><? fncc_editpoll(); ?></div>
	</div><?
	// print the back button
	echo _FNCC_HEADERBACK;
}

/*
 * List all members of the site
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070924
 */
function fncc_members() {
	// security conversions
	$mod = getparam("mod", PAR_GET, SAN_FLAT);
	// print the back button
	echo _FNCC_HEADERBACK;
	// print html code
	?><div style="text-align: center;">
		<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/kdmconfig.png" alt="manage users" border="0" />
	</div>
	<div style="padding: 2em 0.5em 2em 0.5em;">
		<center><h4><?=_FNCC_DESUSERSLIST?></h4></center>
		<div style="padding-top:1em;"><? fncc_userslist(); ?></div>
	</div><?
	// print the back button
	echo _FNCC_HEADERBACK;
}

/*
 * Add a new user profile
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070924
 */
function fncc_newprofile() {
	// security conversions
	$mod  = getparam("mod", PAR_GET, SAN_FLAT);
	// print the back button
	echo _FNCC_HEADERBACK;
	// print html code
	?><div style="text-align: center;">
		<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/id_card.png" alt="user profile" border="0" />
	</div>
	<div style="padding: 2em 0.5em 2em 0.5em;">
	<center><h4><?=_FNCC_DESADDUSER?></h4></center>
		<div style="padding-top:1em;"><? fncc_newuserprofile(); ?></div>
	</div><?
	// print the back button
	echo _FNCC_HEADERBACK;
}

/*
 * Add a new user profile
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070924
 */
function fncc_waitingusers() {
	// security conversions
	$mod  = getparam("mod", PAR_GET, SAN_FLAT);
	// print the back button
	echo _FNCC_HEADERBACK;
	// print html code
	?><div style="text-align: center;">
		<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/waiting_user.png" alt="waiting profiles" border="0" />
	</div>
	<div style="padding: 2em 0.5em 2em 0.5em;">
	<center><h4><?=_FNCC_WAITINGUSERS?></h4></center>
		<div style="padding-top:1em;"><? fncc_listwaiting(); ?></div>
	</div><?
	// print the back button
	echo _FNCC_HEADERBACK;
}

/*
 * Returns the number of users waiting for activation
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070726
 *
 * @return	integer	Number of users waiting
 */
function fncc_countwaitingusers() {
	$waitinglist = array();
	$handle = opendir(get_waiting_users_dir());
	while($file = readdir($handle)) {
		if(eregi("^[0-9a-zA-Z]+\.php$", $file)) {
			array_push($waitinglist, $file);
		}
	}	//echo "<pre>";print_r($waitinglist);echo "</pre>";	//-> TEST
	closedir($handle);
	return(count($waitinglist));
}

/*
 * Admin can create and download FN backups
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070924
 */
function fncc_backups() {
	// security conversions
	$mod = getparam("mod", PAR_GET, SAN_FLAT);
	// print the back button
	echo _FNCC_HEADERBACK;
	// print html code
	?><div style="text-align: center;">
		<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/hdd_unmount.png" alt="backup" border="0" />
	</div>
	<div style="padding: 2em 0.5em 2em 0.5em;">
		<center><h4><?=_FNCC_DESBACKUPS?></h4></center>
		<div style="padding-top:1em;"><? fncc_managebackups(); ?></div>
	</div><?
	// print the back button
	echo _FNCC_HEADERBACK;
}

/*
 * Returns the list of backup files
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070722
 *
 * @return	array	List of backup files created in /misc directory
 */
function fncc_listbackups() {
	$backup_files = array();
	$handle = opendir(get_fn_dir("var"));
	while($file = readdir($handle)) {
		if(eregi("^backup_[a-zA-Z]+_[0-9]+\.zip$", $file)) {
			array_push($backup_files, $file);
		}
	}
	closedir($handle);
	return($backup_files);
}

/*
 * Admin can look at Flatnuke logs
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070924
 */
function fncc_logs() {
	// security conversions
	$mod = getparam("mod", PAR_GET, SAN_FLAT);
	// print the back button
	echo _FNCC_HEADERBACK;
	// print html code
	?><div style="text-align: center;">
		<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/mimetype_log.png" alt="logs" border="0" />
	</div>
	<div style="padding: 2em 0.5em 2em 0.5em;">
		<center><h4><?=_FNCC_DESLOGS?></h4></center>
		<div style="padding-top:1em;"><? fncc_managelogs(); ?></div>
	</div><?
	// print the back button
	echo _FNCC_HEADERBACK;
}

/*
 * Admin can manage Flatnuke blacklists
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070924
 */
function fncc_blacklists() {
	// security conversions
	$mod = getparam("mod", PAR_GET, SAN_FLAT);
	// print the back button
	echo _FNCC_HEADERBACK;
	// print html code
	?><div style="text-align: center;">
		<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/security.png" alt="blacklists" border="0" />
	</div>
	<div style="padding: 2em 0.5em 2em 0.5em;">
		<center><h4><?=_FNCC_DESBLACKLISTS?></h4></center>
		<div style="padding-top:1em;"><? fncc_manageblacklists(); ?></div>
	</div><?
	// print the back button
	echo _FNCC_HEADERBACK;
}

/*
 * Manage theme's structure
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070924
 */
function fncc_themestruct() {
	// security conversions
	$mod = getparam("mod", PAR_GET, SAN_FLAT);
	global $theme;
	// print the back button
	echo _FNCC_HEADERBACK;
	// print html code
	?><div style="text-align: center;">
		<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/kig.png" alt="structure" border="0" />
	</div>
	<div style="padding: 2em 0.5em 2em 0.5em;">
		<center><h4><?=_FNCC_DESTHEMESTRUCTURE?></h4></center>
		<div style="padding-top:1em;"><? fncc_editconffile(get_fn_dir("themes")."/$theme/structure.php"); ?></div>
	</div><?
	// print the back button
	echo _FNCC_HEADERBACK;
}

/*
 * Manage theme's personalisations
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070924
 */
function fncc_themestyle() {
	// security conversions
	$mod = getparam("mod", PAR_GET, SAN_FLAT);
	global $theme;
	// print the back button
	echo _FNCC_HEADERBACK;
	// print html code
	?><div style="text-align: center;">
		<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/gimp.png" alt="theme" border="0" />
	</div>
	<div style="padding: 2em 0.5em 2em 0.5em;">
		<center><h4><?=_FNCC_DESTHEMESTYLE?></h4></center>
		<div style="padding-top:1em;"><? fncc_editconffile(get_fn_dir("themes")."/$theme/theme.php"); ?></div>
	</div><?
	// print the back button
	echo _FNCC_HEADERBACK;
}

/*
 * Manage theme's CSS file
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070924
 */
function fncc_themecss() {
	// security conversions
	$mod = getparam("mod", PAR_GET, SAN_FLAT);
	global $theme;
	// print the back button
	echo _FNCC_HEADERBACK;
	// print html code
	?><div style="text-align: center;">
		<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/stylesheet1.png" alt="css" border="0" />
	</div>
	<div style="padding: 2em 0.5em 2em 0.5em;">
		<center><h4><?=_FNCC_DESCSSTHEME?></h4></center>
		<div style="padding-top:1em;"><? fncc_editconffile(get_fn_dir("themes")."/$theme/style.css"); ?></div>
	</div><?
	// print the back button
	echo _FNCC_HEADERBACK;
}

/*
 * Manage forum's CSS file
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070924
 */
function fncc_forumcss() {
	// security conversions
	$mod = getparam("mod", PAR_GET, SAN_FLAT);
	global $theme;
	// print the back button
	echo _FNCC_HEADERBACK;
	// print html code
	?><div style="text-align: center;">
		<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/stylesheet2.png" alt="css" border="0" />
	</div>
	<div style="padding: 2em 0.5em 2em 0.5em;">
		<center><h4><?=_FNCC_DESCSSFORUM?></h4></center>
		<div style="padding-top:1em;"><? fncc_editconffile(get_fn_dir("themes")."/$theme/forum.css"); ?></div>
	</div><?
	// print the back button
	echo _FNCC_HEADERBACK;
}

/*
 * Section reserved to site admins only
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20061101
 */
function fncc_onlyadmin() {
	// security conversions
	$mod = getparam("mod", PAR_GET, SAN_FLAT);
	// print html code
	?>
	<div style="padding: 2em 0.5em 2em 0.5em;text-align:center;"><h4><?=_FNCC_ONLYADMIN?></h4>
		<div style="padding-top:1em;"><img src="images/maintenance.png" alt="lock" border="0" /></div>
		<div style="padding-top:1em;"><?=_FNCC_DESONLYADMIN?></div>
	</div>
	<?
	// log the attempt
	$ip = getparam("REMOTE_ADDR", PAR_SERVER, SAN_NULL);
	fnlog("Security", "$ip||".get_username()."||Tried to access the administration panel.");
}

?>