<?php

// intercept direct access to this file & rebuild the right path
if (eregi("section.php",$_SERVER['PHP_SELF'])) {
	chdir("../../");
	include_once("config.php");
	include_once("functions.php");
	// set again cookies values of the language
	$userlang = getparam("userlang", PAR_COOKIE, SAN_FLAT);
	if ($userlang!="" AND is_alphanumeric($userlang) AND file_exists("languages/$userlang.php")) {
		$lang = $userlang;
	}
	include_once("languages/$lang.php");
	// set again cookies values of the theme
	$usertheme = getparam("usertheme", PAR_COOKIE, SAN_FLAT);
	if ($usertheme!="" AND !stristr("..",$usertheme) AND is_dir(get_fn_dir("themes")."/$usertheme")) {
		$theme = $usertheme;
	}
	// set again charset: using ajax, it could be rewritten by the web server
	@header("Content-Type: text/html; charset="._CHARSET."");
}

// security checks
$req = getparam("REQUEST_URI", PAR_SERVER, SAN_NULL);
if(strstr($req,"myforum="))
	die(_NONPUOI);
$conf_mod  = getparam("conf_mod",  PAR_POST, SAN_FLAT);
$get_act   = getparam("get_act",   PAR_GET,  SAN_FLAT);
$mod       = getparam("mod",       PAR_GET,  SAN_FLAT);
$op        = getparam("op",        PAR_GET,  SAN_FLAT);

// language definition
global $lang;
switch($lang) {
	case "it": 
		include_once ("languages/admin/$lang.php");
	break;
	default:
		include_once ("languages/admin/en.php");
}

// external code declarations
include_once (get_fn_dir("sections")."/$mod/none_functions/func_interfaces.php");

// constants definitions
define("_FNCC_HEADERBACK", "<img src='".get_fn_dir("sections")."/$mod/none_images/back.png' alt='back' border='0' title='back' style='vertical-align:middle'>&nbsp;".build_ahah_link($mod, "", "fn_adminpanel", "get")._INDIETRO."</a>");

################################################################
/*                     MAIN EXECUTION                         */
################################################################

if(is_admin()) {
	echo "<div id='fn_adminpanel'>";
	// external code declarations
	include_once (get_fn_dir("sections")."/$mod/none_functions/func_operations.php");
	include_once (get_fn_dir("sections")."/$mod/none_functions/func_verify.php");
	// POST actions
	switch($conf_mod) {
		case "phpinfo":			fncc_phpinfo();			break;	// print PHP configuration on the web server
		case "modgeneralconf":	fncc_modgeneralconf();	break;	// save main Flatnuke configuration
		case "modbodyfile":		fncc_modbodyfile();		break;	// save standard text file
		case "savenews":		fncc_savenews();		break;	// save news
		case "savepropnews":	fncc_savepropnews();	break;	// save news proposed by users
		case "savepoll":		fncc_savepoll();		break;	// save poll informations
		case "archpoll":		fncc_archpoll();		break;	// archive poll and build a new one
		case "saveprofile":		fncc_saveprofile();		break;	// save new user profile
		case "updatewaiting":	fncc_updatewaiting();	break;	// update email address of a profile waiting for activation
		case "sendactivation":	fncc_sendactivation();	break;	// re-send activation code to users
		case "dobackup":		fncc_dobackup();		break;	// make the backup
		case "cleanbackup":		fncc_cleanbackup();		break;	// delete backup files on the server
		case "cleanlog":		fncc_cleanlog();		break;	// clean log file
		case "modblacklist":	fncc_modbodyfile();		break;	// save blacklist text file
	}
	// GET actions
	switch($get_act) {
		case "deletenews":		fncc_delnews();		break;	// delete news
		case "deletewaiting":	fncc_delwaiting();	break;	// delete waiting user
	}
	// GET options
	switch($op) {
		case "fnccinfo":		fncc_info();		break;	// general infos on the site
		case "fnccconf":		fncc_conf();		break;	// main Flatnuke configuration
		/*----------------------------------------------*/
		case "fnccnews":		fncc_news();		break;	// admin can add a news
		case "fnccpropnews":	fncc_propnews();	break;	// admin can publish news proposed by users
		case "fnccmotd"    :	fncc_motd();		break;	// manage MOTD file
		case "fnccpolledit":	fncc_polledit();	break;	// manage poll configuration
		/*----------------------------------------------*/
		case "fnccmembers"   :	fncc_members();		break;	// manage users of the site
		case "fnccnewprofile":	fncc_newprofile();	break;	// add a new user profile
		case "fnccwaitingusers":fncc_waitingusers();break;	// manage profiles waiting for activation
		/*----------------------------------------------*/
		case "fnccbackup":		fncc_backups();		break;	// manage FN backups
		case "fncclogs":		fncc_logs();		break;	// manage system logs
		case "fnccblacklists":	fncc_blacklists();	break;	// manage FN blacklists
		/*----------------------------------------------*/
		case "fnccthemestruct":	fncc_themestruct();	break;	// manage theme's structure
		case "fnccthemestyle" :	fncc_themestyle();	break;	// manage theme's style
		case "fnccthemecss"   :	fncc_themecss();	break;	// manage theme's CSS
		case "fnccforumcss"   :	fncc_forumcss();	break;	// manage forum's CSS
		/*----------------------------------------------*/
		default: fncc_main();	// default menu
	}
	echo "</div>";
} else fncc_onlyadmin();	// only admins can access this section

?>