<?

if (eregi("section.php",$_SERVER['PHP_SELF'])) {
	// let direct access in case of maintenance state --> ONLY for login action
	if(isset($_POST['action']) AND $_POST['action']=="login") {
		chdir("../../");
		include_once "config.php";
		include_once "functions.php";
		switch($lang) {
			case "de" OR "es" OR "fr" OR "it" OR "pt":
				include_once ("languages/$lang.php");
			break;
			default:
				include_once ("languages/en.php");
		}
		login();
		return;
	} 
	// block any other direct access to this page
	else {
		Header("Location: ../../index.php");
		die();
	}
}
	
//scelgo l'azione da compiere
if (isset($_GET['action'])){
	$action = getparam("action",PAR_GET,SAN_FLAT);
	switch($action) {
		case "visreg":
			reg_interface();
		break;
		case "viewmembers":
			view_members();
		break;
		case "viewprofile":
			$user = getparam("user",PAR_GET,SAN_FLAT);
			if (trim($user)=="")
				view_profile(get_username());
			else view_profile($user);
		break;
		case "editprofile":
			edit_profile();
		break;
		case "deleteuser":
			delete_user();
		break;
		case "logout":
			logout();
		break;
		case "activateuser":
			$user =getparam("user",PAR_GET,SAN_FLAT);
			if (!is_alphanumeric($user)) die("User name is not valid!");
			$regcode = getparam("regcode",PAR_GET,SAN_NULL);
			if (!check_var($regcode,"digit")) die("The registration code is not valid!");
			activate_user($user,$regcode);
		break;
	}
}
else if (isset($_POST['action'])){
	$action = getparam("action",PAR_POST,SAN_FLAT);
	switch($action) {
	case "login":
		login();
	break;
	case "reguser":
		reguser();
	break;
	case "saveprofile":
		save_profile();
	break;
	}
}
else  {
	if (is_guest())
		login_interface();
	else view_profile(get_username());
}


/**
 * Visualizza l'interfaccia per effettuare il login
 *
 * Visualizza l'interfaccia per effettuare il login degli
 * utenti registrati, e propone un link per la registrazione
 * di nuovi utenti.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 * @author Marco Segato <segatom@users.sourceforge.net> | 20070317: ready to 2.5.9
 */
function login_interface(){
	?><div align="center">
	<fieldset>
	<legend><?=_FLOGIN?></legend>
	<form action="index.php?mod=none_Login" method="post">
	<input type="hidden" name="action" value="login" />
	<div style="text-align:right;padding:1em;margin-right:30%;padding:0.2em;">
	<label for="nome"><?=_NOMEUTENTE?></label> <input name="nome" type="text" id="nome"/>
	</div>
	<div style="text-align:right;padding:1em;margin-right:30%;padding:0.2em;">
	<label for="logpassword"><?=_PASSWORD?></label> <input name="logpassword" type="password" id="logpassword"/>
	</div>
	<?
	// remember login checkbox
	global $remember_login;
	if($remember_login==1) {
		echo "<div style=\"margin:1em;\"><label for=\"rememberlogin\">"._REMEMBERLOGIN."</label>";
		echo "<input type=\"checkbox\" alt=\"remember_login\" name=\"rememberlogin\" id=\"rememberlogin\" /><br />";
		echo "</div>";
	} else echo "<br />";
	// login button
	?><input type="submit" value="<?=_LOGIN?>" />
	</form>
	</fieldset>
	<br /><?
	// link to register
	global $reguser;
	if ($reguser=="1" or $reguser=="2"){
		echo _NONREG;
		?><br /><b><a href="index.php?mod=none_Login&amp;action=visreg" title="<?=_REGORA?>"><?=_REGORA?></a></b><?
	}
	?></div><?
}


/**
 * Interfaccia che permette la registrazione di un nuovo utente
 * 
 * Visualizza l'interfaccia che permette di effettuare la
 * registrazione di un nuovo utente, richiedendo di compilare
 * una serie di campi informazione.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 * @author Marco Segato <segatom@users.sourceforge.net> | 20070317: ready to 2.5.9
 */
function reg_interface(){
	// deny fake regs
	if (isset($_GET['reguser']) or isset($_POST['reguser']) or isset($_COOKIE['reguser'])) die(_NONPUOI);
	// check if registering is permitted
	global $reguser;
	if ($reguser!="1" and $reguser!="2") die(_NONPUOI); // if not, die
	// print registration forms
	edit_user_interface("","reguser");
}


/**
 * Visualizza gli utenti registrati sul portale
 * 
 * Visualizza una lista degli utenti registrati sul portale,
 * con alcune delle informazioni personali inserite.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 * @author Marco Segato <segatom@users.sourceforge.net> | 20070317: ready to 2.5.9
 */
function view_members(){
	// security convertions
	$page    = getparam("page", PAR_GET, SAN_FLAT);
	$myforum = getparam("myforum",PAR_COOKIE,SAN_FLAT);
	$req     = getparam("REQUEST_URI",PAR_SERVER, SAN_FLAT);
	if(strstr($req,"myforum="))
		die(_NONPUOI);
	// check number of page to display
	global $memberperpage;
	if ($page == "") $page = 0;
	if ($page != 0) $page -= 1;

	// check that current user is logged
	if (!is_guest()) {
		echo "<b>"._FUTENTI."</b>:<br /><br />";
		?>
		<table width='95%' cellspacing='1' cellpadding='2' style="border-collapse:collapse">
		<tbody>
		<tr class='forum-group-header'>
		<td class='forum-group-table'><b><?=_NOMEUTENTE?></b></td>
		<td class='forum-group-table'><b><?=_LEVEL?></b></td>
		<td class='forum-group-table'><b><?=_FNOME?></b></td>
		<td class='forum-group-table'><b><?=_FEMAIL?></b></td>
		<td class='forum-group-table'><b><?=_FHOME?></b></td>
		</tr>
		<?
		// start printing each user
		$members = array();
		$members = list_users();
		sort ($members);
		reset ($members);
		$profile = array();
		for($x=$page*$memberperpage; $x<$memberperpage*($page+1); $x++) {
			if (isset($members[$x])) {
				$user = str_replace(".php","",$members[$x]);
				$profile = load_user_profile($user);
				echo "<tr>";
				echo "<td class='forum-group-table'><a href=\"index.php?mod=none_Login&amp;action=viewprofile&amp;user=$user\">$user</a></td>";
				echo "<td class='forum-group-table' align='center'>".$profile['level']."&nbsp;</td>";
				echo "<td class='forum-group-table'>".$profile['name']."&nbsp;</td>";
				echo "<td class='forum-group-table' align='center'>";
// 				echo "mail: ".$profile['hiddenmail'];
				if($profile['mail']!="" and $profile['hiddenmail']!="1" and !is_guest()) {
					echo "<a href=\"mailto:".email_mask($profile['mail'])."\">".str_replace("%20"," ",email_mask($profile['mail']))."</a>";
				}
				else if ($profile['mail']!="" and $profile['hiddenmail']=="1" and is_admin()) {
					//gli amministratori vedono tutto
					echo "<a href=\"mailto:".email_mask($profile['mail'])."\">".str_replace("%20"," ",email_mask($profile['mail']))."</a>";
				}
				else if ($profile['mail']!="" and $profile['hiddenmail']=="1" and !is_admin()){
					echo "";
				}
				else echo "&nbsp;";
				echo "</td>";
				echo "<td class='forum-group-table' align='center'>";
				if($profile['homepage']!="") {
					echo "<a href=\"".$profile['homepage']."\" target=\"_blank\">".$profile['homepage']."</a>";
				} else echo "&nbsp;";
				echo "</td>";
				echo "</tr>";
			}
		}
		// print pages to change view
		$pages = "";
		if(count($members)>$memberperpage){
			for ($thispagenum=1; $thispagenum<=ceil(count($members)/$memberperpage); $thispagenum++) {
				if($thispagenum != ($page+1))
					$pages .= "[<a href=\"index.php?mod=none_Login&amp;action=viewmembers&amp;page=".$thispagenum."\">".$thispagenum."</a>] ";
				else
					$pages .= "[".$thispagenum."] ";
			}
		}
		?></tbody>
		</table>
		<div style="width:95%; margin-top:1em; text-align:center;"><?=$pages;?></div><?
	}
	// not available to unregistered users
	else echo  "<div style=\"width:95%; margin-top:1em; text-align:center;\"><b>"._FERRACC."</b></div>";
}


/**
 * Visualizza il profilo dell'utente
 * 
 * Visualizza il profilo dell'utente selezionato presentandone
 * le piu` significative informazioni personali inserite.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 * @author Marco Segato <segatom@users.sourceforge.net> | 20070317: ready to 2.5.9
 *
 * @param string $user Profilo utente da visualizzare
 */
function view_profile($user=""){
	if (is_guest()){
		login_interface();
		return;
	}
	// secutiry checks
	// Username must be taken from function's parameter. If it's take from GET variable
	// there are some problems in viewing profile
	$user    = getparam($user, PAR_NULL, SAN_FLAT);
	$myforum = get_username();
	$addr    = getparam("REMOTE_ADDR",PAR_SERVER, SAN_FLAT);
	global $lang;
	// check profile exists
	if(!file_exists(get_fn_dir("users")."/$user.php")) {
		?><div style="width:95%; margin-top:1em; text-align:center;">
		<br /><b><?=_NORESULT?></b><br />
		</div><?
		fnlog("Viewprofile", $addr."||".$myforum."||Tried to view unexistant $user profile.");
		return;
	}
	// print profile's informations
	?><div style="width:95%; margin-top:1em; text-align:center;"><?
	// check that current user is logged
	if(!is_guest()) {
		$profile = load_user_profile($user);
		// username
		echo "<b>$user</b><br />";
		// avatar
		$img = $profile['avatar'];
		if($img!="") {
			if(!stristr($img,"http://"))
				echo "<img src='forum/$img' alt='$user' border='0' style='max-width:120px' />";
			else echo "<img src='$img' alt='$user' border='0' style='max-width:120px' />";
		} else echo "<img src='forum/images/blank.png' alt='$user' border='0' style='max-width:120px' />";
		echo "<br /><br />";
		$style1 = "font-style:bold; padding:0.2em;";
		$style2 = "padding:0.2em;";
		?>
		<table width='70%' align='center' border='1' style="border-collapse:collapse">
		<tbody>
		<tr>
		<td width="30%" style="<?=$style1?>"><b><?=_FNOME?>:</b></td>
		<td style="<?=$style2?>"><?=$profile['name']?></td>
		</tr>
		<tr>
		<td style="<?=$style1?>"><b><?=_FEMAIL?>:</b></td>
		<td style="<?=$style2?>"><a href="mailto:<?=email_mask($profile['mail'])?>"><?=str_replace("%20"," ",email_mask($profile['mail']))?></a></td>
		</tr>
		<tr>
		<td style="<?=$style1?>"><b><?=_FHOME?>:</b></td>
		<td style="<?=$style2?>"><?
		if (trim($profile['homepage'])!=""){
			echo "<a href=\"".$profile['homepage']."\" target=\"_blank\">".$profile['homepage']."</a>";
		}
		?></td>
		</tr>
		<tr>
		<td style="<?=$style1?>"><b><?=_FPROFES?>:</b></td>
		<td style="<?=$style2?>"><?=$profile['work']?></td>
		</tr>
		<tr>
		<td style="<?=$style1?>"><b><?=_FPROV?>:</b></td>
		<td style="<?=$style2?>"><?
			if(trim($profile['from'])!="") {
				?><a href="http://maps.google.<?=$lang?>/maps?f=q&hl=<?=$lang?>&q=<?=$profile['from']?>" target="new" title="Google Maps"><?=$profile['from']?></a><?
			}
		?></td>
		</tr>
		<tr>
		<td style="<?=$style1?>"><b><?=_LEVEL?>:</b></td>
		<td style="<?=$style2?>"><?=$profile['level']?></td>
		</tr>
		</tbody>
		</table>
		<br />
		<?
		// admins can delete profiles
		if(is_admin()) {
			echo "<b><a href='#' onclick=\"check('index.php?mod=none_Login&amp;action=deleteuser&amp;user=$user')\">"._FDELUTENTE."</a></b>&nbsp;|&nbsp;";
		}
		// link to edit profile if it's me or admins
		if (is_admin() OR $myforum==$user) {
			echo "<b><a href=\"index.php?mod=none_Login&amp;action=editprofile&amp;user=$user\">"._FMODPROF."</a></b>";
		}
	}
	// not available to unregistered users
	else echo "<b>"._FERRACC."</b>";
	?></div><?
}


/**
 * Funzione per effettuare il login
 *
 * Funzione per effettuare il login ed impostare
 * i cookies con le informazioni di autenticazione.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 * @author Marco Segato <segatom@users.sourceforge.net> | 20070317: ready to 2.5.9
 */
function login(){
	global $remember_login;
	// security fixes
	$nome          = getparam("nome",PAR_POST,SAN_FLAT);
	$logpassword   = getparam("logpassword",PAR_POST,SAN_FLAT);
	$rememberlogin = getparam("rememberlogin", PAR_POST, SAN_FLAT);
	$url           = getparam("PHP_SELF",PAR_SERVER, SAN_FLAT);
	$addr          = getparam("REMOTE_ADDR",PAR_SERVER, SAN_FLAT);
	$nome = str_replace("<","",$nome);
	$nome = str_replace(">","",$nome);
	// md5 input password
	$lpass = md5($logpassword);
	
	// unregistered or blank user
	if(!file_exists(get_fn_dir("users")."/$nome.php") || ($nome=="")) {
		if (file_exists(get_waiting_users_dir()."/$nome.php")){
			echo "<div style=\"text-align: center;\"><b>"._WAITINGUSERLOGIN;
			echo "</b><br />"._CONTACTADMIN."<br /><br /><a href=\"javascript:history.back()\">"._INDIETRO."</a></div>";
			return;
		}
		
		// rebuild correct path
		$url = str_replace("/sections/none_Login/section.php", "", $url);
		$url = str_replace("/index.php", "", $url);
		// goto registration module
		?><div style="width:95%;margin:1em;text-align:center;">
		<b><?=$nome?></b> <?=_FNONREG?>
		<br /><br /><?
		// link to register
		global $reguser;
		if ($reguser=="1" or $reguser=="2"){
			echo _NONREG;
			?><br /><b><a href="<?=$url?>/index.php?mod=none_Login&amp;action=visreg" title="<?=_REGORA?>"><?=_REGORA?></a></b><?
		}
		?></div><?
	}
	// registered user
	else {
		$profile = load_user_profile($nome);
		$passwd = $profile['password'];
		// password is correct
		if($passwd==$lpass){
			// rebuild correct path for the cookie
			$path = pathinfo($url);
			$path = str_replace("\\","/",$path);
			$url = str_replace("/forum","",$path["dirname"]);
			$url = str_replace("/sections/none_Login","",$path["dirname"]);
			if($url=="")
				$url="/";
			// manage cookies' life
			if($remember_login==0 OR $rememberlogin=="") {
				setcookie("myforum",$nome,0,"$url");
				setcookie("secid",md5($nome.$passwd),0,"$url");
			} else {
				setcookie("myforum",$nome,time()+99999999,"$url");
				setcookie("secid",md5($nome.$passwd),time()+99999999,"$url");
			}
			// log action
			$myforum = getparam("myforum",PAR_COOKIE,SAN_FLAT);
			fnlog("Login", $addr."||".$myforum."||User $nome login.");
			// go back to ref page
			?><script language="javascript">window.location='<?=getparam("HTTP_REFERER", PAR_SERVER, SAN_FLAT)?>';</script><?
	 	}
		// wrong password
		else {
			?><div style="width:95%;margin:1em;text-align:center;">
			<b><?=$nome?></b> <?=_FERRPASS?>
			<br /><br />
			<a href="javascript:history.back()">&lt;&lt;&nbsp;<?=_INDIETRO?></a>
			</div><?
		}
	}	
}


/**
 * Modifica il profilo dell'utente
 *
 * Permette di modificare, dopo i necessari controlli sulle
 * autorizzazioni a farlo, il profilo utente selezionato.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 * @author Marco Segato <segatom@users.sourceforge.net> | 20070317: ready to 2.5.9
 *
 * @param string $user Profilo utente da modificare
 */
function edit_profile($user=""){
	// security checks
	$user    = getparam("user", PAR_GET, SAN_FLAT);
	$myforum = getparam("myforum",PAR_COOKIE,SAN_FLAT);
	$addr    = getparam("REMOTE_ADDR",PAR_SERVER, SAN_FLAT);
	$req     = getparam("REQUEST_URI",PAR_SERVER, SAN_FLAT);
	if(strstr($req,"myforum=")) die(_NONPUOI);
	// check profile exists
	if(!file_exists(get_fn_dir("users")."/$user.php") OR $user=="") {
		?><div style="width:95%; margin:1em; text-align:center;">
		<b><?=_NORESULT?></b>
		</div><?
		fnlog("Editprofile", $addr."||".$myforum."||Tried to edit unexistant $user profile.");
		return;
	}

	// who can edit my account? admins or myself ;)
	if( is_admin() OR (is_user() AND $user==$myforum) ) {
		edit_user_interface($user,"edit");
	} // unauthorized tries
	else {
		fnlog("Editprofile", $addr."||".$myforum."||Tried to edit ".$user." profile.");
		// go back home
		?><script language="javascript">window.location='index.php';</script><?
	}
}


/**
 *
 *
 */
function save_profile(){

	//controllo se  possibile registrarsi sulo sito
	if (isset($_GET['reguser']) or isset($_POST['reguser']) or isset($_COOKIE['reguser'])) die(_NONPUOI);
	global $reguser;
	if ($reguser!="1" and $reguser!="2"){
		//posso continuare solo se sto modificando il mio profilo.
		//oppure se sto modificando il profilo di un altro in qualit di amministratore
		$nome="";
		$myforum="";
		$nome=getparam("user",PAR_POST,SAN_FLAT);
		$nome=str_replace("\r","",str_replace("\n","",$nome));
		$nome=str_replace(chr(10),"",str_replace(chr(13),"",$nome));
		$myforum=getparam("myforum",PAR_COOKIE,SAN_FLAT);
		if (!is_alphanumeric($nome)) die(_NONPUOI);
		if (!file_exists(get_fn_dir("users")."/$nome.php")) die(_NONPUOI."1");
		if (getlevel($myforum,"home")=="-1") die(_NONPUOI."2");
		if (!versecid($myforum)) die(_NONPUOI."2 1/2");
		if (($nome!=$myforum) and !is_admin()) die(_NONPUOI."3");
// 		if (!(getlevel($myforum,"forum")!="-1" and versecid($myforum))) die(_NONPUOI."4");
// 	die(_NONPUOI);
	}
	global $forumback,$forumborder;

	$myforum=getparam("myforum",PAR_COOKIE,SAN_FLAT);
	$nome=getparam("user",PAR_POST,SAN_FLAT);
	if(isset($_POST['regpass'])) $regpass=$_POST['regpass'];
		else $regpass="";
	if(isset($_POST['reregpass'])) $reregpass=$_POST['reregpass'];
		else $reregpass="";
	if(isset($_POST['anag'])) $anag=$_POST['anag'];
		else $anag="";
	if(isset($_POST['email'])) $email=$_POST['email'];
		else $email="";
	
	if (isset($_POST['hiddenmail']) and ereg("0|1|on",$_POST['hiddenmail'])){
		if ($_POST['hiddenmail']=="on")
			$hiddenmail = "1";
		else $hiddenmail= "0";
	}
	else $hiddenmail = "0";
	
	if(isset($_POST['homep'])) $homep=$_POST['homep'];
		else $homep="";
	if(isset($_POST['prof'])) $prof=$_POST['prof'];
		else $prof="";
	if(isset($_POST['prov'])) $prov=$_POST['prov'];
		else $prov="";
	if(isset($_POST['ava'])) $ava=$_POST['ava'];
		else $ava="";
	if(isset($_POST['url_avatar']) AND eregi("(jpg|jpeg|png|gif)",get_file_extension($_POST['url_avatar'])) )
		$url_avatar=$_POST['url_avatar'];
		else $url_avatar="images/blank.png";
	if(isset($_POST['firma'])) $firma=$_POST['firma'];
		else $firma="";
	
// 	$tmpdata = array();
// 	$tmpdata = load_user_profile($nome);
// 	$level = $tmpdata['level'];
	if(isset($_POST['level'])) $level=$_POST['level'];
		else $level="";

	$myforum=str_replace("\r","",str_replace("\n","",$myforum));
	$myforum=str_replace(chr(10),"",str_replace(chr(13),"",$myforum));
	$myforum=str_replace(".","",$myforum);
	$myforum=str_replace("/","",$myforum);
	$myforum=str_replace("\\","",$myforum);
	$regpass=str_replace("\r","",str_replace("\n","",$regpass));
	$regpass=str_replace(chr(10),"",str_replace(chr(13),"",$regpass));
	$anag=str_replace("\r","",str_replace("\n","",$anag));
	$anag=str_replace(chr(10),"",str_replace(chr(13),"",$anag));
	$nome=str_replace("\r","",str_replace("\n","",$nome));
	$nome=str_replace(chr(10),"",str_replace(chr(13),"",$nome));
	$email=str_replace("\r","",str_replace("\n","",$email));
	$email=str_replace(chr(10),"",str_replace(chr(13),"",$email));
	$homep=str_replace("\r","",str_replace("\n","",$homep));
	$homep=str_replace(chr(10),"",str_replace(chr(13),"",$homep));
	$prof=str_replace("\r","",str_replace("\n","",$prof));
	$prof=str_replace(chr(10),"",str_replace(chr(13),"",$prof));
	$prov=str_replace("\r","",str_replace("\n","",$prov));
	$prov=str_replace(chr(10),"",str_replace(chr(13),"",$prov));
	$ava=str_replace("\r","",str_replace("\n","",$ava));
	$ava=str_replace(chr(10),"",str_replace(chr(13),"",$ava));
	$url_avatar=str_replace("\r","",str_replace("\n","",$url_avatar));
	$url_avatar=str_replace(chr(10),"",str_replace(chr(13),"",$url_avatar));
	$firma=str_replace("\r","",str_replace("\n","",$firma));
	$firma=str_replace(chr(10),"",str_replace(chr(13),"",$firma));
	$level=str_replace("\r","",str_replace("\n","",$level));
	$level=str_replace(chr(10),"",str_replace(chr(13),"",$level));


	//registro limite
	if($level>10)
		$level=10;
	// io posso modificare il mio ma solo se mantengo il livello!!!
	// l'amministratore pu modificare tutti i profili
	if((($nome==$myforum) and (getlevel($nome,"home")==$level) and versecid($nome)) or ((getlevel($myforum,"home")==10) and versecid($myforum))){
	
		?><br /><br />
		<table border='0' cellspacing='0' cellpadding='0' bgcolor="<?=$forumborder?>" width="95%">
		<tbody><tr>
		<td>
		<table width='100%' border='0' cellspacing='1' cellpadding='3'>
		<tbody>
		<tr>
		<td bgcolor="<?=$forumback?>" colspan=5>
		<?
		$nome=str_replace("<","",$nome);
		$nome=str_replace(">","",$nome);
		$nome=stripslashes($nome);
		$regpass=str_replace("<","",$regpass);
		$regpass=str_replace(">","",$regpass);
		$anag=str_replace("<","",$anag);
		$anag=str_replace(">","",$anag);
		$anag=stripslashes($anag);
		$email=str_replace("<","",$email);
		$email=str_replace(">","",$email);
		$email=stripslashes($email);
		$homep=str_replace("<","",$homep);
		$homep=str_replace(">","",$homep);
		$homep=stripslashes($homep);
		$prof=str_replace("<","",$prof);
		$prof=str_replace(">","",$prof);
		$prof=stripslashes($prof);
		$prov=str_replace("<","",$prov);
		$prov=str_replace(">","",$prov);
		$prov=stripslashes($prov);
		if ($url_avatar!="images/blank.png") {
			$ava = $url_avatar;
			$ava = str_replace("<", "", $ava);
			$ava = str_replace(">", "", $ava);
		} else {
			$ava = "images/".$ava;
			$ava = str_replace("<", "", $ava);
			$ava = str_replace(">", "", $ava);
		}
		//$ava=str_replace("<","",$ava);
		//$ava=str_replace(">","",$ava);
		$firma=str_replace("<","",$firma);
		$firma=str_replace(">","",$firma);
		$firma=stripslashes($firma);
		# Mette la pass in MD5
		if(($regpass=="")){
			$tempdata = array();
			$tempdata = load_user_profile($nome);
			$regpass = $tempdata['password'];
		}
		else{
			$regpass = md5 ($regpass);
		}
		
		$firma=str_replace("\n","<br />",$firma);
		
		
		$data = array();
		$data['password'] = $regpass;
		$data['name'] = $anag;
		$data['mail'] = $email;
		$data['hiddenmail'] = $hiddenmail;
		$data['homepage'] = $homep;
		$data['work'] = $prof;
		$data['from'] = $prov;
		$data['avatar'] = $ava;
		$data['sign'] = $firma;
		$data['level'] = $level;
		
		
		save_user_profile($nome,$data);
		fnlog("Saveprofile", getparam("REMOTE_ADDR",PAR_SERVER, SAN_FLAT)."||".$myforum."||User $myforum changed his profile.");?>
		<div align="center">
		<?=_FOKMODPROF?>
		</div>
		</td>
		</tr>
		</tbody>
		</table>
		</td>
		</tr>
		</tbody>
		</table>
		<!-- automatic redirect to the message after 2 seconds -->
		<meta http-equiv="Refresh" content="1; URL=index.php?mod=none_Login&amp;action=viewprofile&amp;user=<?=$nome?>"><?
	}
}


function reguser(){
	//controllo se  possibile registrarsi sulo sito
	if (isset($_GET['reguser']) or isset($_POST['reguser']) or isset($_COOKIE['reguser'])) die(_NONPUOI);
	global $reguser,$sitename;
	if ($reguser!="1" and $reguser!="2") die(_NONPUOI);

	global $forumback,$forumborder;
	$nome=getparam("nome",PAR_POST,SAN_FLAT);
	if(!is_alphanumeric($nome)) {
		echo _FERRCAMPO."<br />";
		echo "<a href=\"javascript:history.back()\">&lt;&lt;"._INDIETRO."</a>";
		return;
	}
	if(isset($_POST['regpass'])) $regpass=$_POST['regpass'];
		else $regpass="";
	if(isset($_POST['reregpass'])) $reregpass=$_POST['reregpass'];
		else $reregpass="";
	if(isset($_POST['anag'])) $anag=$_POST['anag'];
		else $anag="";
	if(isset($_POST['email'])) $email=$_POST['email'];
		else $email="";
	if(isset($_POST['homep'])) $homep=$_POST['homep'];
		else $homep="";
	if(isset($_POST['prof'])) $prof=$_POST['prof'];
		else $prof="";
	if(isset($_POST['prov'])) $prov=$_POST['prov'];
		else $prov="";
	if(isset($_POST['ava'])) $ava=$_POST['ava'];
		else $ava="";
	if(isset($_POST['url_avatar']) AND eregi("(jpg|jpeg|png|gif)",get_file_extension($_POST['url_avatar'])) )
		$url_avatar=$_POST['url_avatar'];
		else $url_avatar="images/blank.png";
	if(isset($_POST['firma'])) $firma=$_POST['firma'];
		else $firma="";
	
	if (isset($_POST['hiddenmail']) and ereg("1|on",trim($_POST['hiddenmail']))){
		$hiddenmail = "1";
	}
	else $hiddenmail="0";
	
	$nome=str_replace("\r","",str_replace("\n","",$nome));
	$nome=str_replace(chr(10),"",str_replace(chr(13),"",$nome));
	$nome=str_replace(".","",$nome);
	$nome=str_replace("/","",$nome);
	$nome=str_replace("\\","",$nome);

	$regpass=str_replace("\r","",str_replace("\n","",$regpass));
	$regpass=str_replace(chr(10),"",str_replace(chr(13),"",$regpass));

	$reregpass=str_replace("\r","",str_replace("\n","",$reregpass));
	$reregpass=str_replace(chr(10),"",str_replace(chr(13),"",$reregpass));

	$anag=str_replace("\r","",str_replace("\n","",$anag));
	$anag=str_replace(chr(10),"",str_replace(chr(13),"",$anag));

	$email=str_replace("\r","",str_replace("\n","",$email));
	$email=str_replace(chr(10),"",str_replace(chr(13),"",$email));

	$homep=str_replace("\r","",str_replace("\n","",$homep));
	$homep=str_replace(chr(10),"",str_replace(chr(13),"",$homep));

	$prof=str_replace("\r","",str_replace("\n","",$prof));
	$prof=str_replace(chr(10),"",str_replace(chr(13),"",$prof));

	$prov=str_replace("\r","",str_replace("\n","",$prov));
	$prov=str_replace(chr(10),"",str_replace(chr(13),"",$prov));

	$ava=str_replace("\r","",str_replace("\n","",$ava));
	$ava=str_replace(chr(10),"",str_replace(chr(13),"",$ava));

	$url_avatar=str_replace("\r","",str_replace("\n","",$url_avatar));
	$url_avatar=str_replace(chr(10),"",str_replace(chr(13),"",$url_avatar));

	$firma=str_replace("\r","",str_replace("\n","",$firma));
	$firma=str_replace(chr(10),"",str_replace(chr(13),"",$firma));

	?>
	<br /><br />
	<table border='0' cellspacing='0' cellpadding='0' bgcolor='<?=$forumborder?>' width="95%">
	<tbody><tr>
	<td>
	<table width='100%' border='0' cellspacing='1' cellpadding='3'>
	<tbody>
	<tr>
	<td bgcolor="<?=$forumback?>" colspan=5>
	<?
	if(!file_exists(get_fn_dir("users")."/$nome.php") and !file_exists(get_waiting_users_dir()."/$nome.php")){
		if(($nome=="") OR ($regpass=="") OR (stristr($nome," ")) OR (strlen($nome)>13) OR (stristr($nome,"\"")) OR (stristr($nome,"\\")) OR ($regpass != $reregpass) or !is_alphanumeric($nome)){
			print _FERRCAMPO."<br />
		<a href=\"javascript:history.back()\">&lt;&lt;"._INDIETRO."</a>";
		}
		else{
			// installing profile
			if(file_exists("misc/firstinstall")) {
				if(count(list_users())==0) {
					$level=10;
				}
				else $level=0;
				unlink("misc/firstinstall");
			}
			else {
				$level=0;
			}

			$nome=str_replace("<","",$nome);
			$nome=str_replace(">","",$nome);
			$nome=stripslashes($nome);
			$regpass=str_replace("<","",$regpass);
			$regpass=str_replace(">","",$regpass);
			$anag=str_replace(">","",$anag);
			$anag=str_replace("<","",$anag);
			$anag=stripslashes($anag);
			$email=str_replace("<","",$email);
			$email=str_replace(">","",$email);
			$email=stripslashes($email);
			$homep=str_replace("<","",$homep);
			$homep=str_replace(">","",$homep);
			$homep=stripslashes($homep);
			$prof=str_replace("<","",$prof);
			$prof=str_replace(">","",$prof);
			$prof=stripslashes($prof);
			$prov=str_replace("<","",$prov);
			$prov=str_replace(">","",$prov);
			$prov=stripslashes($prov);
			$ava=str_replace("<","",$ava);
			$ava=str_replace(">","",$ava);
			if ($ava=="")
				$ava="blank.png";
			if ($url_avatar!="images/blank.png") {
				$ava = $url_avatar;
				$ava = str_replace("<", "", $ava);
				$ava = str_replace(">", "", $ava);
			}
			else {
				$ava = str_replace("<", "", $ava);
				$ava = str_replace(">", "", $ava);
				$ava = "images/".$ava;
			}
			$firma=str_replace("<","",$firma);
			$firma=str_replace(">","",$firma);
			$firma=stripslashes($firma);
			# Mette la password in MD5
			$pass = "";
			$pass = $regpass;
			$regpass = md5 ($regpass);
			$firma=str_replace("\n","<br />",$firma);

			
			$data = array();
			$data['password'] = $regpass;
			$data['name'] = $anag;
			$data['mail'] = $email;
			$data['hiddenmail'] = $hiddenmail;
			$data['homepage'] = $homep;
			$data['work'] = $prof;
			$data['from'] = $prov;
			$data['avatar'] = $ava;
			$data['sign'] = $firma;
			$data['level'] = $level;
			$data['regmail'] = $email;

			if ($reguser==2){
				
				//controllo che la mail non sia gi stata usata per la registrazione di un altro utente
				if (in_array($email,list_reg_emails()) or in_array($email,list_reg_emails(1))){
					echo "<div style=\"text-align: center;\">"._THEMAIL." $email "._MAILUSED;
					echo "<br /><br /><a href=\"javascript:history.back()\">&lt;&lt;"._INDIETRO."</a></div>";
					die();
				}
				
				//genero il codice di attivazione
				$data['regcode'] = mt_rand(1,99999999);
				//devo controllare la validit della mail
				//se non  valida interrompo e permetto di tornare indietro
				if (!check_mail($email)){
					echo "<div style=\"text-align: center;\"><b>"._ERREMAIL."!</b>";
					echo "<br /><br /><a href=\"javascript:history.back();\">&lt;&lt; "._INDIETRO."</a></div>";
					die();
				}
				
				//se l'e-mail  spammosa blocco tutto!
				if (is_spam($email,"emails")){
					echo "<b>"._ERREMAIL."</b> ("._ISSPAM.")";
					$addr = getparam("REMOTE_ADDR",PAR_SERVER, SAN_FLAT);
					fnlog("Registration","$addr||Failed registration with mail: \"".strip_tags($email)."\"");
					die();
				}
				
			}
			
			if ($reguser=="2") save_user_profile($nome,$data,1);
			else save_user_profile($nome,$data);

			$addr=getparam("REMOTE_ADDR",PAR_SERVER, SAN_FLAT);
			$myforum=getparam("myforum",PAR_COOKIE,SAN_FLAT);

			fnlog("Registration", $addr."||".$myforum."||New registered user $nome.");
			echo "<div align=\"center\">";
			if ($reguser==2){
				//stampo il link di attivazione a schermo (solo in fase di scrittura del codice)
				$url = "http://".$_SERVER['SERVER_NAME']."/".$_SERVER['SCRIPT_NAME']."?mod=none_Login&action=activateuser&user=$nome&regcode=".$data['regcode'];
// 				echo "<br /><br />$url";
				
				$message = _IST_REG_MAIL."\n\n$url";
				
				if (mail($email, _COMP_REG_MAIL." $sitename", $message,"FROM: $sitename <noreply@noreply>\n")){
					echo _COMP_REG." <b>$email</b>";
					echo "<br />"._COMP_REG2;
				}
				else {
					echo _ACTIVATIONMAILNOTSENT;
					fnlog("Registration", $addr."||".$myforum."||Activation mail not sent for $nome.");
				}
				
				
			}
			else echo _FORAREG;
			?><br />
			<a href="index.php?mod=none_Login">&lt;&lt;<?=_LOGIN?></a></div><?
		}
	}
	else{
		?><?=_FUSERSCE?><br /><a href="index.php?mod=none_Login&amp;action=visreg">&lt;&lt;<?=_INDIETRO?></a><?
	}
	?>
	</td>
	</tr>
	</tbody>
	</table>
	</td>
	</tr>
	</tbody>
	</table><?
}


/**
 * Eliminazione di un profilo utente
 *
 * Permette di eliminare, dopo i necessari controlli sulle
 * autorizzazioni a farlo, il profilo utente selezionato.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 * @author Marco Segato <segatom@users.sourceforge.net> | 20070317: ready to 2.5.9
 *
 * @param string $user Profilo utente da eliminare
 */
function delete_user($user=""){
	// security checks
	$myforum = getparam("myforum",PAR_COOKIE,SAN_FLAT);
	$user    = getparam("user", PAR_GET, SAN_FLAT);
	$addr    = getparam("REMOTE_ADDR",PAR_SERVER, SAN_FLAT);
	// who can delete my account? admins or myself ;)
	if( is_admin() OR (is_user() AND $user==$myforum) ) {
		// check if profile exists
		if(file_exists(get_fn_dir("users")."/".$user.".php") AND is_alphanumeric($user)) {
			unlink(get_fn_dir("users")."/".$user.".php");
			fnlog("Deleteuser", $addr."||".$myforum."||User ".$user." deleted.");
		} else {
			fnlog("Deleteuser", $addr."||".$myforum."||Tried to delete non-existant ".$user." profile.");
		}
		// if I delete my own account, clear cookies
		if($user==$myforum){
			logout();
		}
	}
	// unauthorized tries
	else {
		fnlog("Deleteuser", $addr."||".$myforum."||Tried to delete ".$user." profile.");
	}
	// back to login section
	?><script language="javascript">window.location='index.php?mod=none_Login';</script><?
}


/**
 * Esegue il logout da Flatnuke
 *
 * Esegue il logout dal portale Flatnuke e cancella tutti i
 * cookies contenenti le informazioni di autenticazione.
 *
 * @author Simone Vellei <simone_vellei@users.sourceforge.net>
 * @author Marco Segato <segatom@users.sourceforge.net> | 20070317: ready to 2.5.9
 */
function logout(){
	// security checks
	$myforum = getparam("myforum",PAR_COOKIE,SAN_FLAT);
	$addr    = getparam("REMOTE_ADDR",PAR_SERVER, SAN_FLAT);
	$url     = getparam("PHP_SELF",PAR_SERVER, SAN_FLAT);
	// rebuild path for cookies
	$path = pathinfo($url);
	$url  = str_replace("/forum","",$path["dirname"]);
	if($url=="")
		$url="/";
	// set cookies to null
	setcookie("secid","",NULL,"$url");
	setcookie("myforum","",NULL,"$url");
	fnlog("Logout", $addr."||".$myforum."||User $myforum logout.");
	// go back
	?><script language="javascript">window.location='<?=getparam("HTTP_REFERER", PAR_SERVER, SAN_FLAT)?>';</script><?
}


/**
 * Questa funzione mostra l'interfaccia per modificare o creare un profilo utente
 * 
 * @author Aldo Boccacci
 * @since 2.6.2
 */
function edit_user_interface($user,$action){
	if (!is_alphanumeric($user) and $user!="") die(_NONPUOI);
	if (!eregi("edit|reguser",trim($action)))
		die();
	$profile = array();
	$profile = load_user_profile($user);
	
	global $reguser;
	
	?><form action="index.php?mod=none_Login" method="post" name="<?
	
	if ($action=="edit") echo "registra";
	else if ($action=="reguser") echo "reguser";
	
	?>">
		<fieldset>
		<legend><?
		
		if ($action=="edit") echo _FMODPROFTIT." $user";
		else if ($action=="reguser") echo _FREG." "._FCAMPI;
		
		?></legend><?
		
		if ($action=="edit"){
			echo "<input type=\"hidden\" name=\"action\" value=\"saveprofile\" />
			<input type=\"hidden\" name=\"user\" value=\"$user\" />";
		}
		else if ($action=="reguser"){
			echo "<input type=\"hidden\" name=\"action\" value=\"reguser\" />";
		}
		
		$style1 = "font-style:bold; padding:0.2em;";
		$style2 = "padding:0.2em;";
		?>
		<br />
		<table width='70%' align='center' border='1' style="border-collapse:collapse">
		<tbody>
		<?
		if ($action=="edit"){?>
		<tr>
		<td width="30%" style="<?=$style1?>"><label for="regpass"><?=_PASSWORD?><br />(<?=_FDIVERS?>)</label></td>
		<td style="<?=$style2?>"><input name="regpass" type="password" id="regpass" value="" /></td>
		</tr>
		<?
		}//fine $action==edit
		else if ($action=="reguser"){
		?>
		<tr><td>
		<label for="nome"><b><span>*</span> <?=_NOMEUTENTE?></b></label></td><td><input name="nome" type="text" id="nome"/></td></tr>
	<tr><td><label for="regpass"><b><span>*</span> <?=_PASSWORD?></b></label></td><td><input name="regpass" type="password" id="regpass" /></td></tr>
	<tr><td><label for="reregpass"><b><span>*</span> <?=_PASSWORD?></b></label></td><td> <input name="reregpass" type="password" id="reregpass" /></td>
		</tr>
		<?
		}//fine $action=="reguser"
		?>
		<tr>
		<td style="<?=$style1?>"><label for="anag"><?=_FNOME?></label></td>
		<td style="<?=$style2?>"><input name="anag" type="text" id="anag" value="<?=$profile['name']?>" /></td>
		</tr>
		<tr>
		<td style="<?=$style1?>"><label for="email"><?
		
		if ($reguser=="2" and $action=="reguser") echo "<span>*</span>&nbsp;<b>";
		echo _FEMAIL;
		if ($reguser=="2" and $action=="reguser") echo "</b>";
		
		?></label></td>
		<td style="<?=$style2?>"><input name="email" type="text" id="email" value="<?=$profile['mail']?>" /></td>
		</tr>
		<tr>
		<td style="<?=$style1?>"><label for="hiddenmail"><?=_HIDDENMAIL?></label></td>
		<td style="<?=$style2?>"><input name="hiddenmail" type="checkbox" id="hiddenmail"<?
		
		if ($profile['hiddenmail']=="1") echo "checked=\"checked\"";

		?>/></td>
		</tr>
		<tr>
		<td style="<?=$style1?>"><label for="homep"><?=_FHOME?></label></td>
		<td style="<?=$style2?>"><input name="homep" type="text" id="homep" value="<?=$profile['homepage']?>" /></td>
		</tr>
		<tr>
		<td style="<?=$style1?>"><label for="prof"><?=_FPROFES?></label></td>
		<td style="<?=$style2?>"><input name="prof" type="text" id="prof" value="<?=$profile['work']?>" /></td>
		</tr>
		<tr>
		<td style="<?=$style1?>"><label for="prov"><?=_FPROV?></label></td>
		<td style="<?=$style2?>"><input name="prov" type="text" id="prov" value="<?=$profile['from']?>" /></td>
		</tr>
		<tr>
		<td style="<?=$style1?>"><label for="ava"><?=_FAVAT?></label></td>
		<td style="<?=$style2?>"><?
			// set path for local/remote images
			$img_dir = "";
			if(strstr($profile['avatar'],"images/")) {
				$img_dir = "forum/";
			}
			?><img name="avatar" src="<?
			
			if ($action=="edit") echo $img_dir.$profile['avatar'];
			else if ($action=="reguser") echo "forum/images/blank.png";
			
			
			?>" alt="avatar" border="0" style="max-width:120px;" id="avatar" />
			<br />
			<select name="ava" onchange='document.avatar.src="forum/images/"+this.options[this.selectedIndex].value'>
			<option value="">----</option><?
			$modlist = array();
			$handle = opendir('forum/images');
			while ($file = readdir($handle)) {
				if (!( $file=="." or $file==".." )) {
					array_push($modlist, $file);
				}
			}
			closedir($handle);
			if(count($modlist)>0)
				sort($modlist);
			for ($i=0; $i < sizeof($modlist); $i++) {
				echo "<option value=\"$modlist[$i]\" ";
				if(str_replace("images/","",$profile['avatar'])==$modlist[$i])
					echo "selected=\"selected\"";
				echo ">$modlist[$i]</option>\n";
			}
			?></select><br /><br />
			<?=_FAVATREM?>:<br /><?
			if(strstr($profile['avatar'],"http://")){
				echo "<input type=\"text\" name=\"url_avatar\" value=".$profile['avatar']." />";
			}
			else {
				echo "<input type=\"text\" name=\"url_avatar\" />";
			}
			?>
		</td>
		</tr>
		<tr>
		<td style="<?=$style1?>"><label for="firma"><?=_FFIRMA?></label></td><?
		$profile['sign'] = str_replace("<br />","\n",$profile['sign']);
		$profile['sign'] = chop($profile['sign']);
		?><td style="<?=$style2?>"><textarea name="firma" id="firma" rows="5" cols="23"><?=stripslashes($profile['sign']);?></textarea></td>
		</tr>
		<tr>
		<? // admins can manage user level
		if(is_admin()){
			?><td style="<?=$style1?>"><label for="level"><?=_LEVEL?></label></td>
			<td style="<?=$style2?>">
			<select name="level" id="level"><?
				for($i=0; $i<11; $i++){
					if($profile['level']==$i)
						echo "<option value=\"$i\" selected=\"selected\">$i</option>";
					else echo "<option value=\"$i\">$i</option>";
				}
			?></select>
			</td><?
		} else {
		
			if ($action=="edit") echo "<td><input id=\"level\" name=\"level\" value=\"".$profile['level']."\" type=\"hidden\" /></td>";
			else echo "<td>&nbsp;</td>";
		
		}
		?></tr>
		</tbody>
		</table><?
		if($action=="reguser") {
			echo "<div style='font-family:monospace;text-align:justify;padding:1em;'>"._REG_AGREEMENT_TERMS."</div>";
		}
		?><div style="text-align:center;padding:0.5em;"><input type="submit" value="<?=_FINVIA?>" /></div>
		</fieldset>
		</form><?
}


/**
 * Attiva l'utente specificato
 * 
 * @param string $user l'utente da attivare
 * @param string $regcode il codice di attivazione da fornire
 * @since 2.6.2
 * @author Aldo Boccacci
 */
function activate_user($user,$regcode){
	$user = getparam($user,PAR_NULL,SAN_FLAT);
	$regcode = getparam($regcode,PAR_NULL,SAN_FLAT);
	$addr    = getparam("REMOTE_ADDR",PAR_SERVER, SAN_FLAT);
	if (!is_alphanumeric($user)) die("Username must be alphanumeric!");
	if (!check_var($regcode,"digit")) die("regcode must be a digit!");
	
	if (file_exists(get_waiting_users_dir()."/$user.php")){
		$userdata = array();
		$userdata = load_user_profile($user,1);

		if (trim($regcode)==trim($userdata['regcode'])){
			if (rename(get_waiting_users_dir()."/$user.php",get_fn_dir('users')."/$user.php")){
				echo "<div style=\"text-align: center;\">"._FORAREG;
				?><br />
				<a href="index.php?mod=none_Login">&lt;&lt;<?=_LOGIN?></a></div><?
				fnlog("Registration","$addr||".get_username()."||User $user succesfully activate the profile");
			}
			else {
				fnlog("Registration","$addr||".get_username()."||It was impossible to rename the profile of the user $user");
			}
		}
		else {
			echo "Reg code is not valid!";
			fnlog("Registration","$addr||".get_username()."||Regcode of the user $user is not matching");
			die();
		}
	}
	else {
		fnlog("Registration","$addr||".get_username()."||The user $user isn't in the waiting list!");
		die("The user $user isn't in the waiting list!");
	}
}

?>