<?

/************************************************************************/
/* FlatNuke - Flat Text Based Content Management System                 */
/* ============================================                         */
/*                                                                      */
/* Copyright (c) 2003-2004 by Simone Vellei                             */
/* http://flatnuke.sourceforge.net                                      */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/


if (eregi("section.php",$_SERVER['PHP_SELF'])) {
	chdir("../../");
	include_once("functions.php");
	include_once("config.php");
	include_once("languages/$lang.php");
}

//configurazione
//la cartella contenente i plugins
$search_plugins_dir= "include/search/";
//la lunghezza massima della stringa di ricerca
$search_string_limit = "35";

$GLOBALS['search_plugins_dir'] =$search_plugins_dir;
$GLOBALS['search_string_limit'] =$search_string_limit;

// Security convertions
$find = getparam("find",PAR_POST,SAN_FLAT);
$where = getparam("where",PAR_POST,SAN_FLAT);
$findget = getparam("find",PAR_GET,SAN_FLAT);
$whereget = getparam("where",PAR_GET,SAN_FLAT);

if (strlen($find)>$search_string_limit){
	echo "<b>The search string is too long!</b>";
	fnlog("Search","search string \"$find\" too long");
	return;
}
if (strlen($findget)>$search_string_limit){
	echo "<b>The search string is too long!</b>";
	fnlog("Search","search string \"$findget\" too long");
	return;
}

if (trim($findget)!=""){
	if ($whereget=="news"){
		Argument_search($whereget, $findget);
		return;
	}
}

if (trim($find)=="") {
	view_search_interface();
	return;
}
else if ($where=="allsite"){
	foreach (glob("$search_plugins_dir/*.php") as $plugin){
		if (eregi("^none_",basename($plugin))) continue;
		include_once($plugin);
	}
}
else if (trim($where)!=""){
	if (file_exists("$search_plugins_dir/$where.php")){

		include_once("$search_plugins_dir/$where.php");
		return;
	}
	else {
		view_search_interface();
	}
}
else {
	view_search_interface();
}


/**
 * Mostra l'interfaccia utente per compiere ricerche
 * @author Aldo Boccacci
 * @since 2.5.8
 */
function view_search_interface(){
	?><br /><br />
	<div align="center"><? 
	if(file_exists("include/javascripts/ahah.js")) {
		echo "<form id=\"search_section\" action=\"javascript:completeAHAH.likeSubmit('sections/none_Search/section.php','post','search_section','search_results');\">";
	} else {
		echo "<form action=\"index.php?mod=none_Search\" method=\"post\">";
	}
	?><input type="hidden" name="mod" value="none_Search" />
	<label for="textsect" ><? echo _CERCA;?>:</label>
	<input type="text" name="find" size="16" id="textsect" /><br /><br />
	<label for="wheresect"><? echo _CERCASTR; ?></label>
	<select name="where" id="wheresect">
	<option value="allsite" selected="selected"><? echo _ALLSITE; ?></option>
	<?
	global $search_plugins_dir;
		$plugin="";
		$pathstring="";
		foreach (glob("$search_plugins_dir/*.php") as $plugin){
			$plugin_name ="";
			$plugin_name = eregi_replace("\.php$","",basename($plugin));
			if (eregi("^none_",$plugin_name)) continue;
			echo "<option value=\"$plugin_name\">".eregi_replace("^[0-9][0-9]_","",$plugin_name)."</option>\n";
		}
	//gestisci plugins
	?>
	</select><br /><br /><? echo $pathstring; ?>
	<input type="radio" value="AND" id="AND" name="method" alt="AND search" checked="checked" /><label for="AND">AND</label>
	<input type="radio" value="OR" id="OR" name="method" alt="OR search" /><label for="OR">OR</label>
	<br /><br />
	<input type="submit" value="<?=_CERCA?>" />
	</form>
	</div>
	<div id="search_results"></div><?
}


/**
 * Cerca $pattern nella stringa $string secondo il metodo $method.
 * Questa funzione  pensata per essere usata dai vari plugin
 * @param string $pattern la stringa da cercare
 * @param string $string la stringa in cui cercare
 * @param string $method il metodo di ricerca. Pu essere "OR" oppure "AND"
 * @return TRUE se pattern viene trovato, FALSE in caso contrario
 * @author Aldo Boccacci
 * @since 2.5.8
 */
function fn_search_string($pattern, $string,$method="AND"){
	$pattern=getparam($pattern,PAR_NULL,SAN_FLAT);
	$string=getparam($string,PAR_NULL,SAN_FLAT);
	if (!eregi("AND|OR",$method)) $method="AND";
	$results = array();
	$tokens = explode(" ", $pattern);
	foreach ($tokens as $token){
		if (trim($token)=="") continue;
		if (eregi(quotemeta($token),$string)) $results[]="true";
		else $results[]="false";
	}

	if ($method=="AND"){
		if (in_array("false",$results)) return FALSE;
		else return TRUE;
	}
	else if ($method=="OR"){
		if (in_array("true",$results)) return TRUE;
		else return FALSE;
	}
}

?>