/*
 *										
 *		File		: imaplib.c					
 *										
 *		Title		: Flink email monitoring applet for GNOME 2	
 *										
 *		Description	: Routines for checking IMAPv4 boxes		
 *									
 *		Authors		: Marcus Leyman, 2002 <marcus@leyman.nu>	
 *										
 *		License		: GPL						
 *										
 *		Date		: 27 May 2002					
 *										
 */
 
#include <sys/socket.h>
#include <sys/types.h>
#include <string.h>
#include <unistd.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <stdlib.h>

#include "main.h"
#include "imaplib.h"

/********************************************************
 * Function:	flink_imap_get_mail			*
 *							*
 * Description:	connects and checks for mail in imap	*
 *							*
 * Arguments:	gpointer data, Account to check		*
 *							*
 * Returns:	gpointer to int of message count	*
 ********************************************************/
gint
flink_imap_get_mail	(gpointer data)
{
  GConfClient           *client;
  Account		*acc = (Account *) data;
  gint			msgs = 0;
  gint                  old_msgs = 0;
  gint			sd;
	
  client = gconf_client_get_default();
        
  sd = flink_imap_connect(acc->hostname, acc->port);
	
  if (sd < 0) {
    msgs = -1;
  } else {
    if (flink_imap_login (sd, acc->username, acc->password)) {
      msgs = flink_imap_stat (sd, acc->folder);
    } else {
      msgs = -2;
    }	
  }
  /*
  old_msgs = gconf_client_get_int(client, g_strdup_printf("/apps/flink/accounts/%d_newmail", acc->id), NULL);
        
  gconf_client_set_int(client, g_strdup_printf("/apps/flink/accounts/%d_newmail", acc->id), msgs, NULL);

  if (old_msgs < msgs)
    flink_bell();
  */
  return msgs;
}

/********************************************************
 * Function:	flink_imap_connect			*
 *							*
 * Description:	connects to imap server			*
 *							*
 * Arguments:	gchar *host, hostname of server		*
 *		gint port, port to connect to		*
 *							*
 * Returns:	filehandle if positive, error if neg.	*
 ********************************************************/
gint
flink_imap_connect	(gchar *host, 
			gint port)
{
  struct 		sockaddr_in server;
  struct 		hostent *hent;
  gchar 		response[513];
  gint 		len;
  gint		sd;
	
  if (!host)
    return -1;
		
  hent = gethostbyname (host);
	
  if (!hent)
    return -1;

  memset (&server, 0, sizeof(server));
  server.sin_family = AF_INET;
  memcpy (&(server.sin_addr.s_addr), hent->h_addr,
	  sizeof(server.sin_addr.s_addr));
	
  server.sin_port = htons (port);
	
  sd = socket (PF_INET, SOCK_STREAM, 0);
	
  if (sd < 0)
    return -1;
	
  if (connect (sd, (struct sockaddr *) &server, sizeof(server)) < 0) {
    close (sd);
    return -1;
  }

  len = read (sd, response, 512);
  response[len] = '\0';

  if (strncmp (response, "* OK", 3)) {
    close (sd);
    return -1;
  } 

  return sd;
}	

/********************************************************
 * Function:	flink_imap_login			*
 *							*
 * Description:	Logs in to imapserver			*
 *							*
 * Arguments:	gint sd, filehandle			*
 *		gchar *user, username			*
 *		gchar *pass, password			*
 *							*
 * Returns:	TRUE if successfull, FALSE else		*
 ********************************************************/
gboolean
flink_imap_login	(gint sd, 
			gchar *user, 
			gchar *pass)
{
  static gchar cmdline[100];  
  static gchar response[513];
  static gint len;

  if (!user || !pass) {
    close (sd);
    return FALSE;
  }
		
  g_snprintf (cmdline, 100, "a001 LOGIN %s %s\r\n", user, pass);

  write (sd, cmdline, strlen(cmdline));

  len = read (sd, response, 512);
  response[len] = '\0';

  if (strncmp (response, "a001 OK", 7)) {
    close (sd);
    return FALSE;
  }
  return TRUE;
}

/********************************************************
 * Function:	flink_imap_stat				*
 *							*
 * Description:	Checks folder in imapserver for unread 	*
 *		mail					*
 *							*
 * Arguments:	gint sd, filehandle			*
 *		gchar *folder, folder to check		*
 *							*
 * Returns:	if positive number of mail, else error	*
 ********************************************************/
gint 
flink_imap_stat	(gint sd, 
		gchar *folder)
{
  gchar cmdline[100];
  gchar response[513];
  gchar *responsetmp;
  gint len;
  gint msgs;

  if (!folder) {
    write (sd, "a002 LOGOUT\r\n", strlen ("a002 LOGOUT\r\n"));
    close (sd);
    return -6;
  }

  g_snprintf (cmdline, 100, "a002 STATUS %s (UNSEEN MESSAGES)\r\n", folder);
  write (sd, cmdline, strlen(cmdline));
  len = read (sd, response, 512);
  response[len] = '\0';

  write (sd, "a003 LOGOUT\r\n", strlen ("a003 LOGOUT\r\n"));
  close (sd);
	
  if (g_strrstr(response, "failed")) {
    return -6;
  }
	
  if (responsetmp = g_strrstr(response, "UNSEEN")) {
    sscanf(responsetmp, "UNSEEN %d", &msgs);
  } else {
    msgs = 0;
  }
		
  return msgs;
}
