/*
 *									        
 *		File		: mail.c					
 *									        
 *		Title	    	: Flink email monitoring applet for GNOME 2	
 *										
 *		Description	: Base file for mailroutines		        
 *									        
 *		Authors		: Marcus Leyman, 2002 <marcus@leyman.nu>        
 *										
 *		License		: GPL						
 *									        
 *		Date		: 27 May 2002					
 *										
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <panel-applet.h>
#include <panel-applet-gconf.h>
#include <gconf/gconf-client.h>

#include "interface.h"
#include "support.h"
#include "configuration.h"

#include "mboxlib.h"
#include "poplib.h"
#include "imaplib.h"

/* public thread-pool */
GThreadPool	*thread_pool;

/********************************************************
 * Function:	flink_mail_set_total_key		*
 *							*
 * Description:	reads all accounts and sets total_mail	*
 *							*
 * Arguments:	none					*
 *							*	
 * Returns:	nothing					*
 ********************************************************/
void
flink_mail_set_total_key	()
{
  GConfClient	*client;
  GSList		*name_list;
  gint		total_key = 0;
  gint		accounts = 0;
  gint		current = 0;
  gint		current_key = 0;
	
  client = gconf_client_get_default();
					  
  accounts = gconf_client_get_int(client,
				  "/apps/flink/accounts/accounts",
				  NULL);

  for (current = 1; current <= accounts; current++) {
    current_key = gconf_client_get_int (client,
					g_strdup_printf("/apps/flink/accounts/%d_newmail", current),
					NULL);
    if (current_key > -1)
      total_key += current_key;	
  }
		
  gconf_client_set_int(client,
		       "/apps/flink/general/total_mail",
		       total_key,
		       NULL);
}

/********************************************************
 * Function:	flink_get_mail				*
 *							*
 * Description:	executes account-type specific funcions	*
 *							*
 * Arguments:	gpointer data, account id		*
 *		gpointer user_data, NULL       		*	
 *							*
 * Returns:	nothing					*
 ********************************************************/

void
flink_get_mail	(gpointer data,
		 gpointer user_data)
{
  gint 		id = (gint) data;
  Account 	*acc;
  GConfClient	*client;
  gint		msgs, old_msgs;

  acc = g_new0(Account, 1);
  
  client = gconf_client_get_default();

  acc = flink_config_get_account_from_path(g_strdup_printf("/apps/flink/accounts/%d", id));

  switch(acc->type) {
  case 1:
    msgs = flink_pop_get_mail((gpointer) acc);
    break;
  case 2:
    msgs = flink_imap_get_mail((gpointer) acc);
    break;
  case 3:
    msgs = flink_mbox_get_mail((gpointer) acc);
    break;
  default:
    break;
  }
    
  old_msgs = gconf_client_get_int(client, g_strdup_printf("/apps/flink/accounts/%d_newmail", acc->id), NULL);    
  gconf_client_set_int(client, g_strdup_printf("/apps/flink/accounts/%d_newmail", acc->id), msgs, NULL);

  if(old_msgs < msgs)
    flink_bell();
    
  g_free(acc);
}  

/********************************************************
 * Function:	flink_mail_check_account		*
 *							*
 * Description:	checks account from name		*
 *							*
 * Arguments:	GtkWidget *w,				*
 *		gpointer somethingelse, humpf?		*
 *		gpointer data, name of acc to check	*
 *							*
 * Returns:	nothing					*
 ********************************************************/
void
flink_mail_check_account (GtkWidget *w,
			  gpointer somethingelse,
			  gpointer data)
{
  GConfClient	*client;
  gint		id = (gint) data;

  client = gconf_client_get_default();

  if(!thread_pool) {
    thread_pool = g_thread_pool_new(flink_get_mail,
				    NULL,
				    1,
				    FALSE,
				    NULL);
    gconf_client_set_string(client, "/apps/flink/debug", "starting thread_pool", NULL);
  }
 
  g_thread_pool_push(thread_pool,
		     (gpointer) id,
		     NULL);
}	

/********************************************************
 * Function:	flink_mail_check_all_accounts		*
 *							*
 * Description:	checks all accounts			*
 *							*
 * Arguments:	GtkWidget *w,				*
 *		gpointer somethingelse, humpf?		*
 *		gpointer data,				*
 *							*
 * Returns:	nothing					*
 ********************************************************/
void
flink_mail_check_all_accounts	(GtkWidget *w,
				 gpointer somethingelse,
				 gpointer data)
{
  GConfClient		*client;
  GSList		*acc_list;
  gint			accounts;
  gint			current;
	
  client = gconf_client_get_default ();
  accounts = gconf_client_get_int(client,
				  "/apps/flink/accounts/accounts",
				  NULL);

  for (current = 1; current <= accounts; current++) {
    flink_mail_check_account(NULL, NULL, (gpointer) current);
  }
}
