#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999
# All Rights Reserved.
#
# The software contained on this media is the property of the
# DSTC Pty Ltd.  Use of this software is strictly in accordance
# with the license agreement in the accompanying LICENSE.DOC file.
# If your distribution of this software does not contain a
# LICENSE.DOC file then you have no rights to use this software
# in any manner and should contact DSTC at the address below
# to determine an appropriate licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, Gehrmann Labs
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of
# any kind.  In no event shall DSTC Pty Ltd be liable for
# damage of any kind arising out of or in connection with
# the use or performance of this software.
#
# Project:      Distributed Environment
# File:         $Source: /cvsroot/fnorb/fnorb/orb/ThreadSpecificData.py,v $
#
#############################################################################
""" A class for thread-specific data. """


# Fnorb modules.
import fnorb_thread


class ThreadSpecificData:
    """ A thread-safe dictionary class. """

    def __init__(self):

	self.__lk = fnorb_thread.allocate_lock()
	self.__data = {}

	return

    def get(self):
	""" Get the value for the current thread. """

	self.__lk.acquire()
	try:
	    value = self.__data[fnorb_thread.get_ident()]

	finally:
	    self.__lk.release()

	return value

    def set(self, value):
	""" Set the value for the current thread. """

	self.__lk.acquire()
	try:
	    self.__data[fnorb_thread.get_ident()] = value

	finally:
	    self.__lk.release()

	return

#############################################################################
