#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Fnorb
# File:         $Source: /cvsroot/fnorb/fnorb/script/fnping.py,v $
# Version:      @(#)$RCSfile: fnping.py,v $ $Revision: 1.1 $
#
#############################################################################
""" Read a UOL from stdin and 'ping' the object. """


# Standard/built-in modules.
import sys, time

# Fnorb modules.
from Fnorb.orb import CORBA


def main(argv):
    """ Do it! """

    # fixme: This a hack to remove the spurious last argument ('\n') on
    # Windows 95.
    if argv[-1] == '\n':
	del argv[-1]

    if len(argv) == 1:
	# Read a UOL from stdin.
	uol = sys.stdin.read()

    elif len(argv) == 2:
	# Read a stringified IOR from the command line.
	uol = argv[1]

    elif len(argv) == 3 and argv[1] == '-f':
	# Read a stringified IOR from a file.
	uol = open(argv[2]).read()

    else:
	print 'Usage: fnping [-f file | UOL]'
	return 1

    # Ping!
    object = CORBA.ORB_init().string_to_object(uol)

    print 'FNPING',
    print '%s:%d' % (object._fnorb_host(), object._fnorb_port()),
    print object._fnorb_object_key()

    try:
	while 1:
	    start = time.clock()
	    object._is_a('IDL:omg.org/CORBA/Object:1.0')
	    end = time.clock()

	    print 'Reply from',
	    print '%s:%d' % (object._fnorb_host(), object._fnorb_port()),
	    print object._fnorb_object_key(),
	    print 'time=', int((end - start) * 1000), 'ms'

	    time.sleep(1)

    except CORBA.SystemException, ex:
	print ex.__class__.__name__, ex

    return 0

#############################################################################

if __name__ == '__main__':
    # Do it!
    try:
	sys.exit(main(sys.argv))

    except KeyboardInterrupt:
	pass

#############################################################################
