#!/usr/bin/env python

# Free Open FTP Face (C)2006 Jeffrey Bakker
#
# FOFF is a graphical FTP client written in pyGTK.

# FOFF is compact, multiplatform (any system that supports GTK+ and python),
# has a simple and friendly interface, and has built-in convenience features
# including an image viewer, text viewer, one-click compress/decompress with
# gzip, and a mini console that takes both FTP commands and operating system
# commands.


# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

import os
import pyDes
import libglade
import ftplib

import gtk
import pango

# dialog for new directories ==================================================
class mkdirDlg(libglade.GladeWrapper):

	def __init__(self, Filename, WindowName):
		libglade.GladeWrapper.__init__(self, Filename, WindowName)
		self.entMkdir.connect("key-press-event", self.press_enter)

	def get_info(self):

		return self.entMkdir.get_text()

	def mkdir_cancel(self, widget, data=None):

		self.mkdirDlg.hide_all()

	def mkdir_ok(self, widget, data=None):

		self.mkdirDlg.hide_all()

	def press_enter(self, widget, event, data=None):

		if 'Return' == gtk.gdk.keyval_name(event.keyval):
			self.mkdir_ok(self.btnMkdirOK)

# dialog for renaming files ===================================================
class renameDlg(libglade.GladeWrapper):

	def __init__(self, Filename, WindowName):
		libglade.GladeWrapper.__init__(self, Filename, WindowName)
		self.entRename.connect("key-press-event", self.press_enter)

	def get_info(self):

		return self.entRename.get_text()

	def rename_cancel(self, widget, data=None):

		self.renameDlg.hide_all()

	def rename_ok(self, widget, data=None):

		self.renameDlg.hide_all()

	def press_enter(self, widget, event, data=None):

		if 'Return' == gtk.gdk.keyval_name(event.keyval):
			self.rename_ok(self.btnRenameOK)

# dialog for saving servers ===================================================
class saveDlg(libglade.GladeWrapper):

	def __init__(self, Filename, WindowName):
		libglade.GladeWrapper.__init__(self, Filename, WindowName)
		self.entBookmark.connect("key-press-event", self.press_enter)

	def get_info(self):

		return self.entBookmark.get_text()

	def save_server_cancel(self, widget, data=None):

		self.saveDlg.hide_all()

	def save_server_info(self, widget, data=None):

		self.saveDlg.hide_all()

	def press_enter(self, widget, event, data=None):

		if 'Return' == gtk.gdk.keyval_name(event.keyval):
			self.save_server_info(self.btnSaveOK)

# dialog for cwd directories ==================================================
class cwdDlg(libglade.GladeWrapper):

	def __init__(self, Filename, WindowName):
		libglade.GladeWrapper.__init__(self, Filename, WindowName)
		self.entCwd.connect("key-press-event", self.press_enter)

	def get_info(self):

		return self.entCwd.get_text()

	def cwd_cancel(self, widget, data=None):

		self.cwdDlg.hide_all()

	def cwd_ok(self, widget, data=None):

		self.cwdDlg.hide_all()

	def press_enter(self, widget, event, data=None):

		if 'Return' == gtk.gdk.keyval_name(event.keyval):
			self.cwd_ok(self.btnCwdOK)

# text viewer window ==========================================================
class textWnd(libglade.GladeWrapper):

	def __init__(self, Filename, WindowName, TextFile=None):
		libglade.GladeWrapper.__init__(self, Filename, WindowName)

		self.buffer = self.textview1.get_buffer()
		self.textview1.set_left_margin(4)
		self.textview1.set_right_margin(4)
		self.textview1.modify_font(pango.FontDescription('monospace'))

		if TextFile != None:

			self.load_text(TextFile)


	def load_text(self, TextFile):

		self.buffer.set_text('')

		try:
			text = open(TextFile, 'r')

		except IOError:

			print 'Cannot find text file.'
			return

		for line in text:

			self.buffer.insert_at_cursor(line)

		text.close()
		self.textWnd.set_title('FOFF Text Viewer - ' + str(TextFile))


	def on_open_text(self, widget):

		chooser = gtk.FileChooserDialog("Open Text File", None, gtk.FILE_CHOOSER_ACTION_OPEN,
						(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
						gtk.STOCK_OPEN, gtk.RESPONSE_OK))

		chooser.set_default_response(gtk.RESPONSE_OK)
		filter = gtk.FileFilter()
		filter.set_name("All files")
		filter.add_pattern("*")
		chooser.add_filter(filter)

		filter = gtk.FileFilter()
		filter.set_name("Text (*.txt)")
		filter.add_pattern("*.txt")
		chooser.add_filter(filter)


		response = chooser.run()
		if response == gtk.RESPONSE_OK:
			self.load_text(chooser.get_filename())

		chooser.destroy()

	def on_close_text(self, widget, data=None):

		self.textWnd.destroy()


# bookmark window =============================================================
class bookWnd(libglade.GladeWrapper):

	def __init__(self, Filename, WindowName):
		libglade.GladeWrapper.__init__(self, Filename, WindowName)

		# OS Specific config dir
		if os.name == 'posix':
			self.rcdir = os.environ["HOME"] + "/.foffrc"
		else:
			self.rcdir = os.environ["HOMEDRIVE"] + os.environ["HOMEPATH"] + "\\foffrc"


		self.sites_model = gtk.ListStore(str)
		self.tvSites.set_model(self.sites_model)
		column = gtk.TreeViewColumn("My FTP Sites", gtk.CellRendererText(), text=0)
		self.tvSites.append_column(column)

		self.read_servers_config()


	# load settings ========================================================
	def read_servers_config(self):

		config = []
		config = os.listdir(self.rcdir)

		self.sites_model.clear()

		for filename in config:

			if not filename.endswith('.foff'):

				continue

			filename = filename.split('.foff')[0]

			iter = self.sites_model.append()
			self.sites_model.set(iter,0,filename)


	def load_server_config(self, widget):

		sel = self.tvSites.get_selection()
		model, iter = sel.get_selected()
		rcfile = model.get_value(iter, 0)

		try:
			config = open(os.path.join(self.rcdir, rcfile + '.foff'))

		except IOError:

			return

		self.entEname.set_text(rcfile)

		for line in config.readlines():

			if len(line.split('=')) < 1:
				continue

			k,v = line.strip().split('=',2)

			if   k == 'address':
				self.entEsite.set_text(v)

			elif k == 'portnum':
				self.entEport.set_text(v)

			elif k == 'usrname':
				self.entEuser.set_text(v)

			elif k == 'usrpass':

				try:
					des = pyDes.des("FOFFCRYP", pyDes.CBC, "\0\0\0\0\0\0\0\0")
					v = des.decrypt(v, '\0')
					v = v.decode('rot_13')

				except ValueError:

					print "DES Crypt error. Password will not be loaded.\n"
					v = ''

				self.entEpass.set_text(v)
		
			elif k == 'account':

				self.entEaccount.set_text(v)

			elif k == 'remotdr':

				if v == 'None':

					self.entEremote.set_text('')
				else:
					self.entEremote.set_text(v)

			elif k == 'localdr':

				self.fcbElocal.set_filename(str(v))

		config.close()


	# save site info =======================================================
	def on_save_site(self, widget):

		fofffile = self.entEname.get_text()

		if fofffile == '':
			return

		if not fofffile.endswith('.foff'):
			fofffile += '.foff'

		encpass = self.entEpass.get_text()
		encpass = encpass.encode('rot_13')

		try:
			k = pyDes.des("FOFFCRYP", pyDes.CBC, "\0\0\0\0\0\0\0\0")
			encpass = k.encrypt(encpass, '\0')

		except ValueError:

			print "DES Crypt error. Password will not be saved.\n"
			encpass = ''

		bookmark = open(os.path.join(self.rcdir, fofffile), "w")
		bookmark.write('address=' + self.entEsite.get_text() + '\n')
		bookmark.write('portnum=' + self.entEport.get_text() + '\n')
		bookmark.write('usrname=' + self.entEuser.get_text() + '\n')
		bookmark.write('usrpass=' + encpass + '\n')
		bookmark.write('account=' + self.entEaccount.get_text() + '\n')
		bookmark.write('localdr=' + str(self.fcbElocal.get_filename()) + '\n')
		bookmark.write('remotdr=' + self.entEremote.get_text() + '\n')
		bookmark.close()

		self.read_servers_config()


	def new_site(self, widget):

		self.entEname.set_text('')
		self.entEsite.set_text('')
		self.entEport.set_text('21')
		self.entEuser.set_text('')
		self.entEpass.set_text('')

		self.entEaccount.set_text('')
		self.entEremote.set_text('')
		self.fcbElocal.set_filename(os.getcwd())


	def test_connection(self, widget):

		try:
			tConn = ftplib.FTP()
			tConn.connect(self.entEsite.get_text(), self.entEport.get_text())
			tConn.login(self.entEuser.get_text(), self.entEpass.get_text())

			tConn.close()
			del tConn

			msg = gtk.MessageDialog(None,gtk.DIALOG_MODAL,gtk.MESSAGE_INFO,gtk.BUTTONS_OK)
			msg.set_icon_name("gtk-dialog-info")
			msg.set_title('Test Connection')
			msg.set_markup('Connection succeeded.')

			response = msg.run()
			msg.destroy()

		except:
			msg = gtk.MessageDialog(None,gtk.DIALOG_MODAL,gtk.MESSAGE_WARNING,gtk.BUTTONS_OK)
			msg.set_icon_name("gtk-dialog-warning")
			msg.set_title('Test Connection')
			msg.set_markup('Connection failed.')

			response = msg.run()
			msg.destroy()


	def delete_site(self, widget):

		sel = self.tvSites.get_selection()
		model, iter = sel.get_selected()
		rcfile = model.get_value(iter, 0)

		mstr = '<b>Delete site</b>'
		mstr += '\nAre you sure you want to delete \'' + rcfile + '\'?'

		msg = gtk.MessageDialog(None,gtk.DIALOG_MODAL,gtk.MESSAGE_QUESTION,gtk.BUTTONS_YES_NO)
		msg.set_icon_name("gtk-dialog-question")
		msg.set_title('Delete Site')
		msg.set_markup(mstr)

		response = msg.run()
		msg.destroy()

		if response == gtk.RESPONSE_NO:
			return

		os.remove(os.path.join(self.rcdir, rcfile + '.foff'))
		self.read_servers_config()

		self.entEname.set_text('')
		self.entEsite.set_text('')
		self.entEport.set_text('21')
		self.entEuser.set_text('')
		self.entEpass.set_text('')

		self.entEaccount.set_text('')
		self.entEremote.set_text('')
		self.fcbElocal.set_filename(os.getcwd())


	def on_manager_quit(self, widget, data=None):

		self.bookWnd.hide()

# image viewer window =========================================================
class picWnd(libglade.GladeWrapper):

	def __init__(self, Filename, WindowName, ImgFile=None):
		libglade.GladeWrapper.__init__(self, Filename, WindowName)

		self.one2one = 6
		self.imgsize = self.one2one
		self.sizes = [0.20,0.25,0.35,0.50,0.65,0.80,1.0,1.25,1.50,2.0,2.50,3.00,3.75]

		if ImgFile != None:

			self.fcImage.set_filename(os.path.join(os.getcwd(),ImgFile))

		filter = gtk.FileFilter()
		filter.set_name("All Supported Images")
		filter.add_pattern("*.png")
		filter.add_pattern("*.tiff")
		filter.add_pattern("*.tif")
		filter.add_pattern("*.jpg")
		filter.add_pattern("*.jpeg")
		filter.add_pattern("*.xpm")
		filter.add_pattern("*.ico")
		filter.add_pattern("*.bmp")
		filter.add_pattern("*.gif")
		filter.add_pattern("*.tga")
		filter.add_pattern("*.pcx")
		self.fcImage.add_filter(filter)

		filter = gtk.FileFilter()
		filter.set_name("All files")
		filter.add_pattern("*")
		self.fcImage.add_filter(filter)

		filter = gtk.FileFilter()
		filter.set_name("Graphics Interchange Format (*.gif)")
		filter.add_pattern("*.gif")
		self.fcImage.add_filter(filter)

		filter = gtk.FileFilter()
		filter.set_name("Joint Picture Experts Group (*.jpg,*.jpeg)")
		filter.add_pattern("*.jpg")
		filter.add_pattern("*.jpeg")
		self.fcImage.add_filter(filter)

		filter = gtk.FileFilter()
		filter.set_name("Portable Network Graphics (*.png)")
		filter.add_pattern("*.png")
		self.fcImage.add_filter(filter)

		filter = gtk.FileFilter()
		filter.set_name("Targa Image (*.tga)")
		filter.add_pattern("*.tga")
		self.fcImage.add_filter(filter)

		filter = gtk.FileFilter()
		filter.set_name("Tagged Image File Format (*.tif,*.tiff)")
		filter.add_pattern("*.tif")
		filter.add_pattern("*.tiff")
		self.fcImage.add_filter(filter)

		filter = gtk.FileFilter()
		filter.set_name("Windows Bitmap (*.bmp)")
		filter.add_pattern("*.bmp")
		self.fcImage.add_filter(filter)

		filter = gtk.FileFilter()
		filter.set_name("Windows Icon (*.ico)")
		filter.add_pattern("*.ico")
		self.fcImage.add_filter(filter)

		filter = gtk.FileFilter()
		filter.set_name("X PixMap Image (*.xpm)")
		filter.add_pattern("*.xpm")
		self.fcImage.add_filter(filter)

		filter = gtk.FileFilter()
		filter.set_name("ZSoft Paintbrush Format (*.pcx)")
		filter.add_pattern("*.xpm")
		self.fcImage.add_filter(filter)

	def load_new_image(self, widget):

		self.imgsize = self.one2one
		self.imgfile = self.fcImage.get_filename()
		self.imgPreview.set_from_file(self.imgfile)

		self.picWnd.set_title('FOFF Image Viewer - ' + str(self.imgfile))

	def on_zoom_normal(self, widget, data=None):

		self.imgsize = self.one2one
		self.imgPreview.set_from_file(self.imgfile)

	def on_zoom_in(self, widget, data=None):

		if self.imgsize >= 12:
			return

		self.imgsize = self.imgsize + 1
		self.imgPreview.set_from_file(self.imgfile)

		if self.imgsize != self.one2one:

			sizew = self.imgPreview.get_pixbuf().get_width() * self.sizes[self.imgsize]
			sizeh = self.imgPreview.get_pixbuf().get_height() * self.sizes[self.imgsize]

			self.imgPreview.set_from_pixbuf(self.imgPreview.get_pixbuf().scale_simple(sizew,sizeh,gtk.gdk.INTERP_BILINEAR))

	def on_zoom_out(self, widget, data=None):

		if self.imgsize <= 0:
			return

		self.imgsize = self.imgsize - 1
		self.imgPreview.set_from_file(self.imgfile)

		if self.imgsize != self.one2one:

			sizew = self.imgPreview.get_pixbuf().get_width() * self.sizes[self.imgsize]
			sizeh = self.imgPreview.get_pixbuf().get_height() * self.sizes[self.imgsize]

			self.imgPreview.set_from_pixbuf(self.imgPreview.get_pixbuf().scale_simple(sizew,sizeh,gtk.gdk.INTERP_BILINEAR))

	def on_close_pic(self, widget, data=None):

		self.picWnd.destroy()

# ==============================================================================