/* XmlWriter.vala
 *
 * Copyright (C) 2009 - 2015 Jerry Casiano
 *
 * This file is part of Font Manager.
 *
 * Font Manager is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Font Manager is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Font Manager.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 *        Jerry Casiano <JerryCasiano@gmail.com>
*/

namespace FontConfig {

    public class XmlWriter : Xml.TextWriter {

        public XmlWriter (string filepath) {
            base.filename(filepath);
            set_indent(true);
            set_indent_string("  ");
            start_document();
            write_string("<!DOCTYPE fontconfig SYSTEM \"fonts.dtd\">\n");
            write_comment(_(" Generated by Font Manager. Do NOT edit this file. "));
            start_element("fontconfig");
        }

        public void write_assignment (string name, string type, string val) {
            start_element("edit");
            write_attribute("name", name);
            write_attribute("mode", "assign");
            write_element(type, val);
            end_element();
            return;
        }

        public void write_comparison (string name, string test, string type, string val) {
            start_element("test");
            write_attribute("name", name);
            write_attribute("compare", test);
            write_element(type, val);
            end_element();
            return;
        }

        public void write_family_patelt (string family) {
            write_patelt("family", "string", family);
            return;
        }

        public void write_patelt (string name, string element_type, string val) {
            start_element("pattern");
            start_element("patelt");
            write_attribute("name", name);
            write_element(element_type, val);
            end_element();
            end_element();
            return;
        }

        public void start_selection (string selection_type) {
            start_element("selectfont");
            start_element(selection_type);
            return;
        }

        public void end_selection () {
            end_element();
            end_element();
            return;
        }

        public void close () {
            end_element();
            end_document();
            flush();
            return;
        }

    }

}
