#! /bin/bash
#
#  Check if dependencies are installed before build.
#
#  Note: 
#  exiftool and ufraw are not needed to build fotoxx,
#  but they are required at run time to handle EXIF
#  data and digital camera RAW files.

dlist=" g++  /usr/include/gtk-2.0/gtk/gtk.h  
        /usr/include/FreeImage.h  /usr/lib*/libfreeimage*.so
        xdg-open  xdg-desktop-menu "

error=0

for dname in $dlist
do
   if [ ${dname:0:1} = "/" ] 
      then find $dname >/dev/null 2>&1
      else which $dname >/dev/null
   fi
   if [ $? -ne 0 ]; then error=1; fi
done
if [ $error -eq 0 ]; then exit 0; fi

echo ""
echo "The following programs and libraries are required"
echo "(package names depend on your flavor of Linux)."
echo ""
echo "g++                  the Gnu C++ compiler and linker"
echo "libgtk2.0-dev        GTK graphics library (GUI base)"
echo "libfreeimage-dev     FreeImage graphics library"
echo "xdg-utils            LSB standard Linux utilities"
echo ""

for dname in $dlist
do
   if [ ${dname:0:1} = "/" ] 
      then find $dname >/dev/null 2>&1
      else which $dname >/dev/null
   fi
   if [ $? -ne 0 ]
      then echo " missing:  $dname"
      else echo "   found:  $dname"
   fi
done

echo ""
echo "Please install missing dependencies."
echo ""
exit 1


