{
    $Id: cpubase.inc,v 1.12 2004/02/05 18:28:37 peter Exp $
    Copyright (c) 1998-2000 by Florian Klaempfl and Peter Vreman

    Contains the basic declarations for the i386 architecture

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 ****************************************************************************
}
{ This include file contains the basic declarations for the i386 architecture.
}


{*****************************************************************************
                                Operand Sizes
*****************************************************************************}

    type
      topsize = (S_NO,
        S_B,S_W,S_L,S_Q,S_BW,S_BL,S_WL,
        S_IS,S_IL,S_IQ,
        S_FS,S_FL,S_FX,S_FV,S_FXX,
        S_MD,
        S_NEAR,S_FAR,S_SHORT
      );


{*****************************************************************************
                                Registers
*****************************************************************************}
  const
      {# Standard opcode string table (for each tasmop enumeration). The
         opcode strings should conform to the names as defined by the
         processor manufacturer.
      }
      std_op2str:op2strtable={$i i386int.inc}

{*****************************************************************************
                                 Constants
*****************************************************************************}
      c_countusableregsint = 4;

{
      firstsaveintreg = RS_EAX;
      lastsaveintreg  = RS_EDX;
      firstsavefpureg = RS_INVALID;
      lastsavefpureg  = RS_INVALID;
      firstsavemmreg  = RS_MM0;
      lastsavemmreg   = RS_MM7;

      general_superregisters = [RS_EAX,RS_EBX,RS_ECX,RS_EDX];

      maxvarregs = 4;
      varregs : array[1..maxvarregs] of tsuperregister =
         (RS_EBX,RS_EDX,RS_ECX,RS_EAX);

      maxfpuvarregs = 8;

      maxmmvarregs = 8;
}

{*****************************************************************************
                               GDB Information
*****************************************************************************}

      {# Register indexes for stabs information, when some
         parameters or variables are stored in registers.

         Taken from i386.c (dbx_register_map) and i386.h
          (FIXED_REGISTERS) from GCC 3.x source code

      }
      reg_stab_table : array[tregisterindex] of shortint = (
        {$i r386stab.inc}
      );


{*****************************************************************************
                          Default generic sizes
*****************************************************************************}

      {# Defines the default address size for a processor, }
      OS_ADDR = OS_32;
      {# the natural int size for a processor,             }
      OS_INT = OS_32;
      {# the maximum float size for a processor,           }
      OS_FLOAT = OS_F80;
      {# the size of a vector register for a processor     }
      OS_VECTOR = OS_M64;

{*****************************************************************************
                          Generic Register names
*****************************************************************************}

      {# Stack pointer register }
      NR_STACK_POINTER_REG = NR_ESP;
      RS_STACK_POINTER_REG = RS_ESP;
      {# Frame pointer register }
      RS_FRAME_POINTER_REG = RS_EBP;
      NR_FRAME_POINTER_REG = NR_EBP;
      {# Register for addressing absolute data in a position independant way,
         such as in PIC code. The exact meaning is ABI specific. For
         further information look at GCC source : PIC_OFFSET_TABLE_REGNUM
      }
      NR_PIC_OFFSET_REG = NR_EBX;
      { Results are returned in this register (32-bit values) }
      NR_FUNCTION_RETURN_REG = NR_EAX;
      RS_FUNCTION_RETURN_REG = RS_EAX;
      { Low part of 64bit return value }
      NR_FUNCTION_RETURN64_LOW_REG = NR_EAX;
      RS_FUNCTION_RETURN64_LOW_REG = RS_EAX;
      { High part of 64bit return value }
      NR_FUNCTION_RETURN64_HIGH_REG = NR_EDX;
      RS_FUNCTION_RETURN64_HIGH_REG = RS_EDX;
      { The value returned from a function is available in this register }
      NR_FUNCTION_RESULT_REG = NR_FUNCTION_RETURN_REG;
      RS_FUNCTION_RESULT_REG = RS_FUNCTION_RETURN_REG;
      { The lowh part of 64bit value returned from a function }
      NR_FUNCTION_RESULT64_LOW_REG = NR_FUNCTION_RETURN64_LOW_REG;
      RS_FUNCTION_RESULT64_LOW_REG = RS_FUNCTION_RETURN64_LOW_REG;
      { The high part of 64bit value returned from a function }
      NR_FUNCTION_RESULT64_HIGH_REG = NR_FUNCTION_RETURN64_HIGH_REG;
      RS_FUNCTION_RESULT64_HIGH_REG = RS_FUNCTION_RETURN64_HIGH_REG;

      { WARNING: don't change to R_ST0!! See comments above implementation of }
      { a_loadfpu* methods in rgcpu (JM)                                      }
      NR_fpu_result_reg = NR_ST;
      NR_mm_result_reg = NR_MM0;

      { Offset where the parent framepointer is pushed }
      PARENT_FRAMEPOINTER_OFFSET = 8;

{*****************************************************************************
                       GCC /ABI linking information
*****************************************************************************}

    const
      {# Registers which must be saved when calling a routine declared as
         cppdecl, cdecl, stdcall, safecall, palmossyscall. The registers
         saved should be the ones as defined in the target ABI and / or GCC.

         This value can be deduced from the CALLED_USED_REGISTERS array in the
         GCC source.
      }
      saved_standard_registers : array[0..2] of tsuperregister = (RS_EBX,RS_ESI,RS_EDI);
      {# Required parameter alignment when calling a routine declared as
         stdcall and cdecl. The alignment value should be the one defined
         by GCC or the target ABI.

         The value of this constant is equal to the constant
         PARM_BOUNDARY / BITS_PER_UNIT in the GCC source.
      }
      std_param_align = 4;

{
  $Log: cpubase.inc,v $
  Revision 1.12  2004/02/05 18:28:37  peter
    * x86_64 fixes for opsize

  Revision 1.11  2004/01/14 23:39:05  florian
    * another bunch of x86-64 fixes mainly calling convention and
      assembler reader related

  Revision 1.10  2003/10/17 14:38:32  peter
    * 64k registers supported
    * fixed some memory leaks

  Revision 1.9  2003/09/03 15:55:01  peter
    * NEWRA branch merged

  Revision 1.8  2003/09/03 11:18:37  florian
    * fixed arm concatcopy
    + arm support in the common compiler sources added
    * moved some generic cg code around
    + tfputype added
    * ...

  Revision 1.7.2.3  2003/08/29 17:29:00  peter
    * next batch of updates

  Revision 1.7.2.2  2003/08/28 18:35:08  peter
    * tregister changed to cardinal

  Revision 1.7.2.1  2003/08/27 20:05:04  peter
    * forgotten

  Revision 1.7  2003/07/06 17:58:22  peter
    * framepointer fixes for sparc
    * parent framepointer code more generic

  Revision 1.6  2003/06/03 13:01:59  daniel
    * Register allocator finished

  Revision 1.5  2003/05/31 15:05:28  peter
    * FUNCTION_RESULT64_LOW/HIGH_REG added for int64 results

  Revision 1.4  2003/05/30 23:57:08  peter
    * more sparc cleanup
    * accumulator removed, splitted in function_return_reg (called) and
      function_result_reg (caller)

  Revision 1.3  2003/05/16 14:33:31  peter
    * regvar fixes

  Revision 1.2  2002/04/25 16:12:09  florian
    * fixed more problems with cpubase and x86-64

  Revision 1.1  2003/04/25 11:12:09  florian
    * merged i386/cpubase and x86_64/cpubase to x86/cpubase;
      different stuff went to cpubase.inc
}
