#include "fpm.h"
#include "support.h"
#include <string.h>

static gint
fpm_cmp_title(fpm_data *a, fpm_data *b)
{
  return(g_strcasecmp(a->title, b->title));
}

void
fpm_create_category_list(gint edit_flag)
{
  GList *list;
  fpm_data *data;
  GCompareFunc cmp_func;


  /* Clear cat list */
  list = g_list_first(glb_cat_string_list);
  while(list!=NULL)
  {
    g_assert(list->data!=NULL);
    g_free(list->data);
    list=g_list_next(list);
  }
  g_list_free(glb_cat_string_list);
  glb_cat_string_list = NULL;

  cmp_func = (GCompareFunc) g_strcasecmp;

  /* Step through pass list adding to cat list */
  list = g_list_first(glb_pass_list);
  while(list!=NULL)
  {
    data = list->data;
    if (
    /*
        strcmp(data->category, "") &&
	*/
        g_list_find_custom(glb_cat_string_list, data->category, cmp_func) ==NULL)
    {
      g_assert(data->category !=NULL);
      glb_cat_string_list=g_list_insert_sorted(glb_cat_string_list,
      	g_strdup(data->category), cmp_func);
    }
    
    list=g_list_next(list);
  }



  if(edit_flag)
  {
    /* Add first item entry to beginning of list */
    glb_cat_string_list=g_list_prepend(glb_cat_string_list, g_strdup(""));
  }
  else
  {
    /* Add all category and default category */
    glb_cat_string_list=g_list_prepend(glb_cat_string_list, g_strdup(FPM_DEFAULT_CAT_MSG));
    glb_cat_string_list=g_list_prepend(glb_cat_string_list, g_strdup(FPM_ALL_CAT_MSG));
  }
}

void
fpm_check_view(gchar * category)
{
//  g_free(glb_last_category);
  glb_last_category=g_strdup(category);
  fpm_clist_create_view(category);
}

void
fpm_clist_populate_cat_list()
{ 
  GtkComboBox* option_menu;
  GList* list;
  gint i, index;
  GtkTreeModel *option_menu_model;

  fpm_create_category_list(0);
  g_assert(glb_cat_string_list!=NULL);

  option_menu = GTK_COMBO_BOX(lookup_widget(glb_win_app, "optionmenu_category"));
  option_menu_model = GTK_TREE_MODEL(gtk_list_store_new (1, G_TYPE_STRING));

  gtk_combo_box_set_model(option_menu, option_menu_model);

  list=g_list_first(glb_cat_string_list);
  i=0;
  index=0;
  while(list!=NULL)
  {
    gtk_combo_box_append_text(option_menu, g_strdup(list->data));

    if(!strcmp(glb_last_category, list->data))
	index=i;
    i++;
    list=g_list_next(list);
  }
    gtk_combo_box_set_active(option_menu, index);
}

void
fpm_clist_init()
{
  GtkListStore *main_list_store;
  GtkCellRenderer* cellRenderer;
  GtkTreeViewColumn* treeViewColumn;

  main_list_store = gtk_list_store_new (4, G_TYPE_STRING, G_TYPE_STRING,
					G_TYPE_STRING, G_TYPE_POINTER);

  gtk_tree_view_set_model (glb_clist_main, GTK_TREE_MODEL (main_list_store));
  
  cellRenderer = gtk_cell_renderer_text_new();
  treeViewColumn = gtk_tree_view_column_new_with_attributes (_("Title"), cellRenderer, "text", 0, NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW(glb_clist_main),treeViewColumn);
  gtk_tree_view_column_set_resizable(treeViewColumn, 1);
  gtk_tree_view_column_set_fixed_width (treeViewColumn, glb_fpm_ini->columns_width[0]);
  gtk_tree_view_column_set_sort_column_id(treeViewColumn,1);
  gtk_tree_view_column_set_sizing (treeViewColumn, GTK_TREE_VIEW_COLUMN_FIXED);
   
  treeViewColumn = gtk_tree_view_column_new_with_attributes (_("URL"),cellRenderer,"text",1,NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW(glb_clist_main),treeViewColumn);
  gtk_tree_view_column_set_resizable(treeViewColumn, 2);
  gtk_tree_view_column_set_fixed_width (treeViewColumn, glb_fpm_ini->columns_width[1]);
  gtk_tree_view_column_set_sizing (treeViewColumn, GTK_TREE_VIEW_COLUMN_FIXED);

  treeViewColumn = gtk_tree_view_column_new_with_attributes (_("User"),cellRenderer,"text",2,NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW(glb_clist_main),treeViewColumn);
  gtk_tree_view_column_set_resizable(treeViewColumn, 3);
  gtk_tree_view_column_set_sizing (treeViewColumn, GTK_TREE_VIEW_COLUMN_AUTOSIZE);
}


void
fpm_clist_create_view(gchar *  category)
/* Create visible CList from abstract GList */
{
  gint row;
  fpm_data *data;
  GList *list;
  
  GtkTreeIter iter;
  GtkTreeModel *list_store;

  glb_num_row=0;

  /* Sort the list */
  glb_cmp=(GCompareFunc) fpm_cmp_title;
  glb_pass_list=g_list_sort(glb_pass_list, glb_cmp);

  list_store = gtk_tree_view_get_model (glb_clist_main);
  gtk_list_store_clear(GTK_LIST_STORE(list_store));

  /* Iterate over the list */
  list=g_list_first(glb_pass_list);
  while (list!=NULL)
  {

    /* Get data for this element */
    data = list->data;

    if(category == NULL ||
       !strcmp(category, FPM_ALL_CAT_MSG) ||
       !strcmp(category, data->category) ||
       (!strcmp(category, FPM_DEFAULT_CAT_MSG) && data->default_list) )
    { 

    gtk_list_store_append (GTK_LIST_STORE(list_store), &iter);

    gtk_list_store_set(GTK_LIST_STORE(list_store), &iter,
	    FPM_COL_TITLE, data->title,
	    FPM_COL_URL, data->arg,
	    FPM_COL_USER, data->user,
	    FPM_COL_DATA_POINTER, data,
	    -1);

      glb_num_row++;
      row = glb_num_row - 1;
    
    }

    list=g_list_next(list);
  }
} 

