type token =
  | IDENTIFIER of (string)
  | TYPENAME of (string)
  | STRING_LITERAL of (bool*string)
  | CONSTANT of (Logic_ptree.constant)
  | LPAR
  | RPAR
  | IF
  | ELSE
  | COLON
  | COLON2
  | COLONCOLON
  | DOT
  | DOTDOT
  | DOTDOTDOT
  | INT
  | INTEGER
  | REAL
  | FLOAT
  | LT
  | GT
  | LE
  | GE
  | EQ
  | NE
  | COMMA
  | ARROW
  | EQUAL
  | FORALL
  | EXISTS
  | IFF
  | IMPLIES
  | AND
  | OR
  | NOT
  | SEPARATED
  | TRUE
  | FALSE
  | OLD
  | AT
  | RESULT
  | BLOCK_LENGTH
  | BASE_ADDR
  | VALID
  | VALID_INDEX
  | VALID_RANGE
  | FRESH
  | DOLLAR
  | QUESTION
  | MINUS
  | PLUS
  | STAR
  | AMP
  | SLASH
  | PERCENT
  | LSQUARE
  | RSQUARE
  | EOF
  | GLOBAL
  | INVARIANT
  | VARIANT
  | DECREASES
  | FOR
  | LABEL
  | ASSERT
  | SEMICOLON
  | NULL
  | EMPTY
  | REQUIRES
  | ENSURES
  | ASSIGNS
  | LOOP
  | NOTHING
  | SLICE
  | IMPACT
  | PRAGMA
  | FROM
  | READS
  | LOGIC
  | PREDICATE
  | INDUCTIVE
  | AXIOMATIC
  | AXIOM
  | LEMMA
  | LBRACE
  | RBRACE
  | GHOST
  | CASE
  | VOID
  | CHAR
  | SIGNED
  | UNSIGNED
  | SHORT
  | LONG
  | DOUBLE
  | STRUCT
  | ENUM
  | UNION
  | BSUNION
  | INTER
  | LTCOLON
  | COLONGT
  | TYPE
  | BEHAVIOR
  | BEHAVIORS
  | ASSUMES
  | COMPLETE
  | DISJOINT
  | TERMINATES
  | HAT
  | HATHAT
  | PIPE
  | TILDE
  | GTGT
  | LTLT
  | SIZEOF
  | LAMBDA
  | TYPEOF
  | BSTYPE

open Parsing;;
# 27 "cil/src/logic/logic_parser.mly"

  open Cil
  open Cil_types
  open Logic_ptree
  open Logic_const

  let loc () = (symbol_start_pos (), symbol_end_pos ())
  let loc_i i = (rhs_start i, rhs_end i)
  let info x = { lexpr_node = x; lexpr_loc = loc () }
  let loc_info loc x = { lexpr_node = x; lexpr_loc = loc }
  let loc_start x = fst x.lexpr_loc
  let loc_end x = snd x.lexpr_loc

  type sense_of_relation = Unknown | Equal | Disequal | Less | Greater

  let relation_sense rel sense =
    match rel, sense with
        Eq, _ -> sense, true
      | Neq, Unknown -> Disequal, true (* No chain of disequality for now*)
      | (Gt|Ge), (Unknown|Equal|Greater) -> Greater, true
      | (Lt|Le), (Unknown|Equal|Less) -> Less, true
      | _ -> sense, false

# 147 "cil/src/logic/logic_parser.ml"
let yytransl_const = [|
  261 (* LPAR *);
  262 (* RPAR *);
  263 (* IF *);
  264 (* ELSE *);
  265 (* COLON *);
  266 (* COLON2 *);
  267 (* COLONCOLON *);
  268 (* DOT *);
  269 (* DOTDOT *);
  270 (* DOTDOTDOT *);
  271 (* INT *);
  272 (* INTEGER *);
  273 (* REAL *);
  274 (* FLOAT *);
  275 (* LT *);
  276 (* GT *);
  277 (* LE *);
  278 (* GE *);
  279 (* EQ *);
  280 (* NE *);
  281 (* COMMA *);
  282 (* ARROW *);
  283 (* EQUAL *);
  284 (* FORALL *);
  285 (* EXISTS *);
  286 (* IFF *);
  287 (* IMPLIES *);
  288 (* AND *);
  289 (* OR *);
  290 (* NOT *);
  291 (* SEPARATED *);
  292 (* TRUE *);
  293 (* FALSE *);
  294 (* OLD *);
  295 (* AT *);
  296 (* RESULT *);
  297 (* BLOCK_LENGTH *);
  298 (* BASE_ADDR *);
  299 (* VALID *);
  300 (* VALID_INDEX *);
  301 (* VALID_RANGE *);
  302 (* FRESH *);
  303 (* DOLLAR *);
  304 (* QUESTION *);
  305 (* MINUS *);
  306 (* PLUS *);
  307 (* STAR *);
  308 (* AMP *);
  309 (* SLASH *);
  310 (* PERCENT *);
  311 (* LSQUARE *);
  312 (* RSQUARE *);
    0 (* EOF *);
  313 (* GLOBAL *);
  314 (* INVARIANT *);
  315 (* VARIANT *);
  316 (* DECREASES *);
  317 (* FOR *);
  318 (* LABEL *);
  319 (* ASSERT *);
  320 (* SEMICOLON *);
  321 (* NULL *);
  322 (* EMPTY *);
  323 (* REQUIRES *);
  324 (* ENSURES *);
  325 (* ASSIGNS *);
  326 (* LOOP *);
  327 (* NOTHING *);
  328 (* SLICE *);
  329 (* IMPACT *);
  330 (* PRAGMA *);
  331 (* FROM *);
  332 (* READS *);
  333 (* LOGIC *);
  334 (* PREDICATE *);
  335 (* INDUCTIVE *);
  336 (* AXIOMATIC *);
  337 (* AXIOM *);
  338 (* LEMMA *);
  339 (* LBRACE *);
  340 (* RBRACE *);
  341 (* GHOST *);
  342 (* CASE *);
  343 (* VOID *);
  344 (* CHAR *);
  345 (* SIGNED *);
  346 (* UNSIGNED *);
  347 (* SHORT *);
  348 (* LONG *);
  349 (* DOUBLE *);
  350 (* STRUCT *);
  351 (* ENUM *);
  352 (* UNION *);
  353 (* BSUNION *);
  354 (* INTER *);
  355 (* LTCOLON *);
  356 (* COLONGT *);
  357 (* TYPE *);
  358 (* BEHAVIOR *);
  359 (* BEHAVIORS *);
  360 (* ASSUMES *);
  361 (* COMPLETE *);
  362 (* DISJOINT *);
  363 (* TERMINATES *);
  364 (* HAT *);
  365 (* HATHAT *);
  366 (* PIPE *);
  367 (* TILDE *);
  368 (* GTGT *);
  369 (* LTLT *);
  370 (* SIZEOF *);
  371 (* LAMBDA *);
  372 (* TYPEOF *);
  373 (* BSTYPE *);
    0|]

let yytransl_block = [|
  257 (* IDENTIFIER *);
  258 (* TYPENAME *);
  259 (* STRING_LITERAL *);
  260 (* CONSTANT *);
    0|]

let yylhs = "\255\255\
\004\000\005\000\006\000\006\000\007\000\007\000\008\000\008\000\
\009\000\009\000\009\000\009\000\009\000\009\000\009\000\009\000\
\009\000\009\000\009\000\009\000\009\000\009\000\009\000\009\000\
\009\000\009\000\009\000\009\000\009\000\009\000\009\000\009\000\
\009\000\009\000\009\000\009\000\009\000\009\000\009\000\009\000\
\009\000\009\000\009\000\009\000\009\000\009\000\009\000\009\000\
\009\000\009\000\009\000\009\000\009\000\009\000\009\000\009\000\
\009\000\009\000\009\000\009\000\011\000\011\000\019\000\019\000\
\019\000\019\000\019\000\019\000\013\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\010\000\010\000\020\000\020\000\018\000\
\021\000\021\000\021\000\021\000\021\000\024\000\024\000\025\000\
\025\000\025\000\022\000\023\000\023\000\028\000\028\000\028\000\
\028\000\027\000\027\000\027\000\029\000\029\000\030\000\032\000\
\033\000\014\000\036\000\036\000\031\000\031\000\038\000\038\000\
\035\000\035\000\039\000\039\000\039\000\039\000\039\000\039\000\
\041\000\041\000\026\000\026\000\040\000\040\000\037\000\037\000\
\017\000\017\000\017\000\017\000\017\000\017\000\017\000\017\000\
\017\000\017\000\017\000\017\000\017\000\017\000\017\000\017\000\
\017\000\017\000\017\000\017\000\017\000\017\000\017\000\017\000\
\017\000\017\000\017\000\017\000\017\000\017\000\017\000\017\000\
\017\000\034\000\034\000\042\000\043\000\044\000\045\000\046\000\
\047\000\048\000\049\000\049\000\051\000\051\000\052\000\052\000\
\053\000\053\000\053\000\054\000\054\000\055\000\055\000\057\000\
\056\000\058\000\058\000\059\000\059\000\059\000\003\000\061\000\
\061\000\061\000\061\000\061\000\061\000\061\000\062\000\062\000\
\062\000\062\000\067\000\067\000\068\000\069\000\069\000\063\000\
\063\000\065\000\060\000\060\000\070\000\070\000\070\000\070\000\
\070\000\073\000\066\000\074\000\071\000\071\000\072\000\072\000\
\064\000\050\000\050\000\050\000\075\000\076\000\076\000\077\000\
\078\000\078\000\078\000\078\000\012\000\080\000\080\000\081\000\
\082\000\082\000\082\000\082\000\083\000\083\000\083\000\083\000\
\083\000\084\000\084\000\084\000\086\000\086\000\087\000\087\000\
\087\000\087\000\087\000\085\000\085\000\016\000\016\000\079\000\
\079\000\015\000\002\000\089\000\089\000\088\000\088\000\088\000\
\088\000\088\000\090\000\090\000\091\000\091\000\091\000\091\000\
\091\000\091\000\091\000\091\000\091\000\091\000\091\000\091\000\
\091\000\091\000\091\000\091\000\091\000\091\000\091\000\091\000\
\091\000\091\000\091\000\091\000\091\000\091\000\091\000\091\000\
\091\000\091\000\091\000\091\000\091\000\091\000\091\000\091\000\
\091\000\091\000\091\000\091\000\091\000\091\000\091\000\091\000\
\091\000\091\000\091\000\091\000\091\000\091\000\091\000\091\000\
\091\000\091\000\091\000\091\000\091\000\091\000\091\000\091\000\
\091\000\091\000\091\000\091\000\091\000\091\000\091\000\091\000\
\091\000\091\000\091\000\091\000\091\000\091\000\091\000\091\000\
\091\000\091\000\091\000\091\000\091\000\091\000\091\000\091\000\
\091\000\091\000\091\000\091\000\091\000\091\000\091\000\091\000\
\091\000\091\000\091\000\091\000\091\000\091\000\091\000\091\000\
\091\000\091\000\091\000\091\000\091\000\091\000\091\000\091\000\
\091\000\091\000\091\000\091\000\091\000\000\000\000\000\000\000"

let yylen = "\002\000\
\000\000\000\000\000\000\001\000\001\000\003\000\001\000\002\000\
\001\000\002\000\001\000\001\000\004\000\006\000\008\000\004\000\
\001\000\001\000\003\000\003\000\003\000\003\000\003\000\003\000\
\003\000\004\000\004\000\002\000\002\000\002\000\002\000\002\000\
\004\000\004\000\004\000\006\000\004\000\004\000\001\000\004\000\
\004\000\007\000\004\000\001\000\003\000\003\000\003\000\003\000\
\004\000\003\000\003\000\003\000\004\000\005\000\001\000\004\000\
\004\000\005\000\007\000\007\000\001\000\002\000\001\000\001\000\
\001\000\001\000\001\000\001\000\003\000\003\000\003\000\003\000\
\003\000\003\000\004\000\004\000\004\000\003\000\003\000\003\000\
\005\000\003\000\001\000\002\000\003\000\000\000\001\000\001\000\
\001\000\003\000\003\000\002\000\004\000\001\000\002\000\001\000\
\004\000\004\000\002\000\001\000\002\000\001\000\004\000\003\000\
\004\000\000\000\001\000\003\000\001\000\003\000\001\000\001\000\
\004\000\002\000\001\000\003\000\002\000\002\000\002\000\002\000\
\000\000\001\000\001\000\001\000\002\000\002\000\003\000\002\000\
\003\000\004\000\001\000\002\000\003\000\004\000\001\000\001\000\
\001\000\001\000\001\000\001\000\002\000\002\000\001\000\002\000\
\002\000\001\000\001\000\002\000\002\000\001\000\002\000\002\000\
\003\000\002\000\003\000\002\000\003\000\003\000\003\000\004\000\
\004\000\001\000\001\000\002\000\002\000\002\000\002\000\001\000\
\004\000\001\000\003\000\003\000\003\000\003\000\003\000\003\000\
\003\000\003\000\001\000\001\000\000\000\004\000\000\000\001\000\
\004\000\004\000\004\000\000\000\005\000\003\000\001\000\002\000\
\003\000\001\000\003\000\000\000\005\000\005\000\004\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\002\000\009\000\003\000\001\000\007\000\
\004\000\004\000\000\000\003\000\001\000\001\000\006\000\003\000\
\003\000\002\000\004\000\002\000\004\000\003\000\005\000\004\000\
\004\000\001\000\003\000\003\000\001\000\001\000\003\000\001\000\
\001\000\004\000\004\000\007\000\001\000\000\000\001\000\003\000\
\001\000\001\000\006\000\001\000\007\000\006\000\006\000\005\000\
\005\000\005\000\004\000\003\000\000\000\002\000\001\000\005\000\
\004\000\003\000\005\000\000\000\006\000\001\000\003\000\001\000\
\003\000\001\000\002\000\001\000\002\000\001\000\002\000\001\000\
\001\000\001\000\001\000\002\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\002\000\002\000\002\000"

let yydefred = "\000\000\
\000\000\000\000\000\000\000\000\245\000\061\000\018\000\000\000\
\000\000\000\000\000\000\000\000\011\000\012\000\000\000\000\000\
\039\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\017\000\055\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\083\000\000\000\
\000\000\000\000\026\001\000\000\001\000\204\000\001\000\001\000\
\200\000\202\000\203\000\000\000\000\000\000\000\001\000\001\000\
\001\000\000\000\001\000\000\000\201\000\206\000\205\000\143\001\
\000\000\000\000\207\000\208\000\209\000\210\000\024\001\252\000\
\025\001\221\000\222\000\000\000\000\000\000\000\249\000\250\000\
\000\000\022\001\001\000\144\001\000\000\000\000\143\000\137\000\
\138\000\162\000\139\000\140\000\000\000\000\000\147\000\000\000\
\163\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\089\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\063\000\064\000\065\000\066\000\067\000\068\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\008\000\000\000\062\000\000\000\000\000\001\000\001\000\
\000\000\000\000\000\000\000\000\000\000\000\000\001\000\001\000\
\001\000\226\000\228\000\000\000\000\000\001\000\000\000\000\000\
\000\000\000\000\000\000\001\000\000\000\029\001\031\001\030\001\
\032\001\033\001\034\001\035\001\036\001\037\001\038\001\039\001\
\040\001\041\001\042\001\043\001\044\001\045\001\046\001\047\001\
\048\001\049\001\050\001\051\001\052\001\053\001\054\001\055\001\
\056\001\057\001\058\001\059\001\060\001\061\001\062\001\141\001\
\063\001\064\001\065\001\066\001\067\001\068\001\069\001\070\001\
\071\001\072\001\073\001\074\001\075\001\076\001\077\001\078\001\
\079\001\080\001\081\001\082\001\083\001\084\001\085\001\086\001\
\087\001\088\001\089\001\090\001\091\001\092\001\093\001\094\001\
\095\001\096\001\097\001\098\001\099\001\100\001\101\001\102\001\
\103\001\104\001\105\001\106\001\107\001\108\001\109\001\110\001\
\111\001\112\001\113\001\114\001\115\001\116\001\117\001\118\001\
\119\001\120\001\121\001\122\001\123\001\124\001\125\001\135\001\
\126\001\134\001\136\001\137\001\127\001\128\001\129\001\130\001\
\131\001\132\001\133\001\138\001\139\001\140\001\023\001\000\000\
\001\000\212\000\001\000\000\000\021\001\019\001\000\000\001\000\
\001\000\001\000\000\000\184\000\000\000\000\000\000\000\144\000\
\141\000\148\000\000\000\145\000\142\000\149\000\000\000\154\000\
\000\000\164\000\165\000\166\000\167\000\047\000\048\000\000\000\
\000\000\131\000\000\000\000\000\114\000\122\000\123\000\000\000\
\000\000\096\000\092\000\000\000\000\000\000\000\102\000\099\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\004\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\078\000\000\000\
\000\000\000\000\025\000\024\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\051\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\225\000\
\002\000\001\000\000\000\224\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\135\000\000\000\136\000\000\000\002\000\
\000\000\001\000\001\000\001\000\000\000\247\000\000\000\000\000\
\001\000\000\000\004\001\028\001\000\000\000\000\000\000\230\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\
\192\000\000\000\000\000\000\000\000\000\000\000\153\000\000\000\
\155\000\000\000\159\000\000\000\000\000\000\000\000\000\132\000\
\125\000\000\000\000\000\128\000\069\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\090\000\091\000\
\000\000\000\000\041\000\035\000\001\000\038\000\037\000\013\000\
\000\000\000\000\016\000\000\000\000\000\000\000\056\000\057\000\
\033\000\034\000\000\000\053\000\000\000\000\000\027\000\026\000\
\085\000\040\000\000\000\001\000\001\000\172\000\173\000\195\000\
\001\000\000\000\217\000\001\000\218\000\180\000\000\000\002\000\
\179\000\000\000\237\000\000\000\233\000\232\000\000\000\000\000\
\120\000\119\000\177\000\000\000\000\000\000\000\018\001\000\000\
\000\000\000\000\001\000\003\001\000\000\001\000\001\000\001\000\
\001\000\007\001\000\000\000\000\000\000\001\000\000\000\002\000\
\227\000\229\000\182\000\000\000\000\000\000\000\000\000\190\000\
\000\000\001\000\001\000\001\000\199\000\169\000\000\000\160\000\
\161\000\129\000\000\000\127\000\000\000\000\000\109\000\111\000\
\000\000\000\000\000\000\000\000\104\000\000\000\000\000\093\000\
\006\000\000\000\000\000\000\000\000\000\000\000\058\000\054\000\
\000\000\000\000\015\001\000\000\000\000\001\000\214\000\178\000\
\000\000\000\000\231\000\000\000\001\000\002\001\242\000\001\000\
\000\000\000\000\002\000\248\000\000\000\001\000\000\000\001\000\
\000\000\000\000\000\000\001\001\006\001\000\001\000\000\000\000\
\176\000\186\000\187\000\185\000\193\000\000\000\000\000\000\000\
\000\000\171\000\134\000\130\000\000\000\118\000\117\000\098\000\
\097\000\105\000\103\000\036\000\014\000\000\000\000\000\000\000\
\000\000\251\000\223\000\000\000\236\000\235\000\239\000\113\000\
\000\000\017\001\001\000\000\000\174\000\254\000\000\000\255\000\
\000\000\000\000\001\000\010\001\002\000\000\000\000\000\000\000\
\000\000\220\000\108\000\110\000\000\000\060\000\059\000\042\000\
\216\000\253\000\000\000\116\000\000\000\000\000\009\001\000\000\
\175\000\001\000\189\000\197\000\198\000\015\000\244\000\000\000\
\008\001\011\001\000\000\000\000\213\000\013\001"

let yydgoto = "\004\000\
\102\001\064\000\084\000\171\000\254\001\114\001\115\001\039\000\
\040\000\162\000\041\000\042\000\102\000\103\000\022\002\148\001\
\164\001\108\000\163\000\105\000\109\000\110\000\096\001\091\001\
\092\001\097\001\061\002\098\001\062\002\063\002\064\002\065\002\
\166\001\197\001\085\001\099\002\066\002\198\001\086\001\087\001\
\088\001\158\001\183\000\026\002\112\002\183\001\182\000\161\001\
\008\002\009\002\085\000\059\001\060\001\193\001\061\001\191\001\
\062\001\173\000\196\001\053\002\065\000\066\000\067\000\068\000\
\069\000\070\000\071\000\072\000\159\001\073\000\074\000\075\000\
\076\000\077\000\010\002\011\002\012\002\184\000\024\002\173\001\
\174\001\078\000\079\000\080\000\103\002\035\002\036\002\081\000\
\082\000\047\001\048\001"

let yysindex = "\215\001\
\175\014\139\015\158\255\000\000\000\000\000\000\000\000\062\013\
\102\007\102\007\087\015\174\255\000\000\000\000\242\255\003\000\
\000\000\021\000\046\000\047\000\052\000\057\000\058\000\087\015\
\087\015\087\015\087\015\000\000\000\000\175\014\067\000\070\000\
\087\015\073\000\102\007\079\000\082\000\138\014\000\000\172\013\
\037\000\074\255\000\000\031\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\178\000\018\000\030\000\000\000\000\000\
\000\000\094\000\000\000\053\000\000\000\000\000\000\000\000\000\
\201\012\178\255\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\139\000\173\000\241\000\000\000\000\000\
\191\001\000\000\000\000\000\000\007\255\176\000\000\000\000\000\
\000\000\000\000\000\000\000\000\177\255\102\000\000\000\255\254\
\000\000\094\000\094\000\094\000\180\255\190\000\193\000\230\255\
\192\000\126\255\075\000\142\000\185\000\000\000\149\000\005\255\
\016\255\175\014\175\014\175\014\175\014\175\014\175\014\175\014\
\175\014\175\014\005\255\005\255\005\255\005\255\139\011\175\014\
\175\014\005\255\062\013\156\000\175\014\148\006\175\014\175\014\
\175\014\175\014\175\014\175\014\175\014\175\014\175\014\094\000\
\000\000\000\000\000\000\000\000\000\000\000\000\094\000\087\015\
\087\015\087\015\087\015\087\015\175\014\087\015\165\013\087\015\
\087\015\000\000\087\015\000\000\175\014\175\014\000\000\000\000\
\175\014\157\000\094\000\197\000\215\000\162\000\000\000\000\000\
\000\000\000\000\000\000\227\000\102\007\000\000\001\255\224\000\
\224\000\151\000\221\000\000\000\171\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\201\012\
\000\000\000\000\000\000\174\000\000\000\000\000\179\000\000\000\
\000\000\000\000\133\000\000\000\155\000\216\254\102\007\000\000\
\000\000\000\000\008\255\000\000\000\000\000\000\015\255\000\000\
\229\000\000\000\000\000\000\000\000\000\000\000\000\000\087\015\
\230\255\000\000\175\014\019\000\000\000\000\000\000\000\057\255\
\175\014\000\000\000\000\179\255\223\255\075\000\000\000\000\000\
\096\000\131\000\175\014\059\014\175\014\190\255\242\000\049\001\
\239\001\135\001\070\003\144\003\180\002\101\007\001\004\094\000\
\062\013\243\000\000\000\248\000\034\004\252\000\175\014\144\004\
\212\000\006\000\006\000\061\255\243\254\152\000\000\000\214\000\
\056\255\242\254\000\000\000\000\176\255\176\255\005\255\005\255\
\005\255\226\001\213\000\005\255\005\255\000\000\166\001\166\001\
\172\013\006\001\138\014\194\000\249\000\014\001\138\014\000\000\
\000\000\000\000\237\254\000\000\216\000\222\000\223\000\007\014\
\226\000\230\000\016\001\000\000\230\255\000\000\230\255\000\000\
\224\000\000\000\000\000\000\000\123\255\000\000\210\000\026\001\
\000\000\034\001\000\000\000\000\032\001\175\014\235\000\000\000\
\238\000\158\255\239\000\244\000\245\000\175\014\007\255\000\000\
\000\000\202\000\207\000\253\000\036\001\033\001\000\000\045\001\
\000\000\051\001\000\000\005\255\063\001\138\014\015\001\000\000\
\000\000\057\255\102\007\000\000\000\000\102\007\175\014\179\255\
\066\001\131\000\102\007\175\014\138\014\126\255\000\000\000\000\
\138\014\175\014\000\000\000\000\000\000\000\000\000\000\000\000\
\175\014\175\014\000\000\046\001\097\255\009\255\000\000\000\000\
\000\000\000\000\138\014\000\000\068\001\175\014\000\000\000\000\
\000\000\000\000\073\001\000\000\000\000\000\000\000\000\000\000\
\000\000\025\001\000\000\000\000\000\000\000\000\138\014\000\000\
\000\000\010\001\000\000\062\001\000\000\000\000\031\001\102\007\
\000\000\000\000\000\000\155\255\078\001\074\001\000\000\018\001\
\102\007\103\001\000\000\000\000\028\001\000\000\000\000\000\000\
\000\000\000\000\035\001\026\001\048\001\000\000\047\001\000\000\
\000\000\000\000\000\000\007\255\007\255\007\255\050\014\000\000\
\106\001\000\000\000\000\000\000\000\000\000\000\102\007\000\000\
\000\000\000\000\061\001\000\000\112\001\095\001\000\000\000\000\
\075\000\075\000\115\001\067\001\000\000\116\001\072\001\000\000\
\000\000\118\001\065\005\235\011\175\014\175\014\000\000\000\000\
\138\014\175\014\000\000\065\001\070\001\000\000\000\000\000\000\
\091\014\175\014\000\000\110\001\000\000\000\000\000\000\000\000\
\113\001\114\001\000\000\000\000\071\001\000\000\053\001\000\000\
\224\000\122\001\076\001\000\000\000\000\000\000\102\007\132\001\
\000\000\000\000\000\000\000\000\000\000\007\255\080\001\081\001\
\082\001\000\000\000\000\000\000\253\006\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\175\014\060\012\055\014\
\136\001\000\000\000\000\083\001\000\000\000\000\000\000\000\000\
\084\001\000\000\000\000\102\007\000\000\000\000\140\001\000\000\
\224\000\222\255\000\000\000\000\000\000\123\001\155\000\216\254\
\216\254\000\000\000\000\000\000\101\005\000\000\000\000\000\000\
\000\000\000\000\131\001\000\000\175\014\137\000\000\000\088\001\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\204\014\
\000\000\000\000\090\001\028\001\000\000\000\000"

let yyrindex = "\000\000\
\000\000\000\000\025\000\000\000\000\000\000\000\000\000\142\001\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\160\002\000\000\010\012\
\030\005\138\005\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\160\001\000\000\000\000\000\000\000\000\
\000\000\162\002\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\163\002\000\000\000\000\
\000\000\000\000\000\000\000\000\049\000\181\004\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\176\001\000\000\033\002\
\000\000\000\000\000\000\000\000\151\001\000\000\000\000\151\007\
\000\000\000\000\000\000\000\000\251\255\000\000\000\000\224\007\
\138\005\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\034\008\101\008\167\008\233\008\000\000\163\001\
\163\001\045\009\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\142\001\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\013\255\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\209\255\145\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\171\002\
\000\000\000\000\000\000\003\015\000\000\000\000\000\000\000\000\
\000\000\000\000\061\000\000\000\074\000\004\000\000\000\000\000\
\000\000\000\000\143\002\000\000\000\000\000\000\253\002\000\000\
\107\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\117\001\046\007\000\000\000\000\000\000\000\000\
\146\000\000\000\000\000\153\255\000\000\000\000\000\000\000\000\
\000\000\003\255\000\000\000\000\000\000\062\255\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\213\004\062\005\035\000\124\006\000\000\000\000\091\012\
\019\006\240\000\000\000\000\000\255\010\065\011\112\009\178\009\
\244\009\151\001\000\000\054\010\121\010\000\000\132\011\198\011\
\050\012\000\000\242\001\000\000\017\255\000\000\021\255\000\000\
\000\000\000\000\000\000\000\000\000\000\111\001\000\000\000\000\
\000\000\003\015\172\000\000\000\187\000\000\000\187\000\000\000\
\145\000\000\000\000\000\000\000\000\000\000\000\000\000\096\001\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\025\000\000\000\000\000\000\000\000\000\063\000\000\000\
\000\000\000\000\000\000\174\002\000\000\159\001\000\000\217\003\
\000\000\071\004\000\000\189\010\000\000\147\000\000\000\000\000\
\000\000\243\005\178\001\000\000\000\000\178\001\117\001\253\255\
\000\000\097\000\178\001\117\001\096\002\022\000\000\000\000\000\
\125\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\203\015\000\000\000\000\000\000\
\000\000\000\000\235\002\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\092\006\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\123\000\000\000\
\000\000\121\001\000\000\196\255\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\107\001\000\000\000\000\
\000\000\000\000\000\000\000\000\119\001\000\000\000\000\000\000\
\000\000\000\000\000\000\096\001\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\049\000\049\000\049\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\197\006\000\000\000\000\184\001\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\060\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\026\000\188\001\000\000\000\000\000\000\000\000\000\000\000\000\
\145\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\063\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\145\000\000\000\000\000\000\000\000\000\000\000\074\000\004\000\
\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\119\001\000\000\000\000"

let yygindex = "\000\000\
\255\255\000\000\000\000\254\255\145\254\075\002\143\255\000\000\
\098\000\060\001\000\000\045\000\053\002\032\000\250\000\094\254\
\024\000\248\255\000\000\231\254\000\000\133\001\180\254\246\000\
\120\001\162\255\218\254\125\001\000\000\086\000\061\254\086\255\
\000\000\073\254\112\255\066\000\091\255\037\002\153\001\208\254\
\152\001\214\255\235\255\000\000\000\000\000\000\208\000\182\001\
\000\000\000\000\055\001\115\254\000\000\083\000\000\000\000\000\
\000\000\212\254\033\254\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\181\002\000\000\198\000\000\000\000\000\000\000\
\000\000\000\000\160\000\164\000\000\000\244\255\150\000\102\254\
\076\002\000\000\093\254\000\000\080\000\237\000\000\000\000\000\
\184\002\229\001\000\000"

let yytablesize = 4412
let yytable = "\038\000\
\103\001\111\000\170\000\196\000\181\001\174\000\101\000\021\002\
\100\000\084\001\165\001\093\001\034\002\072\001\020\002\167\001\
\144\000\217\001\137\000\170\001\165\000\194\000\199\001\224\001\
\181\000\172\000\132\000\100\000\127\000\201\001\151\000\104\000\
\107\000\107\000\073\000\209\001\014\001\140\000\140\000\212\001\
\055\001\255\001\169\000\001\002\185\000\169\000\187\000\189\000\
\183\000\048\002\002\002\146\001\181\000\106\000\106\000\113\000\
\019\002\207\001\107\000\157\000\191\000\211\001\183\000\213\001\
\194\001\195\001\100\000\005\000\113\000\113\000\113\000\113\000\
\078\002\188\000\056\001\057\001\194\000\113\000\165\000\106\000\
\169\000\002\000\166\000\171\001\002\000\098\002\100\000\137\000\
\092\002\083\002\073\001\074\001\079\002\141\000\141\000\142\000\
\143\000\005\000\167\000\200\001\014\001\165\000\186\000\158\000\
\159\000\166\000\202\001\140\000\112\000\000\002\058\001\083\001\
\140\000\104\001\105\001\106\001\107\001\108\001\109\001\110\001\
\111\001\123\000\124\000\125\000\126\000\005\000\005\000\122\002\
\034\002\117\001\130\000\120\001\157\001\122\001\123\001\124\001\
\125\001\126\001\127\001\128\001\129\001\130\001\075\001\076\001\
\077\001\149\001\150\001\082\001\165\001\027\002\090\001\095\001\
\088\002\167\001\104\000\138\001\167\000\121\001\114\002\115\002\
\116\002\060\002\118\001\141\000\147\001\143\000\178\001\151\001\
\141\000\169\001\143\000\157\002\169\000\169\000\160\001\067\002\
\082\001\094\000\114\000\167\000\070\002\093\002\104\000\214\001\
\113\002\078\001\028\002\144\000\131\001\068\002\142\001\064\001\
\180\002\181\002\071\002\132\001\113\000\113\000\113\000\113\000\
\113\000\151\000\113\000\113\000\113\000\113\000\154\002\113\000\
\098\002\135\000\136\000\137\000\138\000\241\000\226\001\153\001\
\094\000\241\000\094\002\135\000\136\000\137\000\138\000\005\000\
\083\000\163\001\154\000\139\000\155\000\156\000\157\000\140\000\
\159\002\215\001\081\001\241\000\094\000\139\000\049\001\079\000\
\171\002\140\000\084\001\149\002\126\002\127\002\115\000\052\000\
\027\002\133\001\134\001\135\001\136\001\137\001\174\002\140\001\
\141\001\143\001\144\001\238\000\145\001\119\002\120\002\116\000\
\065\001\185\001\123\002\066\001\067\001\187\001\238\000\189\001\
\241\000\208\001\158\000\159\000\017\002\095\000\018\002\081\001\
\082\001\117\000\102\000\172\000\083\001\175\002\243\000\141\000\
\142\000\143\000\243\000\135\000\136\000\137\000\138\000\164\000\
\073\000\141\000\142\000\143\000\073\000\177\002\102\000\073\000\
\182\001\169\000\118\000\119\000\243\000\169\000\160\001\169\000\
\120\000\140\000\088\000\073\000\095\000\121\000\122\000\196\000\
\073\000\073\000\073\000\073\000\040\002\208\001\084\001\128\000\
\084\001\083\001\129\000\005\000\102\000\131\000\088\000\094\001\
\095\000\206\001\073\000\133\000\181\000\102\000\134\000\206\001\
\168\000\243\000\073\000\179\000\181\000\181\000\005\000\073\000\
\005\000\221\001\073\000\225\001\094\001\165\001\101\000\180\000\
\238\001\102\000\167\001\163\001\183\000\073\000\188\000\130\001\
\073\002\141\000\142\000\143\000\068\001\243\001\073\000\015\002\
\191\000\101\000\183\000\107\000\113\000\082\001\181\000\093\001\
\181\000\181\000\181\000\181\000\172\000\188\000\037\002\219\001\
\107\000\090\001\095\001\051\001\165\001\095\001\093\001\073\000\
\222\001\167\001\208\001\240\000\149\001\023\002\183\000\086\000\
\087\000\183\000\183\000\183\000\236\001\237\001\007\002\169\000\
\101\000\246\001\191\000\093\002\183\000\191\000\191\000\183\000\
\183\000\025\002\049\002\246\000\112\000\052\001\169\000\146\000\
\112\000\204\001\188\000\188\000\101\000\135\000\136\000\137\000\
\138\000\220\001\240\000\121\000\047\002\069\001\054\001\112\000\
\070\001\071\001\063\001\079\001\112\000\240\000\080\001\139\000\
\185\002\086\000\087\000\140\000\089\001\099\001\121\000\023\002\
\246\000\100\001\084\002\121\000\101\001\206\001\085\002\001\000\
\002\000\003\000\206\001\119\001\152\001\154\001\112\000\155\001\
\137\002\156\001\112\000\162\001\172\001\177\001\149\001\075\002\
\076\002\176\001\179\001\175\000\176\000\184\001\087\002\190\001\
\101\002\082\000\186\001\203\001\081\002\079\000\177\000\227\001\
\239\001\079\000\169\000\178\000\079\000\240\001\169\000\163\001\
\192\001\242\001\163\001\141\000\142\000\143\000\245\001\163\001\
\079\000\140\000\090\001\250\001\248\001\079\000\079\000\079\000\
\079\000\252\001\105\002\106\002\107\002\251\001\253\001\003\002\
\169\000\090\001\004\002\181\000\172\000\172\000\005\002\079\000\
\150\000\013\002\016\002\111\002\029\002\014\002\038\002\079\000\
\039\002\044\000\041\002\140\002\079\000\042\002\044\002\079\000\
\050\002\169\000\145\002\045\002\046\002\051\002\228\001\054\002\
\052\002\055\002\079\000\056\002\163\001\055\000\056\000\057\000\
\058\000\057\002\059\000\079\000\058\002\163\001\059\002\069\002\
\077\002\080\002\023\002\135\002\136\002\082\002\135\000\136\000\
\137\000\138\000\086\002\169\000\089\002\060\000\090\002\007\002\
\007\002\151\002\169\000\153\002\079\000\079\000\091\002\075\000\
\139\000\095\002\096\002\163\001\140\000\097\002\030\002\031\002\
\057\000\058\000\032\002\059\000\100\002\095\001\095\001\110\002\
\176\002\102\002\118\002\083\001\002\002\124\002\108\002\125\002\
\128\002\130\002\129\002\132\002\076\000\149\001\033\002\131\002\
\138\002\144\002\155\002\147\002\165\002\139\002\150\002\187\002\
\152\002\158\002\148\002\156\002\230\001\168\002\151\000\160\002\
\161\002\162\002\169\002\170\002\173\002\178\002\183\002\186\002\
\169\000\189\002\086\000\163\001\141\000\142\000\143\000\142\001\
\001\000\211\000\020\001\087\000\135\000\136\000\137\000\138\000\
\003\000\163\001\027\001\184\002\086\000\219\000\215\000\169\000\
\146\000\144\000\170\000\005\001\146\000\146\000\139\000\106\000\
\234\000\146\000\140\000\146\000\146\000\107\000\016\001\151\000\
\163\001\115\000\146\000\146\000\146\000\146\000\146\000\146\000\
\146\000\146\000\012\001\116\001\249\001\146\000\146\000\146\000\
\146\000\139\001\164\002\072\002\216\001\172\002\152\000\153\000\
\154\000\168\001\155\000\156\000\157\000\218\001\074\002\146\000\
\146\000\146\000\146\000\146\000\146\000\146\000\146\000\146\000\
\223\001\205\001\077\000\210\001\146\000\104\002\188\001\146\000\
\043\002\179\002\141\000\142\000\143\000\146\002\050\001\082\000\
\142\002\121\002\146\000\082\000\152\000\143\002\082\000\135\000\
\136\000\137\000\138\000\146\000\175\001\053\001\000\000\229\001\
\158\000\159\000\082\000\190\002\135\000\136\000\137\000\138\000\
\109\002\139\000\146\000\146\000\180\001\140\000\000\000\000\000\
\000\000\247\001\000\000\146\000\146\000\146\000\139\000\146\000\
\146\000\150\000\140\000\000\000\000\000\150\000\150\000\000\000\
\000\000\082\000\150\000\000\000\150\000\150\000\082\000\000\000\
\000\000\082\000\000\000\150\000\150\000\150\000\150\000\150\000\
\150\000\150\000\150\000\081\000\082\000\000\000\150\000\150\000\
\150\000\150\000\000\000\000\000\000\000\082\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\141\000\142\000\143\000\
\150\000\150\000\150\000\150\000\150\000\150\000\150\000\150\000\
\150\000\000\000\141\000\142\000\143\000\150\000\000\000\000\000\
\150\000\000\000\000\000\000\000\000\000\075\000\000\000\000\000\
\000\000\075\000\156\000\150\000\075\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\150\000\000\000\000\000\000\000\
\075\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\076\000\150\000\150\000\000\000\076\000\000\000\
\000\000\076\000\000\000\000\000\150\000\150\000\150\000\151\000\
\150\000\150\000\000\000\151\000\151\000\076\000\000\000\075\000\
\151\000\000\000\151\000\151\000\075\000\000\000\000\000\075\000\
\000\000\151\000\151\000\151\000\151\000\151\000\151\000\151\000\
\151\000\000\000\075\000\000\000\151\000\151\000\151\000\151\000\
\000\000\000\000\000\000\075\000\076\000\000\000\000\000\000\000\
\000\000\076\000\000\000\000\000\076\000\000\000\151\000\151\000\
\151\000\151\000\151\000\151\000\151\000\151\000\151\000\076\000\
\000\000\000\000\000\000\151\000\233\001\000\000\151\000\000\000\
\076\000\135\000\136\000\137\000\138\000\000\000\000\000\000\000\
\157\000\151\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\151\000\139\000\000\000\000\000\000\000\140\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\077\000\151\000\151\000\000\000\077\000\000\000\000\000\077\000\
\000\000\000\000\151\000\151\000\151\000\152\000\151\000\151\000\
\000\000\152\000\152\000\077\000\000\000\000\000\152\000\000\000\
\152\000\152\000\000\000\000\000\000\000\000\000\000\000\152\000\
\152\000\152\000\152\000\152\000\152\000\152\000\152\000\000\000\
\000\000\000\000\152\000\152\000\152\000\152\000\000\000\141\000\
\142\000\143\000\077\000\000\000\000\000\000\000\000\000\077\000\
\000\000\000\000\077\000\000\000\152\000\152\000\152\000\152\000\
\152\000\152\000\152\000\152\000\152\000\077\000\000\000\000\000\
\000\000\152\000\000\000\000\000\152\000\000\000\077\000\000\000\
\000\000\081\000\000\000\000\000\000\000\081\000\158\000\152\000\
\081\000\000\000\000\000\231\001\000\000\000\000\000\000\000\000\
\152\000\000\000\000\000\000\000\081\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\152\000\
\152\000\000\000\000\000\135\000\136\000\137\000\138\000\000\000\
\152\000\152\000\152\000\156\000\152\000\152\000\000\000\156\000\
\156\000\000\000\000\000\081\000\156\000\139\000\156\000\156\000\
\081\000\140\000\000\000\081\000\000\000\156\000\156\000\156\000\
\156\000\156\000\156\000\156\000\156\000\000\000\081\000\000\000\
\156\000\156\000\156\000\156\000\000\000\000\000\000\000\081\000\
\000\000\000\000\000\000\000\000\000\000\232\001\000\000\000\000\
\000\000\000\000\156\000\156\000\156\000\156\000\156\000\156\000\
\156\000\156\000\156\000\000\000\000\000\000\000\000\000\156\000\
\000\000\000\000\156\000\000\000\000\000\135\000\136\000\137\000\
\138\000\141\000\142\000\143\000\168\000\156\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\156\000\139\000\
\000\000\000\000\000\000\140\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\156\000\156\000\000\000\
\000\000\000\000\000\000\000\000\071\000\000\000\156\000\156\000\
\156\000\157\000\156\000\156\000\000\000\157\000\157\000\000\000\
\000\000\000\000\157\000\000\000\157\000\157\000\000\000\000\000\
\000\000\000\000\000\000\157\000\157\000\157\000\157\000\157\000\
\157\000\157\000\157\000\000\000\000\000\000\000\157\000\157\000\
\157\000\157\000\000\000\141\000\142\000\143\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\235\001\000\000\
\157\000\157\000\157\000\157\000\157\000\157\000\157\000\157\000\
\157\000\000\000\000\000\000\000\000\000\157\000\000\000\000\000\
\157\000\000\000\000\000\000\000\000\000\009\000\135\000\136\000\
\137\000\138\000\000\000\157\000\000\000\000\000\000\000\241\001\
\000\000\000\000\000\000\000\000\157\000\000\000\000\000\000\000\
\139\000\000\000\000\000\000\000\140\000\000\000\000\000\000\000\
\000\000\000\000\000\000\157\000\157\000\070\000\000\000\135\000\
\136\000\137\000\138\000\000\000\157\000\157\000\157\000\158\000\
\157\000\157\000\000\000\158\000\158\000\000\000\000\000\000\000\
\158\000\139\000\158\000\158\000\000\000\140\000\000\000\000\000\
\000\000\158\000\158\000\158\000\158\000\158\000\158\000\158\000\
\158\000\000\000\000\000\000\000\158\000\158\000\158\000\158\000\
\000\000\000\000\000\000\000\000\141\000\142\000\143\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\158\000\158\000\
\158\000\158\000\158\000\158\000\158\000\158\000\158\000\000\000\
\000\000\000\000\000\000\158\000\000\000\000\000\158\000\000\000\
\000\000\044\000\000\000\000\000\000\000\141\000\142\000\143\000\
\000\000\158\000\000\000\000\000\000\000\244\001\000\000\000\000\
\000\000\000\000\158\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\158\000\158\000\000\000\000\000\135\000\136\000\137\000\
\138\000\000\000\158\000\158\000\158\000\168\000\158\000\158\000\
\000\000\168\000\168\000\000\000\000\000\000\000\168\000\139\000\
\168\000\168\000\000\000\140\000\000\000\000\000\000\000\000\000\
\168\000\168\000\168\000\168\000\168\000\168\000\168\000\000\000\
\000\000\000\000\168\000\168\000\168\000\168\000\000\000\000\000\
\000\000\000\000\071\000\000\000\000\000\000\000\071\000\000\000\
\000\000\071\000\000\000\000\000\168\000\168\000\168\000\168\000\
\168\000\168\000\168\000\168\000\168\000\071\000\000\000\000\000\
\000\000\168\000\126\000\000\000\168\000\000\000\000\000\000\000\
\000\000\000\000\000\000\141\000\142\000\143\000\000\000\168\000\
\000\000\000\000\000\000\000\000\071\000\000\000\000\000\000\000\
\168\000\000\000\000\000\000\000\071\000\000\000\000\000\000\000\
\000\000\071\000\074\000\000\000\071\000\000\000\000\000\168\000\
\168\000\000\000\000\000\000\000\000\000\000\000\000\000\071\000\
\168\000\168\000\168\000\009\000\168\000\168\000\000\000\009\000\
\071\000\009\000\009\000\000\000\000\000\000\000\000\000\000\000\
\009\000\009\000\009\000\009\000\009\000\009\000\009\000\009\000\
\000\000\000\000\000\000\009\000\009\000\009\000\009\000\000\000\
\000\000\000\000\000\000\070\000\000\000\000\000\133\002\070\000\
\000\000\000\000\070\000\000\000\000\000\009\000\009\000\009\000\
\009\000\009\000\009\000\009\000\009\000\009\000\070\000\000\000\
\000\000\000\000\009\000\043\000\000\000\009\000\135\000\136\000\
\137\000\138\000\000\000\000\000\000\000\000\000\000\000\000\000\
\009\000\000\000\182\002\000\000\000\000\070\000\000\000\000\000\
\139\000\009\000\000\000\000\000\140\000\070\000\000\000\000\000\
\000\000\000\000\070\000\072\000\000\000\070\000\000\000\000\000\
\009\000\009\000\135\000\136\000\137\000\138\000\000\000\000\000\
\070\000\009\000\009\000\009\000\000\000\009\000\009\000\044\000\
\000\000\070\000\000\000\044\000\139\000\044\000\044\000\000\000\
\140\000\000\000\000\000\000\000\044\000\044\000\044\000\044\000\
\044\000\044\000\044\000\044\000\000\000\000\000\000\000\044\000\
\044\000\044\000\044\000\000\000\141\000\142\000\143\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\044\000\044\000\044\000\044\000\044\000\044\000\044\000\
\044\000\044\000\000\000\000\000\133\000\000\000\044\000\000\000\
\000\000\044\000\000\000\000\000\000\000\000\000\000\000\000\000\
\141\000\142\000\143\000\000\000\044\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\044\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\044\000\044\000\000\000\000\000\
\000\000\000\000\000\000\126\000\000\000\044\000\044\000\044\000\
\126\000\044\000\044\000\000\000\126\000\000\000\126\000\126\000\
\000\000\000\000\000\000\000\000\000\000\126\000\126\000\126\000\
\126\000\126\000\126\000\126\000\126\000\000\000\000\000\000\000\
\126\000\126\000\126\000\126\000\000\000\000\000\000\000\000\000\
\074\000\000\000\000\000\000\000\074\000\000\000\000\000\074\000\
\000\000\000\000\126\000\126\000\126\000\126\000\126\000\126\000\
\126\000\000\000\126\000\074\000\000\000\124\000\000\000\126\000\
\074\000\074\000\126\000\074\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\126\000\000\000\000\000\
\000\000\000\000\074\000\000\000\000\000\000\000\126\000\000\000\
\000\000\000\000\074\000\000\000\000\000\000\000\000\000\074\000\
\000\000\000\000\074\000\000\000\000\000\126\000\126\000\000\000\
\000\000\000\000\000\000\000\000\000\000\074\000\126\000\126\000\
\126\000\043\000\126\000\126\000\000\000\043\000\074\000\043\000\
\043\000\000\000\000\000\000\000\000\000\000\000\043\000\043\000\
\043\000\043\000\043\000\043\000\043\000\043\000\000\000\000\000\
\000\000\043\000\043\000\043\000\043\000\000\000\000\000\074\000\
\000\000\072\000\000\000\000\000\000\000\072\000\000\000\000\000\
\072\000\000\000\000\000\043\000\043\000\043\000\043\000\043\000\
\043\000\043\000\043\000\043\000\072\000\086\000\121\000\000\000\
\043\000\072\000\072\000\043\000\072\000\000\000\000\000\000\000\
\000\000\000\000\087\000\088\000\089\000\090\000\043\000\000\000\
\000\000\000\000\000\000\072\000\000\000\000\000\000\000\043\000\
\000\000\000\000\000\000\072\000\000\000\000\000\000\000\000\000\
\072\000\000\000\000\000\072\000\000\000\000\000\043\000\043\000\
\000\000\000\000\000\000\000\000\000\000\133\000\072\000\043\000\
\043\000\043\000\133\000\043\000\043\000\000\000\133\000\072\000\
\133\000\133\000\000\000\000\000\000\000\000\000\000\000\133\000\
\133\000\133\000\133\000\133\000\133\000\133\000\133\000\010\000\
\000\000\000\000\133\000\133\000\133\000\133\000\000\000\000\000\
\000\000\000\000\091\000\092\000\093\000\094\000\095\000\096\000\
\097\000\098\000\099\000\100\000\133\000\133\000\133\000\133\000\
\133\000\133\000\133\000\000\000\133\000\005\000\086\000\000\000\
\000\000\133\000\000\000\000\000\133\000\000\000\000\000\000\000\
\000\000\000\000\163\002\087\000\088\000\089\000\090\000\133\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\133\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\028\000\000\000\000\000\000\000\000\000\000\000\133\000\
\133\000\000\000\000\000\000\000\000\000\000\000\124\000\000\000\
\133\000\133\000\133\000\124\000\133\000\133\000\000\000\124\000\
\000\000\124\000\124\000\000\000\000\000\000\000\000\000\000\000\
\124\000\124\000\124\000\124\000\124\000\124\000\124\000\124\000\
\000\000\000\000\000\000\124\000\124\000\124\000\124\000\000\000\
\000\000\000\000\000\000\091\000\092\000\093\000\094\000\095\000\
\096\000\097\000\098\000\099\000\100\000\124\000\124\000\124\000\
\000\000\124\000\124\000\124\000\029\000\124\000\005\000\086\000\
\000\000\000\000\124\000\000\000\000\000\124\000\000\000\000\000\
\000\000\000\000\000\000\000\000\087\000\088\000\089\000\090\000\
\124\000\000\000\000\000\000\000\000\000\234\001\000\000\000\000\
\000\000\124\000\135\000\136\000\137\000\138\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\124\000\124\000\000\000\000\000\139\000\000\000\000\000\000\000\
\140\000\124\000\124\000\124\000\121\000\124\000\124\000\000\000\
\121\000\000\000\121\000\121\000\000\000\000\000\031\000\000\000\
\000\000\121\000\121\000\121\000\121\000\121\000\121\000\121\000\
\121\000\000\000\000\000\000\000\121\000\121\000\121\000\121\000\
\000\000\000\000\000\000\000\000\091\000\092\000\093\000\094\000\
\095\000\096\000\097\000\098\000\099\000\100\000\121\000\121\000\
\121\000\000\000\121\000\121\000\121\000\000\000\121\000\000\000\
\141\000\142\000\143\000\121\000\000\000\000\000\121\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\121\000\000\000\000\000\000\000\010\000\000\000\000\000\
\032\000\010\000\121\000\000\000\010\000\000\000\000\000\000\000\
\000\000\000\000\010\000\010\000\010\000\010\000\010\000\010\000\
\010\000\121\000\121\000\000\000\000\000\010\000\010\000\010\000\
\010\000\000\000\121\000\121\000\121\000\000\000\121\000\121\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\010\000\
\010\000\010\000\010\000\010\000\010\000\010\000\000\000\010\000\
\000\000\000\000\000\000\000\000\010\000\000\000\000\000\010\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\028\000\
\000\000\000\000\010\000\028\000\030\000\000\000\028\000\000\000\
\000\000\000\000\000\000\010\000\028\000\028\000\028\000\028\000\
\028\000\028\000\028\000\000\000\000\000\000\000\000\000\028\000\
\028\000\028\000\028\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\010\000\010\000\010\000\000\000\010\000\
\010\000\028\000\028\000\028\000\028\000\028\000\028\000\028\000\
\000\000\028\000\000\000\000\000\000\000\000\000\028\000\000\000\
\000\000\028\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\029\000\000\000\028\000\000\000\029\000\021\000\
\000\000\029\000\000\000\000\000\000\000\028\000\000\000\029\000\
\029\000\029\000\029\000\029\000\029\000\029\000\000\000\000\000\
\000\000\000\000\029\000\029\000\029\000\029\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\028\000\028\000\028\000\
\000\000\028\000\028\000\000\000\029\000\029\000\029\000\029\000\
\029\000\029\000\029\000\000\000\029\000\000\000\000\000\000\000\
\000\000\029\000\000\000\000\000\029\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\031\000\000\000\000\000\029\000\
\031\000\022\000\000\000\031\000\000\000\000\000\000\000\000\000\
\029\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
\000\000\000\000\000\000\000\000\031\000\031\000\031\000\031\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\029\000\029\000\029\000\000\000\029\000\029\000\031\000\031\000\
\031\000\031\000\031\000\031\000\031\000\000\000\031\000\000\000\
\000\000\000\000\000\000\031\000\000\000\000\000\031\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\032\000\000\000\
\000\000\031\000\032\000\023\000\000\000\032\000\000\000\000\000\
\000\000\000\000\031\000\032\000\032\000\032\000\032\000\032\000\
\032\000\032\000\000\000\000\000\000\000\000\000\032\000\032\000\
\032\000\032\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\031\000\031\000\031\000\000\000\031\000\031\000\
\032\000\032\000\032\000\032\000\032\000\032\000\032\000\000\000\
\032\000\000\000\000\000\000\000\000\000\032\000\000\000\000\000\
\032\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\030\000\032\000\000\000\050\000\030\000\000\000\
\000\000\030\000\000\000\000\000\032\000\000\000\000\000\030\000\
\030\000\030\000\030\000\030\000\030\000\030\000\000\000\000\000\
\000\000\000\000\030\000\030\000\030\000\030\000\000\000\000\000\
\000\000\000\000\000\000\000\000\032\000\032\000\032\000\000\000\
\032\000\032\000\000\000\000\000\030\000\030\000\030\000\030\000\
\030\000\030\000\030\000\000\000\030\000\000\000\000\000\000\000\
\000\000\030\000\000\000\000\000\030\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\021\000\000\000\030\000\
\052\000\021\000\000\000\000\000\021\000\000\000\000\000\000\000\
\030\000\000\000\021\000\021\000\021\000\021\000\021\000\021\000\
\021\000\000\000\000\000\000\000\000\000\021\000\021\000\021\000\
\021\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\030\000\030\000\030\000\000\000\030\000\030\000\000\000\021\000\
\021\000\021\000\021\000\021\000\021\000\021\000\000\000\021\000\
\000\000\000\000\000\000\000\000\021\000\000\000\000\000\021\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\022\000\
\000\000\000\000\021\000\022\000\049\000\000\000\022\000\000\000\
\000\000\000\000\000\000\021\000\022\000\022\000\022\000\022\000\
\022\000\022\000\022\000\000\000\000\000\000\000\000\000\022\000\
\022\000\022\000\022\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\021\000\021\000\021\000\000\000\021\000\
\021\000\022\000\022\000\022\000\022\000\022\000\022\000\022\000\
\000\000\022\000\000\000\000\000\000\000\000\000\022\000\000\000\
\000\000\022\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\023\000\000\000\000\000\022\000\023\000\020\000\000\000\
\023\000\000\000\000\000\000\000\000\000\022\000\023\000\023\000\
\023\000\023\000\023\000\023\000\023\000\000\000\000\000\000\000\
\000\000\023\000\023\000\023\000\023\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\022\000\022\000\022\000\
\000\000\022\000\022\000\023\000\023\000\023\000\023\000\023\000\
\023\000\023\000\000\000\023\000\000\000\000\000\000\000\000\000\
\023\000\000\000\000\000\023\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\050\000\000\000\000\000\023\000\050\000\
\019\000\000\000\050\000\000\000\000\000\000\000\000\000\023\000\
\050\000\050\000\050\000\050\000\050\000\050\000\050\000\000\000\
\000\000\000\000\000\000\050\000\050\000\050\000\050\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\023\000\
\023\000\023\000\000\000\023\000\023\000\050\000\050\000\050\000\
\050\000\050\000\050\000\050\000\000\000\050\000\000\000\000\000\
\000\000\000\000\050\000\000\000\000\000\050\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\052\000\000\000\
\050\000\000\000\052\000\045\000\000\000\052\000\000\000\000\000\
\000\000\050\000\000\000\052\000\052\000\052\000\052\000\052\000\
\052\000\052\000\000\000\000\000\000\000\000\000\052\000\052\000\
\052\000\052\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\050\000\050\000\050\000\000\000\050\000\050\000\000\000\
\052\000\052\000\052\000\052\000\052\000\052\000\052\000\000\000\
\052\000\000\000\000\000\000\000\000\000\052\000\000\000\000\000\
\052\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\049\000\052\000\000\000\046\000\049\000\000\000\
\000\000\049\000\000\000\000\000\052\000\000\000\000\000\049\000\
\049\000\049\000\049\000\049\000\049\000\049\000\000\000\000\000\
\000\000\000\000\049\000\049\000\049\000\049\000\000\000\000\000\
\000\000\000\000\000\000\000\000\052\000\052\000\052\000\000\000\
\052\000\052\000\000\000\000\000\049\000\049\000\049\000\049\000\
\049\000\049\000\049\000\000\000\049\000\000\000\000\000\000\000\
\000\000\049\000\000\000\000\000\049\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\020\000\000\000\000\000\049\000\
\020\000\007\000\000\000\020\000\000\000\000\000\000\000\000\000\
\049\000\020\000\020\000\020\000\020\000\020\000\020\000\020\000\
\000\000\000\000\000\000\000\000\020\000\020\000\020\000\020\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\049\000\049\000\049\000\000\000\049\000\049\000\020\000\020\000\
\020\000\084\000\020\000\000\000\000\000\000\000\020\000\000\000\
\000\000\000\000\000\000\020\000\000\000\000\000\020\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\019\000\000\000\
\000\000\020\000\019\000\000\000\000\000\019\000\000\000\000\000\
\000\000\000\000\020\000\019\000\019\000\019\000\019\000\019\000\
\019\000\019\000\080\000\000\000\000\000\000\000\019\000\019\000\
\019\000\019\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\020\000\020\000\020\000\000\000\020\000\020\000\
\019\000\019\000\019\000\000\000\019\000\000\000\000\000\000\000\
\019\000\000\000\000\000\000\000\000\000\019\000\000\000\000\000\
\019\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\045\000\000\000\019\000\000\000\045\000\000\000\000\000\
\045\000\000\000\000\000\000\000\019\000\000\000\045\000\045\000\
\045\000\045\000\045\000\045\000\045\000\000\000\000\000\000\000\
\000\000\045\000\045\000\045\000\045\000\000\000\000\000\000\000\
\135\000\136\000\137\000\138\000\019\000\019\000\019\000\000\000\
\019\000\019\000\000\000\045\000\000\000\000\000\000\000\045\000\
\000\000\000\000\139\000\045\000\000\000\000\000\140\000\000\000\
\045\000\000\000\000\000\045\000\000\000\000\000\000\000\112\001\
\000\000\000\000\000\000\046\000\000\000\000\000\045\000\046\000\
\000\000\000\000\046\000\000\000\000\000\000\000\000\000\045\000\
\046\000\046\000\046\000\046\000\046\000\046\000\046\000\000\000\
\000\000\000\000\000\000\046\000\046\000\046\000\046\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\045\000\
\045\000\045\000\000\000\045\000\045\000\046\000\141\000\142\000\
\113\001\046\000\000\000\000\000\000\000\046\000\000\000\000\000\
\000\000\000\000\046\000\134\002\000\000\046\000\000\000\000\000\
\135\000\136\000\137\000\138\000\000\000\000\000\000\000\007\000\
\046\000\000\000\000\000\007\000\000\000\000\000\007\000\000\000\
\000\000\046\000\139\000\000\000\000\000\000\000\140\000\000\000\
\000\000\000\000\007\000\000\000\000\000\000\000\000\000\007\000\
\007\000\007\000\007\000\000\000\000\000\000\000\000\000\000\000\
\000\000\046\000\046\000\046\000\000\000\046\000\046\000\084\000\
\000\000\007\000\000\000\084\000\000\000\007\000\084\000\000\000\
\000\000\007\000\000\000\000\000\000\000\000\000\007\000\000\000\
\000\000\007\000\084\000\000\000\000\000\000\000\000\000\084\000\
\084\000\084\000\084\000\000\000\007\000\000\000\141\000\142\000\
\143\000\135\000\136\000\137\000\138\000\007\000\000\000\000\000\
\080\000\084\000\000\000\000\000\080\000\084\000\000\000\080\000\
\000\000\084\000\000\000\139\000\000\000\000\000\084\000\140\000\
\000\000\084\000\000\000\080\000\000\000\007\000\007\000\007\000\
\080\000\080\000\080\000\080\000\084\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\084\000\000\000\000\000\
\000\000\000\000\080\000\000\000\000\000\000\000\000\000\166\002\
\000\000\000\000\080\000\000\000\000\000\000\000\000\000\080\000\
\000\000\000\000\080\000\000\000\000\000\084\000\084\000\084\000\
\000\000\000\000\000\000\000\000\000\000\080\000\000\000\141\000\
\142\000\143\000\000\000\000\000\000\000\000\000\080\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\080\000\080\000\
\080\000\190\000\191\000\192\000\193\000\194\000\195\000\196\000\
\197\000\198\000\199\000\200\000\201\000\202\000\203\000\204\000\
\205\000\206\000\207\000\208\000\209\000\210\000\211\000\212\000\
\213\000\214\000\215\000\216\000\217\000\218\000\219\000\220\000\
\221\000\222\000\223\000\224\000\225\000\226\000\227\000\228\000\
\229\000\230\000\231\000\232\000\233\000\234\000\235\000\236\000\
\237\000\238\000\239\000\240\000\241\000\242\000\243\000\244\000\
\245\000\246\000\247\000\248\000\249\000\250\000\251\000\252\000\
\253\000\254\000\255\000\000\001\001\001\002\001\003\001\004\001\
\005\001\000\000\006\001\007\001\008\001\009\001\010\001\000\000\
\000\000\011\001\012\001\013\001\014\001\015\001\000\000\016\001\
\017\001\018\001\019\001\020\001\021\001\022\001\023\001\024\001\
\025\001\026\001\027\001\028\001\029\001\030\001\031\001\032\001\
\033\001\034\001\035\001\036\001\037\001\038\001\039\001\040\001\
\041\001\042\001\043\001\044\001\045\001\046\001\005\000\086\000\
\006\000\007\000\008\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\087\000\088\000\089\000\090\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\009\000\010\000\000\000\000\000\000\000\000\000\011\000\
\012\000\013\000\014\000\015\000\016\000\017\000\018\000\019\000\
\020\000\021\000\022\000\023\000\000\000\000\000\024\000\025\000\
\026\000\027\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\028\000\029\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\030\000\000\000\000\000\000\000\091\000\092\000\093\000\094\000\
\095\000\096\000\097\000\098\000\099\000\100\000\031\000\032\000\
\000\000\000\000\000\000\000\000\000\000\005\000\086\000\006\000\
\007\000\008\000\000\000\000\000\033\000\000\000\000\000\034\000\
\035\000\036\000\037\000\087\000\088\000\089\000\090\000\144\000\
\000\000\000\000\000\000\000\000\000\000\000\000\145\000\146\000\
\147\000\148\000\149\000\150\000\000\000\151\000\011\000\012\000\
\013\000\014\000\015\000\016\000\017\000\018\000\019\000\020\000\
\021\000\022\000\023\000\000\000\000\000\024\000\025\000\026\000\
\027\000\000\000\000\000\000\000\152\000\153\000\154\000\000\000\
\155\000\156\000\157\000\000\000\000\000\028\000\029\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\030\000\
\000\000\000\000\000\000\091\000\092\000\093\000\094\000\095\000\
\096\000\097\000\098\000\099\000\100\000\031\000\032\000\005\000\
\000\000\006\000\007\000\008\000\000\000\000\000\158\000\159\000\
\000\000\000\000\000\000\033\000\000\000\000\000\034\000\000\000\
\036\000\037\000\000\000\160\000\161\000\000\000\000\000\000\000\
\000\000\000\000\009\000\010\000\000\000\000\000\000\000\000\000\
\011\000\012\000\013\000\014\000\015\000\016\000\017\000\018\000\
\019\000\020\000\021\000\022\000\023\000\000\000\000\000\024\000\
\025\000\026\000\027\000\005\000\086\000\000\000\000\000\094\001\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\028\000\
\029\000\087\000\088\000\089\000\090\000\006\002\000\000\135\000\
\136\000\137\000\138\000\000\000\135\000\136\000\137\000\138\000\
\000\000\030\000\000\000\005\000\000\000\006\000\007\000\008\000\
\000\000\139\000\000\000\000\000\000\000\140\000\139\000\031\000\
\032\000\000\000\140\000\000\000\000\000\082\001\000\000\000\000\
\000\000\117\002\000\000\000\000\000\000\033\000\009\000\010\000\
\034\000\035\000\036\000\037\000\011\000\012\000\013\000\014\000\
\015\000\016\000\017\000\018\000\019\000\020\000\021\000\022\000\
\023\000\000\000\167\002\024\000\025\000\026\000\027\000\000\000\
\000\000\091\000\092\000\093\000\094\000\095\000\096\000\097\000\
\098\000\099\000\100\000\028\000\029\000\141\000\142\000\143\000\
\000\000\141\002\141\000\142\000\143\000\000\000\000\000\135\000\
\136\000\137\000\138\000\000\000\000\000\030\000\000\000\005\000\
\000\000\006\000\007\000\008\000\000\000\000\000\000\000\000\000\
\000\000\139\000\000\000\031\000\032\000\140\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\033\000\009\000\010\000\034\000\035\000\036\000\037\000\
\011\000\012\000\013\000\014\000\015\000\016\000\017\000\018\000\
\019\000\020\000\021\000\022\000\023\000\000\000\000\000\024\000\
\025\000\026\000\027\000\000\000\000\000\000\000\000\000\000\000\
\000\000\135\000\136\000\137\000\138\000\000\000\000\000\028\000\
\029\000\000\000\000\000\000\000\000\000\141\000\142\000\143\000\
\000\000\000\000\000\000\139\000\000\000\000\000\000\000\140\000\
\000\000\030\000\000\000\001\000\000\000\001\000\001\000\001\000\
\000\000\000\000\000\000\188\002\000\000\000\000\000\000\031\000\
\032\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\033\000\001\000\001\000\
\034\000\035\000\036\000\037\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\000\000\000\000\001\000\001\000\001\000\001\000\141\000\
\142\000\143\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\001\000\001\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\001\000\000\000\005\000\
\000\000\006\000\007\000\008\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\001\000\001\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\001\000\000\000\000\000\001\000\001\000\001\000\001\000\
\011\000\012\000\013\000\014\000\015\000\016\000\017\000\018\000\
\019\000\020\000\021\000\022\000\023\000\000\000\000\000\024\000\
\025\000\026\000\027\000\043\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\028\000\
\029\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\030\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\031\000\
\032\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\044\000\045\000\033\000\046\000\047\000\
\034\000\048\000\036\000\037\000\000\000\049\000\050\000\051\000\
\052\000\000\000\053\000\054\000\000\000\000\000\044\000\055\000\
\056\000\057\000\058\000\000\000\059\000\044\000\044\000\044\000\
\044\000\044\000\044\000\000\000\044\000\000\000\000\000\000\000\
\044\000\044\000\044\000\044\000\000\000\000\000\000\000\060\000\
\061\000\000\000\000\000\062\000\000\000\063\000\000\000\000\000\
\000\000\000\000\044\000\044\000\044\000\000\000\044\000\044\000\
\044\000\044\000\000\000\000\000\000\000\000\000\000\000\044\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\044\000\044\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\044\000\044\000\
\044\000\000\000\044\000\044\000"

let yycheck = "\001\000\
\114\000\010\000\045\000\000\000\049\001\048\000\008\000\170\001\
\006\001\104\000\181\000\106\000\176\001\015\001\169\001\181\000\
\012\001\094\001\032\001\019\001\005\001\009\001\015\001\100\001\
\000\000\047\000\035\000\025\001\030\000\015\001\026\001\008\000\
\009\000\010\000\000\000\084\001\020\001\052\001\052\001\088\001\
\083\000\153\001\045\000\063\001\057\000\048\000\059\000\060\000\
\000\000\191\001\070\001\165\000\055\000\009\000\010\000\011\000\
\168\001\083\001\035\000\055\001\000\000\005\001\000\000\089\001\
\105\001\106\001\064\001\006\001\024\000\025\000\026\000\027\000\
\064\001\000\000\068\001\069\001\064\001\033\000\005\001\035\000\
\083\000\061\001\009\001\083\001\064\001\025\002\084\001\032\001\
\016\002\252\001\092\001\093\001\084\001\108\001\108\001\109\001\
\110\001\001\001\083\001\092\001\084\001\005\001\058\000\099\001\
\100\001\009\001\092\001\052\001\011\000\154\001\104\001\055\001\
\052\001\115\000\116\000\117\000\118\000\119\000\120\000\121\000\
\122\000\024\000\025\000\026\000\027\000\064\001\001\001\055\002\
\036\002\131\000\033\000\133\000\175\000\135\000\136\000\137\000\
\138\000\139\000\140\000\141\000\142\000\143\000\098\000\099\000\
\100\000\167\000\168\000\051\001\063\001\027\001\106\000\107\000\
\008\002\063\001\131\000\157\000\083\001\134\000\044\002\045\002\
\046\002\210\001\131\000\108\001\166\000\110\001\188\000\169\000\
\108\001\182\000\110\001\111\002\175\000\176\000\177\000\214\001\
\051\001\025\001\005\001\083\001\219\001\027\001\159\000\005\001\
\040\002\006\001\064\001\012\001\144\000\215\001\159\000\015\001\
\160\002\161\002\220\001\151\000\152\000\153\000\154\000\155\000\
\156\000\026\001\158\000\159\000\160\000\161\000\105\002\163\000\
\148\002\030\001\031\001\032\001\033\001\005\001\025\001\171\000\
\064\001\009\001\064\001\030\001\031\001\032\001\033\001\001\001\
\067\001\181\000\051\001\048\001\053\001\054\001\055\001\052\001\
\118\002\055\001\005\001\027\001\084\001\048\001\061\001\000\000\
\147\002\052\001\081\001\099\002\065\002\066\002\005\001\070\001\
\027\001\152\000\153\000\154\000\155\000\156\000\153\002\158\000\
\159\000\160\000\161\000\064\001\163\000\050\002\051\002\005\001\
\088\001\052\001\059\002\091\001\092\001\056\001\075\001\058\001\
\064\001\051\001\099\001\100\001\165\001\025\001\167\001\005\001\
\051\001\005\001\005\001\049\001\055\001\064\001\005\001\108\001\
\109\001\110\001\009\001\030\001\031\001\032\001\033\001\003\001\
\006\001\108\001\109\001\110\001\010\001\157\002\025\001\013\001\
\051\001\052\001\005\001\005\001\027\001\056\001\057\001\058\001\
\005\001\052\001\064\001\025\001\064\001\005\001\005\001\060\001\
\030\001\031\001\032\001\033\001\182\001\051\001\165\001\005\001\
\167\001\055\001\005\001\001\001\055\001\005\001\084\001\005\001\
\084\001\083\001\048\001\005\001\060\001\064\001\005\001\089\001\
\058\001\064\001\056\001\074\001\068\001\069\001\001\001\061\001\
\001\001\099\001\064\001\101\001\005\001\016\002\006\001\074\001\
\113\001\084\001\016\002\063\001\060\001\075\001\058\001\113\001\
\226\001\108\001\109\001\110\001\015\001\119\001\084\001\162\001\
\060\001\025\001\060\001\100\001\080\001\051\001\102\001\222\001\
\104\001\105\001\106\001\107\001\154\001\060\001\177\001\005\001\
\113\001\093\001\094\001\001\001\055\002\097\001\237\001\109\001\
\100\001\055\002\051\001\025\001\170\001\171\001\102\001\006\001\
\006\001\105\001\106\001\107\001\112\001\113\001\160\001\162\001\
\064\001\010\001\102\001\027\001\102\001\105\001\106\001\105\001\
\106\001\172\001\192\001\027\001\001\001\001\001\177\001\000\000\
\005\001\080\001\105\001\106\001\084\001\030\001\031\001\032\001\
\033\001\055\001\064\001\001\001\190\001\088\001\000\000\020\001\
\091\001\092\001\019\001\006\001\025\001\075\001\006\001\048\001\
\064\001\056\001\056\001\052\001\013\001\064\001\020\001\229\001\
\064\001\025\001\253\001\025\001\064\001\215\001\001\002\001\000\
\002\000\003\000\220\001\064\001\064\001\025\001\051\001\009\001\
\082\002\064\001\055\001\001\001\005\001\009\001\252\001\233\001\
\234\001\083\001\064\001\058\001\059\001\064\001\004\002\107\001\
\027\002\000\000\064\001\015\001\246\001\006\001\069\001\006\001\
\006\001\010\001\253\001\074\001\013\001\006\001\001\002\211\001\
\102\001\006\001\214\001\108\001\109\001\110\001\051\001\219\001\
\025\001\052\001\222\001\006\001\056\001\030\001\031\001\032\001\
\033\001\025\001\031\002\032\002\033\002\084\001\009\001\064\001\
\027\002\237\001\061\001\030\002\050\002\051\002\064\001\048\001\
\000\000\064\001\019\001\038\002\083\001\064\001\005\001\056\001\
\009\001\057\001\064\001\086\002\061\001\064\001\064\001\064\001\
\103\001\052\002\093\002\064\001\064\001\103\001\006\001\020\001\
\060\001\025\001\075\001\015\001\016\002\077\001\078\001\079\001\
\080\001\015\001\082\001\084\001\006\001\025\002\056\001\006\001\
\027\001\006\001\096\002\077\002\078\002\005\001\030\001\031\001\
\032\001\033\001\058\001\086\002\075\001\101\001\025\001\089\002\
\090\002\102\002\093\002\104\002\109\001\110\001\064\001\000\000\
\048\001\020\001\025\001\055\002\052\001\084\001\077\001\078\001\
\079\001\080\001\081\001\082\001\006\001\065\002\066\002\064\001\
\155\002\086\001\009\001\055\001\070\001\006\001\084\001\025\001\
\006\001\006\001\056\001\006\001\000\000\147\002\101\001\056\001\
\064\001\020\001\009\001\019\001\134\002\064\001\064\001\178\002\
\084\001\006\001\025\001\064\001\006\001\006\001\000\000\064\001\
\064\001\064\001\064\001\064\001\009\001\027\001\020\001\064\001\
\155\002\064\001\013\001\111\002\108\001\109\001\110\001\000\000\
\001\001\000\000\000\000\013\001\030\001\031\001\032\001\033\001\
\006\001\125\002\000\000\173\002\056\001\000\000\064\001\178\002\
\001\001\012\001\020\001\084\001\005\001\006\001\048\001\006\001\
\064\001\010\001\052\001\012\001\013\001\006\001\084\001\026\001\
\148\002\006\001\019\001\020\001\021\001\022\001\023\001\024\001\
\025\001\026\001\084\001\129\000\145\001\030\001\031\001\032\001\
\033\001\157\000\125\002\222\001\093\001\148\002\049\001\050\001\
\051\001\181\000\053\001\054\001\055\001\097\001\229\001\048\001\
\049\001\050\001\051\001\052\001\053\001\054\001\055\001\056\001\
\100\001\081\001\000\000\084\001\061\001\030\002\057\001\064\001\
\186\001\159\002\108\001\109\001\110\001\096\002\066\000\006\001\
\089\002\052\002\075\001\010\001\000\000\090\002\013\001\030\001\
\031\001\032\001\033\001\084\001\185\000\078\000\255\255\025\001\
\099\001\100\001\025\001\188\002\030\001\031\001\032\001\033\001\
\036\002\048\001\099\001\100\001\048\001\052\001\255\255\255\255\
\255\255\056\001\255\255\108\001\109\001\110\001\048\001\112\001\
\113\001\001\001\052\001\255\255\255\255\005\001\006\001\255\255\
\255\255\056\001\010\001\255\255\012\001\013\001\061\001\255\255\
\255\255\064\001\255\255\019\001\020\001\021\001\022\001\023\001\
\024\001\025\001\026\001\000\000\075\001\255\255\030\001\031\001\
\032\001\033\001\255\255\255\255\255\255\084\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\108\001\109\001\110\001\
\048\001\049\001\050\001\051\001\052\001\053\001\054\001\055\001\
\056\001\255\255\108\001\109\001\110\001\061\001\255\255\255\255\
\064\001\255\255\255\255\255\255\255\255\006\001\255\255\255\255\
\255\255\010\001\000\000\075\001\013\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\084\001\255\255\255\255\255\255\
\025\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\006\001\099\001\100\001\255\255\010\001\255\255\
\255\255\013\001\255\255\255\255\108\001\109\001\110\001\001\001\
\112\001\113\001\255\255\005\001\006\001\025\001\255\255\056\001\
\010\001\255\255\012\001\013\001\061\001\255\255\255\255\064\001\
\255\255\019\001\020\001\021\001\022\001\023\001\024\001\025\001\
\026\001\255\255\075\001\255\255\030\001\031\001\032\001\033\001\
\255\255\255\255\255\255\084\001\056\001\255\255\255\255\255\255\
\255\255\061\001\255\255\255\255\064\001\255\255\048\001\049\001\
\050\001\051\001\052\001\053\001\054\001\055\001\056\001\075\001\
\255\255\255\255\255\255\061\001\025\001\255\255\064\001\255\255\
\084\001\030\001\031\001\032\001\033\001\255\255\255\255\255\255\
\000\000\075\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\084\001\048\001\255\255\255\255\255\255\052\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\006\001\099\001\100\001\255\255\010\001\255\255\255\255\013\001\
\255\255\255\255\108\001\109\001\110\001\001\001\112\001\113\001\
\255\255\005\001\006\001\025\001\255\255\255\255\010\001\255\255\
\012\001\013\001\255\255\255\255\255\255\255\255\255\255\019\001\
\020\001\021\001\022\001\023\001\024\001\025\001\026\001\255\255\
\255\255\255\255\030\001\031\001\032\001\033\001\255\255\108\001\
\109\001\110\001\056\001\255\255\255\255\255\255\255\255\061\001\
\255\255\255\255\064\001\255\255\048\001\049\001\050\001\051\001\
\052\001\053\001\054\001\055\001\056\001\075\001\255\255\255\255\
\255\255\061\001\255\255\255\255\064\001\255\255\084\001\255\255\
\255\255\006\001\255\255\255\255\255\255\010\001\000\000\075\001\
\013\001\255\255\255\255\006\001\255\255\255\255\255\255\255\255\
\084\001\255\255\255\255\255\255\025\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\099\001\
\100\001\255\255\255\255\030\001\031\001\032\001\033\001\255\255\
\108\001\109\001\110\001\001\001\112\001\113\001\255\255\005\001\
\006\001\255\255\255\255\056\001\010\001\048\001\012\001\013\001\
\061\001\052\001\255\255\064\001\255\255\019\001\020\001\021\001\
\022\001\023\001\024\001\025\001\026\001\255\255\075\001\255\255\
\030\001\031\001\032\001\033\001\255\255\255\255\255\255\084\001\
\255\255\255\255\255\255\255\255\255\255\006\001\255\255\255\255\
\255\255\255\255\048\001\049\001\050\001\051\001\052\001\053\001\
\054\001\055\001\056\001\255\255\255\255\255\255\255\255\061\001\
\255\255\255\255\064\001\255\255\255\255\030\001\031\001\032\001\
\033\001\108\001\109\001\110\001\000\000\075\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\084\001\048\001\
\255\255\255\255\255\255\052\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\099\001\100\001\255\255\
\255\255\255\255\255\255\255\255\000\000\255\255\108\001\109\001\
\110\001\001\001\112\001\113\001\255\255\005\001\006\001\255\255\
\255\255\255\255\010\001\255\255\012\001\013\001\255\255\255\255\
\255\255\255\255\255\255\019\001\020\001\021\001\022\001\023\001\
\024\001\025\001\026\001\255\255\255\255\255\255\030\001\031\001\
\032\001\033\001\255\255\108\001\109\001\110\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\006\001\255\255\
\048\001\049\001\050\001\051\001\052\001\053\001\054\001\055\001\
\056\001\255\255\255\255\255\255\255\255\061\001\255\255\255\255\
\064\001\255\255\255\255\255\255\255\255\000\000\030\001\031\001\
\032\001\033\001\255\255\075\001\255\255\255\255\255\255\006\001\
\255\255\255\255\255\255\255\255\084\001\255\255\255\255\255\255\
\048\001\255\255\255\255\255\255\052\001\255\255\255\255\255\255\
\255\255\255\255\255\255\099\001\100\001\000\000\255\255\030\001\
\031\001\032\001\033\001\255\255\108\001\109\001\110\001\001\001\
\112\001\113\001\255\255\005\001\006\001\255\255\255\255\255\255\
\010\001\048\001\012\001\013\001\255\255\052\001\255\255\255\255\
\255\255\019\001\020\001\021\001\022\001\023\001\024\001\025\001\
\026\001\255\255\255\255\255\255\030\001\031\001\032\001\033\001\
\255\255\255\255\255\255\255\255\108\001\109\001\110\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\048\001\049\001\
\050\001\051\001\052\001\053\001\054\001\055\001\056\001\255\255\
\255\255\255\255\255\255\061\001\255\255\255\255\064\001\255\255\
\255\255\000\000\255\255\255\255\255\255\108\001\109\001\110\001\
\255\255\075\001\255\255\255\255\255\255\006\001\255\255\255\255\
\255\255\255\255\084\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\099\001\100\001\255\255\255\255\030\001\031\001\032\001\
\033\001\255\255\108\001\109\001\110\001\001\001\112\001\113\001\
\255\255\005\001\006\001\255\255\255\255\255\255\010\001\048\001\
\012\001\013\001\255\255\052\001\255\255\255\255\255\255\255\255\
\020\001\021\001\022\001\023\001\024\001\025\001\026\001\255\255\
\255\255\255\255\030\001\031\001\032\001\033\001\255\255\255\255\
\255\255\255\255\006\001\255\255\255\255\255\255\010\001\255\255\
\255\255\013\001\255\255\255\255\048\001\049\001\050\001\051\001\
\052\001\053\001\054\001\055\001\056\001\025\001\255\255\255\255\
\255\255\061\001\000\000\255\255\064\001\255\255\255\255\255\255\
\255\255\255\255\255\255\108\001\109\001\110\001\255\255\075\001\
\255\255\255\255\255\255\255\255\048\001\255\255\255\255\255\255\
\084\001\255\255\255\255\255\255\056\001\255\255\255\255\255\255\
\255\255\061\001\000\000\255\255\064\001\255\255\255\255\099\001\
\100\001\255\255\255\255\255\255\255\255\255\255\255\255\075\001\
\108\001\109\001\110\001\006\001\112\001\113\001\255\255\010\001\
\084\001\012\001\013\001\255\255\255\255\255\255\255\255\255\255\
\019\001\020\001\021\001\022\001\023\001\024\001\025\001\026\001\
\255\255\255\255\255\255\030\001\031\001\032\001\033\001\255\255\
\255\255\255\255\255\255\006\001\255\255\255\255\006\001\010\001\
\255\255\255\255\013\001\255\255\255\255\048\001\049\001\050\001\
\051\001\052\001\053\001\054\001\055\001\056\001\025\001\255\255\
\255\255\255\255\061\001\000\000\255\255\064\001\030\001\031\001\
\032\001\033\001\255\255\255\255\255\255\255\255\255\255\255\255\
\075\001\255\255\006\001\255\255\255\255\048\001\255\255\255\255\
\048\001\084\001\255\255\255\255\052\001\056\001\255\255\255\255\
\255\255\255\255\061\001\000\000\255\255\064\001\255\255\255\255\
\099\001\100\001\030\001\031\001\032\001\033\001\255\255\255\255\
\075\001\108\001\109\001\110\001\255\255\112\001\113\001\006\001\
\255\255\084\001\255\255\010\001\048\001\012\001\013\001\255\255\
\052\001\255\255\255\255\255\255\019\001\020\001\021\001\022\001\
\023\001\024\001\025\001\026\001\255\255\255\255\255\255\030\001\
\031\001\032\001\033\001\255\255\108\001\109\001\110\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\048\001\049\001\050\001\051\001\052\001\053\001\054\001\
\055\001\056\001\255\255\255\255\000\000\255\255\061\001\255\255\
\255\255\064\001\255\255\255\255\255\255\255\255\255\255\255\255\
\108\001\109\001\110\001\255\255\075\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\084\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\099\001\100\001\255\255\255\255\
\255\255\255\255\255\255\001\001\255\255\108\001\109\001\110\001\
\006\001\112\001\113\001\255\255\010\001\255\255\012\001\013\001\
\255\255\255\255\255\255\255\255\255\255\019\001\020\001\021\001\
\022\001\023\001\024\001\025\001\026\001\255\255\255\255\255\255\
\030\001\031\001\032\001\033\001\255\255\255\255\255\255\255\255\
\006\001\255\255\255\255\255\255\010\001\255\255\255\255\013\001\
\255\255\255\255\048\001\049\001\050\001\051\001\052\001\053\001\
\054\001\255\255\056\001\025\001\255\255\000\000\255\255\061\001\
\030\001\031\001\064\001\033\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\075\001\255\255\255\255\
\255\255\255\255\048\001\255\255\255\255\255\255\084\001\255\255\
\255\255\255\255\056\001\255\255\255\255\255\255\255\255\061\001\
\255\255\255\255\064\001\255\255\255\255\099\001\100\001\255\255\
\255\255\255\255\255\255\255\255\255\255\075\001\108\001\109\001\
\110\001\006\001\112\001\113\001\255\255\010\001\084\001\012\001\
\013\001\255\255\255\255\255\255\255\255\255\255\019\001\020\001\
\021\001\022\001\023\001\024\001\025\001\026\001\255\255\255\255\
\255\255\030\001\031\001\032\001\033\001\255\255\255\255\109\001\
\255\255\006\001\255\255\255\255\255\255\010\001\255\255\255\255\
\013\001\255\255\255\255\048\001\049\001\050\001\051\001\052\001\
\053\001\054\001\055\001\056\001\025\001\002\001\000\000\255\255\
\061\001\030\001\031\001\064\001\033\001\255\255\255\255\255\255\
\255\255\255\255\015\001\016\001\017\001\018\001\075\001\255\255\
\255\255\255\255\255\255\048\001\255\255\255\255\255\255\084\001\
\255\255\255\255\255\255\056\001\255\255\255\255\255\255\255\255\
\061\001\255\255\255\255\064\001\255\255\255\255\099\001\100\001\
\255\255\255\255\255\255\255\255\255\255\001\001\075\001\108\001\
\109\001\110\001\006\001\112\001\113\001\255\255\010\001\084\001\
\012\001\013\001\255\255\255\255\255\255\255\255\255\255\019\001\
\020\001\021\001\022\001\023\001\024\001\025\001\026\001\000\000\
\255\255\255\255\030\001\031\001\032\001\033\001\255\255\255\255\
\255\255\255\255\087\001\088\001\089\001\090\001\091\001\092\001\
\093\001\094\001\095\001\096\001\048\001\049\001\050\001\051\001\
\052\001\053\001\054\001\255\255\056\001\001\001\002\001\255\255\
\255\255\061\001\255\255\255\255\064\001\255\255\255\255\255\255\
\255\255\255\255\014\001\015\001\016\001\017\001\018\001\075\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\084\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\000\000\255\255\255\255\255\255\255\255\255\255\099\001\
\100\001\255\255\255\255\255\255\255\255\255\255\001\001\255\255\
\108\001\109\001\110\001\006\001\112\001\113\001\255\255\010\001\
\255\255\012\001\013\001\255\255\255\255\255\255\255\255\255\255\
\019\001\020\001\021\001\022\001\023\001\024\001\025\001\026\001\
\255\255\255\255\255\255\030\001\031\001\032\001\033\001\255\255\
\255\255\255\255\255\255\087\001\088\001\089\001\090\001\091\001\
\092\001\093\001\094\001\095\001\096\001\048\001\049\001\050\001\
\255\255\052\001\053\001\054\001\000\000\056\001\001\001\002\001\
\255\255\255\255\061\001\255\255\255\255\064\001\255\255\255\255\
\255\255\255\255\255\255\255\255\015\001\016\001\017\001\018\001\
\075\001\255\255\255\255\255\255\255\255\025\001\255\255\255\255\
\255\255\084\001\030\001\031\001\032\001\033\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\099\001\100\001\255\255\255\255\048\001\255\255\255\255\255\255\
\052\001\108\001\109\001\110\001\006\001\112\001\113\001\255\255\
\010\001\255\255\012\001\013\001\255\255\255\255\000\000\255\255\
\255\255\019\001\020\001\021\001\022\001\023\001\024\001\025\001\
\026\001\255\255\255\255\255\255\030\001\031\001\032\001\033\001\
\255\255\255\255\255\255\255\255\087\001\088\001\089\001\090\001\
\091\001\092\001\093\001\094\001\095\001\096\001\048\001\049\001\
\050\001\255\255\052\001\053\001\054\001\255\255\056\001\255\255\
\108\001\109\001\110\001\061\001\255\255\255\255\064\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\075\001\255\255\255\255\255\255\006\001\255\255\255\255\
\000\000\010\001\084\001\255\255\013\001\255\255\255\255\255\255\
\255\255\255\255\019\001\020\001\021\001\022\001\023\001\024\001\
\025\001\099\001\100\001\255\255\255\255\030\001\031\001\032\001\
\033\001\255\255\108\001\109\001\110\001\255\255\112\001\113\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\048\001\
\049\001\050\001\051\001\052\001\053\001\054\001\255\255\056\001\
\255\255\255\255\255\255\255\255\061\001\255\255\255\255\064\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\006\001\
\255\255\255\255\075\001\010\001\000\000\255\255\013\001\255\255\
\255\255\255\255\255\255\084\001\019\001\020\001\021\001\022\001\
\023\001\024\001\025\001\255\255\255\255\255\255\255\255\030\001\
\031\001\032\001\033\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\108\001\109\001\110\001\255\255\112\001\
\113\001\048\001\049\001\050\001\051\001\052\001\053\001\054\001\
\255\255\056\001\255\255\255\255\255\255\255\255\061\001\255\255\
\255\255\064\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\006\001\255\255\075\001\255\255\010\001\000\000\
\255\255\013\001\255\255\255\255\255\255\084\001\255\255\019\001\
\020\001\021\001\022\001\023\001\024\001\025\001\255\255\255\255\
\255\255\255\255\030\001\031\001\032\001\033\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\108\001\109\001\110\001\
\255\255\112\001\113\001\255\255\048\001\049\001\050\001\051\001\
\052\001\053\001\054\001\255\255\056\001\255\255\255\255\255\255\
\255\255\061\001\255\255\255\255\064\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\006\001\255\255\255\255\075\001\
\010\001\000\000\255\255\013\001\255\255\255\255\255\255\255\255\
\084\001\019\001\020\001\021\001\022\001\023\001\024\001\025\001\
\255\255\255\255\255\255\255\255\030\001\031\001\032\001\033\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\108\001\109\001\110\001\255\255\112\001\113\001\048\001\049\001\
\050\001\051\001\052\001\053\001\054\001\255\255\056\001\255\255\
\255\255\255\255\255\255\061\001\255\255\255\255\064\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\006\001\255\255\
\255\255\075\001\010\001\000\000\255\255\013\001\255\255\255\255\
\255\255\255\255\084\001\019\001\020\001\021\001\022\001\023\001\
\024\001\025\001\255\255\255\255\255\255\255\255\030\001\031\001\
\032\001\033\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\108\001\109\001\110\001\255\255\112\001\113\001\
\048\001\049\001\050\001\051\001\052\001\053\001\054\001\255\255\
\056\001\255\255\255\255\255\255\255\255\061\001\255\255\255\255\
\064\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\006\001\075\001\255\255\000\000\010\001\255\255\
\255\255\013\001\255\255\255\255\084\001\255\255\255\255\019\001\
\020\001\021\001\022\001\023\001\024\001\025\001\255\255\255\255\
\255\255\255\255\030\001\031\001\032\001\033\001\255\255\255\255\
\255\255\255\255\255\255\255\255\108\001\109\001\110\001\255\255\
\112\001\113\001\255\255\255\255\048\001\049\001\050\001\051\001\
\052\001\053\001\054\001\255\255\056\001\255\255\255\255\255\255\
\255\255\061\001\255\255\255\255\064\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\006\001\255\255\075\001\
\000\000\010\001\255\255\255\255\013\001\255\255\255\255\255\255\
\084\001\255\255\019\001\020\001\021\001\022\001\023\001\024\001\
\025\001\255\255\255\255\255\255\255\255\030\001\031\001\032\001\
\033\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\108\001\109\001\110\001\255\255\112\001\113\001\255\255\048\001\
\049\001\050\001\051\001\052\001\053\001\054\001\255\255\056\001\
\255\255\255\255\255\255\255\255\061\001\255\255\255\255\064\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\006\001\
\255\255\255\255\075\001\010\001\000\000\255\255\013\001\255\255\
\255\255\255\255\255\255\084\001\019\001\020\001\021\001\022\001\
\023\001\024\001\025\001\255\255\255\255\255\255\255\255\030\001\
\031\001\032\001\033\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\108\001\109\001\110\001\255\255\112\001\
\113\001\048\001\049\001\050\001\051\001\052\001\053\001\054\001\
\255\255\056\001\255\255\255\255\255\255\255\255\061\001\255\255\
\255\255\064\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\006\001\255\255\255\255\075\001\010\001\000\000\255\255\
\013\001\255\255\255\255\255\255\255\255\084\001\019\001\020\001\
\021\001\022\001\023\001\024\001\025\001\255\255\255\255\255\255\
\255\255\030\001\031\001\032\001\033\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\108\001\109\001\110\001\
\255\255\112\001\113\001\048\001\049\001\050\001\051\001\052\001\
\053\001\054\001\255\255\056\001\255\255\255\255\255\255\255\255\
\061\001\255\255\255\255\064\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\006\001\255\255\255\255\075\001\010\001\
\000\000\255\255\013\001\255\255\255\255\255\255\255\255\084\001\
\019\001\020\001\021\001\022\001\023\001\024\001\025\001\255\255\
\255\255\255\255\255\255\030\001\031\001\032\001\033\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\108\001\
\109\001\110\001\255\255\112\001\113\001\048\001\049\001\050\001\
\051\001\052\001\053\001\054\001\255\255\056\001\255\255\255\255\
\255\255\255\255\061\001\255\255\255\255\064\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\006\001\255\255\
\075\001\255\255\010\001\000\000\255\255\013\001\255\255\255\255\
\255\255\084\001\255\255\019\001\020\001\021\001\022\001\023\001\
\024\001\025\001\255\255\255\255\255\255\255\255\030\001\031\001\
\032\001\033\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\108\001\109\001\110\001\255\255\112\001\113\001\255\255\
\048\001\049\001\050\001\051\001\052\001\053\001\054\001\255\255\
\056\001\255\255\255\255\255\255\255\255\061\001\255\255\255\255\
\064\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\006\001\075\001\255\255\000\000\010\001\255\255\
\255\255\013\001\255\255\255\255\084\001\255\255\255\255\019\001\
\020\001\021\001\022\001\023\001\024\001\025\001\255\255\255\255\
\255\255\255\255\030\001\031\001\032\001\033\001\255\255\255\255\
\255\255\255\255\255\255\255\255\108\001\109\001\110\001\255\255\
\112\001\113\001\255\255\255\255\048\001\049\001\050\001\051\001\
\052\001\053\001\054\001\255\255\056\001\255\255\255\255\255\255\
\255\255\061\001\255\255\255\255\064\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\006\001\255\255\255\255\075\001\
\010\001\000\000\255\255\013\001\255\255\255\255\255\255\255\255\
\084\001\019\001\020\001\021\001\022\001\023\001\024\001\025\001\
\255\255\255\255\255\255\255\255\030\001\031\001\032\001\033\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\108\001\109\001\110\001\255\255\112\001\113\001\048\001\049\001\
\050\001\000\000\052\001\255\255\255\255\255\255\056\001\255\255\
\255\255\255\255\255\255\061\001\255\255\255\255\064\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\006\001\255\255\
\255\255\075\001\010\001\255\255\255\255\013\001\255\255\255\255\
\255\255\255\255\084\001\019\001\020\001\021\001\022\001\023\001\
\024\001\025\001\000\000\255\255\255\255\255\255\030\001\031\001\
\032\001\033\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\108\001\109\001\110\001\255\255\112\001\113\001\
\048\001\049\001\050\001\255\255\052\001\255\255\255\255\255\255\
\056\001\255\255\255\255\255\255\255\255\061\001\255\255\255\255\
\064\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\006\001\255\255\075\001\255\255\010\001\255\255\255\255\
\013\001\255\255\255\255\255\255\084\001\255\255\019\001\020\001\
\021\001\022\001\023\001\024\001\025\001\255\255\255\255\255\255\
\255\255\030\001\031\001\032\001\033\001\255\255\255\255\255\255\
\030\001\031\001\032\001\033\001\108\001\109\001\110\001\255\255\
\112\001\113\001\255\255\048\001\255\255\255\255\255\255\052\001\
\255\255\255\255\048\001\056\001\255\255\255\255\052\001\255\255\
\061\001\255\255\255\255\064\001\255\255\255\255\255\255\061\001\
\255\255\255\255\255\255\006\001\255\255\255\255\075\001\010\001\
\255\255\255\255\013\001\255\255\255\255\255\255\255\255\084\001\
\019\001\020\001\021\001\022\001\023\001\024\001\025\001\255\255\
\255\255\255\255\255\255\030\001\031\001\032\001\033\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\108\001\
\109\001\110\001\255\255\112\001\113\001\048\001\108\001\109\001\
\110\001\052\001\255\255\255\255\255\255\056\001\255\255\255\255\
\255\255\255\255\061\001\025\001\255\255\064\001\255\255\255\255\
\030\001\031\001\032\001\033\001\255\255\255\255\255\255\006\001\
\075\001\255\255\255\255\010\001\255\255\255\255\013\001\255\255\
\255\255\084\001\048\001\255\255\255\255\255\255\052\001\255\255\
\255\255\255\255\025\001\255\255\255\255\255\255\255\255\030\001\
\031\001\032\001\033\001\255\255\255\255\255\255\255\255\255\255\
\255\255\108\001\109\001\110\001\255\255\112\001\113\001\006\001\
\255\255\048\001\255\255\010\001\255\255\052\001\013\001\255\255\
\255\255\056\001\255\255\255\255\255\255\255\255\061\001\255\255\
\255\255\064\001\025\001\255\255\255\255\255\255\255\255\030\001\
\031\001\032\001\033\001\255\255\075\001\255\255\108\001\109\001\
\110\001\030\001\031\001\032\001\033\001\084\001\255\255\255\255\
\006\001\048\001\255\255\255\255\010\001\052\001\255\255\013\001\
\255\255\056\001\255\255\048\001\255\255\255\255\061\001\052\001\
\255\255\064\001\255\255\025\001\255\255\108\001\109\001\110\001\
\030\001\031\001\032\001\033\001\075\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\084\001\255\255\255\255\
\255\255\255\255\048\001\255\255\255\255\255\255\255\255\084\001\
\255\255\255\255\056\001\255\255\255\255\255\255\255\255\061\001\
\255\255\255\255\064\001\255\255\255\255\108\001\109\001\110\001\
\255\255\255\255\255\255\255\255\255\255\075\001\255\255\108\001\
\109\001\110\001\255\255\255\255\255\255\255\255\084\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\108\001\109\001\
\110\001\001\001\002\001\003\001\004\001\005\001\006\001\007\001\
\008\001\009\001\010\001\011\001\012\001\013\001\014\001\015\001\
\016\001\017\001\018\001\019\001\020\001\021\001\022\001\023\001\
\024\001\025\001\026\001\027\001\028\001\029\001\030\001\031\001\
\032\001\033\001\034\001\035\001\036\001\037\001\038\001\039\001\
\040\001\041\001\042\001\043\001\044\001\045\001\046\001\047\001\
\048\001\049\001\050\001\051\001\052\001\053\001\054\001\055\001\
\056\001\057\001\058\001\059\001\060\001\061\001\062\001\063\001\
\064\001\065\001\066\001\067\001\068\001\069\001\070\001\071\001\
\072\001\255\255\074\001\075\001\076\001\077\001\078\001\255\255\
\255\255\081\001\082\001\083\001\084\001\085\001\255\255\087\001\
\088\001\089\001\090\001\091\001\092\001\093\001\094\001\095\001\
\096\001\097\001\098\001\099\001\100\001\101\001\102\001\103\001\
\104\001\105\001\106\001\107\001\108\001\109\001\110\001\111\001\
\112\001\113\001\114\001\115\001\116\001\117\001\001\001\002\001\
\003\001\004\001\005\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\015\001\016\001\017\001\018\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\028\001\029\001\255\255\255\255\255\255\255\255\034\001\
\035\001\036\001\037\001\038\001\039\001\040\001\041\001\042\001\
\043\001\044\001\045\001\046\001\255\255\255\255\049\001\050\001\
\051\001\052\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\065\001\066\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\083\001\255\255\255\255\255\255\087\001\088\001\089\001\090\001\
\091\001\092\001\093\001\094\001\095\001\096\001\097\001\098\001\
\255\255\255\255\255\255\255\255\255\255\001\001\002\001\003\001\
\004\001\005\001\255\255\255\255\111\001\255\255\255\255\114\001\
\115\001\116\001\117\001\015\001\016\001\017\001\018\001\012\001\
\255\255\255\255\255\255\255\255\255\255\255\255\019\001\020\001\
\021\001\022\001\023\001\024\001\255\255\026\001\034\001\035\001\
\036\001\037\001\038\001\039\001\040\001\041\001\042\001\043\001\
\044\001\045\001\046\001\255\255\255\255\049\001\050\001\051\001\
\052\001\255\255\255\255\255\255\049\001\050\001\051\001\255\255\
\053\001\054\001\055\001\255\255\255\255\065\001\066\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\083\001\
\255\255\255\255\255\255\087\001\088\001\089\001\090\001\091\001\
\092\001\093\001\094\001\095\001\096\001\097\001\098\001\001\001\
\255\255\003\001\004\001\005\001\255\255\255\255\099\001\100\001\
\255\255\255\255\255\255\111\001\255\255\255\255\114\001\255\255\
\116\001\117\001\255\255\112\001\113\001\255\255\255\255\255\255\
\255\255\255\255\028\001\029\001\255\255\255\255\255\255\255\255\
\034\001\035\001\036\001\037\001\038\001\039\001\040\001\041\001\
\042\001\043\001\044\001\045\001\046\001\255\255\255\255\049\001\
\050\001\051\001\052\001\001\001\002\001\255\255\255\255\005\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\065\001\
\066\001\015\001\016\001\017\001\018\001\071\001\255\255\030\001\
\031\001\032\001\033\001\255\255\030\001\031\001\032\001\033\001\
\255\255\083\001\255\255\001\001\255\255\003\001\004\001\005\001\
\255\255\048\001\255\255\255\255\255\255\052\001\048\001\097\001\
\098\001\255\255\052\001\255\255\255\255\051\001\255\255\255\255\
\255\255\064\001\255\255\255\255\255\255\111\001\028\001\029\001\
\114\001\115\001\116\001\117\001\034\001\035\001\036\001\037\001\
\038\001\039\001\040\001\041\001\042\001\043\001\044\001\045\001\
\046\001\255\255\084\001\049\001\050\001\051\001\052\001\255\255\
\255\255\087\001\088\001\089\001\090\001\091\001\092\001\093\001\
\094\001\095\001\096\001\065\001\066\001\108\001\109\001\110\001\
\255\255\071\001\108\001\109\001\110\001\255\255\255\255\030\001\
\031\001\032\001\033\001\255\255\255\255\083\001\255\255\001\001\
\255\255\003\001\004\001\005\001\255\255\255\255\255\255\255\255\
\255\255\048\001\255\255\097\001\098\001\052\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\111\001\028\001\029\001\114\001\115\001\116\001\117\001\
\034\001\035\001\036\001\037\001\038\001\039\001\040\001\041\001\
\042\001\043\001\044\001\045\001\046\001\255\255\255\255\049\001\
\050\001\051\001\052\001\255\255\255\255\255\255\255\255\255\255\
\255\255\030\001\031\001\032\001\033\001\255\255\255\255\065\001\
\066\001\255\255\255\255\255\255\255\255\108\001\109\001\110\001\
\255\255\255\255\255\255\048\001\255\255\255\255\255\255\052\001\
\255\255\083\001\255\255\001\001\255\255\003\001\004\001\005\001\
\255\255\255\255\255\255\064\001\255\255\255\255\255\255\097\001\
\098\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\111\001\028\001\029\001\
\114\001\115\001\116\001\117\001\034\001\035\001\036\001\037\001\
\038\001\039\001\040\001\041\001\042\001\043\001\044\001\045\001\
\046\001\255\255\255\255\049\001\050\001\051\001\052\001\108\001\
\109\001\110\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\065\001\066\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\083\001\255\255\001\001\
\255\255\003\001\004\001\005\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\097\001\098\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\111\001\255\255\255\255\114\001\115\001\116\001\117\001\
\034\001\035\001\036\001\037\001\038\001\039\001\040\001\041\001\
\042\001\043\001\044\001\045\001\046\001\255\255\255\255\049\001\
\050\001\051\001\052\001\001\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\065\001\
\066\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\083\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\097\001\
\098\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\057\001\058\001\111\001\060\001\061\001\
\114\001\063\001\116\001\117\001\255\255\067\001\068\001\069\001\
\070\001\255\255\072\001\073\001\255\255\255\255\012\001\077\001\
\078\001\079\001\080\001\255\255\082\001\019\001\020\001\021\001\
\022\001\023\001\024\001\255\255\026\001\255\255\255\255\255\255\
\030\001\031\001\032\001\033\001\255\255\255\255\255\255\101\001\
\102\001\255\255\255\255\105\001\255\255\107\001\255\255\255\255\
\255\255\255\255\048\001\049\001\050\001\255\255\052\001\053\001\
\054\001\055\001\255\255\255\255\255\255\255\255\255\255\061\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\099\001\100\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\108\001\109\001\
\110\001\255\255\112\001\113\001"

let yynames_const = "\
  LPAR\000\
  RPAR\000\
  IF\000\
  ELSE\000\
  COLON\000\
  COLON2\000\
  COLONCOLON\000\
  DOT\000\
  DOTDOT\000\
  DOTDOTDOT\000\
  INT\000\
  INTEGER\000\
  REAL\000\
  FLOAT\000\
  LT\000\
  GT\000\
  LE\000\
  GE\000\
  EQ\000\
  NE\000\
  COMMA\000\
  ARROW\000\
  EQUAL\000\
  FORALL\000\
  EXISTS\000\
  IFF\000\
  IMPLIES\000\
  AND\000\
  OR\000\
  NOT\000\
  SEPARATED\000\
  TRUE\000\
  FALSE\000\
  OLD\000\
  AT\000\
  RESULT\000\
  BLOCK_LENGTH\000\
  BASE_ADDR\000\
  VALID\000\
  VALID_INDEX\000\
  VALID_RANGE\000\
  FRESH\000\
  DOLLAR\000\
  QUESTION\000\
  MINUS\000\
  PLUS\000\
  STAR\000\
  AMP\000\
  SLASH\000\
  PERCENT\000\
  LSQUARE\000\
  RSQUARE\000\
  EOF\000\
  GLOBAL\000\
  INVARIANT\000\
  VARIANT\000\
  DECREASES\000\
  FOR\000\
  LABEL\000\
  ASSERT\000\
  SEMICOLON\000\
  NULL\000\
  EMPTY\000\
  REQUIRES\000\
  ENSURES\000\
  ASSIGNS\000\
  LOOP\000\
  NOTHING\000\
  SLICE\000\
  IMPACT\000\
  PRAGMA\000\
  FROM\000\
  READS\000\
  LOGIC\000\
  PREDICATE\000\
  INDUCTIVE\000\
  AXIOMATIC\000\
  AXIOM\000\
  LEMMA\000\
  LBRACE\000\
  RBRACE\000\
  GHOST\000\
  CASE\000\
  VOID\000\
  CHAR\000\
  SIGNED\000\
  UNSIGNED\000\
  SHORT\000\
  LONG\000\
  DOUBLE\000\
  STRUCT\000\
  ENUM\000\
  UNION\000\
  BSUNION\000\
  INTER\000\
  LTCOLON\000\
  COLONGT\000\
  TYPE\000\
  BEHAVIOR\000\
  BEHAVIORS\000\
  ASSUMES\000\
  COMPLETE\000\
  DISJOINT\000\
  TERMINATES\000\
  HAT\000\
  HATHAT\000\
  PIPE\000\
  TILDE\000\
  GTGT\000\
  LTLT\000\
  SIZEOF\000\
  LAMBDA\000\
  TYPEOF\000\
  BSTYPE\000\
  "

let yynames_block = "\
  IDENTIFIER\000\
  TYPENAME\000\
  STRING_LITERAL\000\
  CONSTANT\000\
  "

let yyact = [|
  (fun _ -> failwith "parser")
; (fun __caml_parser_env ->
    Obj.repr(
# 107 "cil/src/logic/logic_parser.mly"
            ( enter_kw_c_mode () )
# 1913 "cil/src/logic/logic_parser.ml"
               : 'enter_kw_c_mode))
; (fun __caml_parser_env ->
    Obj.repr(
# 110 "cil/src/logic/logic_parser.mly"
            ( exit_kw_c_mode () )
# 1919 "cil/src/logic/logic_parser.ml"
               : 'exit_kw_c_mode))
; (fun __caml_parser_env ->
    Obj.repr(
# 116 "cil/src/logic/logic_parser.mly"
                ( [] )
# 1925 "cil/src/logic/logic_parser.ml"
               : 'lexpr_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'ne_lexpr_list) in
    Obj.repr(
# 117 "cil/src/logic/logic_parser.mly"
                 ( _1 )
# 1932 "cil/src/logic/logic_parser.ml"
               : 'lexpr_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 121 "cil/src/logic/logic_parser.mly"
                           ( [_1] )
# 1939 "cil/src/logic/logic_parser.ml"
               : 'ne_lexpr_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Logic_ptree.lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'ne_lexpr_list) in
    Obj.repr(
# 122 "cil/src/logic/logic_parser.mly"
                            ( _1 :: _3 )
# 1947 "cil/src/logic/logic_parser.ml"
               : 'ne_lexpr_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 126 "cil/src/logic/logic_parser.mly"
                                ( _1 )
# 1954 "cil/src/logic/logic_parser.ml"
               : 'lexpr_rel))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr_inner) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'rel_list) in
    Obj.repr(
# 128 "cil/src/logic/logic_parser.mly"
      ( let rel, rhs, _, oth_rel = _2 in
        let loc = loc_start _1, loc_end rhs in
        let relation = loc_info loc (PLrel(_1,rel,rhs)) in
        match oth_rel with
            None -> relation
          | Some oth_relation -> info (PLand(relation,oth_relation))
      )
# 1968 "cil/src/logic/logic_parser.ml"
               : 'lexpr_rel))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'string) in
    Obj.repr(
# 137 "cil/src/logic/logic_parser.mly"
           (
      let (is_wide,content) = _1 in
      let cst = if is_wide then
        WStringConstant content
      else
        StringConstant content
      in
      info (PLconstant cst)
    )
# 1983 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 146 "cil/src/logic/logic_parser.mly"
                    ( info (PLnot _2) )
# 1990 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    Obj.repr(
# 147 "cil/src/logic/logic_parser.mly"
         ( info PLtrue )
# 1996 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    Obj.repr(
# 148 "cil/src/logic/logic_parser.mly"
          ( info PLfalse )
# 2002 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    Obj.repr(
# 149 "cil/src/logic/logic_parser.mly"
                          ( info (PLvalid (_3)) )
# 2009 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 3 : Logic_ptree.lexpr) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    Obj.repr(
# 150 "cil/src/logic/logic_parser.mly"
                                            ( info (PLvalid_index (_3,_5)) )
# 2017 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 5 : Logic_ptree.lexpr) in
    let _5 = (Parsing.peek_val __caml_parser_env 3 : Logic_ptree.lexpr) in
    let _7 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    Obj.repr(
# 152 "cil/src/logic/logic_parser.mly"
      ( info (PLvalid_range (_3,_5,_7)) )
# 2026 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    Obj.repr(
# 153 "cil/src/logic/logic_parser.mly"
                          ( info (PLfresh (_3)) )
# 2033 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    Obj.repr(
# 154 "cil/src/logic/logic_parser.mly"
         ( info PLnull )
# 2039 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.constant) in
    Obj.repr(
# 155 "cil/src/logic/logic_parser.mly"
             ( info (PLconstant _1) )
# 2046 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 156 "cil/src/logic/logic_parser.mly"
                                 ( info (PLbinop (_1, Badd, _3)) )
# 2054 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 157 "cil/src/logic/logic_parser.mly"
                                  ( info (PLbinop (_1, Bsub, _3)) )
# 2062 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 158 "cil/src/logic/logic_parser.mly"
                                 ( info (PLbinop (_1, Bmul, _3)) )
# 2070 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 159 "cil/src/logic/logic_parser.mly"
                                  ( info (PLbinop (_1, Bdiv, _3)) )
# 2078 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 160 "cil/src/logic/logic_parser.mly"
                                    ( info (PLbinop (_1, Bmod, _3)) )
# 2086 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'identifier) in
    Obj.repr(
# 161 "cil/src/logic/logic_parser.mly"
                                 ( info (PLarrow (_1, _3)) )
# 2094 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'identifier) in
    Obj.repr(
# 162 "cil/src/logic/logic_parser.mly"
                               ( info (PLdot (_1, _3)) )
# 2102 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'range) in
    Obj.repr(
# 163 "cil/src/logic/logic_parser.mly"
                                      ( info (PLarrget (_1, _3)) )
# 2110 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    Obj.repr(
# 164 "cil/src/logic/logic_parser.mly"
                                      ( info (PLarrget (_1, _3)) )
# 2118 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 165 "cil/src/logic/logic_parser.mly"
                                        ( info (PLunop (Uminus, _2)) )
# 2125 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 166 "cil/src/logic/logic_parser.mly"
                                       ( _2 )
# 2132 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 167 "cil/src/logic/logic_parser.mly"
                      ( info (PLunop (Ubw_not, _2)) )
# 2139 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 168 "cil/src/logic/logic_parser.mly"
                     ( info (PLunop (Ustar, _2)) )
# 2146 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 169 "cil/src/logic/logic_parser.mly"
                    ( info (PLunop (Uamp, _2)) )
# 2153 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    Obj.repr(
# 170 "cil/src/logic/logic_parser.mly"
                           ( info (PLsizeofE _3) )
# 2160 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'logic_type_not_id) in
    Obj.repr(
# 171 "cil/src/logic/logic_parser.mly"
                                       ( info (PLsizeof _3) )
# 2167 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    Obj.repr(
# 172 "cil/src/logic/logic_parser.mly"
                        ( info (PLold _3) )
# 2174 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 3 : Logic_ptree.lexpr) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'label) in
    Obj.repr(
# 173 "cil/src/logic/logic_parser.mly"
                                   ( info (PLat (_3, _5)) )
# 2182 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    Obj.repr(
# 174 "cil/src/logic/logic_parser.mly"
                              ( info (PLbase_addr _3) )
# 2189 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    Obj.repr(
# 175 "cil/src/logic/logic_parser.mly"
                                 ( info (PLblock_length _3) )
# 2196 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    Obj.repr(
# 176 "cil/src/logic/logic_parser.mly"
           ( info PLresult )
# 2202 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'ne_lexpr_list) in
    Obj.repr(
# 178 "cil/src/logic/logic_parser.mly"
      ( info (PLapp (_1, [], _3)) )
# 2210 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'ne_lexpr_list) in
    Obj.repr(
# 180 "cil/src/logic/logic_parser.mly"
      ( info (PLseparated _3) )
# 2217 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 6 : 'identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 4 : 'ne_tvar_list) in
    let _6 = (Parsing.peek_val __caml_parser_env 1 : 'ne_lexpr_list) in
    Obj.repr(
# 182 "cil/src/logic/logic_parser.mly"
      ( info (PLapp (_1, _3, _6)) )
# 2226 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'ne_tvar_list) in
    Obj.repr(
# 184 "cil/src/logic/logic_parser.mly"
      ( info (PLapp (_1, _3, [])) )
# 2234 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'identifier) in
    Obj.repr(
# 185 "cil/src/logic/logic_parser.mly"
                                ( info (PLvar _1) )
# 2241 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 186 "cil/src/logic/logic_parser.mly"
                                 ( info (PLbinop (_1, Brshift, _3)))
# 2249 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 187 "cil/src/logic/logic_parser.mly"
                                 ( info (PLbinop (_1, Blshift, _3)))
# 2257 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    Obj.repr(
# 188 "cil/src/logic/logic_parser.mly"
                                   ( info _2.lexpr_node )
# 2264 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'range) in
    Obj.repr(
# 189 "cil/src/logic/logic_parser.mly"
                    ( info _2.lexpr_node )
# 2271 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'logic_type_not_id) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 191 "cil/src/logic/logic_parser.mly"
      ( info (PLcast (_2, _4)) )
# 2279 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 193 "cil/src/logic/logic_parser.mly"
      ( info (PLsubtype (_1, _3)) )
# 2287 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'logic_type_not_id) in
    Obj.repr(
# 195 "cil/src/logic/logic_parser.mly"
      ( info (PLcoercion (_1, _3)) )
# 2295 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 197 "cil/src/logic/logic_parser.mly"
      ( info (PLcoercionE (_1, _3)) )
# 2303 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    Obj.repr(
# 198 "cil/src/logic/logic_parser.mly"
                           ( info (PLtypeof _3) )
# 2310 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'type_spec_not_id) in
    Obj.repr(
# 199 "cil/src/logic/logic_parser.mly"
                                           ( info (PLtype _3) )
# 2317 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    Obj.repr(
# 201 "cil/src/logic/logic_parser.mly"
          ( info PLempty )
# 2323 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr_list) in
    Obj.repr(
# 202 "cil/src/logic/logic_parser.mly"
                                 ( info (PLunion _3) )
# 2330 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr_list) in
    Obj.repr(
# 203 "cil/src/logic/logic_parser.mly"
                               ( info (PLinter _3) )
# 2337 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Logic_ptree.lexpr) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'binders) in
    Obj.repr(
# 205 "cil/src/logic/logic_parser.mly"
      (info (PLcomprehension (_2,_4,None)) )
# 2345 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 5 : Logic_ptree.lexpr) in
    let _4 = (Parsing.peek_val __caml_parser_env 3 : 'binders) in
    let _6 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    Obj.repr(
# 207 "cil/src/logic/logic_parser.mly"
      ( info (PLcomprehension (_2,_4,Some _6)) )
# 2354 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 5 : Logic_ptree.lexpr) in
    let _4 = (Parsing.peek_val __caml_parser_env 3 : 'identifier) in
    let _6 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    Obj.repr(
# 209 "cil/src/logic/logic_parser.mly"
                                                   ( info (PLupdate(_2,_4,_6)) )
# 2363 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : bool*string) in
    Obj.repr(
# 213 "cil/src/logic/logic_parser.mly"
                   ( _1 )
# 2370 "cil/src/logic/logic_parser.ml"
               : 'string))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'string) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : bool*string) in
    Obj.repr(
# 214 "cil/src/logic/logic_parser.mly"
                          (
      let (is_wide,prefix) = _1 in
      let (is_wide2,suffix) = _2 in
      (is_wide || is_wide2, prefix ^ suffix)
    )
# 2382 "cil/src/logic/logic_parser.ml"
               : 'string))
; (fun __caml_parser_env ->
    Obj.repr(
# 221 "cil/src/logic/logic_parser.mly"
          ( Lt )
# 2388 "cil/src/logic/logic_parser.ml"
               : 'relation))
; (fun __caml_parser_env ->
    Obj.repr(
# 222 "cil/src/logic/logic_parser.mly"
          ( Gt )
# 2394 "cil/src/logic/logic_parser.ml"
               : 'relation))
; (fun __caml_parser_env ->
    Obj.repr(
# 223 "cil/src/logic/logic_parser.mly"
          ( Le )
# 2400 "cil/src/logic/logic_parser.ml"
               : 'relation))
; (fun __caml_parser_env ->
    Obj.repr(
# 224 "cil/src/logic/logic_parser.mly"
          ( Ge )
# 2406 "cil/src/logic/logic_parser.ml"
               : 'relation))
; (fun __caml_parser_env ->
    Obj.repr(
# 225 "cil/src/logic/logic_parser.mly"
          ( Eq )
# 2412 "cil/src/logic/logic_parser.ml"
               : 'relation))
; (fun __caml_parser_env ->
    Obj.repr(
# 226 "cil/src/logic/logic_parser.mly"
          ( Neq )
# 2418 "cil/src/logic/logic_parser.ml"
               : 'relation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_option) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_option) in
    Obj.repr(
# 230 "cil/src/logic/logic_parser.mly"
                                   ( info (PLrange(_1,_3)) )
# 2426 "cil/src/logic/logic_parser.ml"
               : 'range))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Logic_ptree.lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 234 "cil/src/logic/logic_parser.mly"
                      ( info (PLimplies (_1, _3)) )
# 2434 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Logic_ptree.lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 235 "cil/src/logic/logic_parser.mly"
                  ( info (PLiff (_1, _3)) )
# 2442 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Logic_ptree.lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 236 "cil/src/logic/logic_parser.mly"
                     ( info (PLor (_1, _3)) )
# 2450 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Logic_ptree.lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 237 "cil/src/logic/logic_parser.mly"
                     ( info (PLand (_1, _3)) )
# 2458 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Logic_ptree.lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 238 "cil/src/logic/logic_parser.mly"
                        ( info (PLxor (_1, _3)) )
# 2466 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'binders) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 240 "cil/src/logic/logic_parser.mly"
      ( info (PLforall (_2, _4)) )
# 2474 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'binders) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 242 "cil/src/logic/logic_parser.mly"
      ( info (PLexists (_2, _4)) )
# 2482 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'binders) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 244 "cil/src/logic/logic_parser.mly"
      ( info (PLlambda (_2,_4)) )
# 2490 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Logic_ptree.lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 246 "cil/src/logic/logic_parser.mly"
                  ( info (PLbinop (_1, Bbw_and, _3)) )
# 2498 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Logic_ptree.lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 247 "cil/src/logic/logic_parser.mly"
                   ( info (PLbinop (_1, Bbw_or, _3)) )
# 2506 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Logic_ptree.lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 248 "cil/src/logic/logic_parser.mly"
                  ( info (PLbinop (_1, Bbw_xor, _3)) )
# 2514 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Logic_ptree.lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Logic_ptree.lexpr) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 250 "cil/src/logic/logic_parser.mly"
    ( info (PLif (_1, _3, _5)) )
# 2523 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 252 "cil/src/logic/logic_parser.mly"
                                          ( info (PLnamed (_1, _3)) )
# 2531 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_rel) in
    Obj.repr(
# 253 "cil/src/logic/logic_parser.mly"
                                ( _1 )
# 2538 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'relation) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 258 "cil/src/logic/logic_parser.mly"
  ( _1, _2, fst(relation_sense _1 Unknown), None )
# 2546 "cil/src/logic/logic_parser.ml"
               : 'rel_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'relation) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'rel_list) in
    Obj.repr(
# 260 "cil/src/logic/logic_parser.mly"
  (
    let next_rel, rhs, sense, oth_rel = _3 in
    let (sense, correct) = relation_sense _1 sense
    in
    if correct then
      let loc = loc_start _2, loc_end rhs in
      let my_rel = loc_info loc (PLrel(_2,next_rel,rhs)) in
      let oth_rel = match oth_rel with
          None -> my_rel
        | Some rel ->
	    let loc = loc_start _2, loc_end rel in
	    loc_info loc (PLand(my_rel,rel))
      in
      _1,_2,sense,Some oth_rel
    else begin
      let loc = Parsing.rhs_start_pos 1, Parsing.rhs_end_pos 3 in
      raise (Not_well_formed
               (loc,"Inconsistent relation chain."));

    end
  )
# 2575 "cil/src/logic/logic_parser.ml"
               : 'rel_list))
; (fun __caml_parser_env ->
    Obj.repr(
# 284 "cil/src/logic/logic_parser.mly"
                ( None )
# 2581 "cil/src/logic/logic_parser.ml"
               : 'lexpr_option))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 285 "cil/src/logic/logic_parser.mly"
                ( Some _1 )
# 2588 "cil/src/logic/logic_parser.ml"
               : 'lexpr_option))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'binders_reentrance) in
    Obj.repr(
# 290 "cil/src/logic/logic_parser.mly"
                            ( let (_lt, vars) = _1 in vars )
# 2595 "cil/src/logic/logic_parser.ml"
               : 'binders))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec) in
    Obj.repr(
# 294 "cil/src/logic/logic_parser.mly"
    ( let (lt, var) = _1 in (lt, [var])
    )
# 2603 "cil/src/logic/logic_parser.ml"
               : 'binders_reentrance))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'binders_reentrance) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec) in
    Obj.repr(
# 297 "cil/src/logic/logic_parser.mly"
    ( let _, vars = _1 in
      let (lt, var) = _3 in
        (lt, vars @ [ var ])
    )
# 2614 "cil/src/logic/logic_parser.ml"
               : 'binders_reentrance))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'binders_reentrance) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'var_spec) in
    Obj.repr(
# 302 "cil/src/logic/logic_parser.mly"
    ( let last_type_spec, vars = _1 in
        (last_type_spec, vars @ [ let (modif, name) = _3 in (modif last_type_spec, name)])
    )
# 2624 "cil/src/logic/logic_parser.ml"
               : 'binders_reentrance))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'identifier) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'var_spec_for_id) in
    Obj.repr(
# 309 "cil/src/logic/logic_parser.mly"
   ( let last_type_spec = LTnamed(_1, []) in
       (last_type_spec, let (modif, name) = _2 in [ (modif last_type_spec, name)])
   )
# 2634 "cil/src/logic/logic_parser.ml"
               : 'binders_reentrance))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'binders_reentrance) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'identifier) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'var_spec_for_id) in
    Obj.repr(
# 316 "cil/src/logic/logic_parser.mly"
   ( let _, vars = _1 in
     let last_type_spec = LTnamed(_3, []) in
       (last_type_spec, vars @ let (modif, name) = _4 in [ (modif last_type_spec, name)])
   )
# 2646 "cil/src/logic/logic_parser.ml"
               : 'binders_reentrance))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'var_spec_bis_for_id) in
    Obj.repr(
# 325 "cil/src/logic/logic_parser.mly"
                                     ( _1 )
# 2653 "cil/src/logic/logic_parser.ml"
               : 'var_spec_for_id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'stars) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'var_spec_bis_for_id) in
    Obj.repr(
# 327 "cil/src/logic/logic_parser.mly"
  ( let (modif, name) = _2 in
      ((fun x -> _1 (modif x)), name) )
# 2662 "cil/src/logic/logic_parser.ml"
               : 'var_spec_for_id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'identifier) in
    Obj.repr(
# 335 "cil/src/logic/logic_parser.mly"
                 ( ((fun x -> x), _1) )
# 2669 "cil/src/logic/logic_parser.ml"
               : 'var_spec_bis_for_id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'var_spec_bis_for_id) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr_option) in
    Obj.repr(
# 337 "cil/src/logic/logic_parser.mly"
      ( (* TODO: use size information for LTarray - $3 *)
        let (modif, name) = _1 in
          ((fun x -> LTarray (modif x)), name)
      )
# 2680 "cil/src/logic/logic_parser.ml"
               : 'var_spec_bis_for_id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'var_spec_bis_for_id) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'abs_param_type_list) in
    Obj.repr(
# 341 "cil/src/logic/logic_parser.mly"
                                                    ( (* TODO *) raise Parse_error )
# 2688 "cil/src/logic/logic_parser.ml"
               : 'var_spec_bis_for_id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'type_spec_not_id) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'var_spec) in
    Obj.repr(
# 345 "cil/src/logic/logic_parser.mly"
                            ( (_1, let (modif, name) = _2 in (modif _1, name))  )
# 2696 "cil/src/logic/logic_parser.ml"
               : 'decl_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'var_spec_bis) in
    Obj.repr(
# 349 "cil/src/logic/logic_parser.mly"
                     ( _1 )
# 2703 "cil/src/logic/logic_parser.ml"
               : 'var_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'stars) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'var_spec_bis) in
    Obj.repr(
# 351 "cil/src/logic/logic_parser.mly"
  ( let (modif, name) = _2 in
      ((fun x -> _1 (modif x)), name) )
# 2712 "cil/src/logic/logic_parser.ml"
               : 'var_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'identifier) in
    Obj.repr(
# 356 "cil/src/logic/logic_parser.mly"
                 ( ((fun x -> x), _1) )
# 2719 "cil/src/logic/logic_parser.ml"
               : 'var_spec_bis))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'var_spec_bis) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr_option) in
    Obj.repr(
# 358 "cil/src/logic/logic_parser.mly"
      ( (* TODO: use size information for LTarray - $3 *)
        let (modif, name) = _1 in
          ((fun x -> LTarray (modif x)), name)
      )
# 2730 "cil/src/logic/logic_parser.ml"
               : 'var_spec_bis))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'var_spec) in
    Obj.repr(
# 362 "cil/src/logic/logic_parser.mly"
                     ( _2 )
# 2737 "cil/src/logic/logic_parser.ml"
               : 'var_spec_bis))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'var_spec_bis) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'abs_param_type_list) in
    Obj.repr(
# 363 "cil/src/logic/logic_parser.mly"
                                             ( (* TODO *) raise Parse_error )
# 2745 "cil/src/logic/logic_parser.ml"
               : 'var_spec_bis))
; (fun __caml_parser_env ->
    Obj.repr(
# 367 "cil/src/logic/logic_parser.mly"
              ( [ ] )
# 2751 "cil/src/logic/logic_parser.ml"
               : 'abs_param_type_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'abs_param_list) in
    Obj.repr(
# 368 "cil/src/logic/logic_parser.mly"
                 ( _1 )
# 2758 "cil/src/logic/logic_parser.ml"
               : 'abs_param_type_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'abs_param_list) in
    Obj.repr(
# 369 "cil/src/logic/logic_parser.mly"
                                 ( (* TODO *) raise Parse_error )
# 2765 "cil/src/logic/logic_parser.ml"
               : 'abs_param_type_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'abs_param) in
    Obj.repr(
# 373 "cil/src/logic/logic_parser.mly"
            ( [ _1 ] )
# 2772 "cil/src/logic/logic_parser.ml"
               : 'abs_param_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'abs_param_list) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'abs_param) in
    Obj.repr(
# 374 "cil/src/logic/logic_parser.mly"
                                 ( _1 @ [ _3 ] )
# 2780 "cil/src/logic/logic_parser.ml"
               : 'abs_param_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'parameter) in
    Obj.repr(
# 381 "cil/src/logic/logic_parser.mly"
            ( _1 )
# 2787 "cil/src/logic/logic_parser.ml"
               : 'abs_param))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'identifier) in
    Obj.repr(
# 387 "cil/src/logic/logic_parser.mly"
              ( LTnamed(_1, []) )
# 2794 "cil/src/logic/logic_parser.ml"
               : 'id_as_typename))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'ne_logic_type_list) in
    Obj.repr(
# 392 "cil/src/logic/logic_parser.mly"
  ( LTnamed(_1, _3) )
# 2802 "cil/src/logic/logic_parser.ml"
               : 'id_as_typename_poly))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'type_spec_not_id) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'abs_spec_option) in
    Obj.repr(
# 398 "cil/src/logic/logic_parser.mly"
                                    ( _2 _1 )
# 2810 "cil/src/logic/logic_parser.ml"
               : 'logic_type_not_id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'parameter) in
    Obj.repr(
# 402 "cil/src/logic/logic_parser.mly"
            ( [_1] )
# 2817 "cil/src/logic/logic_parser.ml"
               : 'ne_parameters))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'parameter) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'ne_parameters) in
    Obj.repr(
# 403 "cil/src/logic/logic_parser.mly"
                                ( _1 :: _3 )
# 2825 "cil/src/logic/logic_parser.ml"
               : 'ne_parameters))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'type_spec) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'var_spec) in
    Obj.repr(
# 407 "cil/src/logic/logic_parser.mly"
                     ( let (modif, name) = _2 in (modif _1, name))
# 2833 "cil/src/logic/logic_parser.ml"
               : 'parameter))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'id_as_typename) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'var_spec) in
    Obj.repr(
# 408 "cil/src/logic/logic_parser.mly"
                          ( let (modif, name) = _2 in (modif _1, name) )
# 2841 "cil/src/logic/logic_parser.ml"
               : 'parameter))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'type_spec) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'abs_spec_option) in
    Obj.repr(
# 415 "cil/src/logic/logic_parser.mly"
                             ( _2 _1 )
# 2849 "cil/src/logic/logic_parser.ml"
               : 'logic_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'id_as_typename) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'abs_spec_option) in
    Obj.repr(
# 416 "cil/src/logic/logic_parser.mly"
                                 ( _2 _1 )
# 2857 "cil/src/logic/logic_parser.ml"
               : 'logic_type))
; (fun __caml_parser_env ->
    Obj.repr(
# 420 "cil/src/logic/logic_parser.mly"
                              ( fun t -> t )
# 2863 "cil/src/logic/logic_parser.ml"
               : 'abs_spec_option))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'abs_spec) in
    Obj.repr(
# 421 "cil/src/logic/logic_parser.mly"
           ( _1 )
# 2870 "cil/src/logic/logic_parser.ml"
               : 'abs_spec_option))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'tabs) in
    Obj.repr(
# 425 "cil/src/logic/logic_parser.mly"
                          ( _1 )
# 2877 "cil/src/logic/logic_parser.ml"
               : 'abs_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'stars) in
    Obj.repr(
# 426 "cil/src/logic/logic_parser.mly"
                                         ( _1 )
# 2884 "cil/src/logic/logic_parser.ml"
               : 'abs_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'stars) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'tabs) in
    Obj.repr(
# 427 "cil/src/logic/logic_parser.mly"
                                         ( fun t -> _2 (_1 t) )
# 2892 "cil/src/logic/logic_parser.ml"
               : 'abs_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'stars) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'abs_spec_bis) in
    Obj.repr(
# 428 "cil/src/logic/logic_parser.mly"
                                         ( fun t -> _2 (_1 t) )
# 2900 "cil/src/logic/logic_parser.ml"
               : 'abs_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'stars) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'abs_spec_bis) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'tabs) in
    Obj.repr(
# 429 "cil/src/logic/logic_parser.mly"
                                         ( fun t -> _2 (_3 (_1 t)) )
# 2909 "cil/src/logic/logic_parser.ml"
               : 'abs_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'abs_spec_bis) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'tabs) in
    Obj.repr(
# 430 "cil/src/logic/logic_parser.mly"
                                         ( fun t -> _1 (_2 t) )
# 2917 "cil/src/logic/logic_parser.ml"
               : 'abs_spec))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'abs_spec) in
    Obj.repr(
# 434 "cil/src/logic/logic_parser.mly"
                     ( _2 )
# 2924 "cil/src/logic/logic_parser.ml"
               : 'abs_spec_bis))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'abs_spec_bis) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'abs_param_type_list) in
    Obj.repr(
# 435 "cil/src/logic/logic_parser.mly"
                                             ( (* TODO *) raise Parse_error )
# 2932 "cil/src/logic/logic_parser.ml"
               : 'abs_spec_bis))
; (fun __caml_parser_env ->
    Obj.repr(
# 439 "cil/src/logic/logic_parser.mly"
             ( fun t -> LTpointer t )
# 2938 "cil/src/logic/logic_parser.ml"
               : 'stars))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'stars) in
    Obj.repr(
# 440 "cil/src/logic/logic_parser.mly"
             ( fun t -> _1 (LTpointer t) )
# 2945 "cil/src/logic/logic_parser.ml"
               : 'stars))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr_option) in
    Obj.repr(
# 445 "cil/src/logic/logic_parser.mly"
    (  (* TODO: use size information for LTarray - $2 *)
      fun t -> LTarray t
    )
# 2954 "cil/src/logic/logic_parser.ml"
               : 'tabs))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_option) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'tabs) in
    Obj.repr(
# 449 "cil/src/logic/logic_parser.mly"
    (  (* TODO: use size information for LTarray - $2 *)
      fun t -> LTarray (_4 t)
    )
# 2964 "cil/src/logic/logic_parser.ml"
               : 'tabs))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'type_spec_not_id) in
    Obj.repr(
# 455 "cil/src/logic/logic_parser.mly"
                   ( _1 )
# 2971 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'id_as_typename_poly) in
    Obj.repr(
# 456 "cil/src/logic/logic_parser.mly"
                      ( _1 )
# 2978 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 460 "cil/src/logic/logic_parser.mly"
                 ( LTinteger )
# 2984 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    Obj.repr(
# 461 "cil/src/logic/logic_parser.mly"
                 ( LTreal )
# 2990 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    Obj.repr(
# 462 "cil/src/logic/logic_parser.mly"
                 ( LTvoid )
# 2996 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    Obj.repr(
# 463 "cil/src/logic/logic_parser.mly"
                 ( LTint IChar )
# 3002 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    Obj.repr(
# 464 "cil/src/logic/logic_parser.mly"
                 ( LTint ISChar )
# 3008 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    Obj.repr(
# 465 "cil/src/logic/logic_parser.mly"
                 ( LTint IUChar )
# 3014 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    Obj.repr(
# 466 "cil/src/logic/logic_parser.mly"
                 ( LTint IInt )
# 3020 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    Obj.repr(
# 467 "cil/src/logic/logic_parser.mly"
                 ( LTint IInt )
# 3026 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    Obj.repr(
# 468 "cil/src/logic/logic_parser.mly"
                 ( LTint IUInt )
# 3032 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    Obj.repr(
# 469 "cil/src/logic/logic_parser.mly"
                 ( LTint IUInt )
# 3038 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    Obj.repr(
# 470 "cil/src/logic/logic_parser.mly"
                 ( LTint IShort )
# 3044 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    Obj.repr(
# 471 "cil/src/logic/logic_parser.mly"
                 ( LTint IShort )
# 3050 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    Obj.repr(
# 472 "cil/src/logic/logic_parser.mly"
                 ( LTint IUShort )
# 3056 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    Obj.repr(
# 473 "cil/src/logic/logic_parser.mly"
                 ( LTint ILong )
# 3062 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    Obj.repr(
# 474 "cil/src/logic/logic_parser.mly"
                 ( LTint ILong )
# 3068 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    Obj.repr(
# 475 "cil/src/logic/logic_parser.mly"
                 ( LTint IULong )
# 3074 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    Obj.repr(
# 476 "cil/src/logic/logic_parser.mly"
                 ( LTint ILong )
# 3080 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    Obj.repr(
# 477 "cil/src/logic/logic_parser.mly"
                 ( LTint ILong )
# 3086 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    Obj.repr(
# 478 "cil/src/logic/logic_parser.mly"
                    ( LTint IULong )
# 3092 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    Obj.repr(
# 479 "cil/src/logic/logic_parser.mly"
                 ( LTint ILongLong )
# 3098 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    Obj.repr(
# 481 "cil/src/logic/logic_parser.mly"
                     ( LTint ILongLong )
# 3104 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    Obj.repr(
# 483 "cil/src/logic/logic_parser.mly"
                     ( LTint IULongLong )
# 3110 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    Obj.repr(
# 485 "cil/src/logic/logic_parser.mly"
                    ( LTint ILongLong )
# 3116 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    Obj.repr(
# 487 "cil/src/logic/logic_parser.mly"
                        ( LTint ILongLong )
# 3122 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    Obj.repr(
# 489 "cil/src/logic/logic_parser.mly"
                         ( LTint IULongLong )
# 3128 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    Obj.repr(
# 491 "cil/src/logic/logic_parser.mly"
                    ( LTfloat FFloat )
# 3134 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    Obj.repr(
# 492 "cil/src/logic/logic_parser.mly"
                    ( LTfloat FDouble )
# 3140 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    Obj.repr(
# 493 "cil/src/logic/logic_parser.mly"
                    ( LTfloat FLongDouble )
# 3146 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'identifier) in
    Obj.repr(
# 494 "cil/src/logic/logic_parser.mly"
                    ( LTstruct _2 )
# 3153 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'identifier) in
    Obj.repr(
# 495 "cil/src/logic/logic_parser.mly"
                    ( LTenum _2 )
# 3160 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'identifier) in
    Obj.repr(
# 496 "cil/src/logic/logic_parser.mly"
                    ( LTunion _2 )
# 3167 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 497 "cil/src/logic/logic_parser.mly"
                    ( LTnamed (_1,[]) )
# 3174 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'ne_logic_type_list) in
    Obj.repr(
# 498 "cil/src/logic/logic_parser.mly"
                                    ( LTnamed(_1,_3) )
# 3182 "cil/src/logic/logic_parser.ml"
               : 'type_spec_not_id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'logic_type) in
    Obj.repr(
# 502 "cil/src/logic/logic_parser.mly"
                                      ( [_1] )
# 3189 "cil/src/logic/logic_parser.ml"
               : 'ne_logic_type_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'logic_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'ne_logic_type_list) in
    Obj.repr(
# 503 "cil/src/logic/logic_parser.mly"
                                      ( _1 :: _3 )
# 3197 "cil/src/logic/logic_parser.ml"
               : 'ne_logic_type_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'enter_kw_c_mode) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exit_kw_c_mode) in
    Obj.repr(
# 509 "cil/src/logic/logic_parser.mly"
                                     ( _2 )
# 3206 "cil/src/logic/logic_parser.ml"
               : 'full_lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'enter_kw_c_mode) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exit_kw_c_mode) in
    Obj.repr(
# 513 "cil/src/logic/logic_parser.mly"
                                          ( _2 )
# 3215 "cil/src/logic/logic_parser.ml"
               : 'full_identifier))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'enter_kw_c_mode) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'ne_parameters) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exit_kw_c_mode) in
    Obj.repr(
# 517 "cil/src/logic/logic_parser.mly"
                                             ( _2 )
# 3224 "cil/src/logic/logic_parser.ml"
               : 'full_parameters))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'enter_kw_c_mode) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'parameter) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exit_kw_c_mode) in
    Obj.repr(
# 521 "cil/src/logic/logic_parser.mly"
                                         ( _2 )
# 3233 "cil/src/logic/logic_parser.ml"
               : 'full_parameter))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'enter_kw_c_mode) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'ne_lexpr_list) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exit_kw_c_mode) in
    Obj.repr(
# 531 "cil/src/logic/logic_parser.mly"
                                             ( _2 )
# 3242 "cil/src/logic/logic_parser.ml"
               : 'full_ne_lexpr_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'enter_kw_c_mode) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'logic_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exit_kw_c_mode) in
    Obj.repr(
# 535 "cil/src/logic/logic_parser.mly"
                                          ( _2 )
# 3251 "cil/src/logic/logic_parser.ml"
               : 'full_logic_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'enter_kw_c_mode) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'assigns) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exit_kw_c_mode) in
    Obj.repr(
# 539 "cil/src/logic/logic_parser.mly"
                                       ( _2 )
# 3260 "cil/src/logic/logic_parser.ml"
               : 'full_assigns))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'location_dep) in
    Obj.repr(
# 543 "cil/src/logic/logic_parser.mly"
               ( _1 )
# 3267 "cil/src/logic/logic_parser.ml"
               : 'assigns))
; (fun __caml_parser_env ->
    Obj.repr(
# 544 "cil/src/logic/logic_parser.mly"
          ( [Nothing,[]] )
# 3273 "cil/src/logic/logic_parser.ml"
               : 'assigns))
; (fun __caml_parser_env ->
    Obj.repr(
# 548 "cil/src/logic/logic_parser.mly"
                ( [] )
# 3279 "cil/src/logic/logic_parser.ml"
               : 'requires))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'full_lexpr) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'requires) in
    Obj.repr(
# 549 "cil/src/logic/logic_parser.mly"
                                         ( _2::_4 )
# 3287 "cil/src/logic/logic_parser.ml"
               : 'requires))
; (fun __caml_parser_env ->
    Obj.repr(
# 554 "cil/src/logic/logic_parser.mly"
                ( [],[],[] )
# 3293 "cil/src/logic/logic_parser.ml"
               : 'behavior_body))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'ne_behavior_body) in
    Obj.repr(
# 555 "cil/src/logic/logic_parser.mly"
                   ( _1 )
# 3300 "cil/src/logic/logic_parser.ml"
               : 'behavior_body))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'full_lexpr) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'behavior_body) in
    Obj.repr(
# 559 "cil/src/logic/logic_parser.mly"
    ( let a,b,c = _4 in _2::a,b,c )
# 3308 "cil/src/logic/logic_parser.ml"
               : 'ne_behavior_body))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'full_lexpr) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'behavior_body) in
    Obj.repr(
# 561 "cil/src/logic/logic_parser.mly"
    ( let a,b,c = _4 in a,_2::b,c )
# 3316 "cil/src/logic/logic_parser.ml"
               : 'ne_behavior_body))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'full_assigns) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'behavior_body) in
    Obj.repr(
# 563 "cil/src/logic/logic_parser.mly"
    ( let a,b,c = _4 in
      let assigns =
        match c,_2 with
            ([] | [(Nothing,_) ]), ([] | [(Nothing,_) ]) -> [(Nothing,[])]
          | [(Nothing,_) ], _ | _, [(Nothing,_)] ->
              raise (
                Not_well_formed (loc(),"Mixing \\nothing and a real location"))
          | _,_ -> _2 @ c
      in a,b,assigns
    )
# 3333 "cil/src/logic/logic_parser.ml"
               : 'ne_behavior_body))
; (fun __caml_parser_env ->
    Obj.repr(
# 576 "cil/src/logic/logic_parser.mly"
                ( [] )
# 3339 "cil/src/logic/logic_parser.ml"
               : 'behaviors))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'full_identifier) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'behavior_body) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'behaviors) in
    Obj.repr(
# 578 "cil/src/logic/logic_parser.mly"
      ( let (assumes,ensures,assigns) = _4 in
        Logic_const.check_assigns ~loc:(loc()) assigns;
        {b_name=_2; b_assumes = assumes;
         b_ensures = ensures;
         b_assigns = assigns}::_5 )
# 3352 "cil/src/logic/logic_parser.ml"
               : 'behaviors))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'behavior_body) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'terminates) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'behavior_body) in
    Obj.repr(
# 587 "cil/src/logic/logic_parser.mly"
      ( let (assumes1, ensures1, assigns1) = _1 in
        let (assumes2, ensures2,assigns2) = _3 in
        (Some _2, (assumes1 @ assumes2,
                      ensures1 @ ensures2, assigns1 @ assigns2))
      )
# 3365 "cil/src/logic/logic_parser.ml"
               : 'simple_behavior_body))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'behavior_body) in
    Obj.repr(
# 592 "cil/src/logic/logic_parser.mly"
                ( (None, _1) )
# 3372 "cil/src/logic/logic_parser.ml"
               : 'simple_behavior_body))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'simple_behavior_body) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'behaviors) in
    Obj.repr(
# 597 "cil/src/logic/logic_parser.mly"
    ( let (terminates,(assumes,ensures,assigns)) = _1 in
      let behaviors =
        if (*TODO: enforce to have a default behavior true || *)
           assumes <> [] || ensures <> [] || assigns <> [] then
          { b_name = "default";b_assumes = assumes;
            b_ensures = ensures;
            b_assigns = assigns} :: _2
        else _2
      in
      terminates, behaviors
    )
# 3390 "cil/src/logic/logic_parser.ml"
               : 'behaviors_or_default))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.lexpr) in
    Obj.repr(
# 610 "cil/src/logic/logic_parser.mly"
                                       ( _2 )
# 3397 "cil/src/logic/logic_parser.ml"
               : 'terminates))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'full_identifier) in
    Obj.repr(
# 614 "cil/src/logic/logic_parser.mly"
                  ( [_1] )
# 3404 "cil/src/logic/logic_parser.ml"
               : 'ne_full_identifier_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'full_identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'ne_full_identifier_list) in
    Obj.repr(
# 615 "cil/src/logic/logic_parser.mly"
                                                (_1 :: _3)
# 3412 "cil/src/logic/logic_parser.ml"
               : 'ne_full_identifier_list))
; (fun __caml_parser_env ->
    Obj.repr(
# 619 "cil/src/logic/logic_parser.mly"
                ( [],[] )
# 3418 "cil/src/logic/logic_parser.ml"
               : 'complete_or_disjoint))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'ne_full_identifier_list) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'complete_or_disjoint) in
    Obj.repr(
# 621 "cil/src/logic/logic_parser.mly"
      ( let (complete,disjoint) = _5 in (_3::complete, disjoint) )
# 3426 "cil/src/logic/logic_parser.ml"
               : 'complete_or_disjoint))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'ne_full_identifier_list) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'complete_or_disjoint) in
    Obj.repr(
# 623 "cil/src/logic/logic_parser.mly"
      ( let (complete,disjoint) = _5 in (complete, _3::disjoint) )
# 3434 "cil/src/logic/logic_parser.ml"
               : 'complete_or_disjoint))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'requires) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'behaviors_or_default) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'complete_or_disjoint) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'decreases) in
    Obj.repr(
# 627 "cil/src/logic/logic_parser.mly"
      (
        { spec_requires = _1;
          spec_behavior = snd _2;
          spec_variant = _4;
          spec_terminates = fst _2;
          spec_complete_behaviors = fst _3;
          spec_disjoint_behaviors = snd _3;
        },loc() )
# 3451 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.spec * Cabs.cabsloc))
; (fun __caml_parser_env ->
    Obj.repr(
# 642 "cil/src/logic/logic_parser.mly"
           ( () )
# 3457 "cil/src/logic/logic_parser.ml"
               : 'is_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 643 "cil/src/logic/logic_parser.mly"
           ( () )
# 3463 "cil/src/logic/logic_parser.ml"
               : 'is_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 644 "cil/src/logic/logic_parser.mly"
          ( () )
# 3469 "cil/src/logic/logic_parser.ml"
               : 'is_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 645 "cil/src/logic/logic_parser.mly"
          ( () )
# 3475 "cil/src/logic/logic_parser.ml"
               : 'is_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 646 "cil/src/logic/logic_parser.mly"
            ( () )
# 3481 "cil/src/logic/logic_parser.ml"
               : 'is_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 647 "cil/src/logic/logic_parser.mly"
             ( () )
# 3487 "cil/src/logic/logic_parser.ml"
               : 'is_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 648 "cil/src/logic/logic_parser.mly"
           ( () )
# 3493 "cil/src/logic/logic_parser.ml"
               : 'is_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'loop_invariant) in
    Obj.repr(
# 652 "cil/src/logic/logic_parser.mly"
                 ( [AInvariant (fst _1,true,snd _1)] )
# 3500 "cil/src/logic/logic_parser.ml"
               : 'loop_annot))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'loop_effects) in
    Obj.repr(
# 653 "cil/src/logic/logic_parser.mly"
               ( List.map (fun x -> AAssigns x) _1 )
# 3507 "cil/src/logic/logic_parser.ml"
               : 'loop_annot))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'loop_variant) in
    Obj.repr(
# 654 "cil/src/logic/logic_parser.mly"
               ( [AVariant _1] )
# 3514 "cil/src/logic/logic_parser.ml"
               : 'loop_annot))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'loop_pragma) in
    Obj.repr(
# 655 "cil/src/logic/logic_parser.mly"
              ( [APragma (Loop_pragma _1)] )
# 3521 "cil/src/logic/logic_parser.ml"
               : 'loop_annot))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'loop_annot) in
    Obj.repr(
# 660 "cil/src/logic/logic_parser.mly"
    ( _1 )
# 3528 "cil/src/logic/logic_parser.ml"
               : 'loop_annotations))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'loop_annot) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'loop_annotations) in
    Obj.repr(
# 661 "cil/src/logic/logic_parser.mly"
                              ( _1 @ _2 )
# 3536 "cil/src/logic/logic_parser.ml"
               : 'loop_annotations))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 6 : 'full_identifier) in
    let _5 = (Parsing.peek_val __caml_parser_env 4 : 'full_parameter) in
    let _8 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 667 "cil/src/logic/logic_parser.mly"
  ( let typ,name = _5 in{ inv_name = _3; this_name = name; this_type = typ; inv = _8; } )
# 3545 "cil/src/logic/logic_parser.ml"
               : 'type_annot))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'full_lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'full_identifier) in
    Obj.repr(
# 671 "cil/src/logic/logic_parser.mly"
                                 ( (_1, Some _3) )
# 3553 "cil/src/logic/logic_parser.ml"
               : 'variant))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'full_lexpr) in
    Obj.repr(
# 672 "cil/src/logic/logic_parser.mly"
                            ( (_1, None) )
# 3560 "cil/src/logic/logic_parser.ml"
               : 'variant))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 5 : 'ne_full_identifier_list) in
    let _6 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 677 "cil/src/logic/logic_parser.mly"
    ( (_2,_6) )
# 3568 "cil/src/logic/logic_parser.ml"
               : 'loop_invariant))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 678 "cil/src/logic/logic_parser.mly"
                                      ( ([],_3) )
# 3575 "cil/src/logic/logic_parser.ml"
               : 'loop_invariant))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'variant) in
    Obj.repr(
# 682 "cil/src/logic/logic_parser.mly"
                                 ( _3 )
# 3582 "cil/src/logic/logic_parser.ml"
               : 'loop_variant))
; (fun __caml_parser_env ->
    Obj.repr(
# 686 "cil/src/logic/logic_parser.mly"
                  ( None )
# 3588 "cil/src/logic/logic_parser.ml"
               : 'decreases))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'variant) in
    Obj.repr(
# 687 "cil/src/logic/logic_parser.mly"
                              ( Some _2 )
# 3595 "cil/src/logic/logic_parser.ml"
               : 'decreases))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'slice_pragma) in
    Obj.repr(
# 691 "cil/src/logic/logic_parser.mly"
                   ( APragma (Slice_pragma _1) )
# 3602 "cil/src/logic/logic_parser.ml"
               : 'code_annotation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'impact_pragma) in
    Obj.repr(
# 692 "cil/src/logic/logic_parser.mly"
                   ( APragma (Impact_pragma _1) )
# 3609 "cil/src/logic/logic_parser.ml"
               : 'code_annotation))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'ne_full_identifier_list) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 694 "cil/src/logic/logic_parser.mly"
      ( AAssert (_2,_5,{status=Cil_types.Unknown}) )
# 3617 "cil/src/logic/logic_parser.ml"
               : 'code_annotation))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 695 "cil/src/logic/logic_parser.mly"
                                 ( AAssert ([],_2,{status=Cil_types.Unknown}) )
# 3624 "cil/src/logic/logic_parser.ml"
               : 'code_annotation))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 696 "cil/src/logic/logic_parser.mly"
                                 ( AInvariant ([],false,_2) )
# 3631 "cil/src/logic/logic_parser.ml"
               : 'code_annotation))
; (fun __caml_parser_env ->
    Obj.repr(
# 700 "cil/src/logic/logic_parser.mly"
              ( )
# 3637 "cil/src/logic/logic_parser.ml"
               : 'loop_pragma_tk))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'loop_pragma_tk) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'full_ne_lexpr_list) in
    Obj.repr(
# 705 "cil/src/logic/logic_parser.mly"
  ( if _2 = "UNROLL_LOOP" || _2 = "UNROLL" then
      match _3 with
        | [level] -> Unroll_level level
        | _ -> raise(
            Not_well_formed(loc(),"usage: loop pragma UNROLL n;"))
    else if _2 = "WIDEN_VARIABLES" then
      Widen_variables _3
    else if _2 = "WIDEN_HINTS" then
      Widen_hints _3
    else raise (Not_well_formed (loc(),"unknown loop pragma")) )
# 3655 "cil/src/logic/logic_parser.ml"
               : 'loop_pragma))
; (fun __caml_parser_env ->
    Obj.repr(
# 717 "cil/src/logic/logic_parser.mly"
               ( )
# 3661 "cil/src/logic/logic_parser.ml"
               : 'slice_pragma_tk))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'slice_pragma_tk) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 722 "cil/src/logic/logic_parser.mly"
    ( if _2 = "expr" then SPexpr _3
      else raise (Not_well_formed (loc(), "unknown slice pragma")) )
# 3671 "cil/src/logic/logic_parser.ml"
               : 'slice_pragma))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'slice_pragma_tk) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : string) in
    Obj.repr(
# 725 "cil/src/logic/logic_parser.mly"
    ( if _2 = "ctrl" then SPctrl
      else if _2 = "stmt" then SPstmt
      else raise (Not_well_formed (loc(), "unknown slice pragma")) )
# 3681 "cil/src/logic/logic_parser.ml"
               : 'slice_pragma))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 2 : string) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 731 "cil/src/logic/logic_parser.mly"
    ( if _3 = "expr" then IPexpr _4
      else raise (Not_well_formed (loc(), "unknown impact pragma")) )
# 3690 "cil/src/logic/logic_parser.ml"
               : 'impact_pragma))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : string) in
    Obj.repr(
# 734 "cil/src/logic/logic_parser.mly"
    ( if _3 = "stmt" then IPstmt
      else raise (Not_well_formed (loc(), "unknown impact pragma")) )
# 3698 "cil/src/logic/logic_parser.ml"
               : 'impact_pragma))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'full_assigns) in
    Obj.repr(
# 738 "cil/src/logic/logic_parser.mly"
                                      ( _3 )
# 3705 "cil/src/logic/logic_parser.ml"
               : 'loop_effects))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'zones) in
    Obj.repr(
# 742 "cil/src/logic/logic_parser.mly"
        ( List.map (fun x -> (x,[])) _1 )
# 3712 "cil/src/logic/logic_parser.ml"
               : 'location_dep))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'zones) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'zones) in
    Obj.repr(
# 743 "cil/src/logic/logic_parser.mly"
                   (List.map (fun x -> (x, _3)) _1)
# 3720 "cil/src/logic/logic_parser.ml"
               : 'location_dep))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'zones) in
    Obj.repr(
# 744 "cil/src/logic/logic_parser.mly"
                      (List.map (fun x -> (x, [Nothing])) _1)
# 3727 "cil/src/logic/logic_parser.ml"
               : 'location_dep))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'tsets) in
    Obj.repr(
# 746 "cil/src/logic/logic_parser.mly"
              ( List.map (fun x -> Location x) _1 )
# 3734 "cil/src/logic/logic_parser.ml"
               : 'zones))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'location) in
    Obj.repr(
# 749 "cil/src/logic/logic_parser.mly"
           ( [_1] )
# 3741 "cil/src/logic/logic_parser.ml"
               : 'tsets))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'location) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'tsets) in
    Obj.repr(
# 750 "cil/src/logic/logic_parser.mly"
                       ( _1 :: _3 )
# 3749 "cil/src/logic/logic_parser.ml"
               : 'tsets))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.lexpr) in
    Obj.repr(
# 754 "cil/src/logic/logic_parser.mly"
        ( _1 )
# 3756 "cil/src/logic/logic_parser.ml"
               : 'location))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'full_identifier) in
    Obj.repr(
# 768 "cil/src/logic/logic_parser.mly"
                  ( (_1,[],[]) )
# 3763 "cil/src/logic/logic_parser.ml"
               : 'poly_id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'full_identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'ne_tvar_list) in
    Obj.repr(
# 769 "cil/src/logic/logic_parser.mly"
                                     ( _1,[],_3 )
# 3771 "cil/src/logic/logic_parser.ml"
               : 'poly_id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'full_identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'ne_label_list) in
    Obj.repr(
# 770 "cil/src/logic/logic_parser.mly"
                                              ( (_1,_3,[]) )
# 3779 "cil/src/logic/logic_parser.ml"
               : 'poly_id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 6 : 'full_identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 4 : 'ne_label_list) in
    let _6 = (Parsing.peek_val __caml_parser_env 1 : 'ne_tvar_list) in
    Obj.repr(
# 771 "cil/src/logic/logic_parser.mly"
                                                                 ( _1,_3,_6 )
# 3788 "cil/src/logic/logic_parser.ml"
               : 'poly_id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 774 "cil/src/logic/logic_parser.mly"
             ( _1 )
# 3795 "cil/src/logic/logic_parser.ml"
               : 'identifier))
; (fun __caml_parser_env ->
    Obj.repr(
# 778 "cil/src/logic/logic_parser.mly"
              ( [] )
# 3801 "cil/src/logic/logic_parser.ml"
               : 'opt_parameters))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'parameters) in
    Obj.repr(
# 779 "cil/src/logic/logic_parser.mly"
             ( _1 )
# 3808 "cil/src/logic/logic_parser.ml"
               : 'opt_parameters))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'full_parameters) in
    Obj.repr(
# 783 "cil/src/logic/logic_parser.mly"
                            ( _2 )
# 3815 "cil/src/logic/logic_parser.ml"
               : 'parameters))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'logic_def) in
    Obj.repr(
# 787 "cil/src/logic/logic_parser.mly"
             ( _1 )
# 3822 "cil/src/logic/logic_parser.ml"
               : 'decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'deprecated_logic_decl) in
    Obj.repr(
# 789 "cil/src/logic/logic_parser.mly"
    ( _1 )
# 3829 "cil/src/logic/logic_parser.ml"
               : 'decl))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'full_identifier) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 791 "cil/src/logic/logic_parser.mly"
    ( LDinvariant (_3, _5) )
# 3837 "cil/src/logic/logic_parser.ml"
               : 'decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'type_annot) in
    Obj.repr(
# 792 "cil/src/logic/logic_parser.mly"
             (LDtype_annot _1)
# 3844 "cil/src/logic/logic_parser.ml"
               : 'decl))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 5 : 'full_logic_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 4 : 'poly_id) in
    let _4 = (Parsing.peek_val __caml_parser_env 3 : 'opt_parameters) in
    let _6 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 798 "cil/src/logic/logic_parser.mly"
    ( let (id, labels, tvars) = _3 in
      LDlogic_def (id, labels, tvars, _2, _4, _6) )
# 3855 "cil/src/logic/logic_parser.ml"
               : 'logic_def))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'poly_id) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'opt_parameters) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 802 "cil/src/logic/logic_parser.mly"
    ( let (id,labels,tvars) = _2 in
      LDpredicate_def (id, labels, tvars, _3, _5) )
# 3865 "cil/src/logic/logic_parser.ml"
               : 'logic_def))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'poly_id) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'parameters) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'indcases) in
    Obj.repr(
# 806 "cil/src/logic/logic_parser.mly"
    ( let (id,labels,tvars) = _2 in
      LDinductive_def(id, labels, tvars, _3, _5) )
# 3875 "cil/src/logic/logic_parser.ml"
               : 'logic_def))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'poly_id) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 809 "cil/src/logic/logic_parser.mly"
    ( let (id,labels,tvars) = _2 in
      LDlemma (id, false, labels, tvars, _4) )
# 3884 "cil/src/logic/logic_parser.ml"
               : 'logic_def))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'identifier) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'logic_decls) in
    Obj.repr(
# 812 "cil/src/logic/logic_parser.mly"
    ( LDaxiomatic(_2,_4) )
# 3892 "cil/src/logic/logic_parser.ml"
               : 'logic_def))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'full_logic_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'poly_id) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'opt_parameters) in
    Obj.repr(
# 818 "cil/src/logic/logic_parser.mly"
    ( let (id, labels, tvars) = _3 in
      Format.eprintf "Warning: deprecated logic declaration '%s', should be declared inside an axiomatic block@." id;
      LDlogic_reads (id, labels, tvars, _2, _4, []) )
# 3903 "cil/src/logic/logic_parser.ml"
               : 'deprecated_logic_decl))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'poly_id) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'opt_parameters) in
    Obj.repr(
# 823 "cil/src/logic/logic_parser.mly"
    ( let (id,labels,tvars) = _2 in
      Format.eprintf "Warning: deprecated logic declaration `%s', should be declared inside an axiomatic block@." id;
      LDpredicate_reads (id, labels, tvars, _3, []) )
# 3913 "cil/src/logic/logic_parser.ml"
               : 'deprecated_logic_decl))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'poly_id) in
    Obj.repr(
# 828 "cil/src/logic/logic_parser.mly"
    ( let (id,labels,tvars) = _2 in
      assert (labels = []);
      Format.eprintf "Warning: deprecated logic type declaration `%s', should be declared inside an axiomatic block@." id;
      LDtype(id,tvars) )
# 3923 "cil/src/logic/logic_parser.ml"
               : 'deprecated_logic_decl))
; (fun __caml_parser_env ->
    Obj.repr(
# 837 "cil/src/logic/logic_parser.mly"
    ( [] )
# 3929 "cil/src/logic/logic_parser.ml"
               : 'logic_decls))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'logic_decl) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'logic_decls) in
    Obj.repr(
# 839 "cil/src/logic/logic_parser.mly"
    ( _1::_2 )
# 3937 "cil/src/logic/logic_parser.ml"
               : 'logic_decls))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'logic_def) in
    Obj.repr(
# 843 "cil/src/logic/logic_parser.mly"
             ( _1 )
# 3944 "cil/src/logic/logic_parser.ml"
               : 'logic_decl))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'full_logic_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'poly_id) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'opt_parameters) in
    Obj.repr(
# 846 "cil/src/logic/logic_parser.mly"
    ( let (id, labels, tvars) = _3 in
      LDlogic_reads (id, labels, tvars, _2, _4, []) )
# 3954 "cil/src/logic/logic_parser.ml"
               : 'logic_decl))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'poly_id) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'opt_parameters) in
    Obj.repr(
# 850 "cil/src/logic/logic_parser.mly"
    ( let (id,labels,tvars) = _2 in
      LDpredicate_reads (id, labels, tvars, _3, []) )
# 3963 "cil/src/logic/logic_parser.ml"
               : 'logic_decl))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'poly_id) in
    Obj.repr(
# 854 "cil/src/logic/logic_parser.mly"
    ( let (id,labels,tvars) = _2 in
      assert (labels = []);
      LDtype(id,tvars) )
# 3972 "cil/src/logic/logic_parser.ml"
               : 'logic_decl))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'poly_id) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 860 "cil/src/logic/logic_parser.mly"
    ( let (id,labels,tvars) = _2 in
      LDlemma (id, true, labels, tvars, _4) )
# 3981 "cil/src/logic/logic_parser.ml"
               : 'logic_decl))
; (fun __caml_parser_env ->
    Obj.repr(
# 867 "cil/src/logic/logic_parser.mly"
    ( [] )
# 3987 "cil/src/logic/logic_parser.ml"
               : 'indcases))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'poly_id) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : Logic_ptree.lexpr) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : 'indcases) in
    Obj.repr(
# 869 "cil/src/logic/logic_parser.mly"
    ( let (id,labels,tvars) = _2 in
      (id,labels,tvars,_4)::_6 )
# 3997 "cil/src/logic/logic_parser.ml"
               : 'indcases))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'full_identifier) in
    Obj.repr(
# 875 "cil/src/logic/logic_parser.mly"
                  ( [_1] )
# 4004 "cil/src/logic/logic_parser.ml"
               : 'ne_tvar_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'full_identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'ne_tvar_list) in
    Obj.repr(
# 876 "cil/src/logic/logic_parser.mly"
                                     ( _1 :: _3 )
# 4012 "cil/src/logic/logic_parser.ml"
               : 'ne_tvar_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'label) in
    Obj.repr(
# 880 "cil/src/logic/logic_parser.mly"
        ( [_1] )
# 4019 "cil/src/logic/logic_parser.ml"
               : 'ne_label_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'label) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'ne_label_list) in
    Obj.repr(
# 881 "cil/src/logic/logic_parser.mly"
                            ( _1 :: _3 )
# 4027 "cil/src/logic/logic_parser.ml"
               : 'ne_label_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'full_identifier) in
    Obj.repr(
# 885 "cil/src/logic/logic_parser.mly"
                  ( _1 )
# 4034 "cil/src/logic/logic_parser.ml"
               : 'label))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'annotation) in
    Obj.repr(
# 889 "cil/src/logic/logic_parser.mly"
                   ( _1 )
# 4041 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.annot))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'decl) in
    Obj.repr(
# 893 "cil/src/logic/logic_parser.mly"
       ( [(loc(), _1)] )
# 4048 "cil/src/logic/logic_parser.ml"
               : 'decl_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'decl) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'decl_list) in
    Obj.repr(
# 894 "cil/src/logic/logic_parser.mly"
                 ( (loc(),_1) :: _2 )
# 4056 "cil/src/logic/logic_parser.ml"
               : 'decl_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'decl_list) in
    Obj.repr(
# 897 "cil/src/logic/logic_parser.mly"
                        ( Adecl (_1) )
# 4063 "cil/src/logic/logic_parser.ml"
               : 'annotation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'is_spec) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'any) in
    Obj.repr(
# 898 "cil/src/logic/logic_parser.mly"
                   ( Aspec )
# 4071 "cil/src/logic/logic_parser.ml"
               : 'annotation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'loop_annotations) in
    Obj.repr(
# 899 "cil/src/logic/logic_parser.mly"
                   ( Logic_const.check_loop_annotation ~loc:(loc()) _1;
                     Aloop_annot (loc (), _1) )
# 4079 "cil/src/logic/logic_parser.ml"
               : 'annotation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'code_annotation) in
    Obj.repr(
# 901 "cil/src/logic/logic_parser.mly"
                  ( Acode_annot (loc(),_1) )
# 4086 "cil/src/logic/logic_parser.ml"
               : 'annotation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 902 "cil/src/logic/logic_parser.mly"
                  ( Aattribute_annot (loc (), _1) )
# 4093 "cil/src/logic/logic_parser.ml"
               : 'annotation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'wildcard) in
    Obj.repr(
# 907 "cil/src/logic/logic_parser.mly"
           ( () )
# 4100 "cil/src/logic/logic_parser.ml"
               : 'any))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'wildcard) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'any) in
    Obj.repr(
# 908 "cil/src/logic/logic_parser.mly"
               ( () )
# 4108 "cil/src/logic/logic_parser.ml"
               : 'any))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 912 "cil/src/logic/logic_parser.mly"
             ( () )
# 4115 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : bool*string) in
    Obj.repr(
# 913 "cil/src/logic/logic_parser.mly"
                 ( () )
# 4122 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 914 "cil/src/logic/logic_parser.mly"
           ( () )
# 4129 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.constant) in
    Obj.repr(
# 915 "cil/src/logic/logic_parser.mly"
           ( () )
# 4136 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 916 "cil/src/logic/logic_parser.mly"
       ( () )
# 4142 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 917 "cil/src/logic/logic_parser.mly"
       ( () )
# 4148 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 918 "cil/src/logic/logic_parser.mly"
     ( () )
# 4154 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 919 "cil/src/logic/logic_parser.mly"
       ( () )
# 4160 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 920 "cil/src/logic/logic_parser.mly"
        ( () )
# 4166 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 921 "cil/src/logic/logic_parser.mly"
         ( () )
# 4172 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 922 "cil/src/logic/logic_parser.mly"
             ( () )
# 4178 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 923 "cil/src/logic/logic_parser.mly"
      ( () )
# 4184 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 924 "cil/src/logic/logic_parser.mly"
         ( () )
# 4190 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 925 "cil/src/logic/logic_parser.mly"
            ( () )
# 4196 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 926 "cil/src/logic/logic_parser.mly"
      ( () )
# 4202 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 927 "cil/src/logic/logic_parser.mly"
          ( () )
# 4208 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 928 "cil/src/logic/logic_parser.mly"
       ( () )
# 4214 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 929 "cil/src/logic/logic_parser.mly"
        ( () )
# 4220 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 930 "cil/src/logic/logic_parser.mly"
     ( () )
# 4226 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 931 "cil/src/logic/logic_parser.mly"
     ( () )
# 4232 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 932 "cil/src/logic/logic_parser.mly"
     ( () )
# 4238 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 933 "cil/src/logic/logic_parser.mly"
     ( () )
# 4244 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 934 "cil/src/logic/logic_parser.mly"
     ( () )
# 4250 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 935 "cil/src/logic/logic_parser.mly"
     ( () )
# 4256 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 936 "cil/src/logic/logic_parser.mly"
        ( () )
# 4262 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 937 "cil/src/logic/logic_parser.mly"
        ( () )
# 4268 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 938 "cil/src/logic/logic_parser.mly"
        ( () )
# 4274 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 939 "cil/src/logic/logic_parser.mly"
         ( () )
# 4280 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 940 "cil/src/logic/logic_parser.mly"
         ( () )
# 4286 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 941 "cil/src/logic/logic_parser.mly"
      ( () )
# 4292 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 942 "cil/src/logic/logic_parser.mly"
          ( () )
# 4298 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 943 "cil/src/logic/logic_parser.mly"
      ( () )
# 4304 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 944 "cil/src/logic/logic_parser.mly"
     ( () )
# 4310 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 945 "cil/src/logic/logic_parser.mly"
      ( () )
# 4316 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 946 "cil/src/logic/logic_parser.mly"
       ( () )
# 4322 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 947 "cil/src/logic/logic_parser.mly"
        ( () )
# 4328 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 948 "cil/src/logic/logic_parser.mly"
      ( () )
# 4334 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 949 "cil/src/logic/logic_parser.mly"
     ( () )
# 4340 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 950 "cil/src/logic/logic_parser.mly"
         ( () )
# 4346 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 951 "cil/src/logic/logic_parser.mly"
               ( () )
# 4352 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 952 "cil/src/logic/logic_parser.mly"
            ( () )
# 4358 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 953 "cil/src/logic/logic_parser.mly"
        ( () )
# 4364 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 954 "cil/src/logic/logic_parser.mly"
              ( () )
# 4370 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 955 "cil/src/logic/logic_parser.mly"
              ( () )
# 4376 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 956 "cil/src/logic/logic_parser.mly"
        ( () )
# 4382 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 957 "cil/src/logic/logic_parser.mly"
         ( () )
# 4388 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 958 "cil/src/logic/logic_parser.mly"
           ( () )
# 4394 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 959 "cil/src/logic/logic_parser.mly"
        ( () )
# 4400 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 960 "cil/src/logic/logic_parser.mly"
       ( () )
# 4406 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 961 "cil/src/logic/logic_parser.mly"
       ( () )
# 4412 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 962 "cil/src/logic/logic_parser.mly"
      ( () )
# 4418 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 963 "cil/src/logic/logic_parser.mly"
        ( () )
# 4424 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 964 "cil/src/logic/logic_parser.mly"
          ( () )
# 4430 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 965 "cil/src/logic/logic_parser.mly"
          ( () )
# 4436 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 966 "cil/src/logic/logic_parser.mly"
          ( () )
# 4442 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 967 "cil/src/logic/logic_parser.mly"
         ( () )
# 4448 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 968 "cil/src/logic/logic_parser.mly"
            ( () )
# 4454 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 969 "cil/src/logic/logic_parser.mly"
          ( () )
# 4460 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 970 "cil/src/logic/logic_parser.mly"
            ( () )
# 4466 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 971 "cil/src/logic/logic_parser.mly"
      ( () )
# 4472 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 972 "cil/src/logic/logic_parser.mly"
        ( () )
# 4478 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 973 "cil/src/logic/logic_parser.mly"
         ( () )
# 4484 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 974 "cil/src/logic/logic_parser.mly"
            ( () )
# 4490 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 975 "cil/src/logic/logic_parser.mly"
       ( () )
# 4496 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 976 "cil/src/logic/logic_parser.mly"
        ( () )
# 4502 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 977 "cil/src/logic/logic_parser.mly"
           ( () )
# 4508 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 978 "cil/src/logic/logic_parser.mly"
          ( () )
# 4514 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 979 "cil/src/logic/logic_parser.mly"
          ( () )
# 4520 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 980 "cil/src/logic/logic_parser.mly"
       ( () )
# 4526 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 981 "cil/src/logic/logic_parser.mly"
          ( () )
# 4532 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 982 "cil/src/logic/logic_parser.mly"
        ( () )
# 4538 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 983 "cil/src/logic/logic_parser.mly"
         ( () )
# 4544 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 984 "cil/src/logic/logic_parser.mly"
       ( () )
# 4550 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 985 "cil/src/logic/logic_parser.mly"
        ( () )
# 4556 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 986 "cil/src/logic/logic_parser.mly"
        ( () )
# 4562 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 987 "cil/src/logic/logic_parser.mly"
            ( () )
# 4568 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 988 "cil/src/logic/logic_parser.mly"
        ( () )
# 4574 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 989 "cil/src/logic/logic_parser.mly"
        ( () )
# 4580 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 990 "cil/src/logic/logic_parser.mly"
         ( () )
# 4586 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 991 "cil/src/logic/logic_parser.mly"
         ( () )
# 4592 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 992 "cil/src/logic/logic_parser.mly"
        ( () )
# 4598 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 993 "cil/src/logic/logic_parser.mly"
       ( () )
# 4604 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 994 "cil/src/logic/logic_parser.mly"
       ( () )
# 4610 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 995 "cil/src/logic/logic_parser.mly"
         ( () )
# 4616 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 996 "cil/src/logic/logic_parser.mly"
           ( () )
# 4622 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 997 "cil/src/logic/logic_parser.mly"
        ( () )
# 4628 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 998 "cil/src/logic/logic_parser.mly"
       ( () )
# 4634 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 999 "cil/src/logic/logic_parser.mly"
         ( () )
# 4640 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1000 "cil/src/logic/logic_parser.mly"
         ( () )
# 4646 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1001 "cil/src/logic/logic_parser.mly"
       ( () )
# 4652 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1002 "cil/src/logic/logic_parser.mly"
        ( () )
# 4658 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1003 "cil/src/logic/logic_parser.mly"
          ( () )
# 4664 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1004 "cil/src/logic/logic_parser.mly"
        ( () )
# 4670 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1005 "cil/src/logic/logic_parser.mly"
          ( () )
# 4676 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1006 "cil/src/logic/logic_parser.mly"
          ( () )
# 4682 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1007 "cil/src/logic/logic_parser.mly"
       ( () )
# 4688 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1008 "cil/src/logic/logic_parser.mly"
           ( () )
# 4694 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1009 "cil/src/logic/logic_parser.mly"
          ( () )
# 4700 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1010 "cil/src/logic/logic_parser.mly"
      ( () )
# 4706 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1011 "cil/src/logic/logic_parser.mly"
         ( () )
# 4712 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1012 "cil/src/logic/logic_parser.mly"
       ( () )
# 4718 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1013 "cil/src/logic/logic_parser.mly"
        ( () )
# 4724 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1014 "cil/src/logic/logic_parser.mly"
       ( () )
# 4730 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1015 "cil/src/logic/logic_parser.mly"
       ( () )
# 4736 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1016 "cil/src/logic/logic_parser.mly"
         ( () )
# 4742 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1017 "cil/src/logic/logic_parser.mly"
           ( () )
# 4748 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1018 "cil/src/logic/logic_parser.mly"
            ( () )
# 4754 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1019 "cil/src/logic/logic_parser.mly"
           ( () )
# 4760 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1020 "cil/src/logic/logic_parser.mly"
             ( () )
# 4766 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1021 "cil/src/logic/logic_parser.mly"
         ( () )
# 4772 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1022 "cil/src/logic/logic_parser.mly"
         ( () )
# 4778 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1023 "cil/src/logic/logic_parser.mly"
         ( () )
# 4784 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1024 "cil/src/logic/logic_parser.mly"
            ( () )
# 4790 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
(* Entry lexpr *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
(* Entry annot *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
(* Entry spec *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
|]
let yytables =
  { Parsing.actions=yyact;
    Parsing.transl_const=yytransl_const;
    Parsing.transl_block=yytransl_block;
    Parsing.lhs=yylhs;
    Parsing.len=yylen;
    Parsing.defred=yydefred;
    Parsing.dgoto=yydgoto;
    Parsing.sindex=yysindex;
    Parsing.rindex=yyrindex;
    Parsing.gindex=yygindex;
    Parsing.tablesize=yytablesize;
    Parsing.table=yytable;
    Parsing.check=yycheck;
    Parsing.error_function=parse_error;
    Parsing.names_const=yynames_const;
    Parsing.names_block=yynames_block }
let lexpr (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 1 lexfun lexbuf : Logic_ptree.lexpr)
let annot (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 2 lexfun lexbuf : Logic_ptree.annot)
let spec (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 3 lexfun lexbuf : Logic_ptree.spec * Cabs.cabsloc)
;;
