type token =
  | SPEC of (Lexing.position * string)
  | DECL of ((Cabs.cabsloc * Logic_ptree.decl) list)
  | CODE_ANNOT of (Logic_ptree.code_annot * Cabs.cabsloc)
  | LOOP_ANNOT of (Logic_ptree.code_annot list * Cabs.cabsloc)
  | ATTRIBUTE_ANNOT of (string * Cabs.cabsloc)
  | IDENT of (string * Cabs.cabsloc)
  | CST_CHAR of (int64 list * Cabs.cabsloc)
  | CST_WCHAR of (int64 list * Cabs.cabsloc)
  | CST_INT of (string * Cabs.cabsloc)
  | CST_FLOAT of (string * Cabs.cabsloc)
  | NAMED_TYPE of (string * Cabs.cabsloc)
  | CST_STRING of (int64 list * Cabs.cabsloc)
  | CST_WSTRING of (int64 list * Cabs.cabsloc)
  | EOF
  | BOOL of (Cabs.cabsloc)
  | CHAR of (Cabs.cabsloc)
  | INT of (Cabs.cabsloc)
  | DOUBLE of (Cabs.cabsloc)
  | FLOAT of (Cabs.cabsloc)
  | VOID of (Cabs.cabsloc)
  | INT64 of (Cabs.cabsloc)
  | INT32 of (Cabs.cabsloc)
  | ENUM of (Cabs.cabsloc)
  | STRUCT of (Cabs.cabsloc)
  | TYPEDEF of (Cabs.cabsloc)
  | UNION of (Cabs.cabsloc)
  | SIGNED of (Cabs.cabsloc)
  | UNSIGNED of (Cabs.cabsloc)
  | LONG of (Cabs.cabsloc)
  | SHORT of (Cabs.cabsloc)
  | VOLATILE of (Cabs.cabsloc)
  | EXTERN of (Cabs.cabsloc)
  | STATIC of (Cabs.cabsloc)
  | CONST of (Cabs.cabsloc)
  | RESTRICT of (Cabs.cabsloc)
  | AUTO of (Cabs.cabsloc)
  | REGISTER of (Cabs.cabsloc)
  | THREAD of (Cabs.cabsloc)
  | SIZEOF of (Cabs.cabsloc)
  | ALIGNOF of (Cabs.cabsloc)
  | EQ
  | PLUS_EQ
  | MINUS_EQ
  | STAR_EQ
  | SLASH_EQ
  | PERCENT_EQ
  | AND_EQ
  | PIPE_EQ
  | CIRC_EQ
  | INF_INF_EQ
  | SUP_SUP_EQ
  | ARROW
  | DOT
  | EQ_EQ
  | EXCLAM_EQ
  | INF
  | SUP
  | INF_EQ
  | SUP_EQ
  | PLUS of (Cabs.cabsloc)
  | MINUS of (Cabs.cabsloc)
  | STAR of (Cabs.cabsloc)
  | SLASH
  | PERCENT
  | TILDE of (Cabs.cabsloc)
  | AND of (Cabs.cabsloc)
  | PIPE
  | CIRC
  | EXCLAM of (Cabs.cabsloc)
  | AND_AND of (Cabs.cabsloc)
  | PIPE_PIPE
  | INF_INF
  | SUP_SUP
  | PLUS_PLUS of (Cabs.cabsloc)
  | MINUS_MINUS of (Cabs.cabsloc)
  | RPAREN
  | LPAREN of (Cabs.cabsloc)
  | RBRACE of (Cabs.cabsloc)
  | LBRACE of (Cabs.cabsloc)
  | LBRACKET
  | RBRACKET
  | COLON
  | SEMICOLON of (Cabs.cabsloc)
  | COMMA
  | ELLIPSIS
  | QUEST
  | BREAK of (Cabs.cabsloc)
  | CONTINUE of (Cabs.cabsloc)
  | GOTO of (Cabs.cabsloc)
  | RETURN of (Cabs.cabsloc)
  | SWITCH of (Cabs.cabsloc)
  | CASE of (Cabs.cabsloc)
  | DEFAULT of (Cabs.cabsloc)
  | WHILE of (Cabs.cabsloc)
  | DO of (Cabs.cabsloc)
  | FOR of (Cabs.cabsloc)
  | IF of (Cabs.cabsloc)
  | TRY of (Cabs.cabsloc)
  | EXCEPT of (Cabs.cabsloc)
  | FINALLY of (Cabs.cabsloc)
  | ELSE
  | ATTRIBUTE of (Cabs.cabsloc)
  | INLINE of (Cabs.cabsloc)
  | ASM of (Cabs.cabsloc)
  | TYPEOF of (Cabs.cabsloc)
  | FUNCTION__ of (Cabs.cabsloc)
  | PRETTY_FUNCTION__ of (Cabs.cabsloc)
  | LABEL__
  | BUILTIN_VA_ARG of (Cabs.cabsloc)
  | ATTRIBUTE_USED of (Cabs.cabsloc)
  | BUILTIN_VA_LIST
  | BLOCKATTRIBUTE
  | BUILTIN_TYPES_COMPAT of (Cabs.cabsloc)
  | BUILTIN_OFFSETOF of (Cabs.cabsloc)
  | DECLSPEC of (Cabs.cabsloc)
  | MSASM of (string * Cabs.cabsloc)
  | MSATTR of (string * Cabs.cabsloc)
  | PRAGMA_LINE of (string * Cabs.cabsloc)
  | PRAGMA of (Cabs.cabsloc)
  | PRAGMA_EOL
  | AT_TRANSFORM of (Cabs.cabsloc)
  | AT_TRANSFORMEXPR of (Cabs.cabsloc)
  | AT_SPECIFIER of (Cabs.cabsloc)
  | AT_EXPR of (Cabs.cabsloc)
  | AT_NAME
  | LGHOST
  | RGHOST

open Parsing;;
# 47 "cil/src/frontc/cparser.mly"

open Cabs
open Cabshelper
let parse_error msg = Errorloc.parse_error msg

(* unit -> string option *)
(*
let getComments () =
  match !comments with
    [] -> None
  | _ ->
      let r = Some(String.concat "\n" (List.rev !comments)) in
      comments := [];
      r
*)

(*CEA: note - There is a [cabslu] value inside the opened [Cabshelper] module.
   question - Why to define another [cabslu] here?
  let cabslu = {lineno = -10;
	      filename = "cabs loc unknown";
	      byteno = -10;
              ident = 0;}
*)

(* cabsloc -> cabsloc *)
(*
let handleLoc l =
  l.clcomment <- getComments();
  l
*)

(*
** Expression building
*)
let smooth_expression lst =
  match lst with
    [] -> NOTHING
  | [expr] -> expr
  | _ -> COMMA (lst)


let currentFunctionName = ref "<outside any function>"

(* Go through all the parameter names and mark them as identifiers *)
let rec findProto = function
    PROTO (d, args, _) when isJUSTBASE d ->
      List.iter (fun (_, (an, _, _, _)) -> !Lexerhack.add_identifier an) args
  | PROTO (d, _, _) -> findProto d
  | PARENTYPE (_, d, _) -> findProto d
  | PTR (_, d) -> findProto d
  | ARRAY (d, _, _) -> findProto d
  | _ -> raise Parsing.Parse_error

and isJUSTBASE = function
    JUSTBASE -> true
  | PARENTYPE (_, d, _) -> isJUSTBASE d
  | _ -> false

let announceFunctionName ((n, decl, _, _):name) =
  !Lexerhack.add_identifier n;
  (* Start a context that includes the parameter names and the whole body.
   * Will pop when we finish parsing the function body *)
  !Lexerhack.push_context ();
  (try findProto decl
   with Parsing.Parse_error ->
     parse_error "Cannot find the prototype in a function definition");
  currentFunctionName := n



let applyPointer (ptspecs: attribute list list) (dt: decl_type)
       : decl_type =
  (* Outer specification first *)
  let rec loop = function
      [] -> dt
    | attrs :: rest -> PTR(attrs, loop rest)
  in
  loop ptspecs

let doDeclaration logic_spec (loc: cabsloc) (specs: spec_elem list) (nl: init_name list)  =
  if isTypedef specs then begin
    (* Tell the lexer about the new type names *)
    List.iter (fun ((n, _, _, _), _) -> !Lexerhack.add_type n) nl;
    TYPEDEF ((specs, List.map (fun (n, _) -> n) nl), loc)
  end else
    if nl = [] then
      ONLYTYPEDEF (specs, loc)
    else begin
      (* Tell the lexer about the new variable names *)
      List.iter (fun ((n, _, _, _), _) -> !Lexerhack.add_identifier n) nl;
      !Lexerhack.push_context ();
      List.iter
        (fun ((_,t,_,_),_) ->
           try findProto t with Parsing.Parse_error -> ())
        nl;
      let logic_spec =
        match logic_spec with
            None -> None
          | Some ls ->
	      Cabshelper.continue_annot loc
		(fun () -> Some (Logic_lexer.spec ls))
		(fun () -> None)
		"Skipping annotation"
      in
      !Lexerhack.pop_context ();
      DECDEF (logic_spec, (specs, nl), loc)
    end


let doFunctionDef spec (loc: cabsloc)
                  (lend: cabsloc)
                  (specs: spec_elem list)
                  (n: name)
                  (b: block) : definition =
  let fname = (specs, n) in
  FUNDEF (spec, fname, b, loc, lend)

let doOldParDecl (names: string list)
                 ((pardefs: name_group list), (isva: bool))
    : single_name list * bool =
  let findOneName n =
    (* Search in pardefs for the definition for this parameter *)
    let rec loopGroups = function
        [] -> ([SpecType Tint], (n, JUSTBASE, [], cabslu))
      | (specs, names) :: restgroups ->
          let rec loopNames = function
              [] -> loopGroups restgroups
            | ((n',_, _, _) as sn) :: _ when n' = n -> (specs, sn)
            | _ :: restnames -> loopNames restnames
          in
          loopNames names
    in
    loopGroups pardefs
  in
  let args = List.map findOneName names in
  (args, isva)

let checkConnective (s : string) : unit =
begin
  (* checking this means I could possibly have more connectives, with *)
  (* different meaning *)
  if (s <> "to") then parse_error "transformer connective must be 'to'";
end

let int64_to_char value =
  if (compare value (Int64.of_int 255) > 0) || (compare value Int64.zero < 0) then
    parse_error (Printf.sprintf "integral literal 0x%Lx too big" value)
  else
    Char.chr (Int64.to_int value)

(* takes a not-nul-terminated list, and converts it to a string. *)
let rec intlist_to_string (str: int64 list):string =
  match str with
    [] -> ""  (* add nul-termination *)
  | value::rest ->
      let this_char = int64_to_char value in
      (String.make 1 this_char) ^ (intlist_to_string rest)

let fst3 (result, _, _) = result
let snd3 (_, result, _) = result
let trd3 (_, _, result) = result

let fourth4 (_,_,_,result) = result

(*
   transform:  __builtin_offsetof(type, member)
   into     :  (size_t) (&(type * ) 0)->member
 *)

let transformOffsetOf (speclist, dtype) member =
  let rec addPointer = function
    | JUSTBASE ->
	PTR([], JUSTBASE)
    | PARENTYPE (attrs1, dtype, attrs2) ->
	PARENTYPE (attrs1, addPointer dtype, attrs2)
    | ARRAY (dtype, attrs, expr) ->
	ARRAY (addPointer dtype, attrs, expr)
    | PTR (attrs, dtype) ->
	PTR (attrs, addPointer dtype)
    | PROTO (dtype, names, variadic) ->
	PROTO (addPointer dtype, names, variadic)
  in
  let nullType = (speclist, addPointer dtype) in
  let nullExpr = CONSTANT (CONST_INT "0") in
  let castExpr = CAST (nullType, SINGLE_INIT nullExpr) in

  let rec replaceBase = function
    | VARIABLE field ->
	MEMBEROFPTR (castExpr, field)
    | MEMBEROF (base, field) ->
	MEMBEROF (replaceBase base, field)
    | INDEX (base, index) ->
	INDEX (replaceBase base, index)
    | _ -> 
	parse_error "malformed offset expression in __builtin_offsetof"
  in
  let memberExpr = replaceBase member in
  let addrExpr = UNARY (ADDROF, memberExpr) in
  (* slight cheat: hard-coded assumption that size_t == unsigned int *)
  let sizeofType = [SpecType Tunsigned], JUSTBASE in
  let resultExpr = CAST (sizeofType, SINGLE_INIT addrExpr) in
  resultExpr


let no_ghost s = {stmt_ghost = false ; stmt_node = s}
let in_ghost s =
  let ghost_me = object
    inherit Cabsvisit.nopCabsVisitor
    method vstmt s =
      s.stmt_ghost <- true;
      Cil.DoChildren
  end
  in
  ignore (Cabsvisit.visitCabsStatement ghost_me s)

# 348 "cil/src/frontc/cparser.ml"
let yytransl_const = [|
    0 (* EOF *);
  296 (* EQ *);
  297 (* PLUS_EQ *);
  298 (* MINUS_EQ *);
  299 (* STAR_EQ *);
  300 (* SLASH_EQ *);
  301 (* PERCENT_EQ *);
  302 (* AND_EQ *);
  303 (* PIPE_EQ *);
  304 (* CIRC_EQ *);
  305 (* INF_INF_EQ *);
  306 (* SUP_SUP_EQ *);
  307 (* ARROW *);
  308 (* DOT *);
  309 (* EQ_EQ *);
  310 (* EXCLAM_EQ *);
  311 (* INF *);
  312 (* SUP *);
  313 (* INF_EQ *);
  314 (* SUP_EQ *);
  318 (* SLASH *);
  319 (* PERCENT *);
  322 (* PIPE *);
  323 (* CIRC *);
  326 (* PIPE_PIPE *);
  327 (* INF_INF *);
  328 (* SUP_SUP *);
  331 (* RPAREN *);
  335 (* LBRACKET *);
  336 (* RBRACKET *);
  337 (* COLON *);
  339 (* COMMA *);
  340 (* ELLIPSIS *);
  341 (* QUEST *);
  356 (* ELSE *);
  363 (* LABEL__ *);
  366 (* BUILTIN_VA_LIST *);
  367 (* BLOCKATTRIBUTE *);
  375 (* PRAGMA_EOL *);
  380 (* AT_NAME *);
  381 (* LGHOST *);
  382 (* RGHOST *);
    0|]

let yytransl_block = [|
  257 (* SPEC *);
  258 (* DECL *);
  259 (* CODE_ANNOT *);
  260 (* LOOP_ANNOT *);
  261 (* ATTRIBUTE_ANNOT *);
  262 (* IDENT *);
  263 (* CST_CHAR *);
  264 (* CST_WCHAR *);
  265 (* CST_INT *);
  266 (* CST_FLOAT *);
  267 (* NAMED_TYPE *);
  268 (* CST_STRING *);
  269 (* CST_WSTRING *);
  270 (* BOOL *);
  271 (* CHAR *);
  272 (* INT *);
  273 (* DOUBLE *);
  274 (* FLOAT *);
  275 (* VOID *);
  276 (* INT64 *);
  277 (* INT32 *);
  278 (* ENUM *);
  279 (* STRUCT *);
  280 (* TYPEDEF *);
  281 (* UNION *);
  282 (* SIGNED *);
  283 (* UNSIGNED *);
  284 (* LONG *);
  285 (* SHORT *);
  286 (* VOLATILE *);
  287 (* EXTERN *);
  288 (* STATIC *);
  289 (* CONST *);
  290 (* RESTRICT *);
  291 (* AUTO *);
  292 (* REGISTER *);
  293 (* THREAD *);
  294 (* SIZEOF *);
  295 (* ALIGNOF *);
  315 (* PLUS *);
  316 (* MINUS *);
  317 (* STAR *);
  320 (* TILDE *);
  321 (* AND *);
  324 (* EXCLAM *);
  325 (* AND_AND *);
  329 (* PLUS_PLUS *);
  330 (* MINUS_MINUS *);
  332 (* LPAREN *);
  333 (* RBRACE *);
  334 (* LBRACE *);
  338 (* SEMICOLON *);
  342 (* BREAK *);
  343 (* CONTINUE *);
  344 (* GOTO *);
  345 (* RETURN *);
  346 (* SWITCH *);
  347 (* CASE *);
  348 (* DEFAULT *);
  349 (* WHILE *);
  350 (* DO *);
  351 (* FOR *);
  352 (* IF *);
  353 (* TRY *);
  354 (* EXCEPT *);
  355 (* FINALLY *);
  357 (* ATTRIBUTE *);
  358 (* INLINE *);
  359 (* ASM *);
  360 (* TYPEOF *);
  361 (* FUNCTION__ *);
  362 (* PRETTY_FUNCTION__ *);
  364 (* BUILTIN_VA_ARG *);
  365 (* ATTRIBUTE_USED *);
  368 (* BUILTIN_TYPES_COMPAT *);
  369 (* BUILTIN_OFFSETOF *);
  370 (* DECLSPEC *);
  371 (* MSASM *);
  372 (* MSATTR *);
  373 (* PRAGMA_LINE *);
  374 (* PRAGMA *);
  376 (* AT_TRANSFORM *);
  377 (* AT_TRANSFORMEXPR *);
  378 (* AT_SPECIFIER *);
  379 (* AT_EXPR *);
    0|]

let yylhs = "\255\255\
\001\000\002\000\003\000\003\000\003\000\003\000\050\000\052\000\
\052\000\052\000\004\000\004\000\004\000\004\000\004\000\004\000\
\004\000\004\000\004\000\004\000\004\000\004\000\055\000\055\000\
\056\000\056\000\057\000\057\000\058\000\058\000\058\000\058\000\
\058\000\059\000\059\000\059\000\059\000\059\000\059\000\059\000\
\059\000\059\000\059\000\059\000\060\000\060\000\060\000\062\000\
\062\000\062\000\062\000\062\000\062\000\062\000\062\000\062\000\
\062\000\062\000\062\000\062\000\062\000\063\000\063\000\064\000\
\064\000\064\000\064\000\065\000\065\000\065\000\066\000\066\000\
\066\000\067\000\067\000\067\000\067\000\067\000\068\000\068\000\
\068\000\069\000\069\000\070\000\070\000\071\000\071\000\072\000\
\072\000\073\000\073\000\074\000\074\000\075\000\075\000\075\000\
\075\000\075\000\075\000\075\000\075\000\075\000\075\000\075\000\
\075\000\010\000\008\000\008\000\008\000\008\000\008\000\008\000\
\009\000\076\000\017\000\017\000\018\000\018\000\018\000\077\000\
\077\000\077\000\012\000\012\000\020\000\020\000\061\000\061\000\
\019\000\019\000\019\000\078\000\078\000\021\000\021\000\021\000\
\022\000\022\000\079\000\015\000\015\000\011\000\011\000\013\000\
\013\000\013\000\080\000\080\000\014\000\014\000\016\000\016\000\
\034\000\034\000\081\000\082\000\082\000\035\000\035\000\035\000\
\035\000\035\000\084\000\084\000\086\000\086\000\036\000\036\000\
\037\000\037\000\087\000\087\000\085\000\085\000\085\000\085\000\
\085\000\085\000\085\000\085\000\085\000\085\000\085\000\085\000\
\085\000\085\000\085\000\085\000\085\000\085\000\085\000\085\000\
\085\000\085\000\085\000\085\000\085\000\088\000\088\000\094\000\
\095\000\089\000\089\000\030\000\030\000\030\000\030\000\040\000\
\040\000\039\000\039\000\023\000\023\000\023\000\023\000\023\000\
\023\000\023\000\023\000\023\000\023\000\096\000\096\000\097\000\
\097\000\024\000\024\000\024\000\024\000\024\000\024\000\024\000\
\024\000\024\000\024\000\024\000\024\000\024\000\024\000\024\000\
\024\000\024\000\024\000\024\000\024\000\024\000\024\000\024\000\
\024\000\024\000\024\000\024\000\024\000\024\000\024\000\025\000\
\025\000\025\000\025\000\025\000\025\000\043\000\043\000\042\000\
\042\000\042\000\029\000\029\000\029\000\028\000\028\000\041\000\
\044\000\044\000\044\000\044\000\044\000\100\000\101\000\101\000\
\102\000\102\000\102\000\027\000\027\000\027\000\027\000\026\000\
\103\000\103\000\038\000\038\000\054\000\054\000\054\000\104\000\
\104\000\104\000\048\000\049\000\049\000\033\000\033\000\047\000\
\047\000\045\000\045\000\045\000\045\000\046\000\046\000\031\000\
\031\000\032\000\032\000\032\000\032\000\032\000\051\000\051\000\
\051\000\051\000\005\000\005\000\006\000\006\000\006\000\098\000\
\098\000\098\000\098\000\091\000\091\000\105\000\105\000\105\000\
\105\000\105\000\107\000\107\000\099\000\099\000\053\000\053\000\
\053\000\109\000\109\000\109\000\109\000\109\000\109\000\109\000\
\109\000\109\000\109\000\109\000\110\000\110\000\110\000\110\000\
\110\000\110\000\111\000\111\000\111\000\111\000\111\000\111\000\
\111\000\111\000\111\000\111\000\111\000\112\000\113\000\113\000\
\113\000\113\000\114\000\114\000\114\000\115\000\115\000\115\000\
\116\000\116\000\116\000\116\000\116\000\117\000\117\000\117\000\
\118\000\118\000\119\000\119\000\120\000\120\000\121\000\121\000\
\122\000\122\000\123\000\123\000\108\000\124\000\124\000\124\000\
\125\000\125\000\083\000\083\000\106\000\106\000\007\000\007\000\
\007\000\092\000\092\000\093\000\093\000\126\000\126\000\128\000\
\128\000\129\000\129\000\127\000\127\000\130\000\130\000\131\000\
\131\000\132\000\132\000\090\000\000\000\000\000"

let yylen = "\002\000\
\002\000\001\000\000\000\002\000\003\000\002\000\000\000\002\000\
\002\000\001\000\001\000\001\000\001\000\003\000\005\000\005\000\
\001\000\006\000\004\000\008\000\008\000\003\000\001\000\001\000\
\001\000\004\000\000\000\001\000\001\000\001\000\001\000\003\000\
\004\000\001\000\002\000\004\000\006\000\006\000\006\000\003\000\
\003\000\002\000\002\000\006\000\001\000\003\000\002\000\001\000\
\002\000\002\000\002\000\004\000\002\000\004\000\002\000\002\000\
\002\000\002\000\002\000\002\000\002\000\001\000\004\000\001\000\
\003\000\003\000\003\000\001\000\003\000\003\000\001\000\003\000\
\003\000\001\000\003\000\003\000\003\000\003\000\001\000\003\000\
\003\000\001\000\003\000\001\000\003\000\001\000\003\000\001\000\
\003\000\001\000\003\000\001\000\005\000\001\000\003\000\003\000\
\003\000\003\000\003\000\003\000\003\000\003\000\003\000\003\000\
\003\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\002\000\001\000\002\000\002\000\001\000\
\001\000\001\000\001\000\003\000\001\000\003\000\000\000\001\000\
\003\000\002\000\001\000\001\000\000\000\003\000\004\000\005\000\
\000\000\001\000\002\000\000\000\001\000\000\000\001\000\001\000\
\003\000\003\000\000\000\001\000\003\000\003\000\003\000\003\000\
\005\000\003\000\001\000\000\000\002\000\001\000\003\000\003\000\
\003\000\003\000\000\000\001\000\002\000\004\000\000\000\004\000\
\001\000\003\000\001\000\002\000\001\000\002\000\002\000\001\000\
\003\000\005\000\003\000\004\000\006\000\010\000\004\000\004\000\
\006\000\002\000\002\000\003\000\002\000\002\000\003\000\004\000\
\007\000\001\000\005\000\004\000\003\000\000\000\001\000\001\000\
\001\000\002\000\001\000\003\000\002\000\004\000\003\000\001\000\
\003\000\001\000\003\000\002\000\002\000\002\000\002\000\002\000\
\002\000\002\000\002\000\002\000\004\000\000\000\001\000\000\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\002\000\003\000\005\000\004\000\
\006\000\005\000\002\000\005\000\004\000\006\000\005\000\002\000\
\006\000\005\000\007\000\006\000\001\000\004\000\004\000\000\000\
\003\000\002\000\004\000\002\000\003\000\001\000\003\000\001\000\
\004\000\002\000\001\000\003\000\003\000\001\000\003\000\003\000\
\001\000\004\000\005\000\005\000\004\000\001\000\000\000\002\000\
\000\000\002\000\003\000\002\000\002\000\001\000\003\000\002\000\
\005\000\003\000\001\000\003\000\000\000\004\000\004\000\001\000\
\003\000\001\000\003\000\000\000\001\000\002\000\001\000\003\000\
\001\000\004\000\003\000\004\000\004\000\001\000\000\000\003\000\
\002\000\002\000\002\000\004\000\005\000\003\000\001\000\001\000\
\001\000\001\000\000\000\002\000\000\000\002\000\005\000\004\000\
\002\000\001\000\001\000\000\000\002\000\001\000\001\000\001\000\
\001\000\001\000\004\000\002\000\001\000\002\000\003\000\004\000\
\001\000\001\000\001\000\003\000\002\000\001\000\001\000\001\000\
\003\000\003\000\003\000\001\000\001\000\003\000\002\000\003\000\
\003\000\004\000\001\000\002\000\004\000\002\000\004\000\002\000\
\002\000\002\000\002\000\002\000\002\000\001\000\001\000\003\000\
\003\000\003\000\001\000\003\000\003\000\001\000\003\000\003\000\
\001\000\003\000\003\000\003\000\003\000\001\000\003\000\003\000\
\001\000\003\000\001\000\003\000\001\000\003\000\001\000\003\000\
\001\000\003\000\001\000\005\000\001\000\001\000\003\000\003\000\
\000\000\001\000\003\000\003\000\003\000\003\000\000\000\002\000\
\002\000\001\000\002\000\000\000\003\000\000\000\001\000\001\000\
\003\000\005\000\005\000\000\000\003\000\000\000\003\000\000\000\
\002\000\001\000\003\000\000\000\002\000\002\000"

let yydefred = "\000\000\
\000\000\000\000\000\000\000\000\011\000\066\001\000\000\253\000\
\228\000\227\000\230\000\234\000\233\000\226\000\232\000\000\000\
\000\000\000\000\000\000\235\000\236\000\231\000\229\000\064\001\
\000\000\000\000\063\001\065\001\000\000\000\000\075\001\000\000\
\000\000\000\000\000\000\000\000\000\000\074\001\089\001\000\000\
\000\000\000\000\000\000\000\000\181\001\000\000\002\000\000\000\
\000\000\000\000\012\000\013\000\000\000\000\000\000\000\017\000\
\000\000\182\001\000\000\000\000\000\000\000\000\000\000\000\000\
\023\000\024\000\000\000\000\000\000\000\000\000\025\000\000\000\
\000\000\000\000\000\000\000\000\000\000\223\000\212\000\000\000\
\000\000\000\000\120\000\121\000\122\000\000\000\000\000\115\000\
\213\000\214\000\215\000\216\000\006\000\000\000\218\000\000\000\
\000\000\000\000\073\001\000\000\000\000\091\001\100\001\096\001\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\095\001\000\000\101\001\000\000\118\001\119\001\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\149\001\000\000\000\000\000\000\010\000\000\000\
\000\000\000\000\001\000\004\000\000\000\205\000\059\001\000\000\
\000\000\000\000\045\001\000\000\225\000\217\000\007\000\155\000\
\057\001\000\000\000\000\219\000\220\000\000\000\207\000\000\000\
\056\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\011\001\000\000\000\000\084\001\000\000\000\000\000\000\
\000\000\086\001\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\014\000\116\000\000\000\000\000\000\000\029\000\109\000\
\110\000\107\000\108\000\117\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\030\000\111\000\000\000\031\000\
\000\000\000\000\000\000\034\000\000\000\062\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\094\000\106\000\000\000\000\000\000\000\093\001\000\000\
\000\000\103\001\000\000\000\000\108\001\000\000\110\001\112\001\
\113\001\114\001\117\001\115\001\116\001\000\000\000\000\000\000\
\087\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\008\000\009\000\005\000\082\001\081\001\079\001\
\080\001\000\000\078\001\000\000\000\000\204\000\000\000\000\000\
\000\000\017\001\032\001\000\000\000\000\000\000\022\000\062\001\
\000\000\206\000\000\000\019\000\000\000\000\000\028\001\029\001\
\000\000\000\000\000\000\024\001\060\001\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\002\001\000\000\
\000\000\000\000\000\000\000\000\000\000\240\000\004\001\000\000\
\000\000\000\000\245\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\154\001\000\000\072\001\000\000\000\000\051\000\
\000\000\053\000\055\000\056\000\057\000\060\000\058\000\059\000\
\061\000\000\000\049\000\050\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\254\000\119\000\118\000\
\046\001\000\000\255\000\000\000\000\000\042\000\043\000\000\000\
\000\000\035\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\156\001\000\000\000\000\155\001\102\001\097\001\098\001\000\000\
\000\000\092\001\099\001\088\001\104\001\105\001\000\000\120\001\
\121\001\122\001\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\221\000\043\001\068\001\209\000\
\000\000\123\000\211\000\000\000\000\000\000\000\000\000\016\001\
\000\000\000\000\154\000\000\000\000\000\000\000\000\000\000\000\
\036\001\000\000\000\000\031\001\000\000\000\000\000\000\000\000\
\026\001\000\000\015\001\013\001\012\001\250\000\083\001\026\000\
\000\000\000\000\000\000\005\001\010\001\001\001\000\000\000\000\
\000\000\239\000\242\000\000\000\244\000\247\000\000\000\015\000\
\158\001\157\001\016\000\000\000\000\000\000\000\150\000\000\000\
\000\000\149\000\000\000\032\000\000\000\000\000\000\000\000\000\
\000\000\041\000\040\000\000\000\141\000\000\000\000\000\000\000\
\095\000\096\000\097\000\098\000\099\000\100\000\101\000\102\000\
\103\000\104\000\105\000\065\000\066\000\067\000\064\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\143\000\
\000\000\152\001\151\001\000\000\000\000\106\001\000\000\000\000\
\000\000\000\000\000\000\000\000\131\000\000\000\128\000\000\000\
\000\000\000\000\000\000\000\000\034\001\000\000\000\000\000\000\
\000\000\070\001\000\000\000\000\157\000\000\000\000\000\000\000\
\000\000\164\000\061\001\042\001\000\000\000\000\018\000\000\000\
\000\000\022\001\048\001\000\000\000\000\027\001\249\000\252\000\
\000\000\000\000\007\001\003\001\241\000\246\000\000\000\000\000\
\000\000\146\000\145\000\000\000\063\000\000\000\000\000\000\000\
\033\000\000\000\036\000\152\000\151\000\000\000\148\001\000\000\
\000\000\000\000\000\000\000\000\132\000\000\000\139\000\124\000\
\130\000\018\001\000\000\000\000\148\000\000\000\000\000\021\001\
\168\000\170\000\165\000\000\000\153\000\000\000\000\000\201\000\
\000\000\173\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\194\000\000\000\000\000\176\000\
\000\000\000\000\000\000\000\000\199\000\200\000\000\000\000\000\
\051\001\000\000\000\000\000\000\251\000\009\001\000\000\000\000\
\000\000\045\000\000\000\093\000\000\000\000\000\138\000\134\000\
\000\000\000\000\126\000\129\000\033\001\020\001\019\001\000\000\
\000\000\000\000\000\000\000\000\171\000\000\000\174\000\189\000\
\190\000\000\000\000\000\187\000\000\000\000\000\000\000\000\000\
\186\000\000\000\000\000\000\000\000\000\000\000\175\000\159\000\
\161\000\000\000\160\000\000\000\000\000\000\000\041\001\038\001\
\039\001\050\001\053\001\052\001\044\000\037\000\038\000\000\000\
\039\000\047\000\020\000\021\000\135\000\000\000\071\001\166\000\
\197\000\000\000\172\000\000\000\191\000\188\000\000\000\179\000\
\000\000\000\000\000\000\000\000\000\000\160\001\161\001\000\000\
\000\000\000\000\000\000\000\000\000\000\046\000\136\000\192\000\
\184\000\000\000\000\000\000\000\196\000\114\000\000\000\000\000\
\183\000\077\001\180\000\000\000\000\000\203\000\000\000\000\000\
\178\000\195\000\163\001\000\000\000\000\000\000\202\000\000\000\
\185\000\000\000\000\000\000\000\168\001\000\000\000\000\181\000\
\000\000\000\000\000\000\165\001\000\000\000\000\193\000\000\000\
\175\001\000\000\169\001\000\000\000\000\000\000\173\001\000\000\
\000\000\180\001\000\000\177\001\171\001\170\001\182\000\000\000\
\179\001"

let yydgoto = "\003\000\
\045\000\046\000\047\000\048\000\042\001\216\001\222\002\221\000\
\222\000\118\001\055\002\069\002\166\002\224\000\022\002\138\001\
\087\000\225\000\070\002\071\002\072\002\192\002\181\000\050\000\
\182\000\143\000\167\000\170\000\171\000\051\000\052\000\053\000\
\227\000\168\002\088\002\054\001\220\001\164\000\144\000\145\000\
\097\001\083\001\084\001\230\001\231\001\232\001\178\002\147\000\
\085\001\054\000\055\000\138\000\183\000\227\001\071\000\050\001\
\072\001\228\000\229\000\187\002\074\002\230\000\231\000\232\000\
\233\000\234\000\235\000\236\000\237\000\238\000\239\000\240\000\
\241\000\242\000\243\000\023\003\088\000\134\002\075\002\142\002\
\154\000\223\001\099\000\089\002\205\002\206\002\207\002\172\002\
\031\003\071\003\009\003\024\003\037\003\173\002\174\002\089\000\
\150\000\057\000\073\000\064\000\168\000\068\001\051\001\094\002\
\044\001\197\000\074\000\245\000\117\000\118\000\119\000\120\000\
\121\000\122\000\123\000\124\000\125\000\126\000\127\000\128\000\
\129\000\130\000\131\000\246\000\100\001\043\003\052\003\044\003\
\045\003\046\003\063\003\068\003"

let yysindex = "\200\000\
\161\006\161\006\000\000\023\016\000\000\000\000\016\255\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\118\255\
\042\000\020\017\103\000\000\000\000\000\000\000\000\000\000\000\
\103\015\020\017\000\000\000\000\020\017\020\017\000\000\161\006\
\044\255\020\017\155\255\157\255\187\255\000\000\000\000\253\027\
\230\255\005\000\207\255\124\006\000\000\064\001\000\000\161\006\
\043\255\053\017\000\000\000\000\081\255\095\000\020\017\000\000\
\020\017\000\000\035\000\020\017\251\255\081\255\182\000\133\016\
\000\000\000\000\196\000\136\000\187\255\159\000\000\000\167\000\
\189\255\233\255\187\012\177\000\060\000\000\000\000\000\187\012\
\191\000\181\000\000\000\000\000\000\000\197\013\013\000\000\000\
\000\000\000\000\000\000\000\000\000\000\161\000\000\000\013\000\
\173\014\110\027\000\000\112\255\223\000\000\000\000\000\000\000\
\168\018\239\018\253\027\253\027\253\027\253\027\253\027\253\027\
\253\027\238\000\000\000\015\255\000\000\028\255\000\000\000\000\
\053\001\063\000\192\000\081\001\031\001\036\000\210\000\009\001\
\010\001\093\000\000\000\160\013\002\019\087\001\000\000\124\006\
\124\006\161\006\000\000\000\000\062\005\000\000\000\000\006\001\
\027\001\108\001\000\000\020\000\000\000\000\000\000\000\000\000\
\000\000\021\001\070\001\000\000\000\000\182\000\000\000\076\001\
\000\000\085\001\107\001\095\001\133\016\131\001\122\001\140\001\
\178\001\000\000\138\001\161\000\000\000\219\001\196\000\196\000\
\159\001\000\000\186\001\187\012\210\255\202\001\187\012\187\012\
\187\012\207\001\227\001\187\012\187\012\254\001\020\017\161\006\
\043\255\000\000\000\000\146\027\007\002\014\002\000\000\000\000\
\000\000\000\000\000\000\000\000\073\019\092\019\002\019\002\019\
\002\019\002\019\002\019\002\019\044\000\163\019\163\019\036\010\
\017\002\018\002\021\002\022\002\000\000\000\000\015\002\000\000\
\025\000\131\001\032\002\000\000\176\003\000\000\216\001\071\001\
\046\001\083\001\155\001\111\001\037\002\043\002\045\002\056\002\
\129\000\000\000\000\000\214\255\029\002\052\002\000\000\039\027\
\125\002\000\000\127\002\036\010\000\000\036\010\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\062\002\129\002\028\002\
\000\000\100\255\100\255\253\027\253\027\253\027\253\027\253\027\
\253\027\253\027\253\027\253\027\253\027\253\027\253\027\253\027\
\253\027\253\027\253\027\253\027\253\027\253\027\253\027\069\002\
\082\002\073\002\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\131\001\000\000\062\005\131\001\000\000\196\017\062\005\
\090\001\000\000\000\000\100\002\044\000\086\002\000\000\000\000\
\124\002\000\000\182\000\000\000\020\017\131\002\000\000\000\000\
\000\000\074\000\136\015\000\000\000\000\002\019\075\000\123\002\
\132\002\133\002\138\001\138\001\196\000\187\012\000\000\002\019\
\187\012\128\002\130\002\136\002\020\000\000\000\000\000\134\002\
\135\002\187\012\000\000\142\002\146\002\187\012\251\255\149\002\
\108\001\014\000\000\000\152\002\000\000\154\002\036\010\000\000\
\036\010\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\036\010\000\000\000\000\140\000\145\002\164\002\165\002\
\166\002\002\019\020\017\020\017\204\002\000\000\000\000\000\000\
\000\000\155\002\000\000\100\255\100\255\000\000\000\000\197\011\
\216\011\000\000\002\019\002\019\002\019\002\019\002\019\002\019\
\002\019\002\019\002\019\002\019\002\019\002\019\002\019\002\019\
\002\019\002\019\002\019\002\019\002\019\002\019\002\019\002\019\
\002\019\002\019\002\019\002\019\002\019\002\019\002\019\197\011\
\000\000\217\027\217\027\000\000\000\000\000\000\000\000\179\002\
\180\002\000\000\000\000\000\000\000\000\000\000\176\002\000\000\
\000\000\000\000\053\001\053\001\063\000\063\000\192\000\192\000\
\192\000\192\000\081\001\081\001\031\001\036\000\210\000\009\001\
\010\001\182\002\003\003\004\003\000\000\000\000\000\000\000\000\
\245\014\000\000\000\000\131\001\182\000\062\005\191\002\000\000\
\133\016\166\001\000\000\193\002\194\002\187\255\054\255\020\017\
\000\000\065\255\201\002\000\000\113\001\211\017\144\008\197\002\
\000\000\122\001\000\000\000\000\000\000\000\000\000\000\000\000\
\224\002\254\002\138\001\000\000\000\000\000\000\002\019\130\255\
\187\012\000\000\000\000\255\002\000\000\000\000\000\003\000\000\
\000\000\000\000\000\000\005\003\006\003\007\003\000\000\197\011\
\197\011\000\000\016\018\000\000\251\002\252\002\008\003\011\003\
\113\001\000\000\000\000\012\003\000\000\015\003\133\000\014\003\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\071\001\
\071\001\046\001\046\001\083\001\083\001\083\001\083\001\155\001\
\155\001\111\001\037\002\043\002\045\002\056\002\018\003\000\000\
\013\003\000\000\000\000\009\003\009\003\000\000\253\027\023\003\
\025\003\000\000\100\255\002\019\000\000\021\003\000\000\065\003\
\026\003\031\003\196\017\034\003\000\000\047\003\031\012\013\000\
\048\003\000\000\021\001\044\000\000\000\054\255\054\255\054\003\
\173\009\000\000\000\000\000\000\041\003\052\003\000\000\058\003\
\131\001\000\000\000\000\133\016\197\011\000\000\000\000\000\000\
\066\003\062\005\000\000\000\000\000\000\000\000\009\003\009\003\
\009\003\000\000\000\000\245\014\000\000\020\017\020\017\100\255\
\000\000\131\001\000\000\000\000\000\000\002\019\000\000\161\006\
\002\019\249\255\080\000\245\014\000\000\196\017\000\000\000\000\
\000\000\000\000\020\017\178\000\000\000\055\003\069\003\000\000\
\000\000\000\000\000\000\019\003\000\000\012\003\015\005\000\000\
\000\000\000\000\071\003\080\003\055\255\088\011\087\003\002\019\
\096\003\087\003\081\255\044\001\000\000\099\003\054\255\000\000\
\054\255\108\003\054\255\067\001\000\000\000\000\065\255\166\016\
\000\000\115\003\116\003\117\003\000\000\000\000\122\003\125\003\
\126\003\000\000\026\255\000\000\127\003\128\003\000\000\000\000\
\249\255\002\019\000\000\000\000\000\000\000\000\000\000\062\005\
\054\255\149\000\011\006\121\003\000\000\226\010\000\000\000\000\
\000\000\197\011\124\003\000\000\129\003\050\012\011\006\194\000\
\000\000\011\006\074\001\044\001\044\001\134\003\000\000\000\000\
\000\000\169\000\000\000\087\003\011\006\138\003\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\197\003\
\000\000\000\000\000\000\000\000\000\000\135\003\000\000\000\000\
\000\000\169\000\000\000\136\003\000\000\000\000\140\000\000\000\
\011\006\002\019\119\003\087\003\081\255\000\000\000\000\208\003\
\011\006\169\000\011\006\130\003\155\010\000\000\000\000\000\000\
\000\000\150\003\011\006\081\255\000\000\000\000\208\003\152\003\
\000\000\000\000\000\000\087\003\147\003\000\000\197\011\011\006\
\000\000\000\000\000\000\167\003\172\003\166\003\000\000\175\003\
\000\000\252\003\178\003\179\003\000\000\013\000\182\003\000\000\
\197\011\185\003\167\003\000\000\167\003\190\003\000\000\192\003\
\000\000\187\003\000\000\121\012\011\006\208\003\000\000\194\003\
\195\003\000\000\189\003\000\000\000\000\000\000\000\000\208\003\
\000\000"

let yyrindex = "\000\000\
\023\000\024\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\086\000\000\000\000\000\000\000\000\000\000\000\000\000\
\205\000\086\000\000\000\000\000\086\000\086\000\000\000\022\000\
\000\000\086\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\022\000\
\213\000\076\000\000\000\000\000\000\000\000\000\086\000\000\000\
\086\000\000\000\000\000\086\000\213\000\000\000\246\015\202\003\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\028\007\
\000\000\235\000\219\003\140\007\000\000\000\000\000\000\219\003\
\252\007\000\000\000\000\000\000\000\000\000\000\041\013\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\113\003\232\005\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\149\006\000\000\000\000\
\102\005\040\014\025\028\184\028\085\008\136\008\191\012\172\006\
\042\007\153\001\000\000\059\004\000\000\000\000\000\000\000\000\
\000\000\022\000\000\000\000\000\164\000\000\000\000\000\234\003\
\000\000\063\255\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\019\004\000\000\000\000\000\000\246\015\000\000\000\000\
\000\000\242\003\091\255\000\000\000\000\097\000\243\003\000\000\
\083\255\000\000\244\003\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\219\003\213\000\000\000\219\003\219\003\
\219\003\108\008\000\000\219\003\219\003\000\000\000\000\045\255\
\213\000\000\000\000\000\245\003\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\247\019\233\000\000\000\000\000\078\020\000\000\065\021\134\021\
\085\022\036\023\100\024\012\025\124\025\236\025\092\026\204\026\
\121\002\000\000\000\000\000\000\247\003\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\110\000\000\000\188\008\213\000\000\000\000\000\102\255\
\244\000\000\000\000\000\000\000\000\000\145\004\000\000\000\000\
\000\000\000\000\000\000\000\000\147\255\000\000\000\000\000\000\
\197\000\240\003\000\000\000\000\000\000\000\000\246\003\000\000\
\000\000\000\000\244\003\244\003\000\000\219\003\000\000\000\000\
\219\003\101\001\248\003\000\000\000\000\000\000\000\000\000\000\
\000\000\219\003\000\000\000\000\000\000\219\003\213\000\000\000\
\112\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\249\003\017\001\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\240\003\000\000\000\000\000\000\000\000\000\000\250\003\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\251\003\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\239\007\185\013\015\016\158\016\058\028\093\028\
\126\028\161\028\207\028\230\028\171\012\055\011\005\015\007\010\
\154\007\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\254\003\000\000\000\000\213\000\246\015\107\011\000\000\000\000\
\202\003\104\001\000\000\000\000\255\003\000\000\053\009\127\255\
\000\000\213\000\137\255\000\000\118\000\005\001\245\000\000\000\
\000\000\243\003\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\244\003\000\000\000\000\000\000\000\000\213\000\
\219\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\049\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\203\021\
\016\022\154\022\223\022\102\023\168\023\234\023\044\024\156\024\
\212\024\068\025\180\025\036\026\148\026\004\027\000\000\000\000\
\000\000\000\000\000\000\015\007\127\007\000\000\000\000\000\000\
\000\000\054\029\000\000\000\000\000\000\000\004\000\000\092\018\
\000\000\000\000\000\000\000\000\000\000\000\000\002\004\000\000\
\000\000\000\000\019\004\000\000\000\000\156\002\024\003\000\000\
\156\000\000\000\000\000\000\000\003\004\000\000\000\000\000\000\
\106\255\000\000\000\000\202\003\002\004\000\000\000\000\000\000\
\000\000\115\001\000\000\000\000\000\000\000\000\165\020\252\020\
\000\000\000\000\000\000\254\003\000\000\000\000\000\000\000\000\
\000\000\227\000\000\000\000\000\000\000\000\000\000\000\045\255\
\000\000\120\017\000\000\254\003\000\000\000\000\000\000\000\000\
\000\000\000\000\127\255\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\175\000\082\001\000\000\
\053\014\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\253\003\000\000\000\000\156\002\000\000\
\156\002\000\000\156\002\000\000\000\000\000\000\213\000\147\255\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\120\017\000\000\000\000\000\000\000\000\000\000\000\000\141\001\
\156\002\000\000\082\001\000\000\000\000\082\001\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\082\001\000\000\
\000\000\082\001\000\000\253\003\253\003\000\000\000\000\000\000\
\000\000\148\003\000\000\000\000\082\001\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\141\005\000\000\000\000\000\000\000\000\000\000\000\000\
\082\001\000\000\027\002\000\000\000\000\000\000\000\000\000\000\
\082\001\141\005\082\001\000\000\004\004\000\000\000\000\000\000\
\000\000\000\000\082\001\000\000\000\000\000\000\052\000\014\004\
\000\000\000\000\000\000\000\000\000\000\000\000\004\004\082\001\
\000\000\000\000\000\000\111\255\000\000\000\000\000\000\000\000\
\000\000\000\000\052\002\173\000\000\000\000\000\000\000\000\000\
\015\004\000\000\111\255\000\000\048\000\000\000\000\000\000\000\
\000\000\016\004\000\000\000\000\082\001\000\000\000\000\000\000\
\000\000\000\000\062\002\000\000\000\000\000\000\000\000\000\000\
\000\000"

let yygindex = "\000\000\
\000\000\066\005\228\255\195\004\071\255\110\003\237\255\000\000\
\231\255\218\255\005\255\215\254\104\255\193\253\000\000\163\002\
\000\000\000\000\000\000\000\000\177\253\161\002\012\000\000\000\
\229\255\000\000\120\255\028\004\107\255\213\255\006\000\096\005\
\172\255\212\255\061\255\020\003\033\003\108\255\000\000\223\255\
\226\255\000\000\112\003\210\004\000\000\000\000\160\255\098\255\
\242\255\110\255\000\000\071\002\001\000\044\254\050\255\058\000\
\235\254\000\000\000\000\000\000\198\254\240\255\088\001\077\001\
\168\001\116\001\109\001\211\003\218\003\210\003\228\003\217\003\
\000\000\017\003\181\002\066\253\205\255\000\000\000\000\028\003\
\000\000\000\000\208\255\210\253\225\253\187\254\148\255\000\000\
\000\000\000\000\137\002\116\002\000\000\000\000\000\000\051\003\
\000\000\132\255\030\001\239\254\073\254\162\003\000\000\247\002\
\232\254\013\005\000\000\008\000\000\000\000\000\000\000\127\000\
\058\002\060\002\050\002\059\002\160\004\161\004\159\004\162\004\
\163\004\000\000\236\254\099\255\000\000\138\002\000\000\000\000\
\139\002\000\000\000\000\118\002"

let yytablesize = 7819
let yytable = "\086\000\
\136\000\056\000\056\000\093\000\052\001\211\001\113\001\065\001\
\153\000\057\001\202\001\091\002\049\000\049\000\115\000\061\000\
\043\001\161\000\146\000\140\000\173\000\003\000\003\000\003\000\
\218\001\075\001\076\001\160\000\062\001\078\000\146\000\217\001\
\056\000\081\002\148\000\195\000\078\000\078\000\099\001\147\002\
\078\000\078\000\194\000\049\000\007\000\078\000\148\000\116\000\
\056\000\137\000\191\002\250\000\187\000\241\001\242\001\049\000\
\086\002\171\002\223\000\049\000\065\000\149\000\058\001\119\001\
\092\002\066\000\078\000\065\001\078\000\064\001\198\000\078\000\
\115\000\072\000\076\000\166\000\081\000\240\002\010\001\011\001\
\151\000\115\000\115\000\115\000\115\000\115\000\115\000\115\000\
\253\000\255\000\062\001\063\000\136\000\136\000\033\001\215\002\
\008\001\193\000\218\002\119\001\241\002\119\001\221\001\141\000\
\137\001\065\000\012\001\067\001\226\000\037\001\066\000\044\001\
\067\001\191\002\207\001\210\002\044\001\247\000\212\001\094\000\
\006\001\003\000\174\001\065\000\142\000\141\000\037\001\067\003\
\066\000\129\001\177\000\120\001\056\000\009\001\186\000\063\001\
\061\001\067\003\056\000\190\000\058\001\137\000\137\000\049\000\
\210\000\210\000\037\001\049\000\049\000\049\000\082\001\066\001\
\079\001\090\002\248\002\087\001\088\001\089\001\152\000\014\001\
\092\001\093\001\067\001\096\001\011\003\014\001\225\001\176\001\
\062\001\177\001\115\000\121\001\179\002\128\001\251\002\043\001\
\166\000\067\001\087\002\043\001\043\001\044\001\197\002\243\001\
\044\001\166\001\234\001\248\000\104\001\106\001\141\000\166\001\
\056\000\218\001\065\000\067\000\020\003\115\001\116\001\066\000\
\001\000\002\000\095\001\049\000\037\001\218\001\119\001\121\001\
\119\001\121\001\080\001\130\001\217\001\100\002\061\001\174\001\
\174\001\119\001\068\000\233\002\038\003\105\002\115\000\070\000\
\037\001\067\001\052\001\226\000\037\001\044\001\096\000\069\000\
\097\000\000\001\001\001\002\001\003\001\004\001\005\001\021\002\
\024\002\070\000\115\000\115\000\115\000\115\000\115\000\115\000\
\115\000\115\000\115\000\115\000\115\000\115\000\115\000\115\000\
\115\000\115\000\115\000\115\000\115\000\115\000\098\000\226\000\
\210\001\226\000\176\000\208\001\058\002\059\002\141\000\056\002\
\090\002\090\002\004\002\183\001\005\002\007\000\007\000\007\000\
\083\000\065\000\134\000\206\001\079\002\006\002\066\000\235\001\
\169\001\137\002\080\001\081\001\083\000\127\001\014\002\015\002\
\170\001\245\001\127\002\097\002\067\002\099\002\077\000\065\000\
\082\000\065\000\244\001\132\000\066\000\246\001\066\000\141\000\
\070\000\183\002\121\001\174\001\121\001\160\000\252\001\139\000\
\078\002\065\000\255\001\181\001\182\001\121\001\066\000\068\002\
\226\001\195\002\236\001\224\000\159\000\068\000\166\000\065\000\
\169\000\224\000\133\000\013\002\066\000\222\000\224\000\122\002\
\001\002\043\001\069\000\222\000\196\002\043\001\155\000\048\001\
\170\001\090\002\003\000\090\002\026\001\090\002\044\001\178\000\
\043\001\043\001\043\001\044\001\065\000\067\001\158\000\114\002\
\115\002\066\000\226\000\044\001\226\000\084\000\085\000\075\000\
\044\001\016\001\017\001\067\001\067\001\226\000\162\001\067\001\
\067\001\084\000\085\000\090\002\162\001\221\001\226\000\226\000\
\224\000\185\000\170\002\184\001\185\001\186\001\068\000\070\000\
\115\000\115\000\222\000\148\002\043\001\229\001\224\000\224\000\
\174\001\174\001\224\000\069\000\224\000\224\000\224\000\193\002\
\222\000\222\000\030\001\194\002\222\000\070\000\222\000\222\000\
\222\000\067\001\210\001\030\001\044\001\085\002\067\001\044\001\
\182\002\031\001\067\001\030\001\080\000\076\002\141\002\070\000\
\044\001\044\001\065\000\162\000\044\001\018\002\019\002\066\000\
\044\001\067\001\065\001\093\002\067\001\070\000\167\001\224\000\
\204\002\169\000\045\001\068\000\141\002\031\000\211\002\045\001\
\106\002\222\000\222\000\172\000\124\002\168\001\007\002\008\002\
\069\000\082\001\044\001\065\001\044\001\108\002\008\002\044\001\
\067\001\219\001\070\000\224\002\166\000\225\002\249\002\227\002\
\158\000\044\001\174\000\226\001\196\000\043\001\067\001\067\001\
\085\001\067\001\067\001\069\001\175\000\085\001\067\001\167\001\
\198\000\198\000\198\000\007\000\204\002\167\001\184\000\204\002\
\007\000\198\002\189\000\202\002\008\002\213\002\018\001\019\001\
\204\002\222\000\073\002\204\002\188\000\033\000\247\002\049\001\
\045\001\029\003\001\003\045\001\027\001\002\003\204\002\049\001\
\222\000\158\000\037\000\069\001\038\000\131\002\222\000\067\001\
\044\001\184\002\185\002\040\003\210\001\115\000\107\001\108\001\
\109\001\110\001\111\001\112\001\069\001\167\002\044\001\251\000\
\070\000\044\001\204\002\047\001\044\001\056\003\143\002\044\001\
\085\001\252\002\204\002\047\001\204\002\119\001\007\001\067\001\
\045\001\069\001\076\002\054\001\204\002\069\001\069\001\067\001\
\222\000\220\002\028\001\043\001\221\002\210\001\029\001\069\001\
\044\001\204\002\066\001\024\001\025\001\069\001\069\001\069\001\
\045\001\169\002\190\002\144\000\034\001\210\001\038\001\210\001\
\144\000\144\000\144\000\189\002\193\000\010\003\085\001\069\001\
\153\001\154\001\000\003\130\001\046\001\003\003\204\002\166\000\
\096\002\013\001\014\001\015\001\056\002\038\001\219\002\039\001\
\012\003\216\002\040\001\041\001\130\002\010\003\031\000\053\001\
\056\000\226\000\226\000\150\001\151\001\152\001\056\002\020\001\
\021\001\022\001\023\001\049\000\067\001\010\003\039\001\069\001\
\093\002\040\001\041\001\047\001\017\003\031\000\226\001\055\001\
\056\002\155\001\156\001\246\002\025\003\058\001\027\003\228\002\
\229\002\230\002\095\001\161\001\162\001\213\001\033\003\059\001\
\214\001\061\001\038\001\004\003\005\003\073\002\198\000\198\000\
\198\000\186\002\069\001\041\003\067\001\069\001\008\001\008\001\
\069\001\069\001\069\001\226\001\060\001\073\002\033\000\141\000\
\215\001\210\000\210\000\039\001\067\001\067\001\040\001\041\001\
\006\003\007\003\031\000\037\000\067\001\038\000\035\001\036\001\
\066\003\157\001\158\001\159\001\160\001\033\000\069\001\067\001\
\021\003\070\001\067\001\018\003\071\001\067\001\067\001\067\001\
\074\001\030\003\037\000\147\001\038\000\040\002\041\002\034\003\
\147\001\147\001\147\001\147\001\077\001\036\002\037\002\038\002\
\039\002\039\002\039\002\039\002\039\002\039\002\039\002\039\002\
\039\002\039\002\039\002\039\002\039\002\039\002\039\002\139\001\
\140\001\141\001\142\001\143\001\144\001\145\001\146\001\147\001\
\148\001\149\001\033\000\078\001\215\001\048\002\049\002\147\001\
\044\002\045\002\046\002\047\002\054\003\065\003\086\001\037\000\
\193\000\038\000\177\000\177\000\090\001\177\000\177\000\177\000\
\177\000\177\000\177\000\177\000\177\000\177\000\177\000\177\000\
\177\000\177\000\177\000\177\000\177\000\177\000\177\000\091\001\
\177\000\177\000\177\000\177\000\177\000\177\000\177\000\177\000\
\177\000\177\000\177\000\177\000\177\000\177\000\177\000\177\000\
\177\000\177\000\042\002\043\002\079\000\191\001\192\001\193\001\
\194\001\187\001\188\001\094\001\090\000\189\001\190\001\091\000\
\092\000\101\001\195\001\196\001\095\000\177\000\177\000\177\000\
\102\001\126\001\177\000\177\000\122\001\123\001\177\000\177\000\
\124\001\125\001\117\002\177\000\177\000\163\001\177\000\177\000\
\177\000\156\000\131\001\157\000\177\000\164\001\165\001\171\001\
\177\000\177\000\177\000\177\000\177\000\177\000\177\000\177\000\
\177\000\177\000\177\000\177\000\166\001\092\000\172\001\177\000\
\177\000\177\000\177\000\177\000\177\000\174\001\177\000\175\001\
\178\001\179\001\177\000\177\000\177\000\177\000\177\000\177\000\
\177\000\203\001\180\001\205\001\177\000\177\000\092\000\177\000\
\177\000\092\000\092\000\163\000\163\000\092\000\204\001\163\000\
\163\000\163\000\163\000\163\000\163\000\163\000\163\000\163\000\
\163\000\163\000\163\000\163\000\163\000\163\000\163\000\163\000\
\219\001\163\000\163\000\163\000\163\000\163\000\163\000\163\000\
\163\000\163\000\163\000\163\000\163\000\163\000\163\000\163\000\
\163\000\163\000\163\000\092\000\222\001\092\000\224\001\238\001\
\092\000\092\000\092\000\092\000\092\000\228\001\239\001\240\001\
\247\001\016\002\250\001\251\001\248\001\039\002\163\000\163\000\
\163\000\249\001\253\001\163\000\163\000\092\000\254\001\163\000\
\163\000\000\002\002\002\009\002\163\000\163\000\017\002\163\000\
\163\000\163\000\092\000\003\002\092\000\163\000\010\002\011\002\
\012\002\163\000\163\000\163\000\163\000\163\000\163\000\163\000\
\163\000\163\000\163\000\163\000\163\000\060\002\061\002\062\002\
\163\000\163\000\163\000\163\000\163\000\163\000\063\002\163\000\
\064\002\065\002\080\002\163\000\163\000\163\000\163\000\163\000\
\163\000\163\000\083\002\101\002\084\002\163\000\163\000\163\000\
\163\000\163\000\095\002\163\000\163\000\163\000\163\000\163\000\
\163\000\163\000\163\000\163\000\163\000\163\000\163\000\163\000\
\163\000\163\000\163\000\163\000\103\002\163\000\163\000\163\000\
\163\000\163\000\163\000\163\000\163\000\163\000\163\000\163\000\
\163\000\163\000\163\000\163\000\163\000\163\000\163\000\025\002\
\026\002\027\002\028\002\029\002\030\002\031\002\032\002\033\002\
\034\002\035\002\104\002\109\002\110\002\118\002\119\002\111\002\
\112\002\113\002\163\000\163\000\163\000\121\002\116\002\163\000\
\163\000\123\002\120\002\163\000\163\000\125\002\008\002\170\001\
\163\000\163\000\126\002\163\000\128\002\163\000\129\002\132\002\
\133\002\163\000\135\002\136\002\138\002\163\000\163\000\163\000\
\163\000\163\000\163\000\163\000\163\000\163\000\163\000\163\000\
\163\000\139\002\144\002\175\002\163\000\163\000\163\000\163\000\
\163\000\163\000\149\002\163\000\177\002\176\002\199\002\163\000\
\163\000\163\000\163\000\163\000\163\000\163\000\181\002\200\002\
\201\002\163\000\163\000\076\001\076\001\163\000\076\001\076\001\
\208\002\076\001\076\001\076\001\076\001\076\001\076\001\076\001\
\076\001\209\002\214\002\090\001\090\001\090\001\090\001\090\001\
\090\001\090\001\090\001\090\001\090\001\090\001\090\001\090\001\
\217\002\090\001\090\001\090\001\223\002\090\001\090\001\090\001\
\090\001\076\001\076\001\090\001\226\002\234\002\235\002\090\001\
\090\001\090\001\090\001\090\001\236\002\090\001\237\002\238\002\
\239\002\250\002\014\003\243\002\244\002\253\002\076\001\076\001\
\076\001\008\003\254\002\076\001\076\001\013\003\015\003\076\001\
\076\001\016\003\019\003\022\003\076\001\076\001\028\003\076\001\
\162\000\076\001\132\001\133\001\039\003\076\001\032\003\090\001\
\036\003\076\001\076\001\076\001\076\001\076\001\076\001\076\001\
\076\001\076\001\076\001\076\001\076\001\042\003\047\003\048\003\
\134\001\135\001\076\001\136\001\076\001\076\001\137\001\076\001\
\049\003\050\003\051\003\076\001\076\001\053\003\076\001\055\003\
\057\003\060\003\061\003\062\003\069\003\070\003\076\001\072\003\
\076\001\162\000\167\000\167\000\023\001\167\000\167\000\167\000\
\167\000\167\000\167\000\167\000\167\000\167\000\167\000\167\000\
\167\000\167\000\167\000\167\000\167\000\167\000\167\000\000\001\
\167\000\167\000\167\000\167\000\167\000\167\000\167\000\167\000\
\167\000\167\000\167\000\167\000\167\000\167\000\167\000\167\000\
\167\000\167\000\007\000\208\000\035\001\025\001\055\001\153\001\
\027\000\150\001\028\000\058\000\140\000\007\000\032\001\082\002\
\159\001\006\001\127\000\142\000\125\000\167\000\167\000\167\000\
\169\000\147\000\167\000\167\000\040\001\142\000\167\000\167\000\
\164\001\142\000\176\001\167\000\167\000\242\002\167\000\167\000\
\167\000\245\002\237\001\062\000\167\000\049\001\145\002\107\002\
\167\000\167\000\167\000\167\000\167\000\167\000\167\000\167\000\
\167\000\167\000\167\000\167\000\146\002\050\002\052\002\167\000\
\167\000\167\000\167\000\167\000\167\000\051\002\167\000\054\002\
\180\002\167\000\167\000\167\000\167\000\167\000\167\000\167\000\
\167\000\053\002\035\003\102\002\167\000\167\000\188\002\167\000\
\156\000\156\000\026\003\156\000\156\000\156\000\156\000\156\000\
\156\000\156\000\156\000\156\000\156\000\156\000\156\000\156\000\
\156\000\156\000\156\000\156\000\156\000\231\002\156\000\156\000\
\156\000\156\000\156\000\156\000\156\000\156\000\156\000\156\000\
\156\000\156\000\156\000\156\000\156\000\156\000\156\000\156\000\
\073\001\197\001\199\001\198\001\058\003\073\003\200\001\059\003\
\201\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\156\000\156\000\156\000\000\000\000\000\
\156\000\156\000\000\000\000\000\156\000\156\000\000\000\000\000\
\000\000\156\000\156\000\000\000\156\000\156\000\156\000\000\000\
\000\000\000\000\156\000\000\000\000\000\000\000\156\000\156\000\
\156\000\156\000\156\000\156\000\156\000\156\000\156\000\156\000\
\156\000\156\000\000\000\000\000\000\000\156\000\156\000\156\000\
\156\000\156\000\156\000\000\000\156\000\000\000\000\000\000\000\
\156\000\156\000\156\000\156\000\156\000\156\000\156\000\000\000\
\000\000\000\000\156\000\156\000\000\000\156\000\150\002\203\002\
\000\000\086\002\152\002\006\000\066\002\200\000\201\000\202\000\
\203\000\153\002\083\000\204\000\009\000\010\000\011\000\012\000\
\013\000\014\000\015\000\000\000\016\000\017\000\018\000\019\000\
\020\000\021\000\022\000\023\000\024\000\060\000\026\000\027\000\
\028\000\029\000\030\000\031\000\205\000\206\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\038\001\000\000\000\000\000\000\000\000\000\000\
\000\000\207\000\208\000\209\000\000\000\000\000\210\000\211\000\
\000\000\000\000\212\000\213\000\000\000\000\000\000\000\214\000\
\215\000\000\000\216\000\039\001\152\000\000\000\040\001\041\001\
\154\002\000\000\031\000\000\000\155\002\156\002\157\002\158\002\
\159\002\160\002\161\002\000\000\000\000\000\000\162\002\163\002\
\000\000\000\000\000\000\033\000\034\000\164\002\036\000\084\000\
\085\000\000\000\217\000\000\000\000\000\000\000\218\000\219\000\
\037\000\165\002\038\000\000\000\000\000\000\000\000\000\000\000\
\043\000\220\000\000\000\087\002\076\001\076\001\000\000\076\001\
\076\001\000\000\076\001\076\001\076\001\076\001\076\001\076\001\
\076\001\076\001\123\001\123\001\123\001\123\001\123\001\123\001\
\123\001\123\001\033\000\000\000\000\000\000\000\123\001\123\001\
\123\001\000\000\123\001\123\001\123\001\123\001\000\000\037\000\
\123\001\038\000\076\001\076\001\000\000\123\001\123\001\123\001\
\123\001\000\000\123\001\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\076\001\
\076\001\076\001\000\000\000\000\076\001\076\001\000\000\000\000\
\076\001\076\001\000\000\000\000\000\000\076\001\076\001\000\000\
\076\001\000\000\076\001\000\000\123\001\000\000\076\001\000\000\
\000\000\000\000\076\001\076\001\076\001\076\001\076\001\076\001\
\076\001\076\001\076\001\076\001\076\001\076\001\000\000\000\000\
\000\000\000\000\000\000\076\001\000\000\076\001\076\001\000\000\
\076\001\000\000\000\000\000\000\076\001\076\001\000\000\076\001\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\076\001\
\000\000\076\001\150\002\203\002\000\000\086\002\152\002\000\000\
\066\002\200\000\201\000\202\000\203\000\066\000\083\000\204\000\
\000\000\000\000\094\001\094\001\094\001\094\001\094\001\094\001\
\094\001\094\001\094\001\094\001\094\001\094\001\094\001\000\000\
\094\001\094\001\094\001\000\000\094\001\094\001\094\001\094\001\
\205\000\206\000\094\001\000\000\000\000\000\000\094\001\094\001\
\000\000\094\001\094\001\000\000\094\001\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\207\000\208\000\209\000\
\000\000\000\000\210\000\211\000\000\000\000\000\212\000\213\000\
\000\000\000\000\000\000\214\000\215\000\000\000\216\000\000\000\
\152\000\000\000\000\000\000\000\154\002\000\000\094\001\000\000\
\155\002\156\002\157\002\158\002\159\002\160\002\161\002\000\000\
\000\000\000\000\162\002\163\002\000\000\000\000\000\000\000\000\
\000\000\164\002\000\000\084\000\085\000\000\000\217\000\000\000\
\000\000\000\000\218\000\219\000\004\000\165\002\000\000\000\000\
\006\000\059\000\000\000\000\000\000\000\220\000\008\000\087\002\
\000\000\009\000\010\000\011\000\012\000\013\000\014\000\015\000\
\000\000\016\000\017\000\018\000\019\000\020\000\021\000\022\000\
\023\000\024\000\060\000\026\000\027\000\028\000\029\000\030\000\
\031\000\004\000\005\000\000\000\000\000\006\000\007\000\000\000\
\000\000\000\000\000\000\008\000\000\000\000\000\009\000\010\000\
\011\000\012\000\013\000\014\000\015\000\000\000\016\000\017\000\
\018\000\019\000\020\000\021\000\022\000\023\000\024\000\025\000\
\026\000\027\000\028\000\029\000\030\000\031\000\000\000\000\000\
\000\000\107\001\107\001\107\001\107\001\107\001\107\001\107\001\
\107\001\107\001\107\001\107\001\000\000\107\001\107\001\107\001\
\000\000\107\001\107\001\107\001\107\001\000\000\000\000\107\001\
\033\000\034\000\000\000\036\000\107\001\107\001\107\001\107\001\
\000\000\107\001\000\000\000\000\000\000\037\000\000\000\038\000\
\143\001\143\001\032\000\000\000\000\000\043\000\143\001\000\000\
\000\000\135\000\000\000\143\001\143\001\143\001\143\001\000\000\
\143\001\000\000\000\000\000\000\000\000\033\000\034\000\035\000\
\036\000\000\000\000\000\107\001\000\000\000\000\000\000\000\000\
\000\000\000\000\037\000\000\000\038\000\039\000\040\000\000\000\
\041\000\042\000\043\000\248\000\000\000\044\000\000\000\000\000\
\248\000\248\000\143\001\000\000\000\000\000\000\248\000\000\000\
\000\000\248\000\248\000\248\000\248\000\248\000\248\000\248\000\
\000\000\248\000\248\000\248\000\248\000\248\000\248\000\248\000\
\248\000\248\000\248\000\248\000\248\000\248\000\248\000\248\000\
\248\000\000\000\000\000\109\001\109\001\109\001\109\001\109\001\
\109\001\109\001\109\001\109\001\109\001\109\001\000\000\109\001\
\109\001\109\001\000\000\109\001\109\001\109\001\109\001\000\000\
\248\000\109\001\000\000\000\000\000\000\000\000\109\001\109\001\
\109\001\109\001\000\000\109\001\000\000\000\000\248\000\248\000\
\000\000\000\000\248\000\000\000\248\000\248\000\248\000\145\001\
\000\000\000\000\000\000\000\000\145\001\000\000\000\000\000\000\
\000\000\145\001\145\001\145\001\145\001\000\000\145\001\000\000\
\248\000\248\000\000\000\248\000\000\000\109\001\000\000\000\000\
\000\000\000\000\000\000\237\000\000\000\248\000\000\000\248\000\
\237\000\237\000\000\000\000\000\000\000\248\000\237\000\248\000\
\000\000\237\000\237\000\237\000\237\000\237\000\237\000\237\000\
\145\001\237\000\237\000\237\000\237\000\237\000\237\000\237\000\
\237\000\237\000\237\000\237\000\237\000\237\000\237\000\237\000\
\237\000\000\000\000\000\111\001\111\001\111\001\111\001\111\001\
\111\001\111\001\111\001\111\001\111\001\111\001\000\000\111\001\
\111\001\111\001\000\000\111\001\111\001\111\001\111\001\000\000\
\237\000\111\001\000\000\000\000\000\000\000\000\111\001\111\001\
\111\001\111\001\000\000\111\001\000\000\000\000\237\000\237\000\
\000\000\000\000\237\000\000\000\237\000\237\000\237\000\146\001\
\000\000\000\000\000\000\000\000\146\001\000\000\000\000\000\000\
\000\000\146\001\146\001\146\001\146\001\000\000\146\001\000\000\
\237\000\237\000\000\000\237\000\000\000\111\001\000\000\000\000\
\000\000\000\000\000\000\243\000\000\000\237\000\000\000\237\000\
\243\000\243\000\000\000\000\000\000\000\237\000\243\000\237\000\
\000\000\243\000\243\000\243\000\243\000\243\000\243\000\243\000\
\146\001\243\000\243\000\243\000\243\000\243\000\243\000\243\000\
\243\000\243\000\243\000\243\000\243\000\243\000\243\000\243\000\
\243\000\000\000\000\000\124\001\124\001\124\001\124\001\124\001\
\124\001\124\001\124\001\000\000\000\000\000\000\000\000\124\001\
\124\001\124\001\000\000\124\001\124\001\124\001\124\001\000\000\
\243\000\124\001\000\000\000\000\000\000\000\000\124\001\124\001\
\124\001\124\001\000\000\124\001\000\000\000\000\243\000\243\000\
\000\000\000\000\243\000\000\000\243\000\243\000\243\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\243\000\243\000\000\000\243\000\000\000\124\001\000\000\000\000\
\000\000\000\000\000\000\238\000\000\000\243\000\000\000\243\000\
\238\000\238\000\000\000\000\000\000\000\243\000\238\000\243\000\
\000\000\238\000\238\000\238\000\238\000\238\000\238\000\238\000\
\000\000\238\000\238\000\238\000\238\000\238\000\238\000\238\000\
\238\000\238\000\238\000\238\000\238\000\238\000\238\000\238\000\
\238\000\000\000\000\000\000\000\038\001\137\001\137\001\137\001\
\000\000\137\001\137\001\000\000\000\000\000\000\000\000\137\001\
\000\000\000\000\000\000\000\000\137\001\137\001\137\001\137\001\
\238\000\137\001\000\000\000\000\000\000\039\001\000\000\000\000\
\040\001\041\001\000\000\000\000\031\000\000\000\238\000\238\000\
\000\000\000\000\238\000\067\001\238\000\238\000\238\000\000\000\
\000\000\067\001\067\001\067\001\067\001\067\001\067\001\067\001\
\067\001\139\001\139\001\137\001\139\001\139\001\000\000\000\000\
\238\000\238\000\139\001\238\000\000\000\000\000\000\000\139\001\
\139\001\139\001\139\001\098\002\139\001\238\000\000\000\238\000\
\000\000\067\001\067\001\067\001\000\000\238\000\000\000\238\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\033\000\000\000\067\001\067\001\
\067\001\000\000\000\000\067\001\067\001\000\000\139\001\067\001\
\067\001\037\000\000\000\038\000\067\001\067\001\067\001\067\001\
\000\000\067\001\067\001\067\001\067\001\067\001\067\001\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\067\001\067\001\000\000\067\001\
\000\000\000\000\000\000\067\001\067\001\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\163\000\163\000\067\001\067\001\
\163\000\163\000\163\000\163\000\163\000\163\000\163\000\163\000\
\163\000\163\000\163\000\163\000\163\000\163\000\163\000\163\000\
\163\000\000\000\163\000\163\000\163\000\163\000\163\000\163\000\
\163\000\163\000\163\000\163\000\163\000\163\000\163\000\163\000\
\163\000\163\000\163\000\163\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\163\000\
\163\000\163\000\000\000\000\000\163\000\163\000\000\000\000\000\
\163\000\163\000\000\000\000\000\000\000\163\000\163\000\000\000\
\163\000\163\000\163\000\000\000\000\000\000\000\163\000\000\000\
\000\000\000\000\163\000\163\000\163\000\163\000\163\000\163\000\
\163\000\163\000\163\000\163\000\163\000\163\000\000\000\000\000\
\000\000\163\000\163\000\163\000\163\000\163\000\163\000\000\000\
\163\000\000\000\000\000\000\000\163\000\163\000\163\000\163\000\
\163\000\163\000\163\000\000\000\150\002\151\002\163\000\163\000\
\152\002\006\000\066\002\200\000\201\000\202\000\203\000\153\002\
\083\000\204\000\009\000\010\000\011\000\012\000\013\000\014\000\
\015\000\000\000\016\000\017\000\018\000\019\000\020\000\021\000\
\022\000\023\000\024\000\060\000\026\000\027\000\028\000\029\000\
\030\000\031\000\205\000\206\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\207\000\
\208\000\209\000\000\000\000\000\210\000\211\000\000\000\000\000\
\212\000\213\000\000\000\000\000\000\000\214\000\215\000\000\000\
\216\000\000\000\152\000\000\000\000\000\000\000\154\002\000\000\
\000\000\000\000\155\002\156\002\157\002\158\002\159\002\160\002\
\161\002\000\000\000\000\000\000\162\002\163\002\000\000\000\000\
\000\000\033\000\034\000\164\002\036\000\084\000\085\000\000\000\
\217\000\000\000\000\000\000\000\218\000\219\000\037\000\165\002\
\038\000\039\000\040\000\117\001\000\000\000\000\043\000\220\000\
\006\000\199\000\200\000\201\000\202\000\203\000\008\000\083\000\
\204\000\009\000\010\000\011\000\012\000\013\000\014\000\015\000\
\000\000\016\000\017\000\018\000\019\000\020\000\021\000\022\000\
\023\000\024\000\060\000\026\000\027\000\028\000\029\000\030\000\
\031\000\205\000\206\000\144\001\144\001\000\000\000\000\000\000\
\000\000\144\001\000\000\000\000\000\000\000\000\144\001\144\001\
\144\001\144\001\000\000\144\001\000\000\000\000\207\000\208\000\
\209\000\000\000\000\000\210\000\211\000\000\000\000\000\212\000\
\213\000\000\000\000\000\000\000\214\000\215\000\000\000\216\000\
\000\000\152\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\144\001\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\033\000\034\000\000\000\036\000\084\000\085\000\000\000\217\000\
\000\000\000\000\000\000\218\000\219\000\037\000\000\000\038\000\
\000\000\000\000\020\002\191\000\000\000\043\000\220\000\006\000\
\199\000\200\000\201\000\202\000\203\000\008\000\083\000\204\000\
\009\000\010\000\011\000\012\000\013\000\014\000\015\000\000\000\
\016\000\017\000\018\000\019\000\020\000\021\000\022\000\023\000\
\024\000\060\000\026\000\027\000\028\000\029\000\030\000\031\000\
\205\000\206\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\207\000\208\000\209\000\
\000\000\000\000\210\000\211\000\000\000\000\000\212\000\213\000\
\000\000\150\002\203\002\214\000\215\000\152\002\216\000\066\002\
\200\000\201\000\202\000\203\000\066\000\083\000\204\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\033\000\
\034\000\000\000\036\000\084\000\085\000\000\000\217\000\205\000\
\206\000\000\000\218\000\219\000\037\000\000\000\038\000\000\000\
\000\000\000\000\000\000\000\000\043\000\220\000\000\000\000\000\
\000\000\000\000\000\000\000\000\207\000\208\000\209\000\000\000\
\000\000\210\000\211\000\000\000\000\000\212\000\213\000\000\000\
\000\000\000\000\214\000\215\000\000\000\216\000\000\000\152\000\
\000\000\000\000\000\000\154\002\000\000\000\000\000\000\155\002\
\156\002\157\002\158\002\159\002\160\002\161\002\000\000\000\000\
\000\000\162\002\163\002\000\000\000\000\000\000\000\000\000\000\
\164\002\000\000\084\000\085\000\000\000\217\000\000\000\000\000\
\000\000\218\000\219\000\000\000\165\002\000\000\000\000\020\002\
\000\000\000\000\000\000\000\000\220\000\199\000\200\000\201\000\
\202\000\203\000\000\000\083\000\204\000\000\000\000\000\000\000\
\000\000\000\000\067\001\000\000\000\000\000\000\000\000\000\000\
\067\001\067\001\067\001\067\001\067\001\000\000\067\001\067\001\
\140\001\140\001\000\000\140\001\140\001\205\000\206\000\000\000\
\000\000\140\001\000\000\000\000\000\000\000\000\140\001\140\001\
\140\001\140\001\000\000\140\001\000\000\000\000\000\000\000\000\
\067\001\067\001\207\000\208\000\209\000\000\000\000\000\210\000\
\211\000\000\000\000\000\212\000\213\000\000\000\000\000\000\000\
\214\000\215\000\000\000\216\000\000\000\067\001\067\001\067\001\
\000\000\212\002\067\001\067\001\000\000\140\001\067\001\067\001\
\000\000\000\000\000\000\067\001\067\001\000\000\067\001\000\000\
\000\000\000\000\067\001\000\000\000\000\000\000\000\000\000\000\
\084\000\085\000\000\000\217\000\020\002\000\000\000\000\218\000\
\219\000\000\000\199\000\200\000\201\000\202\000\203\000\000\000\
\083\000\204\000\220\000\067\001\067\001\000\000\067\001\023\002\
\000\000\000\000\067\001\067\001\000\000\199\000\200\000\201\000\
\202\000\203\000\000\000\083\000\204\000\067\001\000\000\000\000\
\000\000\000\000\205\000\206\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\205\000\206\000\207\000\
\208\000\209\000\000\000\000\000\210\000\211\000\000\000\000\000\
\212\000\213\000\000\000\000\000\000\000\214\000\215\000\000\000\
\216\000\000\000\207\000\208\000\209\000\000\000\000\000\210\000\
\211\000\000\000\000\000\212\000\213\000\000\000\140\002\000\000\
\214\000\215\000\000\000\216\000\199\000\200\000\201\000\202\000\
\203\000\000\000\083\000\204\000\000\000\084\000\085\000\000\000\
\217\000\255\002\000\000\000\000\218\000\219\000\000\000\199\000\
\200\000\201\000\202\000\203\000\000\000\083\000\204\000\220\000\
\084\000\085\000\000\000\217\000\205\000\206\000\000\000\218\000\
\219\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\220\000\000\000\000\000\000\000\000\000\205\000\
\206\000\207\000\208\000\209\000\000\000\000\000\210\000\211\000\
\000\000\000\000\212\000\213\000\000\000\000\000\000\000\214\000\
\215\000\000\000\216\000\000\000\207\000\208\000\209\000\000\000\
\000\000\210\000\211\000\000\000\000\000\212\000\213\000\000\000\
\064\003\000\000\214\000\215\000\000\000\216\000\199\000\200\000\
\201\000\202\000\203\000\000\000\083\000\204\000\000\000\084\000\
\085\000\000\000\217\000\000\000\000\000\000\000\218\000\219\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\220\000\084\000\085\000\000\000\217\000\205\000\206\000\
\000\000\218\000\219\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\220\000\000\000\000\000\000\000\
\000\000\000\000\000\000\207\000\208\000\209\000\000\000\000\000\
\210\000\211\000\179\000\000\000\212\000\213\000\000\000\006\000\
\000\000\214\000\215\000\000\000\216\000\008\000\000\000\000\000\
\009\000\010\000\011\000\012\000\013\000\014\000\015\000\000\000\
\016\000\017\000\018\000\019\000\020\000\021\000\022\000\023\000\
\024\000\060\000\026\000\027\000\028\000\029\000\030\000\031\000\
\000\000\084\000\085\000\000\000\217\000\000\000\000\000\000\000\
\218\000\219\000\000\000\138\001\138\001\138\001\000\000\138\001\
\138\001\000\000\000\000\220\000\000\000\138\001\000\000\000\000\
\000\000\000\000\138\001\138\001\138\001\138\001\000\000\138\001\
\141\001\000\000\000\000\141\001\141\001\000\000\000\000\000\000\
\000\000\141\001\000\000\000\000\180\000\000\000\141\001\141\001\
\141\001\141\001\000\000\141\001\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\033\000\
\034\000\138\001\036\000\000\000\000\000\000\000\000\000\000\000\
\000\000\113\000\000\000\000\000\037\000\113\000\038\000\039\000\
\040\000\000\000\000\000\113\000\043\000\141\001\113\000\113\000\
\113\000\113\000\113\000\113\000\113\000\000\000\113\000\113\000\
\113\000\113\000\113\000\113\000\113\000\113\000\113\000\113\000\
\113\000\113\000\113\000\113\000\113\000\113\000\000\000\000\000\
\113\000\113\000\113\000\113\000\113\000\113\000\113\000\113\000\
\113\000\113\000\113\000\113\000\113\000\113\000\113\000\113\000\
\113\000\113\000\113\000\113\000\113\000\113\000\113\000\113\000\
\000\000\113\000\113\000\113\000\000\000\113\000\113\000\113\000\
\113\000\113\000\113\000\113\000\113\000\113\000\113\000\113\000\
\113\000\113\000\113\000\113\000\113\000\113\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\113\000\113\000\000\000\
\113\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\113\000\000\000\113\000\000\000\000\000\113\000\
\004\000\005\000\113\000\000\000\006\000\007\000\000\000\000\000\
\000\000\000\000\008\000\000\000\000\000\009\000\010\000\011\000\
\012\000\013\000\014\000\015\000\000\000\016\000\017\000\018\000\
\019\000\020\000\021\000\022\000\023\000\024\000\025\000\026\000\
\027\000\028\000\029\000\030\000\031\000\191\000\000\000\000\000\
\000\000\006\000\000\000\000\000\000\000\000\000\000\000\008\000\
\000\000\000\000\009\000\010\000\011\000\012\000\013\000\014\000\
\015\000\000\000\016\000\017\000\018\000\019\000\020\000\021\000\
\022\000\023\000\024\000\060\000\026\000\027\000\028\000\029\000\
\030\000\031\000\000\000\000\000\000\000\125\001\125\001\125\001\
\125\001\125\001\125\001\125\001\125\001\000\000\000\000\000\000\
\000\000\125\001\125\001\125\001\000\000\125\001\125\001\125\001\
\125\001\000\000\000\000\125\001\033\000\034\000\035\000\036\000\
\125\001\125\001\125\001\125\001\000\000\125\001\000\000\000\000\
\000\000\037\000\192\000\038\000\039\000\040\000\000\000\041\000\
\042\000\043\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\033\000\034\000\000\000\036\000\000\000\000\000\125\001\
\000\000\000\000\000\000\000\000\000\000\000\000\037\000\000\000\
\038\000\253\000\253\000\000\000\000\000\000\000\043\000\253\000\
\000\000\000\000\253\000\253\000\253\000\253\000\253\000\253\000\
\253\000\000\000\253\000\253\000\253\000\253\000\253\000\253\000\
\253\000\253\000\253\000\253\000\253\000\253\000\253\000\253\000\
\253\000\253\000\000\000\000\000\126\001\126\001\126\001\126\001\
\126\001\126\001\000\000\000\000\000\000\000\000\000\000\000\000\
\126\001\126\001\126\001\000\000\126\001\126\001\126\001\126\001\
\000\000\253\000\126\001\000\000\000\000\000\000\000\000\126\001\
\126\001\126\001\126\001\000\000\126\001\000\000\000\000\000\000\
\253\000\000\000\000\000\000\000\000\000\024\000\253\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\253\000\253\000\000\000\253\000\000\000\126\001\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\253\000\000\000\
\253\000\000\000\000\000\000\000\000\000\000\000\253\000\000\000\
\253\000\006\000\199\000\200\000\201\000\202\000\203\000\008\000\
\083\000\204\000\009\000\010\000\011\000\012\000\013\000\014\000\
\015\000\000\000\016\000\017\000\018\000\019\000\020\000\021\000\
\022\000\023\000\024\000\060\000\026\000\027\000\028\000\029\000\
\030\000\031\000\205\000\206\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\207\000\
\208\000\209\000\000\000\000\000\210\000\211\000\000\000\000\000\
\212\000\213\000\000\000\000\000\000\000\214\000\215\000\000\000\
\216\000\000\000\066\002\200\000\201\000\202\000\203\000\066\000\
\083\000\204\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\033\000\034\000\000\000\036\000\084\000\085\000\000\000\
\217\000\000\000\205\000\206\000\218\000\219\000\037\000\000\000\
\038\000\000\000\000\000\000\000\000\000\000\000\043\000\220\000\
\067\002\000\000\000\000\000\000\000\000\000\000\000\000\207\000\
\208\000\209\000\000\000\000\000\210\000\211\000\000\000\000\000\
\212\000\213\000\000\000\000\000\000\000\214\000\215\000\000\000\
\216\000\000\000\209\001\068\002\000\000\000\000\142\001\000\000\
\000\000\142\001\142\001\000\000\000\000\000\000\000\000\142\001\
\000\000\000\000\000\000\000\000\142\001\142\001\142\001\142\001\
\000\000\142\001\000\000\000\000\000\000\084\000\085\000\000\000\
\217\000\000\000\000\000\000\000\218\000\219\000\000\000\000\000\
\000\000\000\000\000\000\006\000\000\000\000\000\000\000\220\000\
\070\000\008\000\083\000\000\000\009\000\010\000\011\000\012\000\
\013\000\014\000\015\000\142\001\016\000\017\000\018\000\019\000\
\020\000\021\000\022\000\023\000\024\000\060\000\026\000\027\000\
\028\000\029\000\030\000\031\000\006\000\000\000\000\000\000\000\
\000\000\000\000\008\000\000\000\000\000\009\000\010\000\011\000\
\012\000\013\000\014\000\015\000\000\000\016\000\017\000\018\000\
\019\000\020\000\021\000\022\000\023\000\024\000\060\000\026\000\
\027\000\028\000\029\000\030\000\031\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\033\000\034\000\000\000\036\000\084\000\
\085\000\000\000\000\000\165\000\000\000\000\000\000\000\000\000\
\037\000\000\000\038\000\233\001\000\000\000\000\000\000\000\000\
\043\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\033\000\034\000\000\000\036\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\037\000\022\001\038\000\000\000\000\000\000\000\000\000\
\022\001\043\000\000\000\022\001\022\001\022\001\022\001\022\001\
\022\001\022\001\000\000\022\001\022\001\022\001\022\001\022\001\
\022\001\022\001\022\001\022\001\022\001\022\001\022\001\022\001\
\022\001\022\001\022\001\006\000\059\000\000\000\000\000\000\000\
\000\000\008\000\000\000\000\000\009\000\010\000\011\000\012\000\
\013\000\014\000\015\000\000\000\016\000\017\000\018\000\019\000\
\020\000\021\000\022\000\023\000\024\000\060\000\026\000\027\000\
\028\000\029\000\030\000\031\000\000\000\000\000\000\000\000\000\
\022\001\022\001\000\000\127\001\127\001\127\001\127\001\127\001\
\127\001\000\000\000\000\000\000\000\000\000\000\000\000\127\001\
\127\001\127\001\000\000\127\001\127\001\127\001\127\001\000\000\
\000\000\127\001\022\001\022\001\000\000\022\001\127\001\127\001\
\127\001\127\001\000\000\127\001\000\000\000\000\000\000\022\001\
\000\000\022\001\000\000\000\000\000\000\000\000\000\000\022\001\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\033\000\034\000\000\000\036\000\000\000\
\000\000\000\000\000\000\000\000\000\000\127\001\000\000\000\000\
\037\000\006\000\038\000\000\000\000\000\000\000\000\000\008\000\
\043\000\000\000\009\000\010\000\011\000\012\000\013\000\014\000\
\015\000\000\000\016\000\017\000\018\000\019\000\020\000\021\000\
\022\000\023\000\024\000\060\000\026\000\027\000\028\000\029\000\
\030\000\031\000\006\000\000\000\000\000\000\000\000\000\000\000\
\008\000\000\000\000\000\009\000\010\000\011\000\012\000\013\000\
\014\000\015\000\000\000\016\000\017\000\018\000\019\000\020\000\
\021\000\022\000\023\000\024\000\060\000\026\000\027\000\028\000\
\029\000\030\000\031\000\000\000\000\000\000\000\000\000\000\000\
\165\000\000\000\128\001\128\001\128\001\128\001\128\001\128\001\
\000\000\000\000\000\000\000\000\000\000\000\000\128\001\128\001\
\128\001\000\000\128\001\128\001\128\001\128\001\000\000\000\000\
\128\001\033\000\034\000\000\000\036\000\128\001\128\001\128\001\
\128\001\000\000\128\001\000\000\000\000\000\000\037\000\000\000\
\038\000\232\002\000\000\000\000\000\000\000\000\043\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\033\000\034\000\000\000\036\000\000\000\000\000\
\000\000\000\000\000\000\000\000\128\001\000\000\000\000\037\000\
\006\000\038\000\000\000\000\000\000\000\000\000\008\000\043\000\
\000\000\009\000\010\000\011\000\012\000\013\000\014\000\015\000\
\000\000\016\000\017\000\018\000\019\000\020\000\021\000\022\000\
\023\000\024\000\060\000\026\000\027\000\028\000\029\000\030\000\
\031\000\006\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\009\000\010\000\011\000\012\000\013\000\014\000\
\015\000\000\000\016\000\017\000\018\000\019\000\020\000\021\000\
\022\000\023\000\024\000\060\000\026\000\027\000\028\000\029\000\
\030\000\031\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\033\000\034\000\000\000\036\000\000\000\137\000\137\000\137\000\
\137\000\137\000\000\000\137\000\137\000\037\000\000\000\038\000\
\000\000\000\000\000\000\000\000\000\000\043\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\033\000\034\000\000\000\036\000\137\000\137\000\137\000\
\000\000\000\000\000\000\000\000\000\000\000\000\037\000\000\000\
\038\000\000\000\000\000\000\000\000\000\000\000\043\000\000\000\
\000\000\000\000\137\000\137\000\137\000\000\000\000\000\137\000\
\137\000\000\000\000\000\137\000\137\000\000\000\000\000\000\000\
\137\000\137\000\000\000\137\000\000\000\137\000\000\000\000\000\
\000\000\199\000\200\000\201\000\202\000\203\000\000\000\083\000\
\204\000\000\000\000\000\000\000\000\000\000\000\000\000\038\001\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\137\000\137\000\000\000\137\000\000\000\000\000\000\000\137\000\
\137\000\205\000\206\000\000\000\000\000\000\000\000\000\000\000\
\039\001\000\000\137\000\040\001\041\001\000\000\000\000\031\000\
\000\000\000\000\000\000\000\000\000\000\000\000\207\000\208\000\
\209\000\000\000\000\000\210\000\211\000\000\000\000\000\212\000\
\213\000\000\000\000\000\000\000\214\000\215\000\000\000\216\000\
\000\000\209\001\000\000\000\000\000\000\199\000\200\000\201\000\
\202\000\203\000\000\000\083\000\204\000\000\000\098\002\000\000\
\000\000\214\001\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\084\000\085\000\000\000\217\000\
\000\000\000\000\000\000\218\000\219\000\205\000\206\000\033\000\
\000\000\215\001\000\000\000\000\000\000\000\000\220\000\000\000\
\000\000\000\000\000\000\000\000\037\000\000\000\038\000\000\000\
\000\000\000\000\207\000\208\000\209\000\000\000\000\000\210\000\
\211\000\000\000\000\000\212\000\213\000\000\000\000\000\000\000\
\214\000\215\000\000\000\216\000\000\000\116\002\000\000\000\000\
\000\000\133\000\133\000\133\000\133\000\133\000\000\000\133\000\
\133\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\084\000\085\000\000\000\217\000\000\000\000\000\000\000\218\000\
\219\000\133\000\133\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\220\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\133\000\133\000\
\133\000\000\000\000\000\133\000\133\000\000\000\000\000\133\000\
\133\000\000\000\000\000\000\000\133\000\133\000\000\000\133\000\
\000\000\133\000\000\000\000\000\000\000\199\000\200\000\201\000\
\202\000\203\000\000\000\083\000\204\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\133\000\133\000\000\000\133\000\
\000\000\000\000\000\000\133\000\133\000\205\000\206\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\133\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\207\000\208\000\209\000\000\000\000\000\210\000\
\211\000\000\000\000\000\212\000\213\000\000\000\000\000\000\000\
\214\000\215\000\000\000\252\000\199\000\200\000\201\000\202\000\
\203\000\000\000\083\000\204\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\199\000\
\200\000\201\000\202\000\203\000\000\000\083\000\204\000\000\000\
\084\000\085\000\000\000\217\000\205\000\206\000\000\000\218\000\
\219\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\220\000\000\000\000\000\000\000\000\000\205\000\
\206\000\207\000\208\000\209\000\000\000\000\000\210\000\211\000\
\000\000\000\000\212\000\213\000\000\000\000\000\000\000\214\000\
\215\000\000\000\254\000\000\000\207\000\208\000\209\000\000\000\
\000\000\210\000\211\000\000\000\000\000\212\000\213\000\000\000\
\000\000\000\000\214\000\215\000\000\000\216\000\199\000\200\000\
\201\000\202\000\203\000\000\000\083\000\204\000\000\000\084\000\
\085\000\000\000\217\000\000\000\000\000\000\000\218\000\219\000\
\000\000\199\000\200\000\201\000\202\000\203\000\000\000\083\000\
\204\000\220\000\084\000\085\000\000\000\217\000\205\000\206\000\
\000\000\218\000\219\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\220\000\000\000\000\000\000\000\
\000\000\205\000\206\000\207\000\208\000\209\000\000\000\000\000\
\210\000\211\000\000\000\000\000\212\000\213\000\000\000\000\000\
\000\000\214\000\215\000\000\000\103\001\000\000\207\000\208\000\
\209\000\000\000\000\000\210\000\211\000\000\000\000\000\212\000\
\213\000\000\000\000\000\000\000\214\000\215\000\000\000\105\001\
\199\000\200\000\201\000\202\000\203\000\000\000\083\000\204\000\
\000\000\084\000\085\000\000\000\217\000\000\000\000\000\000\000\
\218\000\219\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\220\000\084\000\085\000\000\000\217\000\
\205\000\206\000\000\000\218\000\219\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\220\000\000\000\
\000\000\000\000\000\000\000\000\000\000\207\000\208\000\209\000\
\000\000\000\000\210\000\211\000\000\000\000\000\212\000\213\000\
\000\000\000\000\000\000\214\000\215\000\000\000\114\001\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\112\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\084\000\085\000\000\000\217\000\000\000\
\000\000\000\000\218\000\219\000\112\000\000\000\000\000\112\000\
\112\000\000\000\000\000\112\000\000\000\220\000\112\000\112\000\
\112\000\112\000\112\000\112\000\112\000\112\000\112\000\112\000\
\112\000\112\000\112\000\112\000\112\000\112\000\112\000\112\000\
\112\000\112\000\112\000\112\000\112\000\112\000\000\000\112\000\
\112\000\112\000\000\000\112\000\112\000\112\000\112\000\112\000\
\112\000\112\000\112\000\112\000\000\000\112\000\112\000\112\000\
\112\000\112\000\112\000\112\000\000\000\000\000\000\000\000\000\
\000\000\000\000\048\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\112\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\112\000\000\000\112\000\048\000\000\000\112\000\048\000\048\000\
\000\000\000\000\048\000\000\000\000\000\048\000\048\000\048\000\
\048\000\048\000\048\000\048\000\048\000\048\000\048\000\048\000\
\000\000\000\000\048\000\048\000\048\000\048\000\048\000\048\000\
\048\000\048\000\048\000\048\000\048\000\000\000\048\000\048\000\
\048\000\000\000\048\000\048\000\048\000\048\000\000\000\000\000\
\048\000\000\000\048\000\000\000\000\000\048\000\048\000\048\000\
\048\000\048\000\048\000\000\000\000\000\000\000\000\000\000\000\
\000\000\052\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\048\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\048\000\
\000\000\048\000\052\000\000\000\048\000\052\000\052\000\000\000\
\000\000\052\000\000\000\000\000\052\000\052\000\052\000\052\000\
\052\000\052\000\052\000\052\000\052\000\052\000\052\000\000\000\
\000\000\052\000\052\000\052\000\052\000\052\000\052\000\052\000\
\052\000\052\000\052\000\052\000\000\000\052\000\052\000\052\000\
\000\000\052\000\052\000\052\000\052\000\000\000\000\000\052\000\
\000\000\052\000\000\000\000\000\052\000\052\000\052\000\052\000\
\052\000\052\000\000\000\000\000\000\000\000\000\000\000\000\000\
\054\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\052\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\052\000\000\000\
\052\000\054\000\000\000\052\000\054\000\054\000\000\000\000\000\
\054\000\000\000\000\000\054\000\054\000\054\000\054\000\054\000\
\054\000\054\000\054\000\054\000\054\000\054\000\000\000\000\000\
\054\000\054\000\054\000\054\000\054\000\054\000\054\000\054\000\
\054\000\054\000\054\000\000\000\054\000\054\000\054\000\000\000\
\054\000\054\000\054\000\054\000\000\000\064\000\054\000\000\000\
\054\000\000\000\000\000\054\000\054\000\054\000\054\000\054\000\
\054\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\064\000\000\000\
\054\000\064\000\064\000\000\000\000\000\064\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\054\000\000\000\054\000\
\000\000\000\000\054\000\000\000\000\000\064\000\064\000\064\000\
\064\000\064\000\064\000\064\000\064\000\064\000\064\000\064\000\
\000\000\064\000\064\000\064\000\000\000\064\000\064\000\064\000\
\064\000\000\000\068\000\064\000\000\000\064\000\000\000\000\000\
\064\000\064\000\064\000\064\000\064\000\064\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\068\000\000\000\064\000\068\000\068\000\
\000\000\000\000\068\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\064\000\000\000\064\000\000\000\000\000\000\000\
\000\000\000\000\068\000\068\000\068\000\068\000\068\000\068\000\
\068\000\068\000\000\000\000\000\000\000\000\000\068\000\068\000\
\068\000\000\000\068\000\068\000\068\000\068\000\000\000\069\000\
\068\000\000\000\068\000\000\000\000\000\068\000\068\000\068\000\
\068\000\068\000\068\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\069\000\000\000\068\000\069\000\069\000\000\000\000\000\069\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\068\000\
\000\000\068\000\000\000\000\000\000\000\000\000\000\000\069\000\
\069\000\069\000\069\000\069\000\069\000\069\000\069\000\000\000\
\000\000\000\000\000\000\069\000\069\000\069\000\000\000\069\000\
\069\000\069\000\069\000\000\000\070\000\069\000\000\000\069\000\
\000\000\000\000\069\000\069\000\069\000\069\000\069\000\069\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\070\000\000\000\069\000\
\070\000\070\000\000\000\000\000\070\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\069\000\000\000\069\000\000\000\
\000\000\000\000\000\000\000\000\070\000\070\000\070\000\070\000\
\070\000\070\000\070\000\070\000\000\000\000\000\000\000\000\000\
\070\000\070\000\070\000\000\000\070\000\070\000\070\000\070\000\
\000\000\071\000\070\000\000\000\070\000\000\000\000\000\070\000\
\070\000\070\000\070\000\070\000\070\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\071\000\000\000\070\000\071\000\071\000\000\000\
\000\000\071\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\070\000\000\000\070\000\000\000\000\000\000\000\000\000\
\000\000\071\000\071\000\071\000\071\000\071\000\071\000\000\000\
\000\000\000\000\000\000\000\000\000\000\071\000\071\000\071\000\
\000\000\071\000\071\000\071\000\071\000\000\000\072\000\071\000\
\000\000\071\000\000\000\000\000\071\000\071\000\071\000\071\000\
\071\000\071\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\072\000\
\000\000\071\000\072\000\072\000\000\000\000\000\072\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\071\000\000\000\
\071\000\000\000\000\000\000\000\000\000\000\000\072\000\072\000\
\072\000\072\000\072\000\072\000\000\000\000\000\000\000\000\000\
\000\000\000\000\072\000\072\000\072\000\000\000\072\000\072\000\
\072\000\072\000\000\000\073\000\072\000\000\000\072\000\000\000\
\000\000\072\000\072\000\072\000\072\000\072\000\072\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\073\000\000\000\072\000\073\000\
\073\000\000\000\000\000\073\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\072\000\000\000\072\000\000\000\000\000\
\000\000\000\000\000\000\073\000\073\000\073\000\073\000\073\000\
\073\000\000\000\000\000\000\000\000\000\000\000\000\000\073\000\
\073\000\073\000\000\000\073\000\073\000\073\000\073\000\000\000\
\074\000\073\000\000\000\073\000\000\000\000\000\073\000\073\000\
\073\000\073\000\073\000\073\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\074\000\000\000\073\000\074\000\074\000\000\000\000\000\
\074\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\073\000\000\000\073\000\000\000\000\000\000\000\000\000\000\000\
\074\000\074\000\074\000\074\000\074\000\074\000\000\000\000\000\
\000\000\000\000\000\000\000\000\074\000\074\000\074\000\000\000\
\074\000\074\000\075\000\000\000\000\000\000\000\074\000\000\000\
\074\000\000\000\000\000\074\000\074\000\074\000\074\000\074\000\
\074\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\075\000\000\000\000\000\075\000\075\000\
\074\000\000\000\075\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\074\000\000\000\074\000\
\000\000\000\000\075\000\075\000\075\000\075\000\075\000\075\000\
\000\000\000\000\000\000\000\000\000\000\000\000\075\000\075\000\
\075\000\000\000\075\000\075\000\076\000\000\000\000\000\000\000\
\075\000\000\000\075\000\000\000\000\000\075\000\075\000\075\000\
\075\000\075\000\075\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\076\000\000\000\000\000\
\076\000\076\000\075\000\000\000\076\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\075\000\
\000\000\075\000\000\000\000\000\076\000\076\000\076\000\076\000\
\076\000\076\000\000\000\000\000\000\000\000\000\000\000\000\000\
\076\000\076\000\076\000\000\000\076\000\076\000\077\000\000\000\
\000\000\000\000\076\000\000\000\076\000\000\000\000\000\076\000\
\076\000\076\000\076\000\076\000\076\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\077\000\
\000\000\000\000\077\000\077\000\076\000\000\000\077\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\076\000\000\000\076\000\000\000\000\000\077\000\077\000\
\077\000\077\000\077\000\077\000\000\000\000\000\000\000\000\000\
\000\000\000\000\077\000\077\000\077\000\000\000\077\000\077\000\
\078\000\000\000\000\000\000\000\077\000\000\000\077\000\000\000\
\000\000\077\000\077\000\077\000\077\000\077\000\077\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\078\000\000\000\000\000\078\000\078\000\077\000\000\000\
\078\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\077\000\000\000\077\000\000\000\000\000\
\078\000\078\000\078\000\078\000\078\000\078\000\000\000\000\000\
\079\000\000\000\000\000\000\000\078\000\078\000\078\000\000\000\
\078\000\078\000\000\000\000\000\000\000\000\000\078\000\000\000\
\078\000\000\000\000\000\078\000\078\000\078\000\078\000\078\000\
\078\000\079\000\000\000\000\000\079\000\079\000\000\000\000\000\
\079\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\078\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\079\000\079\000\000\000\000\000\000\000\078\000\000\000\078\000\
\080\000\000\000\000\000\000\000\079\000\079\000\079\000\000\000\
\079\000\079\000\000\000\000\000\000\000\000\000\079\000\000\000\
\079\000\000\000\000\000\079\000\079\000\079\000\079\000\079\000\
\079\000\080\000\000\000\000\000\080\000\080\000\000\000\000\000\
\080\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\079\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\080\000\080\000\000\000\000\000\000\000\079\000\000\000\079\000\
\081\000\000\000\000\000\000\000\080\000\080\000\080\000\000\000\
\080\000\080\000\000\000\000\000\000\000\000\000\080\000\000\000\
\080\000\000\000\000\000\080\000\080\000\080\000\080\000\080\000\
\080\000\081\000\000\000\000\000\081\000\081\000\000\000\000\000\
\081\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\080\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\081\000\081\000\000\000\000\000\000\000\080\000\000\000\080\000\
\082\000\000\000\000\000\000\000\081\000\081\000\081\000\000\000\
\081\000\081\000\000\000\000\000\000\000\000\000\081\000\000\000\
\081\000\000\000\000\000\081\000\081\000\081\000\081\000\081\000\
\081\000\082\000\000\000\000\000\082\000\082\000\000\000\000\000\
\082\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\081\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\081\000\000\000\081\000\
\083\000\000\000\000\000\000\000\082\000\082\000\082\000\000\000\
\082\000\082\000\000\000\000\000\000\000\000\000\082\000\000\000\
\082\000\000\000\000\000\082\000\082\000\082\000\082\000\082\000\
\082\000\083\000\000\000\000\000\083\000\083\000\000\000\000\000\
\083\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\082\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\082\000\000\000\082\000\
\084\000\000\000\000\000\000\000\083\000\083\000\083\000\000\000\
\083\000\083\000\000\000\000\000\000\000\000\000\083\000\000\000\
\083\000\000\000\000\000\083\000\083\000\083\000\083\000\083\000\
\083\000\084\000\000\000\000\000\084\000\084\000\000\000\000\000\
\084\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\083\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\083\000\000\000\083\000\
\085\000\000\000\000\000\000\000\000\000\084\000\084\000\000\000\
\084\000\084\000\000\000\000\000\000\000\000\000\084\000\000\000\
\084\000\000\000\000\000\084\000\084\000\084\000\084\000\084\000\
\084\000\085\000\000\000\000\000\085\000\085\000\000\000\000\000\
\085\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\084\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\084\000\000\000\084\000\
\086\000\000\000\000\000\000\000\000\000\085\000\085\000\000\000\
\085\000\085\000\000\000\000\000\000\000\000\000\085\000\000\000\
\085\000\000\000\000\000\085\000\085\000\085\000\085\000\085\000\
\085\000\086\000\000\000\000\000\086\000\086\000\000\000\000\000\
\086\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\085\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\085\000\000\000\085\000\
\087\000\000\000\000\000\000\000\000\000\086\000\000\000\000\000\
\086\000\086\000\000\000\000\000\000\000\000\000\086\000\000\000\
\086\000\000\000\000\000\086\000\086\000\086\000\086\000\086\000\
\086\000\087\000\000\000\000\000\087\000\087\000\000\000\000\000\
\087\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\086\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\086\000\000\000\086\000\
\088\000\000\000\000\000\000\000\000\000\087\000\000\000\000\000\
\087\000\087\000\000\000\000\000\000\000\000\000\087\000\000\000\
\087\000\000\000\000\000\087\000\087\000\087\000\087\000\087\000\
\087\000\088\000\000\000\000\000\088\000\088\000\000\000\000\000\
\088\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\087\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\087\000\000\000\087\000\
\089\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\088\000\088\000\000\000\000\000\000\000\000\000\088\000\000\000\
\088\000\000\000\000\000\088\000\088\000\088\000\088\000\088\000\
\088\000\089\000\000\000\000\000\089\000\089\000\000\000\000\000\
\089\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\088\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\088\000\000\000\088\000\
\090\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\089\000\089\000\000\000\000\000\000\000\000\000\089\000\000\000\
\089\000\000\000\000\000\089\000\089\000\089\000\089\000\089\000\
\089\000\090\000\000\000\000\000\090\000\090\000\000\000\000\000\
\090\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\089\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\089\000\000\000\089\000\
\091\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\090\000\000\000\000\000\000\000\000\000\090\000\000\000\
\090\000\000\000\000\000\090\000\090\000\090\000\090\000\090\000\
\090\000\091\000\000\000\000\000\091\000\091\000\244\000\000\000\
\091\000\000\000\000\000\000\000\100\000\000\000\000\000\101\000\
\090\000\102\000\083\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\090\000\000\000\090\000\
\000\000\000\000\000\000\000\000\103\000\000\000\000\000\104\000\
\000\000\091\000\000\000\000\000\105\000\106\000\091\000\000\000\
\091\000\000\000\000\000\091\000\091\000\091\000\091\000\091\000\
\091\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\107\000\108\000\109\000\000\000\000\000\110\000\111\000\
\091\000\000\000\112\000\000\000\000\000\244\000\000\000\000\000\
\000\000\173\001\113\000\100\000\000\000\091\000\101\000\091\000\
\102\000\083\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\114\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\103\000\000\000\000\000\104\000\084\000\
\085\000\098\001\000\000\105\000\106\000\000\000\000\000\100\000\
\000\000\000\000\101\000\000\000\102\000\083\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\107\000\108\000\109\000\000\000\000\000\110\000\111\000\103\000\
\000\000\112\000\104\000\000\000\000\000\000\000\000\000\105\000\
\106\000\113\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\114\000\000\000\000\000\107\000\108\000\109\000\000\000\
\000\000\110\000\111\000\000\000\000\000\112\000\084\000\085\000\
\057\002\000\000\000\000\000\000\000\000\113\000\100\000\000\000\
\000\000\101\000\000\000\102\000\083\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\114\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\103\000\000\000\
\000\000\104\000\084\000\085\000\000\000\000\000\105\000\106\000\
\000\000\000\000\100\000\000\000\000\000\101\000\000\000\102\000\
\083\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\107\000\108\000\109\000\000\000\000\000\
\110\000\111\000\103\000\000\000\112\000\104\000\000\000\000\000\
\000\000\000\000\105\000\106\000\113\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\114\000\000\000\000\000\107\000\
\108\000\109\000\000\000\000\000\110\000\111\000\000\000\000\000\
\112\000\084\000\085\000\000\000\000\000\000\000\000\000\000\000\
\113\000\000\000\000\000\000\000\000\000\129\001\129\001\129\001\
\129\001\129\001\129\001\000\000\000\000\000\000\000\000\000\000\
\114\000\129\001\129\001\129\001\000\000\129\001\129\001\000\000\
\000\000\000\000\000\000\129\001\000\000\084\000\085\000\000\000\
\129\001\129\001\129\001\129\001\000\000\129\001\130\001\130\001\
\130\001\130\001\130\001\130\001\000\000\000\000\000\000\000\000\
\000\000\000\000\130\001\130\001\130\001\000\000\130\001\130\001\
\000\000\000\000\000\000\000\000\130\001\000\000\000\000\000\000\
\000\000\130\001\130\001\130\001\130\001\000\000\130\001\129\001\
\000\000\131\001\131\001\131\001\131\001\131\001\131\001\000\000\
\000\000\000\000\000\000\000\000\000\000\131\001\131\001\131\001\
\000\000\131\001\131\001\000\000\000\000\000\000\000\000\131\001\
\000\000\000\000\000\000\000\000\131\001\131\001\131\001\131\001\
\130\001\131\001\132\001\132\001\132\001\132\001\132\001\132\001\
\000\000\000\000\000\000\000\000\000\000\000\000\132\001\132\001\
\132\001\000\000\132\001\132\001\000\000\000\000\000\000\000\000\
\132\001\000\000\000\000\000\000\000\000\132\001\132\001\132\001\
\132\001\000\000\132\001\131\001\000\000\133\001\133\001\133\001\
\133\001\133\001\133\001\000\000\000\000\000\000\000\000\000\000\
\000\000\133\001\133\001\133\001\000\000\133\001\133\001\000\000\
\000\000\000\000\000\000\133\001\134\001\134\001\000\000\000\000\
\133\001\133\001\133\001\133\001\132\001\133\001\000\000\000\000\
\134\001\134\001\134\001\000\000\134\001\134\001\000\000\000\000\
\000\000\000\000\134\001\135\001\135\001\000\000\000\000\134\001\
\134\001\134\001\134\001\000\000\134\001\000\000\000\000\135\001\
\135\001\135\001\000\000\135\001\135\001\000\000\000\000\133\001\
\000\000\135\001\136\001\136\001\000\000\000\000\135\001\135\001\
\135\001\135\001\000\000\135\001\000\000\000\000\136\001\136\001\
\136\001\000\000\136\001\136\001\000\000\000\000\134\001\000\000\
\136\001\000\000\000\000\000\000\000\000\136\001\136\001\136\001\
\136\001\000\000\136\001\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\135\001\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\136\001\029\000\029\000\029\000\
\029\000\029\000\029\000\029\000\029\000\029\000\029\000\029\000\
\029\000\029\000\029\000\029\000\029\000\029\000\029\000\029\000\
\029\000\029\000\029\000\029\000\029\000\000\000\029\000\029\000\
\029\000\000\000\029\000\029\000\029\000\029\000\029\000\029\000\
\000\000\029\000\029\000\000\000\029\000\000\000\023\000\029\000\
\029\000\000\000\029\000"

let yycheck = "\025\000\
\044\000\001\000\002\000\032\000\151\000\047\001\213\000\166\000\
\053\000\158\000\031\001\224\001\001\000\002\000\040\000\004\000\
\141\000\062\000\049\000\048\000\069\000\000\000\000\000\000\000\
\049\001\175\000\176\000\061\000\165\000\018\000\061\000\049\001\
\032\000\217\001\049\000\087\000\025\000\026\000\196\000\086\002\
\029\000\030\000\086\000\032\000\000\001\034\000\061\000\040\000\
\048\000\044\000\130\002\100\000\080\000\075\001\076\001\044\000\
\003\001\089\002\097\000\048\000\006\001\050\000\000\001\216\000\
\000\001\011\001\055\000\226\000\057\000\166\000\096\000\060\000\
\098\000\016\000\017\000\064\000\019\000\052\001\051\001\052\001\
\000\001\107\000\108\000\109\000\110\000\111\000\112\000\113\000\
\105\000\106\000\000\001\076\001\136\000\137\000\133\000\159\002\
\082\001\086\000\162\002\252\000\075\001\254\000\053\001\061\001\
\079\001\006\001\079\001\006\001\097\000\138\000\011\001\006\001\
\011\001\193\002\044\001\061\001\011\001\006\001\048\001\076\001\
\113\000\077\001\012\001\006\001\082\001\061\001\000\001\062\003\
\011\001\226\000\073\000\216\000\132\000\119\001\077\000\166\000\
\000\001\072\003\138\000\082\000\078\001\136\000\137\000\132\000\
\082\001\083\001\000\001\136\000\137\000\138\000\181\000\166\000\
\180\000\223\001\201\002\183\000\184\000\185\000\078\001\077\001\
\188\000\189\000\061\001\192\000\228\002\083\001\059\001\252\000\
\078\001\254\000\196\000\216\000\100\002\225\000\206\002\044\001\
\165\000\076\001\125\001\048\001\049\001\076\001\139\002\077\001\
\079\001\075\001\067\001\076\001\205\000\206\000\061\001\081\001\
\192\000\218\001\006\001\078\001\004\003\214\000\215\000\011\001\
\001\000\002\000\191\000\192\000\078\001\230\001\103\001\252\000\
\105\001\254\000\081\001\226\000\230\001\231\001\078\001\105\001\
\106\001\114\001\101\001\176\002\028\003\243\001\248\000\124\001\
\078\001\124\001\117\001\216\000\082\001\124\001\076\001\114\001\
\076\001\107\000\108\000\109\000\110\000\111\000\112\000\136\001\
\137\001\124\001\012\001\013\001\014\001\015\001\016\001\017\001\
\018\001\019\001\020\001\021\001\022\001\023\001\024\001\025\001\
\026\001\027\001\028\001\029\001\030\001\031\001\076\001\252\000\
\047\001\254\000\078\001\045\001\170\001\171\001\061\001\168\001\
\086\002\087\002\103\001\012\001\105\001\000\001\000\001\000\001\
\012\001\006\001\076\001\042\001\214\001\114\001\011\001\070\001\
\075\001\075\002\081\001\082\001\012\001\013\001\123\001\124\001\
\083\001\080\001\063\002\229\001\052\001\231\001\017\000\006\001\
\019\000\006\001\078\001\078\001\011\001\081\001\011\001\061\001\
\124\001\116\002\103\001\012\001\105\001\095\001\090\001\000\000\
\213\001\006\001\094\001\010\001\011\001\114\001\011\001\079\001\
\061\001\132\002\000\001\000\001\082\001\101\001\067\001\006\001\
\006\001\006\001\078\001\122\001\011\001\000\001\011\001\017\002\
\075\001\214\001\114\001\006\001\134\002\218\001\000\001\076\001\
\083\001\167\002\077\001\169\002\065\001\171\002\006\001\074\000\
\229\001\230\001\231\001\011\001\006\001\061\001\076\001\008\002\
\009\002\011\001\103\001\006\001\105\001\105\001\106\001\078\001\
\011\001\059\001\060\001\006\001\076\001\114\001\075\001\079\001\
\011\001\105\001\106\001\201\002\081\001\084\002\123\001\124\001\
\061\001\078\001\089\002\013\001\014\001\015\001\101\001\124\001\
\170\001\171\001\061\001\087\002\017\002\076\001\075\001\076\001\
\105\001\106\001\079\001\114\001\081\001\082\001\083\001\080\001\
\075\001\076\001\070\001\084\001\079\001\124\001\081\001\082\001\
\083\001\006\001\209\001\075\001\076\001\222\001\011\001\079\001\
\106\002\085\001\061\001\083\001\078\001\212\001\079\002\124\001\
\075\001\076\001\006\001\006\001\079\001\132\001\133\001\011\001\
\083\001\076\001\097\002\226\001\079\001\124\001\070\001\124\001\
\151\002\006\001\006\001\101\001\101\002\037\001\157\002\011\001\
\247\001\124\001\006\001\076\001\080\001\085\001\075\001\083\001\
\114\001\248\001\006\001\122\002\124\001\249\001\083\001\011\001\
\061\001\077\001\124\001\167\002\217\001\169\002\082\001\171\002\
\077\001\124\001\076\001\224\001\076\001\106\002\075\001\076\001\
\006\001\124\001\079\001\000\001\078\001\011\001\083\001\075\001\
\093\001\094\001\095\001\077\001\203\002\081\001\078\001\206\002\
\082\001\080\001\078\001\150\002\083\001\158\002\071\001\072\001\
\215\002\061\001\209\001\218\002\078\001\101\001\200\002\075\001\
\076\001\013\003\081\001\079\001\067\001\084\001\229\002\083\001\
\076\001\126\001\114\001\040\001\116\001\068\002\082\001\124\001\
\076\001\118\002\119\002\031\003\075\002\063\002\207\000\208\000\
\209\000\210\000\211\000\212\000\040\001\089\002\076\001\081\001\
\124\001\079\001\001\003\075\001\076\001\049\003\080\002\079\001\
\078\001\210\002\009\003\083\001\011\003\214\002\081\001\075\001\
\124\001\078\001\097\002\079\001\019\003\082\001\083\001\083\001\
\124\001\030\001\066\001\200\002\033\001\116\002\069\001\075\001\
\124\001\032\003\097\002\053\001\054\001\081\001\082\001\083\001\
\083\001\089\002\129\002\075\001\006\001\132\002\005\001\134\002\
\080\001\081\001\082\001\128\002\089\002\226\002\124\001\000\001\
\059\001\060\001\215\002\122\002\082\001\218\002\061\003\100\002\
\000\001\061\001\062\001\063\001\013\003\005\001\163\002\030\001\
\229\002\160\002\033\001\034\001\067\002\250\002\037\001\107\001\
\128\002\118\002\119\002\061\001\062\001\063\001\031\003\055\001\
\056\001\057\001\058\001\128\002\000\001\010\003\030\001\040\001\
\175\002\033\001\034\001\040\001\001\003\037\001\139\002\082\001\
\049\003\071\001\072\001\194\002\009\003\082\001\011\003\093\001\
\094\001\095\001\151\002\053\001\054\001\076\001\019\003\083\001\
\079\001\075\001\005\001\098\001\099\001\116\002\093\001\094\001\
\095\001\120\002\075\001\032\003\040\001\078\001\082\001\083\001\
\081\001\082\001\083\001\176\002\082\001\132\002\101\001\061\001\
\103\001\082\001\083\001\030\001\082\001\083\001\033\001\034\001\
\220\002\221\002\037\001\114\001\083\001\116\001\136\000\137\000\
\061\003\055\001\056\001\057\001\058\001\101\001\075\001\075\001\
\005\003\040\001\078\001\002\003\083\001\081\001\082\001\083\001\
\006\001\013\003\114\001\075\001\116\001\153\001\154\001\020\003\
\080\001\081\001\082\001\083\001\078\001\150\001\151\001\152\001\
\153\001\154\001\155\001\156\001\157\001\158\001\159\001\160\001\
\161\001\162\001\163\001\164\001\165\001\166\001\167\001\040\001\
\041\001\042\001\043\001\044\001\045\001\046\001\047\001\048\001\
\049\001\050\001\101\001\082\001\103\001\161\001\162\001\119\001\
\157\001\158\001\159\001\160\001\046\003\060\003\077\001\114\001\
\013\003\116\001\000\001\001\001\078\001\003\001\004\001\005\001\
\006\001\007\001\008\001\009\001\010\001\011\001\012\001\013\001\
\014\001\015\001\016\001\017\001\018\001\019\001\020\001\077\001\
\022\001\023\001\024\001\025\001\026\001\027\001\028\001\029\001\
\030\001\031\001\032\001\033\001\034\001\035\001\036\001\037\001\
\038\001\039\001\155\001\156\001\018\000\020\001\021\001\022\001\
\023\001\016\001\017\001\078\001\026\000\018\001\019\001\029\000\
\030\000\075\001\024\001\025\001\034\000\059\001\060\001\061\001\
\075\001\075\001\064\001\065\001\076\001\076\001\068\001\069\001\
\076\001\076\001\011\002\073\001\074\001\065\001\076\001\077\001\
\078\001\055\000\075\001\057\000\082\001\067\001\066\001\083\001\
\086\001\087\001\088\001\089\001\090\001\091\001\092\001\093\001\
\094\001\095\001\096\001\097\001\069\001\005\001\075\001\101\001\
\102\001\103\001\104\001\105\001\106\001\009\001\108\001\009\001\
\075\001\009\001\112\001\113\001\114\001\115\001\116\001\117\001\
\118\001\077\001\119\001\075\001\122\001\123\001\030\001\125\001\
\126\001\033\001\034\001\000\001\001\001\037\001\077\001\004\001\
\005\001\006\001\007\001\008\001\009\001\010\001\011\001\012\001\
\013\001\014\001\015\001\016\001\017\001\018\001\019\001\020\001\
\077\001\022\001\023\001\024\001\025\001\026\001\027\001\028\001\
\029\001\030\001\031\001\032\001\033\001\034\001\035\001\036\001\
\037\001\038\001\039\001\075\001\111\001\077\001\075\001\077\001\
\080\001\081\001\082\001\083\001\084\001\075\001\075\001\075\001\
\081\001\006\001\077\001\077\001\083\001\126\002\059\001\060\001\
\061\001\082\001\077\001\064\001\065\001\101\001\077\001\068\001\
\069\001\077\001\075\001\083\001\073\001\074\001\076\001\076\001\
\077\001\078\001\114\001\082\001\116\001\082\001\075\001\075\001\
\075\001\086\001\087\001\088\001\089\001\090\001\091\001\092\001\
\093\001\094\001\095\001\096\001\097\001\075\001\075\001\080\001\
\101\001\102\001\103\001\104\001\105\001\106\001\081\001\108\001\
\006\001\006\001\076\001\112\001\113\001\114\001\115\001\116\001\
\117\001\118\001\082\001\079\001\083\001\122\001\123\001\000\001\
\001\001\126\001\082\001\004\001\005\001\006\001\007\001\008\001\
\009\001\010\001\011\001\012\001\013\001\014\001\015\001\016\001\
\017\001\018\001\019\001\020\001\077\001\022\001\023\001\024\001\
\025\001\026\001\027\001\028\001\029\001\030\001\031\001\032\001\
\033\001\034\001\035\001\036\001\037\001\038\001\039\001\139\001\
\140\001\141\001\142\001\143\001\144\001\145\001\146\001\147\001\
\148\001\149\001\077\001\077\001\077\001\083\001\083\001\075\001\
\075\001\075\001\059\001\060\001\061\001\075\001\078\001\064\001\
\065\001\075\001\083\001\068\001\069\001\080\001\083\001\083\001\
\073\001\074\001\081\001\076\001\078\001\078\001\078\001\083\001\
\040\001\082\001\081\001\077\001\075\001\086\001\087\001\088\001\
\089\001\090\001\091\001\092\001\093\001\094\001\095\001\096\001\
\097\001\075\001\075\001\083\001\101\001\102\001\103\001\104\001\
\105\001\106\001\077\001\108\001\075\001\082\001\080\001\112\001\
\113\001\114\001\115\001\116\001\117\001\118\001\077\001\075\001\
\126\001\122\001\123\001\000\001\001\001\126\001\003\001\004\001\
\082\001\006\001\007\001\008\001\009\001\010\001\011\001\012\001\
\013\001\082\001\076\001\051\001\052\001\053\001\054\001\055\001\
\056\001\057\001\058\001\059\001\060\001\061\001\062\001\063\001\
\081\001\065\001\066\001\067\001\082\001\069\001\070\001\071\001\
\072\001\038\001\039\001\075\001\081\001\075\001\075\001\079\001\
\080\001\081\001\082\001\083\001\080\001\085\001\077\001\075\001\
\075\001\081\001\006\001\077\001\077\001\082\001\059\001\060\001\
\061\001\076\001\082\001\064\001\065\001\076\001\080\001\068\001\
\069\001\082\001\100\001\012\001\073\001\074\001\093\001\076\001\
\077\001\078\001\051\001\052\001\082\001\082\001\081\001\119\001\
\081\001\086\001\087\001\088\001\089\001\090\001\091\001\092\001\
\093\001\094\001\095\001\096\001\097\001\079\001\075\001\082\001\
\073\001\074\001\103\001\076\001\105\001\106\001\079\001\108\001\
\082\001\006\001\081\001\112\001\113\001\083\001\115\001\082\001\
\080\001\076\001\075\001\081\001\075\001\075\001\123\001\083\001\
\125\001\126\001\000\001\001\001\075\001\003\001\004\001\005\001\
\006\001\007\001\008\001\009\001\010\001\011\001\012\001\013\001\
\014\001\015\001\016\001\017\001\018\001\019\001\020\001\077\001\
\022\001\023\001\024\001\025\001\026\001\027\001\028\001\029\001\
\030\001\031\001\032\001\033\001\034\001\035\001\036\001\037\001\
\038\001\039\001\000\001\082\001\075\001\075\001\079\001\075\001\
\077\001\075\001\077\001\002\000\075\001\077\001\132\000\218\001\
\076\001\082\001\077\001\081\001\077\001\059\001\060\001\061\001\
\082\001\080\001\064\001\065\001\082\001\082\001\068\001\069\001\
\075\001\075\001\075\001\073\001\074\001\187\002\076\001\077\001\
\078\001\193\002\071\001\004\000\082\001\148\000\083\002\248\001\
\086\001\087\001\088\001\089\001\090\001\091\001\092\001\093\001\
\094\001\095\001\096\001\097\001\084\002\163\001\165\001\101\001\
\102\001\103\001\104\001\105\001\106\001\164\001\108\001\167\001\
\101\002\111\001\112\001\113\001\114\001\115\001\116\001\117\001\
\118\001\166\001\023\003\234\001\122\001\123\001\126\002\125\001\
\000\001\001\001\010\003\003\001\004\001\005\001\006\001\007\001\
\008\001\009\001\010\001\011\001\012\001\013\001\014\001\015\001\
\016\001\017\001\018\001\019\001\020\001\175\002\022\001\023\001\
\024\001\025\001\026\001\027\001\028\001\029\001\030\001\031\001\
\032\001\033\001\034\001\035\001\036\001\037\001\038\001\039\001\
\172\000\026\001\028\001\027\001\051\003\072\003\029\001\053\003\
\030\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\059\001\060\001\061\001\255\255\255\255\
\064\001\065\001\255\255\255\255\068\001\069\001\255\255\255\255\
\255\255\073\001\074\001\255\255\076\001\077\001\078\001\255\255\
\255\255\255\255\082\001\255\255\255\255\255\255\086\001\087\001\
\088\001\089\001\090\001\091\001\092\001\093\001\094\001\095\001\
\096\001\097\001\255\255\255\255\255\255\101\001\102\001\103\001\
\104\001\105\001\106\001\255\255\108\001\255\255\255\255\255\255\
\112\001\113\001\114\001\115\001\116\001\117\001\118\001\255\255\
\255\255\255\255\122\001\123\001\255\255\125\001\000\001\001\001\
\255\255\003\001\004\001\005\001\006\001\007\001\008\001\009\001\
\010\001\011\001\012\001\013\001\014\001\015\001\016\001\017\001\
\018\001\019\001\020\001\255\255\022\001\023\001\024\001\025\001\
\026\001\027\001\028\001\029\001\030\001\031\001\032\001\033\001\
\034\001\035\001\036\001\037\001\038\001\039\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\005\001\255\255\255\255\255\255\255\255\255\255\
\255\255\059\001\060\001\061\001\255\255\255\255\064\001\065\001\
\255\255\255\255\068\001\069\001\255\255\255\255\255\255\073\001\
\074\001\255\255\076\001\030\001\078\001\255\255\033\001\034\001\
\082\001\255\255\037\001\255\255\086\001\087\001\088\001\089\001\
\090\001\091\001\092\001\255\255\255\255\255\255\096\001\097\001\
\255\255\255\255\255\255\101\001\102\001\103\001\104\001\105\001\
\106\001\255\255\108\001\255\255\255\255\255\255\112\001\113\001\
\114\001\115\001\116\001\255\255\255\255\255\255\255\255\255\255\
\122\001\123\001\255\255\125\001\000\001\001\001\255\255\003\001\
\004\001\255\255\006\001\007\001\008\001\009\001\010\001\011\001\
\012\001\013\001\053\001\054\001\055\001\056\001\057\001\058\001\
\059\001\060\001\101\001\255\255\255\255\255\255\065\001\066\001\
\067\001\255\255\069\001\070\001\071\001\072\001\255\255\114\001\
\075\001\116\001\038\001\039\001\255\255\080\001\081\001\082\001\
\083\001\255\255\085\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\059\001\
\060\001\061\001\255\255\255\255\064\001\065\001\255\255\255\255\
\068\001\069\001\255\255\255\255\255\255\073\001\074\001\255\255\
\076\001\255\255\078\001\255\255\119\001\255\255\082\001\255\255\
\255\255\255\255\086\001\087\001\088\001\089\001\090\001\091\001\
\092\001\093\001\094\001\095\001\096\001\097\001\255\255\255\255\
\255\255\255\255\255\255\103\001\255\255\105\001\106\001\255\255\
\108\001\255\255\255\255\255\255\112\001\113\001\255\255\115\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\123\001\
\255\255\125\001\000\001\001\001\255\255\003\001\004\001\255\255\
\006\001\007\001\008\001\009\001\010\001\011\001\012\001\013\001\
\255\255\255\255\051\001\052\001\053\001\054\001\055\001\056\001\
\057\001\058\001\059\001\060\001\061\001\062\001\063\001\255\255\
\065\001\066\001\067\001\255\255\069\001\070\001\071\001\072\001\
\038\001\039\001\075\001\255\255\255\255\255\255\079\001\080\001\
\255\255\082\001\083\001\255\255\085\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\059\001\060\001\061\001\
\255\255\255\255\064\001\065\001\255\255\255\255\068\001\069\001\
\255\255\255\255\255\255\073\001\074\001\255\255\076\001\255\255\
\078\001\255\255\255\255\255\255\082\001\255\255\119\001\255\255\
\086\001\087\001\088\001\089\001\090\001\091\001\092\001\255\255\
\255\255\255\255\096\001\097\001\255\255\255\255\255\255\255\255\
\255\255\103\001\255\255\105\001\106\001\255\255\108\001\255\255\
\255\255\255\255\112\001\113\001\001\001\115\001\255\255\255\255\
\005\001\006\001\255\255\255\255\255\255\123\001\011\001\125\001\
\255\255\014\001\015\001\016\001\017\001\018\001\019\001\020\001\
\255\255\022\001\023\001\024\001\025\001\026\001\027\001\028\001\
\029\001\030\001\031\001\032\001\033\001\034\001\035\001\036\001\
\037\001\001\001\002\001\255\255\255\255\005\001\006\001\255\255\
\255\255\255\255\255\255\011\001\255\255\255\255\014\001\015\001\
\016\001\017\001\018\001\019\001\020\001\255\255\022\001\023\001\
\024\001\025\001\026\001\027\001\028\001\029\001\030\001\031\001\
\032\001\033\001\034\001\035\001\036\001\037\001\255\255\255\255\
\255\255\053\001\054\001\055\001\056\001\057\001\058\001\059\001\
\060\001\061\001\062\001\063\001\255\255\065\001\066\001\067\001\
\255\255\069\001\070\001\071\001\072\001\255\255\255\255\075\001\
\101\001\102\001\255\255\104\001\080\001\081\001\082\001\083\001\
\255\255\085\001\255\255\255\255\255\255\114\001\255\255\116\001\
\069\001\070\001\082\001\255\255\255\255\122\001\075\001\255\255\
\255\255\126\001\255\255\080\001\081\001\082\001\083\001\255\255\
\085\001\255\255\255\255\255\255\255\255\101\001\102\001\103\001\
\104\001\255\255\255\255\119\001\255\255\255\255\255\255\255\255\
\255\255\255\255\114\001\255\255\116\001\117\001\118\001\255\255\
\120\001\121\001\122\001\000\001\255\255\125\001\255\255\255\255\
\005\001\006\001\119\001\255\255\255\255\255\255\011\001\255\255\
\255\255\014\001\015\001\016\001\017\001\018\001\019\001\020\001\
\255\255\022\001\023\001\024\001\025\001\026\001\027\001\028\001\
\029\001\030\001\031\001\032\001\033\001\034\001\035\001\036\001\
\037\001\255\255\255\255\053\001\054\001\055\001\056\001\057\001\
\058\001\059\001\060\001\061\001\062\001\063\001\255\255\065\001\
\066\001\067\001\255\255\069\001\070\001\071\001\072\001\255\255\
\061\001\075\001\255\255\255\255\255\255\255\255\080\001\081\001\
\082\001\083\001\255\255\085\001\255\255\255\255\075\001\076\001\
\255\255\255\255\079\001\255\255\081\001\082\001\083\001\070\001\
\255\255\255\255\255\255\255\255\075\001\255\255\255\255\255\255\
\255\255\080\001\081\001\082\001\083\001\255\255\085\001\255\255\
\101\001\102\001\255\255\104\001\255\255\119\001\255\255\255\255\
\255\255\255\255\255\255\000\001\255\255\114\001\255\255\116\001\
\005\001\006\001\255\255\255\255\255\255\122\001\011\001\124\001\
\255\255\014\001\015\001\016\001\017\001\018\001\019\001\020\001\
\119\001\022\001\023\001\024\001\025\001\026\001\027\001\028\001\
\029\001\030\001\031\001\032\001\033\001\034\001\035\001\036\001\
\037\001\255\255\255\255\053\001\054\001\055\001\056\001\057\001\
\058\001\059\001\060\001\061\001\062\001\063\001\255\255\065\001\
\066\001\067\001\255\255\069\001\070\001\071\001\072\001\255\255\
\061\001\075\001\255\255\255\255\255\255\255\255\080\001\081\001\
\082\001\083\001\255\255\085\001\255\255\255\255\075\001\076\001\
\255\255\255\255\079\001\255\255\081\001\082\001\083\001\070\001\
\255\255\255\255\255\255\255\255\075\001\255\255\255\255\255\255\
\255\255\080\001\081\001\082\001\083\001\255\255\085\001\255\255\
\101\001\102\001\255\255\104\001\255\255\119\001\255\255\255\255\
\255\255\255\255\255\255\000\001\255\255\114\001\255\255\116\001\
\005\001\006\001\255\255\255\255\255\255\122\001\011\001\124\001\
\255\255\014\001\015\001\016\001\017\001\018\001\019\001\020\001\
\119\001\022\001\023\001\024\001\025\001\026\001\027\001\028\001\
\029\001\030\001\031\001\032\001\033\001\034\001\035\001\036\001\
\037\001\255\255\255\255\053\001\054\001\055\001\056\001\057\001\
\058\001\059\001\060\001\255\255\255\255\255\255\255\255\065\001\
\066\001\067\001\255\255\069\001\070\001\071\001\072\001\255\255\
\061\001\075\001\255\255\255\255\255\255\255\255\080\001\081\001\
\082\001\083\001\255\255\085\001\255\255\255\255\075\001\076\001\
\255\255\255\255\079\001\255\255\081\001\082\001\083\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\101\001\102\001\255\255\104\001\255\255\119\001\255\255\255\255\
\255\255\255\255\255\255\000\001\255\255\114\001\255\255\116\001\
\005\001\006\001\255\255\255\255\255\255\122\001\011\001\124\001\
\255\255\014\001\015\001\016\001\017\001\018\001\019\001\020\001\
\255\255\022\001\023\001\024\001\025\001\026\001\027\001\028\001\
\029\001\030\001\031\001\032\001\033\001\034\001\035\001\036\001\
\037\001\255\255\255\255\255\255\005\001\065\001\066\001\067\001\
\255\255\069\001\070\001\255\255\255\255\255\255\255\255\075\001\
\255\255\255\255\255\255\255\255\080\001\081\001\082\001\083\001\
\061\001\085\001\255\255\255\255\255\255\030\001\255\255\255\255\
\033\001\034\001\255\255\255\255\037\001\255\255\075\001\076\001\
\255\255\255\255\079\001\000\001\081\001\082\001\083\001\255\255\
\255\255\006\001\007\001\008\001\009\001\010\001\011\001\012\001\
\013\001\066\001\067\001\119\001\069\001\070\001\255\255\255\255\
\101\001\102\001\075\001\104\001\255\255\255\255\255\255\080\001\
\081\001\082\001\083\001\076\001\085\001\114\001\255\255\116\001\
\255\255\038\001\039\001\040\001\255\255\122\001\255\255\124\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\101\001\255\255\059\001\060\001\
\061\001\255\255\255\255\064\001\065\001\255\255\119\001\068\001\
\069\001\114\001\255\255\116\001\073\001\074\001\075\001\076\001\
\255\255\078\001\079\001\080\001\081\001\082\001\083\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\105\001\106\001\255\255\108\001\
\255\255\255\255\255\255\112\001\113\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\000\001\001\001\123\001\124\001\
\004\001\005\001\006\001\007\001\008\001\009\001\010\001\011\001\
\012\001\013\001\014\001\015\001\016\001\017\001\018\001\019\001\
\020\001\255\255\022\001\023\001\024\001\025\001\026\001\027\001\
\028\001\029\001\030\001\031\001\032\001\033\001\034\001\035\001\
\036\001\037\001\038\001\039\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\059\001\
\060\001\061\001\255\255\255\255\064\001\065\001\255\255\255\255\
\068\001\069\001\255\255\255\255\255\255\073\001\074\001\255\255\
\076\001\077\001\078\001\255\255\255\255\255\255\082\001\255\255\
\255\255\255\255\086\001\087\001\088\001\089\001\090\001\091\001\
\092\001\093\001\094\001\095\001\096\001\097\001\255\255\255\255\
\255\255\101\001\102\001\103\001\104\001\105\001\106\001\255\255\
\108\001\255\255\255\255\255\255\112\001\113\001\114\001\115\001\
\116\001\117\001\118\001\255\255\000\001\001\001\122\001\123\001\
\004\001\005\001\006\001\007\001\008\001\009\001\010\001\011\001\
\012\001\013\001\014\001\015\001\016\001\017\001\018\001\019\001\
\020\001\255\255\022\001\023\001\024\001\025\001\026\001\027\001\
\028\001\029\001\030\001\031\001\032\001\033\001\034\001\035\001\
\036\001\037\001\038\001\039\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\059\001\
\060\001\061\001\255\255\255\255\064\001\065\001\255\255\255\255\
\068\001\069\001\255\255\255\255\255\255\073\001\074\001\255\255\
\076\001\255\255\078\001\255\255\255\255\255\255\082\001\255\255\
\255\255\255\255\086\001\087\001\088\001\089\001\090\001\091\001\
\092\001\255\255\255\255\255\255\096\001\097\001\255\255\255\255\
\255\255\101\001\102\001\103\001\104\001\105\001\106\001\255\255\
\108\001\255\255\255\255\255\255\112\001\113\001\114\001\115\001\
\116\001\117\001\118\001\000\001\255\255\255\255\122\001\123\001\
\005\001\006\001\007\001\008\001\009\001\010\001\011\001\012\001\
\013\001\014\001\015\001\016\001\017\001\018\001\019\001\020\001\
\255\255\022\001\023\001\024\001\025\001\026\001\027\001\028\001\
\029\001\030\001\031\001\032\001\033\001\034\001\035\001\036\001\
\037\001\038\001\039\001\069\001\070\001\255\255\255\255\255\255\
\255\255\075\001\255\255\255\255\255\255\255\255\080\001\081\001\
\082\001\083\001\255\255\085\001\255\255\255\255\059\001\060\001\
\061\001\255\255\255\255\064\001\065\001\255\255\255\255\068\001\
\069\001\255\255\255\255\255\255\073\001\074\001\255\255\076\001\
\255\255\078\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\119\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\101\001\102\001\255\255\104\001\105\001\106\001\255\255\108\001\
\255\255\255\255\255\255\112\001\113\001\114\001\255\255\116\001\
\255\255\255\255\000\001\001\001\255\255\122\001\123\001\005\001\
\006\001\007\001\008\001\009\001\010\001\011\001\012\001\013\001\
\014\001\015\001\016\001\017\001\018\001\019\001\020\001\255\255\
\022\001\023\001\024\001\025\001\026\001\027\001\028\001\029\001\
\030\001\031\001\032\001\033\001\034\001\035\001\036\001\037\001\
\038\001\039\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\059\001\060\001\061\001\
\255\255\255\255\064\001\065\001\255\255\255\255\068\001\069\001\
\255\255\000\001\001\001\073\001\074\001\004\001\076\001\006\001\
\007\001\008\001\009\001\010\001\011\001\012\001\013\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\101\001\
\102\001\255\255\104\001\105\001\106\001\255\255\108\001\038\001\
\039\001\255\255\112\001\113\001\114\001\255\255\116\001\255\255\
\255\255\255\255\255\255\255\255\122\001\123\001\255\255\255\255\
\255\255\255\255\255\255\255\255\059\001\060\001\061\001\255\255\
\255\255\064\001\065\001\255\255\255\255\068\001\069\001\255\255\
\255\255\255\255\073\001\074\001\255\255\076\001\255\255\078\001\
\255\255\255\255\255\255\082\001\255\255\255\255\255\255\086\001\
\087\001\088\001\089\001\090\001\091\001\092\001\255\255\255\255\
\255\255\096\001\097\001\255\255\255\255\255\255\255\255\255\255\
\103\001\255\255\105\001\106\001\255\255\108\001\255\255\255\255\
\255\255\112\001\113\001\255\255\115\001\255\255\255\255\000\001\
\255\255\255\255\255\255\255\255\123\001\006\001\007\001\008\001\
\009\001\010\001\255\255\012\001\013\001\255\255\255\255\255\255\
\255\255\255\255\000\001\255\255\255\255\255\255\255\255\255\255\
\006\001\007\001\008\001\009\001\010\001\255\255\012\001\013\001\
\066\001\067\001\255\255\069\001\070\001\038\001\039\001\255\255\
\255\255\075\001\255\255\255\255\255\255\255\255\080\001\081\001\
\082\001\083\001\255\255\085\001\255\255\255\255\255\255\255\255\
\038\001\039\001\059\001\060\001\061\001\255\255\255\255\064\001\
\065\001\255\255\255\255\068\001\069\001\255\255\255\255\255\255\
\073\001\074\001\255\255\076\001\255\255\059\001\060\001\061\001\
\255\255\082\001\064\001\065\001\255\255\119\001\068\001\069\001\
\255\255\255\255\255\255\073\001\074\001\255\255\076\001\255\255\
\255\255\255\255\080\001\255\255\255\255\255\255\255\255\255\255\
\105\001\106\001\255\255\108\001\000\001\255\255\255\255\112\001\
\113\001\255\255\006\001\007\001\008\001\009\001\010\001\255\255\
\012\001\013\001\123\001\105\001\106\001\255\255\108\001\000\001\
\255\255\255\255\112\001\113\001\255\255\006\001\007\001\008\001\
\009\001\010\001\255\255\012\001\013\001\123\001\255\255\255\255\
\255\255\255\255\038\001\039\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\038\001\039\001\059\001\
\060\001\061\001\255\255\255\255\064\001\065\001\255\255\255\255\
\068\001\069\001\255\255\255\255\255\255\073\001\074\001\255\255\
\076\001\255\255\059\001\060\001\061\001\255\255\255\255\064\001\
\065\001\255\255\255\255\068\001\069\001\255\255\000\001\255\255\
\073\001\074\001\255\255\076\001\006\001\007\001\008\001\009\001\
\010\001\255\255\012\001\013\001\255\255\105\001\106\001\255\255\
\108\001\000\001\255\255\255\255\112\001\113\001\255\255\006\001\
\007\001\008\001\009\001\010\001\255\255\012\001\013\001\123\001\
\105\001\106\001\255\255\108\001\038\001\039\001\255\255\112\001\
\113\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\123\001\255\255\255\255\255\255\255\255\038\001\
\039\001\059\001\060\001\061\001\255\255\255\255\064\001\065\001\
\255\255\255\255\068\001\069\001\255\255\255\255\255\255\073\001\
\074\001\255\255\076\001\255\255\059\001\060\001\061\001\255\255\
\255\255\064\001\065\001\255\255\255\255\068\001\069\001\255\255\
\000\001\255\255\073\001\074\001\255\255\076\001\006\001\007\001\
\008\001\009\001\010\001\255\255\012\001\013\001\255\255\105\001\
\106\001\255\255\108\001\255\255\255\255\255\255\112\001\113\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\123\001\105\001\106\001\255\255\108\001\038\001\039\001\
\255\255\112\001\113\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\123\001\255\255\255\255\255\255\
\255\255\255\255\255\255\059\001\060\001\061\001\255\255\255\255\
\064\001\065\001\000\001\255\255\068\001\069\001\255\255\005\001\
\255\255\073\001\074\001\255\255\076\001\011\001\255\255\255\255\
\014\001\015\001\016\001\017\001\018\001\019\001\020\001\255\255\
\022\001\023\001\024\001\025\001\026\001\027\001\028\001\029\001\
\030\001\031\001\032\001\033\001\034\001\035\001\036\001\037\001\
\255\255\105\001\106\001\255\255\108\001\255\255\255\255\255\255\
\112\001\113\001\255\255\065\001\066\001\067\001\255\255\069\001\
\070\001\255\255\255\255\123\001\255\255\075\001\255\255\255\255\
\255\255\255\255\080\001\081\001\082\001\083\001\255\255\085\001\
\066\001\255\255\255\255\069\001\070\001\255\255\255\255\255\255\
\255\255\075\001\255\255\255\255\082\001\255\255\080\001\081\001\
\082\001\083\001\255\255\085\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\101\001\
\102\001\119\001\104\001\255\255\255\255\255\255\255\255\255\255\
\255\255\001\001\255\255\255\255\114\001\005\001\116\001\117\001\
\118\001\255\255\255\255\011\001\122\001\119\001\014\001\015\001\
\016\001\017\001\018\001\019\001\020\001\255\255\022\001\023\001\
\024\001\025\001\026\001\027\001\028\001\029\001\030\001\031\001\
\032\001\033\001\034\001\035\001\036\001\037\001\255\255\255\255\
\040\001\041\001\042\001\043\001\044\001\045\001\046\001\047\001\
\048\001\049\001\050\001\051\001\052\001\053\001\054\001\055\001\
\056\001\057\001\058\001\059\001\060\001\061\001\062\001\063\001\
\255\255\065\001\066\001\067\001\255\255\069\001\070\001\071\001\
\072\001\073\001\074\001\075\001\076\001\077\001\078\001\079\001\
\080\001\081\001\082\001\083\001\084\001\085\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\101\001\102\001\255\255\
\104\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\114\001\255\255\116\001\255\255\255\255\119\001\
\001\001\002\001\122\001\255\255\005\001\006\001\255\255\255\255\
\255\255\255\255\011\001\255\255\255\255\014\001\015\001\016\001\
\017\001\018\001\019\001\020\001\255\255\022\001\023\001\024\001\
\025\001\026\001\027\001\028\001\029\001\030\001\031\001\032\001\
\033\001\034\001\035\001\036\001\037\001\001\001\255\255\255\255\
\255\255\005\001\255\255\255\255\255\255\255\255\255\255\011\001\
\255\255\255\255\014\001\015\001\016\001\017\001\018\001\019\001\
\020\001\255\255\022\001\023\001\024\001\025\001\026\001\027\001\
\028\001\029\001\030\001\031\001\032\001\033\001\034\001\035\001\
\036\001\037\001\255\255\255\255\255\255\053\001\054\001\055\001\
\056\001\057\001\058\001\059\001\060\001\255\255\255\255\255\255\
\255\255\065\001\066\001\067\001\255\255\069\001\070\001\071\001\
\072\001\255\255\255\255\075\001\101\001\102\001\103\001\104\001\
\080\001\081\001\082\001\083\001\255\255\085\001\255\255\255\255\
\255\255\114\001\078\001\116\001\117\001\118\001\255\255\120\001\
\121\001\122\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\101\001\102\001\255\255\104\001\255\255\255\255\119\001\
\255\255\255\255\255\255\255\255\255\255\255\255\114\001\255\255\
\116\001\005\001\006\001\255\255\255\255\255\255\122\001\011\001\
\255\255\255\255\014\001\015\001\016\001\017\001\018\001\019\001\
\020\001\255\255\022\001\023\001\024\001\025\001\026\001\027\001\
\028\001\029\001\030\001\031\001\032\001\033\001\034\001\035\001\
\036\001\037\001\255\255\255\255\053\001\054\001\055\001\056\001\
\057\001\058\001\255\255\255\255\255\255\255\255\255\255\255\255\
\065\001\066\001\067\001\255\255\069\001\070\001\071\001\072\001\
\255\255\061\001\075\001\255\255\255\255\255\255\255\255\080\001\
\081\001\082\001\083\001\255\255\085\001\255\255\255\255\255\255\
\076\001\255\255\255\255\255\255\255\255\081\001\082\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\101\001\102\001\255\255\104\001\255\255\119\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\114\001\255\255\
\116\001\255\255\255\255\255\255\255\255\255\255\122\001\255\255\
\124\001\005\001\006\001\007\001\008\001\009\001\010\001\011\001\
\012\001\013\001\014\001\015\001\016\001\017\001\018\001\019\001\
\020\001\255\255\022\001\023\001\024\001\025\001\026\001\027\001\
\028\001\029\001\030\001\031\001\032\001\033\001\034\001\035\001\
\036\001\037\001\038\001\039\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\059\001\
\060\001\061\001\255\255\255\255\064\001\065\001\255\255\255\255\
\068\001\069\001\255\255\255\255\255\255\073\001\074\001\255\255\
\076\001\255\255\006\001\007\001\008\001\009\001\010\001\011\001\
\012\001\013\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\101\001\102\001\255\255\104\001\105\001\106\001\255\255\
\108\001\255\255\038\001\039\001\112\001\113\001\114\001\255\255\
\116\001\255\255\255\255\255\255\255\255\255\255\122\001\123\001\
\052\001\255\255\255\255\255\255\255\255\255\255\255\255\059\001\
\060\001\061\001\255\255\255\255\064\001\065\001\255\255\255\255\
\068\001\069\001\255\255\255\255\255\255\073\001\074\001\255\255\
\076\001\255\255\078\001\079\001\255\255\255\255\066\001\255\255\
\255\255\069\001\070\001\255\255\255\255\255\255\255\255\075\001\
\255\255\255\255\255\255\255\255\080\001\081\001\082\001\083\001\
\255\255\085\001\255\255\255\255\255\255\105\001\106\001\255\255\
\108\001\255\255\255\255\255\255\112\001\113\001\255\255\255\255\
\255\255\255\255\255\255\005\001\255\255\255\255\255\255\123\001\
\124\001\011\001\012\001\255\255\014\001\015\001\016\001\017\001\
\018\001\019\001\020\001\119\001\022\001\023\001\024\001\025\001\
\026\001\027\001\028\001\029\001\030\001\031\001\032\001\033\001\
\034\001\035\001\036\001\037\001\005\001\255\255\255\255\255\255\
\255\255\255\255\011\001\255\255\255\255\014\001\015\001\016\001\
\017\001\018\001\019\001\020\001\255\255\022\001\023\001\024\001\
\025\001\026\001\027\001\028\001\029\001\030\001\031\001\032\001\
\033\001\034\001\035\001\036\001\037\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\101\001\102\001\255\255\104\001\105\001\
\106\001\255\255\255\255\076\001\255\255\255\255\255\255\255\255\
\114\001\255\255\116\001\084\001\255\255\255\255\255\255\255\255\
\122\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\101\001\102\001\255\255\104\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\114\001\005\001\116\001\255\255\255\255\255\255\255\255\
\011\001\122\001\255\255\014\001\015\001\016\001\017\001\018\001\
\019\001\020\001\255\255\022\001\023\001\024\001\025\001\026\001\
\027\001\028\001\029\001\030\001\031\001\032\001\033\001\034\001\
\035\001\036\001\037\001\005\001\006\001\255\255\255\255\255\255\
\255\255\011\001\255\255\255\255\014\001\015\001\016\001\017\001\
\018\001\019\001\020\001\255\255\022\001\023\001\024\001\025\001\
\026\001\027\001\028\001\029\001\030\001\031\001\032\001\033\001\
\034\001\035\001\036\001\037\001\255\255\255\255\255\255\255\255\
\075\001\076\001\255\255\053\001\054\001\055\001\056\001\057\001\
\058\001\255\255\255\255\255\255\255\255\255\255\255\255\065\001\
\066\001\067\001\255\255\069\001\070\001\071\001\072\001\255\255\
\255\255\075\001\101\001\102\001\255\255\104\001\080\001\081\001\
\082\001\083\001\255\255\085\001\255\255\255\255\255\255\114\001\
\255\255\116\001\255\255\255\255\255\255\255\255\255\255\122\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\101\001\102\001\255\255\104\001\255\255\
\255\255\255\255\255\255\255\255\255\255\119\001\255\255\255\255\
\114\001\005\001\116\001\255\255\255\255\255\255\255\255\011\001\
\122\001\255\255\014\001\015\001\016\001\017\001\018\001\019\001\
\020\001\255\255\022\001\023\001\024\001\025\001\026\001\027\001\
\028\001\029\001\030\001\031\001\032\001\033\001\034\001\035\001\
\036\001\037\001\005\001\255\255\255\255\255\255\255\255\255\255\
\011\001\255\255\255\255\014\001\015\001\016\001\017\001\018\001\
\019\001\020\001\255\255\022\001\023\001\024\001\025\001\026\001\
\027\001\028\001\029\001\030\001\031\001\032\001\033\001\034\001\
\035\001\036\001\037\001\255\255\255\255\255\255\255\255\255\255\
\076\001\255\255\053\001\054\001\055\001\056\001\057\001\058\001\
\255\255\255\255\255\255\255\255\255\255\255\255\065\001\066\001\
\067\001\255\255\069\001\070\001\071\001\072\001\255\255\255\255\
\075\001\101\001\102\001\255\255\104\001\080\001\081\001\082\001\
\083\001\255\255\085\001\255\255\255\255\255\255\114\001\255\255\
\116\001\084\001\255\255\255\255\255\255\255\255\122\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\101\001\102\001\255\255\104\001\255\255\255\255\
\255\255\255\255\255\255\255\255\119\001\255\255\255\255\114\001\
\005\001\116\001\255\255\255\255\255\255\255\255\011\001\122\001\
\255\255\014\001\015\001\016\001\017\001\018\001\019\001\020\001\
\255\255\022\001\023\001\024\001\025\001\026\001\027\001\028\001\
\029\001\030\001\031\001\032\001\033\001\034\001\035\001\036\001\
\037\001\005\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\014\001\015\001\016\001\017\001\018\001\019\001\
\020\001\255\255\022\001\023\001\024\001\025\001\026\001\027\001\
\028\001\029\001\030\001\031\001\032\001\033\001\034\001\035\001\
\036\001\037\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\101\001\102\001\255\255\104\001\255\255\006\001\007\001\008\001\
\009\001\010\001\255\255\012\001\013\001\114\001\255\255\116\001\
\255\255\255\255\255\255\255\255\255\255\122\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\101\001\102\001\255\255\104\001\038\001\039\001\040\001\
\255\255\255\255\255\255\255\255\255\255\255\255\114\001\255\255\
\116\001\255\255\255\255\255\255\255\255\255\255\122\001\255\255\
\255\255\255\255\059\001\060\001\061\001\255\255\255\255\064\001\
\065\001\255\255\255\255\068\001\069\001\255\255\255\255\255\255\
\073\001\074\001\255\255\076\001\255\255\078\001\255\255\255\255\
\255\255\006\001\007\001\008\001\009\001\010\001\255\255\012\001\
\013\001\255\255\255\255\255\255\255\255\255\255\255\255\005\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\105\001\106\001\255\255\108\001\255\255\255\255\255\255\112\001\
\113\001\038\001\039\001\255\255\255\255\255\255\255\255\255\255\
\030\001\255\255\123\001\033\001\034\001\255\255\255\255\037\001\
\255\255\255\255\255\255\255\255\255\255\255\255\059\001\060\001\
\061\001\255\255\255\255\064\001\065\001\255\255\255\255\068\001\
\069\001\255\255\255\255\255\255\073\001\074\001\255\255\076\001\
\255\255\078\001\255\255\255\255\255\255\006\001\007\001\008\001\
\009\001\010\001\255\255\012\001\013\001\255\255\076\001\255\255\
\255\255\079\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\105\001\106\001\255\255\108\001\
\255\255\255\255\255\255\112\001\113\001\038\001\039\001\101\001\
\255\255\103\001\255\255\255\255\255\255\255\255\123\001\255\255\
\255\255\255\255\255\255\255\255\114\001\255\255\116\001\255\255\
\255\255\255\255\059\001\060\001\061\001\255\255\255\255\064\001\
\065\001\255\255\255\255\068\001\069\001\255\255\255\255\255\255\
\073\001\074\001\255\255\076\001\255\255\078\001\255\255\255\255\
\255\255\006\001\007\001\008\001\009\001\010\001\255\255\012\001\
\013\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\105\001\106\001\255\255\108\001\255\255\255\255\255\255\112\001\
\113\001\038\001\039\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\123\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\059\001\060\001\
\061\001\255\255\255\255\064\001\065\001\255\255\255\255\068\001\
\069\001\255\255\255\255\255\255\073\001\074\001\255\255\076\001\
\255\255\078\001\255\255\255\255\255\255\006\001\007\001\008\001\
\009\001\010\001\255\255\012\001\013\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\105\001\106\001\255\255\108\001\
\255\255\255\255\255\255\112\001\113\001\038\001\039\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\123\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\059\001\060\001\061\001\255\255\255\255\064\001\
\065\001\255\255\255\255\068\001\069\001\255\255\255\255\255\255\
\073\001\074\001\255\255\076\001\006\001\007\001\008\001\009\001\
\010\001\255\255\012\001\013\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\006\001\
\007\001\008\001\009\001\010\001\255\255\012\001\013\001\255\255\
\105\001\106\001\255\255\108\001\038\001\039\001\255\255\112\001\
\113\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\123\001\255\255\255\255\255\255\255\255\038\001\
\039\001\059\001\060\001\061\001\255\255\255\255\064\001\065\001\
\255\255\255\255\068\001\069\001\255\255\255\255\255\255\073\001\
\074\001\255\255\076\001\255\255\059\001\060\001\061\001\255\255\
\255\255\064\001\065\001\255\255\255\255\068\001\069\001\255\255\
\255\255\255\255\073\001\074\001\255\255\076\001\006\001\007\001\
\008\001\009\001\010\001\255\255\012\001\013\001\255\255\105\001\
\106\001\255\255\108\001\255\255\255\255\255\255\112\001\113\001\
\255\255\006\001\007\001\008\001\009\001\010\001\255\255\012\001\
\013\001\123\001\105\001\106\001\255\255\108\001\038\001\039\001\
\255\255\112\001\113\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\123\001\255\255\255\255\255\255\
\255\255\038\001\039\001\059\001\060\001\061\001\255\255\255\255\
\064\001\065\001\255\255\255\255\068\001\069\001\255\255\255\255\
\255\255\073\001\074\001\255\255\076\001\255\255\059\001\060\001\
\061\001\255\255\255\255\064\001\065\001\255\255\255\255\068\001\
\069\001\255\255\255\255\255\255\073\001\074\001\255\255\076\001\
\006\001\007\001\008\001\009\001\010\001\255\255\012\001\013\001\
\255\255\105\001\106\001\255\255\108\001\255\255\255\255\255\255\
\112\001\113\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\123\001\105\001\106\001\255\255\108\001\
\038\001\039\001\255\255\112\001\113\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\123\001\255\255\
\255\255\255\255\255\255\255\255\255\255\059\001\060\001\061\001\
\255\255\255\255\064\001\065\001\255\255\255\255\068\001\069\001\
\255\255\255\255\255\255\073\001\074\001\255\255\076\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\005\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\105\001\106\001\255\255\108\001\255\255\
\255\255\255\255\112\001\113\001\030\001\255\255\255\255\033\001\
\034\001\255\255\255\255\037\001\255\255\123\001\040\001\041\001\
\042\001\043\001\044\001\045\001\046\001\047\001\048\001\049\001\
\050\001\051\001\052\001\053\001\054\001\055\001\056\001\057\001\
\058\001\059\001\060\001\061\001\062\001\063\001\255\255\065\001\
\066\001\067\001\255\255\069\001\070\001\071\001\072\001\073\001\
\074\001\075\001\076\001\077\001\255\255\079\001\080\001\081\001\
\082\001\083\001\084\001\085\001\255\255\255\255\255\255\255\255\
\255\255\255\255\005\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\101\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\114\001\255\255\116\001\030\001\255\255\119\001\033\001\034\001\
\255\255\255\255\037\001\255\255\255\255\040\001\041\001\042\001\
\043\001\044\001\045\001\046\001\047\001\048\001\049\001\050\001\
\255\255\255\255\053\001\054\001\055\001\056\001\057\001\058\001\
\059\001\060\001\061\001\062\001\063\001\255\255\065\001\066\001\
\067\001\255\255\069\001\070\001\071\001\072\001\255\255\255\255\
\075\001\255\255\077\001\255\255\255\255\080\001\081\001\082\001\
\083\001\084\001\085\001\255\255\255\255\255\255\255\255\255\255\
\255\255\005\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\101\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\114\001\
\255\255\116\001\030\001\255\255\119\001\033\001\034\001\255\255\
\255\255\037\001\255\255\255\255\040\001\041\001\042\001\043\001\
\044\001\045\001\046\001\047\001\048\001\049\001\050\001\255\255\
\255\255\053\001\054\001\055\001\056\001\057\001\058\001\059\001\
\060\001\061\001\062\001\063\001\255\255\065\001\066\001\067\001\
\255\255\069\001\070\001\071\001\072\001\255\255\255\255\075\001\
\255\255\077\001\255\255\255\255\080\001\081\001\082\001\083\001\
\084\001\085\001\255\255\255\255\255\255\255\255\255\255\255\255\
\005\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\101\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\114\001\255\255\
\116\001\030\001\255\255\119\001\033\001\034\001\255\255\255\255\
\037\001\255\255\255\255\040\001\041\001\042\001\043\001\044\001\
\045\001\046\001\047\001\048\001\049\001\050\001\255\255\255\255\
\053\001\054\001\055\001\056\001\057\001\058\001\059\001\060\001\
\061\001\062\001\063\001\255\255\065\001\066\001\067\001\255\255\
\069\001\070\001\071\001\072\001\255\255\005\001\075\001\255\255\
\077\001\255\255\255\255\080\001\081\001\082\001\083\001\084\001\
\085\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\030\001\255\255\
\101\001\033\001\034\001\255\255\255\255\037\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\114\001\255\255\116\001\
\255\255\255\255\119\001\255\255\255\255\053\001\054\001\055\001\
\056\001\057\001\058\001\059\001\060\001\061\001\062\001\063\001\
\255\255\065\001\066\001\067\001\255\255\069\001\070\001\071\001\
\072\001\255\255\005\001\075\001\255\255\077\001\255\255\255\255\
\080\001\081\001\082\001\083\001\084\001\085\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\030\001\255\255\101\001\033\001\034\001\
\255\255\255\255\037\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\114\001\255\255\116\001\255\255\255\255\255\255\
\255\255\255\255\053\001\054\001\055\001\056\001\057\001\058\001\
\059\001\060\001\255\255\255\255\255\255\255\255\065\001\066\001\
\067\001\255\255\069\001\070\001\071\001\072\001\255\255\005\001\
\075\001\255\255\077\001\255\255\255\255\080\001\081\001\082\001\
\083\001\084\001\085\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\030\001\255\255\101\001\033\001\034\001\255\255\255\255\037\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\114\001\
\255\255\116\001\255\255\255\255\255\255\255\255\255\255\053\001\
\054\001\055\001\056\001\057\001\058\001\059\001\060\001\255\255\
\255\255\255\255\255\255\065\001\066\001\067\001\255\255\069\001\
\070\001\071\001\072\001\255\255\005\001\075\001\255\255\077\001\
\255\255\255\255\080\001\081\001\082\001\083\001\084\001\085\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\030\001\255\255\101\001\
\033\001\034\001\255\255\255\255\037\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\114\001\255\255\116\001\255\255\
\255\255\255\255\255\255\255\255\053\001\054\001\055\001\056\001\
\057\001\058\001\059\001\060\001\255\255\255\255\255\255\255\255\
\065\001\066\001\067\001\255\255\069\001\070\001\071\001\072\001\
\255\255\005\001\075\001\255\255\077\001\255\255\255\255\080\001\
\081\001\082\001\083\001\084\001\085\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\030\001\255\255\101\001\033\001\034\001\255\255\
\255\255\037\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\114\001\255\255\116\001\255\255\255\255\255\255\255\255\
\255\255\053\001\054\001\055\001\056\001\057\001\058\001\255\255\
\255\255\255\255\255\255\255\255\255\255\065\001\066\001\067\001\
\255\255\069\001\070\001\071\001\072\001\255\255\005\001\075\001\
\255\255\077\001\255\255\255\255\080\001\081\001\082\001\083\001\
\084\001\085\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\030\001\
\255\255\101\001\033\001\034\001\255\255\255\255\037\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\114\001\255\255\
\116\001\255\255\255\255\255\255\255\255\255\255\053\001\054\001\
\055\001\056\001\057\001\058\001\255\255\255\255\255\255\255\255\
\255\255\255\255\065\001\066\001\067\001\255\255\069\001\070\001\
\071\001\072\001\255\255\005\001\075\001\255\255\077\001\255\255\
\255\255\080\001\081\001\082\001\083\001\084\001\085\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\030\001\255\255\101\001\033\001\
\034\001\255\255\255\255\037\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\114\001\255\255\116\001\255\255\255\255\
\255\255\255\255\255\255\053\001\054\001\055\001\056\001\057\001\
\058\001\255\255\255\255\255\255\255\255\255\255\255\255\065\001\
\066\001\067\001\255\255\069\001\070\001\071\001\072\001\255\255\
\005\001\075\001\255\255\077\001\255\255\255\255\080\001\081\001\
\082\001\083\001\084\001\085\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\030\001\255\255\101\001\033\001\034\001\255\255\255\255\
\037\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\114\001\255\255\116\001\255\255\255\255\255\255\255\255\255\255\
\053\001\054\001\055\001\056\001\057\001\058\001\255\255\255\255\
\255\255\255\255\255\255\255\255\065\001\066\001\067\001\255\255\
\069\001\070\001\005\001\255\255\255\255\255\255\075\001\255\255\
\077\001\255\255\255\255\080\001\081\001\082\001\083\001\084\001\
\085\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\030\001\255\255\255\255\033\001\034\001\
\101\001\255\255\037\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\114\001\255\255\116\001\
\255\255\255\255\053\001\054\001\055\001\056\001\057\001\058\001\
\255\255\255\255\255\255\255\255\255\255\255\255\065\001\066\001\
\067\001\255\255\069\001\070\001\005\001\255\255\255\255\255\255\
\075\001\255\255\077\001\255\255\255\255\080\001\081\001\082\001\
\083\001\084\001\085\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\030\001\255\255\255\255\
\033\001\034\001\101\001\255\255\037\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\114\001\
\255\255\116\001\255\255\255\255\053\001\054\001\055\001\056\001\
\057\001\058\001\255\255\255\255\255\255\255\255\255\255\255\255\
\065\001\066\001\067\001\255\255\069\001\070\001\005\001\255\255\
\255\255\255\255\075\001\255\255\077\001\255\255\255\255\080\001\
\081\001\082\001\083\001\084\001\085\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\030\001\
\255\255\255\255\033\001\034\001\101\001\255\255\037\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\114\001\255\255\116\001\255\255\255\255\053\001\054\001\
\055\001\056\001\057\001\058\001\255\255\255\255\255\255\255\255\
\255\255\255\255\065\001\066\001\067\001\255\255\069\001\070\001\
\005\001\255\255\255\255\255\255\075\001\255\255\077\001\255\255\
\255\255\080\001\081\001\082\001\083\001\084\001\085\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\030\001\255\255\255\255\033\001\034\001\101\001\255\255\
\037\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\114\001\255\255\116\001\255\255\255\255\
\053\001\054\001\055\001\056\001\057\001\058\001\255\255\255\255\
\005\001\255\255\255\255\255\255\065\001\066\001\067\001\255\255\
\069\001\070\001\255\255\255\255\255\255\255\255\075\001\255\255\
\077\001\255\255\255\255\080\001\081\001\082\001\083\001\084\001\
\085\001\030\001\255\255\255\255\033\001\034\001\255\255\255\255\
\037\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\101\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\053\001\054\001\255\255\255\255\255\255\114\001\255\255\116\001\
\005\001\255\255\255\255\255\255\065\001\066\001\067\001\255\255\
\069\001\070\001\255\255\255\255\255\255\255\255\075\001\255\255\
\077\001\255\255\255\255\080\001\081\001\082\001\083\001\084\001\
\085\001\030\001\255\255\255\255\033\001\034\001\255\255\255\255\
\037\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\101\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\053\001\054\001\255\255\255\255\255\255\114\001\255\255\116\001\
\005\001\255\255\255\255\255\255\065\001\066\001\067\001\255\255\
\069\001\070\001\255\255\255\255\255\255\255\255\075\001\255\255\
\077\001\255\255\255\255\080\001\081\001\082\001\083\001\084\001\
\085\001\030\001\255\255\255\255\033\001\034\001\255\255\255\255\
\037\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\101\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\053\001\054\001\255\255\255\255\255\255\114\001\255\255\116\001\
\005\001\255\255\255\255\255\255\065\001\066\001\067\001\255\255\
\069\001\070\001\255\255\255\255\255\255\255\255\075\001\255\255\
\077\001\255\255\255\255\080\001\081\001\082\001\083\001\084\001\
\085\001\030\001\255\255\255\255\033\001\034\001\255\255\255\255\
\037\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\101\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\114\001\255\255\116\001\
\005\001\255\255\255\255\255\255\065\001\066\001\067\001\255\255\
\069\001\070\001\255\255\255\255\255\255\255\255\075\001\255\255\
\077\001\255\255\255\255\080\001\081\001\082\001\083\001\084\001\
\085\001\030\001\255\255\255\255\033\001\034\001\255\255\255\255\
\037\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\101\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\114\001\255\255\116\001\
\005\001\255\255\255\255\255\255\065\001\066\001\067\001\255\255\
\069\001\070\001\255\255\255\255\255\255\255\255\075\001\255\255\
\077\001\255\255\255\255\080\001\081\001\082\001\083\001\084\001\
\085\001\030\001\255\255\255\255\033\001\034\001\255\255\255\255\
\037\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\101\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\114\001\255\255\116\001\
\005\001\255\255\255\255\255\255\255\255\066\001\067\001\255\255\
\069\001\070\001\255\255\255\255\255\255\255\255\075\001\255\255\
\077\001\255\255\255\255\080\001\081\001\082\001\083\001\084\001\
\085\001\030\001\255\255\255\255\033\001\034\001\255\255\255\255\
\037\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\101\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\114\001\255\255\116\001\
\005\001\255\255\255\255\255\255\255\255\066\001\067\001\255\255\
\069\001\070\001\255\255\255\255\255\255\255\255\075\001\255\255\
\077\001\255\255\255\255\080\001\081\001\082\001\083\001\084\001\
\085\001\030\001\255\255\255\255\033\001\034\001\255\255\255\255\
\037\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\101\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\114\001\255\255\116\001\
\005\001\255\255\255\255\255\255\255\255\066\001\255\255\255\255\
\069\001\070\001\255\255\255\255\255\255\255\255\075\001\255\255\
\077\001\255\255\255\255\080\001\081\001\082\001\083\001\084\001\
\085\001\030\001\255\255\255\255\033\001\034\001\255\255\255\255\
\037\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\101\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\114\001\255\255\116\001\
\005\001\255\255\255\255\255\255\255\255\066\001\255\255\255\255\
\069\001\070\001\255\255\255\255\255\255\255\255\075\001\255\255\
\077\001\255\255\255\255\080\001\081\001\082\001\083\001\084\001\
\085\001\030\001\255\255\255\255\033\001\034\001\255\255\255\255\
\037\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\101\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\114\001\255\255\116\001\
\005\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\069\001\070\001\255\255\255\255\255\255\255\255\075\001\255\255\
\077\001\255\255\255\255\080\001\081\001\082\001\083\001\084\001\
\085\001\030\001\255\255\255\255\033\001\034\001\255\255\255\255\
\037\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\101\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\114\001\255\255\116\001\
\005\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\069\001\070\001\255\255\255\255\255\255\255\255\075\001\255\255\
\077\001\255\255\255\255\080\001\081\001\082\001\083\001\084\001\
\085\001\030\001\255\255\255\255\033\001\034\001\255\255\255\255\
\037\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\101\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\114\001\255\255\116\001\
\005\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\070\001\255\255\255\255\255\255\255\255\075\001\255\255\
\077\001\255\255\255\255\080\001\081\001\082\001\083\001\084\001\
\085\001\030\001\255\255\255\255\033\001\034\001\000\001\255\255\
\037\001\255\255\255\255\255\255\006\001\255\255\255\255\009\001\
\101\001\011\001\012\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\114\001\255\255\116\001\
\255\255\255\255\255\255\255\255\030\001\255\255\255\255\033\001\
\255\255\070\001\255\255\255\255\038\001\039\001\075\001\255\255\
\077\001\255\255\255\255\080\001\081\001\082\001\083\001\084\001\
\085\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\059\001\060\001\061\001\255\255\255\255\064\001\065\001\
\101\001\255\255\068\001\255\255\255\255\000\001\255\255\255\255\
\255\255\075\001\076\001\006\001\255\255\114\001\009\001\116\001\
\011\001\012\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\092\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\030\001\255\255\255\255\033\001\105\001\
\106\001\000\001\255\255\038\001\039\001\255\255\255\255\006\001\
\255\255\255\255\009\001\255\255\011\001\012\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\059\001\060\001\061\001\255\255\255\255\064\001\065\001\030\001\
\255\255\068\001\033\001\255\255\255\255\255\255\255\255\038\001\
\039\001\076\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\092\001\255\255\255\255\059\001\060\001\061\001\255\255\
\255\255\064\001\065\001\255\255\255\255\068\001\105\001\106\001\
\000\001\255\255\255\255\255\255\255\255\076\001\006\001\255\255\
\255\255\009\001\255\255\011\001\012\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\092\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\030\001\255\255\
\255\255\033\001\105\001\106\001\255\255\255\255\038\001\039\001\
\255\255\255\255\006\001\255\255\255\255\009\001\255\255\011\001\
\012\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\059\001\060\001\061\001\255\255\255\255\
\064\001\065\001\030\001\255\255\068\001\033\001\255\255\255\255\
\255\255\255\255\038\001\039\001\076\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\092\001\255\255\255\255\059\001\
\060\001\061\001\255\255\255\255\064\001\065\001\255\255\255\255\
\068\001\105\001\106\001\255\255\255\255\255\255\255\255\255\255\
\076\001\255\255\255\255\255\255\255\255\053\001\054\001\055\001\
\056\001\057\001\058\001\255\255\255\255\255\255\255\255\255\255\
\092\001\065\001\066\001\067\001\255\255\069\001\070\001\255\255\
\255\255\255\255\255\255\075\001\255\255\105\001\106\001\255\255\
\080\001\081\001\082\001\083\001\255\255\085\001\053\001\054\001\
\055\001\056\001\057\001\058\001\255\255\255\255\255\255\255\255\
\255\255\255\255\065\001\066\001\067\001\255\255\069\001\070\001\
\255\255\255\255\255\255\255\255\075\001\255\255\255\255\255\255\
\255\255\080\001\081\001\082\001\083\001\255\255\085\001\119\001\
\255\255\053\001\054\001\055\001\056\001\057\001\058\001\255\255\
\255\255\255\255\255\255\255\255\255\255\065\001\066\001\067\001\
\255\255\069\001\070\001\255\255\255\255\255\255\255\255\075\001\
\255\255\255\255\255\255\255\255\080\001\081\001\082\001\083\001\
\119\001\085\001\053\001\054\001\055\001\056\001\057\001\058\001\
\255\255\255\255\255\255\255\255\255\255\255\255\065\001\066\001\
\067\001\255\255\069\001\070\001\255\255\255\255\255\255\255\255\
\075\001\255\255\255\255\255\255\255\255\080\001\081\001\082\001\
\083\001\255\255\085\001\119\001\255\255\053\001\054\001\055\001\
\056\001\057\001\058\001\255\255\255\255\255\255\255\255\255\255\
\255\255\065\001\066\001\067\001\255\255\069\001\070\001\255\255\
\255\255\255\255\255\255\075\001\053\001\054\001\255\255\255\255\
\080\001\081\001\082\001\083\001\119\001\085\001\255\255\255\255\
\065\001\066\001\067\001\255\255\069\001\070\001\255\255\255\255\
\255\255\255\255\075\001\053\001\054\001\255\255\255\255\080\001\
\081\001\082\001\083\001\255\255\085\001\255\255\255\255\065\001\
\066\001\067\001\255\255\069\001\070\001\255\255\255\255\119\001\
\255\255\075\001\053\001\054\001\255\255\255\255\080\001\081\001\
\082\001\083\001\255\255\085\001\255\255\255\255\065\001\066\001\
\067\001\255\255\069\001\070\001\255\255\255\255\119\001\255\255\
\075\001\255\255\255\255\255\255\255\255\080\001\081\001\082\001\
\083\001\255\255\085\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\119\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\119\001\040\001\041\001\042\001\
\043\001\044\001\045\001\046\001\047\001\048\001\049\001\050\001\
\051\001\052\001\053\001\054\001\055\001\056\001\057\001\058\001\
\059\001\060\001\061\001\062\001\063\001\255\255\065\001\066\001\
\067\001\255\255\069\001\070\001\071\001\072\001\073\001\074\001\
\255\255\076\001\077\001\255\255\079\001\255\255\081\001\082\001\
\083\001\255\255\085\001"

let yynames_const = "\
  EOF\000\
  EQ\000\
  PLUS_EQ\000\
  MINUS_EQ\000\
  STAR_EQ\000\
  SLASH_EQ\000\
  PERCENT_EQ\000\
  AND_EQ\000\
  PIPE_EQ\000\
  CIRC_EQ\000\
  INF_INF_EQ\000\
  SUP_SUP_EQ\000\
  ARROW\000\
  DOT\000\
  EQ_EQ\000\
  EXCLAM_EQ\000\
  INF\000\
  SUP\000\
  INF_EQ\000\
  SUP_EQ\000\
  SLASH\000\
  PERCENT\000\
  PIPE\000\
  CIRC\000\
  PIPE_PIPE\000\
  INF_INF\000\
  SUP_SUP\000\
  RPAREN\000\
  LBRACKET\000\
  RBRACKET\000\
  COLON\000\
  COMMA\000\
  ELLIPSIS\000\
  QUEST\000\
  ELSE\000\
  LABEL__\000\
  BUILTIN_VA_LIST\000\
  BLOCKATTRIBUTE\000\
  PRAGMA_EOL\000\
  AT_NAME\000\
  LGHOST\000\
  RGHOST\000\
  "

let yynames_block = "\
  SPEC\000\
  DECL\000\
  CODE_ANNOT\000\
  LOOP_ANNOT\000\
  ATTRIBUTE_ANNOT\000\
  IDENT\000\
  CST_CHAR\000\
  CST_WCHAR\000\
  CST_INT\000\
  CST_FLOAT\000\
  NAMED_TYPE\000\
  CST_STRING\000\
  CST_WSTRING\000\
  BOOL\000\
  CHAR\000\
  INT\000\
  DOUBLE\000\
  FLOAT\000\
  VOID\000\
  INT64\000\
  INT32\000\
  ENUM\000\
  STRUCT\000\
  TYPEDEF\000\
  UNION\000\
  SIGNED\000\
  UNSIGNED\000\
  LONG\000\
  SHORT\000\
  VOLATILE\000\
  EXTERN\000\
  STATIC\000\
  CONST\000\
  RESTRICT\000\
  AUTO\000\
  REGISTER\000\
  THREAD\000\
  SIZEOF\000\
  ALIGNOF\000\
  PLUS\000\
  MINUS\000\
  STAR\000\
  TILDE\000\
  AND\000\
  EXCLAM\000\
  AND_AND\000\
  PLUS_PLUS\000\
  MINUS_MINUS\000\
  LPAREN\000\
  RBRACE\000\
  LBRACE\000\
  SEMICOLON\000\
  BREAK\000\
  CONTINUE\000\
  GOTO\000\
  RETURN\000\
  SWITCH\000\
  CASE\000\
  DEFAULT\000\
  WHILE\000\
  DO\000\
  FOR\000\
  IF\000\
  TRY\000\
  EXCEPT\000\
  FINALLY\000\
  ATTRIBUTE\000\
  INLINE\000\
  ASM\000\
  TYPEOF\000\
  FUNCTION__\000\
  PRETTY_FUNCTION__\000\
  BUILTIN_VA_ARG\000\
  ATTRIBUTE_USED\000\
  BUILTIN_TYPES_COMPAT\000\
  BUILTIN_OFFSETOF\000\
  DECLSPEC\000\
  MSASM\000\
  MSATTR\000\
  PRAGMA_LINE\000\
  PRAGMA\000\
  AT_TRANSFORM\000\
  AT_TRANSFORMEXPR\000\
  AT_SPECIFIER\000\
  AT_EXPR\000\
  "

let yyact = [|
  (fun _ -> failwith "parser")
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : (bool*Cabs.definition) list) in
    Obj.repr(
# 421 "cil/src/frontc/cparser.mly"
              (_1)
# 3059 "cil/src/frontc/cparser.ml"
               : (bool*Cabs.definition) list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : (bool*Cabs.definition) list) in
    Obj.repr(
# 423 "cil/src/frontc/cparser.mly"
                 (_1)
# 3066 "cil/src/frontc/cparser.ml"
               : (bool*Cabs.definition) list))
; (fun __caml_parser_env ->
    Obj.repr(
# 426 "cil/src/frontc/cparser.mly"
                                        ( [] )
# 3072 "cil/src/frontc/cparser.ml"
               : (bool*Cabs.definition) list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.definition) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : (bool*Cabs.definition) list) in
    Obj.repr(
# 427 "cil/src/frontc/cparser.mly"
                                        ( (false,_1) :: _2 )
# 3080 "cil/src/frontc/cparser.ml"
               : (bool*Cabs.definition) list))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'ghost_globals) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : (bool*Cabs.definition) list) in
    Obj.repr(
# 428 "cil/src/frontc/cparser.mly"
                                        ( _2 @ _3 )
# 3088 "cil/src/frontc/cparser.ml"
               : (bool*Cabs.definition) list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : (bool*Cabs.definition) list) in
    Obj.repr(
# 429 "cil/src/frontc/cparser.mly"
                                        ( _2 )
# 3096 "cil/src/frontc/cparser.ml"
               : (bool*Cabs.definition) list))
; (fun __caml_parser_env ->
    Obj.repr(
# 433 "cil/src/frontc/cparser.mly"
                               ( currentLoc () )
# 3102 "cil/src/frontc/cparser.ml"
               : Cabs.cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.definition) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'ghost_globals) in
    Obj.repr(
# 438 "cil/src/frontc/cparser.mly"
                                                      ( (true,_1)::_2 )
# 3110 "cil/src/frontc/cparser.ml"
               : 'ghost_globals))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.definition) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'ghost_globals) in
    Obj.repr(
# 439 "cil/src/frontc/cparser.mly"
                                                      ( (true,_1)::_2 )
# 3118 "cil/src/frontc/cparser.ml"
               : 'ghost_globals))
; (fun __caml_parser_env ->
    Obj.repr(
# 440 "cil/src/frontc/cparser.mly"
                                                      ( [] )
# 3124 "cil/src/frontc/cparser.ml"
               : 'ghost_globals))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : (Cabs.cabsloc * Logic_ptree.decl) list) in
    Obj.repr(
# 445 "cil/src/frontc/cparser.mly"
                                        ( GLOBANNOT _1 )
# 3131 "cil/src/frontc/cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.definition) in
    Obj.repr(
# 446 "cil/src/frontc/cparser.mly"
                                        ( _1 )
# 3138 "cil/src/frontc/cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.definition) in
    Obj.repr(
# 447 "cil/src/frontc/cparser.mly"
                                        ( _1 )
# 3145 "cil/src/frontc/cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : string * cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.definition) in
    Obj.repr(
# 451 "cil/src/frontc/cparser.mly"
                                        ( LINKAGE (fst _2, (*handleLoc*) (snd _2), [ _3 ]) )
# 3154 "cil/src/frontc/cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : string * cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : (bool*Cabs.definition) list) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 453 "cil/src/frontc/cparser.mly"
      ( LINKAGE (fst _2, (*handleLoc*) (snd _2),
                 List.map
                   (fun (x,y) ->
                      if x then parse_error "invalid ghost in extern linkage specification"
		      else y)
                   _4)  )
# 3170 "cil/src/frontc/cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : string * cabsloc) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 460 "cil/src/frontc/cparser.mly"
                                        ( GLOBASM (fst _3, (*handleLoc*) _1) )
# 3180 "cil/src/frontc/cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'pragma) in
    Obj.repr(
# 461 "cil/src/frontc/cparser.mly"
                                        ( _1 )
# 3187 "cil/src/frontc/cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : string * Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : string list) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'old_pardef_list) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 466 "cil/src/frontc/cparser.mly"
                           ( (* Convert pardecl to new style *)
                             let pardecl, isva = doOldParDecl _3 _5 in
                             (* Make the function declarator *)
                             doDeclaration None ((*handleLoc*) (snd _1)) []
                               [((fst _1, PROTO(JUSTBASE, pardecl,isva), [], snd _1),
                                 NO_INIT)]
                            )
# 3204 "cil/src/frontc/cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : string * Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 475 "cil/src/frontc/cparser.mly"
                           ( (* Make the function declarator *)
                             doDeclaration None ((*handleLoc*)(snd _1)) []
                               [((fst _1, PROTO(JUSTBASE,[],false), [], (*CEA*) cabslu),
                                 NO_INIT)]
                            )
# 3217 "cil/src/frontc/cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 7 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 6 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 5 : Cabs.definition) in
    let _4 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _5 = (Parsing.peek_val __caml_parser_env 3 : string * Cabs.cabsloc) in
    let _6 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _7 = (Parsing.peek_val __caml_parser_env 1 : (bool*Cabs.definition) list) in
    let _8 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 481 "cil/src/frontc/cparser.mly"
                                                                        (
    checkConnective(fst _5);
    TRANSFORMER(_3,
                  List.map
                    (fun (x,y) ->
                       if x then parse_error "invalid ghost transformer"
                       else y)
                    _7,
                _1)
  )
# 3240 "cil/src/frontc/cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 7 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 6 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 5 : Cabs.expression * cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _5 = (Parsing.peek_val __caml_parser_env 3 : string * Cabs.cabsloc) in
    let _6 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _7 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression * cabsloc) in
    let _8 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 492 "cil/src/frontc/cparser.mly"
                                                                                   (
    checkConnective(fst _5);
    EXPRTRANSFORMER(fst _3, fst _7, _1)
  )
# 3257 "cil/src/frontc/cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 496 "cil/src/frontc/cparser.mly"
                           ( PRAGMA (VARIABLE "parse_error", _1) )
# 3265 "cil/src/frontc/cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 500 "cil/src/frontc/cparser.mly"
             ( _1 )
# 3272 "cil/src/frontc/cparser.ml"
               : 'id_or_typename_as_id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 501 "cil/src/frontc/cparser.mly"
                  ( _1 )
# 3279 "cil/src/frontc/cparser.ml"
               : 'id_or_typename_as_id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'id_or_typename_as_id) in
    Obj.repr(
# 505 "cil/src/frontc/cparser.mly"
                          (fst _1)
# 3286 "cil/src/frontc/cparser.ml"
               : 'id_or_typename))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : string * Cabs.cabsloc) in
    Obj.repr(
# 506 "cil/src/frontc/cparser.mly"
                                        ( "@name(" ^ fst _3 ^ ")" )
# 3294 "cil/src/frontc/cparser.ml"
               : 'id_or_typename))
; (fun __caml_parser_env ->
    Obj.repr(
# 510 "cil/src/frontc/cparser.mly"
                                        ( () )
# 3300 "cil/src/frontc/cparser.ml"
               : 'maybecomma))
; (fun __caml_parser_env ->
    Obj.repr(
# 511 "cil/src/frontc/cparser.mly"
                                        ( () )
# 3306 "cil/src/frontc/cparser.ml"
               : 'maybecomma))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 518 "cil/src/frontc/cparser.mly"
          (VARIABLE (fst _1), snd _1)
# 3313 "cil/src/frontc/cparser.ml"
               : 'primary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.constant * cabsloc) in
    Obj.repr(
# 520 "cil/src/frontc/cparser.mly"
          (CONSTANT (fst _1), snd _1)
# 3320 "cil/src/frontc/cparser.ml"
               : 'primary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.expression list * cabsloc) in
    Obj.repr(
# 522 "cil/src/frontc/cparser.mly"
          (PAREN (smooth_expression (fst _1)), snd _1)
# 3327 "cil/src/frontc/cparser.ml"
               : 'primary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.block * cabsloc * cabsloc) in
    Obj.repr(
# 524 "cil/src/frontc/cparser.mly"
          ( GNU_BODY (fst3 _2), _1 )
# 3335 "cil/src/frontc/cparser.ml"
               : 'primary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : string * Cabs.cabsloc) in
    Obj.repr(
# 528 "cil/src/frontc/cparser.mly"
                         ( EXPR_PATTERN(fst _3), _1 )
# 3344 "cil/src/frontc/cparser.ml"
               : 'primary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'primary_expression) in
    Obj.repr(
# 533 "cil/src/frontc/cparser.mly"
                        ( _1 )
# 3351 "cil/src/frontc/cparser.ml"
               : 'postfix_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'postfix_expression) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.expression list) in
    Obj.repr(
# 535 "cil/src/frontc/cparser.mly"
   (INDEX (fst _1, smooth_expression _2), snd _1)
# 3359 "cil/src/frontc/cparser.ml"
               : 'postfix_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'postfix_expression) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression list) in
    Obj.repr(
# 537 "cil/src/frontc/cparser.mly"
   (CALL (fst _1, _3), snd _1)
# 3368 "cil/src/frontc/cparser.ml"
               : 'postfix_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : Cabs.expression * cabsloc) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : Cabs.spec_elem list * Cabs.decl_type) in
    Obj.repr(
# 539 "cil/src/frontc/cparser.mly"
                        ( let b, d = _5 in
                          CALL (VARIABLE "__builtin_va_arg",
                                [fst _3; TYPE_SIZEOF (b, d)]), _1 )
# 3380 "cil/src/frontc/cparser.ml"
               : 'postfix_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : Cabs.spec_elem list * Cabs.decl_type) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : Cabs.spec_elem list * Cabs.decl_type) in
    Obj.repr(
# 543 "cil/src/frontc/cparser.mly"
                        ( let b1,d1 = _3 in
                          let b2,d2 = _5 in
                          CALL (VARIABLE "__builtin_types_compatible_p",
                                [TYPE_SIZEOF(b1,d1); TYPE_SIZEOF(b2,d2)]), _1 )
# 3393 "cil/src/frontc/cparser.ml"
               : 'postfix_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : Cabs.spec_elem list * Cabs.decl_type) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'offsetof_member_designator) in
    Obj.repr(
# 548 "cil/src/frontc/cparser.mly"
                        ( transformOffsetOf _3 _5, _1 )
# 3403 "cil/src/frontc/cparser.ml"
               : 'postfix_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'postfix_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'id_or_typename) in
    Obj.repr(
# 550 "cil/src/frontc/cparser.mly"
          (MEMBEROF (fst _1, _3), snd _1)
# 3411 "cil/src/frontc/cparser.ml"
               : 'postfix_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'postfix_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'id_or_typename) in
    Obj.repr(
# 552 "cil/src/frontc/cparser.mly"
          (MEMBEROFPTR (fst _1, _3), snd _1)
# 3419 "cil/src/frontc/cparser.ml"
               : 'postfix_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'postfix_expression) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 554 "cil/src/frontc/cparser.mly"
          (UNARY (POSINCR, fst _1), snd _1)
# 3427 "cil/src/frontc/cparser.ml"
               : 'postfix_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'postfix_expression) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 556 "cil/src/frontc/cparser.mly"
          (UNARY (POSDECR, fst _1), snd _1)
# 3435 "cil/src/frontc/cparser.ml"
               : 'postfix_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : Cabs.spec_elem list * Cabs.decl_type) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'initializer_list_opt) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 559 "cil/src/frontc/cparser.mly"
          ( CAST(_2, COMPOUND_INIT _5), _1 )
# 3446 "cil/src/frontc/cparser.ml"
               : 'postfix_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'id_or_typename) in
    Obj.repr(
# 564 "cil/src/frontc/cparser.mly"
          ( VARIABLE (_1) )
# 3453 "cil/src/frontc/cparser.ml"
               : 'offsetof_member_designator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'offsetof_member_designator) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 566 "cil/src/frontc/cparser.mly"
   ( MEMBEROF (_1, fst _3) )
# 3461 "cil/src/frontc/cparser.ml"
               : 'offsetof_member_designator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'offsetof_member_designator) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.expression list) in
    Obj.repr(
# 568 "cil/src/frontc/cparser.mly"
   ( INDEX (_1, smooth_expression _2) )
# 3469 "cil/src/frontc/cparser.ml"
               : 'offsetof_member_designator))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'postfix_expression) in
    Obj.repr(
# 573 "cil/src/frontc/cparser.mly"
                        ( _1 )
# 3476 "cil/src/frontc/cparser.ml"
               : 'unary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'unary_expression) in
    Obj.repr(
# 575 "cil/src/frontc/cparser.mly"
          (UNARY (PREINCR, fst _2), _1)
# 3484 "cil/src/frontc/cparser.ml"
               : 'unary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'unary_expression) in
    Obj.repr(
# 577 "cil/src/frontc/cparser.mly"
          (UNARY (PREDECR, fst _2), _1)
# 3492 "cil/src/frontc/cparser.ml"
               : 'unary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'unary_expression) in
    Obj.repr(
# 579 "cil/src/frontc/cparser.mly"
          (EXPR_SIZEOF (fst _2), _1)
# 3500 "cil/src/frontc/cparser.ml"
               : 'unary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.spec_elem list * Cabs.decl_type) in
    Obj.repr(
# 581 "cil/src/frontc/cparser.mly"
          (let b, d = _3 in TYPE_SIZEOF (b, d), _1)
# 3509 "cil/src/frontc/cparser.ml"
               : 'unary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'unary_expression) in
    Obj.repr(
# 583 "cil/src/frontc/cparser.mly"
          (EXPR_ALIGNOF (fst _2), _1)
# 3517 "cil/src/frontc/cparser.ml"
               : 'unary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.spec_elem list * Cabs.decl_type) in
    Obj.repr(
# 585 "cil/src/frontc/cparser.mly"
          (let b, d = _3 in TYPE_ALIGNOF (b, d), _1)
# 3526 "cil/src/frontc/cparser.ml"
               : 'unary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'cast_expression) in
    Obj.repr(
# 587 "cil/src/frontc/cparser.mly"
          (UNARY (PLUS, fst _2), _1)
# 3534 "cil/src/frontc/cparser.ml"
               : 'unary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'cast_expression) in
    Obj.repr(
# 589 "cil/src/frontc/cparser.mly"
          (UNARY (MINUS, fst _2), _1)
# 3542 "cil/src/frontc/cparser.ml"
               : 'unary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'cast_expression) in
    Obj.repr(
# 591 "cil/src/frontc/cparser.mly"
          (UNARY (MEMOF, fst _2), _1)
# 3550 "cil/src/frontc/cparser.ml"
               : 'unary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'cast_expression) in
    Obj.repr(
# 593 "cil/src/frontc/cparser.mly"
          (UNARY (ADDROF, fst _2), _1)
# 3558 "cil/src/frontc/cparser.ml"
               : 'unary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'cast_expression) in
    Obj.repr(
# 595 "cil/src/frontc/cparser.mly"
          (UNARY (NOT, fst _2), _1)
# 3566 "cil/src/frontc/cparser.ml"
               : 'unary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'cast_expression) in
    Obj.repr(
# 597 "cil/src/frontc/cparser.mly"
          (UNARY (BNOT, fst _2), _1)
# 3574 "cil/src/frontc/cparser.ml"
               : 'unary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'id_or_typename_as_id) in
    Obj.repr(
# 599 "cil/src/frontc/cparser.mly"
                                             ( LABELADDR (fst _2), _1 )
# 3582 "cil/src/frontc/cparser.ml"
               : 'unary_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'unary_expression) in
    Obj.repr(
# 604 "cil/src/frontc/cparser.mly"
                         ( _1 )
# 3589 "cil/src/frontc/cparser.ml"
               : 'cast_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.spec_elem list * Cabs.decl_type) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'cast_expression) in
    Obj.repr(
# 606 "cil/src/frontc/cparser.mly"
           ( CAST(_2, SINGLE_INIT (fst _4)), _1 )
# 3598 "cil/src/frontc/cparser.ml"
               : 'cast_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'cast_expression) in
    Obj.repr(
# 611 "cil/src/frontc/cparser.mly"
                         ( _1 )
# 3605 "cil/src/frontc/cparser.ml"
               : 'multiplicative_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'multiplicative_expression) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'cast_expression) in
    Obj.repr(
# 613 "cil/src/frontc/cparser.mly"
   (BINARY(MUL, fst _1, fst _3), snd _1)
# 3614 "cil/src/frontc/cparser.ml"
               : 'multiplicative_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'multiplicative_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'cast_expression) in
    Obj.repr(
# 615 "cil/src/frontc/cparser.mly"
   (BINARY(DIV, fst _1, fst _3), snd _1)
# 3622 "cil/src/frontc/cparser.ml"
               : 'multiplicative_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'multiplicative_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'cast_expression) in
    Obj.repr(
# 617 "cil/src/frontc/cparser.mly"
   (BINARY(MOD, fst _1, fst _3), snd _1)
# 3630 "cil/src/frontc/cparser.ml"
               : 'multiplicative_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'multiplicative_expression) in
    Obj.repr(
# 622 "cil/src/frontc/cparser.mly"
                        ( _1 )
# 3637 "cil/src/frontc/cparser.ml"
               : 'additive_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'additive_expression) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'multiplicative_expression) in
    Obj.repr(
# 624 "cil/src/frontc/cparser.mly"
   (BINARY(ADD, fst _1, fst _3), snd _1)
# 3646 "cil/src/frontc/cparser.ml"
               : 'additive_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'additive_expression) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'multiplicative_expression) in
    Obj.repr(
# 626 "cil/src/frontc/cparser.mly"
   (BINARY(SUB, fst _1, fst _3), snd _1)
# 3655 "cil/src/frontc/cparser.ml"
               : 'additive_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'additive_expression) in
    Obj.repr(
# 631 "cil/src/frontc/cparser.mly"
                         ( _1 )
# 3662 "cil/src/frontc/cparser.ml"
               : 'shift_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'shift_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'additive_expression) in
    Obj.repr(
# 633 "cil/src/frontc/cparser.mly"
   (BINARY(SHL, fst _1, fst _3), snd _1)
# 3670 "cil/src/frontc/cparser.ml"
               : 'shift_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'shift_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'additive_expression) in
    Obj.repr(
# 635 "cil/src/frontc/cparser.mly"
   (BINARY(SHR, fst _1, fst _3), snd _1)
# 3678 "cil/src/frontc/cparser.ml"
               : 'shift_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'shift_expression) in
    Obj.repr(
# 641 "cil/src/frontc/cparser.mly"
                        ( _1 )
# 3685 "cil/src/frontc/cparser.ml"
               : 'relational_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'relational_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'shift_expression) in
    Obj.repr(
# 643 "cil/src/frontc/cparser.mly"
   (BINARY(LT, fst _1, fst _3), snd _1)
# 3693 "cil/src/frontc/cparser.ml"
               : 'relational_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'relational_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'shift_expression) in
    Obj.repr(
# 645 "cil/src/frontc/cparser.mly"
   (BINARY(GT, fst _1, fst _3), snd _1)
# 3701 "cil/src/frontc/cparser.ml"
               : 'relational_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'relational_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'shift_expression) in
    Obj.repr(
# 647 "cil/src/frontc/cparser.mly"
   (BINARY(LE, fst _1, fst _3), snd _1)
# 3709 "cil/src/frontc/cparser.ml"
               : 'relational_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'relational_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'shift_expression) in
    Obj.repr(
# 649 "cil/src/frontc/cparser.mly"
   (BINARY(GE, fst _1, fst _3), snd _1)
# 3717 "cil/src/frontc/cparser.ml"
               : 'relational_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'relational_expression) in
    Obj.repr(
# 654 "cil/src/frontc/cparser.mly"
                        ( _1 )
# 3724 "cil/src/frontc/cparser.ml"
               : 'equality_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'equality_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'relational_expression) in
    Obj.repr(
# 656 "cil/src/frontc/cparser.mly"
   (BINARY(EQ, fst _1, fst _3), snd _1)
# 3732 "cil/src/frontc/cparser.ml"
               : 'equality_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'equality_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'relational_expression) in
    Obj.repr(
# 658 "cil/src/frontc/cparser.mly"
   (BINARY(NE, fst _1, fst _3), snd _1)
# 3740 "cil/src/frontc/cparser.ml"
               : 'equality_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'equality_expression) in
    Obj.repr(
# 664 "cil/src/frontc/cparser.mly"
                       ( _1 )
# 3747 "cil/src/frontc/cparser.ml"
               : 'bitwise_and_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'bitwise_and_expression) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'equality_expression) in
    Obj.repr(
# 666 "cil/src/frontc/cparser.mly"
   (BINARY(BAND, fst _1, fst _3), snd _1)
# 3756 "cil/src/frontc/cparser.ml"
               : 'bitwise_and_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'bitwise_and_expression) in
    Obj.repr(
# 671 "cil/src/frontc/cparser.mly"
                       ( _1 )
# 3763 "cil/src/frontc/cparser.ml"
               : 'bitwise_xor_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'bitwise_xor_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'bitwise_and_expression) in
    Obj.repr(
# 673 "cil/src/frontc/cparser.mly"
   (BINARY(XOR, fst _1, fst _3), snd _1)
# 3771 "cil/src/frontc/cparser.ml"
               : 'bitwise_xor_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'bitwise_xor_expression) in
    Obj.repr(
# 678 "cil/src/frontc/cparser.mly"
                        ( _1 )
# 3778 "cil/src/frontc/cparser.ml"
               : 'bitwise_or_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'bitwise_or_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'bitwise_xor_expression) in
    Obj.repr(
# 680 "cil/src/frontc/cparser.mly"
   (BINARY(BOR, fst _1, fst _3), snd _1)
# 3786 "cil/src/frontc/cparser.ml"
               : 'bitwise_or_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'bitwise_or_expression) in
    Obj.repr(
# 685 "cil/src/frontc/cparser.mly"
                        ( _1 )
# 3793 "cil/src/frontc/cparser.ml"
               : 'logical_and_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'logical_and_expression) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'bitwise_or_expression) in
    Obj.repr(
# 687 "cil/src/frontc/cparser.mly"
   (BINARY(AND, fst _1, fst _3), snd _1)
# 3802 "cil/src/frontc/cparser.ml"
               : 'logical_and_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'logical_and_expression) in
    Obj.repr(
# 692 "cil/src/frontc/cparser.mly"
                        ( _1 )
# 3809 "cil/src/frontc/cparser.ml"
               : 'logical_or_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'logical_or_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'logical_and_expression) in
    Obj.repr(
# 694 "cil/src/frontc/cparser.mly"
   (BINARY(OR, fst _1, fst _3), snd _1)
# 3817 "cil/src/frontc/cparser.ml"
               : 'logical_or_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'logical_or_expression) in
    Obj.repr(
# 699 "cil/src/frontc/cparser.mly"
                         ( _1 )
# 3824 "cil/src/frontc/cparser.ml"
               : 'conditional_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : 'logical_or_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Cabs.expression) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'conditional_expression) in
    Obj.repr(
# 701 "cil/src/frontc/cparser.mly"
   (QUESTION (fst _1, _3, fst _5), snd _1)
# 3833 "cil/src/frontc/cparser.ml"
               : 'conditional_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'conditional_expression) in
    Obj.repr(
# 709 "cil/src/frontc/cparser.mly"
                         ( _1 )
# 3840 "cil/src/frontc/cparser.ml"
               : 'assignment_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'cast_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'assignment_expression) in
    Obj.repr(
# 711 "cil/src/frontc/cparser.mly"
   (BINARY(ASSIGN, fst _1, fst _3), snd _1)
# 3848 "cil/src/frontc/cparser.ml"
               : 'assignment_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'cast_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'assignment_expression) in
    Obj.repr(
# 713 "cil/src/frontc/cparser.mly"
   (BINARY(ADD_ASSIGN, fst _1, fst _3), snd _1)
# 3856 "cil/src/frontc/cparser.ml"
               : 'assignment_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'cast_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'assignment_expression) in
    Obj.repr(
# 715 "cil/src/frontc/cparser.mly"
   (BINARY(SUB_ASSIGN, fst _1, fst _3), snd _1)
# 3864 "cil/src/frontc/cparser.ml"
               : 'assignment_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'cast_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'assignment_expression) in
    Obj.repr(
# 717 "cil/src/frontc/cparser.mly"
   (BINARY(MUL_ASSIGN, fst _1, fst _3), snd _1)
# 3872 "cil/src/frontc/cparser.ml"
               : 'assignment_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'cast_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'assignment_expression) in
    Obj.repr(
# 719 "cil/src/frontc/cparser.mly"
   (BINARY(DIV_ASSIGN, fst _1, fst _3), snd _1)
# 3880 "cil/src/frontc/cparser.ml"
               : 'assignment_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'cast_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'assignment_expression) in
    Obj.repr(
# 721 "cil/src/frontc/cparser.mly"
   (BINARY(MOD_ASSIGN, fst _1, fst _3), snd _1)
# 3888 "cil/src/frontc/cparser.ml"
               : 'assignment_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'cast_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'assignment_expression) in
    Obj.repr(
# 723 "cil/src/frontc/cparser.mly"
   (BINARY(BAND_ASSIGN, fst _1, fst _3), snd _1)
# 3896 "cil/src/frontc/cparser.ml"
               : 'assignment_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'cast_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'assignment_expression) in
    Obj.repr(
# 725 "cil/src/frontc/cparser.mly"
   (BINARY(BOR_ASSIGN, fst _1, fst _3), snd _1)
# 3904 "cil/src/frontc/cparser.ml"
               : 'assignment_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'cast_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'assignment_expression) in
    Obj.repr(
# 727 "cil/src/frontc/cparser.mly"
   (BINARY(XOR_ASSIGN, fst _1, fst _3), snd _1)
# 3912 "cil/src/frontc/cparser.ml"
               : 'assignment_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'cast_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'assignment_expression) in
    Obj.repr(
# 729 "cil/src/frontc/cparser.mly"
   (BINARY(SHL_ASSIGN, fst _1, fst _3), snd _1)
# 3920 "cil/src/frontc/cparser.ml"
               : 'assignment_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'cast_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'assignment_expression) in
    Obj.repr(
# 731 "cil/src/frontc/cparser.mly"
   (BINARY(SHR_ASSIGN, fst _1, fst _3), snd _1)
# 3928 "cil/src/frontc/cparser.ml"
               : 'assignment_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'assignment_expression) in
    Obj.repr(
# 736 "cil/src/frontc/cparser.mly"
                        ( _1 )
# 3935 "cil/src/frontc/cparser.ml"
               : Cabs.expression * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 741 "cil/src/frontc/cparser.mly"
               (CONST_INT (fst _1), snd _1)
# 3942 "cil/src/frontc/cparser.ml"
               : Cabs.constant * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 742 "cil/src/frontc/cparser.mly"
                 (CONST_FLOAT (fst _1), snd _1)
# 3949 "cil/src/frontc/cparser.ml"
               : Cabs.constant * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : int64 list * Cabs.cabsloc) in
    Obj.repr(
# 743 "cil/src/frontc/cparser.mly"
                (CONST_CHAR (fst _1), snd _1)
# 3956 "cil/src/frontc/cparser.ml"
               : Cabs.constant * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : int64 list * Cabs.cabsloc) in
    Obj.repr(
# 744 "cil/src/frontc/cparser.mly"
                 (CONST_WCHAR (fst _1), snd _1)
# 3963 "cil/src/frontc/cparser.ml"
               : Cabs.constant * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * cabsloc) in
    Obj.repr(
# 745 "cil/src/frontc/cparser.mly"
                             (CONST_STRING (fst _1), snd _1)
# 3970 "cil/src/frontc/cparser.ml"
               : Cabs.constant * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : int64 list * cabsloc) in
    Obj.repr(
# 746 "cil/src/frontc/cparser.mly"
                   (CONST_WSTRING (fst _1), snd _1)
# 3977 "cil/src/frontc/cparser.ml"
               : Cabs.constant * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : int64 list Queue.t * cabsloc) in
    Obj.repr(
# 752 "cil/src/frontc/cparser.mly"
                                        (
     let queue, location = _1 in
     let buffer = Buffer.create (Queue.length queue) in
     Queue.iter
       (List.iter
	  (fun value ->
	    let char = int64_to_char value in
	    Buffer.add_char buffer char))
       queue;
     Buffer.contents buffer, location
   )
# 3994 "cil/src/frontc/cparser.ml"
               : string * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : int64 list * Cabs.cabsloc) in
    Obj.repr(
# 766 "cil/src/frontc/cparser.mly"
                                        (intlist_to_string (fst _1) )
# 4001 "cil/src/frontc/cparser.ml"
               : 'one_string_constant))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'one_string) in
    Obj.repr(
# 769 "cil/src/frontc/cparser.mly"
                                        (
      let queue = Queue.create () in
      Queue.add (fst _1) queue;
      queue, snd _1
    )
# 4012 "cil/src/frontc/cparser.ml"
               : int64 list Queue.t * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : int64 list Queue.t * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'one_string) in
    Obj.repr(
# 774 "cil/src/frontc/cparser.mly"
                                        (
      Queue.add (fst _2) (fst _1);
      _1
    )
# 4023 "cil/src/frontc/cparser.ml"
               : int64 list Queue.t * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : int64 list * Cabs.cabsloc) in
    Obj.repr(
# 781 "cil/src/frontc/cparser.mly"
                                        ( _1 )
# 4030 "cil/src/frontc/cparser.ml"
               : int64 list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : int64 list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'one_string) in
    Obj.repr(
# 782 "cil/src/frontc/cparser.mly"
                                        ( (fst _1) @ (fst _2), snd _1 )
# 4038 "cil/src/frontc/cparser.ml"
               : int64 list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : int64 list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : int64 list * Cabs.cabsloc) in
    Obj.repr(
# 783 "cil/src/frontc/cparser.mly"
                                        ( (fst _1) @ (fst _2), snd _1 )
# 4046 "cil/src/frontc/cparser.ml"
               : int64 list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : int64 list * Cabs.cabsloc) in
    Obj.repr(
# 788 "cil/src/frontc/cparser.mly"
                  (_1)
# 4053 "cil/src/frontc/cparser.ml"
               : 'one_string))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 789 "cil/src/frontc/cparser.mly"
                                        ((Cabshelper.explodeStringToInts
					    !currentFunctionName), _1)
# 4061 "cil/src/frontc/cparser.ml"
               : 'one_string))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 791 "cil/src/frontc/cparser.mly"
                                        ((Cabshelper.explodeStringToInts
					    !currentFunctionName), _1)
# 4069 "cil/src/frontc/cparser.ml"
               : 'one_string))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.expression * cabsloc) in
    Obj.repr(
# 796 "cil/src/frontc/cparser.mly"
                        ( SINGLE_INIT (fst _1) )
# 4076 "cil/src/frontc/cparser.ml"
               : Cabs.init_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'initializer_list_opt) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 798 "cil/src/frontc/cparser.mly"
   ( COMPOUND_INIT _2)
# 4085 "cil/src/frontc/cparser.ml"
               : Cabs.init_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.initwhat * Cabs.init_expression) in
    Obj.repr(
# 801 "cil/src/frontc/cparser.mly"
                                            ( [_1] )
# 4092 "cil/src/frontc/cparser.ml"
               : (Cabs.initwhat * Cabs.init_expression) list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.initwhat * Cabs.init_expression) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'initializer_list_opt) in
    Obj.repr(
# 802 "cil/src/frontc/cparser.mly"
                                            ( _1 :: _3 )
# 4100 "cil/src/frontc/cparser.ml"
               : (Cabs.initwhat * Cabs.init_expression) list))
; (fun __caml_parser_env ->
    Obj.repr(
# 805 "cil/src/frontc/cparser.mly"
                                            ( [] )
# 4106 "cil/src/frontc/cparser.ml"
               : 'initializer_list_opt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : (Cabs.initwhat * Cabs.init_expression) list) in
    Obj.repr(
# 806 "cil/src/frontc/cparser.mly"
                                            ( _1 )
# 4113 "cil/src/frontc/cparser.ml"
               : 'initializer_list_opt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.initwhat) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'eq_opt) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.init_expression) in
    Obj.repr(
# 809 "cil/src/frontc/cparser.mly"
                                            ( (_1, _3) )
# 4122 "cil/src/frontc/cparser.ml"
               : Cabs.initwhat * Cabs.init_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'gcc_init_designators) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.init_expression) in
    Obj.repr(
# 810 "cil/src/frontc/cparser.mly"
                                         ( (_1, _2) )
# 4130 "cil/src/frontc/cparser.ml"
               : Cabs.initwhat * Cabs.init_expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.init_expression) in
    Obj.repr(
# 811 "cil/src/frontc/cparser.mly"
                                        ( (NEXT_INIT, _1) )
# 4137 "cil/src/frontc/cparser.ml"
               : Cabs.initwhat * Cabs.init_expression))
; (fun __caml_parser_env ->
    Obj.repr(
# 814 "cil/src/frontc/cparser.mly"
                             ( () )
# 4143 "cil/src/frontc/cparser.ml"
               : 'eq_opt))
; (fun __caml_parser_env ->
    Obj.repr(
# 816 "cil/src/frontc/cparser.mly"
                                 ( () )
# 4149 "cil/src/frontc/cparser.ml"
               : 'eq_opt))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'id_or_typename) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.initwhat) in
    Obj.repr(
# 819 "cil/src/frontc/cparser.mly"
                                                 ( INFIELD_INIT(_2, _3) )
# 4157 "cil/src/frontc/cparser.ml"
               : Cabs.initwhat))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.expression * cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Cabs.initwhat) in
    Obj.repr(
# 821 "cil/src/frontc/cparser.mly"
                                        ( ATINDEX_INIT(fst _2, _4) )
# 4165 "cil/src/frontc/cparser.ml"
               : Cabs.initwhat))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Cabs.expression * cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression * cabsloc) in
    Obj.repr(
# 823 "cil/src/frontc/cparser.mly"
                                        ( ATINDEXRANGE_INIT(fst _2, fst _4) )
# 4173 "cil/src/frontc/cparser.ml"
               : Cabs.initwhat))
; (fun __caml_parser_env ->
    Obj.repr(
# 826 "cil/src/frontc/cparser.mly"
                                        ( NEXT_INIT )
# 4179 "cil/src/frontc/cparser.ml"
               : Cabs.initwhat))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.initwhat) in
    Obj.repr(
# 827 "cil/src/frontc/cparser.mly"
                                        ( _1 )
# 4186 "cil/src/frontc/cparser.ml"
               : Cabs.initwhat))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'id_or_typename) in
    Obj.repr(
# 831 "cil/src/frontc/cparser.mly"
                                        ( INFIELD_INIT(_1, NEXT_INIT) )
# 4193 "cil/src/frontc/cparser.ml"
               : 'gcc_init_designators))
; (fun __caml_parser_env ->
    Obj.repr(
# 835 "cil/src/frontc/cparser.mly"
                                    ( [] )
# 4199 "cil/src/frontc/cparser.ml"
               : Cabs.expression list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.expression list * cabsloc) in
    Obj.repr(
# 836 "cil/src/frontc/cparser.mly"
                                    ( fst _1 )
# 4206 "cil/src/frontc/cparser.ml"
               : Cabs.expression list))
; (fun __caml_parser_env ->
    Obj.repr(
# 841 "cil/src/frontc/cparser.mly"
          (NOTHING)
# 4212 "cil/src/frontc/cparser.ml"
               : Cabs.expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.expression list * cabsloc) in
    Obj.repr(
# 843 "cil/src/frontc/cparser.mly"
          (smooth_expression (fst _1))
# 4219 "cil/src/frontc/cparser.ml"
               : Cabs.expression))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.expression * cabsloc) in
    Obj.repr(
# 847 "cil/src/frontc/cparser.mly"
                                           ([fst _1], snd _1)
# 4226 "cil/src/frontc/cparser.ml"
               : Cabs.expression list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.expression * cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.expression list * cabsloc) in
    Obj.repr(
# 848 "cil/src/frontc/cparser.mly"
                                                  ( fst _1 :: fst _3, snd _1 )
# 4234 "cil/src/frontc/cparser.ml"
               : Cabs.expression list * cabsloc))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.expression list * cabsloc) in
    Obj.repr(
# 849 "cil/src/frontc/cparser.mly"
                                                  ( _3 )
# 4241 "cil/src/frontc/cparser.ml"
               : Cabs.expression list * cabsloc))
; (fun __caml_parser_env ->
    Obj.repr(
# 853 "cil/src/frontc/cparser.mly"
                                    ( NOTHING )
# 4247 "cil/src/frontc/cparser.ml"
               : 'comma_expression_opt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.expression list * cabsloc) in
    Obj.repr(
# 854 "cil/src/frontc/cparser.mly"
                                    ( smooth_expression (fst _1) )
# 4254 "cil/src/frontc/cparser.ml"
               : 'comma_expression_opt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression list * cabsloc) in
    Obj.repr(
# 858 "cil/src/frontc/cparser.mly"
                                                   ( _2 )
# 4262 "cil/src/frontc/cparser.ml"
               : Cabs.expression list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    Obj.repr(
# 859 "cil/src/frontc/cparser.mly"
                                                   ( [], _1 )
# 4269 "cil/src/frontc/cparser.ml"
               : Cabs.expression list * cabsloc))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression list * cabsloc) in
    Obj.repr(
# 863 "cil/src/frontc/cparser.mly"
                                                       ( fst _2 )
# 4276 "cil/src/frontc/cparser.ml"
               : Cabs.expression list))
; (fun __caml_parser_env ->
    Obj.repr(
# 864 "cil/src/frontc/cparser.mly"
                                                       ( [] )
# 4282 "cil/src/frontc/cparser.ml"
               : Cabs.expression list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : 'block_begin) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : string list) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'block_attrs) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Cabs.statement list) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 871 "cil/src/frontc/cparser.mly"
                                         (!Lexerhack.pop_context();
                                          { blabels = _2;
                                            battrs = _3;
                                            bstmts = _4 },
					    _1, _5
                                         )
# 4298 "cil/src/frontc/cparser.ml"
               : Cabs.block * cabsloc * cabsloc))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 877 "cil/src/frontc/cparser.mly"
                                         ( { blabels = [];
                                             battrs  = [];
                                             bstmts  = [] },
					     _2, _3
                                         )
# 4310 "cil/src/frontc/cparser.ml"
               : Cabs.block * cabsloc * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 884 "cil/src/frontc/cparser.mly"
                           (!Lexerhack.push_context (); _1)
# 4317 "cil/src/frontc/cparser.ml"
               : 'block_begin))
; (fun __caml_parser_env ->
    Obj.repr(
# 888 "cil/src/frontc/cparser.mly"
                                                            ( [] )
# 4323 "cil/src/frontc/cparser.ml"
               : 'block_attrs))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'paren_attr_list_ne) in
    Obj.repr(
# 890 "cil/src/frontc/cparser.mly"
                                        ( [("__blockattribute__", _2)] )
# 4330 "cil/src/frontc/cparser.ml"
               : 'block_attrs))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'annot_list_opt) in
    Obj.repr(
# 895 "cil/src/frontc/cparser.mly"
                                                        ( _1 )
# 4337 "cil/src/frontc/cparser.ml"
               : Cabs.statement list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'annot_list_opt) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.definition) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.statement list) in
    Obj.repr(
# 896 "cil/src/frontc/cparser.mly"
                                                        ( _1 @ no_ghost (DEFINITION(_2)) :: _3 )
# 4346 "cil/src/frontc/cparser.ml"
               : Cabs.statement list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'annot_list_opt) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'statement) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.statement list) in
    Obj.repr(
# 897 "cil/src/frontc/cparser.mly"
                                                        ( _1 @ (no_ghost _2) :: _3 )
# 4355 "cil/src/frontc/cparser.ml"
               : Cabs.statement list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'annot_list_opt) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'pragma) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.statement list) in
    Obj.repr(
# 898 "cil/src/frontc/cparser.mly"
                                                        ( _1 @ _3 )
# 4364 "cil/src/frontc/cparser.ml"
               : Cabs.statement list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'annot_list_opt) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'id_or_typename_as_id) in
    Obj.repr(
# 901 "cil/src/frontc/cparser.mly"
                                      ( _1 @ [no_ghost
                                                (LABEL (fst _2,
                                                        no_ghost (NOP (snd _2)), snd _2))] )
# 4374 "cil/src/frontc/cparser.ml"
               : Cabs.statement list))
; (fun __caml_parser_env ->
    Obj.repr(
# 907 "cil/src/frontc/cparser.mly"
                    ( [] )
# 4380 "cil/src/frontc/cparser.ml"
               : 'annot_list_opt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'annot_list) in
    Obj.repr(
# 908 "cil/src/frontc/cparser.mly"
                    ( _1 )
# 4387 "cil/src/frontc/cparser.ml"
               : 'annot_list_opt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Logic_ptree.code_annot * Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'annot_list_opt) in
    Obj.repr(
# 912 "cil/src/frontc/cparser.mly"
                             ( no_ghost (Cabs.CODE_ANNOT _1):: _2)
# 4395 "cil/src/frontc/cparser.ml"
               : 'annot_list))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.statement list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'annot_list_opt) in
    Obj.repr(
# 914 "cil/src/frontc/cparser.mly"
       ( let res = (_2@_4) in
         List.iter in_ghost res; res )
# 4404 "cil/src/frontc/cparser.ml"
               : 'annot_list))
; (fun __caml_parser_env ->
    Obj.repr(
# 919 "cil/src/frontc/cparser.mly"
                                                     ( [] )
# 4410 "cil/src/frontc/cparser.ml"
               : string list))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : string list) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : string list) in
    Obj.repr(
# 920 "cil/src/frontc/cparser.mly"
                                                     ( _2 @ _4 )
# 4419 "cil/src/frontc/cparser.ml"
               : string list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'id_or_typename_as_id) in
    Obj.repr(
# 923 "cil/src/frontc/cparser.mly"
                                                     ( [ fst _1 ] )
# 4426 "cil/src/frontc/cparser.ml"
               : string list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'id_or_typename_as_id) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : string list) in
    Obj.repr(
# 924 "cil/src/frontc/cparser.mly"
                                                     ( fst _1 :: _3 )
# 4434 "cil/src/frontc/cparser.ml"
               : string list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'statement) in
    Obj.repr(
# 929 "cil/src/frontc/cparser.mly"
              ( no_ghost _1 )
# 4441 "cil/src/frontc/cparser.ml"
               : 'annotated_statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'annot_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'statement) in
    Obj.repr(
# 930 "cil/src/frontc/cparser.mly"
                         (
      let st = no_ghost _2 in
      let st =
        match st.stmt_node with
        | BLOCK(b,start,stop) ->
            {st with stmt_node =
                BLOCK({b with battrs = ("FRAMA_C_KEEP_BLOCK",[])::b.battrs},start,stop)}
        | _ -> st
      in
      no_ghost
        (BLOCK ({ blabels = [];
                  battrs  = [];
                  bstmts  = _1 @ [st] },
                get_statementloc (List.hd _1), get_statementloc st)))
# 4462 "cil/src/frontc/cparser.ml"
               : 'annotated_statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 947 "cil/src/frontc/cparser.mly"
               (NOP ((*handleLoc*) _1) )
# 4469 "cil/src/frontc/cparser.ml"
               : 'statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Lexing.position * string) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'annotated_statement) in
    Obj.repr(
# 949 "cil/src/frontc/cparser.mly"
      (
        let bs = _2 in
        Cabshelper.continue_annot
	  (currentLoc())
	  (fun () ->
             let spec = Logic_lexer.spec _1 in
             let spec = no_ghost (Cabs.CODE_SPEC spec) in
             BLOCK ({ blabels = []; battrs = []; bstmts = [spec;bs] },
                    get_statementloc spec, get_statementloc bs))
	  (fun () -> bs.stmt_node)
	  "Skipping annotation"
      )
# 4488 "cil/src/frontc/cparser.ml"
               : 'statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 962 "cil/src/frontc/cparser.mly"
          (COMPUTATION (smooth_expression (fst _1),  (*handleLoc*)(snd _1)))
# 4496 "cil/src/frontc/cparser.ml"
               : 'statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.block * cabsloc * cabsloc) in
    Obj.repr(
# 963 "cil/src/frontc/cparser.mly"
                        (BLOCK (fst3 _1, (*handleLoc*)(snd3 _1), trd3 _1))
# 4503 "cil/src/frontc/cparser.ml"
               : 'statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression list * cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'annotated_statement) in
    Obj.repr(
# 965 "cil/src/frontc/cparser.mly"
                 (IF (smooth_expression (fst _2), _3, no_ghost (NOP _1), _1))
# 4512 "cil/src/frontc/cparser.ml"
               : 'statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Cabs.expression list * cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'annotated_statement) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'annotated_statement) in
    Obj.repr(
# 967 "cil/src/frontc/cparser.mly"
                 (IF (smooth_expression (fst _2), _3, _5, (*handleLoc*) _1))
# 4522 "cil/src/frontc/cparser.ml"
               : 'statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression list * cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'annotated_statement) in
    Obj.repr(
# 969 "cil/src/frontc/cparser.mly"
                        (SWITCH (smooth_expression (fst _2), _3, (*handleLoc*) _1))
# 4531 "cil/src/frontc/cparser.ml"
               : 'statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'opt_loop_annotations) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression list * cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'annotated_statement) in
    Obj.repr(
# 972 "cil/src/frontc/cparser.mly"
          (WHILE (_1, smooth_expression (fst _3), _4, (*handleLoc*) _2))
# 4541 "cil/src/frontc/cparser.ml"
               : 'statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : 'opt_loop_annotations) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'annotated_statement) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression list * cabsloc) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 975 "cil/src/frontc/cparser.mly"
                   (DOWHILE (_1,
					   smooth_expression (fst _5), _3, (*handleLoc*) _2))
# 4554 "cil/src/frontc/cparser.ml"
               : 'statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 9 : 'opt_loop_annotations) in
    let _2 = (Parsing.peek_val __caml_parser_env 8 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 7 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 6 : 'for_clause) in
    let _5 = (Parsing.peek_val __caml_parser_env 5 : Cabs.expression) in
    let _6 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _7 = (Parsing.peek_val __caml_parser_env 3 : Cabs.expression) in
    let _9 = (Parsing.peek_val __caml_parser_env 1 : 'annotated_statement) in
    let _10 = (Parsing.peek_val __caml_parser_env 0 : 'get_current_loc) in
    Obj.repr(
# 980 "cil/src/frontc/cparser.mly"
                          (FOR (_1, _4, _5, _7, _9, _2, (*handleLoc*) _10))
# 4569 "cil/src/frontc/cparser.ml"
               : 'statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'id_or_typename_as_id) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'attribute_nocv_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'annotated_statement) in
    Obj.repr(
# 982 "cil/src/frontc/cparser.mly"
                   ((* The only attribute that should appear here
                                     is "unused". For now, we drop this on the
                                     floor, since unused labels are usually
                                     removed anyways by Rmtmps. *)
                                  LABEL (fst _1, _4, (snd _1)))
# 4582 "cil/src/frontc/cparser.ml"
               : 'statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.expression * cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'annotated_statement) in
    Obj.repr(
# 988 "cil/src/frontc/cparser.mly"
                          (CASE (fst _2, _4, (*handleLoc*) _1))
# 4591 "cil/src/frontc/cparser.ml"
               : 'statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : Cabs.expression * cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : Cabs.expression * cabsloc) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : 'annotated_statement) in
    Obj.repr(
# 990 "cil/src/frontc/cparser.mly"
                          (CASERANGE (fst _2, fst _4, _6, (*handleLoc*) _1))
# 4601 "cil/src/frontc/cparser.ml"
               : 'statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    Obj.repr(
# 992 "cil/src/frontc/cparser.mly"
                          (DEFAULT (no_ghost (NOP _1), (*handleLoc*) _1))
# 4608 "cil/src/frontc/cparser.ml"
               : 'statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 993 "cil/src/frontc/cparser.mly"
                       (RETURN (NOTHING, (*handleLoc*) _1))
# 4616 "cil/src/frontc/cparser.ml"
               : 'statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression list * cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 995 "cil/src/frontc/cparser.mly"
                          (RETURN (smooth_expression (fst _2), (*handleLoc*) _1))
# 4625 "cil/src/frontc/cparser.ml"
               : 'statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 996 "cil/src/frontc/cparser.mly"
                        (BREAK ((*handleLoc*) _1))
# 4633 "cil/src/frontc/cparser.ml"
               : 'statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 997 "cil/src/frontc/cparser.mly"
                        (CONTINUE ((*handleLoc*) _1))
# 4641 "cil/src/frontc/cparser.ml"
               : 'statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'id_or_typename_as_id) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 999 "cil/src/frontc/cparser.mly"
                   (GOTO (fst _2, (*handleLoc*) _1))
# 4650 "cil/src/frontc/cparser.ml"
               : 'statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression list * cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1001 "cil/src/frontc/cparser.mly"
                                 ( COMPGOTO (smooth_expression (fst _3), (*handleLoc*) _1) )
# 4660 "cil/src/frontc/cparser.ml"
               : 'statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 6 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 5 : Cabs.attribute list) in
    let _3 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 3 : 'asmtemplate) in
    let _5 = (Parsing.peek_val __caml_parser_env 2 : 'asmoutputs) in
    let _7 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1003 "cil/src/frontc/cparser.mly"
                        ( ASM (_2, _4, _5, (*handleLoc*) _1) )
# 4672 "cil/src/frontc/cparser.ml"
               : 'statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 1004 "cil/src/frontc/cparser.mly"
                        ( ASM ([], [fst _1], None, (*handleLoc*)(snd _1)))
# 4679 "cil/src/frontc/cparser.ml"
               : 'statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Cabs.block * cabsloc * cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression list * cabsloc) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Cabs.block * cabsloc * cabsloc) in
    Obj.repr(
# 1006 "cil/src/frontc/cparser.mly"
                        ( let b, _, _ = _2 in
                          let h, _, _ = _5 in
                          if not !Cprint.msvcMode then
                            parse_error "try/except in GCC code";
                          TRY_EXCEPT (b, COMMA (fst _4), h, (*handleLoc*) _1) )
# 4694 "cil/src/frontc/cparser.ml"
               : 'statement))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.block * cabsloc * cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Cabs.block * cabsloc * cabsloc) in
    Obj.repr(
# 1012 "cil/src/frontc/cparser.mly"
                        ( let b, _, _ = _2 in
                          let h, _, _ = _4 in
                          if not !Cprint.msvcMode then
                            parse_error "try/finally in GCC code";
                          TRY_FINALLY (b, h, (*handleLoc*) _1) )
# 4708 "cil/src/frontc/cparser.ml"
               : 'statement))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1018 "cil/src/frontc/cparser.mly"
                                 ( (NOP _2))
# 4716 "cil/src/frontc/cparser.ml"
               : 'statement))
; (fun __caml_parser_env ->
    Obj.repr(
# 1023 "cil/src/frontc/cparser.mly"
                ( [] )
# 4722 "cil/src/frontc/cparser.ml"
               : 'opt_loop_annotations))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'loop_annotations) in
    Obj.repr(
# 1024 "cil/src/frontc/cparser.mly"
                   ( _1 )
# 4729 "cil/src/frontc/cparser.ml"
               : 'opt_loop_annotations))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'loop_annotation) in
    Obj.repr(
# 1028 "cil/src/frontc/cparser.mly"
                  ( _1 )
# 4736 "cil/src/frontc/cparser.ml"
               : 'loop_annotations))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.code_annot list * Cabs.cabsloc) in
    Obj.repr(
# 1040 "cil/src/frontc/cparser.mly"
               ( fst _1 )
# 4743 "cil/src/frontc/cparser.ml"
               : 'loop_annotation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1044 "cil/src/frontc/cparser.mly"
                                 ( FC_EXP _1 )
# 4751 "cil/src/frontc/cparser.ml"
               : 'for_clause))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.definition) in
    Obj.repr(
# 1045 "cil/src/frontc/cparser.mly"
                                 ( FC_DECL _1 )
# 4758 "cil/src/frontc/cparser.ml"
               : 'for_clause))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : spec_elem list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.init_name list) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1050 "cil/src/frontc/cparser.mly"
      ( doDeclaration None ((snd _1)) (fst _1) _2 )
# 4767 "cil/src/frontc/cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : spec_elem list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1052 "cil/src/frontc/cparser.mly"
      ( doDeclaration None ((snd _1)) (fst _1) [] )
# 4775 "cil/src/frontc/cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Lexing.position * string) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : spec_elem list * cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.init_name list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1054 "cil/src/frontc/cparser.mly"
      ( doDeclaration (Some _1) ((snd _2)) (fst _2) _3 )
# 4785 "cil/src/frontc/cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Lexing.position * string) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : spec_elem list * cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1056 "cil/src/frontc/cparser.mly"
      ( doDeclaration (Some _1) ((snd _2)) (fst _2) [] )
# 4794 "cil/src/frontc/cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.init_name) in
    Obj.repr(
# 1059 "cil/src/frontc/cparser.mly"
                                                 ( [_1] )
# 4801 "cil/src/frontc/cparser.ml"
               : Cabs.init_name list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.init_name) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.init_name list) in
    Obj.repr(
# 1060 "cil/src/frontc/cparser.mly"
                                                 ( _1 :: _3 )
# 4809 "cil/src/frontc/cparser.ml"
               : Cabs.init_name list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.name) in
    Obj.repr(
# 1064 "cil/src/frontc/cparser.mly"
                                        ( (_1, NO_INIT) )
# 4816 "cil/src/frontc/cparser.ml"
               : Cabs.init_name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.name) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.init_expression) in
    Obj.repr(
# 1066 "cil/src/frontc/cparser.mly"
                                        ( (_1, _3) )
# 4824 "cil/src/frontc/cparser.ml"
               : Cabs.init_name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec_list_opt) in
    Obj.repr(
# 1071 "cil/src/frontc/cparser.mly"
                                        ( SpecTypedef :: _2, _1  )
# 4832 "cil/src/frontc/cparser.ml"
               : spec_elem list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec_list_opt) in
    Obj.repr(
# 1072 "cil/src/frontc/cparser.mly"
                                        ( SpecStorage EXTERN :: _2, _1 )
# 4840 "cil/src/frontc/cparser.ml"
               : spec_elem list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec_list_opt) in
    Obj.repr(
# 1073 "cil/src/frontc/cparser.mly"
                                        ( SpecStorage STATIC :: _2, _1 )
# 4848 "cil/src/frontc/cparser.ml"
               : spec_elem list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec_list_opt) in
    Obj.repr(
# 1074 "cil/src/frontc/cparser.mly"
                                        ( SpecStorage AUTO :: _2, _1 )
# 4856 "cil/src/frontc/cparser.ml"
               : spec_elem list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec_list_opt) in
    Obj.repr(
# 1075 "cil/src/frontc/cparser.mly"
                                        ( SpecStorage REGISTER :: _2, _1)
# 4864 "cil/src/frontc/cparser.ml"
               : spec_elem list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : typeSpecifier * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec_list_opt_no_named) in
    Obj.repr(
# 1077 "cil/src/frontc/cparser.mly"
                                          ( SpecType (fst _1) :: _2, snd _1 )
# 4872 "cil/src/frontc/cparser.ml"
               : spec_elem list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec_list_opt) in
    Obj.repr(
# 1079 "cil/src/frontc/cparser.mly"
                                        ( SpecInline :: _2, _1 )
# 4880 "cil/src/frontc/cparser.ml"
               : spec_elem list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.spec_elem * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec_list_opt) in
    Obj.repr(
# 1080 "cil/src/frontc/cparser.mly"
                                        ( (fst _1) :: _2, snd _1 )
# 4888 "cil/src/frontc/cparser.ml"
               : spec_elem list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'attribute_nocv) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec_list_opt) in
    Obj.repr(
# 1081 "cil/src/frontc/cparser.mly"
                                        ( SpecAttr (fst _1) :: _2, snd _1 )
# 4896 "cil/src/frontc/cparser.ml"
               : spec_elem list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : string * Cabs.cabsloc) in
    Obj.repr(
# 1083 "cil/src/frontc/cparser.mly"
                                        ( [ SpecPattern(fst _3) ], _1 )
# 4905 "cil/src/frontc/cparser.ml"
               : spec_elem list * cabsloc))
; (fun __caml_parser_env ->
    Obj.repr(
# 1088 "cil/src/frontc/cparser.mly"
                                        ( [] )
# 4911 "cil/src/frontc/cparser.ml"
               : 'decl_spec_list_opt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : spec_elem list * cabsloc) in
    Obj.repr(
# 1089 "cil/src/frontc/cparser.mly"
                                        ( fst _1 )
# 4918 "cil/src/frontc/cparser.ml"
               : 'decl_spec_list_opt))
; (fun __caml_parser_env ->
    Obj.repr(
# 1096 "cil/src/frontc/cparser.mly"
                                        ( [] )
# 4924 "cil/src/frontc/cparser.ml"
               : 'decl_spec_list_opt_no_named))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : spec_elem list * cabsloc) in
    Obj.repr(
# 1097 "cil/src/frontc/cparser.mly"
                                        ( fst _1 )
# 4931 "cil/src/frontc/cparser.ml"
               : 'decl_spec_list_opt_no_named))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1100 "cil/src/frontc/cparser.mly"
                    ( Tvoid, _1)
# 4938 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1101 "cil/src/frontc/cparser.mly"
                    ( Tchar, _1 )
# 4945 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1102 "cil/src/frontc/cparser.mly"
                    ( Tbool, _1 )
# 4952 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1103 "cil/src/frontc/cparser.mly"
                    ( Tshort, _1 )
# 4959 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1104 "cil/src/frontc/cparser.mly"
                    ( Tint, _1 )
# 4966 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1105 "cil/src/frontc/cparser.mly"
                    ( Tlong, _1 )
# 4973 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1106 "cil/src/frontc/cparser.mly"
                    ( Tint64, _1 )
# 4980 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1107 "cil/src/frontc/cparser.mly"
                    ( Tfloat, _1 )
# 4987 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1108 "cil/src/frontc/cparser.mly"
                    ( Tdouble, _1 )
# 4994 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1109 "cil/src/frontc/cparser.mly"
                    ( Tsigned, _1 )
# 5001 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1110 "cil/src/frontc/cparser.mly"
                    ( Tunsigned, _1 )
# 5008 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'id_or_typename) in
    Obj.repr(
# 1112 "cil/src/frontc/cparser.mly"
                                                   ( Tstruct (_2, None,    []), _1 )
# 5016 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'just_attributes) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'id_or_typename) in
    Obj.repr(
# 1114 "cil/src/frontc/cparser.mly"
                                                   ( Tstruct (_3, None,    _2), _1 )
# 5025 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'id_or_typename) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Cabs.field_group list) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1116 "cil/src/frontc/cparser.mly"
                                                   ( Tstruct (_2, Some _4, []), _1 )
# 5036 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.field_group list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1118 "cil/src/frontc/cparser.mly"
                                                   ( Tstruct ("", Some _3, []), _1 )
# 5046 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'just_attributes) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'id_or_typename) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : Cabs.field_group list) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1120 "cil/src/frontc/cparser.mly"
                                                   ( Tstruct (_3, Some _5, _2), _1 )
# 5058 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'just_attributes) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Cabs.field_group list) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1122 "cil/src/frontc/cparser.mly"
                                                   ( Tstruct ("", Some _4, _2), _1 )
# 5069 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'id_or_typename) in
    Obj.repr(
# 1124 "cil/src/frontc/cparser.mly"
                                                   ( Tunion  (_2, None,    []), _1 )
# 5077 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'id_or_typename) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Cabs.field_group list) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1126 "cil/src/frontc/cparser.mly"
                                                   ( Tunion  (_2, Some _4, []), _1 )
# 5088 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.field_group list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1128 "cil/src/frontc/cparser.mly"
                                                   ( Tunion  ("", Some _3, []), _1 )
# 5098 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'just_attributes) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'id_or_typename) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : Cabs.field_group list) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1130 "cil/src/frontc/cparser.mly"
                                                   ( Tunion  (_3, Some _5, _2), _1 )
# 5110 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'just_attributes) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Cabs.field_group list) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1132 "cil/src/frontc/cparser.mly"
                                                   ( Tunion  ("", Some _4, _2), _1 )
# 5121 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'id_or_typename) in
    Obj.repr(
# 1134 "cil/src/frontc/cparser.mly"
                                                   ( Tenum   (_2, None,    []), _1 )
# 5129 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'id_or_typename) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : Cabs.enum_item list) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'maybecomma) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1136 "cil/src/frontc/cparser.mly"
                                                   ( Tenum   (_2, Some _4, []), _1 )
# 5141 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Cabs.enum_item list) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'maybecomma) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1138 "cil/src/frontc/cparser.mly"
                                                   ( Tenum   ("", Some _3, []), _1 )
# 5152 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 6 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 5 : 'just_attributes) in
    let _3 = (Parsing.peek_val __caml_parser_env 4 : 'id_or_typename) in
    let _4 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _5 = (Parsing.peek_val __caml_parser_env 2 : Cabs.enum_item list) in
    let _6 = (Parsing.peek_val __caml_parser_env 1 : 'maybecomma) in
    let _7 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1140 "cil/src/frontc/cparser.mly"
                                                   ( Tenum   (_3, Some _5, _2), _1 )
# 5165 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'just_attributes) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : Cabs.enum_item list) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'maybecomma) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1142 "cil/src/frontc/cparser.mly"
                                                   ( Tenum   ("", Some _4, _2), _1 )
# 5177 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 1143 "cil/src/frontc/cparser.mly"
                    ( Tnamed (fst _1), snd _1 )
# 5184 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression * cabsloc) in
    Obj.repr(
# 1144 "cil/src/frontc/cparser.mly"
                                        ( TtypeofE (fst _3), _1 )
# 5193 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.spec_elem list * Cabs.decl_type) in
    Obj.repr(
# 1145 "cil/src/frontc/cparser.mly"
                                        ( let s, d = _3 in
                                          TtypeofT (s, d), _1 )
# 5203 "cil/src/frontc/cparser.ml"
               : typeSpecifier * cabsloc))
; (fun __caml_parser_env ->
    Obj.repr(
# 1151 "cil/src/frontc/cparser.mly"
                                         ( [] )
# 5209 "cil/src/frontc/cparser.ml"
               : Cabs.field_group list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : spec_elem list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.field_group list) in
    Obj.repr(
# 1153 "cil/src/frontc/cparser.mly"
                                         ( FIELD (fst _1,
                                            [(missingFieldDecl, None)]) :: _3 )
# 5219 "cil/src/frontc/cparser.ml"
               : Cabs.field_group list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.field_group list) in
    Obj.repr(
# 1157 "cil/src/frontc/cparser.mly"
                                         ( _2 )
# 5227 "cil/src/frontc/cparser.ml"
               : Cabs.field_group list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : spec_elem list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : (Cabs.name * expression option) list) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Cabs.field_group list) in
    Obj.repr(
# 1159 "cil/src/frontc/cparser.mly"
                                          ( FIELD (fst _1, _2)
                                            :: _4 )
# 5238 "cil/src/frontc/cparser.ml"
               : Cabs.field_group list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'pragma) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.field_group list) in
    Obj.repr(
# 1162 "cil/src/frontc/cparser.mly"
                                          ( _2 )
# 5246 "cil/src/frontc/cparser.ml"
               : Cabs.field_group list))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.field_group list) in
    Obj.repr(
# 1165 "cil/src/frontc/cparser.mly"
                                          ( _3 )
# 5254 "cil/src/frontc/cparser.ml"
               : Cabs.field_group list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.name * expression option) in
    Obj.repr(
# 1168 "cil/src/frontc/cparser.mly"
                                         ( [_1] )
# 5261 "cil/src/frontc/cparser.ml"
               : (Cabs.name * expression option) list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.name * expression option) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : (Cabs.name * expression option) list) in
    Obj.repr(
# 1169 "cil/src/frontc/cparser.mly"
                                         ( _1 :: _3 )
# 5269 "cil/src/frontc/cparser.ml"
               : (Cabs.name * expression option) list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.name) in
    Obj.repr(
# 1172 "cil/src/frontc/cparser.mly"
                                    ( (_1, None) )
# 5276 "cil/src/frontc/cparser.ml"
               : Cabs.name * expression option))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.name) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression * cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : Cabs.attribute list) in
    Obj.repr(
# 1174 "cil/src/frontc/cparser.mly"
                                    ( let (n,decl,al,loc) = _1 in
                                      let al' = al @ _4 in
                                     ((n,decl,al',loc), Some (fst _3)) )
# 5287 "cil/src/frontc/cparser.ml"
               : Cabs.name * expression option))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.expression * cabsloc) in
    Obj.repr(
# 1177 "cil/src/frontc/cparser.mly"
                                    ( (missingFieldDecl, Some (fst _2)) )
# 5294 "cil/src/frontc/cparser.ml"
               : Cabs.name * expression option))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.enum_item) in
    Obj.repr(
# 1181 "cil/src/frontc/cparser.mly"
                  ([_1])
# 5301 "cil/src/frontc/cparser.ml"
               : Cabs.enum_item list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.enum_item list) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.enum_item) in
    Obj.repr(
# 1182 "cil/src/frontc/cparser.mly"
                                       (_1 @ [_3])
# 5309 "cil/src/frontc/cparser.ml"
               : Cabs.enum_item list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.enum_item list) in
    Obj.repr(
# 1183 "cil/src/frontc/cparser.mly"
                                        ( _1 )
# 5316 "cil/src/frontc/cparser.ml"
               : Cabs.enum_item list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 1186 "cil/src/frontc/cparser.mly"
            ((fst _1, NOTHING, snd _1))
# 5323 "cil/src/frontc/cparser.ml"
               : Cabs.enum_item))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string * Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.expression * cabsloc) in
    Obj.repr(
# 1187 "cil/src/frontc/cparser.mly"
                         ((fst _1, fst _3, snd _1))
# 5331 "cil/src/frontc/cparser.ml"
               : Cabs.enum_item))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : attribute list list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : string * Cabs.decl_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.attribute list) in
    Obj.repr(
# 1193 "cil/src/frontc/cparser.mly"
                               ( let (n, decl) = _2 in
                                (n, applyPointer (fst _1) decl, _3, (snd _1)) )
# 5341 "cil/src/frontc/cparser.ml"
               : Cabs.name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'id_or_typename) in
    Obj.repr(
# 1201 "cil/src/frontc/cparser.mly"
                                   ( (_1, JUSTBASE) )
# 5348 "cil/src/frontc/cparser.ml"
               : string * Cabs.decl_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.attribute list) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.name) in
    Obj.repr(
# 1204 "cil/src/frontc/cparser.mly"
                                   ( let (n,decl,al,_) = _3 in
                                     (n, PARENTYPE(_2,decl,al)) )
# 5358 "cil/src/frontc/cparser.ml"
               : string * Cabs.decl_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : string * Cabs.decl_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Cabs.attribute list) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'comma_expression_opt) in
    Obj.repr(
# 1208 "cil/src/frontc/cparser.mly"
                                   ( let (n, decl) = _1 in
                                     (n, ARRAY(decl, _3, _4)) )
# 5368 "cil/src/frontc/cparser.ml"
               : string * Cabs.decl_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : string * Cabs.decl_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Cabs.attribute list) in
    Obj.repr(
# 1211 "cil/src/frontc/cparser.mly"
                                   ( let (n, decl) = _1 in
                                     (n, ARRAY(decl, _3, NOTHING)) )
# 5377 "cil/src/frontc/cparser.ml"
               : string * Cabs.decl_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : string * Cabs.decl_type) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'parameter_list_startscope) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'rest_par_list) in
    Obj.repr(
# 1214 "cil/src/frontc/cparser.mly"
                                   ( let (n, decl) = _1 in
                                     let (params, isva) = _3 in
                                     !Lexerhack.pop_context ();
                                     (n, PROTO(decl, params, isva))
                                   )
# 5390 "cil/src/frontc/cparser.ml"
               : string * Cabs.decl_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1221 "cil/src/frontc/cparser.mly"
                                   ( !Lexerhack.push_context () )
# 5397 "cil/src/frontc/cparser.ml"
               : 'parameter_list_startscope))
; (fun __caml_parser_env ->
    Obj.repr(
# 1224 "cil/src/frontc/cparser.mly"
                                   ( ([], false) )
# 5403 "cil/src/frontc/cparser.ml"
               : 'rest_par_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.single_name) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'rest_par_list1) in
    Obj.repr(
# 1225 "cil/src/frontc/cparser.mly"
                                   ( let (params, isva) = _2 in
                                     (_1 :: params, isva)
                                   )
# 5413 "cil/src/frontc/cparser.ml"
               : 'rest_par_list))
; (fun __caml_parser_env ->
    Obj.repr(
# 1230 "cil/src/frontc/cparser.mly"
                                        ( ([], false) )
# 5419 "cil/src/frontc/cparser.ml"
               : 'rest_par_list1))
; (fun __caml_parser_env ->
    Obj.repr(
# 1231 "cil/src/frontc/cparser.mly"
                                        ( ([], true) )
# 5425 "cil/src/frontc/cparser.ml"
               : 'rest_par_list1))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.single_name) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'rest_par_list1) in
    Obj.repr(
# 1232 "cil/src/frontc/cparser.mly"
                                        ( let (params, isva) = _3 in
                                          (_2 :: params, isva)
                                        )
# 5435 "cil/src/frontc/cparser.ml"
               : 'rest_par_list1))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : spec_elem list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.name) in
    Obj.repr(
# 1239 "cil/src/frontc/cparser.mly"
                                          ( (fst _1, _2) )
# 5443 "cil/src/frontc/cparser.ml"
               : Cabs.single_name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : spec_elem list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.decl_type * Cabs.attribute list) in
    Obj.repr(
# 1240 "cil/src/frontc/cparser.mly"
                                          ( let d, a = _2 in
                                            (fst _1, ("", d, a, (*CEA*) cabslu)) )
# 5452 "cil/src/frontc/cparser.ml"
               : Cabs.single_name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : spec_elem list * cabsloc) in
    Obj.repr(
# 1242 "cil/src/frontc/cparser.mly"
                                          ( (fst _1, ("", JUSTBASE, [], (*CEA*) cabslu)) )
# 5459 "cil/src/frontc/cparser.ml"
               : Cabs.single_name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.single_name) in
    Obj.repr(
# 1243 "cil/src/frontc/cparser.mly"
                                          ( _2 )
# 5467 "cil/src/frontc/cparser.ml"
               : Cabs.single_name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : attribute list list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'direct_old_proto_decl) in
    Obj.repr(
# 1248 "cil/src/frontc/cparser.mly"
                                      ( let (n, decl, a) = _2 in
					  (n, applyPointer (fst _1) decl,
                                           a, snd _1)
                                      )
# 5478 "cil/src/frontc/cparser.ml"
               : Cabs.name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : string * Cabs.decl_type) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : string list) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'old_pardef_list) in
    Obj.repr(
# 1257 "cil/src/frontc/cparser.mly"
                                   ( let par_decl, isva = doOldParDecl _3 _5 in
                                     let n, decl = _1 in
                                     (n, PROTO(decl, par_decl, isva), [])
                                   )
# 5491 "cil/src/frontc/cparser.ml"
               : 'direct_old_proto_decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string * Cabs.decl_type) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    Obj.repr(
# 1262 "cil/src/frontc/cparser.mly"
                                   ( let n, decl = _1 in
                                     (n, PROTO(decl, [], false), [])
                                   )
# 5501 "cil/src/frontc/cparser.ml"
               : 'direct_old_proto_decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 1277 "cil/src/frontc/cparser.mly"
                                               ( [fst _1] )
# 5508 "cil/src/frontc/cparser.ml"
               : string list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string * Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : string list) in
    Obj.repr(
# 1278 "cil/src/frontc/cparser.mly"
                                               ( let rest = _3 in
                                                 (fst _1 :: rest) )
# 5517 "cil/src/frontc/cparser.ml"
               : string list))
; (fun __caml_parser_env ->
    Obj.repr(
# 1283 "cil/src/frontc/cparser.mly"
                                          ( ([], false) )
# 5523 "cil/src/frontc/cparser.ml"
               : 'old_pardef_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : spec_elem list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'old_pardef) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    Obj.repr(
# 1285 "cil/src/frontc/cparser.mly"
                                          ( ([(fst _1, _2)], true) )
# 5532 "cil/src/frontc/cparser.ml"
               : 'old_pardef_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : spec_elem list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'old_pardef) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'old_pardef_list) in
    Obj.repr(
# 1287 "cil/src/frontc/cparser.mly"
                                          ( let rest, isva = _4 in
                                            ((fst _1, _2) :: rest, isva)
                                          )
# 5544 "cil/src/frontc/cparser.ml"
               : 'old_pardef_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.name) in
    Obj.repr(
# 1293 "cil/src/frontc/cparser.mly"
                                          ( [_1] )
# 5551 "cil/src/frontc/cparser.ml"
               : 'old_pardef))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.name) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'old_pardef) in
    Obj.repr(
# 1294 "cil/src/frontc/cparser.mly"
                                          ( _1 :: _3 )
# 5559 "cil/src/frontc/cparser.ml"
               : 'old_pardef))
; (fun __caml_parser_env ->
    Obj.repr(
# 1295 "cil/src/frontc/cparser.mly"
                                          ( [] )
# 5565 "cil/src/frontc/cparser.ml"
               : 'old_pardef))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.attribute list) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : attribute list list * cabsloc) in
    Obj.repr(
# 1300 "cil/src/frontc/cparser.mly"
                                ( _2 :: fst _3, _1 )
# 5574 "cil/src/frontc/cparser.ml"
               : attribute list list * cabsloc))
; (fun __caml_parser_env ->
    Obj.repr(
# 1303 "cil/src/frontc/cparser.mly"
                                 ( let l = currentLoc () in
                                   ([], l) )
# 5581 "cil/src/frontc/cparser.ml"
               : attribute list list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : attribute list list * cabsloc) in
    Obj.repr(
# 1305 "cil/src/frontc/cparser.mly"
                                 ( _1 )
# 5588 "cil/src/frontc/cparser.ml"
               : attribute list list * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : spec_elem list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.decl_type * Cabs.attribute list) in
    Obj.repr(
# 1309 "cil/src/frontc/cparser.mly"
                               ( let d, a = _2 in
                                 if a <> [] then parse_error "attributes in type name" ;
                                 (fst _1, d)
                               )
# 5599 "cil/src/frontc/cparser.ml"
               : Cabs.spec_elem list * Cabs.decl_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : spec_elem list * cabsloc) in
    Obj.repr(
# 1313 "cil/src/frontc/cparser.mly"
                               ( (fst _1, JUSTBASE) )
# 5606 "cil/src/frontc/cparser.ml"
               : Cabs.spec_elem list * Cabs.decl_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : attribute list list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.decl_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.attribute list) in
    Obj.repr(
# 1316 "cil/src/frontc/cparser.mly"
                                          ( applyPointer (fst _1) _2, _3 )
# 5615 "cil/src/frontc/cparser.ml"
               : Cabs.decl_type * Cabs.attribute list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : attribute list list * cabsloc) in
    Obj.repr(
# 1317 "cil/src/frontc/cparser.mly"
                                          ( applyPointer (fst _1) JUSTBASE, [] )
# 5622 "cil/src/frontc/cparser.ml"
               : Cabs.decl_type * Cabs.attribute list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.attribute list) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.decl_type * Cabs.attribute list) in
    Obj.repr(
# 1324 "cil/src/frontc/cparser.mly"
                                   ( let d, a = _3 in
                                     PARENTYPE (_2, d, a)
                                   )
# 5633 "cil/src/frontc/cparser.ml"
               : Cabs.decl_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    Obj.repr(
# 1329 "cil/src/frontc/cparser.mly"
                                   ( JUSTBASE )
# 5640 "cil/src/frontc/cparser.ml"
               : Cabs.decl_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.decl_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'comma_expression_opt) in
    Obj.repr(
# 1332 "cil/src/frontc/cparser.mly"
                                   ( ARRAY(_1, [], _3) )
# 5648 "cil/src/frontc/cparser.ml"
               : Cabs.decl_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.decl_type) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'parameter_list_startscope) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'rest_par_list) in
    Obj.repr(
# 1335 "cil/src/frontc/cparser.mly"
                                   ( let (params, isva) = _3 in
                                     !Lexerhack.pop_context ();
                                     PROTO (_1, params, isva)
                                   )
# 5660 "cil/src/frontc/cparser.ml"
               : Cabs.decl_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.decl_type) in
    Obj.repr(
# 1341 "cil/src/frontc/cparser.mly"
                                    ( _1 )
# 5667 "cil/src/frontc/cparser.ml"
               : Cabs.decl_type))
; (fun __caml_parser_env ->
    Obj.repr(
# 1342 "cil/src/frontc/cparser.mly"
                                    ( JUSTBASE )
# 5673 "cil/src/frontc/cparser.ml"
               : Cabs.decl_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Lexing.position * string) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : cabsloc * spec_elem list * name) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : Cabs.block * cabsloc * cabsloc) in
    Obj.repr(
# 1346 "cil/src/frontc/cparser.mly"
          (
            let spec =
              try Some (Logic_lexer.spec _1 )
              with Parsing.Parse_error -> None
            in
            let (loc, specs, decl) = _2 in
            currentFunctionName := "<__FUNCTION__ used outside any functions>";
            !Lexerhack.pop_context (); (* The context pushed by
                                    * announceFunctionName *)
            doFunctionDef spec loc (trd3 _3) specs decl (fst3 _3)
          )
# 5692 "cil/src/frontc/cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : cabsloc * spec_elem list * name) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.block * cabsloc * cabsloc) in
    Obj.repr(
# 1358 "cil/src/frontc/cparser.mly"
          ( let (loc, specs, decl) = _1 in
            currentFunctionName := "<__FUNCTION__ used outside any functions>";
            !Lexerhack.pop_context (); (* The context pushed by
                                    * announceFunctionName *)
            doFunctionDef None ((*handleLoc*) loc) (trd3 _2) specs decl (fst3 _2)
          )
# 5705 "cil/src/frontc/cparser.ml"
               : Cabs.definition))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : spec_elem list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.name) in
    Obj.repr(
# 1368 "cil/src/frontc/cparser.mly"
                            ( announceFunctionName _2;
                              (fourth4 _2, fst _1, _2)
                            )
# 5715 "cil/src/frontc/cparser.ml"
               : cabsloc * spec_elem list * name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : spec_elem list * cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.name) in
    Obj.repr(
# 1374 "cil/src/frontc/cparser.mly"
                            ( announceFunctionName _2;
                              (snd _1, fst _1, _2)
                            )
# 5725 "cil/src/frontc/cparser.ml"
               : cabsloc * spec_elem list * name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : string * Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'parameter_list_startscope) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'rest_par_list) in
    Obj.repr(
# 1379 "cil/src/frontc/cparser.mly"
                           ( let (params, isva) = _3 in
                             let fdec =
                               (fst _1, PROTO(JUSTBASE, params, isva), [], snd _1) in
                             announceFunctionName fdec;
                             (* Default is int type *)
                             let defSpec = [SpecType Tint] in
                             (snd _1, defSpec, fdec)
                           )
# 5741 "cil/src/frontc/cparser.ml"
               : cabsloc * spec_elem list * name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : string * Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : string list) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'old_pardef_list) in
    Obj.repr(
# 1390 "cil/src/frontc/cparser.mly"
                           ( (* Convert pardecl to new style *)
                             let pardecl, isva = doOldParDecl _3 _5 in
                             (* Make the function declarator *)
                             let fdec = (fst _1,
                                         PROTO(JUSTBASE, pardecl,isva),
                                         [], snd _1) in
                             announceFunctionName fdec;
                             (* Default is int type *)
                             let defSpec = [SpecType Tint] in
                             (snd _1, defSpec, fdec)
                            )
# 5761 "cil/src/frontc/cparser.ml"
               : cabsloc * spec_elem list * name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string * Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    Obj.repr(
# 1403 "cil/src/frontc/cparser.mly"
                           ( (* Make the function declarator *)
                             let fdec = (fst _1,
                                         PROTO(JUSTBASE, [], false),
                                         [], snd _1) in
                             announceFunctionName fdec;
                             (* Default is int type *)
                             let defSpec = [SpecType Tint] in
                             (snd _1, defSpec, fdec)
                            )
# 5777 "cil/src/frontc/cparser.ml"
               : cabsloc * spec_elem list * name))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1416 "cil/src/frontc/cparser.mly"
                             ( SpecCV(CV_CONST), _1 )
# 5784 "cil/src/frontc/cparser.ml"
               : Cabs.spec_elem * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1417 "cil/src/frontc/cparser.mly"
                             ( SpecCV(CV_VOLATILE), _1 )
# 5791 "cil/src/frontc/cparser.ml"
               : Cabs.spec_elem * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1418 "cil/src/frontc/cparser.mly"
                             ( SpecCV(CV_RESTRICT), _1 )
# 5798 "cil/src/frontc/cparser.ml"
               : Cabs.spec_elem * cabsloc))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 1419 "cil/src/frontc/cparser.mly"
                             ( let annot, loc = _1 in
			       SpecCV(CV_ATTRIBUTE_ANNOT annot), loc )
# 5806 "cil/src/frontc/cparser.ml"
               : Cabs.spec_elem * cabsloc))
; (fun __caml_parser_env ->
    Obj.repr(
# 1425 "cil/src/frontc/cparser.mly"
                   ( [])
# 5812 "cil/src/frontc/cparser.ml"
               : Cabs.attribute list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'attribute) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.attribute list) in
    Obj.repr(
# 1426 "cil/src/frontc/cparser.mly"
                                 ( fst _1 :: _2 )
# 5820 "cil/src/frontc/cparser.ml"
               : Cabs.attribute list))
; (fun __caml_parser_env ->
    Obj.repr(
# 1432 "cil/src/frontc/cparser.mly"
                                        ( [] )
# 5826 "cil/src/frontc/cparser.ml"
               : Cabs.attribute list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'attribute) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.attribute list) in
    Obj.repr(
# 1433 "cil/src/frontc/cparser.mly"
                                        ( fst _1 :: _2 )
# 5834 "cil/src/frontc/cparser.ml"
               : Cabs.attribute list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : string * cabsloc) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : Cabs.attribute list) in
    Obj.repr(
# 1435 "cil/src/frontc/cparser.mly"
                                        ( ("__asm__",
					   [CONSTANT(CONST_STRING (fst _3))]) :: _5 )
# 5845 "cil/src/frontc/cparser.ml"
               : Cabs.attribute list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'paren_attr_list) in
    Obj.repr(
# 1442 "cil/src/frontc/cparser.mly"
                                        ( ("__attribute__", _3), _1 )
# 5854 "cil/src/frontc/cparser.ml"
               : 'attribute_nocv))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'paren_attr_list_ne) in
    Obj.repr(
# 1447 "cil/src/frontc/cparser.mly"
                                        ( ("__declspec", _2), _1 )
# 5862 "cil/src/frontc/cparser.ml"
               : 'attribute_nocv))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 1448 "cil/src/frontc/cparser.mly"
                                        ( (fst _1, []), snd _1 )
# 5869 "cil/src/frontc/cparser.ml"
               : 'attribute_nocv))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1450 "cil/src/frontc/cparser.mly"
                                        ( ("__thread",[]), _1 )
# 5876 "cil/src/frontc/cparser.ml"
               : 'attribute_nocv))
; (fun __caml_parser_env ->
    Obj.repr(
# 1454 "cil/src/frontc/cparser.mly"
                   ( [])
# 5882 "cil/src/frontc/cparser.ml"
               : 'attribute_nocv_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'attribute_nocv) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'attribute_nocv_list) in
    Obj.repr(
# 1455 "cil/src/frontc/cparser.mly"
                                        ( fst _1 :: _2 )
# 5890 "cil/src/frontc/cparser.ml"
               : 'attribute_nocv_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'attribute_nocv) in
    Obj.repr(
# 1460 "cil/src/frontc/cparser.mly"
                          ( _1 )
# 5897 "cil/src/frontc/cparser.ml"
               : 'attribute))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1461 "cil/src/frontc/cparser.mly"
                          ( ("const", []), _1 )
# 5904 "cil/src/frontc/cparser.ml"
               : 'attribute))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1462 "cil/src/frontc/cparser.mly"
                          ( ("restrict",[]), _1 )
# 5911 "cil/src/frontc/cparser.ml"
               : 'attribute))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1463 "cil/src/frontc/cparser.mly"
                          ( ("volatile",[]), _1 )
# 5918 "cil/src/frontc/cparser.ml"
               : 'attribute))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 1464 "cil/src/frontc/cparser.mly"
                          ( let annot, loc = _1 in
			    ("$annot:" ^ annot, []), loc )
# 5926 "cil/src/frontc/cparser.ml"
               : 'attribute))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'paren_attr_list) in
    Obj.repr(
# 1473 "cil/src/frontc/cparser.mly"
                                        ( ("__attribute__", _3) )
# 5935 "cil/src/frontc/cparser.ml"
               : 'just_attribute))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'paren_attr_list_ne) in
    Obj.repr(
# 1474 "cil/src/frontc/cparser.mly"
                                        ( ("__declspec", _2) )
# 5943 "cil/src/frontc/cparser.ml"
               : 'just_attribute))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'just_attribute) in
    Obj.repr(
# 1480 "cil/src/frontc/cparser.mly"
                                        ( [_1] )
# 5950 "cil/src/frontc/cparser.ml"
               : 'just_attributes))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'just_attribute) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'just_attributes) in
    Obj.repr(
# 1481 "cil/src/frontc/cparser.mly"
                                        ( _1 :: _2 )
# 5958 "cil/src/frontc/cparser.ml"
               : 'just_attributes))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'attr) in
    Obj.repr(
# 1486 "cil/src/frontc/cparser.mly"
                          ( PRAGMA (_2, _1) )
# 5966 "cil/src/frontc/cparser.ml"
               : 'pragma))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    Obj.repr(
# 1487 "cil/src/frontc/cparser.mly"
                                   ( PRAGMA (_2, _1) )
# 5975 "cil/src/frontc/cparser.ml"
               : 'pragma))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 1488 "cil/src/frontc/cparser.mly"
                                        ( PRAGMA (VARIABLE (fst _1),
                                                  snd _1) )
# 5983 "cil/src/frontc/cparser.ml"
               : 'pragma))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 1495 "cil/src/frontc/cparser.mly"
             ( VARIABLE (fst _1) )
# 5990 "cil/src/frontc/cparser.ml"
               : 'primary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 1497 "cil/src/frontc/cparser.mly"
                  ( VARIABLE (fst _1) )
# 5997 "cil/src/frontc/cparser.ml"
               : 'primary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'attr) in
    Obj.repr(
# 1498 "cil/src/frontc/cparser.mly"
                                        ( _2 )
# 6005 "cil/src/frontc/cparser.ml"
               : 'primary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : string * Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 1499 "cil/src/frontc/cparser.mly"
                                         ( CALL(VARIABLE (fst _1), [VARIABLE (fst _2)]) )
# 6013 "cil/src/frontc/cparser.ml"
               : 'primary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 1500 "cil/src/frontc/cparser.mly"
                                         ( CONSTANT(CONST_INT (fst _1)) )
# 6020 "cil/src/frontc/cparser.ml"
               : 'primary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * cabsloc) in
    Obj.repr(
# 1501 "cil/src/frontc/cparser.mly"
                                         ( CONSTANT(CONST_STRING (fst _1)) )
# 6027 "cil/src/frontc/cparser.ml"
               : 'primary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1505 "cil/src/frontc/cparser.mly"
                                         ( VARIABLE "aconst" )
# 6034 "cil/src/frontc/cparser.ml"
               : 'primary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string * Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 1507 "cil/src/frontc/cparser.mly"
                                         ( VARIABLE (fst _1 ^ ":" ^ fst _3) )
# 6042 "cil/src/frontc/cparser.ml"
               : 'primary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string * Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 1511 "cil/src/frontc/cparser.mly"
                                         ( VARIABLE (fst _1 ^ ":" ^ fst _3) )
# 6050 "cil/src/frontc/cparser.ml"
               : 'primary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : string * Cabs.cabsloc) in
    Obj.repr(
# 1513 "cil/src/frontc/cparser.mly"
                                         ( VARIABLE ("default:" ^ fst _3) )
# 6058 "cil/src/frontc/cparser.ml"
               : 'primary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Cabs.cabsloc) in
    Obj.repr(
# 1518 "cil/src/frontc/cparser.mly"
                                         ( VARIABLE ("__noreturn__") )
# 6065 "cil/src/frontc/cparser.ml"
               : 'primary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'primary_attr) in
    Obj.repr(
# 1522 "cil/src/frontc/cparser.mly"
                                         ( _1 )
# 6072 "cil/src/frontc/cparser.ml"
               : 'postfix_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string * Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    Obj.repr(
# 1525 "cil/src/frontc/cparser.mly"
                                     ( CALL(VARIABLE (fst _1), [VARIABLE ""]) )
# 6080 "cil/src/frontc/cparser.ml"
               : 'postfix_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : string * Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'paren_attr_list_ne) in
    Obj.repr(
# 1526 "cil/src/frontc/cparser.mly"
                                     ( CALL(VARIABLE (fst _1), _2) )
# 6088 "cil/src/frontc/cparser.ml"
               : 'postfix_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'postfix_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'id_or_typename) in
    Obj.repr(
# 1528 "cil/src/frontc/cparser.mly"
                                         (MEMBEROFPTR (_1, _3))
# 6096 "cil/src/frontc/cparser.ml"
               : 'postfix_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'postfix_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'id_or_typename) in
    Obj.repr(
# 1529 "cil/src/frontc/cparser.mly"
                                         (MEMBEROF (_1, _3))
# 6104 "cil/src/frontc/cparser.ml"
               : 'postfix_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'postfix_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'attr) in
    Obj.repr(
# 1530 "cil/src/frontc/cparser.mly"
                                         (INDEX (_1, _3) )
# 6112 "cil/src/frontc/cparser.ml"
               : 'postfix_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'postfix_attr) in
    Obj.repr(
# 1537 "cil/src/frontc/cparser.mly"
                                         ( _1 )
# 6119 "cil/src/frontc/cparser.ml"
               : 'unary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'unary_expression) in
    Obj.repr(
# 1538 "cil/src/frontc/cparser.mly"
                                         (EXPR_SIZEOF (fst _2) )
# 6127 "cil/src/frontc/cparser.ml"
               : 'unary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.spec_elem list * Cabs.decl_type) in
    Obj.repr(
# 1540 "cil/src/frontc/cparser.mly"
                           (let b, d = _3 in TYPE_SIZEOF (b, d))
# 6136 "cil/src/frontc/cparser.ml"
               : 'unary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'unary_expression) in
    Obj.repr(
# 1542 "cil/src/frontc/cparser.mly"
                                         (EXPR_ALIGNOF (fst _2) )
# 6144 "cil/src/frontc/cparser.ml"
               : 'unary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : Cabs.spec_elem list * Cabs.decl_type) in
    Obj.repr(
# 1543 "cil/src/frontc/cparser.mly"
                                         (let b, d = _3 in TYPE_ALIGNOF (b, d))
# 6153 "cil/src/frontc/cparser.ml"
               : 'unary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'cast_attr) in
    Obj.repr(
# 1544 "cil/src/frontc/cparser.mly"
                                        (UNARY (PLUS, _2))
# 6161 "cil/src/frontc/cparser.ml"
               : 'unary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'cast_attr) in
    Obj.repr(
# 1545 "cil/src/frontc/cparser.mly"
                                        (UNARY (MINUS, _2))
# 6169 "cil/src/frontc/cparser.ml"
               : 'unary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'cast_attr) in
    Obj.repr(
# 1546 "cil/src/frontc/cparser.mly"
                            (UNARY (MEMOF, _2))
# 6177 "cil/src/frontc/cparser.ml"
               : 'unary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'cast_attr) in
    Obj.repr(
# 1548 "cil/src/frontc/cparser.mly"
                                 (UNARY (ADDROF, _2))
# 6185 "cil/src/frontc/cparser.ml"
               : 'unary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'cast_attr) in
    Obj.repr(
# 1549 "cil/src/frontc/cparser.mly"
                                 (UNARY (NOT, _2))
# 6193 "cil/src/frontc/cparser.ml"
               : 'unary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'cast_attr) in
    Obj.repr(
# 1550 "cil/src/frontc/cparser.mly"
                                        (UNARY (BNOT, _2))
# 6201 "cil/src/frontc/cparser.ml"
               : 'unary_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'unary_attr) in
    Obj.repr(
# 1554 "cil/src/frontc/cparser.mly"
                                         ( _1 )
# 6208 "cil/src/frontc/cparser.ml"
               : 'cast_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'cast_attr) in
    Obj.repr(
# 1558 "cil/src/frontc/cparser.mly"
                                        ( _1 )
# 6215 "cil/src/frontc/cparser.ml"
               : 'multiplicative_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'multiplicative_attr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'cast_attr) in
    Obj.repr(
# 1559 "cil/src/frontc/cparser.mly"
                                        (BINARY(MUL ,_1 , _3))
# 6224 "cil/src/frontc/cparser.ml"
               : 'multiplicative_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'multiplicative_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'cast_attr) in
    Obj.repr(
# 1560 "cil/src/frontc/cparser.mly"
                                          (BINARY(DIV ,_1 , _3))
# 6232 "cil/src/frontc/cparser.ml"
               : 'multiplicative_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'multiplicative_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'cast_attr) in
    Obj.repr(
# 1561 "cil/src/frontc/cparser.mly"
                                          (BINARY(MOD ,_1 , _3))
# 6240 "cil/src/frontc/cparser.ml"
               : 'multiplicative_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'multiplicative_attr) in
    Obj.repr(
# 1566 "cil/src/frontc/cparser.mly"
                                        ( _1 )
# 6247 "cil/src/frontc/cparser.ml"
               : 'additive_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'additive_attr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'multiplicative_attr) in
    Obj.repr(
# 1567 "cil/src/frontc/cparser.mly"
                                            (BINARY(ADD ,_1 , _3))
# 6256 "cil/src/frontc/cparser.ml"
               : 'additive_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'additive_attr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'multiplicative_attr) in
    Obj.repr(
# 1568 "cil/src/frontc/cparser.mly"
                                            (BINARY(SUB ,_1 , _3))
# 6265 "cil/src/frontc/cparser.ml"
               : 'additive_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'additive_attr) in
    Obj.repr(
# 1572 "cil/src/frontc/cparser.mly"
                                        ( _1 )
# 6272 "cil/src/frontc/cparser.ml"
               : 'shift_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'shift_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'additive_attr) in
    Obj.repr(
# 1573 "cil/src/frontc/cparser.mly"
                                     (BINARY(SHL ,_1 , _3))
# 6280 "cil/src/frontc/cparser.ml"
               : 'shift_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'shift_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'additive_attr) in
    Obj.repr(
# 1574 "cil/src/frontc/cparser.mly"
                                     (BINARY(SHR ,_1 , _3))
# 6288 "cil/src/frontc/cparser.ml"
               : 'shift_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'shift_attr) in
    Obj.repr(
# 1578 "cil/src/frontc/cparser.mly"
                                        ( _1 )
# 6295 "cil/src/frontc/cparser.ml"
               : 'relational_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'relational_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'shift_attr) in
    Obj.repr(
# 1579 "cil/src/frontc/cparser.mly"
                                   (BINARY(LT ,_1 , _3))
# 6303 "cil/src/frontc/cparser.ml"
               : 'relational_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'relational_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'shift_attr) in
    Obj.repr(
# 1580 "cil/src/frontc/cparser.mly"
                                   (BINARY(GT ,_1 , _3))
# 6311 "cil/src/frontc/cparser.ml"
               : 'relational_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'relational_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'shift_attr) in
    Obj.repr(
# 1581 "cil/src/frontc/cparser.mly"
                                      (BINARY(LE ,_1 , _3))
# 6319 "cil/src/frontc/cparser.ml"
               : 'relational_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'relational_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'shift_attr) in
    Obj.repr(
# 1582 "cil/src/frontc/cparser.mly"
                                      (BINARY(GE ,_1 , _3))
# 6327 "cil/src/frontc/cparser.ml"
               : 'relational_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'relational_attr) in
    Obj.repr(
# 1586 "cil/src/frontc/cparser.mly"
                                        ( _1 )
# 6334 "cil/src/frontc/cparser.ml"
               : 'equality_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'equality_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'relational_attr) in
    Obj.repr(
# 1587 "cil/src/frontc/cparser.mly"
                                            (BINARY(EQ ,_1 , _3))
# 6342 "cil/src/frontc/cparser.ml"
               : 'equality_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'equality_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'relational_attr) in
    Obj.repr(
# 1588 "cil/src/frontc/cparser.mly"
                                            (BINARY(NE ,_1 , _3))
# 6350 "cil/src/frontc/cparser.ml"
               : 'equality_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'equality_attr) in
    Obj.repr(
# 1593 "cil/src/frontc/cparser.mly"
                                        ( _1 )
# 6357 "cil/src/frontc/cparser.ml"
               : 'bitwise_and_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'bitwise_and_attr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'equality_attr) in
    Obj.repr(
# 1594 "cil/src/frontc/cparser.mly"
                                       (BINARY(BAND ,_1 , _3))
# 6366 "cil/src/frontc/cparser.ml"
               : 'bitwise_and_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'bitwise_and_attr) in
    Obj.repr(
# 1598 "cil/src/frontc/cparser.mly"
                                           ( _1 )
# 6373 "cil/src/frontc/cparser.ml"
               : 'bitwise_xor_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'bitwise_xor_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'bitwise_and_attr) in
    Obj.repr(
# 1599 "cil/src/frontc/cparser.mly"
                                           (BINARY(XOR ,_1 , _3))
# 6381 "cil/src/frontc/cparser.ml"
               : 'bitwise_xor_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'bitwise_xor_attr) in
    Obj.repr(
# 1603 "cil/src/frontc/cparser.mly"
                                          ( _1 )
# 6388 "cil/src/frontc/cparser.ml"
               : 'bitwise_or_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'bitwise_or_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'bitwise_xor_attr) in
    Obj.repr(
# 1604 "cil/src/frontc/cparser.mly"
                                          (BINARY(BOR ,_1 , _3))
# 6396 "cil/src/frontc/cparser.ml"
               : 'bitwise_or_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'bitwise_or_attr) in
    Obj.repr(
# 1608 "cil/src/frontc/cparser.mly"
                                                ( _1 )
# 6403 "cil/src/frontc/cparser.ml"
               : 'logical_and_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'logical_and_attr) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'bitwise_or_attr) in
    Obj.repr(
# 1609 "cil/src/frontc/cparser.mly"
                                             (BINARY(AND ,_1 , _3))
# 6412 "cil/src/frontc/cparser.ml"
               : 'logical_and_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'logical_and_attr) in
    Obj.repr(
# 1613 "cil/src/frontc/cparser.mly"
                                               ( _1 )
# 6419 "cil/src/frontc/cparser.ml"
               : 'logical_or_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'logical_or_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'logical_and_attr) in
    Obj.repr(
# 1614 "cil/src/frontc/cparser.mly"
                                               (BINARY(OR ,_1 , _3))
# 6427 "cil/src/frontc/cparser.ml"
               : 'logical_or_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'logical_or_attr) in
    Obj.repr(
# 1618 "cil/src/frontc/cparser.mly"
                                           ( _1 )
# 6434 "cil/src/frontc/cparser.ml"
               : 'conditional_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : 'logical_or_attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'conditional_attr) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'conditional_attr) in
    Obj.repr(
# 1621 "cil/src/frontc/cparser.mly"
                                          ( QUESTION(_1, _3, _5) )
# 6443 "cil/src/frontc/cparser.ml"
               : 'conditional_attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'conditional_attr) in
    Obj.repr(
# 1624 "cil/src/frontc/cparser.mly"
                                          ( _1 )
# 6450 "cil/src/frontc/cparser.ml"
               : 'attr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'attr) in
    Obj.repr(
# 1628 "cil/src/frontc/cparser.mly"
                                         ( [_1] )
# 6457 "cil/src/frontc/cparser.ml"
               : 'attr_list_ne))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'attr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'attr_list_ne) in
    Obj.repr(
# 1629 "cil/src/frontc/cparser.mly"
                                         ( _1 :: _3 )
# 6465 "cil/src/frontc/cparser.ml"
               : 'attr_list_ne))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'attr_list_ne) in
    Obj.repr(
# 1630 "cil/src/frontc/cparser.mly"
                                         ( _3 )
# 6472 "cil/src/frontc/cparser.ml"
               : 'attr_list_ne))
; (fun __caml_parser_env ->
    Obj.repr(
# 1633 "cil/src/frontc/cparser.mly"
                                         ( [] )
# 6478 "cil/src/frontc/cparser.ml"
               : 'attr_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'attr_list_ne) in
    Obj.repr(
# 1634 "cil/src/frontc/cparser.mly"
                                         ( _1 )
# 6485 "cil/src/frontc/cparser.ml"
               : 'attr_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'attr_list_ne) in
    Obj.repr(
# 1637 "cil/src/frontc/cparser.mly"
                                         ( _2 )
# 6493 "cil/src/frontc/cparser.ml"
               : 'paren_attr_list_ne))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    Obj.repr(
# 1638 "cil/src/frontc/cparser.mly"
                                         ( [] )
# 6500 "cil/src/frontc/cparser.ml"
               : 'paren_attr_list_ne))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'attr_list) in
    Obj.repr(
# 1641 "cil/src/frontc/cparser.mly"
                                         ( _2 )
# 6508 "cil/src/frontc/cparser.ml"
               : 'paren_attr_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    Obj.repr(
# 1642 "cil/src/frontc/cparser.mly"
                                         ( [] )
# 6515 "cil/src/frontc/cparser.ml"
               : 'paren_attr_list))
; (fun __caml_parser_env ->
    Obj.repr(
# 1646 "cil/src/frontc/cparser.mly"
                                        ( [] )
# 6521 "cil/src/frontc/cparser.ml"
               : Cabs.attribute list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.attribute list) in
    Obj.repr(
# 1647 "cil/src/frontc/cparser.mly"
                                        ( ("volatile", []) :: _2 )
# 6529 "cil/src/frontc/cparser.ml"
               : Cabs.attribute list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : Cabs.cabsloc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : Cabs.attribute list) in
    Obj.repr(
# 1648 "cil/src/frontc/cparser.mly"
                                        ( ("const", []) :: _2 )
# 6537 "cil/src/frontc/cparser.ml"
               : Cabs.attribute list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'one_string_constant) in
    Obj.repr(
# 1651 "cil/src/frontc/cparser.mly"
                                                 ( [_1] )
# 6544 "cil/src/frontc/cparser.ml"
               : 'asmtemplate))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'one_string_constant) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'asmtemplate) in
    Obj.repr(
# 1652 "cil/src/frontc/cparser.mly"
                                                 ( _1 :: _2 )
# 6552 "cil/src/frontc/cparser.ml"
               : 'asmtemplate))
; (fun __caml_parser_env ->
    Obj.repr(
# 1655 "cil/src/frontc/cparser.mly"
                        ( None )
# 6558 "cil/src/frontc/cparser.ml"
               : 'asmoutputs))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'asmoperands) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'asminputs) in
    Obj.repr(
# 1657 "cil/src/frontc/cparser.mly"
                        ( let (ins, clobs) = _3 in
                          Some {aoutputs = _2; ainputs = ins; aclobbers = clobs} )
# 6567 "cil/src/frontc/cparser.ml"
               : 'asmoutputs))
; (fun __caml_parser_env ->
    Obj.repr(
# 1661 "cil/src/frontc/cparser.mly"
                                        ( [] )
# 6573 "cil/src/frontc/cparser.ml"
               : 'asmoperands))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'asmoperandsne) in
    Obj.repr(
# 1662 "cil/src/frontc/cparser.mly"
                                        ( List.rev _1 )
# 6580 "cil/src/frontc/cparser.ml"
               : 'asmoperands))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'asmoperand) in
    Obj.repr(
# 1665 "cil/src/frontc/cparser.mly"
                                        ( [_1] )
# 6587 "cil/src/frontc/cparser.ml"
               : 'asmoperandsne))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'asmoperandsne) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'asmoperand) in
    Obj.repr(
# 1666 "cil/src/frontc/cparser.mly"
                                        ( _3 :: _1 )
# 6595 "cil/src/frontc/cparser.ml"
               : 'asmoperandsne))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : 'asmopname) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : string * cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : Cabs.expression * cabsloc) in
    Obj.repr(
# 1669 "cil/src/frontc/cparser.mly"
                                                           ( (_1, fst _2, fst _4) )
# 6605 "cil/src/frontc/cparser.ml"
               : 'asmoperand))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : 'asmopname) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : string * cabsloc) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : Cabs.cabsloc) in
    Obj.repr(
# 1670 "cil/src/frontc/cparser.mly"
                                                           ( (_1, fst _2, NOTHING ) )
# 6614 "cil/src/frontc/cparser.ml"
               : 'asmoperand))
; (fun __caml_parser_env ->
    Obj.repr(
# 1673 "cil/src/frontc/cparser.mly"
                             ( ([], []) )
# 6620 "cil/src/frontc/cparser.ml"
               : 'asminputs))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'asmoperands) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'asmclobber) in
    Obj.repr(
# 1675 "cil/src/frontc/cparser.mly"
                        ( (_2, _3) )
# 6628 "cil/src/frontc/cparser.ml"
               : 'asminputs))
; (fun __caml_parser_env ->
    Obj.repr(
# 1678 "cil/src/frontc/cparser.mly"
                                        ( None )
# 6634 "cil/src/frontc/cparser.ml"
               : 'asmopname))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : string * Cabs.cabsloc) in
    Obj.repr(
# 1679 "cil/src/frontc/cparser.mly"
                                        ( Some (fst _2) )
# 6641 "cil/src/frontc/cparser.ml"
               : 'asmopname))
; (fun __caml_parser_env ->
    Obj.repr(
# 1683 "cil/src/frontc/cparser.mly"
                                        ( [] )
# 6647 "cil/src/frontc/cparser.ml"
               : 'asmclobber))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'asmcloberlst_ne) in
    Obj.repr(
# 1684 "cil/src/frontc/cparser.mly"
                                        ( _2 )
# 6654 "cil/src/frontc/cparser.ml"
               : 'asmclobber))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'one_string_constant) in
    Obj.repr(
# 1687 "cil/src/frontc/cparser.mly"
                                                 ( [_1] )
# 6661 "cil/src/frontc/cparser.ml"
               : 'asmcloberlst_ne))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'one_string_constant) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'asmcloberlst_ne) in
    Obj.repr(
# 1688 "cil/src/frontc/cparser.mly"
                                                 ( _1 :: _3 )
# 6669 "cil/src/frontc/cparser.ml"
               : 'asmcloberlst_ne))
; (fun __caml_parser_env ->
    Obj.repr(
# 1693 "cil/src/frontc/cparser.mly"
              ( currentLoc () )
# 6675 "cil/src/frontc/cparser.ml"
               : 'get_current_loc))
(* Entry interpret *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
(* Entry file *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
|]
let yytables =
  { Parsing.actions=yyact;
    Parsing.transl_const=yytransl_const;
    Parsing.transl_block=yytransl_block;
    Parsing.lhs=yylhs;
    Parsing.len=yylen;
    Parsing.defred=yydefred;
    Parsing.dgoto=yydgoto;
    Parsing.sindex=yysindex;
    Parsing.rindex=yyrindex;
    Parsing.gindex=yygindex;
    Parsing.tablesize=yytablesize;
    Parsing.table=yytable;
    Parsing.check=yycheck;
    Parsing.error_function=parse_error;
    Parsing.names_const=yynames_const;
    Parsing.names_block=yynames_block }
let interpret (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 1 lexfun lexbuf : (bool*Cabs.definition) list)
let file (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 2 lexfun lexbuf : (bool*Cabs.definition) list)
;;
