type token =
  | IDENTIFIER of (string)
  | TYPENAME of (string)
  | STRING_LITERAL of (bool*string)
  | CONSTANT of (Logic_ptree.constant)
  | LPAR
  | RPAR
  | IF
  | ELSE
  | COLON
  | COLON2
  | COLONCOLON
  | DOT
  | DOTDOT
  | DOTDOTDOT
  | INT
  | INTEGER
  | REAL
  | BOOLEAN
  | FLOAT
  | LT
  | GT
  | LE
  | GE
  | EQ
  | NE
  | COMMA
  | ARROW
  | EQUAL
  | FORALL
  | EXISTS
  | IFF
  | IMPLIES
  | AND
  | OR
  | NOT
  | SEPARATED
  | TRUE
  | FALSE
  | OLD
  | AT
  | RESULT
  | BLOCK_LENGTH
  | BASE_ADDR
  | VALID
  | VALID_INDEX
  | VALID_RANGE
  | FRESH
  | DOLLAR
  | QUESTION
  | MINUS
  | PLUS
  | STAR
  | AMP
  | SLASH
  | PERCENT
  | LSQUARE
  | RSQUARE
  | EOF
  | GLOBAL
  | INVARIANT
  | VARIANT
  | DECREASES
  | FOR
  | LABEL
  | ASSERT
  | SEMICOLON
  | NULL
  | EMPTY
  | REQUIRES
  | ENSURES
  | ASSIGNS
  | LOOP
  | NOTHING
  | SLICE
  | IMPACT
  | PRAGMA
  | FROM
  | EXITS
  | BREAKS
  | CONTINUES
  | RETURNS
  | READS
  | LOGIC
  | PREDICATE
  | INDUCTIVE
  | AXIOMATIC
  | AXIOM
  | LEMMA
  | LBRACE
  | RBRACE
  | GHOST
  | CASE
  | VOID
  | CHAR
  | SIGNED
  | UNSIGNED
  | SHORT
  | LONG
  | DOUBLE
  | STRUCT
  | ENUM
  | UNION
  | BSUNION
  | INTER
  | LTCOLON
  | COLONGT
  | TYPE
  | BEHAVIOR
  | BEHAVIORS
  | ASSUMES
  | COMPLETE
  | DISJOINT
  | TERMINATES
  | HAT
  | HATHAT
  | PIPE
  | TILDE
  | GTGT
  | LTLT
  | SIZEOF
  | LAMBDA
  | LET
  | TYPEOF
  | BSTYPE

open Parsing;;
# 28 "cil/src/logic/logic_parser.mly"

  open Cil
  open Cil_types
  open Logic_ptree
  open Logic_const
  open Logic_utils

  let loc () = (symbol_start_pos (), symbol_end_pos ())
  let loc_i i = (rhs_start i, rhs_end i)
  let info x = { lexpr_node = x; lexpr_loc = loc () }
  let loc_info loc x = { lexpr_node = x; lexpr_loc = loc }
  let loc_start x = fst x.lexpr_loc
  let loc_end x = snd x.lexpr_loc

  type sense_of_relation = Unknown | Equal | Disequal | Less | Greater

  let relation_sense rel sense =
    match rel, sense with
        Eq, _ -> sense, true
      | Neq, Unknown -> Disequal, true (* No chain of disequality for now*)
      | (Gt|Ge), (Unknown|Equal|Greater) -> Greater, true
      | (Lt|Le), (Unknown|Equal|Less) -> Less, true
      | _ -> sense, false

  let type_variables_stack = Stack.create ()

  let enter_type_variables_scope l =
    List.iter Logic_env.add_typename l;
    Stack.push l type_variables_stack

  let exit_type_variables_scope () =
    let l = Stack.pop type_variables_stack in
    List.iter Logic_env.remove_typename l

  let rt_type = ref false

  let set_rt_type () = rt_type:= true

  let reset_rt_type () = rt_type:=false

  let is_rt_type () = !rt_type

  let loc_decl d = { decl_node = d; decl_loc = loc () }

# 174 "cil/src/logic/logic_parser.ml"
let yytransl_const = [|
  261 (* LPAR *);
  262 (* RPAR *);
  263 (* IF *);
  264 (* ELSE *);
  265 (* COLON *);
  266 (* COLON2 *);
  267 (* COLONCOLON *);
  268 (* DOT *);
  269 (* DOTDOT *);
  270 (* DOTDOTDOT *);
  271 (* INT *);
  272 (* INTEGER *);
  273 (* REAL *);
  274 (* BOOLEAN *);
  275 (* FLOAT *);
  276 (* LT *);
  277 (* GT *);
  278 (* LE *);
  279 (* GE *);
  280 (* EQ *);
  281 (* NE *);
  282 (* COMMA *);
  283 (* ARROW *);
  284 (* EQUAL *);
  285 (* FORALL *);
  286 (* EXISTS *);
  287 (* IFF *);
  288 (* IMPLIES *);
  289 (* AND *);
  290 (* OR *);
  291 (* NOT *);
  292 (* SEPARATED *);
  293 (* TRUE *);
  294 (* FALSE *);
  295 (* OLD *);
  296 (* AT *);
  297 (* RESULT *);
  298 (* BLOCK_LENGTH *);
  299 (* BASE_ADDR *);
  300 (* VALID *);
  301 (* VALID_INDEX *);
  302 (* VALID_RANGE *);
  303 (* FRESH *);
  304 (* DOLLAR *);
  305 (* QUESTION *);
  306 (* MINUS *);
  307 (* PLUS *);
  308 (* STAR *);
  309 (* AMP *);
  310 (* SLASH *);
  311 (* PERCENT *);
  312 (* LSQUARE *);
  313 (* RSQUARE *);
    0 (* EOF *);
  314 (* GLOBAL *);
  315 (* INVARIANT *);
  316 (* VARIANT *);
  317 (* DECREASES *);
  318 (* FOR *);
  319 (* LABEL *);
  320 (* ASSERT *);
  321 (* SEMICOLON *);
  322 (* NULL *);
  323 (* EMPTY *);
  324 (* REQUIRES *);
  325 (* ENSURES *);
  326 (* ASSIGNS *);
  327 (* LOOP *);
  328 (* NOTHING *);
  329 (* SLICE *);
  330 (* IMPACT *);
  331 (* PRAGMA *);
  332 (* FROM *);
  333 (* EXITS *);
  334 (* BREAKS *);
  335 (* CONTINUES *);
  336 (* RETURNS *);
  337 (* READS *);
  338 (* LOGIC *);
  339 (* PREDICATE *);
  340 (* INDUCTIVE *);
  341 (* AXIOMATIC *);
  342 (* AXIOM *);
  343 (* LEMMA *);
  344 (* LBRACE *);
  345 (* RBRACE *);
  346 (* GHOST *);
  347 (* CASE *);
  348 (* VOID *);
  349 (* CHAR *);
  350 (* SIGNED *);
  351 (* UNSIGNED *);
  352 (* SHORT *);
  353 (* LONG *);
  354 (* DOUBLE *);
  355 (* STRUCT *);
  356 (* ENUM *);
  357 (* UNION *);
  358 (* BSUNION *);
  359 (* INTER *);
  360 (* LTCOLON *);
  361 (* COLONGT *);
  362 (* TYPE *);
  363 (* BEHAVIOR *);
  364 (* BEHAVIORS *);
  365 (* ASSUMES *);
  366 (* COMPLETE *);
  367 (* DISJOINT *);
  368 (* TERMINATES *);
  369 (* HAT *);
  370 (* HATHAT *);
  371 (* PIPE *);
  372 (* TILDE *);
  373 (* GTGT *);
  374 (* LTLT *);
  375 (* SIZEOF *);
  376 (* LAMBDA *);
  377 (* LET *);
  378 (* TYPEOF *);
  379 (* BSTYPE *);
    0|]

let yytransl_block = [|
  257 (* IDENTIFIER *);
  258 (* TYPENAME *);
  259 (* STRING_LITERAL *);
  260 (* CONSTANT *);
    0|]

let yylhs = "\255\255\
\004\000\005\000\006\000\007\000\008\000\009\000\010\000\010\000\
\011\000\011\000\013\000\013\000\015\000\015\000\015\000\015\000\
\015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
\015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
\015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
\015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
\015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
\015\000\015\000\015\000\015\000\015\000\015\000\015\000\015\000\
\017\000\017\000\025\000\025\000\025\000\025\000\025\000\025\000\
\025\000\019\000\001\000\012\000\012\000\012\000\012\000\012\000\
\012\000\012\000\012\000\012\000\012\000\012\000\012\000\014\000\
\014\000\014\000\014\000\014\000\016\000\016\000\026\000\026\000\
\024\000\027\000\027\000\027\000\028\000\029\000\029\000\032\000\
\032\000\030\000\030\000\030\000\030\000\033\000\033\000\033\000\
\034\000\034\000\035\000\036\000\037\000\037\000\038\000\038\000\
\020\000\040\000\040\000\039\000\039\000\041\000\041\000\041\000\
\041\000\041\000\041\000\041\000\043\000\043\000\031\000\031\000\
\042\000\042\000\023\000\023\000\023\000\023\000\023\000\023\000\
\023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
\023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
\023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
\023\000\023\000\023\000\023\000\044\000\044\000\045\000\046\000\
\047\000\049\000\050\000\051\000\052\000\053\000\054\000\055\000\
\055\000\057\000\057\000\058\000\058\000\060\000\060\000\060\000\
\060\000\060\000\059\000\059\000\059\000\061\000\061\000\062\000\
\063\000\064\000\064\000\065\000\065\000\066\000\066\000\067\000\
\067\000\067\000\003\000\069\000\069\000\069\000\069\000\069\000\
\069\000\069\000\069\000\069\000\069\000\069\000\070\000\071\000\
\071\000\071\000\071\000\071\000\073\000\073\000\077\000\078\000\
\078\000\072\000\075\000\068\000\068\000\079\000\079\000\079\000\
\079\000\079\000\082\000\076\000\083\000\080\000\080\000\081\000\
\081\000\074\000\056\000\056\000\056\000\084\000\085\000\085\000\
\086\000\087\000\087\000\088\000\089\000\089\000\089\000\018\000\
\048\000\048\000\091\000\091\000\092\000\093\000\093\000\093\000\
\093\000\094\000\094\000\094\000\094\000\094\000\094\000\095\000\
\095\000\095\000\097\000\097\000\100\000\100\000\100\000\100\000\
\100\000\099\000\101\000\101\000\101\000\098\000\098\000\103\000\
\103\000\102\000\102\000\104\000\104\000\105\000\105\000\096\000\
\096\000\022\000\022\000\090\000\090\000\021\000\002\000\107\000\
\107\000\106\000\106\000\106\000\106\000\106\000\108\000\108\000\
\109\000\109\000\109\000\109\000\109\000\109\000\109\000\109\000\
\109\000\109\000\109\000\109\000\109\000\109\000\109\000\109\000\
\109\000\109\000\109\000\109\000\109\000\109\000\109\000\109\000\
\109\000\109\000\109\000\109\000\109\000\109\000\109\000\109\000\
\109\000\109\000\109\000\109\000\109\000\109\000\109\000\109\000\
\109\000\109\000\109\000\109\000\109\000\109\000\109\000\109\000\
\109\000\109\000\109\000\109\000\109\000\109\000\109\000\109\000\
\109\000\109\000\109\000\109\000\109\000\109\000\109\000\109\000\
\109\000\109\000\109\000\109\000\109\000\109\000\109\000\109\000\
\109\000\109\000\109\000\109\000\109\000\109\000\109\000\109\000\
\109\000\109\000\109\000\109\000\109\000\109\000\109\000\109\000\
\109\000\109\000\109\000\109\000\109\000\109\000\109\000\109\000\
\109\000\109\000\109\000\109\000\109\000\109\000\109\000\109\000\
\109\000\109\000\109\000\109\000\109\000\109\000\109\000\109\000\
\109\000\109\000\109\000\109\000\109\000\109\000\000\000\000\000\
\000\000"

let yylen = "\002\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\
\001\000\003\000\001\000\002\000\001\000\002\000\001\000\001\000\
\004\000\006\000\008\000\004\000\001\000\001\000\003\000\003\000\
\003\000\003\000\003\000\003\000\003\000\004\000\004\000\002\000\
\002\000\002\000\002\000\002\000\004\000\004\000\004\000\006\000\
\004\000\004\000\001\000\004\000\004\000\007\000\004\000\001\000\
\003\000\003\000\003\000\003\000\004\000\003\000\003\000\003\000\
\004\000\005\000\001\000\004\000\004\000\005\000\007\000\007\000\
\001\000\002\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\003\000\002\000\003\000\003\000\003\000\003\000\003\000\
\003\000\003\000\003\000\005\000\003\000\003\000\001\000\001\000\
\006\000\004\000\004\000\004\000\002\000\003\000\000\000\001\000\
\001\000\001\000\003\000\003\000\002\000\001\000\002\000\001\000\
\000\000\001\000\004\000\003\000\004\000\000\000\001\000\003\000\
\001\000\003\000\001\000\001\000\001\000\003\000\002\000\002\000\
\002\000\001\000\003\000\000\000\001\000\001\000\001\000\002\000\
\002\000\003\000\002\000\001\000\003\000\004\000\001\000\002\000\
\003\000\004\000\001\000\001\000\001\000\001\000\001\000\002\000\
\002\000\001\000\002\000\002\000\001\000\001\000\002\000\002\000\
\001\000\002\000\002\000\003\000\002\000\003\000\002\000\003\000\
\003\000\003\000\004\000\004\000\001\000\001\000\002\000\003\000\
\003\000\003\000\001\000\006\000\001\000\004\000\003\000\003\000\
\003\000\003\000\003\000\003\000\003\000\003\000\003\000\001\000\
\001\000\000\000\004\000\000\000\001\000\001\000\001\000\001\000\
\001\000\001\000\004\000\004\000\004\000\000\000\005\000\001\000\
\002\000\000\000\003\000\001\000\003\000\000\000\001\000\000\000\
\005\000\005\000\006\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\002\000\
\002\000\004\000\002\000\002\000\000\000\001\000\009\000\003\000\
\001\000\004\000\004\000\000\000\003\000\001\000\001\000\006\000\
\003\000\003\000\002\000\004\000\002\000\004\000\003\000\005\000\
\004\000\004\000\001\000\003\000\003\000\001\000\001\000\003\000\
\001\000\001\000\004\000\001\000\001\000\004\000\007\000\001\000\
\001\000\001\000\000\000\001\000\003\000\001\000\001\000\006\000\
\001\000\007\000\006\000\006\000\005\000\005\000\005\000\005\000\
\004\000\003\000\000\000\002\000\001\000\006\000\005\000\003\000\
\005\000\001\000\000\000\002\000\002\000\001\000\001\000\000\000\
\003\000\002\000\003\000\001\000\004\000\001\000\003\000\000\000\
\006\000\001\000\003\000\001\000\003\000\001\000\002\000\001\000\
\002\000\001\000\002\000\001\000\001\000\001\000\001\000\002\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\002\000\002\000\
\002\000"

let yydefred = "\000\000\
\000\000\000\000\000\000\000\000\008\001\000\000\065\000\022\000\
\000\000\000\000\000\000\000\000\000\000\015\000\016\000\000\000\
\000\000\043\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\021\000\059\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\183\001\
\000\000\087\000\011\000\000\000\000\000\000\000\062\001\000\000\
\001\000\220\000\001\000\001\000\212\000\214\000\219\000\000\000\
\000\000\000\000\215\000\216\000\217\000\218\000\001\000\001\000\
\001\000\001\000\001\000\000\000\213\000\222\000\221\000\184\001\
\000\000\060\001\223\000\000\000\000\000\000\000\000\000\017\001\
\061\001\238\000\239\000\000\000\000\000\000\000\014\001\015\001\
\000\000\058\001\001\000\185\001\000\000\000\000\000\000\146\000\
\139\000\140\000\141\000\165\000\142\000\143\000\000\000\000\000\
\150\000\000\000\166\000\004\000\004\000\004\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\098\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\075\000\
\000\000\000\000\000\000\000\000\067\000\068\000\069\000\070\000\
\071\000\072\000\000\000\073\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\012\000\000\000\
\066\000\000\000\000\000\001\000\001\000\000\000\000\000\000\000\
\000\000\000\000\000\000\001\000\001\000\001\000\243\000\245\000\
\000\000\000\000\001\000\000\000\000\000\005\001\000\000\000\000\
\000\000\000\000\001\000\000\000\000\000\000\000\065\001\067\001\
\066\001\068\001\069\001\070\001\071\001\072\001\073\001\074\001\
\075\001\076\001\077\001\078\001\079\001\080\001\081\001\082\001\
\083\001\084\001\085\001\086\001\087\001\088\001\089\001\090\001\
\091\001\092\001\093\001\094\001\095\001\096\001\097\001\098\001\
\177\001\099\001\100\001\101\001\102\001\103\001\104\001\105\001\
\106\001\107\001\108\001\109\001\110\001\111\001\112\001\113\001\
\114\001\115\001\116\001\117\001\118\001\119\001\120\001\121\001\
\122\001\123\001\124\001\125\001\126\001\127\001\128\001\129\001\
\130\001\131\001\132\001\133\001\134\001\135\001\136\001\137\001\
\178\001\180\001\181\001\179\001\138\001\139\001\140\001\141\001\
\142\001\143\001\144\001\145\001\146\001\147\001\148\001\149\001\
\150\001\151\001\152\001\153\001\154\001\155\001\156\001\157\001\
\158\001\159\001\160\001\161\001\171\001\162\001\170\001\172\001\
\173\001\163\001\164\001\165\001\166\001\167\001\168\001\169\001\
\174\001\182\001\175\001\176\001\059\001\000\000\001\000\230\000\
\224\000\225\000\227\000\228\000\001\000\000\000\057\001\055\001\
\000\000\000\000\000\000\000\000\003\000\147\000\144\000\151\000\
\000\000\148\000\145\000\152\000\000\000\157\000\000\000\167\000\
\000\000\000\000\000\000\051\000\052\000\000\000\000\000\135\000\
\000\000\000\000\121\000\125\000\126\000\000\000\000\000\000\000\
\106\000\101\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\008\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\081\000\000\000\000\000\000\000\029\000\028\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\055\000\000\000\000\000\093\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\242\000\009\001\010\001\002\000\001\000\
\000\000\241\000\000\000\000\000\000\000\000\000\000\000\000\000\
\122\000\000\000\002\000\000\000\002\000\001\000\001\000\001\000\
\000\000\012\001\000\000\000\000\001\000\000\000\026\001\000\000\
\064\001\000\000\000\000\000\000\247\000\000\000\000\000\000\000\
\001\000\000\000\000\000\156\000\000\000\158\000\000\000\162\000\
\168\000\169\000\170\000\000\000\000\000\104\000\000\000\136\000\
\128\000\000\000\000\000\131\000\000\000\074\000\000\000\000\000\
\000\000\000\000\000\000\099\000\100\000\000\000\045\000\000\000\
\039\000\001\000\042\000\041\000\017\000\000\000\000\000\020\000\
\000\000\000\000\060\000\061\000\037\000\038\000\000\000\000\000\
\057\000\000\000\000\000\031\000\030\000\094\000\044\000\000\000\
\001\000\001\000\175\000\177\000\205\000\001\000\226\000\234\000\
\001\000\235\000\185\000\000\000\002\000\184\000\000\000\254\000\
\000\000\250\000\249\000\000\000\006\000\182\000\000\000\176\000\
\000\000\000\000\054\001\000\000\000\000\000\000\001\000\025\001\
\000\000\001\000\001\000\001\000\001\000\029\001\000\000\000\000\
\034\001\000\000\001\000\001\000\000\000\000\000\039\001\000\000\
\038\001\000\000\000\000\002\000\244\000\246\000\187\000\203\000\
\000\000\190\000\001\000\191\000\192\000\193\000\194\000\001\000\
\200\000\189\000\001\000\000\000\000\000\000\000\000\000\163\000\
\164\000\133\000\000\000\130\000\115\000\000\000\000\000\113\000\
\108\000\000\000\000\000\010\000\000\000\000\000\000\000\000\000\
\000\000\062\000\000\000\058\000\000\000\000\000\051\001\000\000\
\000\000\232\000\183\000\000\000\000\000\248\000\123\000\001\000\
\024\001\003\001\001\000\000\000\116\000\000\000\000\000\002\000\
\000\000\013\001\000\000\001\000\000\000\001\000\000\000\000\000\
\000\000\022\001\028\001\021\001\000\000\000\000\000\000\002\000\
\001\000\023\001\001\000\042\001\180\000\237\000\000\000\000\000\
\000\000\001\000\201\000\000\000\000\000\000\000\003\000\004\000\
\138\000\134\000\000\000\109\000\107\000\040\000\018\000\000\000\
\000\000\000\000\000\000\000\000\016\001\240\000\253\000\252\000\
\000\001\000\000\053\001\001\000\119\000\120\000\178\000\000\000\
\019\001\000\000\020\001\000\000\000\000\001\000\032\001\002\000\
\000\000\043\001\181\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\211\000\000\000\172\000\
\112\000\114\000\000\000\064\000\063\000\046\000\018\001\000\000\
\118\000\000\000\000\000\000\000\000\000\000\000\179\000\001\000\
\001\000\045\001\041\001\197\000\195\000\196\000\000\000\207\000\
\000\000\000\000\174\000\019\000\007\001\000\000\000\000\037\001\
\036\001\031\001\033\001\000\000\047\001\000\000\000\000\000\000\
\000\000\030\001\231\000\199\000\209\000\210\000\049\001"

let yydgoto = "\004\000\
\040\000\072\000\092\000\196\000\011\002\211\001\097\001\186\001\
\111\002\132\001\133\001\121\001\042\000\043\000\044\000\175\000\
\045\000\046\000\112\000\085\002\034\002\168\001\114\000\118\000\
\176\000\115\000\119\000\120\000\114\001\115\001\116\001\223\001\
\086\002\087\002\088\002\119\002\120\002\121\002\107\001\187\001\
\108\001\109\001\110\001\079\002\180\001\197\000\185\000\175\001\
\038\002\134\002\204\001\189\002\195\000\183\001\021\002\022\002\
\093\000\073\002\074\002\075\002\147\002\076\002\077\002\083\001\
\224\002\225\002\150\002\210\001\073\000\074\000\072\001\076\000\
\015\002\077\000\078\000\079\000\080\000\181\001\081\000\082\000\
\083\000\084\000\085\000\023\002\024\002\025\002\198\000\206\000\
\199\000\036\002\193\001\194\001\086\000\087\000\088\000\125\002\
\047\002\056\002\048\002\049\002\213\002\057\002\140\002\058\002\
\190\002\089\000\090\000\069\001\070\001"

let yysindex = "\233\000\
\229\015\052\017\240\254\000\000\000\000\065\255\000\000\000\000\
\244\013\077\014\077\014\252\016\049\255\000\000\000\000\076\255\
\181\255\000\000\191\255\195\255\199\255\203\255\252\255\006\000\
\252\016\252\016\252\016\252\016\000\000\000\000\229\015\030\000\
\045\000\252\016\050\000\077\014\062\000\065\000\068\000\000\000\
\035\000\000\000\000\000\091\008\039\000\075\255\000\000\038\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\036\000\
\005\000\032\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\040\000\000\000\000\000\000\000\000\000\
\121\013\000\000\000\000\005\255\005\255\005\255\005\255\000\000\
\000\000\000\000\000\000\088\000\108\000\234\000\000\000\000\000\
\113\001\000\000\000\000\000\000\003\000\229\015\024\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\080\255\136\255\
\000\000\068\255\000\000\000\000\000\000\000\000\057\255\114\000\
\115\000\020\000\101\000\111\000\063\255\075\000\113\000\000\000\
\082\000\031\255\050\255\229\015\229\015\229\015\229\015\229\015\
\229\015\229\015\229\015\229\015\031\255\031\255\031\255\031\255\
\011\007\229\015\229\015\031\255\244\013\099\000\138\000\229\015\
\077\014\229\015\229\015\229\015\229\015\229\015\229\015\000\000\
\229\015\229\015\229\015\062\000\000\000\000\000\000\000\000\000\
\000\000\000\000\062\000\000\000\252\016\252\016\252\016\252\016\
\252\016\229\015\252\016\097\014\252\016\252\016\000\000\163\016\
\000\000\229\015\229\015\000\000\000\000\229\015\102\000\045\255\
\143\000\161\000\109\000\000\000\000\000\000\000\000\000\000\000\
\126\000\174\000\000\000\062\000\016\255\000\000\175\000\175\000\
\094\000\182\000\000\000\163\000\128\000\171\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\121\013\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\135\000\000\000\000\000\
\137\000\229\015\145\000\077\010\000\000\000\000\000\000\000\000\
\058\255\000\000\000\000\000\000\083\255\000\000\194\000\000\000\
\062\000\062\000\062\000\000\000\000\000\252\016\020\000\000\000\
\206\000\023\000\000\000\000\000\000\000\249\255\229\015\063\255\
\000\000\000\000\008\000\004\000\229\015\002\015\229\015\207\000\
\248\001\088\255\202\003\243\255\083\003\062\004\071\004\071\006\
\175\004\062\000\244\013\208\000\000\000\209\000\038\005\210\000\
\229\015\229\015\217\005\170\000\029\003\029\003\140\255\070\255\
\235\002\000\000\173\000\172\255\004\255\000\000\000\000\167\255\
\167\255\031\255\031\255\031\255\038\007\166\000\031\255\031\255\
\000\000\107\000\107\000\000\000\091\008\225\000\077\010\144\000\
\211\000\223\000\077\010\000\000\000\000\000\000\000\000\000\000\
\041\000\000\000\177\000\178\000\185\000\200\014\186\000\188\000\
\000\000\077\014\000\000\175\000\000\000\000\000\000\000\000\000\
\159\255\000\000\147\000\053\002\000\000\249\000\000\000\124\000\
\000\000\246\000\229\015\191\000\000\000\196\000\240\254\185\007\
\000\000\046\001\077\014\000\000\247\000\000\000\250\000\000\000\
\000\000\000\000\000\000\031\255\002\001\000\000\212\000\000\000\
\000\000\249\255\077\014\000\000\077\010\000\000\006\001\077\014\
\206\000\008\000\077\010\000\000\000\000\077\010\000\000\229\015\
\000\000\000\000\000\000\000\000\000\000\229\015\229\015\000\000\
\242\000\233\254\000\000\000\000\000\000\000\000\077\010\039\008\
\000\000\010\001\229\015\000\000\000\000\000\000\000\000\012\001\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\077\010\000\000\000\000\198\000\000\000\
\251\000\000\000\000\000\213\000\000\000\000\000\161\255\000\000\
\255\000\254\000\000\000\192\000\161\002\021\001\000\000\000\000\
\197\000\000\000\000\000\000\000\000\000\000\000\200\000\053\002\
\000\000\222\000\000\000\000\000\161\002\033\001\000\000\232\000\
\000\000\183\000\005\255\000\000\000\000\000\000\000\000\000\000\
\235\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\201\000\237\255\022\001\028\001\000\000\
\000\000\000\000\253\000\000\000\000\000\048\001\038\001\000\000\
\000\000\053\001\014\001\000\000\061\001\001\006\222\006\229\015\
\229\015\000\000\229\015\000\000\077\010\229\015\000\000\007\001\
\009\001\000\000\000\000\039\015\229\015\000\000\000\000\000\000\
\000\000\000\000\000\000\055\001\000\000\063\255\063\255\000\000\
\050\001\000\000\013\001\000\000\252\000\000\000\175\000\070\001\
\018\001\000\000\000\000\000\000\161\002\081\001\183\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\023\001\025\001\
\026\001\000\000\000\000\240\000\241\000\094\002\000\000\000\000\
\000\000\000\000\020\015\000\000\000\000\000\000\000\000\229\015\
\192\012\014\014\077\010\091\001\000\000\000\000\000\000\000\000\
\000\000\034\001\000\000\000\000\000\000\000\000\000\000\161\002\
\000\000\092\001\000\000\175\000\081\255\000\000\000\000\000\000\
\074\001\000\000\000\000\077\014\078\001\097\001\183\000\046\001\
\046\001\046\001\101\001\000\000\000\000\000\000\077\014\000\000\
\000\000\000\000\047\006\000\000\000\000\000\000\000\000\085\001\
\000\000\229\015\171\255\134\015\052\001\054\001\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\046\001\000\000\
\057\001\067\001\000\000\000\000\000\000\042\009\075\001\000\000\
\000\000\000\000\000\000\083\001\000\000\201\000\237\255\237\255\
\197\000\000\000\000\000\000\000\000\000\000\000\000\000"

let yyrindex = "\000\000\
\000\000\000\000\118\000\000\000\000\000\000\000\000\000\000\000\
\105\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\024\001\107\005\182\005\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\145\001\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\149\002\149\002\149\002\149\002\000\000\
\000\000\000\000\000\000\000\000\000\000\151\002\000\000\000\000\
\000\000\000\000\000\000\000\000\051\001\000\000\001\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\207\001\
\000\000\069\002\000\000\000\000\000\000\000\000\139\001\000\000\
\000\000\220\007\000\000\253\004\000\000\000\000\242\254\000\000\
\000\000\149\008\182\005\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\220\008\035\009\109\009\184\009\
\000\000\147\001\147\001\255\009\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\105\001\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\173\255\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\192\015\000\000\000\000\032\255\000\000\162\255\000\000\
\000\000\000\000\000\000\228\255\126\001\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\156\002\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\068\016\000\000\000\000\
\000\000\000\000\065\001\195\000\000\000\000\000\000\000\000\000\
\187\002\000\000\000\000\000\000\046\003\000\000\161\003\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\100\001\074\008\000\000\000\000\000\000\036\006\021\000\000\000\
\000\000\000\000\027\255\000\000\000\000\000\000\000\000\000\000\
\186\255\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\023\002\141\002\253\012\032\005\
\000\000\000\000\028\000\007\013\181\006\000\000\000\000\254\011\
\069\012\070\010\144\010\219\010\139\001\000\000\034\011\105\011\
\000\000\140\012\186\012\000\000\024\001\000\000\189\001\000\000\
\018\255\000\000\166\255\000\000\000\000\000\000\000\000\000\000\
\149\002\000\000\000\000\098\001\000\000\000\000\000\000\068\016\
\000\000\000\000\000\000\162\255\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\079\001\000\000\000\000\000\000\084\007\
\000\000\000\000\000\000\000\000\000\000\000\000\118\000\000\000\
\000\000\015\000\000\000\000\000\023\004\000\000\138\004\000\000\
\000\000\000\000\000\000\179\011\000\000\000\000\000\000\000\000\
\000\000\146\006\161\001\000\000\037\000\000\000\000\000\161\001\
\100\001\079\255\221\002\000\000\000\000\115\003\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\143\003\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\007\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\238\255\000\000\000\000\104\001\000\000\
\022\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\082\001\000\000\000\000\000\000\000\000\000\000\000\000\
\084\001\000\000\000\000\000\000\000\000\000\000\000\000\079\001\
\000\000\000\000\000\000\000\000\000\000\223\254\000\000\000\000\
\000\000\112\001\149\002\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\018\000\178\002\158\001\000\000\000\000\
\000\000\000\000\110\007\000\000\000\000\000\000\175\001\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\233\003\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\043\000\000\000\000\000\000\000\000\000\
\176\001\000\000\000\000\000\000\000\000\000\000\133\255\000\000\
\126\001\000\000\000\000\000\000\000\000\000\000\112\001\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\057\004\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\133\255\118\001\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\180\001\000\000\112\001\015\000\
\015\000\015\000\000\000\047\255\047\255\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\118\001\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\015\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\018\000\178\002\178\002\
\084\001\000\000\000\000\000\000\000\000\000\000\000\000"

let yygindex = "\000\000\
\000\000\000\000\000\000\224\255\146\254\046\000\151\255\000\000\
\000\000\049\002\139\255\255\255\000\000\013\002\044\000\029\001\
\000\000\074\000\026\002\248\255\214\000\087\254\014\000\002\000\
\000\000\087\001\000\000\086\001\160\254\089\001\165\255\224\000\
\227\000\000\000\051\000\000\000\034\000\081\000\000\000\000\000\
\115\001\190\254\110\001\025\000\210\255\250\255\192\255\000\000\
\000\000\000\000\000\000\036\001\180\000\156\000\000\000\000\000\
\019\001\025\255\000\000\000\000\007\000\000\000\000\000\000\000\
\215\255\047\000\099\254\000\000\000\000\000\000\223\002\000\000\
\077\001\000\000\000\000\000\000\000\000\039\001\000\000\000\000\
\000\000\000\000\000\000\129\000\176\253\000\000\202\255\000\000\
\200\255\127\000\080\254\043\002\000\000\086\254\000\000\011\000\
\199\000\000\000\000\000\000\000\042\000\000\000\053\254\231\253\
\049\000\000\000\163\002\185\001\000\000"

let yytablesize = 4772
let yytable = "\041\000\
\113\000\201\000\183\000\098\001\099\001\187\000\120\001\111\000\
\200\000\186\000\202\000\031\002\121\000\205\000\188\000\231\001\
\182\000\198\000\184\000\182\000\033\002\237\001\106\001\117\000\
\117\000\046\002\135\002\083\000\169\002\137\000\194\000\044\001\
\102\000\184\000\152\000\190\001\002\001\142\000\050\001\225\001\
\002\001\097\002\156\000\228\001\081\001\173\001\174\001\001\000\
\001\000\117\000\097\000\091\000\102\000\124\000\178\000\122\000\
\151\000\163\000\182\000\002\001\166\001\204\000\100\001\005\000\
\012\002\098\002\071\001\112\001\133\000\134\000\135\000\136\000\
\212\001\094\000\097\000\056\000\030\002\140\000\032\002\178\000\
\125\000\044\001\094\001\179\000\103\000\123\000\170\000\146\000\
\147\000\148\000\149\000\102\000\084\001\241\001\086\001\103\002\
\002\001\214\001\123\000\123\000\123\000\123\000\148\000\191\001\
\103\000\150\000\050\001\123\000\039\002\151\000\143\000\206\000\
\002\001\191\002\104\001\102\000\153\000\186\000\146\000\147\000\
\148\000\149\000\151\000\122\001\123\001\124\001\125\001\126\001\
\127\001\128\001\129\001\233\002\136\001\046\002\171\000\172\000\
\150\000\180\000\188\001\135\001\151\000\179\001\139\001\103\000\
\141\001\142\001\143\001\144\001\145\001\146\001\090\001\147\001\
\148\001\149\001\213\001\182\000\182\000\182\001\140\001\084\002\
\011\001\212\002\180\000\161\001\095\001\096\001\107\002\103\000\
\157\001\153\000\154\000\155\000\087\001\169\001\170\001\088\001\
\089\001\167\001\156\000\215\001\171\001\204\000\153\000\154\000\
\155\000\126\000\039\002\186\002\112\002\011\001\113\001\009\000\
\151\000\163\000\086\000\127\000\198\001\011\001\112\002\128\000\
\153\000\154\000\155\000\129\000\148\000\141\002\181\002\130\000\
\152\001\153\001\154\001\155\001\156\001\011\001\159\001\160\001\
\162\001\163\001\167\000\165\001\168\000\169\000\170\000\040\002\
\151\000\113\002\011\001\002\000\091\001\150\001\002\000\092\001\
\093\001\001\000\002\000\003\000\151\001\204\000\123\000\123\000\
\123\000\123\000\123\000\219\002\123\000\123\000\123\000\123\000\
\243\001\123\000\009\000\212\002\153\000\227\001\155\000\002\001\
\131\000\171\000\208\002\211\002\005\000\171\000\171\000\001\001\
\112\001\175\002\132\000\106\001\232\001\189\001\171\000\172\000\
\153\002\146\000\147\000\148\000\149\000\173\002\174\002\088\000\
\103\001\187\002\095\000\103\001\153\000\202\001\155\000\206\001\
\094\000\083\000\138\000\150\000\002\001\083\000\184\000\151\000\
\083\000\177\000\096\000\085\001\203\001\182\000\001\001\006\001\
\105\001\139\000\202\000\006\001\171\000\083\000\141\000\224\001\
\171\000\001\001\083\000\083\000\083\000\083\000\005\000\233\001\
\236\000\146\000\147\000\148\000\149\000\144\000\006\001\104\001\
\145\000\215\002\224\001\105\001\083\000\095\000\105\001\192\000\
\208\001\245\002\246\002\150\000\083\000\060\002\255\000\151\000\
\077\001\083\000\148\002\149\002\083\000\096\000\188\000\189\000\
\181\000\255\000\203\000\153\000\154\000\155\000\071\001\083\000\
\014\002\190\000\193\000\006\001\078\001\229\001\191\000\056\000\
\080\001\111\001\082\001\235\001\083\000\238\001\156\000\101\001\
\102\001\188\000\092\002\006\001\188\000\188\000\184\001\198\000\
\198\000\149\001\085\001\117\000\250\001\163\000\013\002\255\001\
\000\002\028\002\118\001\117\001\083\000\083\000\083\000\184\000\
\117\000\220\001\119\001\153\000\154\000\155\000\050\002\182\000\
\073\001\074\001\075\001\076\001\165\000\166\000\167\000\037\002\
\168\000\169\000\170\000\137\001\182\000\138\001\172\001\053\002\
\176\001\177\001\217\001\218\001\219\001\178\001\185\001\123\000\
\182\000\029\002\186\000\192\001\020\002\196\001\190\001\169\001\
\035\002\113\001\186\000\186\000\085\000\113\001\197\001\113\001\
\199\001\054\002\186\000\186\000\186\000\186\000\200\001\205\001\
\086\000\207\001\078\002\249\001\086\000\209\001\149\000\086\000\
\216\001\222\001\171\000\172\000\239\001\251\001\252\001\254\001\
\220\002\221\002\222\002\104\002\086\000\002\002\005\002\105\002\
\186\000\151\000\186\000\186\000\186\000\186\000\007\002\010\002\
\008\002\182\000\041\002\035\002\009\002\182\000\052\002\017\002\
\164\002\016\002\127\002\128\002\094\002\095\002\129\002\238\002\
\123\002\018\002\026\002\086\000\027\002\051\002\059\002\061\002\
\086\000\101\002\169\001\086\000\062\002\080\002\182\000\082\002\
\081\002\194\000\106\002\089\002\083\002\096\002\086\000\100\002\
\102\002\108\002\133\002\114\002\109\002\110\002\077\000\115\002\
\116\002\144\002\122\002\086\000\145\002\088\000\132\002\124\002\
\130\002\088\000\182\001\048\000\088\000\137\002\204\000\182\000\
\138\002\139\002\182\000\142\002\136\002\054\002\200\002\151\002\
\152\002\088\000\118\002\146\002\105\001\154\002\088\000\088\000\
\088\000\088\000\156\002\063\000\064\000\065\000\066\000\155\002\
\067\000\170\002\158\002\178\002\153\000\180\002\157\002\165\002\
\088\000\166\002\172\002\176\002\088\000\177\002\182\002\182\000\
\088\000\195\002\183\002\068\000\179\002\088\000\185\002\192\002\
\088\000\193\002\194\002\196\002\197\002\198\002\161\002\162\002\
\206\002\163\002\207\002\088\000\210\002\216\002\218\002\217\002\
\188\002\229\002\020\002\020\002\035\002\223\002\117\002\202\000\
\088\000\184\000\066\002\067\002\234\002\095\000\235\002\202\000\
\202\000\239\002\068\002\069\002\070\002\071\002\189\001\202\000\
\202\000\202\000\202\000\240\002\054\002\236\000\236\000\214\002\
\088\000\088\000\088\000\242\002\076\000\236\000\236\000\236\000\
\236\000\001\000\118\002\243\002\229\000\182\000\056\001\096\000\
\007\000\004\001\072\002\063\001\105\000\202\000\203\002\202\000\
\202\000\202\000\233\000\184\000\184\000\169\001\110\000\027\001\
\251\000\236\002\052\001\236\000\048\001\236\000\236\000\236\000\
\040\001\208\000\173\000\136\002\111\000\117\000\035\001\182\000\
\188\002\046\001\154\000\134\001\164\001\118\002\078\002\113\001\
\113\001\006\002\085\000\158\001\199\002\230\001\085\000\093\002\
\091\002\085\000\090\002\236\001\234\001\202\002\117\002\149\000\
\230\002\209\002\020\002\149\000\149\000\184\002\085\000\226\001\
\149\000\221\001\149\000\149\000\090\000\126\002\143\002\227\002\
\075\000\063\002\149\000\149\000\149\000\149\000\149\000\149\000\
\149\000\149\000\149\000\055\002\168\002\149\000\149\000\149\000\
\149\000\171\002\195\001\226\002\244\002\085\000\131\002\065\002\
\079\001\117\002\085\000\247\002\231\002\085\000\201\001\149\000\
\149\000\149\000\149\000\149\000\149\000\149\000\149\000\149\000\
\085\000\237\002\000\000\000\000\149\000\000\000\000\000\149\000\
\000\000\240\001\000\000\000\000\000\000\085\000\146\000\147\000\
\148\000\149\000\149\000\000\000\077\000\000\000\000\000\000\000\
\077\000\000\000\000\000\077\000\000\000\000\000\000\000\149\000\
\150\000\000\000\000\000\000\000\151\000\155\000\000\000\000\000\
\077\000\000\000\000\000\000\000\000\000\000\000\149\000\149\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\149\000\
\149\000\149\000\000\000\149\000\149\000\153\000\000\000\077\000\
\000\000\153\000\153\000\000\000\000\000\000\000\153\000\077\000\
\153\000\153\000\000\000\000\000\077\000\000\000\000\000\077\000\
\153\000\153\000\153\000\153\000\153\000\153\000\153\000\153\000\
\153\000\000\000\077\000\153\000\153\000\153\000\153\000\000\000\
\153\000\154\000\155\000\000\000\000\000\000\000\000\000\077\000\
\000\000\000\000\091\000\000\000\000\000\153\000\153\000\153\000\
\153\000\153\000\153\000\153\000\153\000\153\000\000\000\000\000\
\000\000\000\000\153\000\000\000\000\000\153\000\042\002\043\002\
\065\000\066\000\044\002\067\000\000\000\000\000\092\000\000\000\
\153\000\000\000\076\000\000\000\000\000\000\000\076\000\000\000\
\000\000\076\000\000\000\000\000\000\000\153\000\045\002\000\000\
\159\000\005\000\116\000\000\000\000\000\000\000\076\000\000\000\
\000\000\000\000\000\000\000\000\153\000\153\000\000\000\096\000\
\097\000\098\000\099\000\100\000\000\000\153\000\153\000\153\000\
\000\000\153\000\153\000\154\000\000\000\076\000\000\000\154\000\
\154\000\000\000\000\000\000\000\154\000\076\000\154\000\154\000\
\000\000\000\000\076\000\000\000\000\000\076\000\154\000\154\000\
\154\000\154\000\154\000\154\000\154\000\154\000\154\000\000\000\
\076\000\154\000\154\000\154\000\154\000\000\000\000\000\000\000\
\000\000\000\000\090\000\000\000\000\000\076\000\090\000\000\000\
\084\000\090\000\000\000\154\000\154\000\154\000\154\000\154\000\
\154\000\154\000\154\000\154\000\003\002\000\000\090\000\000\000\
\154\000\000\000\000\000\154\000\101\000\102\000\103\000\104\000\
\105\000\106\000\107\000\108\000\109\000\110\000\154\000\000\000\
\000\000\146\000\147\000\148\000\149\000\000\000\000\000\000\000\
\000\000\000\000\000\000\154\000\000\000\090\000\160\000\000\000\
\000\000\000\000\090\000\150\000\000\000\090\000\000\000\151\000\
\000\000\000\000\154\000\154\000\000\000\000\000\000\000\000\000\
\090\000\000\000\000\000\154\000\154\000\154\000\155\000\154\000\
\154\000\000\000\155\000\155\000\000\000\090\000\000\000\155\000\
\089\000\155\000\155\000\146\000\147\000\148\000\149\000\000\000\
\000\000\155\000\155\000\155\000\155\000\155\000\155\000\155\000\
\155\000\155\000\000\000\000\000\155\000\155\000\155\000\155\000\
\000\000\151\000\000\000\000\000\000\000\000\000\000\000\000\000\
\244\001\000\000\000\000\153\000\154\000\155\000\155\000\155\000\
\155\000\155\000\155\000\155\000\155\000\155\000\155\000\000\000\
\000\000\000\000\000\000\155\000\000\000\000\000\155\000\000\000\
\000\000\146\000\147\000\148\000\149\000\000\000\000\000\000\000\
\091\000\155\000\000\000\000\000\091\000\000\000\000\000\091\000\
\000\000\000\000\000\000\150\000\000\000\000\000\155\000\151\000\
\000\000\161\000\000\000\000\000\091\000\153\000\154\000\155\000\
\000\000\000\000\000\000\000\000\092\000\155\000\155\000\000\000\
\092\000\000\000\000\000\092\000\000\000\000\000\155\000\155\000\
\155\000\159\000\155\000\155\000\000\000\159\000\159\000\000\000\
\092\000\000\000\159\000\091\000\159\000\159\000\000\000\000\000\
\091\000\000\000\000\000\091\000\159\000\159\000\159\000\159\000\
\159\000\159\000\159\000\159\000\159\000\000\000\091\000\159\000\
\159\000\159\000\159\000\153\000\154\000\155\000\000\000\092\000\
\000\000\000\000\000\000\091\000\092\000\000\000\000\000\092\000\
\000\000\159\000\159\000\159\000\159\000\159\000\159\000\159\000\
\159\000\159\000\092\000\000\000\000\000\000\000\159\000\000\000\
\000\000\159\000\000\000\242\001\000\000\000\000\000\000\092\000\
\146\000\147\000\148\000\149\000\159\000\000\000\084\000\000\000\
\000\000\000\000\084\000\000\000\000\000\084\000\000\000\000\000\
\000\000\159\000\150\000\000\000\171\000\000\000\151\000\000\000\
\000\000\000\000\084\000\000\000\000\000\000\000\000\000\000\000\
\159\000\159\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\159\000\159\000\159\000\000\000\159\000\159\000\160\000\
\000\000\000\000\000\000\160\000\160\000\000\000\000\000\078\000\
\160\000\084\000\160\000\160\000\000\000\000\000\084\000\000\000\
\000\000\084\000\160\000\160\000\160\000\160\000\160\000\160\000\
\160\000\160\000\160\000\000\000\084\000\160\000\160\000\160\000\
\160\000\000\000\153\000\154\000\155\000\000\000\089\000\000\000\
\000\000\084\000\089\000\245\001\000\000\089\000\000\000\160\000\
\160\000\160\000\160\000\160\000\160\000\160\000\160\000\160\000\
\000\000\000\000\089\000\000\000\160\000\000\000\000\000\160\000\
\000\000\000\000\000\000\000\000\146\000\147\000\148\000\149\000\
\246\001\000\000\160\000\000\000\000\000\146\000\147\000\148\000\
\149\000\000\000\013\000\000\000\000\000\000\000\150\000\160\000\
\000\000\089\000\151\000\000\000\000\000\000\000\089\000\150\000\
\000\000\089\000\000\000\151\000\000\000\000\000\160\000\160\000\
\000\000\000\000\000\000\000\000\089\000\000\000\000\000\160\000\
\160\000\160\000\161\000\160\000\160\000\000\000\161\000\161\000\
\000\000\089\000\000\000\161\000\000\000\161\000\161\000\000\000\
\000\000\000\000\000\000\000\000\000\000\161\000\161\000\161\000\
\161\000\161\000\161\000\161\000\161\000\161\000\000\000\000\000\
\161\000\161\000\161\000\161\000\000\000\000\000\153\000\154\000\
\155\000\000\000\000\000\000\000\248\001\048\000\000\000\153\000\
\154\000\155\000\161\000\161\000\161\000\161\000\161\000\161\000\
\161\000\161\000\161\000\000\000\000\000\000\000\000\000\161\000\
\000\000\000\000\161\000\000\000\000\000\146\000\147\000\148\000\
\149\000\000\000\000\000\000\000\000\000\161\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\150\000\
\000\000\000\000\161\000\151\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\161\000\161\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\161\000\161\000\161\000\171\000\161\000\161\000\
\000\000\171\000\171\000\000\000\000\000\000\000\171\000\000\000\
\171\000\171\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\171\000\171\000\171\000\171\000\171\000\171\000\171\000\
\171\000\000\000\000\000\171\000\171\000\171\000\171\000\153\000\
\154\000\155\000\000\000\132\000\000\000\078\000\000\000\000\000\
\000\000\078\000\000\000\253\001\078\000\171\000\171\000\171\000\
\171\000\171\000\171\000\171\000\171\000\171\000\000\000\000\000\
\000\000\078\000\171\000\000\000\000\000\171\000\078\000\078\000\
\000\000\078\000\000\000\000\000\146\000\147\000\148\000\149\000\
\171\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\078\000\000\000\000\000\000\000\000\000\171\000\150\000\000\000\
\078\000\000\000\151\000\000\000\000\000\078\000\000\000\000\000\
\078\000\000\000\000\000\000\000\171\000\171\000\000\000\000\000\
\000\000\000\000\000\000\078\000\000\000\171\000\171\000\171\000\
\013\000\171\000\171\000\000\000\013\000\000\000\013\000\013\000\
\078\000\000\000\000\000\000\000\000\000\000\000\013\000\013\000\
\013\000\013\000\013\000\013\000\013\000\013\000\013\000\000\000\
\000\000\013\000\013\000\013\000\013\000\000\000\000\000\000\000\
\000\000\129\000\000\000\000\000\000\000\000\000\153\000\154\000\
\155\000\000\000\000\000\013\000\013\000\013\000\013\000\013\000\
\013\000\013\000\013\000\013\000\000\000\000\000\000\000\000\000\
\013\000\000\000\000\000\013\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\082\000\000\000\013\000\000\000\
\000\000\000\000\000\000\048\000\000\000\000\000\000\000\048\000\
\000\000\048\000\048\000\013\000\000\000\000\000\000\000\000\000\
\000\000\048\000\048\000\048\000\048\000\048\000\048\000\048\000\
\048\000\048\000\013\000\013\000\048\000\048\000\048\000\048\000\
\000\000\000\000\000\000\013\000\013\000\013\000\001\002\013\000\
\013\000\000\000\000\000\000\000\000\000\000\000\048\000\048\000\
\048\000\048\000\048\000\048\000\048\000\048\000\048\000\000\000\
\000\000\000\000\000\000\048\000\000\000\000\000\048\000\146\000\
\147\000\148\000\149\000\000\000\000\000\000\000\000\000\047\000\
\000\000\048\000\000\000\000\000\000\000\000\000\159\002\000\000\
\000\000\150\000\000\000\000\000\000\000\151\000\048\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\048\000\048\000\146\000\
\147\000\148\000\149\000\000\000\132\000\000\000\048\000\048\000\
\048\000\132\000\048\000\048\000\000\000\132\000\000\000\132\000\
\132\000\150\000\000\000\000\000\228\002\151\000\000\000\132\000\
\132\000\132\000\132\000\132\000\132\000\132\000\132\000\132\000\
\000\000\000\000\132\000\132\000\132\000\132\000\000\000\000\000\
\000\000\153\000\154\000\155\000\000\000\146\000\147\000\148\000\
\149\000\000\000\000\000\000\000\132\000\132\000\132\000\132\000\
\132\000\132\000\132\000\000\000\132\000\000\000\000\000\150\000\
\247\001\132\000\000\000\151\000\132\000\146\000\147\000\148\000\
\149\000\000\000\000\000\000\000\000\000\137\000\000\000\132\000\
\000\000\153\000\154\000\155\000\000\000\000\000\000\000\150\000\
\000\000\000\000\000\000\151\000\132\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\132\000\132\000\000\000\000\000\000\000\
\000\000\000\000\129\000\000\000\132\000\132\000\132\000\129\000\
\132\000\132\000\000\000\129\000\000\000\129\000\129\000\153\000\
\154\000\155\000\000\000\000\000\000\000\129\000\129\000\129\000\
\129\000\129\000\129\000\129\000\129\000\129\000\000\000\000\000\
\129\000\129\000\129\000\129\000\000\000\000\000\000\000\153\000\
\154\000\155\000\082\000\000\000\000\000\000\000\082\000\000\000\
\000\000\082\000\129\000\129\000\129\000\129\000\129\000\129\000\
\129\000\000\000\129\000\000\000\000\000\000\000\082\000\129\000\
\000\000\000\000\129\000\082\000\082\000\082\000\082\000\000\000\
\000\000\000\000\000\000\124\000\000\000\129\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\082\000\000\000\000\000\
\000\000\000\000\129\000\000\000\000\000\082\000\000\000\000\000\
\000\000\000\000\082\000\000\000\000\000\082\000\000\000\160\002\
\000\000\129\000\129\000\000\000\146\000\147\000\148\000\149\000\
\082\000\000\000\129\000\129\000\129\000\047\000\129\000\129\000\
\000\000\047\000\000\000\047\000\047\000\082\000\150\000\000\000\
\000\000\000\000\151\000\047\000\047\000\047\000\047\000\047\000\
\047\000\047\000\047\000\047\000\000\000\000\000\047\000\047\000\
\047\000\047\000\000\000\000\000\000\000\000\000\082\000\082\000\
\000\000\146\000\147\000\148\000\149\000\000\000\000\000\000\000\
\047\000\047\000\047\000\047\000\047\000\047\000\047\000\047\000\
\047\000\000\000\000\000\150\000\000\000\047\000\000\000\151\000\
\047\000\000\000\000\000\000\000\146\000\147\000\148\000\149\000\
\130\001\127\000\000\000\047\000\000\000\000\000\153\000\154\000\
\155\000\000\000\000\000\000\000\001\000\001\000\150\000\000\000\
\047\000\000\000\151\000\000\000\000\000\000\000\004\002\000\000\
\000\000\000\000\001\000\001\000\001\000\001\000\001\000\047\000\
\047\000\000\000\000\000\000\000\000\000\000\000\137\000\000\000\
\047\000\047\000\047\000\137\000\047\000\047\000\000\000\137\000\
\000\000\137\000\137\000\153\000\154\000\131\001\000\000\000\000\
\000\000\137\000\137\000\137\000\137\000\137\000\137\000\137\000\
\137\000\137\000\000\000\000\000\137\000\137\000\137\000\137\000\
\000\000\000\000\000\000\000\000\014\000\000\000\153\000\154\000\
\155\000\000\000\000\000\000\000\000\000\000\000\137\000\137\000\
\137\000\137\000\137\000\137\000\137\000\000\000\137\000\000\000\
\000\000\000\000\000\000\137\000\000\000\000\000\137\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\137\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\137\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\137\000\137\000\146\000\
\147\000\148\000\149\000\032\000\124\000\000\000\137\000\137\000\
\137\000\124\000\137\000\137\000\000\000\124\000\000\000\124\000\
\124\000\150\000\000\000\000\000\000\000\151\000\000\000\124\000\
\124\000\124\000\124\000\124\000\124\000\124\000\124\000\124\000\
\000\000\064\002\124\000\124\000\124\000\124\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\124\000\124\000\124\000\000\000\
\124\000\124\000\124\000\000\000\124\000\000\000\000\000\000\000\
\000\000\124\000\000\000\000\000\124\000\000\000\000\000\000\000\
\000\000\000\000\033\000\000\000\000\000\000\000\000\000\124\000\
\000\000\153\000\154\000\155\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\124\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\124\000\124\000\146\000\147\000\148\000\
\149\000\000\000\127\000\000\000\124\000\124\000\124\000\127\000\
\124\000\124\000\000\000\127\000\000\000\127\000\127\000\150\000\
\000\000\000\000\000\000\151\000\000\000\127\000\127\000\127\000\
\127\000\127\000\127\000\127\000\127\000\127\000\156\000\099\002\
\127\000\127\000\127\000\127\000\035\000\000\000\157\000\158\000\
\159\000\160\000\161\000\162\000\000\000\163\000\164\000\000\000\
\000\000\000\000\127\000\127\000\127\000\000\000\127\000\127\000\
\127\000\000\000\127\000\000\000\000\000\000\000\000\000\127\000\
\000\000\000\000\127\000\000\000\165\000\166\000\167\000\000\000\
\168\000\169\000\170\000\000\000\000\000\127\000\000\000\153\000\
\154\000\155\000\014\000\000\000\000\000\000\000\014\000\000\000\
\000\000\014\000\127\000\000\000\000\000\000\000\000\000\000\000\
\014\000\014\000\014\000\014\000\014\000\014\000\014\000\000\000\
\014\000\127\000\127\000\014\000\014\000\014\000\014\000\036\000\
\000\000\000\000\127\000\127\000\127\000\000\000\127\000\127\000\
\000\000\000\000\171\000\172\000\000\000\014\000\014\000\014\000\
\014\000\014\000\014\000\014\000\000\000\014\000\000\000\173\000\
\174\000\000\000\014\000\000\000\000\000\014\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\014\000\032\000\000\000\000\000\000\000\032\000\000\000\000\000\
\032\000\000\000\000\000\000\000\000\000\014\000\000\000\032\000\
\032\000\032\000\032\000\032\000\032\000\032\000\000\000\032\000\
\000\000\000\000\032\000\032\000\032\000\032\000\034\000\000\000\
\000\000\000\000\000\000\000\000\000\000\014\000\014\000\014\000\
\000\000\014\000\014\000\000\000\032\000\032\000\032\000\032\000\
\032\000\032\000\032\000\000\000\032\000\000\000\000\000\000\000\
\000\000\032\000\000\000\000\000\032\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\032\000\
\033\000\000\000\000\000\000\000\033\000\000\000\000\000\033\000\
\000\000\000\000\000\000\000\000\032\000\000\000\033\000\033\000\
\033\000\033\000\033\000\033\000\033\000\000\000\033\000\000\000\
\000\000\033\000\033\000\033\000\033\000\025\000\000\000\000\000\
\146\000\147\000\148\000\149\000\032\000\032\000\032\000\000\000\
\032\000\032\000\000\000\033\000\033\000\033\000\033\000\033\000\
\033\000\033\000\150\000\033\000\000\000\000\000\151\000\000\000\
\033\000\000\000\000\000\033\000\000\000\000\000\000\000\000\000\
\000\000\000\000\241\002\000\000\000\000\000\000\033\000\000\000\
\000\000\000\000\035\000\000\000\000\000\000\000\035\000\000\000\
\000\000\035\000\000\000\033\000\000\000\000\000\000\000\000\000\
\035\000\035\000\035\000\035\000\035\000\035\000\035\000\000\000\
\035\000\000\000\000\000\035\000\035\000\035\000\035\000\026\000\
\000\000\000\000\000\000\033\000\033\000\033\000\000\000\033\000\
\033\000\000\000\153\000\154\000\155\000\035\000\035\000\035\000\
\035\000\035\000\035\000\035\000\000\000\035\000\000\000\000\000\
\000\000\000\000\035\000\000\000\000\000\035\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\035\000\000\000\000\000\000\000\000\000\036\000\000\000\000\000\
\000\000\036\000\000\000\000\000\036\000\035\000\000\000\000\000\
\000\000\000\000\000\000\036\000\036\000\036\000\036\000\036\000\
\036\000\036\000\000\000\036\000\000\000\000\000\036\000\036\000\
\036\000\036\000\027\000\000\000\000\000\035\000\035\000\035\000\
\000\000\035\000\035\000\000\000\000\000\000\000\000\000\000\000\
\036\000\036\000\036\000\036\000\036\000\036\000\036\000\000\000\
\036\000\000\000\000\000\000\000\000\000\036\000\000\000\000\000\
\036\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\036\000\034\000\000\000\000\000\000\000\
\034\000\000\000\000\000\034\000\000\000\000\000\000\000\000\000\
\036\000\000\000\034\000\034\000\034\000\034\000\034\000\034\000\
\034\000\000\000\034\000\000\000\000\000\034\000\034\000\034\000\
\034\000\054\000\000\000\000\000\000\000\000\000\000\000\000\000\
\036\000\036\000\036\000\000\000\036\000\036\000\000\000\034\000\
\034\000\034\000\034\000\034\000\034\000\034\000\000\000\034\000\
\000\000\000\000\000\000\000\000\034\000\000\000\000\000\034\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\034\000\025\000\000\000\000\000\000\000\025\000\
\000\000\000\000\025\000\000\000\000\000\000\000\000\000\034\000\
\000\000\025\000\025\000\025\000\025\000\025\000\025\000\025\000\
\000\000\025\000\000\000\000\000\025\000\025\000\025\000\025\000\
\056\000\000\000\000\000\146\000\147\000\148\000\149\000\034\000\
\034\000\034\000\000\000\034\000\034\000\000\000\025\000\025\000\
\025\000\025\000\025\000\025\000\025\000\150\000\025\000\000\000\
\000\000\151\000\000\000\025\000\000\000\000\000\025\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\025\000\000\000\000\000\000\000\026\000\000\000\000\000\
\000\000\026\000\000\000\000\000\026\000\000\000\025\000\000\000\
\000\000\000\000\000\000\026\000\026\000\026\000\026\000\026\000\
\026\000\026\000\000\000\026\000\000\000\000\000\026\000\026\000\
\026\000\026\000\053\000\000\000\000\000\000\000\025\000\025\000\
\025\000\000\000\025\000\025\000\000\000\153\000\154\000\155\000\
\026\000\026\000\026\000\026\000\026\000\026\000\026\000\000\000\
\026\000\000\000\000\000\000\000\000\000\026\000\000\000\000\000\
\026\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\026\000\000\000\000\000\000\000\000\000\
\027\000\000\000\000\000\000\000\027\000\000\000\000\000\027\000\
\026\000\000\000\000\000\000\000\000\000\000\000\027\000\027\000\
\027\000\027\000\027\000\027\000\027\000\000\000\027\000\000\000\
\000\000\027\000\027\000\027\000\027\000\024\000\000\000\000\000\
\026\000\026\000\026\000\000\000\026\000\026\000\000\000\000\000\
\000\000\000\000\000\000\027\000\027\000\027\000\027\000\027\000\
\027\000\027\000\000\000\027\000\000\000\000\000\000\000\000\000\
\027\000\000\000\000\000\027\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\027\000\054\000\
\000\000\000\000\000\000\054\000\000\000\000\000\054\000\000\000\
\000\000\000\000\000\000\027\000\000\000\054\000\054\000\054\000\
\054\000\054\000\054\000\054\000\000\000\054\000\000\000\000\000\
\054\000\054\000\054\000\054\000\023\000\000\000\000\000\000\000\
\000\000\000\000\000\000\027\000\027\000\027\000\000\000\027\000\
\027\000\000\000\054\000\054\000\054\000\054\000\054\000\054\000\
\054\000\000\000\054\000\000\000\000\000\000\000\000\000\054\000\
\000\000\000\000\054\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\054\000\056\000\000\000\
\000\000\000\000\056\000\000\000\000\000\056\000\000\000\000\000\
\000\000\000\000\054\000\000\000\056\000\056\000\056\000\056\000\
\056\000\056\000\056\000\000\000\056\000\000\000\000\000\056\000\
\056\000\056\000\056\000\049\000\000\000\000\000\000\000\000\000\
\000\000\000\000\054\000\054\000\054\000\000\000\054\000\054\000\
\000\000\056\000\056\000\056\000\056\000\056\000\056\000\056\000\
\000\000\056\000\000\000\000\000\000\000\000\000\056\000\000\000\
\000\000\056\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\056\000\000\000\000\000\000\000\
\053\000\050\000\000\000\000\000\053\000\000\000\000\000\053\000\
\000\000\056\000\000\000\000\000\000\000\000\000\053\000\053\000\
\053\000\053\000\053\000\053\000\053\000\000\000\053\000\000\000\
\000\000\053\000\053\000\053\000\053\000\000\000\000\000\000\000\
\000\000\056\000\056\000\056\000\000\000\056\000\056\000\000\000\
\000\000\000\000\000\000\053\000\053\000\053\000\053\000\053\000\
\053\000\053\000\000\000\053\000\000\000\000\000\000\000\000\000\
\053\000\000\000\000\000\053\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\079\000\000\000\053\000\000\000\
\000\000\000\000\000\000\024\000\000\000\000\000\080\000\024\000\
\000\000\000\000\024\000\053\000\000\000\000\000\000\000\000\000\
\000\000\024\000\024\000\024\000\024\000\024\000\024\000\024\000\
\000\000\024\000\000\000\000\000\024\000\024\000\024\000\024\000\
\000\000\000\000\000\000\053\000\053\000\053\000\000\000\053\000\
\053\000\000\000\000\000\000\000\000\000\000\000\024\000\024\000\
\024\000\000\000\024\000\000\000\000\000\000\000\024\000\000\000\
\000\000\000\000\000\000\024\000\000\000\000\000\024\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\024\000\023\000\000\000\000\000\000\000\023\000\000\000\
\000\000\023\000\000\000\000\000\000\000\000\000\024\000\000\000\
\023\000\023\000\023\000\023\000\023\000\023\000\023\000\000\000\
\023\000\000\000\000\000\023\000\023\000\023\000\023\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\024\000\024\000\
\024\000\000\000\024\000\024\000\000\000\023\000\023\000\023\000\
\000\000\023\000\000\000\000\000\000\000\023\000\000\000\000\000\
\000\000\000\000\023\000\000\000\000\000\023\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\023\000\049\000\000\000\000\000\000\000\049\000\000\000\000\000\
\049\000\000\000\000\000\000\000\000\000\023\000\000\000\049\000\
\049\000\049\000\049\000\049\000\049\000\049\000\000\000\049\000\
\000\000\000\000\049\000\049\000\049\000\049\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\023\000\023\000\023\000\
\000\000\023\000\023\000\000\000\049\000\000\000\000\000\050\000\
\049\000\000\000\000\000\050\000\049\000\000\000\050\000\000\000\
\000\000\049\000\000\000\000\000\049\000\050\000\050\000\050\000\
\050\000\050\000\050\000\050\000\000\000\050\000\000\000\049\000\
\050\000\050\000\050\000\050\000\000\000\000\000\146\000\147\000\
\148\000\149\000\000\000\000\000\049\000\000\000\000\000\000\000\
\000\000\000\000\050\000\000\000\000\000\000\000\050\000\000\000\
\150\000\000\000\050\000\000\000\151\000\000\000\000\000\050\000\
\000\000\000\000\050\000\000\000\049\000\049\000\049\000\000\000\
\049\000\049\000\079\000\000\000\000\000\050\000\079\000\000\000\
\000\000\079\000\000\000\000\000\080\000\000\000\000\000\000\000\
\080\000\000\000\050\000\080\000\000\000\000\000\079\000\000\000\
\204\002\000\000\000\000\079\000\079\000\079\000\079\000\000\000\
\080\000\000\000\000\000\000\000\000\000\080\000\080\000\000\000\
\080\000\000\000\050\000\050\000\050\000\079\000\050\000\050\000\
\153\000\154\000\155\000\000\000\000\000\079\000\000\000\080\000\
\000\000\000\000\079\000\000\000\000\000\079\000\000\000\080\000\
\000\000\000\000\000\000\000\000\080\000\000\000\000\000\080\000\
\079\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\080\000\000\000\000\000\079\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\080\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\079\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\080\000\207\000\208\000\209\000\210\000\211\000\212\000\213\000\
\214\000\215\000\216\000\217\000\218\000\219\000\220\000\221\000\
\222\000\223\000\000\000\224\000\225\000\226\000\227\000\228\000\
\229\000\230\000\231\000\232\000\233\000\234\000\235\000\236\000\
\237\000\238\000\239\000\240\000\241\000\242\000\243\000\244\000\
\245\000\246\000\247\000\248\000\249\000\250\000\251\000\252\000\
\253\000\254\000\255\000\000\001\001\001\002\001\003\001\004\001\
\005\001\006\001\007\001\008\001\009\001\010\001\011\001\012\001\
\013\001\014\001\015\001\016\001\017\001\018\001\019\001\020\001\
\021\001\022\001\000\000\023\001\024\001\025\001\026\001\027\001\
\028\001\029\001\030\001\031\001\000\000\000\000\032\001\033\001\
\034\001\035\001\036\001\000\000\037\001\038\001\039\001\040\001\
\041\001\042\001\043\001\044\001\045\001\046\001\047\001\048\001\
\049\001\050\001\051\001\052\001\053\001\054\001\055\001\056\001\
\057\001\058\001\059\001\060\001\061\001\062\001\063\001\064\001\
\065\001\066\001\067\001\068\001\005\000\095\000\007\000\008\000\
\009\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\096\000\097\000\098\000\099\000\100\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\010\000\011\000\000\000\000\000\000\000\000\000\012\000\013\000\
\014\000\015\000\016\000\017\000\018\000\019\000\020\000\021\000\
\022\000\023\000\024\000\000\000\000\000\025\000\026\000\027\000\
\028\000\000\000\000\000\000\000\146\000\147\000\148\000\149\000\
\000\000\000\000\000\000\000\000\000\000\029\000\030\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\150\000\000\000\
\000\000\000\000\151\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\031\000\000\000\000\000\116\000\101\000\
\102\000\103\000\104\000\105\000\106\000\107\000\108\000\109\000\
\110\000\032\000\033\000\096\000\097\000\098\000\099\000\100\000\
\000\000\005\000\116\000\007\000\008\000\009\000\205\002\034\000\
\000\000\000\000\035\000\036\000\037\000\038\000\039\000\096\000\
\097\000\098\000\099\000\100\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\153\000\154\000\
\155\000\000\000\000\000\012\000\013\000\014\000\015\000\016\000\
\017\000\018\000\019\000\020\000\021\000\022\000\023\000\024\000\
\000\000\000\000\025\000\026\000\027\000\028\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\029\000\030\000\000\000\000\000\000\000\000\000\
\101\000\102\000\103\000\104\000\105\000\106\000\107\000\108\000\
\109\000\110\000\000\000\000\000\000\000\000\000\000\000\000\000\
\031\000\000\000\000\000\000\000\101\000\102\000\103\000\104\000\
\105\000\106\000\107\000\108\000\109\000\110\000\032\000\033\000\
\005\000\006\000\007\000\008\000\009\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\034\000\000\000\000\000\035\000\
\000\000\000\000\038\000\039\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\010\000\011\000\000\000\000\000\
\000\000\000\000\012\000\013\000\014\000\015\000\016\000\017\000\
\018\000\019\000\020\000\021\000\022\000\023\000\024\000\000\000\
\000\000\025\000\026\000\027\000\028\000\000\000\000\000\000\000\
\000\000\000\000\005\000\116\000\000\000\000\000\112\001\000\000\
\000\000\029\000\030\000\000\000\000\000\000\000\000\000\019\002\
\096\000\097\000\098\000\099\000\100\000\116\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\031\000\
\000\000\201\002\096\000\097\000\098\000\099\000\100\000\005\000\
\006\000\007\000\008\000\009\000\000\000\032\000\033\000\000\000\
\000\000\000\000\000\000\000\000\000\000\104\001\000\000\000\000\
\000\000\000\000\000\000\034\000\000\000\000\000\035\000\036\000\
\037\000\038\000\039\000\010\000\011\000\000\000\000\000\000\000\
\000\000\012\000\013\000\014\000\015\000\016\000\017\000\018\000\
\019\000\020\000\021\000\022\000\023\000\024\000\000\000\000\000\
\025\000\026\000\027\000\028\000\000\000\101\000\102\000\103\000\
\104\000\105\000\106\000\107\000\108\000\109\000\110\000\000\000\
\029\000\030\000\000\000\000\000\000\000\000\000\167\002\101\000\
\102\000\103\000\104\000\105\000\106\000\107\000\108\000\109\000\
\110\000\000\000\000\000\000\000\000\000\000\000\031\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\005\000\006\000\
\007\000\008\000\009\000\000\000\032\000\033\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\034\000\000\000\000\000\035\000\036\000\037\000\
\038\000\039\000\010\000\011\000\000\000\000\000\000\000\000\000\
\012\000\013\000\014\000\015\000\016\000\017\000\018\000\019\000\
\020\000\021\000\022\000\023\000\024\000\000\000\000\000\025\000\
\026\000\027\000\028\000\000\000\000\000\000\000\000\000\000\000\
\000\000\005\000\000\000\000\000\000\000\000\000\000\000\029\000\
\030\000\000\000\000\000\000\000\000\000\232\002\005\000\005\000\
\005\000\005\000\005\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\031\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\005\000\006\000\007\000\
\008\000\009\000\000\000\032\000\033\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\034\000\000\000\000\000\035\000\036\000\037\000\038\000\
\039\000\010\000\011\000\000\000\000\000\000\000\000\000\012\000\
\013\000\014\000\015\000\016\000\017\000\018\000\019\000\020\000\
\021\000\022\000\023\000\024\000\000\000\000\000\025\000\026\000\
\027\000\028\000\000\000\005\000\005\000\005\000\005\000\005\000\
\005\000\005\000\005\000\005\000\005\000\000\000\029\000\030\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\031\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\001\000\001\000\001\000\001\000\
\001\000\000\000\032\000\033\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\034\000\000\000\000\000\035\000\036\000\037\000\038\000\039\000\
\001\000\001\000\000\000\000\000\000\000\000\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\000\000\000\000\001\000\001\000\001\000\
\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\001\000\001\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\005\000\000\000\007\000\008\000\009\000\
\000\000\001\000\001\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\
\000\000\000\000\001\000\001\000\001\000\001\000\001\000\010\000\
\011\000\000\000\000\000\000\000\000\000\012\000\013\000\014\000\
\015\000\016\000\017\000\018\000\019\000\020\000\021\000\022\000\
\023\000\024\000\000\000\000\000\025\000\026\000\027\000\028\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\029\000\030\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\031\000\000\000\005\000\000\000\007\000\008\000\
\009\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\032\000\033\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\034\000\000\000\
\000\000\035\000\036\000\037\000\038\000\039\000\012\000\013\000\
\014\000\015\000\016\000\017\000\018\000\019\000\020\000\021\000\
\022\000\023\000\024\000\000\000\000\000\025\000\026\000\027\000\
\028\000\000\000\000\000\000\000\047\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\029\000\030\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\031\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\032\000\033\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\048\000\049\000\034\000\
\050\000\051\000\035\000\052\000\000\000\038\000\039\000\053\000\
\054\000\055\000\056\000\000\000\057\000\058\000\000\000\000\000\
\059\000\060\000\061\000\062\000\000\000\063\000\064\000\065\000\
\066\000\000\000\067\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\068\000\069\000\000\000\
\000\000\070\000\000\000\071\000"

let yycheck = "\001\000\
\009\000\066\000\049\000\109\000\110\000\052\000\124\000\009\000\
\065\000\051\000\067\000\188\001\011\000\068\000\000\000\112\001\
\049\000\000\000\051\000\052\000\190\001\118\001\114\000\010\000\
\011\000\196\001\052\002\000\000\109\002\031\000\063\000\065\001\
\006\001\066\000\000\000\020\001\005\001\036\000\021\001\106\001\
\009\001\065\001\012\001\110\001\091\000\001\001\002\001\001\001\
\002\001\036\000\065\001\068\001\026\001\005\001\005\001\012\000\
\053\001\027\001\091\000\028\001\178\000\068\000\006\001\001\001\
\175\001\089\001\062\001\005\001\025\000\026\000\027\000\028\000\
\015\001\009\001\089\001\071\001\187\001\034\000\189\001\005\001\
\005\001\115\001\015\001\009\001\006\001\012\000\056\001\031\001\
\032\001\033\001\034\001\065\001\094\000\006\001\015\001\009\002\
\065\001\015\001\025\000\026\000\027\000\028\000\033\001\088\001\
\026\001\049\001\089\001\034\000\028\001\053\001\037\000\065\001\
\081\001\139\002\052\001\089\001\113\001\000\000\031\001\032\001\
\033\001\034\001\053\001\125\000\126\000\127\000\128\000\129\000\
\130\000\131\000\132\000\212\002\141\000\048\002\104\001\105\001\
\049\001\088\001\195\000\141\000\053\001\188\000\144\000\065\001\
\146\000\147\000\148\000\149\000\150\000\151\000\015\001\153\000\
\154\000\155\000\097\001\188\000\189\000\190\000\145\000\226\001\
\028\001\081\001\088\001\172\000\097\001\098\001\021\002\089\001\
\170\000\113\001\114\001\115\001\093\001\180\000\181\000\096\001\
\097\001\179\000\012\001\097\001\182\000\009\001\113\001\114\001\
\115\001\005\001\028\001\135\002\028\001\028\001\117\000\006\001\
\053\001\027\001\000\000\005\001\203\000\065\001\028\001\005\001\
\113\001\114\001\115\001\005\001\033\001\060\002\127\002\005\001\
\165\000\166\000\167\000\168\000\169\000\081\001\171\000\172\000\
\173\000\174\000\052\001\176\000\054\001\055\001\056\001\065\001\
\053\001\065\001\065\001\062\001\093\001\156\000\065\001\096\001\
\097\001\001\000\002\000\003\000\163\000\065\001\165\000\166\000\
\167\000\168\000\169\000\191\002\171\000\172\000\173\000\174\000\
\006\001\176\000\065\001\081\001\113\001\005\001\115\001\028\001\
\005\001\001\001\172\002\180\002\001\001\005\001\006\001\026\001\
\005\001\120\002\005\001\103\001\005\001\196\000\104\001\105\001\
\083\002\031\001\032\001\033\001\034\001\118\002\119\002\000\000\
\005\001\136\002\006\001\005\001\113\001\071\001\115\001\078\001\
\009\001\006\001\005\001\049\001\065\001\010\001\071\001\053\001\
\013\001\003\001\006\001\020\001\077\001\078\001\065\001\005\001\
\056\001\005\001\000\000\009\001\052\001\026\001\005\001\052\001\
\056\001\076\001\031\001\032\001\033\001\034\001\001\001\056\001\
\000\000\031\001\032\001\033\001\034\001\005\001\028\001\052\001\
\005\001\184\002\052\001\056\001\049\001\057\001\056\001\075\001\
\082\001\239\002\240\002\049\001\057\001\203\001\065\001\053\001\
\001\001\062\001\110\001\111\001\065\001\057\001\059\001\060\001\
\059\001\076\001\059\001\113\001\114\001\115\001\062\001\076\001\
\064\001\070\001\075\001\065\001\001\001\111\001\075\001\071\001\
\000\000\013\001\112\001\117\001\089\001\119\001\012\001\006\001\
\006\001\107\001\240\001\081\001\110\001\111\001\001\001\110\001\
\111\001\131\001\020\001\118\001\131\001\027\001\176\001\137\001\
\138\001\184\001\026\001\065\001\113\001\114\001\115\001\176\001\
\131\001\102\001\065\001\113\001\114\001\115\001\197\001\184\001\
\076\000\077\000\078\000\079\000\050\001\051\001\052\001\192\001\
\054\001\055\001\056\001\065\001\197\001\028\001\065\001\200\001\
\026\001\009\001\097\001\098\001\099\001\065\001\001\001\102\001\
\209\001\186\001\061\001\005\001\182\001\088\001\020\001\190\001\
\191\001\112\001\069\001\070\001\000\000\116\001\009\001\118\001\
\065\001\200\001\077\001\078\001\079\001\080\001\028\001\065\001\
\006\001\065\001\211\001\130\001\010\001\061\001\000\000\013\001\
\015\001\004\001\104\001\105\001\006\001\006\001\006\001\006\001\
\192\002\193\002\194\002\010\002\026\001\052\001\057\001\014\002\
\107\001\053\001\109\001\110\001\111\001\112\001\006\001\009\001\
\089\001\010\002\088\001\242\001\026\001\014\002\115\001\062\001\
\102\002\065\001\043\002\044\002\246\001\247\001\045\002\223\002\
\039\002\065\001\065\001\057\001\065\001\005\001\009\001\065\001\
\062\001\003\002\009\002\065\001\065\001\015\001\039\002\006\001\
\015\001\042\002\017\002\006\001\057\001\028\001\076\001\006\001\
\005\001\076\001\051\002\021\001\026\001\065\001\000\000\026\001\
\089\001\072\002\006\001\089\001\075\002\006\001\065\001\091\001\
\089\001\010\001\067\002\058\001\013\001\005\001\045\002\072\002\
\065\001\115\001\075\002\065\001\053\002\052\002\152\002\026\001\
\021\001\026\001\037\002\107\001\056\001\006\001\031\001\032\001\
\033\001\034\001\006\001\082\001\083\001\084\001\085\001\026\001\
\087\001\112\002\006\001\124\002\000\000\126\002\057\001\065\001\
\049\001\065\001\020\001\026\001\053\001\065\001\009\001\112\002\
\057\001\146\002\065\001\106\001\089\001\062\001\006\001\065\001\
\065\001\065\001\065\001\108\001\108\001\000\000\096\002\097\002\
\006\001\099\002\065\001\076\001\009\001\028\001\006\001\026\001\
\137\002\021\001\108\002\109\002\115\002\009\001\037\002\061\001\
\089\001\146\002\069\001\070\001\065\001\013\001\065\001\069\001\
\070\001\065\001\077\001\078\001\079\001\080\001\053\002\077\001\
\078\001\079\001\080\001\065\001\139\002\069\001\070\001\182\002\
\113\001\114\001\115\001\065\001\000\000\077\001\078\001\079\001\
\080\001\001\001\133\002\065\001\000\000\182\002\000\000\013\001\
\006\001\028\001\109\001\000\000\057\001\107\001\160\002\109\001\
\110\001\111\001\065\001\196\002\197\002\172\002\006\001\089\001\
\065\001\216\002\089\001\107\001\089\001\109\001\110\001\111\001\
\065\001\000\000\021\001\188\002\006\001\006\001\065\001\216\002\
\217\002\006\001\000\000\139\000\176\000\176\002\199\002\118\002\
\119\002\165\001\006\001\170\000\151\002\111\001\010\001\242\001\
\233\001\013\001\232\001\118\001\116\001\155\002\133\002\001\001\
\210\002\176\002\212\002\005\001\006\001\133\002\026\001\106\001\
\010\001\103\001\012\001\013\001\000\000\042\002\067\002\199\002\
\002\000\207\001\020\001\021\001\022\001\023\001\024\001\025\001\
\026\001\027\001\028\001\200\001\108\002\031\001\032\001\033\001\
\034\001\115\002\200\000\197\002\238\002\057\001\048\002\209\001\
\086\000\176\002\062\001\241\002\211\002\065\001\070\001\049\001\
\050\001\051\001\052\001\053\001\054\001\055\001\056\001\057\001\
\076\001\217\002\255\255\255\255\062\001\255\255\255\255\065\001\
\255\255\026\001\255\255\255\255\255\255\089\001\031\001\032\001\
\033\001\034\001\076\001\255\255\006\001\255\255\255\255\255\255\
\010\001\255\255\255\255\013\001\255\255\255\255\255\255\089\001\
\049\001\255\255\255\255\255\255\053\001\000\000\255\255\255\255\
\026\001\255\255\255\255\255\255\255\255\255\255\104\001\105\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\113\001\
\114\001\115\001\255\255\117\001\118\001\001\001\255\255\049\001\
\255\255\005\001\006\001\255\255\255\255\255\255\010\001\057\001\
\012\001\013\001\255\255\255\255\062\001\255\255\255\255\065\001\
\020\001\021\001\022\001\023\001\024\001\025\001\026\001\027\001\
\028\001\255\255\076\001\031\001\032\001\033\001\034\001\255\255\
\113\001\114\001\115\001\255\255\255\255\255\255\255\255\089\001\
\255\255\255\255\000\000\255\255\255\255\049\001\050\001\051\001\
\052\001\053\001\054\001\055\001\056\001\057\001\255\255\255\255\
\255\255\255\255\062\001\255\255\255\255\065\001\082\001\083\001\
\084\001\085\001\086\001\087\001\255\255\255\255\000\000\255\255\
\076\001\255\255\006\001\255\255\255\255\255\255\010\001\255\255\
\255\255\013\001\255\255\255\255\255\255\089\001\106\001\255\255\
\000\000\001\001\002\001\255\255\255\255\255\255\026\001\255\255\
\255\255\255\255\255\255\255\255\104\001\105\001\255\255\015\001\
\016\001\017\001\018\001\019\001\255\255\113\001\114\001\115\001\
\255\255\117\001\118\001\001\001\255\255\049\001\255\255\005\001\
\006\001\255\255\255\255\255\255\010\001\057\001\012\001\013\001\
\255\255\255\255\062\001\255\255\255\255\065\001\020\001\021\001\
\022\001\023\001\024\001\025\001\026\001\027\001\028\001\255\255\
\076\001\031\001\032\001\033\001\034\001\255\255\255\255\255\255\
\255\255\255\255\006\001\255\255\255\255\089\001\010\001\255\255\
\000\000\013\001\255\255\049\001\050\001\051\001\052\001\053\001\
\054\001\055\001\056\001\057\001\010\001\255\255\026\001\255\255\
\062\001\255\255\255\255\065\001\092\001\093\001\094\001\095\001\
\096\001\097\001\098\001\099\001\100\001\101\001\076\001\255\255\
\255\255\031\001\032\001\033\001\034\001\255\255\255\255\255\255\
\255\255\255\255\255\255\089\001\255\255\057\001\000\000\255\255\
\255\255\255\255\062\001\049\001\255\255\065\001\255\255\053\001\
\255\255\255\255\104\001\105\001\255\255\255\255\255\255\255\255\
\076\001\255\255\255\255\113\001\114\001\115\001\001\001\117\001\
\118\001\255\255\005\001\006\001\255\255\089\001\255\255\010\001\
\000\000\012\001\013\001\031\001\032\001\033\001\034\001\255\255\
\255\255\020\001\021\001\022\001\023\001\024\001\025\001\026\001\
\027\001\028\001\255\255\255\255\031\001\032\001\033\001\034\001\
\255\255\053\001\255\255\255\255\255\255\255\255\255\255\255\255\
\006\001\255\255\255\255\113\001\114\001\115\001\049\001\050\001\
\051\001\052\001\053\001\054\001\055\001\056\001\057\001\255\255\
\255\255\255\255\255\255\062\001\255\255\255\255\065\001\255\255\
\255\255\031\001\032\001\033\001\034\001\255\255\255\255\255\255\
\006\001\076\001\255\255\255\255\010\001\255\255\255\255\013\001\
\255\255\255\255\255\255\049\001\255\255\255\255\089\001\053\001\
\255\255\000\000\255\255\255\255\026\001\113\001\114\001\115\001\
\255\255\255\255\255\255\255\255\006\001\104\001\105\001\255\255\
\010\001\255\255\255\255\013\001\255\255\255\255\113\001\114\001\
\115\001\001\001\117\001\118\001\255\255\005\001\006\001\255\255\
\026\001\255\255\010\001\057\001\012\001\013\001\255\255\255\255\
\062\001\255\255\255\255\065\001\020\001\021\001\022\001\023\001\
\024\001\025\001\026\001\027\001\028\001\255\255\076\001\031\001\
\032\001\033\001\034\001\113\001\114\001\115\001\255\255\057\001\
\255\255\255\255\255\255\089\001\062\001\255\255\255\255\065\001\
\255\255\049\001\050\001\051\001\052\001\053\001\054\001\055\001\
\056\001\057\001\076\001\255\255\255\255\255\255\062\001\255\255\
\255\255\065\001\255\255\026\001\255\255\255\255\255\255\089\001\
\031\001\032\001\033\001\034\001\076\001\255\255\006\001\255\255\
\255\255\255\255\010\001\255\255\255\255\013\001\255\255\255\255\
\255\255\089\001\049\001\255\255\000\000\255\255\053\001\255\255\
\255\255\255\255\026\001\255\255\255\255\255\255\255\255\255\255\
\104\001\105\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\113\001\114\001\115\001\255\255\117\001\118\001\001\001\
\255\255\255\255\255\255\005\001\006\001\255\255\255\255\000\000\
\010\001\057\001\012\001\013\001\255\255\255\255\062\001\255\255\
\255\255\065\001\020\001\021\001\022\001\023\001\024\001\025\001\
\026\001\027\001\028\001\255\255\076\001\031\001\032\001\033\001\
\034\001\255\255\113\001\114\001\115\001\255\255\006\001\255\255\
\255\255\089\001\010\001\006\001\255\255\013\001\255\255\049\001\
\050\001\051\001\052\001\053\001\054\001\055\001\056\001\057\001\
\255\255\255\255\026\001\255\255\062\001\255\255\255\255\065\001\
\255\255\255\255\255\255\255\255\031\001\032\001\033\001\034\001\
\026\001\255\255\076\001\255\255\255\255\031\001\032\001\033\001\
\034\001\255\255\000\000\255\255\255\255\255\255\049\001\089\001\
\255\255\057\001\053\001\255\255\255\255\255\255\062\001\049\001\
\255\255\065\001\255\255\053\001\255\255\255\255\104\001\105\001\
\255\255\255\255\255\255\255\255\076\001\255\255\255\255\113\001\
\114\001\115\001\001\001\117\001\118\001\255\255\005\001\006\001\
\255\255\089\001\255\255\010\001\255\255\012\001\013\001\255\255\
\255\255\255\255\255\255\255\255\255\255\020\001\021\001\022\001\
\023\001\024\001\025\001\026\001\027\001\028\001\255\255\255\255\
\031\001\032\001\033\001\034\001\255\255\255\255\113\001\114\001\
\115\001\255\255\255\255\255\255\006\001\000\000\255\255\113\001\
\114\001\115\001\049\001\050\001\051\001\052\001\053\001\054\001\
\055\001\056\001\057\001\255\255\255\255\255\255\255\255\062\001\
\255\255\255\255\065\001\255\255\255\255\031\001\032\001\033\001\
\034\001\255\255\255\255\255\255\255\255\076\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\049\001\
\255\255\255\255\089\001\053\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\104\001\105\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\113\001\114\001\115\001\001\001\117\001\118\001\
\255\255\005\001\006\001\255\255\255\255\255\255\010\001\255\255\
\012\001\013\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\021\001\022\001\023\001\024\001\025\001\026\001\027\001\
\028\001\255\255\255\255\031\001\032\001\033\001\034\001\113\001\
\114\001\115\001\255\255\000\000\255\255\006\001\255\255\255\255\
\255\255\010\001\255\255\006\001\013\001\049\001\050\001\051\001\
\052\001\053\001\054\001\055\001\056\001\057\001\255\255\255\255\
\255\255\026\001\062\001\255\255\255\255\065\001\031\001\032\001\
\255\255\034\001\255\255\255\255\031\001\032\001\033\001\034\001\
\076\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\049\001\255\255\255\255\255\255\255\255\089\001\049\001\255\255\
\057\001\255\255\053\001\255\255\255\255\062\001\255\255\255\255\
\065\001\255\255\255\255\255\255\104\001\105\001\255\255\255\255\
\255\255\255\255\255\255\076\001\255\255\113\001\114\001\115\001\
\006\001\117\001\118\001\255\255\010\001\255\255\012\001\013\001\
\089\001\255\255\255\255\255\255\255\255\255\255\020\001\021\001\
\022\001\023\001\024\001\025\001\026\001\027\001\028\001\255\255\
\255\255\031\001\032\001\033\001\034\001\255\255\255\255\255\255\
\255\255\000\000\255\255\255\255\255\255\255\255\113\001\114\001\
\115\001\255\255\255\255\049\001\050\001\051\001\052\001\053\001\
\054\001\055\001\056\001\057\001\255\255\255\255\255\255\255\255\
\062\001\255\255\255\255\065\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\000\000\255\255\076\001\255\255\
\255\255\255\255\255\255\006\001\255\255\255\255\255\255\010\001\
\255\255\012\001\013\001\089\001\255\255\255\255\255\255\255\255\
\255\255\020\001\021\001\022\001\023\001\024\001\025\001\026\001\
\027\001\028\001\104\001\105\001\031\001\032\001\033\001\034\001\
\255\255\255\255\255\255\113\001\114\001\115\001\006\001\117\001\
\118\001\255\255\255\255\255\255\255\255\255\255\049\001\050\001\
\051\001\052\001\053\001\054\001\055\001\056\001\057\001\255\255\
\255\255\255\255\255\255\062\001\255\255\255\255\065\001\031\001\
\032\001\033\001\034\001\255\255\255\255\255\255\255\255\000\000\
\255\255\076\001\255\255\255\255\255\255\255\255\006\001\255\255\
\255\255\049\001\255\255\255\255\255\255\053\001\089\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\104\001\105\001\031\001\
\032\001\033\001\034\001\255\255\001\001\255\255\113\001\114\001\
\115\001\006\001\117\001\118\001\255\255\010\001\255\255\012\001\
\013\001\049\001\255\255\255\255\006\001\053\001\255\255\020\001\
\021\001\022\001\023\001\024\001\025\001\026\001\027\001\028\001\
\255\255\255\255\031\001\032\001\033\001\034\001\255\255\255\255\
\255\255\113\001\114\001\115\001\255\255\031\001\032\001\033\001\
\034\001\255\255\255\255\255\255\049\001\050\001\051\001\052\001\
\053\001\054\001\055\001\255\255\057\001\255\255\255\255\049\001\
\026\001\062\001\255\255\053\001\065\001\031\001\032\001\033\001\
\034\001\255\255\255\255\255\255\255\255\000\000\255\255\076\001\
\255\255\113\001\114\001\115\001\255\255\255\255\255\255\049\001\
\255\255\255\255\255\255\053\001\089\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\104\001\105\001\255\255\255\255\255\255\
\255\255\255\255\001\001\255\255\113\001\114\001\115\001\006\001\
\117\001\118\001\255\255\010\001\255\255\012\001\013\001\113\001\
\114\001\115\001\255\255\255\255\255\255\020\001\021\001\022\001\
\023\001\024\001\025\001\026\001\027\001\028\001\255\255\255\255\
\031\001\032\001\033\001\034\001\255\255\255\255\255\255\113\001\
\114\001\115\001\006\001\255\255\255\255\255\255\010\001\255\255\
\255\255\013\001\049\001\050\001\051\001\052\001\053\001\054\001\
\055\001\255\255\057\001\255\255\255\255\255\255\026\001\062\001\
\255\255\255\255\065\001\031\001\032\001\033\001\034\001\255\255\
\255\255\255\255\255\255\000\000\255\255\076\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\049\001\255\255\255\255\
\255\255\255\255\089\001\255\255\255\255\057\001\255\255\255\255\
\255\255\255\255\062\001\255\255\255\255\065\001\255\255\026\001\
\255\255\104\001\105\001\255\255\031\001\032\001\033\001\034\001\
\076\001\255\255\113\001\114\001\115\001\006\001\117\001\118\001\
\255\255\010\001\255\255\012\001\013\001\089\001\049\001\255\255\
\255\255\255\255\053\001\020\001\021\001\022\001\023\001\024\001\
\025\001\026\001\027\001\028\001\255\255\255\255\031\001\032\001\
\033\001\034\001\255\255\255\255\255\255\255\255\114\001\115\001\
\255\255\031\001\032\001\033\001\034\001\255\255\255\255\255\255\
\049\001\050\001\051\001\052\001\053\001\054\001\055\001\056\001\
\057\001\255\255\255\255\049\001\255\255\062\001\255\255\053\001\
\065\001\255\255\255\255\255\255\031\001\032\001\033\001\034\001\
\062\001\000\000\255\255\076\001\255\255\255\255\113\001\114\001\
\115\001\255\255\255\255\255\255\001\001\002\001\049\001\255\255\
\089\001\255\255\053\001\255\255\255\255\255\255\057\001\255\255\
\255\255\255\255\015\001\016\001\017\001\018\001\019\001\104\001\
\105\001\255\255\255\255\255\255\255\255\255\255\001\001\255\255\
\113\001\114\001\115\001\006\001\117\001\118\001\255\255\010\001\
\255\255\012\001\013\001\113\001\114\001\115\001\255\255\255\255\
\255\255\020\001\021\001\022\001\023\001\024\001\025\001\026\001\
\027\001\028\001\255\255\255\255\031\001\032\001\033\001\034\001\
\255\255\255\255\255\255\255\255\000\000\255\255\113\001\114\001\
\115\001\255\255\255\255\255\255\255\255\255\255\049\001\050\001\
\051\001\052\001\053\001\054\001\055\001\255\255\057\001\255\255\
\255\255\255\255\255\255\062\001\255\255\255\255\065\001\092\001\
\093\001\094\001\095\001\096\001\097\001\098\001\099\001\100\001\
\101\001\076\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\089\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\104\001\105\001\031\001\
\032\001\033\001\034\001\000\000\001\001\255\255\113\001\114\001\
\115\001\006\001\117\001\118\001\255\255\010\001\255\255\012\001\
\013\001\049\001\255\255\255\255\255\255\053\001\255\255\020\001\
\021\001\022\001\023\001\024\001\025\001\026\001\027\001\028\001\
\255\255\065\001\031\001\032\001\033\001\034\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\049\001\050\001\051\001\255\255\
\053\001\054\001\055\001\255\255\057\001\255\255\255\255\255\255\
\255\255\062\001\255\255\255\255\065\001\255\255\255\255\255\255\
\255\255\255\255\000\000\255\255\255\255\255\255\255\255\076\001\
\255\255\113\001\114\001\115\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\089\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\104\001\105\001\031\001\032\001\033\001\
\034\001\255\255\001\001\255\255\113\001\114\001\115\001\006\001\
\117\001\118\001\255\255\010\001\255\255\012\001\013\001\049\001\
\255\255\255\255\255\255\053\001\255\255\020\001\021\001\022\001\
\023\001\024\001\025\001\026\001\027\001\028\001\012\001\065\001\
\031\001\032\001\033\001\034\001\000\000\255\255\020\001\021\001\
\022\001\023\001\024\001\025\001\255\255\027\001\028\001\255\255\
\255\255\255\255\049\001\050\001\051\001\255\255\053\001\054\001\
\055\001\255\255\057\001\255\255\255\255\255\255\255\255\062\001\
\255\255\255\255\065\001\255\255\050\001\051\001\052\001\255\255\
\054\001\055\001\056\001\255\255\255\255\076\001\255\255\113\001\
\114\001\115\001\006\001\255\255\255\255\255\255\010\001\255\255\
\255\255\013\001\089\001\255\255\255\255\255\255\255\255\255\255\
\020\001\021\001\022\001\023\001\024\001\025\001\026\001\255\255\
\028\001\104\001\105\001\031\001\032\001\033\001\034\001\000\000\
\255\255\255\255\113\001\114\001\115\001\255\255\117\001\118\001\
\255\255\255\255\104\001\105\001\255\255\049\001\050\001\051\001\
\052\001\053\001\054\001\055\001\255\255\057\001\255\255\117\001\
\118\001\255\255\062\001\255\255\255\255\065\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\076\001\006\001\255\255\255\255\255\255\010\001\255\255\255\255\
\013\001\255\255\255\255\255\255\255\255\089\001\255\255\020\001\
\021\001\022\001\023\001\024\001\025\001\026\001\255\255\028\001\
\255\255\255\255\031\001\032\001\033\001\034\001\000\000\255\255\
\255\255\255\255\255\255\255\255\255\255\113\001\114\001\115\001\
\255\255\117\001\118\001\255\255\049\001\050\001\051\001\052\001\
\053\001\054\001\055\001\255\255\057\001\255\255\255\255\255\255\
\255\255\062\001\255\255\255\255\065\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\076\001\
\006\001\255\255\255\255\255\255\010\001\255\255\255\255\013\001\
\255\255\255\255\255\255\255\255\089\001\255\255\020\001\021\001\
\022\001\023\001\024\001\025\001\026\001\255\255\028\001\255\255\
\255\255\031\001\032\001\033\001\034\001\000\000\255\255\255\255\
\031\001\032\001\033\001\034\001\113\001\114\001\115\001\255\255\
\117\001\118\001\255\255\049\001\050\001\051\001\052\001\053\001\
\054\001\055\001\049\001\057\001\255\255\255\255\053\001\255\255\
\062\001\255\255\255\255\065\001\255\255\255\255\255\255\255\255\
\255\255\255\255\065\001\255\255\255\255\255\255\076\001\255\255\
\255\255\255\255\006\001\255\255\255\255\255\255\010\001\255\255\
\255\255\013\001\255\255\089\001\255\255\255\255\255\255\255\255\
\020\001\021\001\022\001\023\001\024\001\025\001\026\001\255\255\
\028\001\255\255\255\255\031\001\032\001\033\001\034\001\000\000\
\255\255\255\255\255\255\113\001\114\001\115\001\255\255\117\001\
\118\001\255\255\113\001\114\001\115\001\049\001\050\001\051\001\
\052\001\053\001\054\001\055\001\255\255\057\001\255\255\255\255\
\255\255\255\255\062\001\255\255\255\255\065\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\076\001\255\255\255\255\255\255\255\255\006\001\255\255\255\255\
\255\255\010\001\255\255\255\255\013\001\089\001\255\255\255\255\
\255\255\255\255\255\255\020\001\021\001\022\001\023\001\024\001\
\025\001\026\001\255\255\028\001\255\255\255\255\031\001\032\001\
\033\001\034\001\000\000\255\255\255\255\113\001\114\001\115\001\
\255\255\117\001\118\001\255\255\255\255\255\255\255\255\255\255\
\049\001\050\001\051\001\052\001\053\001\054\001\055\001\255\255\
\057\001\255\255\255\255\255\255\255\255\062\001\255\255\255\255\
\065\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\076\001\006\001\255\255\255\255\255\255\
\010\001\255\255\255\255\013\001\255\255\255\255\255\255\255\255\
\089\001\255\255\020\001\021\001\022\001\023\001\024\001\025\001\
\026\001\255\255\028\001\255\255\255\255\031\001\032\001\033\001\
\034\001\000\000\255\255\255\255\255\255\255\255\255\255\255\255\
\113\001\114\001\115\001\255\255\117\001\118\001\255\255\049\001\
\050\001\051\001\052\001\053\001\054\001\055\001\255\255\057\001\
\255\255\255\255\255\255\255\255\062\001\255\255\255\255\065\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\076\001\006\001\255\255\255\255\255\255\010\001\
\255\255\255\255\013\001\255\255\255\255\255\255\255\255\089\001\
\255\255\020\001\021\001\022\001\023\001\024\001\025\001\026\001\
\255\255\028\001\255\255\255\255\031\001\032\001\033\001\034\001\
\000\000\255\255\255\255\031\001\032\001\033\001\034\001\113\001\
\114\001\115\001\255\255\117\001\118\001\255\255\049\001\050\001\
\051\001\052\001\053\001\054\001\055\001\049\001\057\001\255\255\
\255\255\053\001\255\255\062\001\255\255\255\255\065\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\076\001\255\255\255\255\255\255\006\001\255\255\255\255\
\255\255\010\001\255\255\255\255\013\001\255\255\089\001\255\255\
\255\255\255\255\255\255\020\001\021\001\022\001\023\001\024\001\
\025\001\026\001\255\255\028\001\255\255\255\255\031\001\032\001\
\033\001\034\001\000\000\255\255\255\255\255\255\113\001\114\001\
\115\001\255\255\117\001\118\001\255\255\113\001\114\001\115\001\
\049\001\050\001\051\001\052\001\053\001\054\001\055\001\255\255\
\057\001\255\255\255\255\255\255\255\255\062\001\255\255\255\255\
\065\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\076\001\255\255\255\255\255\255\255\255\
\006\001\255\255\255\255\255\255\010\001\255\255\255\255\013\001\
\089\001\255\255\255\255\255\255\255\255\255\255\020\001\021\001\
\022\001\023\001\024\001\025\001\026\001\255\255\028\001\255\255\
\255\255\031\001\032\001\033\001\034\001\000\000\255\255\255\255\
\113\001\114\001\115\001\255\255\117\001\118\001\255\255\255\255\
\255\255\255\255\255\255\049\001\050\001\051\001\052\001\053\001\
\054\001\055\001\255\255\057\001\255\255\255\255\255\255\255\255\
\062\001\255\255\255\255\065\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\076\001\006\001\
\255\255\255\255\255\255\010\001\255\255\255\255\013\001\255\255\
\255\255\255\255\255\255\089\001\255\255\020\001\021\001\022\001\
\023\001\024\001\025\001\026\001\255\255\028\001\255\255\255\255\
\031\001\032\001\033\001\034\001\000\000\255\255\255\255\255\255\
\255\255\255\255\255\255\113\001\114\001\115\001\255\255\117\001\
\118\001\255\255\049\001\050\001\051\001\052\001\053\001\054\001\
\055\001\255\255\057\001\255\255\255\255\255\255\255\255\062\001\
\255\255\255\255\065\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\076\001\006\001\255\255\
\255\255\255\255\010\001\255\255\255\255\013\001\255\255\255\255\
\255\255\255\255\089\001\255\255\020\001\021\001\022\001\023\001\
\024\001\025\001\026\001\255\255\028\001\255\255\255\255\031\001\
\032\001\033\001\034\001\000\000\255\255\255\255\255\255\255\255\
\255\255\255\255\113\001\114\001\115\001\255\255\117\001\118\001\
\255\255\049\001\050\001\051\001\052\001\053\001\054\001\055\001\
\255\255\057\001\255\255\255\255\255\255\255\255\062\001\255\255\
\255\255\065\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\076\001\255\255\255\255\255\255\
\006\001\000\000\255\255\255\255\010\001\255\255\255\255\013\001\
\255\255\089\001\255\255\255\255\255\255\255\255\020\001\021\001\
\022\001\023\001\024\001\025\001\026\001\255\255\028\001\255\255\
\255\255\031\001\032\001\033\001\034\001\255\255\255\255\255\255\
\255\255\113\001\114\001\115\001\255\255\117\001\118\001\255\255\
\255\255\255\255\255\255\049\001\050\001\051\001\052\001\053\001\
\054\001\055\001\255\255\057\001\255\255\255\255\255\255\255\255\
\062\001\255\255\255\255\065\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\000\000\255\255\076\001\255\255\
\255\255\255\255\255\255\006\001\255\255\255\255\000\000\010\001\
\255\255\255\255\013\001\089\001\255\255\255\255\255\255\255\255\
\255\255\020\001\021\001\022\001\023\001\024\001\025\001\026\001\
\255\255\028\001\255\255\255\255\031\001\032\001\033\001\034\001\
\255\255\255\255\255\255\113\001\114\001\115\001\255\255\117\001\
\118\001\255\255\255\255\255\255\255\255\255\255\049\001\050\001\
\051\001\255\255\053\001\255\255\255\255\255\255\057\001\255\255\
\255\255\255\255\255\255\062\001\255\255\255\255\065\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\076\001\006\001\255\255\255\255\255\255\010\001\255\255\
\255\255\013\001\255\255\255\255\255\255\255\255\089\001\255\255\
\020\001\021\001\022\001\023\001\024\001\025\001\026\001\255\255\
\028\001\255\255\255\255\031\001\032\001\033\001\034\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\113\001\114\001\
\115\001\255\255\117\001\118\001\255\255\049\001\050\001\051\001\
\255\255\053\001\255\255\255\255\255\255\057\001\255\255\255\255\
\255\255\255\255\062\001\255\255\255\255\065\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\076\001\006\001\255\255\255\255\255\255\010\001\255\255\255\255\
\013\001\255\255\255\255\255\255\255\255\089\001\255\255\020\001\
\021\001\022\001\023\001\024\001\025\001\026\001\255\255\028\001\
\255\255\255\255\031\001\032\001\033\001\034\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\113\001\114\001\115\001\
\255\255\117\001\118\001\255\255\049\001\255\255\255\255\006\001\
\053\001\255\255\255\255\010\001\057\001\255\255\013\001\255\255\
\255\255\062\001\255\255\255\255\065\001\020\001\021\001\022\001\
\023\001\024\001\025\001\026\001\255\255\028\001\255\255\076\001\
\031\001\032\001\033\001\034\001\255\255\255\255\031\001\032\001\
\033\001\034\001\255\255\255\255\089\001\255\255\255\255\255\255\
\255\255\255\255\049\001\255\255\255\255\255\255\053\001\255\255\
\049\001\255\255\057\001\255\255\053\001\255\255\255\255\062\001\
\255\255\255\255\065\001\255\255\113\001\114\001\115\001\255\255\
\117\001\118\001\006\001\255\255\255\255\076\001\010\001\255\255\
\255\255\013\001\255\255\255\255\006\001\255\255\255\255\255\255\
\010\001\255\255\089\001\013\001\255\255\255\255\026\001\255\255\
\089\001\255\255\255\255\031\001\032\001\033\001\034\001\255\255\
\026\001\255\255\255\255\255\255\255\255\031\001\032\001\255\255\
\034\001\255\255\113\001\114\001\115\001\049\001\117\001\118\001\
\113\001\114\001\115\001\255\255\255\255\057\001\255\255\049\001\
\255\255\255\255\062\001\255\255\255\255\065\001\255\255\057\001\
\255\255\255\255\255\255\255\255\062\001\255\255\255\255\065\001\
\076\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\076\001\255\255\255\255\089\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\089\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\114\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\114\001\001\001\002\001\003\001\004\001\005\001\006\001\007\001\
\008\001\009\001\010\001\011\001\012\001\013\001\014\001\015\001\
\016\001\017\001\255\255\019\001\020\001\021\001\022\001\023\001\
\024\001\025\001\026\001\027\001\028\001\029\001\030\001\031\001\
\032\001\033\001\034\001\035\001\036\001\037\001\038\001\039\001\
\040\001\041\001\042\001\043\001\044\001\045\001\046\001\047\001\
\048\001\049\001\050\001\051\001\052\001\053\001\054\001\055\001\
\056\001\057\001\058\001\059\001\060\001\061\001\062\001\063\001\
\064\001\065\001\066\001\067\001\068\001\069\001\070\001\071\001\
\072\001\073\001\255\255\075\001\076\001\077\001\078\001\079\001\
\080\001\081\001\082\001\083\001\255\255\255\255\086\001\087\001\
\088\001\089\001\090\001\255\255\092\001\093\001\094\001\095\001\
\096\001\097\001\098\001\099\001\100\001\101\001\102\001\103\001\
\104\001\105\001\106\001\107\001\108\001\109\001\110\001\111\001\
\112\001\113\001\114\001\115\001\116\001\117\001\118\001\119\001\
\120\001\121\001\122\001\123\001\001\001\002\001\003\001\004\001\
\005\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\015\001\016\001\017\001\018\001\019\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\029\001\030\001\255\255\255\255\255\255\255\255\035\001\036\001\
\037\001\038\001\039\001\040\001\041\001\042\001\043\001\044\001\
\045\001\046\001\047\001\255\255\255\255\050\001\051\001\052\001\
\053\001\255\255\255\255\255\255\031\001\032\001\033\001\034\001\
\255\255\255\255\255\255\255\255\255\255\066\001\067\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\049\001\255\255\
\255\255\255\255\053\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\088\001\255\255\255\255\002\001\092\001\
\093\001\094\001\095\001\096\001\097\001\098\001\099\001\100\001\
\101\001\102\001\103\001\015\001\016\001\017\001\018\001\019\001\
\255\255\001\001\002\001\003\001\004\001\005\001\089\001\116\001\
\255\255\255\255\119\001\120\001\121\001\122\001\123\001\015\001\
\016\001\017\001\018\001\019\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\113\001\114\001\
\115\001\255\255\255\255\035\001\036\001\037\001\038\001\039\001\
\040\001\041\001\042\001\043\001\044\001\045\001\046\001\047\001\
\255\255\255\255\050\001\051\001\052\001\053\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\066\001\067\001\255\255\255\255\255\255\255\255\
\092\001\093\001\094\001\095\001\096\001\097\001\098\001\099\001\
\100\001\101\001\255\255\255\255\255\255\255\255\255\255\255\255\
\088\001\255\255\255\255\255\255\092\001\093\001\094\001\095\001\
\096\001\097\001\098\001\099\001\100\001\101\001\102\001\103\001\
\001\001\002\001\003\001\004\001\005\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\116\001\255\255\255\255\119\001\
\255\255\255\255\122\001\123\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\029\001\030\001\255\255\255\255\
\255\255\255\255\035\001\036\001\037\001\038\001\039\001\040\001\
\041\001\042\001\043\001\044\001\045\001\046\001\047\001\255\255\
\255\255\050\001\051\001\052\001\053\001\255\255\255\255\255\255\
\255\255\255\255\001\001\002\001\255\255\255\255\005\001\255\255\
\255\255\066\001\067\001\255\255\255\255\255\255\255\255\072\001\
\015\001\016\001\017\001\018\001\019\001\002\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\088\001\
\255\255\014\001\015\001\016\001\017\001\018\001\019\001\001\001\
\002\001\003\001\004\001\005\001\255\255\102\001\103\001\255\255\
\255\255\255\255\255\255\255\255\255\255\052\001\255\255\255\255\
\255\255\255\255\255\255\116\001\255\255\255\255\119\001\120\001\
\121\001\122\001\123\001\029\001\030\001\255\255\255\255\255\255\
\255\255\035\001\036\001\037\001\038\001\039\001\040\001\041\001\
\042\001\043\001\044\001\045\001\046\001\047\001\255\255\255\255\
\050\001\051\001\052\001\053\001\255\255\092\001\093\001\094\001\
\095\001\096\001\097\001\098\001\099\001\100\001\101\001\255\255\
\066\001\067\001\255\255\255\255\255\255\255\255\072\001\092\001\
\093\001\094\001\095\001\096\001\097\001\098\001\099\001\100\001\
\101\001\255\255\255\255\255\255\255\255\255\255\088\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\001\001\002\001\
\003\001\004\001\005\001\255\255\102\001\103\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\116\001\255\255\255\255\119\001\120\001\121\001\
\122\001\123\001\029\001\030\001\255\255\255\255\255\255\255\255\
\035\001\036\001\037\001\038\001\039\001\040\001\041\001\042\001\
\043\001\044\001\045\001\046\001\047\001\255\255\255\255\050\001\
\051\001\052\001\053\001\255\255\255\255\255\255\255\255\255\255\
\255\255\002\001\255\255\255\255\255\255\255\255\255\255\066\001\
\067\001\255\255\255\255\255\255\255\255\072\001\015\001\016\001\
\017\001\018\001\019\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\088\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\001\001\002\001\003\001\
\004\001\005\001\255\255\102\001\103\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\116\001\255\255\255\255\119\001\120\001\121\001\122\001\
\123\001\029\001\030\001\255\255\255\255\255\255\255\255\035\001\
\036\001\037\001\038\001\039\001\040\001\041\001\042\001\043\001\
\044\001\045\001\046\001\047\001\255\255\255\255\050\001\051\001\
\052\001\053\001\255\255\092\001\093\001\094\001\095\001\096\001\
\097\001\098\001\099\001\100\001\101\001\255\255\066\001\067\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\088\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\001\001\002\001\003\001\004\001\
\005\001\255\255\102\001\103\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\116\001\255\255\255\255\119\001\120\001\121\001\122\001\123\001\
\029\001\030\001\255\255\255\255\255\255\255\255\035\001\036\001\
\037\001\038\001\039\001\040\001\041\001\042\001\043\001\044\001\
\045\001\046\001\047\001\255\255\255\255\050\001\051\001\052\001\
\053\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\066\001\067\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\088\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\001\001\255\255\003\001\004\001\005\001\
\255\255\102\001\103\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\116\001\
\255\255\255\255\119\001\120\001\121\001\122\001\123\001\029\001\
\030\001\255\255\255\255\255\255\255\255\035\001\036\001\037\001\
\038\001\039\001\040\001\041\001\042\001\043\001\044\001\045\001\
\046\001\047\001\255\255\255\255\050\001\051\001\052\001\053\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\066\001\067\001\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\088\001\255\255\001\001\255\255\003\001\004\001\
\005\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\102\001\103\001\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\116\001\255\255\
\255\255\119\001\120\001\121\001\122\001\123\001\035\001\036\001\
\037\001\038\001\039\001\040\001\041\001\042\001\043\001\044\001\
\045\001\046\001\047\001\255\255\255\255\050\001\051\001\052\001\
\053\001\255\255\255\255\255\255\001\001\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\066\001\067\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\088\001\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\102\001\103\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\058\001\059\001\116\001\
\061\001\062\001\119\001\064\001\255\255\122\001\123\001\068\001\
\069\001\070\001\071\001\255\255\073\001\074\001\255\255\255\255\
\077\001\078\001\079\001\080\001\255\255\082\001\083\001\084\001\
\085\001\255\255\087\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\106\001\107\001\255\255\
\255\255\110\001\255\255\112\001"

let yynames_const = "\
  LPAR\000\
  RPAR\000\
  IF\000\
  ELSE\000\
  COLON\000\
  COLON2\000\
  COLONCOLON\000\
  DOT\000\
  DOTDOT\000\
  DOTDOTDOT\000\
  INT\000\
  INTEGER\000\
  REAL\000\
  BOOLEAN\000\
  FLOAT\000\
  LT\000\
  GT\000\
  LE\000\
  GE\000\
  EQ\000\
  NE\000\
  COMMA\000\
  ARROW\000\
  EQUAL\000\
  FORALL\000\
  EXISTS\000\
  IFF\000\
  IMPLIES\000\
  AND\000\
  OR\000\
  NOT\000\
  SEPARATED\000\
  TRUE\000\
  FALSE\000\
  OLD\000\
  AT\000\
  RESULT\000\
  BLOCK_LENGTH\000\
  BASE_ADDR\000\
  VALID\000\
  VALID_INDEX\000\
  VALID_RANGE\000\
  FRESH\000\
  DOLLAR\000\
  QUESTION\000\
  MINUS\000\
  PLUS\000\
  STAR\000\
  AMP\000\
  SLASH\000\
  PERCENT\000\
  LSQUARE\000\
  RSQUARE\000\
  EOF\000\
  GLOBAL\000\
  INVARIANT\000\
  VARIANT\000\
  DECREASES\000\
  FOR\000\
  LABEL\000\
  ASSERT\000\
  SEMICOLON\000\
  NULL\000\
  EMPTY\000\
  REQUIRES\000\
  ENSURES\000\
  ASSIGNS\000\
  LOOP\000\
  NOTHING\000\
  SLICE\000\
  IMPACT\000\
  PRAGMA\000\
  FROM\000\
  EXITS\000\
  BREAKS\000\
  CONTINUES\000\
  RETURNS\000\
  READS\000\
  LOGIC\000\
  PREDICATE\000\
  INDUCTIVE\000\
  AXIOMATIC\000\
  AXIOM\000\
  LEMMA\000\
  LBRACE\000\
  RBRACE\000\
  GHOST\000\
  CASE\000\
  VOID\000\
  CHAR\000\
  SIGNED\000\
  UNSIGNED\000\
  SHORT\000\
  LONG\000\
  DOUBLE\000\
  STRUCT\000\
  ENUM\000\
  UNION\000\
  BSUNION\000\
  INTER\000\
  LTCOLON\000\
  COLONGT\000\
  TYPE\000\
  BEHAVIOR\000\
  BEHAVIORS\000\
  ASSUMES\000\
  COMPLETE\000\
  DISJOINT\000\
  TERMINATES\000\
  HAT\000\
  HATHAT\000\
  PIPE\000\
  TILDE\000\
  GTGT\000\
  LTLT\000\
  SIZEOF\000\
  LAMBDA\000\
  LET\000\
  TYPEOF\000\
  BSTYPE\000\
  "

let yynames_block = "\
  IDENTIFIER\000\
  TYPENAME\000\
  STRING_LITERAL\000\
  CONSTANT\000\
  "

let yyact = [|
  (fun _ -> failwith "parser")
; (fun __caml_parser_env ->
    Obj.repr(
# 131 "cil/src/logic/logic_parser.mly"
            ( enter_kw_c_mode () )
# 2079 "cil/src/logic/logic_parser.ml"
               : 'enter_kw_c_mode))
; (fun __caml_parser_env ->
    Obj.repr(
# 134 "cil/src/logic/logic_parser.mly"
            ( exit_kw_c_mode () )
# 2085 "cil/src/logic/logic_parser.ml"
               : 'exit_kw_c_mode))
; (fun __caml_parser_env ->
    Obj.repr(
# 137 "cil/src/logic/logic_parser.mly"
            ( if is_rt_type () then enter_rt_type_mode () )
# 2091 "cil/src/logic/logic_parser.ml"
               : 'enter_rt_type))
; (fun __caml_parser_env ->
    Obj.repr(
# 140 "cil/src/logic/logic_parser.mly"
            ( if is_rt_type () then exit_rt_type_mode () )
# 2097 "cil/src/logic/logic_parser.ml"
               : 'exit_rt_type))
; (fun __caml_parser_env ->
    Obj.repr(
# 143 "cil/src/logic/logic_parser.mly"
            ( set_rt_type () )
# 2103 "cil/src/logic/logic_parser.ml"
               : 'begin_rt_type))
; (fun __caml_parser_env ->
    Obj.repr(
# 146 "cil/src/logic/logic_parser.mly"
            ( reset_rt_type () )
# 2109 "cil/src/logic/logic_parser.ml"
               : 'end_rt_type))
; (fun __caml_parser_env ->
    Obj.repr(
# 151 "cil/src/logic/logic_parser.mly"
                ( [] )
# 2115 "cil/src/logic/logic_parser.ml"
               : 'lexpr_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'ne_lexpr_list) in
    Obj.repr(
# 152 "cil/src/logic/logic_parser.mly"
                 ( _1 )
# 2122 "cil/src/logic/logic_parser.ml"
               : 'lexpr_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr) in
    Obj.repr(
# 156 "cil/src/logic/logic_parser.mly"
                           ( [_1] )
# 2129 "cil/src/logic/logic_parser.ml"
               : 'ne_lexpr_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'ne_lexpr_list) in
    Obj.repr(
# 157 "cil/src/logic/logic_parser.mly"
                            ( _1 :: _3 )
# 2137 "cil/src/logic/logic_parser.ml"
               : 'ne_lexpr_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_end_rel) in
    Obj.repr(
# 161 "cil/src/logic/logic_parser.mly"
                                  ( _1 )
# 2144 "cil/src/logic/logic_parser.ml"
               : 'lexpr_rel))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr_inner) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'rel_list) in
    Obj.repr(
# 163 "cil/src/logic/logic_parser.mly"
      ( let rel, rhs, _, oth_rel = _2 in
        let loc = loc_start _1, loc_end rhs in
        let relation = loc_info loc (PLrel(_1,rel,rhs)) in
        match oth_rel with
            None -> relation
          | Some oth_relation -> info (PLand(relation,oth_relation))
      )
# 2158 "cil/src/logic/logic_parser.ml"
               : 'lexpr_rel))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'string) in
    Obj.repr(
# 172 "cil/src/logic/logic_parser.mly"
           (
      let (is_wide,content) = _1 in
      let cst = if is_wide then
        WStringConstant content
      else
        StringConstant content
      in
      info (PLconstant cst)
    )
# 2173 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 181 "cil/src/logic/logic_parser.mly"
                    ( info (PLnot _2) )
# 2180 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    Obj.repr(
# 182 "cil/src/logic/logic_parser.mly"
         ( info PLtrue )
# 2186 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    Obj.repr(
# 183 "cil/src/logic/logic_parser.mly"
          ( info PLfalse )
# 2192 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr) in
    Obj.repr(
# 184 "cil/src/logic/logic_parser.mly"
                          ( info (PLvalid (_3)) )
# 2199 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'lexpr) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr) in
    Obj.repr(
# 185 "cil/src/logic/logic_parser.mly"
                                            ( info (PLvalid_index (_3,_5)) )
# 2207 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 5 : 'lexpr) in
    let _5 = (Parsing.peek_val __caml_parser_env 3 : 'lexpr) in
    let _7 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr) in
    Obj.repr(
# 187 "cil/src/logic/logic_parser.mly"
      ( info (PLvalid_range (_3,_5,_7)) )
# 2216 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr) in
    Obj.repr(
# 188 "cil/src/logic/logic_parser.mly"
                          ( info (PLfresh (_3)) )
# 2223 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    Obj.repr(
# 189 "cil/src/logic/logic_parser.mly"
         ( info PLnull )
# 2229 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.constant) in
    Obj.repr(
# 190 "cil/src/logic/logic_parser.mly"
             ( info (PLconstant _1) )
# 2236 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 191 "cil/src/logic/logic_parser.mly"
                                 ( info (PLbinop (_1, Badd, _3)) )
# 2244 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 192 "cil/src/logic/logic_parser.mly"
                                  ( info (PLbinop (_1, Bsub, _3)) )
# 2252 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 193 "cil/src/logic/logic_parser.mly"
                                 ( info (PLbinop (_1, Bmul, _3)) )
# 2260 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 194 "cil/src/logic/logic_parser.mly"
                                  ( info (PLbinop (_1, Bdiv, _3)) )
# 2268 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 195 "cil/src/logic/logic_parser.mly"
                                    ( info (PLbinop (_1, Bmod, _3)) )
# 2276 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'identifier) in
    Obj.repr(
# 196 "cil/src/logic/logic_parser.mly"
                                 ( info (PLarrow (_1, _3)) )
# 2284 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'identifier) in
    Obj.repr(
# 197 "cil/src/logic/logic_parser.mly"
                               ( info (PLdot (_1, _3)) )
# 2292 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'range) in
    Obj.repr(
# 198 "cil/src/logic/logic_parser.mly"
                                      ( info (PLarrget (_1, _3)) )
# 2300 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr) in
    Obj.repr(
# 199 "cil/src/logic/logic_parser.mly"
                                      ( info (PLarrget (_1, _3)) )
# 2308 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 200 "cil/src/logic/logic_parser.mly"
                                        ( info (PLunop (Uminus, _2)) )
# 2315 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 201 "cil/src/logic/logic_parser.mly"
                                       ( _2 )
# 2322 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 202 "cil/src/logic/logic_parser.mly"
                      ( info (PLunop (Ubw_not, _2)) )
# 2329 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 203 "cil/src/logic/logic_parser.mly"
                     ( info (PLunop (Ustar, _2)) )
# 2336 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 204 "cil/src/logic/logic_parser.mly"
                    ( info (PLunop (Uamp, _2)) )
# 2343 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr) in
    Obj.repr(
# 205 "cil/src/logic/logic_parser.mly"
                           ( info (PLsizeofE _3) )
# 2350 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'logic_type) in
    Obj.repr(
# 206 "cil/src/logic/logic_parser.mly"
                                ( info (PLsizeof _3) )
# 2357 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr) in
    Obj.repr(
# 207 "cil/src/logic/logic_parser.mly"
                        ( info (PLold _3) )
# 2364 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'lexpr) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'label) in
    Obj.repr(
# 208 "cil/src/logic/logic_parser.mly"
                                   ( info (PLat (_3, _5)) )
# 2372 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr) in
    Obj.repr(
# 209 "cil/src/logic/logic_parser.mly"
                              ( info (PLbase_addr _3) )
# 2379 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr) in
    Obj.repr(
# 210 "cil/src/logic/logic_parser.mly"
                                 ( info (PLblock_length _3) )
# 2386 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    Obj.repr(
# 211 "cil/src/logic/logic_parser.mly"
           ( info PLresult )
# 2392 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'ne_lexpr_list) in
    Obj.repr(
# 213 "cil/src/logic/logic_parser.mly"
      ( info (PLapp (_1, [], _3)) )
# 2400 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'ne_lexpr_list) in
    Obj.repr(
# 215 "cil/src/logic/logic_parser.mly"
      ( info (PLseparated _3) )
# 2407 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 6 : 'identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 4 : 'ne_tvar_list) in
    let _6 = (Parsing.peek_val __caml_parser_env 1 : 'ne_lexpr_list) in
    Obj.repr(
# 217 "cil/src/logic/logic_parser.mly"
      ( info (PLapp (_1, _3, _6)) )
# 2416 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'ne_tvar_list) in
    Obj.repr(
# 219 "cil/src/logic/logic_parser.mly"
      ( info (PLapp (_1, _3, [])) )
# 2424 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'identifier) in
    Obj.repr(
# 220 "cil/src/logic/logic_parser.mly"
                                ( info (PLvar _1) )
# 2431 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 221 "cil/src/logic/logic_parser.mly"
                                 ( info (PLbinop (_1, Brshift, _3)))
# 2439 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 222 "cil/src/logic/logic_parser.mly"
                                 ( info (PLbinop (_1, Blshift, _3)))
# 2447 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr) in
    Obj.repr(
# 223 "cil/src/logic/logic_parser.mly"
                                   ( info _2.lexpr_node )
# 2454 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'range) in
    Obj.repr(
# 224 "cil/src/logic/logic_parser.mly"
                    ( info _2.lexpr_node )
# 2461 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'logic_type) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 226 "cil/src/logic/logic_parser.mly"
      ( info (PLcast (_2, _4)) )
# 2469 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 228 "cil/src/logic/logic_parser.mly"
      ( info (PLsubtype (_1, _3)) )
# 2477 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'logic_type) in
    Obj.repr(
# 230 "cil/src/logic/logic_parser.mly"
      ( info (PLcoercion (_1, _3)) )
# 2485 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 232 "cil/src/logic/logic_parser.mly"
      ( info (PLcoercionE (_1, _3)) )
# 2493 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr) in
    Obj.repr(
# 233 "cil/src/logic/logic_parser.mly"
                           ( info (PLtypeof _3) )
# 2500 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'type_spec) in
    Obj.repr(
# 234 "cil/src/logic/logic_parser.mly"
                                    ( info (PLtype _3) )
# 2507 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    Obj.repr(
# 236 "cil/src/logic/logic_parser.mly"
          ( info PLempty )
# 2513 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr_list) in
    Obj.repr(
# 237 "cil/src/logic/logic_parser.mly"
                                 ( info (PLunion _3) )
# 2520 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr_list) in
    Obj.repr(
# 238 "cil/src/logic/logic_parser.mly"
                               ( info (PLinter _3) )
# 2527 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'lexpr) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'binders) in
    Obj.repr(
# 240 "cil/src/logic/logic_parser.mly"
      (info (PLcomprehension (_2,_4,None)) )
# 2535 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 5 : 'lexpr) in
    let _4 = (Parsing.peek_val __caml_parser_env 3 : 'binders) in
    let _6 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr) in
    Obj.repr(
# 242 "cil/src/logic/logic_parser.mly"
      ( info (PLcomprehension (_2,_4,Some _6)) )
# 2544 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 5 : 'lexpr) in
    let _4 = (Parsing.peek_val __caml_parser_env 3 : 'identifier) in
    let _6 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr) in
    Obj.repr(
# 244 "cil/src/logic/logic_parser.mly"
                                                   ( info (PLupdate(_2,_4,_6)) )
# 2553 "cil/src/logic/logic_parser.ml"
               : 'lexpr_inner))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : bool*string) in
    Obj.repr(
# 248 "cil/src/logic/logic_parser.mly"
                   ( _1 )
# 2560 "cil/src/logic/logic_parser.ml"
               : 'string))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'string) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : bool*string) in
    Obj.repr(
# 249 "cil/src/logic/logic_parser.mly"
                          (
      let (is_wide,prefix) = _1 in
      let (is_wide2,suffix) = _2 in
      (is_wide || is_wide2, prefix ^ suffix)
    )
# 2572 "cil/src/logic/logic_parser.ml"
               : 'string))
; (fun __caml_parser_env ->
    Obj.repr(
# 256 "cil/src/logic/logic_parser.mly"
          ( Lt )
# 2578 "cil/src/logic/logic_parser.ml"
               : 'relation))
; (fun __caml_parser_env ->
    Obj.repr(
# 257 "cil/src/logic/logic_parser.mly"
          ( Gt )
# 2584 "cil/src/logic/logic_parser.ml"
               : 'relation))
; (fun __caml_parser_env ->
    Obj.repr(
# 258 "cil/src/logic/logic_parser.mly"
          ( Le )
# 2590 "cil/src/logic/logic_parser.ml"
               : 'relation))
; (fun __caml_parser_env ->
    Obj.repr(
# 259 "cil/src/logic/logic_parser.mly"
          ( Ge )
# 2596 "cil/src/logic/logic_parser.ml"
               : 'relation))
; (fun __caml_parser_env ->
    Obj.repr(
# 260 "cil/src/logic/logic_parser.mly"
          ( Eq )
# 2602 "cil/src/logic/logic_parser.ml"
               : 'relation))
; (fun __caml_parser_env ->
    Obj.repr(
# 261 "cil/src/logic/logic_parser.mly"
          ( Neq )
# 2608 "cil/src/logic/logic_parser.ml"
               : 'relation))
; (fun __caml_parser_env ->
    Obj.repr(
# 263 "cil/src/logic/logic_parser.mly"
          (
      let l = loc () in
      raise
        (Not_well_formed(l,
                         "Assignment operators not allowed in annotations."))
    )
# 2619 "cil/src/logic/logic_parser.ml"
               : 'relation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr_option) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_option) in
    Obj.repr(
# 273 "cil/src/logic/logic_parser.mly"
                                   ( info (PLrange(_1,_3)) )
# 2627 "cil/src/logic/logic_parser.ml"
               : 'range))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr) in
    Obj.repr(
# 276 "cil/src/logic/logic_parser.mly"
            ( _1 )
# 2634 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr) in
    Obj.repr(
# 281 "cil/src/logic/logic_parser.mly"
                      ( info (PLimplies (_1, _3)) )
# 2642 "cil/src/logic/logic_parser.ml"
               : 'lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr) in
    Obj.repr(
# 282 "cil/src/logic/logic_parser.mly"
                  ( info (PLiff (_1, _3)) )
# 2650 "cil/src/logic/logic_parser.ml"
               : 'lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr) in
    Obj.repr(
# 283 "cil/src/logic/logic_parser.mly"
                     ( info (PLor (_1, _3)) )
# 2658 "cil/src/logic/logic_parser.ml"
               : 'lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr) in
    Obj.repr(
# 284 "cil/src/logic/logic_parser.mly"
                     ( info (PLand (_1, _3)) )
# 2666 "cil/src/logic/logic_parser.ml"
               : 'lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr) in
    Obj.repr(
# 285 "cil/src/logic/logic_parser.mly"
                        ( info (PLxor (_1, _3)) )
# 2674 "cil/src/logic/logic_parser.ml"
               : 'lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr) in
    Obj.repr(
# 287 "cil/src/logic/logic_parser.mly"
                  ( info (PLbinop (_1, Bbw_and, _3)) )
# 2682 "cil/src/logic/logic_parser.ml"
               : 'lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr) in
    Obj.repr(
# 288 "cil/src/logic/logic_parser.mly"
                   ( info (PLbinop (_1, Bbw_or, _3)) )
# 2690 "cil/src/logic/logic_parser.ml"
               : 'lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr) in
    Obj.repr(
# 289 "cil/src/logic/logic_parser.mly"
                  ( info (PLbinop (_1, Bbw_xor, _3)) )
# 2698 "cil/src/logic/logic_parser.ml"
               : 'lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : 'lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr) in
    Obj.repr(
# 291 "cil/src/logic/logic_parser.mly"
    ( info (PLif (_1, _3, _5)) )
# 2707 "cil/src/logic/logic_parser.ml"
               : 'lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr) in
    Obj.repr(
# 293 "cil/src/logic/logic_parser.mly"
                                          ( info (PLnamed (_1, _3)) )
# 2715 "cil/src/logic/logic_parser.ml"
               : 'lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr) in
    Obj.repr(
# 294 "cil/src/logic/logic_parser.mly"
                                        ( info (PLnamed (_1, _3)) )
# 2723 "cil/src/logic/logic_parser.ml"
               : 'lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_rel) in
    Obj.repr(
# 295 "cil/src/logic/logic_parser.mly"
                                ( _1 )
# 2730 "cil/src/logic/logic_parser.ml"
               : 'lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_inner) in
    Obj.repr(
# 299 "cil/src/logic/logic_parser.mly"
                                ( _1 )
# 2737 "cil/src/logic/logic_parser.ml"
               : 'lexpr_end_rel))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'identifier) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr) in
    Obj.repr(
# 300 "cil/src/logic/logic_parser.mly"
                                                       (info (PLlet(_2,_4,_6)))
# 2746 "cil/src/logic/logic_parser.ml"
               : 'lexpr_end_rel))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'binders) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr) in
    Obj.repr(
# 302 "cil/src/logic/logic_parser.mly"
      ( info (PLforall (_2, _4)) )
# 2754 "cil/src/logic/logic_parser.ml"
               : 'lexpr_end_rel))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'binders) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr) in
    Obj.repr(
# 304 "cil/src/logic/logic_parser.mly"
      ( info (PLexists (_2, _4)) )
# 2762 "cil/src/logic/logic_parser.ml"
               : 'lexpr_end_rel))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'binders) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr) in
    Obj.repr(
# 306 "cil/src/logic/logic_parser.mly"
      ( info (PLlambda (_2,_4)) )
# 2770 "cil/src/logic/logic_parser.ml"
               : 'lexpr_end_rel))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'relation) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr_end_rel) in
    Obj.repr(
# 311 "cil/src/logic/logic_parser.mly"
  ( _1, _2, fst(relation_sense _1 Unknown), None )
# 2778 "cil/src/logic/logic_parser.ml"
               : 'rel_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'relation) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr_inner) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'rel_list) in
    Obj.repr(
# 313 "cil/src/logic/logic_parser.mly"
  (
    let next_rel, rhs, sense, oth_rel = _3 in
    let (sense, correct) = relation_sense _1 sense
    in
    if correct then
      let loc = loc_start _2, loc_end rhs in
      let my_rel = loc_info loc (PLrel(_2,next_rel,rhs)) in
      let oth_rel = match oth_rel with
          None -> my_rel
        | Some rel ->
	    let loc = loc_start _2, loc_end rel in
	    loc_info loc (PLand(my_rel,rel))
      in
      _1,_2,sense,Some oth_rel
    else begin
      let loc = Parsing.rhs_start_pos 1, Parsing.rhs_end_pos 3 in
      raise (Not_well_formed(loc,"Inconsistent relation chain."));
    end
  )
# 2805 "cil/src/logic/logic_parser.ml"
               : 'rel_list))
; (fun __caml_parser_env ->
    Obj.repr(
# 335 "cil/src/logic/logic_parser.mly"
                ( None )
# 2811 "cil/src/logic/logic_parser.ml"
               : 'lexpr_option))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr) in
    Obj.repr(
# 336 "cil/src/logic/logic_parser.mly"
                ( Some _1 )
# 2818 "cil/src/logic/logic_parser.ml"
               : 'lexpr_option))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'binders_reentrance) in
    Obj.repr(
# 341 "cil/src/logic/logic_parser.mly"
                            ( let (_lt, vars) = _1 in vars )
# 2825 "cil/src/logic/logic_parser.ml"
               : 'binders))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec) in
    Obj.repr(
# 344 "cil/src/logic/logic_parser.mly"
            ( let (lt, var) = _1 in (lt, [var]) )
# 2832 "cil/src/logic/logic_parser.ml"
               : 'binders_reentrance))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'binders_reentrance) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'decl_spec) in
    Obj.repr(
# 346 "cil/src/logic/logic_parser.mly"
    ( let _, vars = _1 in
      let (lt, var) = _3 in
        (lt, vars @ [ var ])
    )
# 2843 "cil/src/logic/logic_parser.ml"
               : 'binders_reentrance))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'binders_reentrance) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'var_spec) in
    Obj.repr(
# 351 "cil/src/logic/logic_parser.mly"
    ( let last_type_spec, vars = _1 in
        (last_type_spec, vars @ [ let (modif, name) = _3 in (modif last_type_spec, name)])
    )
# 2853 "cil/src/logic/logic_parser.ml"
               : 'binders_reentrance))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'type_spec) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'var_spec) in
    Obj.repr(
# 356 "cil/src/logic/logic_parser.mly"
                     ( (_1, let (modif, name) = _2 in (modif _1, name))  )
# 2861 "cil/src/logic/logic_parser.ml"
               : 'decl_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'var_spec_bis) in
    Obj.repr(
# 360 "cil/src/logic/logic_parser.mly"
                     ( let (outer, inner,name) = _1 in
                       ((fun x -> outer (inner x)), name))
# 2869 "cil/src/logic/logic_parser.ml"
               : 'var_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'stars) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'var_spec_bis) in
    Obj.repr(
# 363 "cil/src/logic/logic_parser.mly"
  ( let (outer, inner, name) = _2 in
      ((fun x -> outer (inner (_1 x))), name) )
# 2878 "cil/src/logic/logic_parser.ml"
               : 'var_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.constant) in
    Obj.repr(
# 368 "cil/src/logic/logic_parser.mly"
           ( Some _1 )
# 2885 "cil/src/logic/logic_parser.ml"
               : 'constant_option))
; (fun __caml_parser_env ->
    Obj.repr(
# 369 "cil/src/logic/logic_parser.mly"
              ( None )
# 2891 "cil/src/logic/logic_parser.ml"
               : 'constant_option))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'identifier) in
    Obj.repr(
# 373 "cil/src/logic/logic_parser.mly"
                 ( ((fun x -> x),(fun x -> x), _1) )
# 2898 "cil/src/logic/logic_parser.ml"
               : 'var_spec_bis))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'var_spec_bis) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'constant_option) in
    Obj.repr(
# 375 "cil/src/logic/logic_parser.mly"
      (
        let (outer, inner, name) = _1 in
          (outer, (fun x -> inner (LTarray (x,_3))), name)
      )
# 2909 "cil/src/logic/logic_parser.ml"
               : 'var_spec_bis))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'var_spec) in
    Obj.repr(
# 379 "cil/src/logic/logic_parser.mly"
                     ( let (modif, name) = _2 in (modif, (fun x -> x), name) )
# 2916 "cil/src/logic/logic_parser.ml"
               : 'var_spec_bis))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'var_spec_bis) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'abs_param_type_list) in
    Obj.repr(
# 381 "cil/src/logic/logic_parser.mly"
      ( let (outer, inner,name) = _1 in
        let params = _3 in
        (outer, (fun x -> inner (LTarrow (params,x))), name)
      )
# 2927 "cil/src/logic/logic_parser.ml"
               : 'var_spec_bis))
; (fun __caml_parser_env ->
    Obj.repr(
# 388 "cil/src/logic/logic_parser.mly"
              ( [ ] )
# 2933 "cil/src/logic/logic_parser.ml"
               : 'abs_param_type_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'abs_param_list) in
    Obj.repr(
# 389 "cil/src/logic/logic_parser.mly"
                 ( _1 )
# 2940 "cil/src/logic/logic_parser.ml"
               : 'abs_param_type_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'abs_param_list) in
    Obj.repr(
# 390 "cil/src/logic/logic_parser.mly"
                                 ( (* TODO *) raise Parse_error )
# 2947 "cil/src/logic/logic_parser.ml"
               : 'abs_param_type_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'abs_param) in
    Obj.repr(
# 394 "cil/src/logic/logic_parser.mly"
            ( [ _1 ] )
# 2954 "cil/src/logic/logic_parser.ml"
               : 'abs_param_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'abs_param_list) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'abs_param) in
    Obj.repr(
# 395 "cil/src/logic/logic_parser.mly"
                                 ( _1 @ [ _3 ] )
# 2962 "cil/src/logic/logic_parser.ml"
               : 'abs_param_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'logic_type) in
    Obj.repr(
# 402 "cil/src/logic/logic_parser.mly"
             ( _1 )
# 2969 "cil/src/logic/logic_parser.ml"
               : 'abs_param))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'identifier) in
    Obj.repr(
# 408 "cil/src/logic/logic_parser.mly"
             ( LTnamed(_1, []) )
# 2976 "cil/src/logic/logic_parser.ml"
               : 'id_as_typename))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'parameter) in
    Obj.repr(
# 412 "cil/src/logic/logic_parser.mly"
            ( [_1] )
# 2983 "cil/src/logic/logic_parser.ml"
               : 'ne_parameters))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'parameter) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'ne_parameters) in
    Obj.repr(
# 413 "cil/src/logic/logic_parser.mly"
                                ( _1 :: _3 )
# 2991 "cil/src/logic/logic_parser.ml"
               : 'ne_parameters))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'type_spec) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'var_spec) in
    Obj.repr(
# 417 "cil/src/logic/logic_parser.mly"
                     ( let (modif, name) = _2 in (modif _1, name))
# 2999 "cil/src/logic/logic_parser.ml"
               : 'parameter))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'id_as_typename) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'var_spec) in
    Obj.repr(
# 418 "cil/src/logic/logic_parser.mly"
                          ( let (modif, name) = _2 in (modif _1, name) )
# 3007 "cil/src/logic/logic_parser.ml"
               : 'parameter))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'type_spec) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'abs_spec_option) in
    Obj.repr(
# 425 "cil/src/logic/logic_parser.mly"
                            ( _2 _1 )
# 3015 "cil/src/logic/logic_parser.ml"
               : 'logic_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 429 "cil/src/logic/logic_parser.mly"
             ( LTnamed(_1,[]) )
# 3022 "cil/src/logic/logic_parser.ml"
               : 'logic_rt_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'begin_rt_type) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'logic_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'end_rt_type) in
    Obj.repr(
# 430 "cil/src/logic/logic_parser.mly"
                                       ( _2 )
# 3031 "cil/src/logic/logic_parser.ml"
               : 'logic_rt_type))
; (fun __caml_parser_env ->
    Obj.repr(
# 433 "cil/src/logic/logic_parser.mly"
                              ( fun t -> t )
# 3037 "cil/src/logic/logic_parser.ml"
               : 'abs_spec_option))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'abs_spec) in
    Obj.repr(
# 434 "cil/src/logic/logic_parser.mly"
           ( _1 )
# 3044 "cil/src/logic/logic_parser.ml"
               : 'abs_spec_option))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'tabs) in
    Obj.repr(
# 438 "cil/src/logic/logic_parser.mly"
                          ( _1 )
# 3051 "cil/src/logic/logic_parser.ml"
               : 'abs_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'stars) in
    Obj.repr(
# 439 "cil/src/logic/logic_parser.mly"
                                         ( _1 )
# 3058 "cil/src/logic/logic_parser.ml"
               : 'abs_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'stars) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'tabs) in
    Obj.repr(
# 440 "cil/src/logic/logic_parser.mly"
                                         ( fun t -> _2 (_1 t) )
# 3066 "cil/src/logic/logic_parser.ml"
               : 'abs_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'stars) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'abs_spec_bis) in
    Obj.repr(
# 441 "cil/src/logic/logic_parser.mly"
                                         ( fun t -> _2 (_1 t) )
# 3074 "cil/src/logic/logic_parser.ml"
               : 'abs_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'stars) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'abs_spec_bis) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'tabs) in
    Obj.repr(
# 442 "cil/src/logic/logic_parser.mly"
                                         ( fun t -> _2 (_3 (_1 t)) )
# 3083 "cil/src/logic/logic_parser.ml"
               : 'abs_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'abs_spec_bis) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'tabs) in
    Obj.repr(
# 443 "cil/src/logic/logic_parser.mly"
                                         ( fun t -> _1 (_2 t) )
# 3091 "cil/src/logic/logic_parser.ml"
               : 'abs_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'abs_spec_bis) in
    Obj.repr(
# 444 "cil/src/logic/logic_parser.mly"
                                         ( _1 )
# 3098 "cil/src/logic/logic_parser.ml"
               : 'abs_spec))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'abs_spec) in
    Obj.repr(
# 448 "cil/src/logic/logic_parser.mly"
                     ( _2 )
# 3105 "cil/src/logic/logic_parser.ml"
               : 'abs_spec_bis))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'abs_spec_bis) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'abs_param_type_list) in
    Obj.repr(
# 449 "cil/src/logic/logic_parser.mly"
                                             ( fun t -> _1 (LTarrow(_3,t)) )
# 3113 "cil/src/logic/logic_parser.ml"
               : 'abs_spec_bis))
; (fun __caml_parser_env ->
    Obj.repr(
# 453 "cil/src/logic/logic_parser.mly"
             ( fun t -> LTpointer t )
# 3119 "cil/src/logic/logic_parser.ml"
               : 'stars))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'stars) in
    Obj.repr(
# 454 "cil/src/logic/logic_parser.mly"
             ( fun t -> _1 (LTpointer t) )
# 3126 "cil/src/logic/logic_parser.ml"
               : 'stars))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'constant_option) in
    Obj.repr(
# 459 "cil/src/logic/logic_parser.mly"
    (
      fun t -> LTarray (t,_2)
    )
# 3135 "cil/src/logic/logic_parser.ml"
               : 'tabs))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'constant_option) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'tabs) in
    Obj.repr(
# 463 "cil/src/logic/logic_parser.mly"
    (
      fun t -> (LTarray (_4 t,_2))
    )
# 3145 "cil/src/logic/logic_parser.ml"
               : 'tabs))
; (fun __caml_parser_env ->
    Obj.repr(
# 469 "cil/src/logic/logic_parser.mly"
                 ( LTinteger )
# 3151 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 470 "cil/src/logic/logic_parser.mly"
                 ( LTreal )
# 3157 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 471 "cil/src/logic/logic_parser.mly"
                 ( LTnamed (Utf8_logic.boolean,[]) )
# 3163 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 472 "cil/src/logic/logic_parser.mly"
                 ( LTvoid )
# 3169 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 473 "cil/src/logic/logic_parser.mly"
                 ( LTint IChar )
# 3175 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 474 "cil/src/logic/logic_parser.mly"
                 ( LTint ISChar )
# 3181 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 475 "cil/src/logic/logic_parser.mly"
                 ( LTint IUChar )
# 3187 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 476 "cil/src/logic/logic_parser.mly"
                 ( LTint IInt )
# 3193 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 477 "cil/src/logic/logic_parser.mly"
                 ( LTint IInt )
# 3199 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 478 "cil/src/logic/logic_parser.mly"
                 ( LTint IUInt )
# 3205 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 479 "cil/src/logic/logic_parser.mly"
                 ( LTint IUInt )
# 3211 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 480 "cil/src/logic/logic_parser.mly"
                 ( LTint IShort )
# 3217 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 481 "cil/src/logic/logic_parser.mly"
                 ( LTint IShort )
# 3223 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 482 "cil/src/logic/logic_parser.mly"
                 ( LTint IUShort )
# 3229 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 483 "cil/src/logic/logic_parser.mly"
                 ( LTint ILong )
# 3235 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 484 "cil/src/logic/logic_parser.mly"
                 ( LTint ILong )
# 3241 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 485 "cil/src/logic/logic_parser.mly"
                 ( LTint IULong )
# 3247 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 486 "cil/src/logic/logic_parser.mly"
                 ( LTint ILong )
# 3253 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 487 "cil/src/logic/logic_parser.mly"
                 ( LTint ILong )
# 3259 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 488 "cil/src/logic/logic_parser.mly"
                    ( LTint IULong )
# 3265 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 489 "cil/src/logic/logic_parser.mly"
                 ( LTint ILongLong )
# 3271 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 491 "cil/src/logic/logic_parser.mly"
                     ( LTint ILongLong )
# 3277 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 493 "cil/src/logic/logic_parser.mly"
                     ( LTint IULongLong )
# 3283 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 495 "cil/src/logic/logic_parser.mly"
                    ( LTint ILongLong )
# 3289 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 497 "cil/src/logic/logic_parser.mly"
                        ( LTint ILongLong )
# 3295 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 499 "cil/src/logic/logic_parser.mly"
                         ( LTint IULongLong )
# 3301 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 501 "cil/src/logic/logic_parser.mly"
                    ( LTfloat FFloat )
# 3307 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 502 "cil/src/logic/logic_parser.mly"
                    ( LTfloat FDouble )
# 3313 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 503 "cil/src/logic/logic_parser.mly"
                    ( LTfloat FLongDouble )
# 3319 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'exit_rt_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'identifier) in
    Obj.repr(
# 504 "cil/src/logic/logic_parser.mly"
                                 ( LTstruct _3 )
# 3327 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'exit_rt_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'identifier) in
    Obj.repr(
# 505 "cil/src/logic/logic_parser.mly"
                                 ( LTenum _3 )
# 3335 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'exit_rt_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'identifier) in
    Obj.repr(
# 506 "cil/src/logic/logic_parser.mly"
                                  ( LTunion _3 )
# 3343 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 507 "cil/src/logic/logic_parser.mly"
                    ( LTnamed (_1,[]) )
# 3350 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'enter_rt_type) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : 'ne_logic_type_list) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : 'exit_rt_type) in
    Obj.repr(
# 509 "cil/src/logic/logic_parser.mly"
      ( LTnamed(_1,_4) )
# 3360 "cil/src/logic/logic_parser.ml"
               : 'type_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'logic_type) in
    Obj.repr(
# 513 "cil/src/logic/logic_parser.mly"
                                      ( [_1] )
# 3367 "cil/src/logic/logic_parser.ml"
               : 'ne_logic_type_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'logic_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'enter_rt_type) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'ne_logic_type_list) in
    Obj.repr(
# 514 "cil/src/logic/logic_parser.mly"
                                                    ( _1 :: _4 )
# 3376 "cil/src/logic/logic_parser.ml"
               : 'ne_logic_type_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'enter_kw_c_mode) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exit_kw_c_mode) in
    Obj.repr(
# 520 "cil/src/logic/logic_parser.mly"
                                     ( _2 )
# 3385 "cil/src/logic/logic_parser.ml"
               : 'full_lexpr))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'enter_kw_c_mode) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exit_kw_c_mode) in
    Obj.repr(
# 524 "cil/src/logic/logic_parser.mly"
                                          ( _2 )
# 3394 "cil/src/logic/logic_parser.ml"
               : 'full_identifier))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'enter_kw_c_mode) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'identifier_or_typename) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exit_kw_c_mode) in
    Obj.repr(
# 528 "cil/src/logic/logic_parser.mly"
                                                      ( _2 )
# 3403 "cil/src/logic/logic_parser.ml"
               : 'full_identifier_or_typename))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'enter_kw_c_mode) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'ne_parameters) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exit_kw_c_mode) in
    Obj.repr(
# 532 "cil/src/logic/logic_parser.mly"
                                             ( _2 )
# 3412 "cil/src/logic/logic_parser.ml"
               : 'full_parameters))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'enter_kw_c_mode) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'parameter) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exit_kw_c_mode) in
    Obj.repr(
# 536 "cil/src/logic/logic_parser.mly"
                                         ( _2 )
# 3421 "cil/src/logic/logic_parser.ml"
               : 'full_parameter))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'enter_kw_c_mode) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'ne_lexpr_list) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exit_kw_c_mode) in
    Obj.repr(
# 546 "cil/src/logic/logic_parser.mly"
                                             ( _2 )
# 3430 "cil/src/logic/logic_parser.ml"
               : 'full_ne_lexpr_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'enter_kw_c_mode) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'logic_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exit_kw_c_mode) in
    Obj.repr(
# 550 "cil/src/logic/logic_parser.mly"
                                          ( _2 )
# 3439 "cil/src/logic/logic_parser.ml"
               : 'full_logic_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'enter_kw_c_mode) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'logic_rt_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exit_kw_c_mode) in
    Obj.repr(
# 554 "cil/src/logic/logic_parser.mly"
                                               ( _2 )
# 3448 "cil/src/logic/logic_parser.ml"
               : 'full_logic_rt_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'enter_kw_c_mode) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'assigns) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'exit_kw_c_mode) in
    Obj.repr(
# 557 "cil/src/logic/logic_parser.mly"
                                       ( _2 )
# 3457 "cil/src/logic/logic_parser.ml"
               : 'full_assigns))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'location_dep) in
    Obj.repr(
# 561 "cil/src/logic/logic_parser.mly"
               ( _1 )
# 3464 "cil/src/logic/logic_parser.ml"
               : 'assigns))
; (fun __caml_parser_env ->
    Obj.repr(
# 562 "cil/src/logic/logic_parser.mly"
          ( [Nothing,[]] )
# 3470 "cil/src/logic/logic_parser.ml"
               : 'assigns))
; (fun __caml_parser_env ->
    Obj.repr(
# 566 "cil/src/logic/logic_parser.mly"
                ( [] )
# 3476 "cil/src/logic/logic_parser.ml"
               : 'requires))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'full_lexpr) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'requires) in
    Obj.repr(
# 567 "cil/src/logic/logic_parser.mly"
                                         ( _2::_4 )
# 3484 "cil/src/logic/logic_parser.ml"
               : 'requires))
; (fun __caml_parser_env ->
    Obj.repr(
# 572 "cil/src/logic/logic_parser.mly"
                ( [],[],[] )
# 3490 "cil/src/logic/logic_parser.ml"
               : 'behavior_body))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'ne_behavior_body) in
    Obj.repr(
# 573 "cil/src/logic/logic_parser.mly"
                   ( _1 )
# 3497 "cil/src/logic/logic_parser.ml"
               : 'behavior_body))
; (fun __caml_parser_env ->
    Obj.repr(
# 577 "cil/src/logic/logic_parser.mly"
          ( Normal )
# 3503 "cil/src/logic/logic_parser.ml"
               : 'post_cond))
; (fun __caml_parser_env ->
    Obj.repr(
# 578 "cil/src/logic/logic_parser.mly"
          ( Exits )
# 3509 "cil/src/logic/logic_parser.ml"
               : 'post_cond))
; (fun __caml_parser_env ->
    Obj.repr(
# 579 "cil/src/logic/logic_parser.mly"
          ( Breaks )
# 3515 "cil/src/logic/logic_parser.ml"
               : 'post_cond))
; (fun __caml_parser_env ->
    Obj.repr(
# 580 "cil/src/logic/logic_parser.mly"
            ( Continues )
# 3521 "cil/src/logic/logic_parser.ml"
               : 'post_cond))
; (fun __caml_parser_env ->
    Obj.repr(
# 581 "cil/src/logic/logic_parser.mly"
          ( Returns )
# 3527 "cil/src/logic/logic_parser.ml"
               : 'post_cond))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'full_lexpr) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'behavior_body) in
    Obj.repr(
# 585 "cil/src/logic/logic_parser.mly"
    ( let a,b,c = _4 in _2::a,b,c )
# 3535 "cil/src/logic/logic_parser.ml"
               : 'ne_behavior_body))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'post_cond) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'full_lexpr) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'behavior_body) in
    Obj.repr(
# 587 "cil/src/logic/logic_parser.mly"
    ( let a,b,c = _4 in a,(_1,_2)::b,c )
# 3544 "cil/src/logic/logic_parser.ml"
               : 'ne_behavior_body))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'full_assigns) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'behavior_body) in
    Obj.repr(
# 589 "cil/src/logic/logic_parser.mly"
    ( let a,b,c = _4 in
      let assigns =
        match c,_2 with
            ([] | [(Nothing,_) ]), ([] | [(Nothing,_) ]) -> [(Nothing,[])]
          | [(Nothing,_) ], _ | _, [(Nothing,_)] ->
              raise (
                Not_well_formed (loc(),"Mixing \\nothing and a real location"))
          | _,_ -> _2 @ c
      in a,b,assigns
    )
# 3561 "cil/src/logic/logic_parser.ml"
               : 'ne_behavior_body))
; (fun __caml_parser_env ->
    Obj.repr(
# 613 "cil/src/logic/logic_parser.mly"
                ( [] )
# 3567 "cil/src/logic/logic_parser.ml"
               : 'behaviors))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'full_identifier_or_typename) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'behavior_body) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'behaviors) in
    Obj.repr(
# 615 "cil/src/logic/logic_parser.mly"
      ( let (assumes,ensures,assigns) = _4 in
        Logic_utils.check_assigns ~loc:(loc()) assigns;
        {b_name=_2; b_assumes = assumes;
         b_post_cond = ensures;
         b_assigns = assigns}::_5 )
# 3580 "cil/src/logic/logic_parser.ml"
               : 'behaviors))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'behavior_body) in
    Obj.repr(
# 631 "cil/src/logic/logic_parser.mly"
                ( ((*None,*) _1) )
# 3587 "cil/src/logic/logic_parser.ml"
               : 'simple_behavior_body))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'simple_behavior_body) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'behaviors) in
    Obj.repr(
# 636 "cil/src/logic/logic_parser.mly"
    ( let ((* terminates, *)(assumes,ensures,assigns)) = _1 in
      let behaviors =
        if (*TODO: enforce to have a default behavior true || *)
           assumes <> [] || ensures <> [] || assigns <> [] then
          { b_name = "default";b_assumes = assumes;
            b_post_cond = ensures;
            b_assigns = assigns} :: _2
        else _2
      in
      (* terminates, *)behaviors
    )
# 3605 "cil/src/logic/logic_parser.ml"
               : 'behaviors_or_default))
; (fun __caml_parser_env ->
    Obj.repr(
# 650 "cil/src/logic/logic_parser.mly"
                             ( None )
# 3611 "cil/src/logic/logic_parser.ml"
               : 'terminates))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'lexpr) in
    Obj.repr(
# 651 "cil/src/logic/logic_parser.mly"
                             ( Some _2 )
# 3618 "cil/src/logic/logic_parser.ml"
               : 'terminates))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'full_identifier_or_typename) in
    Obj.repr(
# 655 "cil/src/logic/logic_parser.mly"
                              ( [_1] )
# 3625 "cil/src/logic/logic_parser.ml"
               : 'ne_full_identifier_or_typename_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'full_identifier_or_typename) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'ne_full_identifier_or_typename_list) in
    Obj.repr(
# 657 "cil/src/logic/logic_parser.mly"
      (_1 :: _3)
# 3633 "cil/src/logic/logic_parser.ml"
               : 'ne_full_identifier_or_typename_list))
; (fun __caml_parser_env ->
    Obj.repr(
# 661 "cil/src/logic/logic_parser.mly"
                ( [] )
# 3639 "cil/src/logic/logic_parser.ml"
               : 'full_identifier_or_typename_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'ne_full_identifier_or_typename_list) in
    Obj.repr(
# 662 "cil/src/logic/logic_parser.mly"
                                      ( _1 )
# 3646 "cil/src/logic/logic_parser.ml"
               : 'full_identifier_or_typename_list))
; (fun __caml_parser_env ->
    Obj.repr(
# 666 "cil/src/logic/logic_parser.mly"
                ( [],[] )
# 3652 "cil/src/logic/logic_parser.ml"
               : 'complete_or_disjoint))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'full_identifier_or_typename_list) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'complete_or_disjoint) in
    Obj.repr(
# 669 "cil/src/logic/logic_parser.mly"
      ( let (complete,disjoint) = _5 in (_3::complete, disjoint) )
# 3660 "cil/src/logic/logic_parser.ml"
               : 'complete_or_disjoint))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'full_identifier_or_typename_list) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'complete_or_disjoint) in
    Obj.repr(
# 672 "cil/src/logic/logic_parser.mly"
      ( let (complete,disjoint) = _5 in (complete, _3::disjoint) )
# 3668 "cil/src/logic/logic_parser.ml"
               : 'complete_or_disjoint))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 5 : 'requires) in
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'terminates) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'decreases) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : 'behaviors_or_default) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'complete_or_disjoint) in
    Obj.repr(
# 676 "cil/src/logic/logic_parser.mly"
      (
        { spec_requires = _1;
          spec_terminates = _2;
          spec_variant = _3;
          spec_behavior = _4;
          spec_complete_behaviors = fst _5;
          spec_disjoint_behaviors = snd _5;
        },loc() )
# 3686 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.spec * Cabs.cabsloc))
; (fun __caml_parser_env ->
    Obj.repr(
# 691 "cil/src/logic/logic_parser.mly"
           ( () )
# 3692 "cil/src/logic/logic_parser.ml"
               : 'is_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 692 "cil/src/logic/logic_parser.mly"
           ( () )
# 3698 "cil/src/logic/logic_parser.ml"
               : 'is_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 693 "cil/src/logic/logic_parser.mly"
          ( () )
# 3704 "cil/src/logic/logic_parser.ml"
               : 'is_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 694 "cil/src/logic/logic_parser.mly"
        ( () )
# 3710 "cil/src/logic/logic_parser.ml"
               : 'is_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 695 "cil/src/logic/logic_parser.mly"
         ( () )
# 3716 "cil/src/logic/logic_parser.ml"
               : 'is_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 696 "cil/src/logic/logic_parser.mly"
            ( () )
# 3722 "cil/src/logic/logic_parser.ml"
               : 'is_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 697 "cil/src/logic/logic_parser.mly"
          ( () )
# 3728 "cil/src/logic/logic_parser.ml"
               : 'is_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 698 "cil/src/logic/logic_parser.mly"
          ( () )
# 3734 "cil/src/logic/logic_parser.ml"
               : 'is_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 699 "cil/src/logic/logic_parser.mly"
            ( () )
# 3740 "cil/src/logic/logic_parser.ml"
               : 'is_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 700 "cil/src/logic/logic_parser.mly"
             ( () )
# 3746 "cil/src/logic/logic_parser.ml"
               : 'is_spec))
; (fun __caml_parser_env ->
    Obj.repr(
# 701 "cil/src/logic/logic_parser.mly"
           ( () )
# 3752 "cil/src/logic/logic_parser.ml"
               : 'is_spec))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'loop_annot_stack) in
    Obj.repr(
# 707 "cil/src/logic/logic_parser.mly"
    ( let (i,a,b,v,p) = _1 in
      let invs = List.map (fun i -> AInvariant([],true,i)) i in
      let assigns = List.map (fun i -> AAssigns([],i)) a in
      (invs@assigns@b,v,p)
(*
      match i,a with
	| [],[] -> (b,v,p)
	| _ -> (ALoopBehavior([],i,a)::b,v,p)
*)
    )
# 3768 "cil/src/logic/logic_parser.ml"
               : 'loop_annotations))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'loop_invariant) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'loop_annot_opt) in
    Obj.repr(
# 721 "cil/src/logic/logic_parser.mly"
    ( let (i,a,b,v,p) = _2 in (_1::i,a,b,v,p) )
# 3776 "cil/src/logic/logic_parser.ml"
               : 'loop_annot_stack))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'loop_effects) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'loop_annot_opt) in
    Obj.repr(
# 723 "cil/src/logic/logic_parser.mly"
    ( let (i,a,b,v,p) = _2 in (i,_1 @ a,b,v,p) )
# 3784 "cil/src/logic/logic_parser.ml"
               : 'loop_annot_stack))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'ne_full_identifier_or_typename_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'loop_annot_opt) in
    Obj.repr(
# 725 "cil/src/logic/logic_parser.mly"
    ( let (i,a,b,v,p) = _4 in
      let behav = _2 in
      let invs = List.map (fun i -> AInvariant(behav,true,i)) i in
      let assigns = List.map (fun i -> AAssigns(behav,i)) a in
      ([],[],invs@assigns@b,v,p) )
# 3796 "cil/src/logic/logic_parser.ml"
               : 'loop_annot_stack))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'loop_variant) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'loop_annot_opt) in
    Obj.repr(
# 731 "cil/src/logic/logic_parser.mly"
    ( let (i,a,b,v,p) = _2 in (i,a,b,AVariant _1::v,p) )
# 3804 "cil/src/logic/logic_parser.ml"
               : 'loop_annot_stack))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'loop_pragma) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'loop_annot_opt) in
    Obj.repr(
# 733 "cil/src/logic/logic_parser.mly"
    ( let (i,a,b,v,p) = _2 in (i,a,b,v,APragma (Loop_pragma _1)::p) )
# 3812 "cil/src/logic/logic_parser.ml"
               : 'loop_annot_stack))
; (fun __caml_parser_env ->
    Obj.repr(
# 738 "cil/src/logic/logic_parser.mly"
    ( ([],[],[],[],[]) )
# 3818 "cil/src/logic/logic_parser.ml"
               : 'loop_annot_opt))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'loop_annot_stack) in
    Obj.repr(
# 740 "cil/src/logic/logic_parser.mly"
    ( _1 )
# 3825 "cil/src/logic/logic_parser.ml"
               : 'loop_annot_opt))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 6 : 'full_identifier) in
    let _5 = (Parsing.peek_val __caml_parser_env 4 : 'full_parameter) in
    let _8 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 749 "cil/src/logic/logic_parser.mly"
  ( let typ,name = _5 in{ inv_name = _3; this_name = name; this_type = typ; inv = _8; } )
# 3834 "cil/src/logic/logic_parser.ml"
               : 'type_annot))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'full_lexpr) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'full_identifier) in
    Obj.repr(
# 753 "cil/src/logic/logic_parser.mly"
                                 ( (_1, Some _3) )
# 3842 "cil/src/logic/logic_parser.ml"
               : 'variant))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'full_lexpr) in
    Obj.repr(
# 754 "cil/src/logic/logic_parser.mly"
                            ( (_1, None) )
# 3849 "cil/src/logic/logic_parser.ml"
               : 'variant))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 758 "cil/src/logic/logic_parser.mly"
                                      ( _3 )
# 3856 "cil/src/logic/logic_parser.ml"
               : 'loop_invariant))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'variant) in
    Obj.repr(
# 762 "cil/src/logic/logic_parser.mly"
                                 ( _3 )
# 3863 "cil/src/logic/logic_parser.ml"
               : 'loop_variant))
; (fun __caml_parser_env ->
    Obj.repr(
# 766 "cil/src/logic/logic_parser.mly"
                  ( None )
# 3869 "cil/src/logic/logic_parser.ml"
               : 'decreases))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'variant) in
    Obj.repr(
# 767 "cil/src/logic/logic_parser.mly"
                              ( Some _2 )
# 3876 "cil/src/logic/logic_parser.ml"
               : 'decreases))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'slice_pragma) in
    Obj.repr(
# 771 "cil/src/logic/logic_parser.mly"
                   ( APragma (Slice_pragma _1) )
# 3883 "cil/src/logic/logic_parser.ml"
               : 'code_annotation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'impact_pragma) in
    Obj.repr(
# 772 "cil/src/logic/logic_parser.mly"
                   ( APragma (Impact_pragma _1) )
# 3890 "cil/src/logic/logic_parser.ml"
               : 'code_annotation))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'ne_full_identifier_or_typename_list) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 774 "cil/src/logic/logic_parser.mly"
      ( AAssert (_2,_5,{status=Cil_types.Unknown}) )
# 3898 "cil/src/logic/logic_parser.ml"
               : 'code_annotation))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 775 "cil/src/logic/logic_parser.mly"
                                 ( AAssert ([],_2,{status=Cil_types.Unknown}) )
# 3905 "cil/src/logic/logic_parser.ml"
               : 'code_annotation))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 776 "cil/src/logic/logic_parser.mly"
                                 ( AInvariant ([],false,_2) )
# 3912 "cil/src/logic/logic_parser.ml"
               : 'code_annotation))
; (fun __caml_parser_env ->
    Obj.repr(
# 780 "cil/src/logic/logic_parser.mly"
              ( )
# 3918 "cil/src/logic/logic_parser.ml"
               : 'loop_pragma_tk))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'loop_pragma_tk) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'full_ne_lexpr_list) in
    Obj.repr(
# 785 "cil/src/logic/logic_parser.mly"
  ( if _2 = "UNROLL_LOOP" || _2 = "UNROLL" then
      match _3 with
        | [level] -> Unroll_level level
        | _ -> raise(
            Not_well_formed(loc(),"usage: loop pragma UNROLL n;"))
    else if _2 = "WIDEN_VARIABLES" then
      Widen_variables _3
    else if _2 = "WIDEN_HINTS" then
      Widen_hints _3
    else raise (Not_well_formed (loc(),"unknown loop pragma")) )
# 3936 "cil/src/logic/logic_parser.ml"
               : 'loop_pragma))
; (fun __caml_parser_env ->
    Obj.repr(
# 797 "cil/src/logic/logic_parser.mly"
               ( )
# 3942 "cil/src/logic/logic_parser.ml"
               : 'slice_pragma_tk))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'slice_pragma_tk) in
    let _2 = (Parsing.peek_val __caml_parser_env 2 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 802 "cil/src/logic/logic_parser.mly"
    ( if _2 = "expr" then SPexpr _3
      else raise (Not_well_formed (loc(), "unknown slice pragma")) )
# 3952 "cil/src/logic/logic_parser.ml"
               : 'slice_pragma))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'slice_pragma_tk) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : string) in
    Obj.repr(
# 805 "cil/src/logic/logic_parser.mly"
    ( if _2 = "ctrl" then SPctrl
      else if _2 = "stmt" then SPstmt
      else raise (Not_well_formed (loc(), "unknown slice pragma")) )
# 3962 "cil/src/logic/logic_parser.ml"
               : 'slice_pragma))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 2 : string) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 811 "cil/src/logic/logic_parser.mly"
    ( if _3 = "expr" then IPexpr _4
      else raise (Not_well_formed (loc(), "unknown impact pragma")) )
# 3971 "cil/src/logic/logic_parser.ml"
               : 'impact_pragma))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : string) in
    Obj.repr(
# 814 "cil/src/logic/logic_parser.mly"
    ( if _3 = "stmt" then IPstmt
      else raise (Not_well_formed (loc(), "unknown impact pragma")) )
# 3979 "cil/src/logic/logic_parser.ml"
               : 'impact_pragma))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'full_assigns) in
    Obj.repr(
# 818 "cil/src/logic/logic_parser.mly"
                                      ( _3 )
# 3986 "cil/src/logic/logic_parser.ml"
               : 'loop_effects))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'zones) in
    Obj.repr(
# 822 "cil/src/logic/logic_parser.mly"
        ( List.map (fun x -> (x,[])) _1 )
# 3993 "cil/src/logic/logic_parser.ml"
               : 'location_dep))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'zones) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'zones) in
    Obj.repr(
# 823 "cil/src/logic/logic_parser.mly"
                   (List.map (fun x -> (x, _3)) _1)
# 4001 "cil/src/logic/logic_parser.ml"
               : 'location_dep))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'zones) in
    Obj.repr(
# 824 "cil/src/logic/logic_parser.mly"
                      (List.map (fun x -> (x, [Nothing])) _1)
# 4008 "cil/src/logic/logic_parser.ml"
               : 'location_dep))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'tsets) in
    Obj.repr(
# 826 "cil/src/logic/logic_parser.mly"
              ( List.map (fun x -> Location x) _1 )
# 4015 "cil/src/logic/logic_parser.ml"
               : 'zones))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'location) in
    Obj.repr(
# 829 "cil/src/logic/logic_parser.mly"
           ( [_1] )
# 4022 "cil/src/logic/logic_parser.ml"
               : 'tsets))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'location) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'tsets) in
    Obj.repr(
# 830 "cil/src/logic/logic_parser.mly"
                       ( _1 :: _3 )
# 4030 "cil/src/logic/logic_parser.ml"
               : 'tsets))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'lexpr) in
    Obj.repr(
# 834 "cil/src/logic/logic_parser.mly"
        ( _1 )
# 4037 "cil/src/logic/logic_parser.ml"
               : 'location))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'full_identifier) in
    Obj.repr(
# 839 "cil/src/logic/logic_parser.mly"
    ( enter_type_variables_scope []; (_1,[]) )
# 4044 "cil/src/logic/logic_parser.ml"
               : 'poly_id_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'full_identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'ne_tvar_list) in
    Obj.repr(
# 841 "cil/src/logic/logic_parser.mly"
        ( enter_type_variables_scope _3; (_1,_3) )
# 4052 "cil/src/logic/logic_parser.ml"
               : 'poly_id_type))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'poly_id_type) in
    Obj.repr(
# 847 "cil/src/logic/logic_parser.mly"
               ( let (id,_) = _1 in Logic_env.add_typename id; _1 )
# 4059 "cil/src/logic/logic_parser.ml"
               : 'poly_id_type_add_typename))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'poly_id_type) in
    Obj.repr(
# 850 "cil/src/logic/logic_parser.mly"
               ( let (id,tvar) = _1 in (id,[],tvar) )
# 4066 "cil/src/logic/logic_parser.ml"
               : 'poly_id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'full_identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'ne_label_list) in
    Obj.repr(
# 852 "cil/src/logic/logic_parser.mly"
      ( enter_type_variables_scope []; (_1,_3,[]) )
# 4074 "cil/src/logic/logic_parser.ml"
               : 'poly_id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 6 : 'full_identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 4 : 'ne_label_list) in
    let _6 = (Parsing.peek_val __caml_parser_env 1 : 'ne_tvar_list) in
    Obj.repr(
# 854 "cil/src/logic/logic_parser.mly"
      ( enter_type_variables_scope _6; _1,_3,_6 )
# 4083 "cil/src/logic/logic_parser.ml"
               : 'poly_id))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 857 "cil/src/logic/logic_parser.mly"
             ( _1 )
# 4090 "cil/src/logic/logic_parser.ml"
               : 'identifier))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 861 "cil/src/logic/logic_parser.mly"
             ( _1 )
# 4097 "cil/src/logic/logic_parser.ml"
               : 'identifier_or_typename))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 862 "cil/src/logic/logic_parser.mly"
           ( _1 )
# 4104 "cil/src/logic/logic_parser.ml"
               : 'identifier_or_typename))
; (fun __caml_parser_env ->
    Obj.repr(
# 866 "cil/src/logic/logic_parser.mly"
              ( [] )
# 4110 "cil/src/logic/logic_parser.ml"
               : 'opt_parameters))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'parameters) in
    Obj.repr(
# 867 "cil/src/logic/logic_parser.mly"
             ( _1 )
# 4117 "cil/src/logic/logic_parser.ml"
               : 'opt_parameters))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'full_parameters) in
    Obj.repr(
# 871 "cil/src/logic/logic_parser.mly"
                            ( _2 )
# 4124 "cil/src/logic/logic_parser.ml"
               : 'parameters))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'logic_def) in
    Obj.repr(
# 875 "cil/src/logic/logic_parser.mly"
             ( _1 )
# 4131 "cil/src/logic/logic_parser.ml"
               : 'decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'deprecated_logic_decl) in
    Obj.repr(
# 877 "cil/src/logic/logic_parser.mly"
    ( _1 )
# 4138 "cil/src/logic/logic_parser.ml"
               : 'decl))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'full_identifier) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 879 "cil/src/logic/logic_parser.mly"
    ( LDinvariant (_3, _5) )
# 4146 "cil/src/logic/logic_parser.ml"
               : 'decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'type_annot) in
    Obj.repr(
# 880 "cil/src/logic/logic_parser.mly"
             (LDtype_annot _1)
# 4153 "cil/src/logic/logic_parser.ml"
               : 'decl))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 5 : 'full_logic_rt_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 4 : 'poly_id) in
    let _4 = (Parsing.peek_val __caml_parser_env 3 : 'opt_parameters) in
    let _6 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 886 "cil/src/logic/logic_parser.mly"
    ( let (id, labels, tvars) = _3 in
      exit_type_variables_scope ();
      LDlogic_def (id, labels, tvars, _2, _4, _6) )
# 4165 "cil/src/logic/logic_parser.ml"
               : 'logic_def))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'poly_id) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'opt_parameters) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 891 "cil/src/logic/logic_parser.mly"
    ( let (id,labels,tvars) = _2 in
      exit_type_variables_scope ();
      LDpredicate_def (id, labels, tvars, _3, _5) )
# 4176 "cil/src/logic/logic_parser.ml"
               : 'logic_def))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'poly_id) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'parameters) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'indcases) in
    Obj.repr(
# 896 "cil/src/logic/logic_parser.mly"
    ( let (id,labels,tvars) = _2 in
      exit_type_variables_scope ();
      LDinductive_def(id, labels, tvars, _3, _5) )
# 4187 "cil/src/logic/logic_parser.ml"
               : 'logic_def))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'poly_id) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 900 "cil/src/logic/logic_parser.mly"
    ( let (id,labels,tvars) = _2 in
      exit_type_variables_scope ();
      LDlemma (id, false, labels, tvars, _4) )
# 4197 "cil/src/logic/logic_parser.ml"
               : 'logic_def))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'full_identifier_or_typename) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'logic_decls) in
    Obj.repr(
# 904 "cil/src/logic/logic_parser.mly"
    ( LDaxiomatic(_2,_4) )
# 4205 "cil/src/logic/logic_parser.ml"
               : 'logic_def))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'poly_id_type_add_typename) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'typedef) in
    Obj.repr(
# 906 "cil/src/logic/logic_parser.mly"
        ( let (id,tvars) = _2 in
          exit_type_variables_scope ();
          LDtype(id,tvars,Some _4)
        )
# 4216 "cil/src/logic/logic_parser.ml"
               : 'logic_def))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'full_logic_rt_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'poly_id) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'opt_parameters) in
    Obj.repr(
# 915 "cil/src/logic/logic_parser.mly"
    ( let (id, labels, tvars) = _3 in
      exit_type_variables_scope ();
      Format.eprintf "Warning: deprecated logic declaration '%s', should be declared inside an axiomatic block@." id;
      LDlogic_reads (id, labels, tvars, _2, _4, None) )
# 4228 "cil/src/logic/logic_parser.ml"
               : 'deprecated_logic_decl))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'poly_id) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'opt_parameters) in
    Obj.repr(
# 921 "cil/src/logic/logic_parser.mly"
    ( let (id,labels,tvars) = _2 in
      exit_type_variables_scope ();
      Format.eprintf "Warning: deprecated logic declaration `%s', should be declared inside an axiomatic block@." id;
      LDpredicate_reads (id, labels, tvars, _3, None) )
# 4239 "cil/src/logic/logic_parser.ml"
               : 'deprecated_logic_decl))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'poly_id_type) in
    Obj.repr(
# 927 "cil/src/logic/logic_parser.mly"
    ( let (id,tvars) = _2 in
      Logic_env.add_typename id;
      exit_type_variables_scope ();
      Format.eprintf "Warning: deprecated logic type declaration `%s', should be declared inside an axiomatic block@." id;
      LDtype(id,tvars,None) )
# 4250 "cil/src/logic/logic_parser.ml"
               : 'deprecated_logic_decl))
; (fun __caml_parser_env ->
    Obj.repr(
# 937 "cil/src/logic/logic_parser.mly"
    ( [] )
# 4256 "cil/src/logic/logic_parser.ml"
               : 'logic_decls))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'logic_decl_loc) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'logic_decls) in
    Obj.repr(
# 939 "cil/src/logic/logic_parser.mly"
    ( _1::_2 )
# 4264 "cil/src/logic/logic_parser.ml"
               : 'logic_decls))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'logic_def) in
    Obj.repr(
# 943 "cil/src/logic/logic_parser.mly"
             ( _1 )
# 4271 "cil/src/logic/logic_parser.ml"
               : 'logic_decl))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'full_logic_rt_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 3 : 'poly_id) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : 'opt_parameters) in
    let _5 = (Parsing.peek_val __caml_parser_env 1 : 'reads_clause) in
    Obj.repr(
# 946 "cil/src/logic/logic_parser.mly"
    ( let (id, labels, tvars) = _3 in
      exit_type_variables_scope ();
      LDlogic_reads (id, labels, tvars, _2, _4, _5) )
# 4283 "cil/src/logic/logic_parser.ml"
               : 'logic_decl))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'poly_id) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'opt_parameters) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'reads_clause) in
    Obj.repr(
# 951 "cil/src/logic/logic_parser.mly"
    ( let (id,labels,tvars) = _2 in
      exit_type_variables_scope ();
      LDpredicate_reads (id, labels, tvars, _3, _4) )
# 4294 "cil/src/logic/logic_parser.ml"
               : 'logic_decl))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'poly_id_type) in
    Obj.repr(
# 956 "cil/src/logic/logic_parser.mly"
    ( let (id,tvars) = _2 in
      Logic_env.add_typename id;
      exit_type_variables_scope ();
      LDtype(id,tvars,None) )
# 4304 "cil/src/logic/logic_parser.ml"
               : 'logic_decl))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 3 : 'poly_id) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'full_lexpr) in
    Obj.repr(
# 962 "cil/src/logic/logic_parser.mly"
    ( let (id,labels,tvars) = _2 in
      exit_type_variables_scope ();
      LDlemma (id, true, labels, tvars, _4) )
# 4314 "cil/src/logic/logic_parser.ml"
               : 'logic_decl))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'logic_decl) in
    Obj.repr(
# 968 "cil/src/logic/logic_parser.mly"
           ( loc_decl _1 )
# 4321 "cil/src/logic/logic_parser.ml"
               : 'logic_decl_loc))
; (fun __caml_parser_env ->
    Obj.repr(
# 974 "cil/src/logic/logic_parser.mly"
    ( None )
# 4327 "cil/src/logic/logic_parser.ml"
               : 'reads_clause))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'tsets) in
    Obj.repr(
# 976 "cil/src/logic/logic_parser.mly"
    ( Some _2 )
# 4334 "cil/src/logic/logic_parser.ml"
               : 'reads_clause))
; (fun __caml_parser_env ->
    Obj.repr(
# 978 "cil/src/logic/logic_parser.mly"
    ( Some [] )
# 4340 "cil/src/logic/logic_parser.ml"
               : 'reads_clause))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'ne_datacons_list) in
    Obj.repr(
# 982 "cil/src/logic/logic_parser.mly"
                   ( TDsum _1 )
# 4347 "cil/src/logic/logic_parser.ml"
               : 'typedef))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'full_logic_type) in
    Obj.repr(
# 983 "cil/src/logic/logic_parser.mly"
                  ( TDsyn _1 )
# 4354 "cil/src/logic/logic_parser.ml"
               : 'typedef))
; (fun __caml_parser_env ->
    Obj.repr(
# 986 "cil/src/logic/logic_parser.mly"
                ( [] )
# 4360 "cil/src/logic/logic_parser.ml"
               : 'datacons_list))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'datacons) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'datacons_list) in
    Obj.repr(
# 987 "cil/src/logic/logic_parser.mly"
                              ( _2 :: _3 )
# 4368 "cil/src/logic/logic_parser.ml"
               : 'datacons_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'datacons) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'datacons_list) in
    Obj.repr(
# 990 "cil/src/logic/logic_parser.mly"
                         ( _1 :: _2 )
# 4376 "cil/src/logic/logic_parser.ml"
               : 'ne_datacons_list))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'datacons) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'datacons_list) in
    Obj.repr(
# 991 "cil/src/logic/logic_parser.mly"
                              ( _2 :: _3 )
# 4384 "cil/src/logic/logic_parser.ml"
               : 'ne_datacons_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'full_identifier) in
    Obj.repr(
# 995 "cil/src/logic/logic_parser.mly"
                  ( (_1,[]) )
# 4391 "cil/src/logic/logic_parser.ml"
               : 'datacons))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : 'full_identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'ne_type_list) in
    Obj.repr(
# 996 "cil/src/logic/logic_parser.mly"
                                         ( (_1,_3) )
# 4399 "cil/src/logic/logic_parser.ml"
               : 'datacons))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'full_logic_type) in
    Obj.repr(
# 1000 "cil/src/logic/logic_parser.mly"
                  ( [_1] )
# 4406 "cil/src/logic/logic_parser.ml"
               : 'ne_type_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'full_logic_type) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'ne_type_list) in
    Obj.repr(
# 1001 "cil/src/logic/logic_parser.mly"
                                     ( _1::_3 )
# 4414 "cil/src/logic/logic_parser.ml"
               : 'ne_type_list))
; (fun __caml_parser_env ->
    Obj.repr(
# 1005 "cil/src/logic/logic_parser.mly"
    ( [] )
# 4420 "cil/src/logic/logic_parser.ml"
               : 'indcases))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 4 : 'poly_id) in
    let _4 = (Parsing.peek_val __caml_parser_env 2 : 'lexpr) in
    let _6 = (Parsing.peek_val __caml_parser_env 0 : 'indcases) in
    Obj.repr(
# 1007 "cil/src/logic/logic_parser.mly"
    ( let (id,labels,tvars) = _2 in
      exit_type_variables_scope ();
      (id,labels,tvars,_4)::_6 )
# 4431 "cil/src/logic/logic_parser.ml"
               : 'indcases))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'full_identifier) in
    Obj.repr(
# 1014 "cil/src/logic/logic_parser.mly"
                  ( [_1] )
# 4438 "cil/src/logic/logic_parser.ml"
               : 'ne_tvar_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'full_identifier) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'ne_tvar_list) in
    Obj.repr(
# 1015 "cil/src/logic/logic_parser.mly"
                                     ( _1 :: _3 )
# 4446 "cil/src/logic/logic_parser.ml"
               : 'ne_tvar_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'label) in
    Obj.repr(
# 1019 "cil/src/logic/logic_parser.mly"
        ( [_1] )
# 4453 "cil/src/logic/logic_parser.ml"
               : 'ne_label_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'label) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'ne_label_list) in
    Obj.repr(
# 1020 "cil/src/logic/logic_parser.mly"
                            ( _1 :: _3 )
# 4461 "cil/src/logic/logic_parser.ml"
               : 'ne_label_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'full_identifier) in
    Obj.repr(
# 1024 "cil/src/logic/logic_parser.mly"
                  ( _1 )
# 4468 "cil/src/logic/logic_parser.ml"
               : 'label))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'annotation) in
    Obj.repr(
# 1028 "cil/src/logic/logic_parser.mly"
                   ( _1 )
# 4475 "cil/src/logic/logic_parser.ml"
               : Logic_ptree.annot))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'decl) in
    Obj.repr(
# 1032 "cil/src/logic/logic_parser.mly"
       ( [loc_decl _1] )
# 4482 "cil/src/logic/logic_parser.ml"
               : 'decl_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'decl) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'decl_list) in
    Obj.repr(
# 1033 "cil/src/logic/logic_parser.mly"
                 ( (loc_decl _1) :: _2 )
# 4490 "cil/src/logic/logic_parser.ml"
               : 'decl_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'decl_list) in
    Obj.repr(
# 1036 "cil/src/logic/logic_parser.mly"
                        ( Adecl (_1) )
# 4497 "cil/src/logic/logic_parser.ml"
               : 'annotation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'is_spec) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'any) in
    Obj.repr(
# 1037 "cil/src/logic/logic_parser.mly"
                   ( Aspec )
# 4505 "cil/src/logic/logic_parser.ml"
               : 'annotation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'loop_annotations) in
    Obj.repr(
# 1039 "cil/src/logic/logic_parser.mly"
      ( let (b,v,p) = _1 in
	(* TODO: do better, do not lose the structure ! *)
	let l = b@v@p in
	Logic_utils.check_loop_annotation ~loc:(loc()) l;
        Aloop_annot (loc (), l) )
# 4516 "cil/src/logic/logic_parser.ml"
               : 'annotation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'code_annotation) in
    Obj.repr(
# 1044 "cil/src/logic/logic_parser.mly"
                  ( Acode_annot (loc(),_1) )
# 4523 "cil/src/logic/logic_parser.ml"
               : 'annotation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 1045 "cil/src/logic/logic_parser.mly"
                  ( Aattribute_annot (loc (), _1) )
# 4530 "cil/src/logic/logic_parser.ml"
               : 'annotation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'wildcard) in
    Obj.repr(
# 1050 "cil/src/logic/logic_parser.mly"
           ( () )
# 4537 "cil/src/logic/logic_parser.ml"
               : 'any))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'wildcard) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'any) in
    Obj.repr(
# 1051 "cil/src/logic/logic_parser.mly"
               ( () )
# 4545 "cil/src/logic/logic_parser.ml"
               : 'any))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 1055 "cil/src/logic/logic_parser.mly"
             ( () )
# 4552 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : bool*string) in
    Obj.repr(
# 1056 "cil/src/logic/logic_parser.mly"
                 ( () )
# 4559 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 1057 "cil/src/logic/logic_parser.mly"
           ( () )
# 4566 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : Logic_ptree.constant) in
    Obj.repr(
# 1058 "cil/src/logic/logic_parser.mly"
           ( () )
# 4573 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1059 "cil/src/logic/logic_parser.mly"
       ( () )
# 4579 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1060 "cil/src/logic/logic_parser.mly"
       ( () )
# 4585 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1061 "cil/src/logic/logic_parser.mly"
     ( () )
# 4591 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1062 "cil/src/logic/logic_parser.mly"
       ( () )
# 4597 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1063 "cil/src/logic/logic_parser.mly"
        ( () )
# 4603 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1064 "cil/src/logic/logic_parser.mly"
         ( () )
# 4609 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1065 "cil/src/logic/logic_parser.mly"
             ( () )
# 4615 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1066 "cil/src/logic/logic_parser.mly"
      ( () )
# 4621 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1067 "cil/src/logic/logic_parser.mly"
         ( () )
# 4627 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1068 "cil/src/logic/logic_parser.mly"
            ( () )
# 4633 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1069 "cil/src/logic/logic_parser.mly"
      ( () )
# 4639 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1070 "cil/src/logic/logic_parser.mly"
          ( () )
# 4645 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1071 "cil/src/logic/logic_parser.mly"
       ( () )
# 4651 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1072 "cil/src/logic/logic_parser.mly"
        ( () )
# 4657 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1073 "cil/src/logic/logic_parser.mly"
     ( () )
# 4663 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1074 "cil/src/logic/logic_parser.mly"
     ( () )
# 4669 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1075 "cil/src/logic/logic_parser.mly"
     ( () )
# 4675 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1076 "cil/src/logic/logic_parser.mly"
     ( () )
# 4681 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1077 "cil/src/logic/logic_parser.mly"
     ( () )
# 4687 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1078 "cil/src/logic/logic_parser.mly"
     ( () )
# 4693 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1079 "cil/src/logic/logic_parser.mly"
        ( () )
# 4699 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1080 "cil/src/logic/logic_parser.mly"
        ( () )
# 4705 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1081 "cil/src/logic/logic_parser.mly"
        ( () )
# 4711 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1082 "cil/src/logic/logic_parser.mly"
         ( () )
# 4717 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1083 "cil/src/logic/logic_parser.mly"
         ( () )
# 4723 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1084 "cil/src/logic/logic_parser.mly"
      ( () )
# 4729 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1085 "cil/src/logic/logic_parser.mly"
          ( () )
# 4735 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1086 "cil/src/logic/logic_parser.mly"
      ( () )
# 4741 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1087 "cil/src/logic/logic_parser.mly"
     ( () )
# 4747 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1088 "cil/src/logic/logic_parser.mly"
      ( () )
# 4753 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1089 "cil/src/logic/logic_parser.mly"
       ( () )
# 4759 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1090 "cil/src/logic/logic_parser.mly"
        ( () )
# 4765 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1091 "cil/src/logic/logic_parser.mly"
      ( () )
# 4771 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1092 "cil/src/logic/logic_parser.mly"
     ( () )
# 4777 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1093 "cil/src/logic/logic_parser.mly"
         ( () )
# 4783 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1094 "cil/src/logic/logic_parser.mly"
               ( () )
# 4789 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1095 "cil/src/logic/logic_parser.mly"
            ( () )
# 4795 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1096 "cil/src/logic/logic_parser.mly"
        ( () )
# 4801 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1097 "cil/src/logic/logic_parser.mly"
              ( () )
# 4807 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1098 "cil/src/logic/logic_parser.mly"
              ( () )
# 4813 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1099 "cil/src/logic/logic_parser.mly"
        ( () )
# 4819 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1100 "cil/src/logic/logic_parser.mly"
         ( () )
# 4825 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1101 "cil/src/logic/logic_parser.mly"
           ( () )
# 4831 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1102 "cil/src/logic/logic_parser.mly"
        ( () )
# 4837 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1103 "cil/src/logic/logic_parser.mly"
       ( () )
# 4843 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1104 "cil/src/logic/logic_parser.mly"
       ( () )
# 4849 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1105 "cil/src/logic/logic_parser.mly"
      ( () )
# 4855 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1106 "cil/src/logic/logic_parser.mly"
        ( () )
# 4861 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1107 "cil/src/logic/logic_parser.mly"
          ( () )
# 4867 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1108 "cil/src/logic/logic_parser.mly"
          ( () )
# 4873 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1109 "cil/src/logic/logic_parser.mly"
          ( () )
# 4879 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1110 "cil/src/logic/logic_parser.mly"
         ( () )
# 4885 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1111 "cil/src/logic/logic_parser.mly"
            ( () )
# 4891 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1112 "cil/src/logic/logic_parser.mly"
          ( () )
# 4897 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1113 "cil/src/logic/logic_parser.mly"
            ( () )
# 4903 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1114 "cil/src/logic/logic_parser.mly"
      ( () )
# 4909 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1115 "cil/src/logic/logic_parser.mly"
        ( () )
# 4915 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1116 "cil/src/logic/logic_parser.mly"
         ( () )
# 4921 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1117 "cil/src/logic/logic_parser.mly"
            ( () )
# 4927 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1118 "cil/src/logic/logic_parser.mly"
       ( () )
# 4933 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1119 "cil/src/logic/logic_parser.mly"
        ( () )
# 4939 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1120 "cil/src/logic/logic_parser.mly"
           ( () )
# 4945 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1121 "cil/src/logic/logic_parser.mly"
          ( () )
# 4951 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1122 "cil/src/logic/logic_parser.mly"
          ( () )
# 4957 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1123 "cil/src/logic/logic_parser.mly"
       ( () )
# 4963 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1124 "cil/src/logic/logic_parser.mly"
          ( () )
# 4969 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1125 "cil/src/logic/logic_parser.mly"
        ( () )
# 4975 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1126 "cil/src/logic/logic_parser.mly"
         ( () )
# 4981 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1127 "cil/src/logic/logic_parser.mly"
       ( () )
# 4987 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1128 "cil/src/logic/logic_parser.mly"
        ( () )
# 4993 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1129 "cil/src/logic/logic_parser.mly"
        ( () )
# 4999 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1130 "cil/src/logic/logic_parser.mly"
            ( () )
# 5005 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1131 "cil/src/logic/logic_parser.mly"
        ( () )
# 5011 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1132 "cil/src/logic/logic_parser.mly"
        ( () )
# 5017 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1133 "cil/src/logic/logic_parser.mly"
         ( () )
# 5023 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1134 "cil/src/logic/logic_parser.mly"
         ( () )
# 5029 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1135 "cil/src/logic/logic_parser.mly"
        ( () )
# 5035 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1136 "cil/src/logic/logic_parser.mly"
       ( () )
# 5041 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1137 "cil/src/logic/logic_parser.mly"
       ( () )
# 5047 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1138 "cil/src/logic/logic_parser.mly"
         ( () )
# 5053 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1139 "cil/src/logic/logic_parser.mly"
           ( () )
# 5059 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1140 "cil/src/logic/logic_parser.mly"
        ( () )
# 5065 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1141 "cil/src/logic/logic_parser.mly"
       ( () )
# 5071 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1142 "cil/src/logic/logic_parser.mly"
         ( () )
# 5077 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1143 "cil/src/logic/logic_parser.mly"
         ( () )
# 5083 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1144 "cil/src/logic/logic_parser.mly"
       ( () )
# 5089 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1145 "cil/src/logic/logic_parser.mly"
        ( () )
# 5095 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1146 "cil/src/logic/logic_parser.mly"
          ( () )
# 5101 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1147 "cil/src/logic/logic_parser.mly"
        ( () )
# 5107 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1148 "cil/src/logic/logic_parser.mly"
          ( () )
# 5113 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1149 "cil/src/logic/logic_parser.mly"
          ( () )
# 5119 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1150 "cil/src/logic/logic_parser.mly"
       ( () )
# 5125 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1151 "cil/src/logic/logic_parser.mly"
           ( () )
# 5131 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1152 "cil/src/logic/logic_parser.mly"
          ( () )
# 5137 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1153 "cil/src/logic/logic_parser.mly"
      ( () )
# 5143 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1154 "cil/src/logic/logic_parser.mly"
         ( () )
# 5149 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1155 "cil/src/logic/logic_parser.mly"
       ( () )
# 5155 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1156 "cil/src/logic/logic_parser.mly"
        ( () )
# 5161 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1157 "cil/src/logic/logic_parser.mly"
       ( () )
# 5167 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1158 "cil/src/logic/logic_parser.mly"
       ( () )
# 5173 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1159 "cil/src/logic/logic_parser.mly"
         ( () )
# 5179 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1160 "cil/src/logic/logic_parser.mly"
           ( () )
# 5185 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1161 "cil/src/logic/logic_parser.mly"
            ( () )
# 5191 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1162 "cil/src/logic/logic_parser.mly"
           ( () )
# 5197 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1163 "cil/src/logic/logic_parser.mly"
             ( () )
# 5203 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1164 "cil/src/logic/logic_parser.mly"
         ( () )
# 5209 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1165 "cil/src/logic/logic_parser.mly"
         ( () )
# 5215 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1166 "cil/src/logic/logic_parser.mly"
         ( () )
# 5221 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1167 "cil/src/logic/logic_parser.mly"
            ( () )
# 5227 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1168 "cil/src/logic/logic_parser.mly"
        ( () )
# 5233 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1169 "cil/src/logic/logic_parser.mly"
          ( () )
# 5239 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1170 "cil/src/logic/logic_parser.mly"
         ( () )
# 5245 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1171 "cil/src/logic/logic_parser.mly"
            ( () )
# 5251 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
; (fun __caml_parser_env ->
    Obj.repr(
# 1172 "cil/src/logic/logic_parser.mly"
      ( () )
# 5257 "cil/src/logic/logic_parser.ml"
               : 'wildcard))
(* Entry lexpr_eof *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
(* Entry annot *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
(* Entry spec *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
|]
let yytables =
  { Parsing.actions=yyact;
    Parsing.transl_const=yytransl_const;
    Parsing.transl_block=yytransl_block;
    Parsing.lhs=yylhs;
    Parsing.len=yylen;
    Parsing.defred=yydefred;
    Parsing.dgoto=yydgoto;
    Parsing.sindex=yysindex;
    Parsing.rindex=yyrindex;
    Parsing.gindex=yygindex;
    Parsing.tablesize=yytablesize;
    Parsing.table=yytable;
    Parsing.check=yycheck;
    Parsing.error_function=parse_error;
    Parsing.names_const=yynames_const;
    Parsing.names_block=yynames_block }
let lexpr_eof (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 1 lexfun lexbuf : Logic_ptree.lexpr)
let annot (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 2 lexfun lexbuf : Logic_ptree.annot)
let spec (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 3 lexfun lexbuf : Logic_ptree.spec * Cabs.cabsloc)
;;
# 1176 "cil/src/logic/logic_parser.mly"

(*
Local Variables:
compile-command: "make -C ../../.."
End:
*)
# 5297 "cil/src/logic/logic_parser.ml"
