/***************************************************************************
 *   Copyright (c) 2015 Stefan Tröger <stefantroeger@gmx.net>              *
 *                                                                         *
 *   This file is part of the FreeCAD CAx development system.              *
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Library General Public           *
 *   License as published by the Free Software Foundation; either          *
 *   version 2 of the License, or (at your option) any later version.      *
 *                                                                         *
 *   This library  is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU Library General Public License for more details.                  *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this library; see the file COPYING.LIB. If not,    *
 *   write to the Free Software Foundation, Inc., 59 Temple Place,         *
 *   Suite 330, Boston, MA  02111-1307, USA                                *
 *                                                                         *
 ***************************************************************************/


#ifndef PARTGUI_ViewProviderDatumCoordinateSystem_H
#define PARTGUI_ViewProviderDatumCoordinateSystem_H

#include "Gui/ViewProviderGeometryObject.h"
#include "ViewProviderDatum.h"

class SoFont;
class SoTranslation;

namespace PartDesignGui {

class PartDesignGuiExport ViewProviderDatumCoordinateSystem : public PartDesignGui::ViewProviderDatum
{
    PROPERTY_HEADER(PartDesignGui::ViewProviderDatumCoordinateSystem);

public:
    /// Constructor
    ViewProviderDatumCoordinateSystem();
    virtual ~ViewProviderDatumCoordinateSystem();

    virtual void attach ( App::DocumentObject *obj );
    virtual void updateData(const App::Property*);

    virtual void setExtents (Base::BoundBox3d bbox);
private:
    SoCoordinate3 *coord;
    SoTranslation *axisLabelXTrans;
    SoTranslation *axisLabelXToYTrans;
    SoTranslation *axisLabelYToZTrans;
    SoFont* font;
};

} // namespace PartDesignGui


#endif // PARTGUI_ViewProviderDatumCoordinateSystem_H
