/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "fftholder.h"
#include "defs.h"
FFTHolder::FFTHolder()
{
        hirestemp_subband_energies=0;
        hirestemp_nbbands=128;
        hirestemp_fft_width=1024;
        hirestemp_fft_advance=256;
        hirestemp_fftMinima=FLT_MAX;
        hirestemp_fftMaxima=FLT_MIN;
        hirestemp_padding=PAD_ZERO;
        hirestemp_startfreq=100;
        hirestemp_endfreq=22000;
        hirestemp_bark=FALSE;
        hirestemp_bark_sub=10;

        hiresfreq_subband_energies=0;
        hiresfreq_nbbands=512;
        hiresfreq_fft_width=4096;
        hiresfreq_fft_advance=512;
        hiresfreq_fftMinima=FLT_MAX;
        hiresfreq_fftMaxima=FLT_MIN;
        hiresfreq_padding=PAD_ZERO;
        hiresfreq_startfreq=100;
        hiresfreq_endfreq=22000;
        hiresfreq_bark=FALSE;
        hiresfreq_bark_sub=10;
}


FFTHolder::~FFTHolder()
{
}

/*!
    \fn FFTHolder::getHiresFreqFFTAdvance()
 */
int FFTHolder::getHiresFreqFFTAdvance()
{
    return hiresfreq_fft_advance;
}


/*!
    \fn FFTHolder::getHiresTempFFTAdvance()
 */
int FFTHolder::getHiresTempFFTAdvance()
{
    return hirestemp_fft_advance;
}

/*!
    \fn FFTHolder::getFFTMinima()
 */
float FFTHolder::getHiresFreqFFTMinima()
{
    return hiresfreq_fftMinima;
}


/*!
    \fn FFTHolder::getFFTMaxima()
 */
float FFTHolder::getHiresFreqFFTMaxima()
{
    return hiresfreq_fftMaxima;
}


/*!
    \fn FFTHolder::getHiresFreqFFTWidth()
 */
int FFTHolder::getHiresFreqFFTWidth()
{
    return hiresfreq_fft_width;
}


/*!
    \fn FFTHolder::getHiresTempFFTWidth()
 */
int FFTHolder::getHiresTempFFTWidth()
{
    return hirestemp_fft_width;
}

/*!
    \fn FFTHolder::getNbBands()
 */
int FFTHolder::getHiresTempNbBands()
{
    return hirestemp_nbbands;
}

int FFTHolder::getHiresFreqNbBands()
{
    return hiresfreq_nbbands;
}




/*!
    \fn FFTHolder::getHiresFreqStartFreq()
 */
int FFTHolder::getHiresFreqStartFreq()
{
    return hiresfreq_startfreq;
}


/*!
    \fn FFTHolder::getHiresFreqEndFreq()
 */
int FFTHolder::getHiresFreqEndFreq()
{
    return hiresfreq_endfreq;
}


/*!
    \fn FFTHolder::getHiresFreqBark()
 */
bool FFTHolder::getHiresFreqBark()
{
    return hiresfreq_bark;
}


/*!
    \fn FFTHolder::getHiresTempBark()
 */
bool FFTHolder::getHiresTempBark()
{
    return hirestemp_bark;
}


/*!
    \fn FFTHolder::getHiresTempBarkSub()
 */
int FFTHolder::getHiresTempBarkSub()
{
    return hirestemp_bark_sub;
}


/*!
    \fn FFTHolder::getHiresFreqBarkSub()
 */
int FFTHolder::getHiresFreqBarkSub()
{
    return hiresfreq_bark_sub;
}
