/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "monotostereosplitter.h"

MonoToStereoSplitter::MonoToStereoSplitter(QObject *parent, const char *name)
 : CustomEffect(parent, name)
{
        input=0;
        outL=0;
        outR=0;
        beginOutL=0;
        beginOutR=0;
        bufferLength=0;
}


MonoToStereoSplitter::~MonoToStereoSplitter()
{
    if(preOrPost()==CustomEffect::POSITION_POST){
            if (input) zaparr(input);
    }else if(preOrPost()==CustomEffect::POSITION_PRE){
            if (outL) zaparr(outL);
            if (outR) zaparr(outR);
    }
}




/*!
    \fn MonoToStereoSplitter::process(long length)
 */
void MonoToStereoSplitter::process(long length)
{
        memcpy(outL,input,sizeof(float)*length);
        memcpy(outR,input,sizeof(float)*length);
}


/*!
    \fn MonoToStereoSplitter::getInputP()
 */
void MonoToStereoSplitter::init(long _bufferLength)
{
    if(preOrPost()==CustomEffect::POSITION_POST){
        if(!input || _bufferLength>bufferLength){
            bufferLength=_bufferLength;
            if (input) zaparr(input);
            input=new float[bufferLength];
        }
    }else if(preOrPost()==CustomEffect::POSITION_PRE){
        if(!outL || _bufferLength>bufferLength){
            bufferLength=_bufferLength;
            if (outL) zaparr(outL);
            outL=new float[bufferLength];
        }
        if(!outR || _bufferLength>bufferLength){
            bufferLength=_bufferLength;
            if (outR) zaparr(outR);
            outR=new float[bufferLength];
        }
    }
}

/*!
    \fn MonoToStereoSplitter::getInputP()
 */
void MonoToStereoSplitter::setOutputL_P(float* _outL)
{
    beginOutL=outL=_outL;
}

/*!
    \fn MonoToStereoSplitter::getInputP()
 */
void MonoToStereoSplitter::setOutputR_P(float* _outR)
{
    beginOutR=outR=_outR;
}


/*!
    \fn MonoToStereoSplitter::getInput_P()
 */
float* MonoToStereoSplitter::getInput_P()
{
    return input;
}


/*!
    \fn MonoToStereoSplitter::setOutputPosition(long length)
 */
void MonoToStereoSplitter::advancePosition(long length)
{
    if(preOrPost()==CustomEffect::POSITION_POST){
        outL=&outL[length];
        outR=&outR[length];
    }else if(preOrPost()==CustomEffect::POSITION_PRE){
        input=&input[length];
    }
}


/*!
    \fn MonoToStereoSplitter::setOutputPosition(long position)
 */
void MonoToStereoSplitter::setPosition(long position)
{
    if(preOrPost()==CustomEffect::POSITION_POST){
        outL=&beginOutL[position];
        outR=&beginOutR[position];
    }else if(preOrPost()==CustomEffect::POSITION_PRE){
        input=&beginInput[position];
    }
}



/*!
    \fn MonoToStereoSplitter::setInput_P(float*)
 */
void MonoToStereoSplitter::setInput_P(float* _in)
{
    beginInput=input=_in;
}


/*!
    \fn MonoToStereoSplitter::getOutputL_P()
 */
float* MonoToStereoSplitter::getOutputL_P()
{
    return outR;
}


/*!
    \fn MonoToStereoSplitter::getOutputR_P()
 */
float* MonoToStereoSplitter::getOutputR_P()
{
    return outL;
}

QString MonoToStereoSplitter::getName(){
    return "MonoToStereoSplitter";
}
