//
// C++ Interface: portmidimidiinput
//
// Description: 
//
//
// Author: Predrag Viceic <viceic@net2000.ch>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef PORTMIDIMIDIINPUT_H
#define PORTMIDIMIDIINPUT_H

#include <qobject.h>
#include "portmidi.h"
#include "porttime.h"
#include "defs.h"
#include "qstringlist.h"
#include "soundplayer.h"
#include "beatlinedata.h"
#include "midiinputevent.h"
#include "midiinput.h"

/**
@author Predrag Viceic
*/
class PortMidiMidiInput : public MidiInput
{
Q_OBJECT
public:
    PortMidiMidiInput(QObject *parent = 0, const char *name = 0);

    ~PortMidiMidiInput();
    virtual void process();
    virtual void printMessage(int msg);
    
    int openDevice(int id);
    int openDevice(QString device);
    int getDefaultDevice();
    int getSelectedDevice();
    virtual QString getSelectedDeviceString();
    virtual QString getDefaultDeviceString();
    virtual QStringList getDevices();
    virtual void setMidiChannel(int c);

protected:
    PortMidiStream* stream;
    int deviceOpened;
    int serviceInitDone;
    int selectedDevice;
    long midiFilter;
    PmEvent* midiEventBuffer;
};

#endif
