/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "selectionrectangle.h"
#include <qpainter.h>
#include <qfontmetrics.h>
#include <stdlib.h>

SelectionRectangle::SelectionRectangle(QCanvas* canvas)
 : QCanvasRectangle(canvas)
{
        resizing=FALSE;
        leftSideResizing=FALSE;
        moving=FALSE;
        start_sample_position=0;
        end_sample_position=0;
         setZ(-4);
         displayInfo=FALSE;
         drawHandles=TRUE;
         centerRect=new QRect(0,0,0,0);
        leftRect=new QRect(0,0,0,0);
        rightRect=new QRect(0,0,0,0);
        text="";
}
SelectionRectangle::SelectionRectangle(long sample_pos,int x, int y, int width, int height,
                                                                            QCanvas* canvas,bool _displayInfo)
 : QCanvasRectangle(x,y,width,height,canvas)
{
        text="";
        font=QFont();
        font.setPixelSize(12);
        init(sample_pos,x,y,width,height);
        colorClear.setRgb(200,200,200);
        colorDark.setRgb(100,100,100);
        handleColor.setRgb(150,150,150);
        QBrush brush(colorClear,SolidPattern);
        setPen(colorDark);
        setBrush(brush);
        setZ(-4);
        displayInfo=_displayInfo;

        //pict.load(new QBuffer(qembed_findData("nfs_umount.svg")),"svg");
}


SelectionRectangle::~SelectionRectangle()
{
    QCanvasRectangle::hide();  //apparently this is the cause of a potential segfault
}

void SelectionRectangle::drawShape( QPainter &p ){
    if(rect().width()<3) return;
    p.setFont(font);
    QFontMetrics font_metrics(font);
    RasterOp oldROP=p.rasterOp();
    p.setPen(colorDark);
    p.setRasterOp(AndROP);
    p.setBrush(QBrush(colorClear,SolidPattern));
    p.drawRect(rect());
    centerRect->setRect(rect().x()+rect().width()/3,rect().y()+rect().height()/3,
                                            rect().width()/3,rect().height()/3);
    leftRect->setRect(rect().x(),rect().y(),5,rect().height());
    rightRect->setRect(rect().right()-5,rect().y(),
                                        5,rect().height());
    if(drawHandles){
        p.setBrush(QBrush(handleColor,SolidPattern));
        p.drawRoundRect(*centerRect,10,10);
        //p.drawPixmap(*centerRect,QPixmap(qembed_findImage("randr")));
        
        
        /*
        if(centerRect->width()>45){
            p.fillRect(centerRect->x(),centerRect->y(),centerRect->width()/6,centerRect->height(),QBrush(blue));
            p.fillRect(centerRect->x()+centerRect->width()-centerRect->width()/6,
                                        centerRect->y(),centerRect->width()/6,centerRect->height(),QBrush(blue));
        }
        */
        
        //pict.setBoundingRect(*centerRect);
        //p.drawPicture(centerRect->x(),centerRect->y(),pict);
        //p.drawRoundRect(*leftRect,10,10);
        //p.drawRoundRect(*rightRect,10,10);
    }
    computeText();
    if(displayInfo){
        int textWidth=font_metrics.width(text);
        int textHeight=font_metrics.height();
        QRect textRect(rect().x(),rect().bottom(),rect().width(),-textHeight*3-10);
        if(textRect.width()<textWidth){
            textRect.setWidth(textWidth);
        }        
        p.setPen(black);        
        //p.fillRect(textRect,QBrush(blue));
        p.drawText(textRect,AlignCenter | DontClip ,text);
    }
    p.setRasterOp(oldROP);
}

QPointArray  SelectionRectangle::areaPoints() const{
    int width=areaPointsWidth<rect().width()?rect().width():areaPointsWidth;
    QPointArray result(4);
    result.setPoint(0,QPoint((int)(rect().x())-1,-1));
    result.setPoint(1,QPoint((int)(rect().x())+width+1,-1));
    result.setPoint(2,QPoint((int)(rect().x())+width+1,canvas()->height()+1));
    result.setPoint(3,QPoint((int)(rect().x())-1,canvas()->height()+1));
    return result;
}

/*!
    \fn SelectionRectangle::setResizing(bool)
 */
void SelectionRectangle::setResizing(bool _res)
{
    resizing=_res;
}


/*!
    \fn SelectionRectangle::resizing()
 */
bool SelectionRectangle::getResizing()
{
    return resizing;
}


/*!
    \fn SelectionRectangle::getBeatPos()
 */
long SelectionRectangle::getStartSamplePosition()
{
    if(start_sample_position<end_sample_position)
    	return start_sample_position;
   else
	return end_sample_position;
}


/*!
    \fn SelectionRectangle::setEndSamplePosition(long)
 */
void SelectionRectangle::setEndSamplePosition(long esp)
{
    end_sample_position=esp;
    computeText();
}

/*!
    \fn SelectionRectangle::setEndSamplePosition(long)
 */
void SelectionRectangle::setStartSamplePosition(long ssp)
{
    start_sample_position=ssp;
    computeText();
}


/*!
    \fn SelectionRectangle::getEndSamplePosition()
 */
long SelectionRectangle::getEndSamplePosition()
{
    if(start_sample_position<end_sample_position)
    	return end_sample_position;
   else
	return start_sample_position;
}


/*!
    \fn SelectionRectangle::setDisplayInfo(bool)
 */
void SelectionRectangle::setDisplayInfo(bool di)
{
    displayInfo=di;
}


/*!
    \fn SelectionRectangle::setLeftSideResizing(boolean)
 */
void SelectionRectangle::setLeftSideResizing(bool tf)
{
    leftSideResizing=tf;
}


/*!
    \fn SelectionRectangle::getLeftSideResizing()
 */
bool SelectionRectangle::getLeftSideResizing()
{
    return leftSideResizing;
}


/*!
    \fn SelectionRectangle::setMoving(bool)
 */
void SelectionRectangle::setMoving(bool _moving)
{
    moving=_moving;
}


/*!
    \fn SelectionRectangle::getMoving()
 */
bool SelectionRectangle::getMoving()
{
    return moving;
}


/*!
    \fn SelectionRectangle::getSmallRect()
 */
QRect* SelectionRectangle::getCenterRect()
{
    return centerRect;
}


/*!
    \fn SelectionRectangle::setDrawHandles(bool tf)
 */
void SelectionRectangle::setDrawHandles(bool tf)
{
    drawHandles=tf;
}


/*!
    \fn SelectionRectangle::getLeftRect()
 */
QRect* SelectionRectangle::getLeftRect()
{
    return leftRect;
}


/*!
    \fn SelectionRectangle::getRightRect()
 */
QRect* SelectionRectangle::getRightRect()
{
    return rightRect;
}


/*!
    \fn SelectionRectangle::computeText()
 */
void SelectionRectangle::computeText()
{
    QFontMetrics font_metrics(font);
    text=QString("Frames\n%1").arg(abs(end_sample_position-start_sample_position));
    int textWidth=0;
    textWidth=font_metrics.width(text);
    if(rect().width()<textWidth){
        areaPointsWidth=textWidth;
    }else{
        areaPointsWidth=rect().width();
    }
}


/*!
    \fn SelectionRectangle::init(long,int,int,int,int)
 */
void SelectionRectangle::init(long sample_pos,int x,int y,int width,int height)
{
    resizing=FALSE;
    leftSideResizing=FALSE;
    moving=FALSE;
    setStartSamplePosition(sample_pos);
    setEndSamplePosition(sample_pos);
    setSize(0,height);
    QCanvasRectangle::setX(x);
    QCanvasRectangle::setY(y);
    QCanvasRectangle::setSize(width,height);
    centerRect=new QRect(0,0,0,0);
    leftRect=new QRect(0,0,0,0);
    rightRect=new QRect(0,0,0,0);
    drawHandles=TRUE;
    areaPointsWidth=0;
    computeText();
}
