/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef NTOMONOMIXER_H
#define NTOMONOMIXER_H

#include <qobject.h>
#include "defs.h"
#include "customeffect.h"
/**
@author Predrag Viceic
*/
class NtoMonoMixer : public CustomEffect
{
Q_OBJECT
public:
    NtoMonoMixer(int n,QObject *parent = 0, const char *name = 0);

    ~NtoMonoMixer();
    int getNbInputs();
    void process(long length);
    float* getInput_P(int);
    void setOutput_P(float*);
    void setInput_P(int,float*);
    void init(long length);
    void advancePosition(long length);
    void setPosition(long position);
    float* getOutput_P();
    float* addInput();
    float* output;
    float** inputs;
    float** beginInputs;
     QString getName();


protected:
    int nbInputs;
    float* beginOutput;
};

#endif
