//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: BoundaryConditionSet.hpp,v 1.2 2003/05/04 18:09:00 delpinux Exp $

#ifndef BOUNDARYCONDITIONSET_HPP
#define BOUNDARYCONDITIONSET_HPP

#include <vector>
#include <BoundaryCondition.hpp>

/*!
  \class BoundaryConditionSet

  This class is used to describe sets of boundary conditions.

  \author Stphane Del Pino
*/
class BoundaryConditionSet
{
private:
  //! The list of Boundary Conditions.
  std::vector<ReferenceCounting<BoundaryCondition> > __boundaryConditionSet;

public:

  //! Add a boundary condition to the list.
  void addBoundaryCondition(ReferenceCounting<BoundaryCondition> BC)
  {
    __boundaryConditionSet.push_back(BC);
  }


  //! read only access to the number of boundary condition.
  const size_t nbBoundaryCondition() const
  {
    return __boundaryConditionSet.size();
  }

  //! returns the ith boundary condition.
  const BoundaryCondition& operator[] (const size_t i) const
  {
    assert(i<__boundaryConditionSet.size());
    return *(__boundaryConditionSet[i]);
  }

  //! writes the ComponentBoundaryConditions.
  friend std::ostream& operator << (std::ostream& os,
				    const BoundaryConditionSet& bcSet)
  {
    for(size_t i=0; i<bcSet.__boundaryConditionSet.size(); ++i)
      os << *(bcSet.__boundaryConditionSet[i]) << '\n';
    return os;
  }

  //! Copy contructor.
  BoundaryConditionSet(const BoundaryConditionSet& bcSet)
    : __boundaryConditionSet(bcSet.__boundaryConditionSet)
  {
    ;
  }

  //! Default constructor is void.
  BoundaryConditionSet()
  {
    ;
  }

  ~BoundaryConditionSet()
  {
    ;
  }
};

#endif // BOUNDARYCONDITIONSET_HPP

