//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: VariationalOperatorAlphaDxUDxV.hpp,v 1.4 2004/07/11 22:37:06 delpinux Exp $

#ifndef VARIATIONAL_OPERATOR_ALPHA_DX_U_DX_V_HPP
#define VARIATIONAL_OPERATOR_ALPHA_DX_U_DX_V_HPP

#include <VariationalBilinearOperator.hpp>
#include <UserFunction.hpp>
/**
 * @file   VariationalOperatorAlphaDxUDxV.hpp
 * @author Stephane Del Pino
 * @date   Sun Jun 23 18:02:04 2002
 * 
 * @brief  \f$ a(u,v) = \int\alpha\partial_{x_j} u \partial_{x_i} v \f$
 * 
 * 
 */

class VariationalAlphaDxUDxVOperator
  : public VariationalBilinearOperator
{
private:
  ReferenceCounting<UserFunction> __Alpha; /**< \f$\alpha\f$ */

  const size_t __i;		/**< \f$ i \f$ in \f$\partial_{x_i}\f$ */
  const size_t __j;		/**< \f$ j \f$ in \f$\partial_{x_j}\f$ */
public:
  /** 
   * Access to *__Alpha
   * 
   * 
   * @return *__Alpha
   */
  const UserFunction& alpha() const
  {
    return *__Alpha;
  }

  /** 
   * Access to __i
   * 
   * 
   * @return __i
   */
  const size_t i() const
  {
    return __i;
  }

  /** 
   * Access to __j
   * 
   * 
   * @return __j
   */
  const size_t j() const
  {
    return __j;
  }

  /** 
   * Constructor
   * 
   * @param unknownNumber 
   * @param testFunctionNumber 
   * @param alpha 
   * @param i 
   * @param j 
   * 
   */
  VariationalAlphaDxUDxVOperator(const size_t unknownNumber,
				 const size_t testFunctionNumber,
				 ReferenceCounting<UserFunction> alpha,
				 const size_t& i,
				 const size_t& j)
    : VariationalBilinearOperator(VariationalBilinearOperator::alphaDxUDxV,
				  unknownNumber, testFunctionNumber),
      __Alpha(alpha),
      __i(i),
      __j(j)
  {
    ;
  }

  /** 
   * "Multiplies" the operator by a function
   * 
   * @param u the given function
   * 
   * @return the new operator
   */
  ReferenceCounting<VariationalBilinearOperator>
  operator * (ConstReferenceCounting<UserFunction> u) const
  {
    VariationalAlphaDxUDxVOperator* newOperator = new VariationalAlphaDxUDxVOperator(*this);
    (*newOperator).__Alpha = new MulUserFunction(__Alpha, u);
    return newOperator;
  }

  /** 
   * Copy Constructor
   * 
   * @param V 
   * 
   */
  VariationalAlphaDxUDxVOperator(const VariationalAlphaDxUDxVOperator& V)
    : VariationalBilinearOperator(V),
      __Alpha(V.__Alpha),
      __i(V.__i),
      __j(V.__j)
  {
    ;
  }

  /** 
   * 
   * Destructor
   * 
   */
  ~VariationalAlphaDxUDxVOperator()
  {
    ;
  }
};

#endif // VARIATIONAL_OPERATOR_ALPHA_DX_U_DX_V_HPP

