//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: VariationalOperatorMuGradUGradV.hpp,v 1.2 2003/09/21 15:44:53 delpinux Exp $

#ifndef VARIATIONAL_OPERATOR_MU_GRADU_GRADV_HPP
#define VARIATIONAL_OPERATOR_MU_GRADU_GRADV_HPP

#include <VariationalBilinearOperator.hpp>
#include <UserFunction.hpp>
/**
 * @file   VariationalOperatorMuGradUGradV.hpp
 * @class  VariationalMuGradUGradVOperator
 * @author Stephane Del Pino
 * @date   Thu May 30 22:14:40 2002
 * 
 * @brief  \f$ a(u,v) = \int\nabla u\cdot\nabla v\f$
 * 
 * 
 */
class VariationalMuGradUGradVOperator
  : public VariationalBilinearOperator
{
private:
  ReferenceCounting<UserFunction> __mu;	/**< viscosity: \f$\mu\f$  */

public:

  /** 
   * 
   * Access to \f$\mu\f$
   * 
   * @return *__mu
   */
  const UserFunction& mu() const
  {
    return *__mu;
  }

  /** 
   * "Multiplies" the operator by a function
   * 
   * @param u the given function
   * 
   * @return the new operator
   */
  ReferenceCounting<VariationalBilinearOperator>
  operator * (ConstReferenceCounting<UserFunction> u) const
  {
    VariationalMuGradUGradVOperator* newOperator = new VariationalMuGradUGradVOperator(*this);
    (*newOperator).__mu = new MulUserFunction(__mu, u);
    return newOperator;
  }

  /** 
   * Constructor
   * 
   * @param unknownNumber 
   * @param testFunctionNumber 
   * @param mu \f$\mu\f$
   * 
   */
  VariationalMuGradUGradVOperator(const size_t unknownNumber,
				  const size_t testFunctionNumber,
				  ReferenceCounting<UserFunction> mu)
    : VariationalBilinearOperator(VariationalBilinearOperator::muGradUGradV,
				  unknownNumber, testFunctionNumber),
      __mu(mu)
  {
    ;
  }

  /** 
   * Copy constructor
   * 
   * @param V a VariationalMuGradUGradVOperator
   * 
   */
  VariationalMuGradUGradVOperator(const VariationalMuGradUGradVOperator& V)
    : VariationalBilinearOperator(V),
      __mu(V.__mu)
  {
    ;
  }

  /** 
   * Destructor
   * 
   */
  ~VariationalMuGradUGradVOperator()
  {
    ;
  }
};


#endif // VARIATIONAL_OPERATOR_MU_GRADU_GRADV_HPP

