//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: EditorWindow.hpp,v 1.3 2004/12/21 17:18:12 delpinux Exp $

#ifndef EDITOR_WINDOW_HPP
#define EDITOR_WINDOW_HPP

#include <qmainwindow.h>
class QTextEdit;

class EditorWindow
  : public QMainWindow
{
  Q_OBJECT
public:
  EditorWindow();
  ~EditorWindow();

protected:
  void closeEvent(QCloseEvent* event);

private slots:
  void newFile();
  void choose();
  void load( const QString &fileName );
  void save();
  void saveAs();
  void print();

  void run();
  void pause();
  void resume();
  void stop();

  void aboutff3d();
  void aboutQt();
  void aboutVtk();

private:
    QPrinter *printer;
    QTextEdit *e;
    QString filename;
};

#endif // EDITOR_WINDOW_HPP
