//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: GUI.cpp,v 1.10 2005/02/02 21:44:27 delpinux Exp $

#include <StreamCenter.hpp>

#include <GUI.hpp>
#include <qtextedit.h>

#include <qpushbutton.h>
#include <qapplication.h>
#include <qslider.h>
#include <qgrid.h>
#include <qlabel.h>
#include <qvgroupbox.h>
#include <qlayout.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qtabwidget.h>
#include <qfiledialog.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qmainwindow.h>
#include <qstatusbar.h>

#include <QGLvtkWindow.hpp>

#include <vtkRenderer.h>
#include <vtkAxes.h>
#include <vtkPolyDataMapper.h>
#include <vtkLODActor.h>

#include <EditorWindow.hpp>

#include <RunningOptions.hpp>

GUI::GUI(int argc, char* argv[])
  : QApplication(argc, argv, RunningOptions::instance().useGUI())
{
  if (RunningOptions::instance().useGUI()) {
    QMainWindow* mw = new EditorWindow();

//     QMenuBar* menuBar = mw->menuBar();

//     menuBar->setSeparator( QMenuBar::InWindowsStyle );

//     QTabWidget* tabWidget = new QTabWidget(mw,"tabwidget");

//     mw->setCentralWidget(tabWidget);

//     QTextEdit* qTextEdit =  new QTextEdit(tabWidget,0);
//     qTextEdit->setFont(QFont("Courier"));
  
//     tabWidget->addTab(qTextEdit,"Editor");

//     QGrid* box = new QGrid(2,mw,"grid",0);
//     box->layout()->setSpacing( 6 );
//     QVGroupBox*optionsFrame = new QVGroupBox(QString("options"),box,"options");
//     optionsFrame->setMaximumWidth(250);
//     QVBoxLayout* optionsContent = new QVBoxLayout( optionsFrame->layout() );
//     optionsContent->setAlignment( Qt::AlignTop );

//     QVGroupBox*graphicFrame = new QVGroupBox(QString("vtk"),box,"graphics");
//     QVBoxLayout* graphicContent = new QVBoxLayout( graphicFrame->layout() );
//     graphicContent->setAlignment( Qt::AlignTop );

//     QSizePolicy qSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
//     box->setSizePolicy(qSizePolicy);

//     QGLvtkWindow* window = new QGLvtkWindow(graphicFrame,"OpenGL Window");
//     graphicContent->insertWidget(1,window);


//     vtkRenderer *ren1= vtkRenderer::New();
//     ren1->SetBackground( 0.1, 0.2, 0.4 );

//     vtkAxes* axes = vtkAxes::New();
//     axes->SymmetricOn();
//     vtkPolyDataMapper* axesMapper = vtkPolyDataMapper::New();
//     axesMapper->SetInput(axes->GetOutput());
//     vtkLODActor *actor = vtkLODActor::New();
//     actor->SetMapper( axesMapper );
//     ren1->AddActor( actor );

//     window->addRenderer(ren1);
//     window->setSizePolicy(qSizePolicy);

//     tabWidget->addTab(box,"Graphics");

    mw->setGeometry( 0, 0, 800, 600 );
    mw->show();

    mw->statusBar()->message( "Ready", 2000 );

    this->setMainWidget( mw );
    this->exec();
  } else {
    if (RunningOptions::instance().haveDisplay()) {
      fferr(0) << "Warning: falling back to text mode as requested\n";
    } else {
      fferr(0) << "Warning: Cannot open DISPLAY, falling back to text mode\n";
    }
  }
}
