//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stéphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: QGLvtkWindow.cpp,v 1.1 2004/10/24 16:58:05 delpinux Exp $

#include <QGLvtkWindow.hpp>

#include <qcursor.h>

#include <vtkConeSource.h>
#include <vtkPolyDataMapper.h>
#include <vtkRenderWindow.h>
#include <vtkCamera.h>
#include <vtkActor.h>
#include <vtkRenderer.h>
#include <vtkInteractorStyleTrackballCamera.h>

QGLvtkWindow::
QGLvtkWindow( QWidget* parent, const char* name)
  : QGLWidget(parent, name),
    __vtkRenderWindow(vtkXOpenGLRenderWindow::New()),
    __interactor(QGLInteractor::New())
{
  __interactor->SetRenderWindow(__vtkRenderWindow);
  __interactor->HasObserver(vtkCommand::StartEvent);
  __interactor->InvokeEvent(vtkCommand::StartEvent);
  __interactor->Start();

  __vtkRenderWindow->SetDisplayId(qt_xdisplay());
  __vtkRenderWindow->SetWindowId(this->winId());

  vtkInteractorStyleTrackballCamera *style = 
    vtkInteractorStyleTrackballCamera::New();
  __interactor->SetInteractorStyle(style);

  this->setCursor(QCursor(Qt::CrossCursor));
}

QGLvtkWindow::
~QGLvtkWindow()
{
  __vtkRenderWindow->Delete();
  __interactor->Delete();
}
