dnl Checking for Qt libraries (original script picked at http://autoqt.sf.net)
dnl From Jim Meyering

# Check for Qt compiler flags, linker flags, and binary packages
AC_DEFUN([AC_CHECK_QT],
[
AC_REQUIRE([AC_PROG_CXX])
AC_REQUIRE([AC_PATH_X])

# FOUND_QT will be set to false if important componants are missing
FOUND_QT=true

AC_MSG_CHECKING([QTINCLUDE_DIR])
AC_ARG_WITH([qtdir], [  --with-qtinlude=DIR     Qt include directory [default=$QTINCLUDE_DIR]], QTINCLUDE_DIR=$withval)
# Check that QTINCLUDE_DIR is defined or that --with-qtinclude given
if test x"$QTINCLUDE_DIR" = x ; then
    QT_SEARCH="/usr/lib/qt31 /usr/local/qt31 /usr/lib/qt3 /usr/local/qt3 /usr/lib/qt2 /usr/local/qt2 /usr/lib/qt /usr/local/qt"
    for i in $QT_SEARCH; do
        if test -f $i/include/qglobal.h -a x$QTINCLUDE_DIR = x;
	then
	  QTDIR="$i"  # Qt includes found at a non standard location
	  QTINCLUDE_DIR="$i/include"
	fi
    done
fi

# second pass. Now looking for Debian-like 
if test x"$QTINCLUDE_DIR" = x ; then
    if test -f /usr/include/qt3/qglobal.h -a x$QTINCLUDE_DIR = x;
    then
	QTINCLUDE_DIR="/usr/include/qt3"
    fi
fi

if test x"$QTINCLUDE_DIR" = x ; then
    FOUND_QT=false
    AC_MSG_WARN([*** Could not find Qt headers.])
fi
AC_MSG_RESULT([$QTINCLUDE_DIR])

# If some Qt library were found:
if test x"$QTINCLUDE_DIR" != x ; then

  # Change backslashes in QTDIR to forward slashes to prevent escaping
  # problems later on in the build process, mainly for Cygwin build
  # environment using MSVC as the compiler
  # TODO: Use sed instead of perl
  QTINCLUDE_DIR=`echo $QTINCLUDE_DIR | perl -p -e 's/\\\\/\\//g'`

  # Figure out which version of Qt we are using
  AC_MSG_CHECKING([Qt version])
  QT_VER=`grep 'define.*QT_VERSION_STR\W' $QTINCLUDE_DIR/qglobal.h | perl -p -e 's/\D//g'`
  case "${QT_VER}" in
    2*)
        QT_MAJOR="2"
    ;;
    3*)
        QT_MAJOR="3"
    ;;
    *)
	FOUND_QT=false
        AC_MSG_WARN([*** Don't know how to handle this Qt major version])
    ;;
  esac
  AC_MSG_RESULT([$QT_VER ($QT_MAJOR)])

  # Check that moc is in path
  AC_CHECK_PROG(MOC, moc, moc)
  if test x$MOC = x ; then
        FOUND_QT=false
        AC_MSG_WARN([*** moc must be in path])
  fi

  # uic is the Qt user interface compiler
  AC_CHECK_PROG(UIC, uic, uic)
  if test x$UIC = x ; then
          FOUND_QT=false
          AC_MSG_WARN([*** uic must be in path])
  fi

  # qembed is the Qt data embedding utility.
  # It is located in $QTDIR/tools/qembed, and must be compiled and installed
  # manually, we'll let it slide if it isn't present
  AC_CHECK_PROG(QEMBED, qembed, qembed)


  # Calculate Qt include path
  QT_CXXFLAGS="-I$QTINCLUDE_DIR"

  QT_IS_EMBEDDED="no"

  QT_SEARCH="/usr/lib/qt31 /usr/local/qt31 /usr/lib/qt3 /usr/local/qt3 /usr/lib/qt2 /usr/local/qt2 /usr/lib/qt /usr/local/qt /usr"

  # On unix, figure out if we're doing a static or dynamic link
  case "${host}" in
    *-cygwin)
        for i in $QT_SEARCH; do
	    if test x$QT_LIB = x; then
	        AC_DEFINE_UNQUOTED(WIN32, "", Defined if on Win32 platform)
                if test -f "$i/lib/qt.lib" ; then
                    QT_LIB="qt.lib"
                    QT_IS_STATIC="yes"
                    QT_IS_MT="no"
		    QTLIB_DIR="$i/lib"
                elif test -f "$i/lib/qt-mt.lib" ; then
                    QT_LIB="qt-mt.lib" 
                    QT_IS_STATIC="yes"
                    QT_IS_MT="yes"
		    QTLIB_DIR="$i/lib"
                elif test -f "$i/lib/qt$QT_VER.lib" ; then
                    QT_LIB="qt$QT_VER.lib"
                    QT_IS_STATIC="no"
                    QT_IS_MT="no"
		    QTLIB_DIR="$i/lib"
                elif test -f "$i/lib/qt-mt$QT_VER.lib" ; then
                    QT_LIB="qt-mt$QT_VER.lib"
                    QT_IS_STATIC="no"
                    QT_IS_MT="yes"
		    QTLIB_DIR="$i/lib"
                fi
	    fi
	done
        ;;

    *)
        for i in $QT_SEARCH; do
	    if test x$QT_LIB = x; then
                QT_IS_STATIC=`ls $i/lib/*.a 2> /dev/null`
                if test "x$QT_IS_STATIC" = x; then
                    QT_IS_STATIC="no"
                else
                    QT_IS_STATIC="yes"
                fi

	        if test "x`ls $i/lib/libqt-mt.* 2> /dev/null`" != x ; then
                    QT_LIB="-lqt-mt"
                    QT_IS_MT="yes"
		    QTLIB_DIR="$i/lib"
                elif test "x`ls $i/lib/libqt.* 2> /dev/null`" != x ; then
                    QT_LIB="-lqt"
                    QT_IS_MT="no"
		    QTLIB_DIR="$i/lib"
                elif test "x`ls $i/lib/libqte.* 2> /dev/null`" != x ; then
                    QT_LIB="-lqte"
                    QT_IS_MT="no"
                    QT_IS_EMBEDDED="yes"
		    QTLIB_DIR="$i/lib"
                elif test "x`ls $i/lib/libqte-mt.* 2> /dev/null`" != x ; then
                    QT_LIB="-lqte-mt"
                    QT_IS_MT="yes"
                    QT_IS_EMBEDDED="yes"
		    QTLIB_DIR="$i/lib"
                fi
            fi
        done
        if test x$QT_LIB = x ; then
	  FOUND_QT=false
        fi
        ;;
  esac
  AC_MSG_CHECKING([if Qt is static])
  AC_MSG_RESULT([$QT_IS_STATIC])
  AC_MSG_CHECKING([if Qt is multithreaded])
  AC_MSG_RESULT([$QT_IS_MT])
  AC_MSG_CHECKING([if Qt is embedded])
  AC_MSG_RESULT([$QT_IS_EMBEDDED])

  QT_GUILINK=""
  QASSISTANTCLIENT_LDADD="-lqassistantclient"
  case "${host}" in
    *irix*)
        QT_LIBS="$QT_LIB"
        if test $QT_IS_STATIC = yes ; then
            QT_LIBS="$QT_LIBS -L$x_libraries -lXext -lX11 -lm -lSM -lICE"
        fi
        ;;

    *linux*)
        QT_LIBS="$QT_LIB"
        if test $QT_IS_STATIC = yes && test $QT_IS_EMBEDDED = no; then
            QT_LIBS="$QT_LIBS -L$x_libraries -lXext -lX11 -lm -lSM -lICE -ldl -ljpeg"
        fi
        ;;


    *osf*) 
        # Digital Unix (aka DGUX aka Tru64)
        QT_LIBS="$QT_LIB"
        if test $QT_IS_STATIC = yes ; then
            QT_LIBS="$QT_LIBS -L$x_libraries -lXext -lX11 -lm -lSM -lICE"
        fi
        ;;

    *solaris*)
        QT_LIBS="$QT_LIB"
        if test $QT_IS_STATIC = yes ; then
            QT_LIBS="$QT_LIBS -L$x_libraries -lXext -lX11 -lm -lSM -lICE -lresolv -lsocket -lnsl"
        fi
        ;;


    *win*)
        # linker flag to suppress console when linking a GUI app on Win32
        QT_GUILINK="/subsystem:windows"

	if test $QT_MAJOR = "3" ; then
	    if test $QT_IS_MT = yes ; then
        	QT_LIBS="/nodefaultlib:libcmt"
            else
            	QT_LIBS="/nodefaultlib:libc"
            fi
        fi

        if test $QT_IS_STATIC = yes ; then
            QT_LIBS="$QT_LIBS $QT_LIB kernel32.lib user32.lib gdi32.lib comdlg32.lib ole32.lib shell32.lib imm32.lib advapi32.lib wsock32.lib winspool.lib winmm.lib netapi32.lib"
            if test $QT_MAJOR = "3" ; then
                QT_LIBS="$QT_LIBS qtmain.lib"
            fi
        else
            QT_LIBS="$QT_LIBS $QT_LIB"        
            if test $QT_MAJOR = "3" ; then
                QT_CXXFLAGS="$QT_CXXFLAGS -DQT_DLL"
                QT_LIBS="$QT_LIBS qtmain.lib qui.lib user32.lib netapi32.lib"
            fi
        fi
        QASSISTANTCLIENT_LDADD="qassistantclient.lib"
        ;;

  esac


  if test x"$QT_IS_EMBEDDED" = "xyes" ; then
        QT_CXXFLAGS="-DQWS $QT_CXXFLAGS"
  fi

  if test x"$QT_IS_MT" = "xyes" ; then
        QT_CXXFLAGS="$QT_CXXFLAGS -D_REENTRANT -DQT_THREAD_SUPPORT"
  fi

  QT_LDADD="-L$QTLIB_DIR $QT_LIBS"

  AC_MSG_CHECKING([QT_CXXFLAGS])
  AC_MSG_RESULT([$QT_CXXFLAGS])
  AC_MSG_CHECKING([QT_LDADD])
  AC_MSG_RESULT([$QT_LDADD])

  AC_SUBST(QT_CXXFLAGS)
  AC_SUBST(QT_LDADD)
  AC_SUBST(QT_GUILINK)
  AC_SUBST(QASSISTANTCLIENT_LDADD)

fi
])
