//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: SolverDriver.cpp,v 1.4 2004/12/31 16:38:58 delpinux Exp $


#include <SolverDriver.hpp>

#include <PenalizedFictitousDomain.hpp>
#include <EliminatedFictitiousDomain.hpp>
#include <FiniteElementMethod.hpp>

#include <FatBoundary.hpp>

#include <PDESolution.hpp>
#include <PDESolver.hpp>

void SolverDriver::run()
{
  ffout(2) << "Problem: \n";

  PDESolution& u = static_cast<PDESolution&>(__u);
  ffout(2) << "PDE\n";

  ReferenceCounting<Method> M = NULL;

  switch (__methodClass) {
  case SolverDriver::fictitiousDomainMethod: {
    ffout(2) << "Using fictitious domain discretization:\n";
    ffout(2) << "Method:  ";
    switch (__methodType) {
    case (SolverDriverOptions::penalty): {
      M = new PenalizedFictitousDomain(__mesh,
				     __degreeOfFreedomSet);
      ffout(2) << "Penalty\n";
      break;
    }
    case (SolverDriverOptions::eliminate): {
      M = new EliminatedFictitiousDomain(__mesh,
					 __degreeOfFreedomSet);
      ffout(2) << "Elimination\n";
      break;
    }
    case (SolverDriverOptions::fatBoundary): {
      M = new FatBoundary(__mesh);
      break;
    }
    }
    break;
  }
  case SolverDriver::standardFEM: {
    M = new FiniteElementMethod(__mesh,
				__degreeOfFreedomSet);
    break;
  }
  default: {
    throw ErrorHandler(__FILE__,__LINE__,
		       "unexpected method class",
		       ErrorHandler::unexpected);
  }
  }

  PDESolver S (__p, M, u);

  ffout(2) << "Solving ...\n";
  S.Solve();
}

