//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: VariationalOperatorFdxGV.hpp,v 1.4 2004/07/11 14:11:14 delpinux Exp $

#ifndef VARIATIONAL_OPERATOR_F_DX_G_V_HPP
#define VARIATIONAL_OPERATOR_F_DX_G_V_HPP

#include <VariationalLinearOperator.hpp>
#include <UserFunction.hpp>

class VariationalOperatorFdxGV
  : public VariationalLinearOperator
{
private:
  ReferenceCounting<UserFunction> __f; /**< the \f$ f\f$ function */
  ReferenceCounting<UserFunction> __g; /**< the \f$ g\f$ function */
  const size_t __i;	/**< The \f$ i \f$ in \f$\partial_{x_i}\f$  */
public:
  /** 
   * 
   * Access to \f$ f\f$
   * 
   * @return *__f
   */
  const UserFunction& f() const
  {
    return *__f;
  }

  /** 
   * 
   * Access to \f$ g\f$
   * 
   * @return *__g
   */
  const UserFunction& g() const
  {
    return *__g;
  }

  const size_t& number() const
  {
    return __i;
  }

  /** 
   * "Multiplies" the operator by a function
   * 
   * @param u the given function
   * 
   * @return the new operator
   */
  ReferenceCounting<VariationalLinearOperator>
  operator * (ConstReferenceCounting<UserFunction> u) const
  {
    VariationalOperatorFdxGV* newOperator = new VariationalOperatorFdxGV(*this);
    (*newOperator).__f = new MulUserFunction(__f, u);
    return newOperator;
  }

  /** 
   * Constructor
   * 
   * @param testFunctionNumber the test function number
   * @param f the given \f$ f \f$ function
   * @param g the given \f$ g \f$ function
   * @param i the index in \f$ \int f \partial_{x_i} g \f$
   * 
   */
  VariationalOperatorFdxGV(const size_t testFunctionNumber,
			   ReferenceCounting<UserFunction> f,
			   ReferenceCounting<UserFunction> g,
			   const size_t i)
    : VariationalLinearOperator(VariationalLinearOperator::FdxGV,
				testFunctionNumber),
      __f(f),
      __g(g),
      __i(i)
  {
    ;
  }

  /** 
   * Copy constructor
   * 
   * @param V another VariationalOperatorFdxGV
   * 
   */
  VariationalOperatorFdxGV(const VariationalOperatorFdxGV& V)
    : VariationalLinearOperator(V),
      __f(V.__f),
      __g(V.__g),
      __i(V.__i)
  {
    ;
  }

  /** 
   * Destructor
   * 
   * 
   */
  ~VariationalOperatorFdxGV()
  {
    ;
  }
};

#endif // VARIATIONAL_OPERATOR_F_DX_G_V_HPP

